/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.pack.core.download;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.StringUtil;
import com.pandora.core.auth.UserAuthService;
import com.pandora.core.httpclient.HttpClientUtils;
import com.pandora.core.httpclient.ResponseObj;
import com.pandora.core.proxy.Proxy;
import com.pandora.core.utils.RegistryUtils;
import com.pandora.core.utils.ResourceUtil;
import com.pandora.pack.core.PackActivator;
import com.pandora.pack.core.download.DownloadData;
import com.pandora.pack.core.download.DownloadDataManager;
import com.pandora.pack.core.download.DownloadNotify;
import com.pandora.pack.core.download.Messages;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import java.util.List;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.DefaultHttpClient;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ui.IStartup;

public class StartupDownloadPackage
implements IStartup {
    private static final int INTERVAL = 120;
    private static final int QUICK_INTERVAL = 30;
    private List<DownloadNotify> downloadNotifys;
    private static Object locker = new Object();
    private static Thread downloadThread;
    private static boolean quickPolling;

    public static boolean isQuickPolling() {
        return quickPolling;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setQuickPolling(boolean quickPolling) {
        try {
            if (StartupDownloadPackage.quickPolling == quickPolling) {
                return;
            }
            IdeLog.logError((Plugin)PackActivator.getDefault(), (String)("\u8bbe\u7f6e\u4e0b\u8f7d\u5feb\u901f\u8f6e\u8be2 : " + quickPolling));
            Object object = locker;
            synchronized (object) {
                StartupDownloadPackage.quickPolling = quickPolling;
                if (quickPolling) {
                    locker.notifyAll();
                }
            }
        }
        catch (Throwable e) {
            IdeLog.logError((Plugin)PackActivator.getDefault(), (Throwable)e);
        }
    }

    public void earlyStartup() {
        try {
            this.downloadNotifys = RegistryUtils.getEp(DownloadNotify.class, (String)"com.pandora.pack.core.downloadnotify", (String)"receive", (String)"class");
        }
        catch (CoreException e) {
            IdeLog.logError((Plugin)PackActivator.getDefault(), (Throwable)e);
        }
        Job downloadJob = new Job("download package job"){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            protected IStatus run(IProgressMonitor monitor) {
                try {
                    String[] dirNames;
                    IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                    String instill = FileLocator.toFileURL((URL)Platform.getInstallLocation().getURL()).getFile();
                    String[] stringArray = dirNames = new String[]{"download", "project_resource/download"};
                    int n = dirNames.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String dirName = stringArray[n2];
                        File dir = new File(instill, dirName);
                        File[] srcDirs = dir.listFiles(new FileFilter(){

                            @Override
                            public boolean accept(File pathname) {
                                return pathname.isDirectory();
                            }
                        });
                        if (srcDirs != null && srcDirs.length > 0) {
                            File[] fileArray = srcDirs;
                            int n3 = srcDirs.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                File srcDir = fileArray[n4];
                                try {
                                    IProject project;
                                    if (srcDir.list().length > 0 && (project = root.getProject(srcDir.getName())) != null && project.exists() && project.hasNature("com.pandora.projects.ui.MKeyNature")) {
                                        IFolder folder = project.getFolder("unpackage").getFolder("release");
                                        if (!folder.exists()) {
                                            FileUtils.moveDirectory((File)srcDir, (File)folder.getLocation().toFile());
                                        }
                                        folder.refreshLocal(0, monitor);
                                    }
                                }
                                catch (Throwable e) {
                                    IdeLog.logError((Plugin)PackActivator.getDefault(), (Throwable)e);
                                }
                                ++n4;
                            }
                        }
                        ++n2;
                    }
                }
                catch (Throwable ex) {
                    IdeLog.logError((Plugin)PackActivator.getDefault(), (Throwable)ex);
                }
                IdeLog.logTrace((Plugin)PackActivator.getDefault(), (String)Messages.StartupDownloadPackage_InstallationPackageJobStart);
                while (!Thread.currentThread().isInterrupted()) {
                    try {
                        block51: {
                            DownloadData data;
                            block50: {
                                data = DownloadDataManager.getInstance().takeDataFromQueue();
                                if (data == null) continue;
                                try {
                                    if (!UserAuthService.checkHasLogined((boolean)false)) {
                                        DownloadDataManager.getInstance().put(data);
                                        StartupDownloadPackage.interval();
                                    }
                                    break block50;
                                }
                                catch (Exception ex) {
                                    IdeLog.logError((Plugin)PackActivator.getDefault(), (Throwable)ex);
                                    DownloadDataManager.getInstance().put(data);
                                    StartupDownloadPackage.interval();
                                }
                                continue;
                            }
                            ResponseObj responseObj = null;
                            try {
                                HttpClientUtils httpClientUtils = HttpClientUtils.getInstance((String)"ProjectAction!downloadPackage");
                                httpClientUtils.addRequestBody("ticket", data.getId());
                                responseObj = httpClientUtils.excute();
                                if (!"1001".equals(responseObj.getRspcode())) {
                                    StartupDownloadPackage.this.downNotify(null, data.getProjectName(), null);
                                    if ("999".equals(responseObj.getRspcode())) {
                                        IdeLog.logTrace((Plugin)PackActivator.getDefault(), (String)MessageFormat.format(Messages.StartupDownloadPackage_DownloadFail1, data.getId(), responseObj.getRspdesc(), 120));
                                    } else {
                                        IdeLog.logTrace((Plugin)PackActivator.getDefault(), (String)MessageFormat.format(Messages.StartupDownloadPackage_DownloadFail2, data.getId(), responseObj.getRspdesc(), 120));
                                    }
                                    DownloadDataManager.getInstance().put(data);
                                    break block51;
                                }
                                String status = responseObj.getValueByKey("status");
                                StartupDownloadPackage.this.downNotify(status, data.getProjectName(), null);
                                if ("OK".equals(status)) {
                                    File f;
                                    boolean result;
                                    block54: {
                                        IdeLog.logTrace((Plugin)PackActivator.getDefault(), (String)MessageFormat.format(Messages.StartupDownloadPackage_DownloadFail3, data.getId()));
                                        result = false;
                                        String url = responseObj.getValueByKey("url");
                                        f = null;
                                        byte[] buf = new byte[10240];
                                        int size = 0;
                                        RandomAccessFile rndFile = null;
                                        BufferedInputStream bis = null;
                                        DefaultHttpClient httpclient = new DefaultHttpClient();
                                        try {
                                            try {
                                                HttpResponse http = StartupDownloadPackage.this.getHttpResponse(httpclient, (HttpUriRequest)new HttpHead(url));
                                                String fileName = HttpClientUtils.getHttpUrlFileName((HttpResponse)http, (String)url);
                                                IFolder download = ResourceUtil.getAppProjectUnPackageDir((IProject)ResourcesPlugin.getWorkspace().getRoot().getProject(data.getProjectName()), (String)"release", (String[])new String[0]);
                                                File temp = new File(download.getLocation().toString(), String.valueOf(fileName) + ".tmp");
                                                IdeLog.logTrace((Plugin)PackActivator.getDefault(), (String)MessageFormat.format(Messages.StartupDownloadPackage_SaveInstallation, String.valueOf(data.getId()) + ":" + url, temp));
                                                long remoteFileSize = Long.parseLong(http.getFirstHeader("Content-length").getValue());
                                                long nPos = 0L;
                                                if (temp.exists()) {
                                                    long localFileSzie = temp.length();
                                                    if (localFileSzie < remoteFileSize) {
                                                        IdeLog.logTrace((Plugin)PackActivator.getDefault(), (String)(String.valueOf(localFileSzie) + " < " + remoteFileSize + ", \u5f00\u59cb\u6587\u4ef6\u7eed\u4f20..."));
                                                        nPos = localFileSzie;
                                                    } else {
                                                        IdeLog.logTrace((Plugin)PackActivator.getDefault(), (String)"\u6587\u4ef6\u5b58\u5728\uff0c\u5f00\u59cb\u91cd\u65b0\u4e0b\u8f7d...");
                                                        temp.delete();
                                                        try {
                                                            temp.createNewFile();
                                                        }
                                                        catch (Exception e) {
                                                            IdeLog.logError((Plugin)PackActivator.getDefault(), (Throwable)e);
                                                        }
                                                    }
                                                } else {
                                                    IdeLog.logTrace((Plugin)PackActivator.getDefault(), (String)"\u6587\u4ef6\u4e0d\u5b58\u5728\uff0c\u521b\u5efa\u65b0\u6587\u4ef6");
                                                    try {
                                                        temp.getParentFile().mkdirs();
                                                        temp.createNewFile();
                                                    }
                                                    catch (Exception e) {
                                                        IdeLog.logError((Plugin)PackActivator.getDefault(), (Throwable)e);
                                                    }
                                                }
                                                try {
                                                    httpclient.getConnectionManager().shutdown();
                                                }
                                                catch (Exception e) {
                                                    IdeLog.logError((Plugin)PackActivator.getDefault(), (Throwable)e);
                                                }
                                                Thread.sleep(3000L);
                                                httpclient = new DefaultHttpClient();
                                                HttpGet get = new HttpGet(url);
                                                get.addHeader("Range", "bytes=" + nPos + "-");
                                                http = StartupDownloadPackage.this.getHttpResponse(httpclient, (HttpUriRequest)get);
                                                bis = new BufferedInputStream(http.getEntity().getContent());
                                                rndFile = new RandomAccessFile(temp, "rw");
                                                rndFile.seek(nPos);
                                                while (true) {
                                                    if ((size = bis.read(buf)) == -1) {
                                                        IOUtils.closeQuietly((Closeable)rndFile);
                                                        IdeLog.logTrace((Plugin)PackActivator.getDefault(), (String)("\u65ad\u70b9\u4e0b\u8f7d\u6587\u4ef6\u5927\u5c0f\u4e3a: " + size));
                                                        f = new File(download.getLocation().toString(), fileName);
                                                        if (f.exists()) {
                                                            f.delete();
                                                        }
                                                        temp.renameTo(f);
                                                        IdeLog.logTrace((Plugin)PackActivator.getDefault(), (String)MessageFormat.format(Messages.StartupDownloadPackage_SaveComplete, data.getId(), f));
                                                        result = true;
                                                        break;
                                                    }
                                                    rndFile.write(buf, 0, size);
                                                }
                                            }
                                            catch (Exception e) {
                                                IdeLog.logError((Plugin)PackActivator.getDefault(), (Throwable)e);
                                                IOUtils.closeQuietly(bis);
                                                IOUtils.closeQuietly(rndFile);
                                                if (httpclient != null) {
                                                    try {
                                                        httpclient.getConnectionManager().shutdown();
                                                    }
                                                    catch (Exception e2) {
                                                        IdeLog.logError((Plugin)PackActivator.getDefault(), (Throwable)e2);
                                                    }
                                                }
                                                break block54;
                                            }
                                        }
                                        catch (Throwable throwable) {
                                            IOUtils.closeQuietly(bis);
                                            IOUtils.closeQuietly(rndFile);
                                            if (httpclient == null) throw throwable;
                                            try {
                                                httpclient.getConnectionManager().shutdown();
                                                throw throwable;
                                            }
                                            catch (Exception e) {
                                                IdeLog.logError((Plugin)PackActivator.getDefault(), (Throwable)e);
                                            }
                                            throw throwable;
                                        }
                                        IOUtils.closeQuietly((InputStream)bis);
                                        IOUtils.closeQuietly((Closeable)rndFile);
                                        if (httpclient != null) {
                                            try {
                                                httpclient.getConnectionManager().shutdown();
                                            }
                                            catch (Exception e) {
                                                IdeLog.logError((Plugin)PackActivator.getDefault(), (Throwable)e);
                                            }
                                        }
                                    }
                                    if (!result) {
                                        FileUtils.deleteQuietly(f);
                                        IdeLog.logTrace((Plugin)PackActivator.getDefault(), (String)MessageFormat.format(Messages.StartupDownloadPackage_MakeInstallationPackage1, data.getId(), responseObj.getRspdesc(), 120));
                                        DownloadDataManager.getInstance().put(data);
                                        break block51;
                                    } else {
                                        DownloadDataManager.getInstance().setDataDownloaded(data);
                                        StartupDownloadPackage.this.downNotify("DOWNLOADED", data.getProjectName(), f.getName());
                                        continue;
                                    }
                                }
                                if ("FAILED".equals(status)) {
                                    IdeLog.logTrace((Plugin)PackActivator.getDefault(), (String)MessageFormat.format(Messages.StartupDownloadPackage_MakeInstallationPackage2, data.getId(), responseObj.getValueByKey("signDesc")));
                                    DownloadDataManager.getInstance().removeDownloadData(data);
                                } else {
                                    IdeLog.logTrace((Plugin)PackActivator.getDefault(), (String)MessageFormat.format(Messages.StartupDownloadPackage_MakeInstallationPackage3, data.getId(), 120));
                                    DownloadDataManager.getInstance().put(data);
                                }
                            }
                            catch (Exception e) {
                                StartupDownloadPackage.this.downNotify(null, data.getProjectName(), null);
                                IdeLog.logTrace((Plugin)PackActivator.getDefault(), (String)MessageFormat.format(Messages.StartupDownloadPackage_DownloadFail, data.getId(), e.getMessage(), 120));
                                DownloadDataManager.getInstance().put(data);
                            }
                        }
                        StartupDownloadPackage.interval();
                    }
                    catch (InterruptedException interruptedException) {
                        return Status.CANCEL_STATUS;
                    }
                }
                return Status.CANCEL_STATUS;
            }
        };
        downloadThread = new Thread("download package thread");
        downloadJob.setSystem(true);
        downloadJob.schedule();
    }

    public static void interruptDownloadThread() {
        if (downloadThread != null) {
            downloadThread.interrupt();
        }
    }

    private void setProxy(DefaultHttpClient httpclient) {
        if (Proxy.isEnable()) {
            if (StringUtil.isNotBlank((String)Proxy.getUsername())) {
                BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
                UsernamePasswordCredentials creds = new UsernamePasswordCredentials(Proxy.getUsername(), Proxy.getPassword());
                credsProvider.setCredentials(new AuthScope(AuthScope.ANY_HOST, -1), (Credentials)creds);
                httpclient.setCredentialsProvider((CredentialsProvider)credsProvider);
            }
            HttpHost proxy = new HttpHost(Proxy.getUrl(), Integer.parseInt(Proxy.getPort()), Proxy.getType());
            httpclient.getParams().setParameter("http.route.default-proxy", (Object)proxy);
        }
    }

    private HttpResponse getHttpResponse(DefaultHttpClient httpclient, HttpUriRequest url) throws KeyManagementException, NoSuchAlgorithmException, ClientProtocolException, IOException {
        X509TrustManager tm = new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] xcs, String string) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] xcs, String string) throws CertificateException {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }
        };
        SSLContext ctx = SSLContext.getInstance("TLS");
        ctx.init(null, new TrustManager[]{tm}, null);
        SSLSocketFactory ssf = new SSLSocketFactory(ctx);
        ssf.setHostnameVerifier(SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
        ClientConnectionManager ccm = httpclient.getConnectionManager();
        SchemeRegistry sr = ccm.getSchemeRegistry();
        sr.register(new Scheme("https", (SocketFactory)ssf, 443));
        this.setProxy(httpclient);
        return httpclient.execute(url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void interval() throws InterruptedException {
        Object object = locker;
        synchronized (object) {
            if (quickPolling) {
                locker.wait(30000L);
            } else {
                locker.wait(120000L);
            }
        }
    }

    private void downNotify(String packageStatus, String projectName, String packageFileName) {
        if (this.downloadNotifys != null) {
            for (DownloadNotify notify : this.downloadNotifys) {
                try {
                    if (Platform.inDebugMode()) {
                        System.out.println("\u901a\u77e5\u5237\u65b0\u6253\u5305\u72b6\u6001:  " + packageStatus);
                    }
                    notify.notify(packageStatus, projectName, packageFileName);
                }
                catch (Exception e) {
                    IdeLog.logError((Plugin)PackActivator.getDefault(), (Throwable)e);
                }
            }
        }
    }
}

