/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.pack.core;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.StringUtil;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.pandora.core.exception.ConvertProjectException;
import com.pandora.core.httpclient.HttpClientUtils;
import com.pandora.core.httpclient.IFileUpdateProgress;
import com.pandora.core.httpclient.ResponseObj;
import com.pandora.core.mobile.model.ManifastConfiguration;
import com.pandora.core.mobile.model.android.AndroidIcon;
import com.pandora.core.mobile.model.android.AndroidSplashScreen;
import com.pandora.core.mobile.model.android.GoogleProfile;
import com.pandora.core.mobile.model.ios.AppleProfile;
import com.pandora.core.mobile.model.ios.IOSIcon;
import com.pandora.core.mobile.model.ios.IPadIcon;
import com.pandora.core.mobile.model.ios.IPadSplashScreen;
import com.pandora.core.mobile.model.ios.IPhoneIcon;
import com.pandora.core.mobile.model.ios.IPhoneSplashScreen;
import com.pandora.core.mobile.verification.ManifastConfigurationVerification;
import com.pandora.core.project.HMobileProject;
import com.pandora.core.stats.Stats;
import com.pandora.core.utils.ProductUtils;
import com.pandora.core.utils.ProjectUtils;
import com.pandora.core.utils.ResourceUtil;
import com.pandora.core.utils.ZipUtils;
import com.pandora.pack.core.Messages;
import com.pandora.pack.core.PackActivator;
import com.pandora.pack.core.PackPlatform;
import com.pandora.pack.core.download.DownloadDataManager;
import com.pandora.pack.core.utils.PrimaryConfusionUtils;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.wink.json4j.JSONObject;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class MakePackage {
    protected static final String MANIFAST_DIR_NAME = ".manifest";
    protected static final String chineseRegEx = "[\u4e00-\u9fa5]";
    protected static final Pattern chinesePattern = Pattern.compile("[\u4e00-\u9fa5]");
    protected HMobileProject project;
    protected List<PackPlatform> phoneModules;
    protected String appid;
    protected ManifastConfiguration appConfig;

    public MakePackage(IProject project, ManifastConfiguration appConfig, List<PackPlatform> phoneModules) throws CoreException {
        this.phoneModules = phoneModules;
        if (project == null) {
            throw new CoreException((IStatus)new Status(4, "com.pandora.pack.core", MessageFormat.format(Messages.MakePackage_No_Project, "")));
        }
        try {
            this.project = ProjectUtils.convertToHMobile((IProject)project);
        }
        catch (ConvertProjectException e) {
            e.printStackTrace();
        }
        Gson gson = new GsonBuilder().disableHtmlEscaping().create();
        String configJson = gson.toJson((Object)appConfig);
        this.appConfig = (ManifastConfiguration)gson.fromJson(configJson, ManifastConfiguration.class);
        this.appid = appConfig.getAppid();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean makePackage(Runnable cannotCancelNotify, boolean needConfusion, IProgressMonitor monitor) throws CoreException, IOException {
        PackPlatform[] ps;
        ResponseObj responseObj;
        Job stopJob;
        block27: {
            File zip;
            block29: {
                block28: {
                    IdeLog.logTrace((Plugin)PackActivator.getDefault(), (String)MessageFormat.format("\u5f00\u59cb\u6253\u5305\u9879\u76ee{0}", this.project));
                    monitor.subTask("\u538b\u7f29\u76f8\u5173\u8d44\u6e90");
                    for (PackPlatform packPlatform : this.phoneModules) {
                        if (packPlatform.equals((Object)PackPlatform.IOS_ADHOC) || packPlatform.equals((Object)PackPlatform.IOS_APPSTORE) || packPlatform.equals((Object)PackPlatform.IOS_PB)) {
                            Stats.addOperateInfo((String)"menu", (String)"TMIPI", null);
                            continue;
                        }
                        if (!packPlatform.equals((Object)PackPlatform.ANDROID_GOOGLEPLAY) && !packPlatform.equals((Object)PackPlatform.ANDROID_PB)) continue;
                        Stats.addOperateInfo((String)"menu", (String)"TMIPA", null);
                    }
                    zip = null;
                    stopJob = null;
                    if (monitor.isCanceled()) break block28;
                    zip = this.zipPackage(needConfusion);
                    if (!monitor.isCanceled()) break block29;
                }
                if (stopJob == null) return false;
                try {
                    stopJob.cancel();
                    return false;
                }
                catch (Throwable throwable) {}
                return false;
            }
            if (zip.length() > 0x2800000L) {
                throw new CoreException((IStatus)new Status(4, "com.pandora.pack.core", "App\u5305\u5927\u5c0f\u4e0d\u53ef\u8d85\u8fc740M\uff0c\u5982\u9700\u6253\u8d85\u8fc740M\u7684App\u5305\uff0c\u8bf7\u4f7f\u7528\u672c\u5730\u6253\u5305\uff01"));
            }
            monitor.worked(10);
            monitor.subTask("\u5411\u4e91\u7aef\u53d1\u9001\u6253\u5305\u8bf7\u6c42");
            HttpClientUtils httpClientUtils = HttpClientUtils.getInstance((String)"ProjectAction!generateAppPackage");
            HashMap<String, Object> request = new HashMap<String, Object>();
            List<String> platform = PackPlatform.toStrings(this.phoneModules);
            request.put("platform", platform);
            request.put("appid", this.appid);
            request.put("appname", this.project.getProject().getName());
            if (ProductUtils.isAlpha()) {
                request.put("alpha", true);
            }
            httpClientUtils.addRequestBody(request);
            final long[] uploadProgress = new long[2];
            httpClientUtils.addFileBody("attachment", zip, new IFileUpdateProgress(){

                public void update(long contentLength, long progress) {
                    uploadProgress[0] = progress;
                    uploadProgress[1] = contentLength;
                }
            });
            IdeLog.logError((Plugin)PackActivator.getDefault(), (String)("zip\u6587\u4ef6: " + zip));
            IdeLog.logTrace((Plugin)PackActivator.getDefault(), (String)MessageFormat.format("\u4e0a\u4f20\u6253\u5305\u6570\u636e appid:{0} platform:{1} file:{2}", this.appid, StringUtil.join((String)",", platform), zip));
            BasicHttpContext httpContext = new BasicHttpContext();
            HttpPost httpPost = httpClientUtils.createHttpPost();
            stopJob = new Job("stop or statistic Package upload job", (HttpContext)httpContext, cannotCancelNotify, monitor, httpPost, uploadProgress){
                private int statisticsUploadSpeedNumber;
                private long lastStatisticUploadSpeedSize;
                private long lastStatisticUploadSpeedTime;
                private double lastUploadProgress;
                private final /* synthetic */ HttpContext val$httpContext;
                private final /* synthetic */ Runnable val$cannotCancelNotify;
                private final /* synthetic */ IProgressMonitor val$monitor;
                private final /* synthetic */ HttpPost val$httpPost;
                private final /* synthetic */ long[] val$uploadProgress;
                {
                    this.val$httpContext = httpContext;
                    this.val$cannotCancelNotify = runnable;
                    this.val$monitor = iProgressMonitor;
                    this.val$httpPost = httpPost;
                    this.val$uploadProgress = lArray;
                    super($anonymous0);
                    this.statisticsUploadSpeedNumber = 0;
                    this.lastStatisticUploadSpeedSize = 0L;
                    this.lastStatisticUploadSpeedTime = 0L;
                    this.lastUploadProgress = 0.0;
                }

                protected IStatus run(IProgressMonitor subMonitor) {
                    IdeLog.logInfo((Plugin)PackActivator.getDefault(), (String)"\u5f00\u59cb\u6253\u5305\u4e0a\u4f20");
                    while (!subMonitor.isCanceled()) {
                        Object hasSent = this.val$httpContext.getAttribute("http.request_sent");
                        if (this.val$cannotCancelNotify != null && hasSent != null && hasSent instanceof Boolean && ((Boolean)hasSent).booleanValue()) {
                            try {
                                this.val$cannotCancelNotify.run();
                                this.updateUploadProgress();
                                IdeLog.logInfo((Plugin)PackActivator.getDefault(), (String)"\u6253\u5305\u4e0a\u4f20\u5b8c\u6210, \u7981\u6b62\u53d6\u6d88\u6253\u5305");
                                this.val$monitor.subTask("\u6536\u53d6\u4e91\u7aef\u6253\u5305\u8bf7\u6c42\u54cd\u5e94\u6570\u636e");
                            }
                            catch (Throwable e) {
                                IdeLog.logError((Plugin)PackActivator.getDefault(), (Throwable)e);
                            }
                            break;
                        }
                        if (this.val$monitor.isCanceled()) {
                            if (this.val$httpPost.isAborted()) break;
                            try {
                                this.val$httpPost.abort();
                                IdeLog.logInfo((Plugin)PackActivator.getDefault(), (String)"\u53d6\u6d88\u6253\u5305\u4e0a\u4f20");
                            }
                            catch (Throwable e) {
                                IdeLog.logError((Plugin)PackActivator.getDefault(), (Throwable)e);
                            }
                            break;
                        }
                        this.updateUploadProgress();
                        try {
                            Thread.sleep(200L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    return Status.OK_STATUS;
                }

                private void updateUploadProgress() {
                    try {
                        double now;
                        double add;
                        ++this.statisticsUploadSpeedNumber;
                        long progress = this.val$uploadProgress[0];
                        long contentLength = this.val$uploadProgress[1];
                        if (progress != 0L && contentLength != 0L && (add = (now = (double)progress * 1.0 / (double)contentLength * 89.0) - this.lastUploadProgress) >= 1.0) {
                            this.lastUploadProgress = now;
                            this.val$monitor.internalWorked(add);
                        }
                        if (this.statisticsUploadSpeedNumber == 1) {
                            this.lastStatisticUploadSpeedTime = System.currentTimeMillis();
                            this.lastStatisticUploadSpeedSize = progress;
                        }
                        if (this.statisticsUploadSpeedNumber % 5 == 0) {
                            this.val$monitor.subTask(String.format("\u5411\u4e91\u7aef\u53d1\u9001\u6253\u5305\u8bf7\u6c42   (%.2fK/s)", (double)(progress - this.lastStatisticUploadSpeedSize) / (1024.0 * ((double)(System.currentTimeMillis() - this.lastStatisticUploadSpeedTime) / 1000.0))));
                            this.lastStatisticUploadSpeedSize = progress;
                            this.lastStatisticUploadSpeedTime = System.currentTimeMillis();
                        }
                    }
                    catch (Throwable e) {
                        IdeLog.logError((Plugin)PackActivator.getDefault(), (Throwable)e);
                    }
                }
            };
            stopJob.setSystem(true);
            stopJob.schedule();
            long start = System.currentTimeMillis();
            responseObj = httpClientUtils.excute((HttpContext)httpContext, httpPost, false);
            System.out.println("\u6253\u5305\u4e0a\u4f20\u8017\u65f6: " + (System.currentTimeMillis() - start));
            stopJob.cancel();
            monitor.done();
            if (!responseObj.isConnectionError()) break block27;
            if (!monitor.isCanceled()) {
                if (responseObj.getHttpErrorCode() < 500) throw new CoreException((IStatus)new Status(4, "com.pandora.pack.core", Messages.MakePackage_Net_Error));
                throw new CoreException((IStatus)new Status(4, "com.pandora.pack.core", "\u4e91\u7aef\u670d\u52a1\u5668\u7e41\u5fd9\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5"));
            }
            stopJob.cancel();
            if (stopJob == null) return false;
            try {
                stopJob.cancel();
                return false;
            }
            catch (Throwable throwable) {}
            return false;
        }
        if (!"1001".equals(responseObj.getRspcode())) {
            String error = responseObj.getRspdesc();
            throw new CoreException((IStatus)new Status(4, "com.pandora.pack.core", Integer.parseInt(responseObj.getRspcode()), error, null));
        }
        JSONObject body = responseObj.getBody();
        ArrayList<String> tickets = new ArrayList<String>();
        PackPlatform[] packPlatformArray = ps = PackPlatform.values();
        int n = ps.length;
        int n2 = 0;
        while (true) {
            if (n2 >= n) {
                IdeLog.logTrace((Plugin)PackActivator.getDefault(), (String)MessageFormat.format("\u6253\u5305\u8bf7\u6c42\u8fd4\u56de\u7684 tickets : {0}", StringUtil.join((String)",", tickets)));
                if (!tickets.isEmpty()) {
                    DownloadDataManager.getInstance().put(tickets, this.project.getProject().getName());
                }
                monitor.subTask("APP\u5236\u4f5c\u8bf7\u6c42\u53d1\u9001\u6210\u529f");
                if (stopJob == null) return true;
                break;
            }
            PackPlatform p = packPlatformArray[n2];
            if (body.has(p.toString())) {
                tickets.add(body.getJSONObject(p.toString()).getString("ticket"));
            }
            ++n2;
        }
        try {
            stopJob.cancel();
            return true;
        }
        catch (Throwable throwable) {}
        return true;
        catch (Exception e) {
            try {
                IdeLog.logError((Plugin)PackActivator.getDefault(), (Throwable)e);
                if (!(e instanceof CoreException)) throw new CoreException((IStatus)new Status(4, "com.pandora.pack.core", e.getMessage(), (Throwable)e));
                throw (CoreException)e;
            }
            catch (Throwable throwable) {
                if (stopJob == null) throw throwable;
                try {
                    stopJob.cancel();
                    throw throwable;
                }
                catch (Throwable throwable2) {}
                throw throwable;
            }
        }
    }

    public File zipPackage(boolean needConfusion) throws IOException, CoreException {
        File zip;
        File projectDir = new File(this.project.getProject().getLocationURI());
        IdeLog.logTrace((Plugin)PackActivator.getDefault(), (String)MessageFormat.format("\u5f00\u59cbZIP\u9879\u76ee: {0}", projectDir));
        File oldTmp = PackActivator.getDefault().getBundle().getDataFile(".tmp");
        if (oldTmp.exists()) {
            FileUtils.deleteQuietly((File)oldTmp);
        }
        File tmp = PackActivator.getDefault().getBundle().getDataFile(".tmp" + System.currentTimeMillis());
        try {
            String filname;
            String filname2;
            if (tmp.exists()) {
                FileUtils.deleteQuietly((File)tmp);
            }
            tmp.mkdirs();
            JsonObject appConfigJson = ManifastConfigurationVerification.setDefaultValues((ManifastConfiguration)this.appConfig, (File)new File(projectDir, "manifest.json"), (IProject)this.project.getProject(), (ManifastConfigurationVerification.VerificationPlatform)ManifastConfigurationVerification.VerificationPlatform.ALL, (boolean)true);
            File appidDir = new File(tmp, this.appid);
            appidDir = this.copyPackAgeResources(needConfusion, projectDir, appidDir, appConfigJson);
            File manifastDir = new File(appidDir, MANIFAST_DIR_NAME);
            manifastDir.mkdirs();
            if (this.phoneModules.contains((Object)PackPlatform.IOS_APPSTORE) || this.phoneModules.contains((Object)PackPlatform.IOS_ADHOC) || this.phoneModules.contains((Object)PackPlatform.IOS_PB)) {
                IPadSplashScreen iPadSplashScreen;
                IPhoneSplashScreen iPhoneSplashScreen;
                IPadIcon iPadIcon;
                IPhoneIcon iPhoneIcon;
                AppleProfile appleProfile = this.appConfig.getPlus().getDistribute().getApple();
                if (appleProfile != null) {
                    JsonObject appleProfileJson = appConfigJson.getAsJsonObject("plus").getAsJsonObject("distribute").getAsJsonObject("apple");
                    filname2 = this.copyFile(appleProfile.getMobileprovision(), "apple-mobileprovision", manifastDir);
                    if (filname2 != null) {
                        appleProfileJson.addProperty("mobileprovision", filname2);
                    }
                    if ((filname2 = this.copyFile(appleProfile.getP12(), "apple-private", manifastDir)) != null) {
                        appleProfileJson.addProperty("p12", filname2);
                    }
                }
                String auto = this.appConfig.getPlus().getDistribute().getIcons().getIos().getAuto();
                IOSIcon iosicon = this.appConfig.getPlus().getDistribute().getIcons().getIos();
                if (iosicon != null && auto != null && !"".equals(auto)) {
                    JsonObject iOSIconJson = appConfigJson.getAsJsonObject("plus").getAsJsonObject("distribute").getAsJsonObject("icons").getAsJsonObject("ios");
                    filname = this.copyFile(auto, "auto", manifastDir);
                    if (filname != null) {
                        iOSIconJson.addProperty("auto", filname);
                    }
                }
                if ((iPhoneIcon = this.appConfig.getPlus().getDistribute().getIcons().getIos().getIphone()) != null) {
                    JsonObject iPhoneIconJson = appConfigJson.getAsJsonObject("plus").getAsJsonObject("distribute").getAsJsonObject("icons").getAsJsonObject("ios").getAsJsonObject("iphone");
                    String filname3 = "";
                    if (iPhoneIcon.getNormal() != null && !"".equals(iPhoneIcon.getNormal()) && (filname3 = this.copyFile(iPhoneIcon.getNormal(), "icon-iphone-normal", manifastDir)) != null) {
                        iPhoneIconJson.addProperty("normal", filname3);
                    }
                    if (iPhoneIcon.getRetina() != null && !"".equals(iPhoneIcon.getRetina()) && (filname3 = this.copyFile(iPhoneIcon.getRetina(), "icon-iphone-retina", manifastDir)) != null) {
                        iPhoneIconJson.addProperty("retina", filname3);
                    }
                    if (iPhoneIcon.getRetina7() != null && !"".equals(iPhoneIcon.getRetina7()) && (filname3 = this.copyFile(iPhoneIcon.getRetina7(), "icon-iphone-retina7", manifastDir)) != null) {
                        iPhoneIconJson.addProperty("retina7", filname3);
                    }
                    if (iPhoneIcon.getRetina8() != null && !"".equals(iPhoneIcon.getRetina8()) && (filname3 = this.copyFile(iPhoneIcon.getRetina8(), "icon-iphone-retina8", manifastDir)) != null) {
                        iPhoneIconJson.addProperty("retina8", filname3);
                    }
                    if (iPhoneIcon.getSettings_normal() != null && !"".equals(iPhoneIcon.getSettings_normal()) && (filname3 = this.copyFile(iPhoneIcon.getSettings_normal(), "icon-iphone-settings-normal", manifastDir)) != null) {
                        iPhoneIconJson.addProperty("settings-normal", filname3);
                    }
                    if (iPhoneIcon.getSettings_retina() != null && !"".equals(iPhoneIcon.getSettings_retina()) && (filname3 = this.copyFile(iPhoneIcon.getSettings_retina(), "icon-iphone-settings-retina", manifastDir)) != null) {
                        iPhoneIconJson.addProperty("settings-retina", filname3);
                    }
                    if (iPhoneIcon.getSettings_retina8() != null && !"".equals(iPhoneIcon.getSettings_retina8()) && (filname3 = this.copyFile(iPhoneIcon.getSettings_retina(), "icon-iphone-settings-retina8", manifastDir)) != null) {
                        iPhoneIconJson.addProperty("settings-retina8", filname3);
                    }
                    if (iPhoneIcon.getSpotlight_normal() != null && !"".equals(iPhoneIcon.getSpotlight_normal()) && (filname3 = this.copyFile(iPhoneIcon.getSpotlight_normal(), "icon-iphone-spotlight-normal", manifastDir)) != null) {
                        iPhoneIconJson.addProperty("spotlight-normal", filname3);
                    }
                    if (iPhoneIcon.getSpotlight_retina() != null && !"".equals(iPhoneIcon.getSpotlight_retina()) && (filname3 = this.copyFile(iPhoneIcon.getSpotlight_retina(), "icon-iphone-spotlight-retina", manifastDir)) != null) {
                        iPhoneIconJson.addProperty("spotlight-retina", filname3);
                    }
                    if (iPhoneIcon.getSpotlight_retina7() != null && !"".equals(iPhoneIcon.getSpotlight_retina7()) && (filname3 = this.copyFile(iPhoneIcon.getSpotlight_retina7(), "icon-iphone-spotlight-retina7", manifastDir)) != null) {
                        iPhoneIconJson.addProperty("spotlight-retina7", filname3);
                    }
                }
                if ((iPadIcon = this.appConfig.getPlus().getDistribute().getIcons().getIos().getIpad()) != null) {
                    JsonObject ipadIconJson = appConfigJson.getAsJsonObject("plus").getAsJsonObject("distribute").getAsJsonObject("icons").getAsJsonObject("ios").getAsJsonObject("ipad");
                    String filname4 = this.copyFile(iPadIcon.getNormal(), "icon-ipad-normal", manifastDir);
                    if (filname4 != null) {
                        ipadIconJson.addProperty("normal", filname4);
                    }
                    if ((filname4 = this.copyFile(iPadIcon.getRetina(), "icon-ipad-retina", manifastDir)) != null) {
                        ipadIconJson.addProperty("retina", filname4);
                    }
                    if ((filname4 = this.copyFile(iPadIcon.getNormal7(), "icon-ipad-normal7", manifastDir)) != null) {
                        ipadIconJson.addProperty("normal7", filname4);
                    }
                    if ((filname4 = this.copyFile(iPadIcon.getRetina7(), "icon-ipad-retina7", manifastDir)) != null) {
                        ipadIconJson.addProperty("retina7", filname4);
                    }
                    if ((filname4 = this.copyFile(iPadIcon.getSettings_normal(), "icon-ipad-settings-normal", manifastDir)) != null) {
                        ipadIconJson.addProperty("settings-normal", filname4);
                    }
                    if ((filname4 = this.copyFile(iPadIcon.getSettings_retina(), "icon-ipad-settings-retina", manifastDir)) != null) {
                        ipadIconJson.addProperty("settings-retina", filname4);
                    }
                    if ((filname4 = this.copyFile(iPadIcon.getSpotlight_normal(), "icon-ipad-spotlight-normal", manifastDir)) != null) {
                        ipadIconJson.addProperty("spotlight-normal", filname4);
                    }
                    if ((filname4 = this.copyFile(iPadIcon.getSpotlight_normal7(), "icon-ipad-spotlight-normal7", manifastDir)) != null) {
                        ipadIconJson.addProperty("spotlight-normal7", filname4);
                    }
                    if ((filname4 = this.copyFile(iPadIcon.getSpotlight_retina(), "icon-ipad-spotlight-retina", manifastDir)) != null) {
                        ipadIconJson.addProperty("spotlight-retina", filname4);
                    }
                    if ((filname4 = this.copyFile(iPadIcon.getSpotlight_retina7(), "icon-ipad-spotlight-retina7", manifastDir)) != null) {
                        ipadIconJson.addProperty("spotlight-retina7", filname4);
                    }
                }
                if ((iPhoneSplashScreen = this.appConfig.getPlus().getDistribute().getSplashscreen().getIos().getIphone()) != null) {
                    JsonObject iPhoneSplashScreenJson = appConfigJson.getAsJsonObject("plus").getAsJsonObject("distribute").getAsJsonObject("splashscreen").getAsJsonObject("ios").getAsJsonObject("iphone");
                    String filname5 = this.copyFile(iPhoneSplashScreen.get_default(), "splash-iphone-default", manifastDir);
                    if (filname5 != null) {
                        iPhoneSplashScreenJson.addProperty("default", filname5);
                    }
                    if ((filname5 = this.copyFile(iPhoneSplashScreen.getRetina35(), "splash-iphone-retina35", manifastDir)) != null) {
                        iPhoneSplashScreenJson.addProperty("retina35", filname5);
                    }
                    if ((filname5 = this.copyFile(iPhoneSplashScreen.getRetina40(), "splash-iphone-retina40", manifastDir)) != null) {
                        iPhoneSplashScreenJson.addProperty("retina40", filname5);
                    }
                    if ((filname5 = this.copyFile(iPhoneSplashScreen.getRetina47(), "splash-iphone-retina47", manifastDir)) != null) {
                        iPhoneSplashScreenJson.addProperty("retina47", filname5);
                    }
                    if ((filname5 = this.copyFile(iPhoneSplashScreen.getRetina55(), "splash-iphone-retina55", manifastDir)) != null) {
                        iPhoneSplashScreenJson.addProperty("retina55", filname5);
                    }
                    if ((filname5 = this.copyFile(iPhoneSplashScreen.getRetina55l(), "splash-iphone-retina55l", manifastDir)) != null) {
                        iPhoneSplashScreenJson.addProperty("retina55l", filname5);
                    }
                }
                if ((iPadSplashScreen = this.appConfig.getPlus().getDistribute().getSplashscreen().getIos().getIpad()) != null) {
                    JsonObject ipadSplashScreenJson = appConfigJson.getAsJsonObject("plus").getAsJsonObject("distribute").getAsJsonObject("splashscreen").getAsJsonObject("ios").getAsJsonObject("ipad");
                    String filname6 = this.copyFile(iPadSplashScreen.getLandscape(), "splash-ipad-landscape", manifastDir);
                    if (filname6 != null) {
                        ipadSplashScreenJson.addProperty("landscape", filname6);
                    }
                    if ((filname6 = this.copyFile(iPadSplashScreen.getLandscape_retina(), "splash-ipad-landscape_retina", manifastDir)) != null) {
                        ipadSplashScreenJson.addProperty("landscape-retina", filname6);
                    }
                    if ((filname6 = this.copyFile(iPadSplashScreen.getPortrait(), "splash-ipad-portrait", manifastDir)) != null) {
                        ipadSplashScreenJson.addProperty("portrait", filname6);
                    }
                    if ((filname6 = this.copyFile(iPadSplashScreen.getPortrait_retina(), "splash-ipad-portrait_retina", manifastDir)) != null) {
                        ipadSplashScreenJson.addProperty("portrait-retina", filname6);
                    }
                    if ((filname6 = this.copyFile(iPadSplashScreen.getPortrait7(), "splash-ipad-portrait7", manifastDir)) != null) {
                        ipadSplashScreenJson.addProperty("portrait7", filname6);
                    }
                    if ((filname6 = this.copyFile(iPadSplashScreen.getPortrait_retina7(), "splash-ipad-portrait-retina7", manifastDir)) != null) {
                        ipadSplashScreenJson.addProperty("portrait-retina7", filname6);
                    }
                    if ((filname6 = this.copyFile(iPadSplashScreen.getLandscape7(), "splash-ipad-landscape7", manifastDir)) != null) {
                        ipadSplashScreenJson.addProperty("landscape7", filname6);
                    }
                    if ((filname6 = this.copyFile(iPadSplashScreen.getLandscape_retina7(), "splash-ipad-landscape-retina7", manifastDir)) != null) {
                        ipadSplashScreenJson.addProperty("landscape-retina7", filname6);
                    }
                }
            }
            if (this.phoneModules.contains((Object)PackPlatform.ANDROID_GOOGLEPLAY) || this.phoneModules.contains((Object)PackPlatform.ANDROID_PB)) {
                AndroidSplashScreen androidSplashScreen;
                AndroidIcon androidIcon;
                GoogleProfile googleProfile = this.appConfig.getPlus().getDistribute().getGoogle();
                if (googleProfile != null) {
                    JsonObject googleProfileJson = appConfigJson.getAsJsonObject("plus").getAsJsonObject("distribute").getAsJsonObject("google");
                    filname2 = this.copyFile(googleProfile.getKeystore(), "google-keystore", manifastDir);
                    if (filname2 != null) {
                        googleProfileJson.addProperty("keystore", filname2);
                    }
                }
                if ((androidIcon = this.appConfig.getPlus().getDistribute().getIcons().getAndroid()) != null) {
                    JsonObject androidIconJson = appConfigJson.getAsJsonObject("plus").getAsJsonObject("distribute").getAsJsonObject("icons").getAsJsonObject("android");
                    String filname7 = this.copyFile(androidIcon.getHdpi(), "icon-android-hdpi", manifastDir);
                    if (filname7 != null) {
                        androidIconJson.addProperty("hdpi", filname7);
                    }
                    if ((filname7 = this.copyFile(androidIcon.getLdpi(), "icon-android-ldpi", manifastDir)) != null) {
                        androidIconJson.addProperty("ldpi", filname7);
                    }
                    if ((filname7 = this.copyFile(androidIcon.getMdpi(), "icon-android-mdpi", manifastDir)) != null) {
                        androidIconJson.addProperty("mdpi", filname7);
                    }
                    if ((filname7 = this.copyFile(androidIcon.getXhdpi(), "icon-android-xhdpi", manifastDir)) != null) {
                        androidIconJson.addProperty("xhdpi", filname7);
                    }
                    if ((filname7 = this.copyFile(androidIcon.getXxhdpi(), "icon-android-xxhdpi", manifastDir)) != null) {
                        androidIconJson.addProperty("xxhdpi", filname7);
                    }
                }
                if ((androidSplashScreen = this.appConfig.getPlus().getDistribute().getSplashscreen().getAndroid()) != null) {
                    JsonObject androidSplashScreenJson = appConfigJson.getAsJsonObject("plus").getAsJsonObject("distribute").getAsJsonObject("splashscreen").getAsJsonObject("android");
                    filname = this.copyFile(androidSplashScreen.getHdpi(), "splash-android-hdpi", manifastDir);
                    if (filname != null) {
                        androidSplashScreenJson.addProperty("hdpi", filname);
                    }
                    if ((filname = this.copyFile(androidSplashScreen.getLdpi(), "splash-android-ldpi", manifastDir)) != null) {
                        androidSplashScreenJson.addProperty("ldpi", filname);
                    }
                    if ((filname = this.copyFile(androidSplashScreen.getMdpi(), "splash-android-mdpi", manifastDir)) != null) {
                        androidSplashScreenJson.addProperty("mdpi", filname);
                    }
                    if ((filname = this.copyFile(androidSplashScreen.getXhdpi(), "splash-android-xhdpi", manifastDir)) != null) {
                        androidSplashScreenJson.addProperty("xhdpi", filname);
                    }
                    if ((filname = this.copyFile(androidSplashScreen.getXxhdpi(), "splash-android-xxhdpi", manifastDir)) != null) {
                        androidSplashScreenJson.addProperty("xxhdpi", filname);
                    }
                }
            }
            Gson gson = new GsonBuilder().disableHtmlEscaping().create();
            String configJson = gson.toJson((JsonElement)appConfigJson);
            FileUtils.write((File)new File(appidDir, "manifest.json"), (CharSequence)configJson, (String)"utf-8");
            zip = PackActivator.getDefault().getBundle().getDataFile(String.valueOf(this.appid) + ".wgt");
            ZipUtils.zip((String)tmp.getAbsolutePath(), (String)zip.getAbsolutePath());
            IdeLog.logTrace((Plugin)PackActivator.getDefault(), (String)MessageFormat.format("ZIP\u9879\u76ee{0} \u7ed3\u675f: {1}", projectDir, zip));
        }
        finally {
            if (tmp.exists()) {
                FileUtils.deleteQuietly((File)tmp);
            }
        }
        return zip;
    }

    public File copyPackAgeResources(boolean needConfusion, final File sourceFile, File targetDir, JsonObject appConfigJson) throws IOException, CoreException {
        final HashSet<File> unpackageFiles = new HashSet<File>();
        if (appConfigJson.has("unpackage")) {
            try {
                JsonArray array = appConfigJson.getAsJsonArray("unpackage");
                if (array != null && array.size() > 0) {
                    for (JsonElement jsonElement : array) {
                        if (!jsonElement.isJsonPrimitive()) continue;
                        unpackageFiles.add(new File(sourceFile, jsonElement.getAsString()));
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        final String pPath = String.valueOf(sourceFile.getAbsolutePath()) + File.separator;
        FileUtils.copyDirectory((File)sourceFile, (File)targetDir, (FileFilter)new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                String fName = pathname.getName();
                if (chinesePattern.matcher(fName).find()) {
                    throw new IllegalArgumentException("App\u6253\u5305\u65f6\uff0c\u9879\u76ee\u4e2d\u6587\u4ef6\u540d\u4e0d\u80fd\u542b\u6709\u4e2d\u6587\uff0c\u8bf7\u786e\u8ba4");
                }
                String fPath = pathname.getAbsolutePath();
                if ("appstream.json".equals(fPath = fPath.replace(pPath, "")) || fPath.startsWith("appstream@") && fPath.endsWith(".bak.json")) {
                    return false;
                }
                if (pathname.isDirectory() && fName.equals("unpackage") && pathname.getParentFile().equals(sourceFile)) {
                    return false;
                }
                if (unpackageFiles.contains(pathname)) {
                    return false;
                }
                if ("manifest.json.encrypted".equalsIgnoreCase(fName)) {
                    return false;
                }
                return !fName.startsWith(".");
            }
        });
        if (needConfusion) {
            PrimaryConfusionUtils.addConfusionInfo2Target(this.project, targetDir, appConfigJson);
        } else if (appConfigJson.has("plus")) {
            appConfigJson.getAsJsonObject("plus").remove("confusion");
        }
        appConfigJson.remove("dependencies");
        appConfigJson.remove("unpackage");
        return targetDir;
    }

    protected String copyFile(String fileStr, String fileName, File dir) throws IOException {
        File file;
        if (StringUtil.isNotBlank((String)fileStr) && (file = ResourceUtil.getAbsoluteFileFormProjectOrSystemt((IProject)this.project.getProject(), (String)fileStr)).exists()) {
            fileName = String.valueOf(fileName) + file.getName().substring(file.getName().lastIndexOf("."));
            FileUtils.copyFile((File)file, (File)new File(dir, fileName));
            return fileName;
        }
        return null;
    }
}

