/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.html.formatter.nodes;

import com.aptana.editor.html.formatter.HTMLFormatterNodeBuilder;
import com.aptana.formatter.IFormatterContext;
import com.aptana.formatter.IFormatterDocument;
import com.aptana.formatter.IFormatterWriter;
import com.aptana.formatter.nodes.FormatterTextNode;
import com.aptana.parsing.ast.IParseNode;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FormatterHTMLContentNode
extends FormatterTextNode {
    private static final Pattern NEW_LINE_PATTERN = Pattern.compile("\r\n|\r|\n");
    private String parentTagName;
    private String previousSiblingTagName;
    private IParseNode parentElement;
    private boolean isSpaceSensitive;

    public FormatterHTMLContentNode(IFormatterDocument document, IParseNode parentElement, IParseNode previousSiblingElement, int startOffset, int endOffset) {
        super(document, startOffset, endOffset);
        this.parentElement = parentElement;
        if (parentElement != null) {
            this.parentTagName = parentElement.getNameNode().getName().toLowerCase();
            this.isSpaceSensitive = HTMLFormatterNodeBuilder.SPACE_SENSITIVE_ELEMENTS.contains(this.parentTagName);
        }
        if (previousSiblingElement != null) {
            this.previousSiblingTagName = previousSiblingElement.getNameNode().getName().toLowerCase();
        }
    }

    public void accept(IFormatterContext context, IFormatterWriter visitor) throws Exception {
        boolean emptyTagsInSameLine = this.getDocument().getBoolean("html.formatter.newline.exclusion.in.empty.tag");
        boolean trimSpaces = this.getDocument().getBoolean("html.formatter.spaces.trim");
        if (!emptyTagsInSameLine && !trimSpaces) {
            visitor.write(context, this.getStartOffset(), this.getEndOffset());
            return;
        }
        String content = this.getDocument().get(this.getStartOffset(), this.getEndOffset());
        int contentTrimmedLength = content.trim().length();
        boolean insertNewLine = false;
        boolean lookForNewline = true;
        Set tagsWithoutNewLine = this.getDocument().getSet("html.formatter.newline.excluded");
        if (this.parentTagName != null) {
            if (!tagsWithoutNewLine.contains(this.parentTagName)) {
                if (this.preserveNewLines(content)) {
                    super.accept(context, visitor);
                    return;
                }
                if (contentTrimmedLength == 0 && emptyTagsInSameLine && !this.isSpaceSensitive && !tagsWithoutNewLine.contains(this.previousSiblingTagName) && this.parentElement.getChildCount() <= 1) {
                    visitor.appendToPreviousLine(context, "");
                    content = content.trim();
                    lookForNewline = false;
                } else {
                    insertNewLine = this.previousSiblingTagName == null || !tagsWithoutNewLine.contains(this.previousSiblingTagName);
                }
            } else {
                lookForNewline = false;
            }
        }
        if (!insertNewLine && content.length() == 0) {
            return;
        }
        if (!insertNewLine && lookForNewline) {
            int i = 0;
            while (i < content.length()) {
                char c = content.charAt(i);
                if (c == '\n' || c == '\r') {
                    insertNewLine = true;
                    break;
                }
                if (!Character.isWhitespace(c)) break;
                ++i;
            }
        }
        if (emptyTagsInSameLine && contentTrimmedLength == 0) {
            if (insertNewLine) {
                visitor.writeLineBreak(context);
            }
            if (this.isSpaceSensitive && content.length() > 0) {
                this.writeSpaces(visitor, context, 1);
            }
            return;
        }
        if (trimSpaces) {
            content = content.trim();
        }
        int spacesCountBefore = this.getSpacesCountBefore();
        if (insertNewLine) {
            visitor.writeLineBreak(context);
        } else if (spacesCountBefore > 0) {
            this.writeSpaces(visitor, context, spacesCountBefore);
        }
        visitor.writeText(context, content, false);
        if (this.getSpacesCountAfter() > 0) {
            this.writeSpaces(visitor, context, this.getSpacesCountAfter());
        }
    }

    private boolean preserveNewLines(String content) {
        Matcher matcher = NEW_LINE_PATTERN.matcher(content);
        int count = 0;
        while (matcher.find()) {
            ++count;
        }
        if (count == 1 && this.getDocument().getBoolean("html.formatter.newline.exclusion.in.empty.tag")) {
            return false;
        }
        return count > 1 && this.getDocument().getInt("html.formatter.line.preserve") > 0;
    }

    public boolean shouldConsumePreviousWhiteSpaces() {
        Set set = this.getDocument().getSet("html.formatter.newline.excluded");
        return set.contains(this.parentTagName) || this.isSpaceSensitive && this.getDocument().getBoolean("html.formatter.spaces.trim");
    }

    public int getSpacesCountBefore() {
        if (!this.isEmpty() && Character.isWhitespace(this.getDocument().charAt(this.getStartOffset()))) {
            return 1;
        }
        return 0;
    }

    public int getSpacesCountAfter() {
        if (this.getStartOffset() < this.getEndOffset() - 1 && Character.isWhitespace(this.getDocument().charAt(this.getEndOffset() - 1))) {
            return 1;
        }
        return 0;
    }

    public boolean isEmpty() {
        return this.getStartOffset() == this.getEndOffset();
    }
}

