/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.ruby.outline;

import com.aptana.editor.common.AbstractThemeableEditor;
import com.aptana.editor.common.outline.CommonOutlineItem;
import com.aptana.editor.common.outline.CommonOutlinePage;
import com.aptana.ruby.core.IRubyField;
import com.aptana.ruby.core.IRubyMethod;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.handlers.HandlerUtil;

public class ToggleHideSingletonsHandler
extends AbstractHandler {
    private ViewerFilter fFilter;

    public Object execute(ExecutionEvent event) {
        IEditorPart editor = HandlerUtil.getActiveEditor((ExecutionEvent)event);
        if (editor instanceof AbstractThemeableEditor) {
            AbstractThemeableEditor ate = (AbstractThemeableEditor)editor;
            CommonOutlinePage page = ate.getOutlinePage();
            TreeViewer viewer = page.getTreeViewer();
            if (this.fFilter == null) {
                this.fFilter = new SingletonFilter();
                viewer.addFilter(this.fFilter);
            } else {
                viewer.removeFilter(this.fFilter);
                this.fFilter = null;
            }
        }
        return null;
    }

    private static class SingletonFilter
    extends ViewerFilter {
        private SingletonFilter() {
        }

        public boolean select(Viewer viewer, Object parent, Object element) {
            if (element instanceof CommonOutlineItem) {
                CommonOutlineItem coi = (CommonOutlineItem)element;
                return this.select(viewer, parent, coi.getReferenceNode());
            }
            if (element instanceof IRubyMethod) {
                IRubyMethod method = (IRubyMethod)element;
                return !method.isSingleton();
            }
            if (element instanceof IRubyField) {
                IRubyField field = (IRubyField)element;
                short type = field.getNodeType();
                return type != 8;
            }
            return true;
        }
    }
}

