/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.ruby.outline;

import com.aptana.editor.common.outline.CommonOutlineContentProvider;
import com.aptana.editor.common.outline.CommonOutlineItem;
import com.aptana.parsing.ast.IParseNode;
import com.aptana.ruby.core.IRubyElement;
import com.aptana.ruby.core.IRubyMethod;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

public class RubyOutlineContentProvider
extends CommonOutlineContentProvider {
    protected Object[] filter(IParseNode[] nodes) {
        ArrayList<IRubyElement> list = new ArrayList<IRubyElement>();
        IParseNode[] iParseNodeArray = nodes;
        int n = nodes.length;
        int n2 = 0;
        while (n2 < n) {
            IRubyElement element;
            IParseNode node = iParseNodeArray[n2];
            if (node instanceof IRubyElement && (element = (IRubyElement)node).getNodeType() != 4) {
                list.add(element);
            }
            ++n2;
        }
        Collections.sort(list, new Comparator<IRubyElement>(){

            @Override
            public int compare(IRubyElement o1, IRubyElement o2) {
                return this.sortPriority(o1) - this.sortPriority(o2);
            }

            private int sortPriority(IRubyElement element) {
                switch (element.getNodeType()) {
                    case 1: {
                        return -2;
                    }
                    case 5: {
                        return -1;
                    }
                    case 13: {
                        return 0;
                    }
                    case 6: {
                        return 1;
                    }
                    case 2: {
                        return 2;
                    }
                    case 7: {
                        return 3;
                    }
                    case 8: {
                        return 4;
                    }
                    case 9: 
                    case 12: {
                        return 5;
                    }
                    case 3: {
                        IRubyMethod method = (IRubyMethod)element;
                        if (method.isSingleton()) {
                            return 6;
                        }
                        if (method.isConstructor()) {
                            return 7;
                        }
                        return 8;
                    }
                    case 10: {
                        return 9;
                    }
                    case 4: 
                    case 11: {
                        return 10;
                    }
                }
                return 5;
            }
        });
        ArrayList<CommonOutlineItem> outlineItems = new ArrayList<CommonOutlineItem>(list.size());
        for (IRubyElement element : list) {
            outlineItems.add(this.getOutlineItem((IParseNode)element));
        }
        return outlineItems.toArray(new CommonOutlineItem[outlineItems.size()]);
    }
}

