/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.webserver.internal.core.preferences;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.EclipseUtil;
import com.aptana.core.util.SocketUtil;
import com.aptana.webserver.core.WebServerCorePlugin;
import com.aptana.webserver.core.preferences.IWebServerPreferenceConstants;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.preferences.IScopeContext;

public class WebServerPreferences {
    private static final String PORTS_PATTERN = "^(\\d+)(-(\\d+))?$";

    private WebServerPreferences() {
    }

    public static InetAddress getServerAddress() {
        String address = Platform.getPreferencesService().getString("com.aptana.webserver.core", "com.aptana.webserver.core.http_server_address", null, new IScopeContext[]{EclipseUtil.instanceScope(), EclipseUtil.defaultScope()});
        InetAddress[] inetAddressArray = SocketUtil.getLocalAddresses();
        int n = inetAddressArray.length;
        int n2 = 0;
        while (n2 < n) {
            InetAddress i = inetAddressArray[n2];
            if (i.getHostAddress().equals(address)) {
                return i;
            }
            ++n2;
        }
        try {
            return InetAddress.getByName("127.0.0.1");
        }
        catch (UnknownHostException unknownHostException) {
            return null;
        }
    }

    public static int[] getPortRange() {
        Matcher matcher;
        String portsString = Platform.getPreferencesService().getString("com.aptana.webserver.core", "com.aptana.webserver.core.http_server_ports", null, new IScopeContext[]{EclipseUtil.instanceScope(), EclipseUtil.defaultScope()});
        int portsStart = IWebServerPreferenceConstants.DEFAULT_HTTP_SERVER_PORTS_RANGE[0];
        int portsEnd = IWebServerPreferenceConstants.DEFAULT_HTTP_SERVER_PORTS_RANGE[1];
        if (portsString != null && portsString.length() > 0 && (matcher = Pattern.compile(PORTS_PATTERN).matcher(portsString)).matches()) {
            try {
                int start;
                int end = start = Integer.parseInt(matcher.group(1));
                if (matcher.group(2) != null) {
                    end = Integer.parseInt(matcher.group(3));
                }
                if (start <= end) {
                    portsStart = start;
                    portsEnd = end;
                }
            }
            catch (NumberFormatException e) {
                IdeLog.logWarning((Plugin)WebServerCorePlugin.getDefault(), (Throwable)e);
            }
        }
        return new int[]{portsStart, portsEnd};
    }
}

