/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.webserver.internal.core.builtin;

import java.util.HashMap;
import java.util.Map;

public class MimeTypesRegistry {
    private static final String TEXT_HTML = "text/html";
    public static final MimeTypesRegistry INSTANCE = new MimeTypesRegistry();
    private Map<String, String> map = new HashMap<String, String>();

    private MimeTypesRegistry() {
        this.map(TEXT_HTML, "html", "htm", "xhtml", "stm");
        this.map("application/acad", "dwg");
        this.map("application/andrew-inset", "ez");
        this.map("application/atom+xml", "atom");
        this.map("application/clariscad", "ccad");
        this.map("application/drafting", "drw");
        this.map("application/dsptype", "tsp");
        this.map("application/dxf", "dxf");
        this.map("application/envoy", "evy");
        this.map("application/fractals", "fif");
        this.map("application/hta", "hta");
        this.map("application/i-deas", "unv");
        this.map("application/internet-property-stream", "acx");
        this.map("application/java-archive", "jar", "war", "ear");
        this.map("application/json", "json");
        this.map("application/mac-binhex40", "hqx");
        this.map("application/mac-compactpro", "cpt");
        this.map("application/msword", "doc", "dot");
        this.map("application/octet-stream", "bin", "class", "dms", "exe", "lha", "lzh", "dmg", "eot", "iso", "img", "msi", "msp", "msm");
        this.map("application/oda", "oda");
        this.map("application/ogg", "ogm");
        this.map("application/olescript", "axs");
        this.map("application/pdf", "pdf");
        this.map("application/pgp", "pgp");
        this.map("application/pics-rules", "prf");
        this.map("application/pkcs10", "p10");
        this.map("application/pkix-crl", "crl");
        this.map("application/postscript", "ai", "eps", "ps");
        this.map("application/pro_eng", "prt");
        this.map("application/rss+xml", "rss");
        this.map("application/rtf", "rtf");
        this.map("application/set", "set");
        this.map("application/set-payment-initiation", "setpay");
        this.map("application/set-registration-initiation", "setreg");
        this.map("application/SLA", "stl");
        this.map("application/smil", "smil");
        this.map("application/solids", "sol");
        this.map("application/STEP", "stp");
        this.map("application/vda", "vda");
        this.map("application/vnd.google-earth.kml+xml", "kml");
        this.map("application/vnd.google-earth.kmz", "kmz");
        this.map("application/vnd.ms-excel", "xla", "xlc", "xlm", "xls", "xlt", "xlw");
        this.map("application/vnd.ms-outlook", "msg");
        this.map("application/vnd.ms-pkicertstore", "sst");
        this.map("application/vnd.ms-pkiseccat", "cat");
        this.map("application/vnd.ms-powerpoint", "pot", "pps", "ppt", "ppz");
        this.map("application/vnd.ms-project", "mpp");
        this.map("application/vnd.ms-works", "wcm", "wdb", "wks", "wps");
        this.map("application/vnd.rim.cod", "cod");
        this.map("application/vnd.wap.wmlc", "wmlc");
        this.map("application/vnd.wap.xhtml+xml", "xhtml");
        this.map("application/winhlp", "hlp");
        this.map("application/x-7z-compressed", "7z");
        this.map("application/x-arj-compressed", "arj");
        this.map("application/x-bcpio", "bcpio");
        this.map("application/x-cdf", "cdf");
        this.map("application/x-cdlink", "vcd");
        this.map("application/x-chess-pgn", "pgn");
        this.map("application/x-cocoa", "cco");
        this.map("application/x-compress", "z");
        this.map("application/x-cpio", "cpio");
        this.map("application/x-csh", "csh");
        this.map("application/x-deb", "deb");
        this.map("application/x-director", "dcr", "dir", "dxr");
        this.map("application/x-dvi", "dvi");
        this.map("application/x-freelance", "pre");
        this.map("application/x-futuresplash", "spl");
        this.map("application/x-gtar", "gtar");
        this.map("application/x-gzip", "gz");
        this.map("application/x-hdf", "hdf");
        this.map("application/x-internet-signup", "ins", "isp");
        this.map("application/x-iphone", "iii");
        this.map("application/x-ipix", "ipx");
        this.map("application/x-ipscript", "ips");
        this.map("application/x-java-archive-diff", "jardiff");
        this.map("application/x-java-jnlp-file", "jnlp");
        this.map("application/x-javascript", "js");
        this.map("application/x-koan", "skt");
        this.map("application/x-latex", "latex");
        this.map("application/x-lisp", "lsp");
        this.map("application/x-lotusscreencam", "scm");
        this.map("application/x-makeself", "run");
        this.map("application/x-mif", "mif");
        this.map("application/x-msaccess", "mdb");
        this.map("application/x-mscardfile", "crd");
        this.map("application/x-msclip", "clp");
        this.map("application/x-msdos-program", "com");
        this.map("application/x-msdownload", "dll");
        this.map("application/x-msmediaview", "m13", "m14", "mvb");
        this.map("application/x-msmetafile", "wmf");
        this.map("application/x-msmoney", "mny");
        this.map("application/x-mspublisher", "pub");
        this.map("application/x-msschedule", "scd");
        this.map("application/x-msterminal", "trm");
        this.map("application/x-mswrite", "wri");
        this.map("application/x-netcdf", "nc");
        this.map("application/x-perfmon", "pma", "pmc", "pml", "pmr", "pmw");
        this.map("application/x-perl", "pl", "pm");
        this.map("application/x-pilot", "prc", "pdb");
        this.map("application/x-pkcs12", "p12", "pfx");
        this.map("application/x-pkcs7-certificates", "p7b", "spc");
        this.map("application/x-pkcs7-certreqresp", "p7r");
        this.map("application/x-pkcs7-mime", "p7c", "p7m");
        this.map("application/x-pkcs7-signature", "p7s");
        this.map("application/x-rar-compressed", "rar");
        this.map("application/x-redhat-package-manager", "rpm");
        this.map("application/x-sea", "sea");
        this.map("application/x-sh", "sh");
        this.map("application/x-shar", "shar");
        this.map("application/x-shockwave-flash", "swf");
        this.map("application/x-stuffit", "sit");
        this.map("application/x-sv4cpio", "sv4cpio");
        this.map("application/x-sv4crc", "sv4crc");
        this.map("application/x-tar", "tar");
        this.map("application/x-tar-gz", "tgz");
        this.map("application/x-tcl", "tcl", "tk");
        this.map("application/x-tex", "tex");
        this.map("application/x-texinfo", "texi", "texinfo");
        this.map("application/x-troff", "roff", "t", "tr");
        this.map("application/x-troff-man", "man");
        this.map("application/x-troff-me", "me");
        this.map("application/x-troff-ms", "ms");
        this.map("application/x-ustar", "ustar");
        this.map("application/x-wais-source", "src");
        this.map("application/x-x509-ca-cert", "cer", "crt", "der", "pem");
        this.map("application/x-xpinstall", "xpi");
        this.map("application/ynd.ms-pkipko", "pko");
        this.map("application/zip", "zip");
        this.map("audio/basic", "au", "snd");
        this.map("audio/mid", "rmi");
        this.map("audio/midi", "mid", "midi", "kar");
        this.map("audio/mpeg", "mp3", "mpga");
        this.map("audio/TSP-audio", "tsi");
        this.map("audio/x-aiff", "aif", "aifc", "aiff");
        this.map("audio/x-mpegurl", "m3u");
        this.map("audio/x-ms-wax", "wax");
        this.map("audio/x-ms-wma", "wma");
        this.map("audio/x-pn-realaudio", "ra", "ram", "rm");
        this.map("audio/x-wav", "wav");
        this.map("chemical/x-pdb", "xyz");
        this.map("image/gif", "gif");
        this.map("image/ief", "ief");
        this.map("image/jpeg", "jpg", "jpeg", "jpe");
        this.map("image/pipeg", "jfif");
        this.map("image/png", "png");
        this.map("image/svg+xml", "svg");
        this.map("image/tiff", "tif", "tiff");
        this.map("image/vnd.wap.wbmp", "wbmp");
        this.map("image/x-cmu-raster", "ras");
        this.map("image/x-cmx", "cmx");
        this.map("image/x-icon", "ico");
        this.map("image/x-jng", "jng");
        this.map("image/x-ms-bmp", "bmp");
        this.map("image/x-portable-anymap", "pnm");
        this.map("image/x-portable-bitmap", "pbm");
        this.map("image/x-portable-graymap", "pgm");
        this.map("image/x-portable-pixmap", "ppm");
        this.map("image/x-rgb", "rgb");
        this.map("image/x-xpixmap", "xpm");
        this.map("image/x-xwindowdump", "xwd");
        this.map("model/iges", "igs");
        this.map("model/mesh", "silo");
        this.map("model/vrml", "wrl");
        this.map("text/cache-manifest", "manifest");
        this.map("text/css", "css");
        this.map("text/css", "less");
        this.map("text/h323", "323");
        this.map("text/iuls", "uls");
        this.map("text/mathml", "mml");
        this.map("text/plain", "bas", "c", "h", "txt", "m");
        this.map("text/richtext", "rtx");
        this.map("text/scriptlet", "sct");
        this.map("text/sgml", "sgml");
        this.map("text/tab-separated-values", "tsv");
        this.map("text/vnd.sun.j2me.app-descriptor", "jad");
        this.map("text/vnd.wap.wml", "wml");
        this.map("text/webviewhtml", "htt");
        this.map("text/x-component", "htc");
        this.map("text/x-setext", "etx");
        this.map("text/x-vcard", "vcf");
        this.map("application/xml", "xml");
        this.map("video/3gpp", "3gpp", "3gp");
        this.map("video/dl", "dl");
        this.map("video/gl", "gl");
        this.map("video/mp4", "mp4", "m4v");
        this.map("video/mpeg", "mp2", "mpa", "mpe", "mpeg", "mpg", "mpv2");
        this.map("video/ogg", "ogg", "ogv");
        this.map("video/quicktime", "mov", "qt");
        this.map("video/vnd.vivo", "vivo");
        this.map("video/webm", "webm");
        this.map("video/x-fli", "fli");
        this.map("video/x-flv", "flv");
        this.map("video/x-la-asf", "lsf", "lsx");
        this.map("video/x-mng", "mng");
        this.map("video/x-ms-asf", "asf", "asr");
        this.map("video/x-ms-asx", "asx");
        this.map("video/x-ms-wmx", "wmx");
        this.map("video/x-ms-wvx", "wvx");
        this.map("video/x-msvideo", "avi");
        this.map("video/x-sgi-movie", "movie");
        this.map("www/mime", "mime");
        this.map("x-conference/x-cooltalk", "ice");
        this.map("x-world/x-vrml", "vrm");
        this.map("zip", "application/zip");
    }

    private void map(String mimeType, String ... extensions) {
        String[] stringArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            String extension = stringArray[n2];
            this.map.put(extension, mimeType);
            ++n2;
        }
    }

    public String getMimeType(String extension) {
        String mimeType = this.map.get(extension);
        if (mimeType != null) {
            return mimeType;
        }
        return TEXT_HTML;
    }
}

