/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.webserver.internal.core.builtin;

import com.aptana.core.IURIMapper;
import com.aptana.core.logging.IdeLog;
import com.aptana.webserver.core.WebServerCorePlugin;
import com.aptana.webserver.internal.core.builtin.Messages;
import com.aptana.webserver.internal.core.builtin.MimeTypesRegistry;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.regex.Pattern;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.MethodNotSupportedException;
import org.apache.http.nio.entity.NFileEntity;
import org.apache.http.nio.entity.NStringEntity;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpRequestHandler;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.URIUtil;

class LocalWebServerHttpRequestHandler
implements HttpRequestHandler {
    private static final String METHOD_GET = "GET";
    private static final String METHOD_POST = "POST";
    private static final String METHOD_HEAD = "HEAD";
    private static final String HTML_TEXT_TYPE = "text/html";
    private static final Pattern PATTERN_INDEX = Pattern.compile("(index|default)\\.x?html?");
    private IURIMapper uriMapper;

    protected LocalWebServerHttpRequestHandler(IURIMapper uriMapper) {
        this.uriMapper = uriMapper;
    }

    public void handle(HttpRequest request, HttpResponse response, HttpContext context) throws HttpException, IOException {
        block12: {
            try {
                String method = request.getRequestLine().getMethod().toUpperCase(Locale.ENGLISH);
                if (METHOD_GET.equals(method) || METHOD_HEAD.equals(method)) {
                    String target = request.getRequestLine().getUri();
                    URI uri = URIUtil.fromString((String)target);
                    IFileStore fileStore = this.uriMapper.resolve(uri);
                    if (fileStore == null) {
                        response.setStatusCode(404);
                        response.setEntity(LocalWebServerHttpRequestHandler.createTextEntity(MessageFormat.format(Messages.LocalWebServerHttpRequestHandler_FILE_NOT_FOUND, uri.getPath())));
                        return;
                    }
                    IFileInfo fileInfo = fileStore.fetchInfo();
                    if (fileInfo.isDirectory() && (fileInfo = LocalWebServerHttpRequestHandler.getIndex(fileStore)).exists()) {
                        fileStore = fileStore.getChild(fileInfo.getName());
                    }
                    if (!fileInfo.exists()) {
                        response.setStatusCode(404);
                        response.setEntity(LocalWebServerHttpRequestHandler.createTextEntity(MessageFormat.format(Messages.LocalWebServerHttpRequestHandler_FILE_NOT_FOUND, uri.getPath())));
                    } else if (fileInfo.isDirectory()) {
                        response.setStatusCode(403);
                        response.setEntity(LocalWebServerHttpRequestHandler.createTextEntity(Messages.LocalWebServerHttpRequestHandler_FORBIDDEN));
                    } else {
                        response.setStatusCode(200);
                        if (METHOD_GET.equals(method)) {
                            File file = fileStore.toLocalFile(0, (IProgressMonitor)new NullProgressMonitor());
                            final File temporaryFile = file == null ? fileStore.toLocalFile(4096, (IProgressMonitor)new NullProgressMonitor()) : null;
                            response.setEntity((HttpEntity)new NFileEntity(file != null ? file : temporaryFile, LocalWebServerHttpRequestHandler.getMimeType(fileStore.getName())){

                                public void finish() {
                                    super.finish();
                                    if (temporaryFile != null && !temporaryFile.delete()) {
                                        temporaryFile.deleteOnExit();
                                    }
                                }
                            });
                        } else {
                            response.setEntity(null);
                        }
                    }
                    break block12;
                }
                if (METHOD_POST.equals(method)) {
                    throw new MethodNotSupportedException(MessageFormat.format(Messages.LocalWebServerHttpRequestHandler_UNSUPPORTED_METHOD, method));
                }
                throw new MethodNotSupportedException(MessageFormat.format(Messages.LocalWebServerHttpRequestHandler_UNSUPPORTED_METHOD, method));
            }
            catch (Exception e) {
                IdeLog.logError((Plugin)WebServerCorePlugin.getDefault(), (Throwable)e);
                response.setStatusCode(500);
                response.setEntity(LocalWebServerHttpRequestHandler.createTextEntity(Messages.LocalWebServerHttpRequestHandler_INTERNAL_SERVER_ERROR));
            }
        }
    }

    private static HttpEntity createTextEntity(String text) throws UnsupportedEncodingException {
        NStringEntity entity = new NStringEntity(MessageFormat.format("<html><body><h1>{0}</h1></body></html>", text), "UTF-8");
        entity.setContentType("text/html; charset=UTF-8");
        return entity;
    }

    private static IFileInfo getIndex(IFileStore parent) throws CoreException {
        IFileInfo[] iFileInfoArray = parent.childInfos(0, (IProgressMonitor)new NullProgressMonitor());
        int n = iFileInfoArray.length;
        int n2 = 0;
        while (n2 < n) {
            IFileInfo fileInfo = iFileInfoArray[n2];
            if (fileInfo.exists() && PATTERN_INDEX.matcher(fileInfo.getName()).matches()) {
                return fileInfo;
            }
            ++n2;
        }
        return EFS.getNullFileSystem().getStore((IPath)Path.EMPTY).fetchInfo();
    }

    private static String getMimeType(String fileName) {
        return MimeTypesRegistry.INSTANCE.getMimeType(Path.fromPortableString((String)fileName).getFileExtension());
    }
}

