/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.webserver.core;

import com.aptana.core.IURIMapper;
import com.aptana.core.io.efs.EFSUtils;
import com.aptana.core.logging.IdeLog;
import com.aptana.webserver.core.WebServerCorePlugin;
import java.io.File;
import java.net.URI;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Plugin;

public class WorkspaceResolvingURIMapper
implements IURIMapper {
    private IURIMapper baseMapper;

    public WorkspaceResolvingURIMapper(IURIMapper baseMapper) {
        this.baseMapper = baseMapper;
    }

    public URI resolve(IFileStore fileStore) {
        URI uri = this.baseMapper.resolve(fileStore);
        if (uri == null) {
            try {
                File file = fileStore.toLocalFile(0, (IProgressMonitor)new NullProgressMonitor());
                if (file != null) {
                    uri = this.baseMapper.resolve(EFSUtils.getLocalFileStore((File)file));
                }
            }
            catch (CoreException e) {
                IdeLog.logError((Plugin)WebServerCorePlugin.getDefault(), (Throwable)e);
            }
        }
        return uri;
    }

    public IFileStore resolve(URI uri) {
        IFileStore fileStore = this.baseMapper.resolve(uri);
        if (fileStore != null && fileStore.getFileSystem() == EFS.getLocalFileSystem()) {
            try {
                fileStore = EFSUtils.fromLocalFile((File)fileStore.toLocalFile(0, (IProgressMonitor)new NullProgressMonitor()));
            }
            catch (CoreException e) {
                IdeLog.logError((Plugin)WebServerCorePlugin.getDefault(), (Throwable)e);
            }
        }
        return fileStore;
    }
}

