/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.webserver.core;

import com.aptana.core.io.efs.EFSUtils;
import com.aptana.webserver.core.IServer;
import com.aptana.webserver.core.IServerManager;
import com.aptana.webserver.internal.core.ServerManager;
import com.aptana.webserver.internal.core.builtin.LocalWebServer;
import org.eclipse.core.internal.resources.DelayedSnapshotJob;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ISaveContext;
import org.eclipse.core.resources.ISaveParticipant;
import org.eclipse.core.resources.ISavedState;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.osgi.framework.BundleContext;

public class WebServerCorePlugin
extends Plugin {
    public static final String PLUGIN_ID = "com.aptana.webserver.core";
    private static WebServerCorePlugin plugin;
    private ServerManager serverManager;
    private LocalWebServer defaultWebServer;

    public void start(BundleContext context) throws Exception {
        IPath location;
        super.start(context);
        plugin = this;
        ISavedState lastState = ResourcesPlugin.getWorkspace().addSaveParticipant(PLUGIN_ID, (ISaveParticipant)new WorkspaceSaveParticipant());
        if (lastState != null && (location = lastState.lookup((IPath)new Path("webservers"))) != null) {
            ((ServerManager)this.getServerManager()).loadState(this.getStateLocation().append(location));
        }
    }

    public void stop(BundleContext context) throws Exception {
        ResourcesPlugin.getWorkspace().removeSaveParticipant(PLUGIN_ID);
        plugin = null;
        this.serverManager = null;
        if (this.defaultWebServer != null) {
            this.defaultWebServer.stop(true, (IProgressMonitor)new NullProgressMonitor());
        }
        super.stop(context);
    }

    public static WebServerCorePlugin getDefault() {
        return plugin;
    }

    public synchronized IServerManager getServerManager() {
        if (this.serverManager == null) {
            this.serverManager = new ServerManager();
        }
        return this.serverManager;
    }

    public void saveServerConfigurations() {
        new DelayedSnapshotJob(((Workspace)ResourcesPlugin.getWorkspace()).getSaveManager()).schedule();
    }

    public IServer getBuiltinWebServer() {
        this.ensureDefaultWebServer();
        return this.defaultWebServer;
    }

    private synchronized void ensureDefaultWebServer() {
        if (this.defaultWebServer == null) {
            this.defaultWebServer = new LocalWebServer(EFSUtils.getFileStore((IResource)ResourcesPlugin.getWorkspace().getRoot()).toURI());
        }
    }

    private class WorkspaceSaveParticipant
    implements ISaveParticipant {
        private WorkspaceSaveParticipant() {
        }

        public void doneSaving(ISaveContext context) {
            IPath prevSavePath = new Path("webservers").addFileExtension(Integer.toString(context.getPreviousSaveNumber()));
            WebServerCorePlugin.this.getStateLocation().append(prevSavePath).toFile().delete();
        }

        public void prepareToSave(ISaveContext context) throws CoreException {
        }

        public void rollback(ISaveContext context) {
            IPath savePath = new Path("webservers").addFileExtension(Integer.toString(context.getSaveNumber()));
            WebServerCorePlugin.this.getStateLocation().append(savePath).toFile().delete();
        }

        public void saving(ISaveContext context) throws CoreException {
            IPath savePath = new Path("webservers").addFileExtension(Integer.toString(context.getSaveNumber()));
            ((ServerManager)WebServerCorePlugin.this.getServerManager()).saveState(WebServerCorePlugin.this.getStateLocation().append(savePath));
            context.map((IPath)new Path("webservers"), savePath);
            context.needSaveNumber();
        }
    }
}

