/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ruby.ui.wizards;

import com.aptana.core.CoreStrings;
import com.aptana.core.projects.templates.IProjectTemplate;
import com.aptana.core.util.StringUtil;
import com.aptana.projects.wizards.IStepIndicatorWizardPage;
import com.aptana.projects.wizards.IWizardProjectCreationPage;
import com.aptana.ruby.ui.wizards.Messages;
import com.aptana.ui.util.SWTUtils;
import com.aptana.ui.util.UIUtils;
import com.aptana.ui.widgets.SelectedTemplateComposite;
import com.aptana.ui.widgets.StepIndicatorComposite;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.ide.dialogs.IDEResourceInfoUtils;

public class WizardNewRubyProjectCreationPage
extends WizardPage
implements IWizardProjectCreationPage,
IStepIndicatorWizardPage {
    private String initialProjectFieldValue;
    private Text projectNameField;
    private StyledText locationPathField;
    private Button browseButton;
    private Button gitCloneGenerate;
    private StyledText gitLocation;
    private String lastGitDefault;
    private Button gitBrowseButton;
    private Listener nameModifyListener = new Listener(){

        public void handleEvent(Event e) {
            WizardNewRubyProjectCreationPage.this.updateProjectName(WizardNewRubyProjectCreationPage.this.getProjectNameFieldValue());
            WizardNewRubyProjectCreationPage.this.setPageComplete(WizardNewRubyProjectCreationPage.this.validatePage());
        }
    };
    private String lastLocationDefault;
    protected Button noGenerator;
    private Group projectGenerationGroup;
    private StackLayout projectGenerationStackLayout;
    private Composite projectGenerationControls;
    private Label warningLabel;
    private IProjectTemplate projectTemplate = null;
    protected StepIndicatorComposite stepIndicatorComposite;
    protected String[] stepNames;
    private static final int SIZING_TEXT_FIELD_WIDTH = 250;
    private static final String SAVED_LOCATION_ATTR = "OUTSIDE_LOCATION";
    private static final String EMPTY_STRING = "";

    public WizardNewRubyProjectCreationPage(String pageName, IProjectTemplate projectTemplate) {
        super(pageName);
        this.setPageComplete(false);
        this.projectTemplate = projectTemplate;
    }

    public boolean canFlipToNextPage() {
        return super.canFlipToNextPage() && this.noGenerator.getSelection();
    }

    public void createControl(Composite parent) {
        Composite pageComposite = new Composite(parent, 0);
        GridLayout pageLayout = GridLayoutFactory.fillDefaults().spacing(0, 5).create();
        pageComposite.setLayout((Layout)pageLayout);
        pageComposite.setLayoutData((Object)GridDataFactory.fillDefaults().create());
        this.stepIndicatorComposite = new StepIndicatorComposite(pageComposite, this.stepNames);
        this.stepIndicatorComposite.setSelection(this.getStepName());
        this.initializeDialogUnits((Control)parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)pageComposite, "org.eclipse.ui.ide.new_project_wizard_page_context");
        this.createProjectNameGroup(pageComposite);
        this.createDestinationLocationArea(pageComposite);
        this.createProjectTemplateSection(pageComposite);
        this.createWarningArea(pageComposite);
        this.createGenerateGroup(pageComposite);
        this.setButtonLayoutData(this.browseButton);
        this.updateProjectName(this.getProjectNameFieldValue());
        this.setPageComplete(this.validatePage());
        this.setErrorMessage(null);
        this.setMessage(null);
        this.setControl((Control)pageComposite);
        Dialog.applyDialogFont((Control)pageComposite);
    }

    protected void createProjectTemplateSection(Composite parent) {
        if (this.projectTemplate != null) {
            new SelectedTemplateComposite(parent, this.projectTemplate);
        }
    }

    private void createDestinationLocationArea(Composite composite) {
        Composite projectGroup = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 4;
        projectGroup.setLayout((Layout)layout);
        projectGroup.setLayoutData((Object)new GridData(768));
        Label locationLabel = new Label(projectGroup, 0);
        locationLabel.setText(Messages.ProjectLocationSelectionDialog_locationLabel);
        this.locationPathField = new SpecialText(projectGroup, 2052){

            @Override
            protected boolean matchesLastDefault() {
                return WizardNewRubyProjectCreationPage.this.locationMatchesLastDefault();
            }

            @Override
            protected boolean isDefault() {
                String defaultLocation = Platform.getLocation().append(WizardNewRubyProjectCreationPage.this.getProjectNameFieldValue()).toOSString();
                return Path.fromOSString((String)WizardNewRubyProjectCreationPage.this.locationPathField.getText()).toOSString().equals(defaultLocation);
            }
        };
        GridData data = new GridData(768);
        data.widthHint = 250;
        data.horizontalSpan = 2;
        this.locationPathField.setLayoutData((Object)data);
        this.browseButton = new Button(projectGroup, 8);
        this.browseButton.setText(StringUtil.ellipsify((String)CoreStrings.BROWSE));
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                WizardNewRubyProjectCreationPage.this.handleLocationBrowseButtonPressed();
            }
        });
        if (this.initialProjectFieldValue == null) {
            this.locationPathField.setText(EMPTY_STRING);
        } else {
            this.locationPathField.setText(this.initialProjectFieldValue);
        }
        this.locationPathField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                WizardNewRubyProjectCreationPage.this.reportError(WizardNewRubyProjectCreationPage.this.checkValidLocation(), false);
            }
        });
    }

    private void createWarningArea(Composite composite) {
        final Font font = new Font((Device)composite.getDisplay(), SWTUtils.italicizedFont((Font)this.getFont()));
        this.warningLabel = new Label(composite, 64);
        this.warningLabel.setLayoutData((Object)GridDataFactory.fillDefaults().align(4, 1).grab(true, false).create());
        this.warningLabel.setFont(font);
        this.warningLabel.setForeground(UIUtils.getDisplay().getSystemColor(3));
        composite.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (font != null && !font.isDisposed()) {
                    font.dispose();
                }
            }
        });
    }

    private String getPathFromLocationField() {
        URI fieldURI;
        try {
            fieldURI = new URI(this.getLocationText());
        }
        catch (URISyntaxException uRISyntaxException) {
            return this.locationPathField.getText();
        }
        return fieldURI.getPath();
    }

    protected String getLocationText() {
        return this.locationPathField.getText();
    }

    protected void handleLocationBrowseButtonPressed() {
        String selectedDirectory = null;
        String dirName = this.getPathFromLocationField();
        if (!dirName.equals(EMPTY_STRING)) {
            IFileInfo info = IDEResourceInfoUtils.getFileInfo((String)dirName);
            if (info == null || !info.exists()) {
                dirName = EMPTY_STRING;
            }
        } else {
            String value = this.getDialogSettings().get(SAVED_LOCATION_ATTR);
            if (value != null) {
                dirName = value;
            }
        }
        DirectoryDialog dialog = new DirectoryDialog(this.locationPathField.getShell(), 0x10000000);
        dialog.setMessage(EMPTY_STRING);
        dialog.setFilterPath(dirName);
        selectedDirectory = dialog.open();
        if (selectedDirectory != null) {
            this.locationPathField.setText(selectedDirectory);
            this.getDialogSettings().put(SAVED_LOCATION_ATTR, selectedDirectory);
        }
    }

    protected void handleGitLocationBrowseButtonPressed() {
        IFileInfo info;
        String dirName = this.gitLocation.getText().trim();
        if (!(dirName.equals(EMPTY_STRING) || (info = IDEResourceInfoUtils.getFileInfo((String)dirName)) != null && info.exists())) {
            dirName = EMPTY_STRING;
        }
        DirectoryDialog dialog = new DirectoryDialog(this.gitLocation.getShell(), 0x10000000);
        dialog.setMessage(EMPTY_STRING);
        dialog.setFilterPath(dirName);
        String selectedDirectory = dialog.open();
        if (selectedDirectory != null) {
            this.gitLocation.setText(selectedDirectory);
            this.selectGitCloneGeneration();
        }
    }

    protected String checkValidLocation() {
        String locationFieldContents = this.locationPathField.getText();
        if (locationFieldContents.length() == 0) {
            return Messages.WizardNewProjectCreationPage_projectLocationEmpty;
        }
        return null;
    }

    protected String checkValidGitLocation() {
        if (!this.isCloneFromGit()) {
            return null;
        }
        String locationFieldContents = this.gitLocation.getText();
        if (locationFieldContents.length() == 0) {
            return Messages.WizardNewProjectCreationPage_gitLocationEmpty;
        }
        return null;
    }

    protected void reportError(String errorMessage, boolean infoOnly) {
        boolean valid;
        if (infoOnly) {
            this.setMessage(errorMessage, 1);
            this.setErrorMessage(null);
        } else {
            this.setErrorMessage(errorMessage);
        }
        boolean bl = valid = errorMessage == null;
        if (valid) {
            valid = this.validatePage();
        }
        this.setPageComplete(valid);
    }

    private final void createProjectNameGroup(Composite parent) {
        Composite projectGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        projectGroup.setLayout((Layout)layout);
        projectGroup.setLayoutData((Object)new GridData(768));
        Label projectLabel = new Label(projectGroup, 0);
        projectLabel.setText(Messages.WizardNewProjectCreationPage_nameLabel);
        projectLabel.setFont(parent.getFont());
        this.projectNameField = new Text(projectGroup, 2048);
        GridData data = new GridData(768);
        data.widthHint = 250;
        this.projectNameField.setLayoutData((Object)data);
        this.projectNameField.setFont(parent.getFont());
        if (this.initialProjectFieldValue != null) {
            this.projectNameField.setText(this.initialProjectFieldValue);
        }
        this.projectNameField.addListener(24, this.nameModifyListener);
    }

    protected Composite createGenerateGroup(Composite parent) {
        this.projectGenerationGroup = new Group(parent, 0);
        this.projectGenerationGroup.setText(Messages.WizardNewProjectCreationPage_GenerateAppGroupLabel);
        this.projectGenerationStackLayout = new StackLayout();
        this.projectGenerationGroup.setLayout((Layout)this.projectGenerationStackLayout);
        this.projectGenerationGroup.setLayoutData((Object)new GridData(768));
        this.projectGenerationControls = new Composite((Composite)this.projectGenerationGroup, 0);
        this.projectGenerationControls.setLayout((Layout)new GridLayout(1, false));
        this.projectGenerationControls.setLayoutData((Object)new GridData(768));
        this.createGenerationOptions(this.projectGenerationControls);
        this.setTopControl((Control)this.projectGenerationControls);
        return this.projectGenerationGroup;
    }

    protected void setTopControl(Control control) {
        this.projectGenerationStackLayout.topControl = control;
        this.projectGenerationGroup.layout();
    }

    protected void createGenerationOptions(Composite projectGenerationControls) {
        this.gitCloneGenerate = new Button(projectGenerationControls, 16);
        this.gitCloneGenerate.setText(Messages.WizardNewProjectCreationPage_CloneGitRepoLabel);
        this.createGitLocationComposite(projectGenerationControls);
        this.noGenerator = new Button(projectGenerationControls, 16);
        if (this.getWizard().getPage("templateSelectionPage") != null) {
            this.noGenerator.setText(Messages.WizardNewProjectCreationPage_NoGeneratorText2);
        } else {
            this.noGenerator.setText(Messages.WizardNewProjectCreationPage_NoGeneratorText);
        }
        this.noGenerator.setSelection(true);
        this.noGenerator.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WizardNewRubyProjectCreationPage.this.getContainer().updateButtons();
            }
        });
    }

    private void createGitLocationComposite(Composite parent) {
        Composite projectGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 4;
        projectGroup.setLayout((Layout)layout);
        projectGroup.setLayoutData((Object)new GridData(768));
        Label locationLabel = new Label(projectGroup, 0);
        locationLabel.setText(Messages.ProjectLocationSelectionDialog_locationLabel);
        this.gitLocation = new SpecialText(projectGroup, 2052){

            @Override
            protected boolean isDefault() {
                return this.matchesLastDefault();
            }

            @Override
            protected boolean matchesLastDefault() {
                return WizardNewRubyProjectCreationPage.this.gitLocationIsDefault();
            }
        };
        GridData data = new GridData(768);
        data.widthHint = 250;
        data.horizontalSpan = 2;
        this.gitLocation.setLayoutData((Object)data);
        this.gitLocation.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                WizardNewRubyProjectCreationPage.this.setPageComplete(WizardNewRubyProjectCreationPage.this.validatePage());
            }
        });
        this.gitLocation.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                WizardNewRubyProjectCreationPage.this.selectGitCloneGeneration();
            }
        });
        this.gitBrowseButton = new Button(projectGroup, 8);
        this.gitBrowseButton.setText(StringUtil.ellipsify((String)CoreStrings.BROWSE));
        this.gitBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WizardNewRubyProjectCreationPage.this.handleGitLocationBrowseButtonPressed();
            }
        });
    }

    public IPath getLocationPath() {
        if (this.useDefaults()) {
            return Platform.getLocation();
        }
        return Path.fromOSString((String)this.locationPathField.getText());
    }

    public URI getLocationURI() {
        return this.getLocationPath().toFile().toURI();
    }

    public IProject getProjectHandle() {
        return ResourcesPlugin.getWorkspace().getRoot().getProject(this.getProjectName());
    }

    public String getProjectName() {
        if (this.projectNameField == null) {
            return this.initialProjectFieldValue;
        }
        return this.getProjectNameFieldValue();
    }

    private String getProjectNameFieldValue() {
        if (this.projectNameField == null) {
            return EMPTY_STRING;
        }
        return this.projectNameField.getText().trim();
    }

    public void setInitialProjectName(String name) {
        if (name == null) {
            this.initialProjectFieldValue = null;
        } else {
            this.initialProjectFieldValue = name.trim();
            this.updateProjectName(name.trim());
        }
    }

    private void updateProjectName(String trim) {
        String username;
        if (this.locationPathField.getText().trim().length() == 0 || this.locationMatchesLastDefault()) {
            this.lastLocationDefault = Platform.getLocation().append(trim).toOSString();
            this.locationPathField.setText(this.lastLocationDefault);
        }
        if ((username = System.getProperty("user.name")) == null || username.length() == 0) {
            username = "user";
        }
        if (this.gitLocation.getText().trim().length() == 0 || this.gitLocationIsDefault()) {
            this.lastGitDefault = MessageFormat.format("git://github.com/{0}/{1}.git", username, trim);
            this.gitLocation.setText(this.lastGitDefault);
        }
    }

    private boolean locationMatchesLastDefault() {
        return this.lastLocationDefault != null && this.locationPathField.getText().trim().equals(this.lastLocationDefault);
    }

    private boolean gitLocationIsDefault() {
        return this.lastGitDefault != null && this.gitLocation.getText().trim().equals(this.lastGitDefault);
    }

    protected boolean validatePage() {
        String[] files;
        this.projectGenerationStackLayout.topControl = this.projectGenerationControls;
        this.projectGenerationGroup.layout();
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        String projectFieldContents = this.getProjectNameFieldValue();
        if (projectFieldContents.equals(EMPTY_STRING)) {
            this.setErrorMessage(null);
            this.setMessage(Messages.WizardNewProjectCreationPage_projectNameEmpty);
            return false;
        }
        IStatus nameStatus = workspace.validateName(projectFieldContents, 4);
        if (!nameStatus.isOK()) {
            this.setErrorMessage(nameStatus.getMessage());
            return false;
        }
        IProject handle = this.getProjectHandle();
        if (handle.exists()) {
            this.setErrorMessage(Messages.WizardNewProjectCreationPage_projectExistsMessage);
            return false;
        }
        String validLocationMessage = this.checkValidLocation();
        if (validLocationMessage != null) {
            this.setErrorMessage(validLocationMessage);
            return false;
        }
        validLocationMessage = this.checkValidGitLocation();
        if (validLocationMessage != null) {
            this.setErrorMessage(validLocationMessage);
            return false;
        }
        if (this.warningLabel != null) {
            this.warningLabel.setText(EMPTY_STRING);
        }
        File locationFile = this.getLocationPath().toFile();
        if (!this.useDefaults() && locationFile.exists() && (files = locationFile.list()) != null && files.length > 0) {
            this.warningLabel.setText(Messages.WizardNewProjectCreationPage_location_has_existing_content_warning);
            this.warningLabel.getParent().layout(true);
        }
        this.setErrorMessage(null);
        this.setMessage(null);
        return true;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.projectNameField.setFocus();
        }
    }

    public boolean isCloneFromGit() {
        return this.gitCloneGenerate.getSelection();
    }

    public String getCloneURI() {
        return this.gitLocation.getText().trim();
    }

    public boolean useDefaults() {
        IPath platformDefaultLocation = Platform.getLocation();
        IPath selectedPath = Path.fromOSString((String)this.locationPathField.getText().trim());
        return platformDefaultLocation.isPrefixOf(selectedPath);
    }

    protected void selectGitCloneGeneration() {
        this.noGenerator.setSelection(false);
        this.gitCloneGenerate.setSelection(true);
    }

    public String getStepName() {
        return Messages.NewRubyProject_stepName;
    }

    public void initStepIndicator(String[] stepNames) {
        this.stepNames = stepNames;
    }

    private abstract class SpecialText
    extends StyledText {
        protected boolean justGainedFocus;

        public SpecialText(Composite parent, int style) {
            super(parent, style);
            this.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    if (!SpecialText.this.matchesLastDefault()) {
                        SpecialText.this.setStyleRange(new StyleRange(0, SpecialText.this.getCharCount(), null, null));
                    } else {
                        SpecialText.this.setStyleRange(new StyleRange(0, SpecialText.this.getCharCount(), SpecialText.this.getShell().getDisplay().getSystemColor(16), null, 2));
                    }
                }
            });
            this.addFocusListener((FocusListener)new FocusAdapter(){

                public void focusGained(FocusEvent e) {
                    super.focusGained(e);
                    if (SpecialText.this.isDefault()) {
                        SpecialText.this.selectAll();
                        SpecialText.this.justGainedFocus = true;
                    }
                }
            });
            this.addMouseListener(new MouseListener(){

                public void mouseUp(MouseEvent e) {
                }

                public void mouseDown(MouseEvent e) {
                    if (SpecialText.this.justGainedFocus) {
                        SpecialText.this.justGainedFocus = false;
                        SpecialText.this.selectAll();
                    }
                }

                public void mouseDoubleClick(MouseEvent e) {
                }
            });
        }

        protected abstract boolean matchesLastDefault();

        protected abstract boolean isDefault();
    }
}

