/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ruby.ui.wizards;

import com.aptana.core.projects.templates.TemplateType;
import com.aptana.projects.wizards.AbstractNewProjectWizard;
import com.aptana.ruby.ui.RubyUIPlugin;
import com.aptana.ruby.ui.wizards.Messages;
import com.aptana.ruby.ui.wizards.WizardNewRubyProjectCreationPage;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.ui.IWorkbench;

public class NewRubyProjectWizard
extends AbstractNewProjectWizard
implements IExecutableExtension {
    private boolean cloneFromGit;
    private String cloneSourceURI;

    protected void initDialogSettings() {
        IDialogSettings workbenchSettings = RubyUIPlugin.getDefault().getDialogSettings();
        IDialogSettings section = workbenchSettings.getSection("BasicNewProjectResourceWizard");
        if (section == null) {
            section = workbenchSettings.addNewSection("BasicNewProjectResourceWizard");
        }
        this.setDialogSettings(section);
    }

    protected WizardNewRubyProjectCreationPage createMainPage() {
        WizardNewRubyProjectCreationPage mainPage = new WizardNewRubyProjectCreationPage("basicNewProjectPage", this.selectedTemplate);
        mainPage.setTitle(Messages.NewProject_title);
        mainPage.setDescription(Messages.NewRubyProject_description);
        mainPage.setWizard((IWizard)this);
        mainPage.setPageComplete(false);
        return mainPage;
    }

    protected void initializeDefaultPageImageDescriptor() {
        ImageDescriptor desc = RubyUIPlugin.imageDescriptorFromPlugin((String)RubyUIPlugin.getPluginIdentifier(), (String)"icons/newproj_wiz.png");
        this.setDefaultPageImageDescriptor(desc);
    }

    protected String[] getProjectNatures() {
        return new String[]{"com.aptana.ruby.core.rubynature", "com.aptana.projects.webnature"};
    }

    protected String getProjectCreateEventName() {
        return "project.create.ruby";
    }

    protected TemplateType[] getProjectTemplateTypes() {
        return new TemplateType[]{TemplateType.RUBY};
    }

    protected String[] getProjectBuilders() {
        return new String[]{"com.aptana.ide.core.unifiedBuilder"};
    }

    protected String getProjectCreationDescription() {
        return Messages.NewRubyProject_windowTitle;
    }

    public void init(IWorkbench workbench, IStructuredSelection currentSelection) {
        super.init(workbench, currentSelection);
        this.setWindowTitle(Messages.NewRubyProject_windowTitle);
    }

    protected boolean isCloneFromGit() {
        return this.cloneFromGit || super.isCloneFromGit();
    }

    public boolean performFinish() {
        this.cloneFromGit = this.mainPage.isCloneFromGit();
        this.cloneSourceURI = this.mainPage.getCloneURI();
        return super.performFinish();
    }

    protected void cloneFromGit(IProject newProjectHandle, IProjectDescription description, IProgressMonitor monitor) throws InvocationTargetException {
        if (this.cloneFromGit) {
            this.doCloneFromGit(this.cloneSourceURI, newProjectHandle, description, monitor);
        } else {
            super.cloneFromGit(newProjectHandle, description, monitor);
        }
    }
}

