/*
 * Decompiled with CFR 0.152.
 */
package org.jrubyparser.rewriter;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jrubyparser.NodeVisitor;
import org.jrubyparser.RegexpOptions;
import org.jrubyparser.SourcePosition;
import org.jrubyparser.StaticScope;
import org.jrubyparser.ast.AliasNode;
import org.jrubyparser.ast.AndNode;
import org.jrubyparser.ast.ArgsCatNode;
import org.jrubyparser.ast.ArgsNode;
import org.jrubyparser.ast.ArgsPushNode;
import org.jrubyparser.ast.ArgumentNode;
import org.jrubyparser.ast.ArrayNode;
import org.jrubyparser.ast.AssignableNode;
import org.jrubyparser.ast.AttrAssignNode;
import org.jrubyparser.ast.BackRefNode;
import org.jrubyparser.ast.BeginNode;
import org.jrubyparser.ast.BignumNode;
import org.jrubyparser.ast.BlockArg18Node;
import org.jrubyparser.ast.BlockArgNode;
import org.jrubyparser.ast.BlockNode;
import org.jrubyparser.ast.BlockPassNode;
import org.jrubyparser.ast.BreakNode;
import org.jrubyparser.ast.CallNode;
import org.jrubyparser.ast.CaseNode;
import org.jrubyparser.ast.ClassNode;
import org.jrubyparser.ast.ClassVarAsgnNode;
import org.jrubyparser.ast.ClassVarDeclNode;
import org.jrubyparser.ast.ClassVarNode;
import org.jrubyparser.ast.Colon2Node;
import org.jrubyparser.ast.Colon3Node;
import org.jrubyparser.ast.CommentNode;
import org.jrubyparser.ast.ConstDeclNode;
import org.jrubyparser.ast.ConstNode;
import org.jrubyparser.ast.DAsgnNode;
import org.jrubyparser.ast.DRegexpNode;
import org.jrubyparser.ast.DStrNode;
import org.jrubyparser.ast.DSymbolNode;
import org.jrubyparser.ast.DVarNode;
import org.jrubyparser.ast.DXStrNode;
import org.jrubyparser.ast.DefinedNode;
import org.jrubyparser.ast.DefnNode;
import org.jrubyparser.ast.DefsNode;
import org.jrubyparser.ast.DotNode;
import org.jrubyparser.ast.EncodingNode;
import org.jrubyparser.ast.EnsureNode;
import org.jrubyparser.ast.EvStrNode;
import org.jrubyparser.ast.FCallNode;
import org.jrubyparser.ast.FalseNode;
import org.jrubyparser.ast.FixnumNode;
import org.jrubyparser.ast.FlipNode;
import org.jrubyparser.ast.FloatNode;
import org.jrubyparser.ast.ForNode;
import org.jrubyparser.ast.GlobalAsgnNode;
import org.jrubyparser.ast.GlobalVarNode;
import org.jrubyparser.ast.HashNode;
import org.jrubyparser.ast.INameNode;
import org.jrubyparser.ast.IfNode;
import org.jrubyparser.ast.InstAsgnNode;
import org.jrubyparser.ast.InstVarNode;
import org.jrubyparser.ast.IterNode;
import org.jrubyparser.ast.LiteralNode;
import org.jrubyparser.ast.LocalAsgnNode;
import org.jrubyparser.ast.LocalVarNode;
import org.jrubyparser.ast.Match2Node;
import org.jrubyparser.ast.Match3Node;
import org.jrubyparser.ast.MatchNode;
import org.jrubyparser.ast.ModuleNode;
import org.jrubyparser.ast.MultipleAsgn19Node;
import org.jrubyparser.ast.MultipleAsgnNode;
import org.jrubyparser.ast.NewlineNode;
import org.jrubyparser.ast.NextNode;
import org.jrubyparser.ast.NilNode;
import org.jrubyparser.ast.Node;
import org.jrubyparser.ast.NotNode;
import org.jrubyparser.ast.NthRefNode;
import org.jrubyparser.ast.OpAsgnAndNode;
import org.jrubyparser.ast.OpAsgnNode;
import org.jrubyparser.ast.OpAsgnOrNode;
import org.jrubyparser.ast.OpElementAsgnNode;
import org.jrubyparser.ast.OrNode;
import org.jrubyparser.ast.PostExeNode;
import org.jrubyparser.ast.PreExeNode;
import org.jrubyparser.ast.RedoNode;
import org.jrubyparser.ast.RegexpNode;
import org.jrubyparser.ast.RescueBodyNode;
import org.jrubyparser.ast.RescueNode;
import org.jrubyparser.ast.RestArgNode;
import org.jrubyparser.ast.RetryNode;
import org.jrubyparser.ast.ReturnNode;
import org.jrubyparser.ast.RootNode;
import org.jrubyparser.ast.SClassNode;
import org.jrubyparser.ast.SValueNode;
import org.jrubyparser.ast.SelfNode;
import org.jrubyparser.ast.SplatNode;
import org.jrubyparser.ast.StrNode;
import org.jrubyparser.ast.SuperNode;
import org.jrubyparser.ast.SymbolNode;
import org.jrubyparser.ast.ToAryNode;
import org.jrubyparser.ast.TrueNode;
import org.jrubyparser.ast.UndefNode;
import org.jrubyparser.ast.UntilNode;
import org.jrubyparser.ast.VAliasNode;
import org.jrubyparser.ast.VCallNode;
import org.jrubyparser.ast.WhenNode;
import org.jrubyparser.ast.WhileNode;
import org.jrubyparser.ast.XStrNode;
import org.jrubyparser.ast.YieldNode;
import org.jrubyparser.ast.ZArrayNode;
import org.jrubyparser.ast.ZSuperNode;
import org.jrubyparser.rewriter.ClassBodyWriter;
import org.jrubyparser.rewriter.DefaultFormatHelper;
import org.jrubyparser.rewriter.FormatHelper;
import org.jrubyparser.rewriter.ReWriterFactory;
import org.jrubyparser.rewriter.utils.Operators;
import org.jrubyparser.rewriter.utils.ReWriterContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReWriteVisitor
implements NodeVisitor {
    protected final ReWriterContext config;
    protected final ReWriterFactory factory;

    public ReWriteVisitor(Writer out, String source) {
        this(new ReWriterContext(new PrintWriter(out), source, (FormatHelper)new DefaultFormatHelper()));
    }

    public ReWriteVisitor(OutputStream out, String source) {
        this(new ReWriterContext(new PrintWriter(out, true), source, (FormatHelper)new DefaultFormatHelper()));
    }

    public ReWriteVisitor(ReWriterContext config) {
        this.config = config;
        this.factory = new ReWriterFactory(config);
    }

    public void flushStream() {
        this.config.getOutput().flush();
    }

    protected void print(String s) {
        this.config.getOutput().print(s);
    }

    protected void print(char c) {
        this.config.getOutput().print(c);
    }

    protected void print(BigInteger i) {
        this.config.getOutput().print(i);
    }

    protected void print(int i) {
        this.config.getOutput().print(i);
    }

    protected void print(long l) {
        this.config.getOutput().print(l);
    }

    protected void print(double d) {
        this.config.getOutput().print(d);
    }

    private void enterCall() {
        this.config.getCallDepth().enterCall();
    }

    private void leaveCall() {
        this.config.getCallDepth().leaveCall();
    }

    private boolean inCall() {
        return this.config.getCallDepth().inCall();
    }

    protected void printNewlineAndIndentation() {
        if (this.config.hasHereDocument()) {
            this.config.fetchHereDocument().print();
        }
        this.print(this.config.getFormatHelper().getLineDelimiter());
        this.config.getIndentor().printIndentation(this.config.getOutput());
    }

    private static boolean isReceiverACallNode(CallNode n) {
        return n.getReceiverNode() instanceof CallNode || n.getReceiverNode() instanceof FCallNode;
    }

    private void printCommentsBefore(Node iVisited) {
        for (CommentNode n : iVisited.getComments()) {
            if (ReWriteVisitor.getStartLine(n) >= ReWriteVisitor.getStartLine(iVisited)) continue;
            this.visitNode(n);
            this.print(n.getContent());
            this.printNewlineAndIndentation();
        }
    }

    protected boolean printCommentsAfter(Node iVisited) {
        boolean hasComment = false;
        for (CommentNode n : iVisited.getComments()) {
            if (ReWriteVisitor.getStartLine(n) < ReWriteVisitor.getEndLine(iVisited)) continue;
            this.print(' ');
            this.visitNode(n);
            this.print(n.getContent());
            hasComment = true;
        }
        return hasComment;
    }

    public void visitNode(Node iVisited) {
        if (iVisited == null || iVisited.isInvisible()) {
            return;
        }
        this.printCommentsBefore(iVisited);
        if (iVisited instanceof ArgumentNode) {
            this.print(((ArgumentNode)iVisited).getName());
        } else {
            iVisited.accept(this);
        }
        this.printCommentsAfter(iVisited);
        this.config.setLastPosition(iVisited.getPosition());
    }

    public void visitIter(Iterator iterator) {
        while (iterator.hasNext()) {
            this.visitNode((Node)iterator.next());
        }
    }

    private void visitIterAndSkipFirst(Iterator iterator) {
        iterator.next();
        this.visitIter(iterator);
    }

    private static boolean isStartOnNewLine(Node first, Node second) {
        if (first == null || second == null) {
            return false;
        }
        return ReWriteVisitor.getStartLine(first) < ReWriteVisitor.getStartLine(second);
    }

    private boolean needsParentheses(Node n) {
        return n != null && (n.childNodes().size() > 1 || this.inCall() || ReWriteVisitor.firstChild(n) instanceof HashNode) || ReWriteVisitor.firstChild(n) instanceof NewlineNode || ReWriteVisitor.firstChild(n) instanceof IfNode;
    }

    private void printCallArguments(Node argsNode, Node iterNode) {
        boolean paranthesesPrinted;
        if (argsNode != null && argsNode.childNodes().size() < 1 && iterNode == null) {
            return;
        }
        if (argsNode != null && argsNode.childNodes().size() == 1 && ReWriteVisitor.firstChild(argsNode) instanceof HashNode && iterNode == null) {
            HashNode hashNode = (HashNode)ReWriteVisitor.firstChild(argsNode);
            if (hashNode.getListNode().childNodes().size() < 1) {
                this.print("({})");
            } else {
                this.print(' ');
                this.printHashNodeContent(hashNode);
            }
            return;
        }
        boolean bl = paranthesesPrinted = this.needsParentheses(argsNode) || argsNode == null && iterNode != null && iterNode instanceof BlockPassNode || argsNode != null && argsNode.childNodes().size() > 0 && iterNode != null;
        if (paranthesesPrinted) {
            this.print('(');
        } else if (argsNode != null) {
            this.print(this.config.getFormatHelper().beforeCallArguments());
        }
        if (ReWriteVisitor.firstChild(argsNode) instanceof NewlineNode) {
            this.config.setSkipNextNewline(true);
        }
        this.enterCall();
        if (argsNode instanceof SplatNode) {
            this.visitNode(argsNode);
        } else if (argsNode != null) {
            this.visitAndPrintWithSeparator(argsNode.childNodes().iterator());
        }
        if (iterNode instanceof BlockPassNode) {
            if (argsNode != null) {
                this.print(this.config.getFormatHelper().getListSeparator());
            }
            this.print('&');
            this.visitNode(((BlockPassNode)iterNode).getBodyNode());
        }
        if (paranthesesPrinted) {
            this.print(')');
        } else {
            this.print(this.config.getFormatHelper().afterCallArguments());
        }
        this.leaveCall();
    }

    public void visitAndPrintWithSeparator(Iterator<Node> it) {
        while (it.hasNext()) {
            Node n = it.next();
            this.factory.createIgnoreCommentsReWriteVisitor().visitNode(n);
            if (it.hasNext()) {
                this.print(this.config.getFormatHelper().getListSeparator());
            }
            if (!n.hasComments()) continue;
            this.factory.createReWriteVisitor().visitIter(n.getComments().iterator());
            this.printNewlineAndIndentation();
        }
    }

    @Override
    public Object visitAliasNode(AliasNode iVisited) {
        this.print("alias ");
        this.visitNode(iVisited.getNewName());
        this.print(' ');
        this.visitNode(iVisited.getOldName());
        this.printCommentsAtEnd(iVisited);
        return null;
    }

    private boolean sourceRangeEquals(int start, int stop, String compare) {
        return stop <= this.config.getSource().length() && this.sourceSubStringEquals(start, stop - start, compare);
    }

    private boolean sourceRangeContains(SourcePosition pos, String searched) {
        return pos.getStartOffset() < this.config.getSource().length() && pos.getEndOffset() < this.config.getSource().length() + 1 && this.config.getSource().substring(pos.getStartOffset(), pos.getEndOffset()).indexOf(searched) > -1;
    }

    @Override
    public Object visitAndNode(AndNode iVisited) {
        this.enterCall();
        this.visitNode(iVisited.getFirstNode());
        if (this.sourceRangeContains(iVisited.getPosition(), "&&")) {
            this.print(" && ");
        } else {
            this.print(" and ");
        }
        this.visitNode(iVisited.getSecondNode());
        this.leaveCall();
        return null;
    }

    private ArrayList<Node> collectAllArguments(ArgsNode iVisited) {
        ArrayList<Node> arguments = new ArrayList<Node>();
        if (iVisited.getPre() != null) {
            arguments.addAll(iVisited.getPre().childNodes());
        }
        if (iVisited.getOptional() != null) {
            arguments.addAll(iVisited.getOptional().childNodes());
        }
        if (iVisited.getRest() != null) {
            arguments.add(new ConstNode(iVisited.getRest().getPosition(), String.valueOf('*') + iVisited.getRest().getName()));
        }
        if (iVisited.getPost() != null) {
            arguments.addAll(iVisited.getPost().childNodes());
        }
        if (iVisited.getBlock() != null) {
            arguments.add(iVisited.getBlock());
        }
        return arguments;
    }

    private boolean hasNodeCommentsAtEnd(Node n) {
        for (Node node : n.getComments()) {
            if (ReWriteVisitor.getStartLine(node) != ReWriteVisitor.getStartLine(n)) continue;
            return true;
        }
        return false;
    }

    private void printCommentsInArgs(Node n, boolean hasNext) {
        if (this.hasNodeCommentsAtEnd(n) && hasNext) {
            this.print(",");
        }
        if (this.printCommentsAfter(n) && hasNext) {
            this.printNewlineAndIndentation();
        } else if (hasNext) {
            this.print(this.config.getFormatHelper().getListSeparator());
        }
    }

    @Override
    public Object visitArgsNode(ArgsNode iVisited) {
        Iterator<Node> it = this.collectAllArguments(iVisited).iterator();
        while (it.hasNext()) {
            Node n = it.next();
            if (n instanceof ArgumentNode) {
                this.print(((ArgumentNode)n).getName());
                this.printCommentsInArgs(n, it.hasNext());
            } else {
                this.visitNode(n);
                if (it.hasNext()) {
                    this.print(this.config.getFormatHelper().getListSeparator());
                }
            }
            if (it.hasNext()) continue;
            this.print(this.config.getFormatHelper().afterMethodArguments());
        }
        return null;
    }

    @Override
    public Object visitArgsCatNode(ArgsCatNode iVisited) {
        this.print("[");
        this.visitAndPrintWithSeparator(iVisited.getFirstNode().childNodes().iterator());
        this.print(this.config.getFormatHelper().getListSeparator());
        this.print("*");
        this.visitNode(iVisited.getSecondNode());
        this.print("]");
        return null;
    }

    @Override
    public Object visitArrayNode(ArrayNode iVisited) {
        this.print('[');
        this.enterCall();
        this.visitAndPrintWithSeparator(iVisited.childNodes().iterator());
        this.leaveCall();
        this.print(']');
        return null;
    }

    @Override
    public Object visitBackRefNode(BackRefNode iVisited) {
        this.print('$');
        this.print(iVisited.getType());
        return null;
    }

    @Override
    public Object visitBeginNode(BeginNode iVisited) {
        this.print("begin");
        this.visitNodeInIndentation(iVisited.getBodyNode());
        this.printNewlineAndIndentation();
        this.print("end");
        return null;
    }

    @Override
    public Object visitBignumNode(BignumNode iVisited) {
        this.print(iVisited.getValue());
        return null;
    }

    @Override
    public Object visitBlockArgNode(BlockArgNode iVisited) {
        this.print('&');
        this.print(iVisited.getName());
        return null;
    }

    @Override
    public Object visitBlockArg18Node(BlockArg18Node iVisited) {
        this.print('&');
        this.visitNode(iVisited.getBlockArg());
        return null;
    }

    @Override
    public Object visitBlockNode(BlockNode iVisited) {
        this.visitIter(iVisited.childNodes().iterator());
        return null;
    }

    public static int getLocalVarIndex(Node n) {
        return n instanceof LocalVarNode ? ((LocalVarNode)n).getIndex() : -1;
    }

    @Override
    public Object visitBlockPassNode(BlockPassNode iVisited) {
        this.visitNode(iVisited.getBodyNode());
        return null;
    }

    @Override
    public Object visitBreakNode(BreakNode iVisited) {
        this.print("break");
        return null;
    }

    @Override
    public Object visitConstDeclNode(ConstDeclNode iVisited) {
        this.printAsgnNode(iVisited);
        return null;
    }

    @Override
    public Object visitClassVarAsgnNode(ClassVarAsgnNode iVisited) {
        this.printAsgnNode(iVisited);
        return null;
    }

    @Override
    public Object visitClassVarDeclNode(ClassVarDeclNode iVisited) {
        this.printAsgnNode(iVisited);
        return null;
    }

    @Override
    public Object visitClassVarNode(ClassVarNode iVisited) {
        this.print(iVisited.getName());
        return null;
    }

    private boolean isNumericNode(Node n) {
        return n != null && (n instanceof FixnumNode || n instanceof BignumNode);
    }

    private boolean isNameAnOperator(String name) {
        return Operators.contain(name);
    }

    private boolean printSpaceInsteadOfDot(CallNode n) {
        return this.isNameAnOperator(n.getName()) && n.getArgsNode().childNodes().size() <= 1;
    }

    protected void printAssignmentOperator() {
        this.print(this.config.getFormatHelper().beforeAssignment());
        this.print("=");
        this.print(this.config.getFormatHelper().afterAssignment());
    }

    private Object printIndexAssignment(AttrAssignNode iVisited) {
        this.enterCall();
        this.visitNode(iVisited.getReceiverNode());
        this.leaveCall();
        this.print('[');
        this.visitNode(ReWriteVisitor.firstChild(iVisited.getArgsNode()));
        this.print("]");
        this.printAssignmentOperator();
        if (iVisited.getArgsNode().childNodes().size() > 1) {
            this.visitNode(iVisited.getArgsNode().childNodes().get(1));
        }
        return null;
    }

    private Object printIndexAccess(CallNode visited) {
        this.enterCall();
        this.visitNode(visited.getReceiverNode());
        this.leaveCall();
        this.print('[');
        if (visited.getArgsNode() != null) {
            this.visitAndPrintWithSeparator(visited.getArgsNode().childNodes().iterator());
        }
        this.print("]");
        return null;
    }

    private Object printNegativNumericNode(CallNode visited) {
        this.print('-');
        this.visitNode(visited.getReceiverNode());
        return null;
    }

    private boolean isNegativeNumericNode(CallNode visited) {
        return this.isNumericNode(visited.getReceiverNode()) && visited.getName().equals("-@");
    }

    private void printCallReceiverNode(CallNode iVisited) {
        if (iVisited.getReceiverNode() instanceof HashNode) {
            this.print('(');
        }
        if (ReWriteVisitor.isReceiverACallNode(iVisited) && !this.printSpaceInsteadOfDot(iVisited)) {
            this.enterCall();
            this.visitNewlineInParentheses(iVisited.getReceiverNode());
            this.leaveCall();
        } else {
            this.visitNewlineInParentheses(iVisited.getReceiverNode());
        }
        if (iVisited.getReceiverNode() instanceof HashNode) {
            this.print(')');
        }
    }

    protected boolean inMultipleAssignment() {
        return false;
    }

    @Override
    public Object visitCallNode(CallNode iVisited) {
        if (this.isNegativeNumericNode(iVisited)) {
            return this.printNegativNumericNode(iVisited);
        }
        if (iVisited.getName().equals("[]")) {
            return this.printIndexAccess(iVisited);
        }
        this.printCallReceiverNode(iVisited);
        this.print(this.printSpaceInsteadOfDot(iVisited) ? (char)' ' : '.');
        if (this.inMultipleAssignment() && iVisited.getName().endsWith("=")) {
            this.print(iVisited.getName().substring(0, iVisited.getName().length() - 1));
        } else {
            this.print(iVisited.getName());
        }
        if (this.isNameAnOperator(iVisited.getName())) {
            if (ReWriteVisitor.firstChild(iVisited.getArgsNode()) instanceof NewlineNode) {
                this.print(' ');
            }
            this.config.getCallDepth().disableCallDepth();
        }
        this.printCallArguments(iVisited.getArgsNode(), iVisited.getIterNode());
        if (this.isNameAnOperator(iVisited.getName())) {
            this.config.getCallDepth().enableCallDepth();
        }
        if (!(iVisited.getIterNode() instanceof BlockPassNode)) {
            this.visitNode(iVisited.getIterNode());
        }
        return null;
    }

    @Override
    public Object visitCaseNode(CaseNode iVisited) {
        this.print("case ");
        this.visitNode(iVisited.getCaseNode());
        this.visitNode(iVisited.getFirstWhenNode());
        this.printNewlineAndIndentation();
        this.print("end");
        return null;
    }

    private boolean printCommentsIn(Node iVisited) {
        boolean hadComment = false;
        for (CommentNode n : iVisited.getComments()) {
            if (ReWriteVisitor.getStartLine(n) <= ReWriteVisitor.getStartLine(iVisited) || ReWriteVisitor.getEndLine(n) >= ReWriteVisitor.getEndLine(iVisited)) continue;
            hadComment = true;
            this.visitNode(n);
            this.print(n.getContent());
            this.printNewlineAndIndentation();
        }
        return hadComment;
    }

    @Override
    public Object visitClassNode(ClassNode iVisited) {
        this.print("class ");
        this.visitNode(iVisited.getCPath());
        if (iVisited.getSuperNode() != null) {
            this.print(" < ");
            this.visitNode(iVisited.getSuperNode());
        }
        new ClassBodyWriter(this, iVisited.getBodyNode()).write();
        this.printNewlineAndIndentation();
        this.printCommentsIn(iVisited);
        this.print("end");
        return null;
    }

    @Override
    public Object visitColon2Node(Colon2Node iVisited) {
        if (iVisited.getLeftNode() != null) {
            this.visitNode(iVisited.getLeftNode());
            this.print("::");
        }
        this.print(iVisited.getName());
        return null;
    }

    @Override
    public Object visitColon3Node(Colon3Node iVisited) {
        this.print("::");
        this.print(iVisited.getName());
        return null;
    }

    @Override
    public Object visitConstNode(ConstNode iVisited) {
        this.print(iVisited.getName());
        return null;
    }

    @Override
    public Object visitDAsgnNode(DAsgnNode iVisited) {
        this.printAsgnNode(iVisited);
        return null;
    }

    @Override
    public Object visitDRegxNode(DRegexpNode iVisited) {
        this.config.getPrintQuotesInString().set(false);
        this.print(this.getFirstRegexpEnclosure(iVisited));
        this.factory.createDRegxReWriteVisitor().visitIter(iVisited.childNodes().iterator());
        this.print(this.getSecondRegexpEnclosure(iVisited));
        this.printRegexpOptions(iVisited.getOptions());
        this.config.getPrintQuotesInString().revert();
        return null;
    }

    private Object createHereDocument(DStrNode iVisited) {
        this.config.getPrintQuotesInString().set(false);
        this.print("<<-EOF");
        StringWriter writer = new StringWriter();
        PrintWriter oldOut = this.config.getOutput();
        this.config.setOutput(new PrintWriter(writer));
        Iterator<Node> it = iVisited.childNodes().iterator();
        while (it.hasNext()) {
            this.factory.createHereDocReWriteVisitor().visitNode(it.next());
            if (!it.hasNext()) continue;
            this.config.setSkipNextNewline(true);
        }
        this.config.setOutput(oldOut);
        this.config.depositHereDocument(writer.getBuffer().toString());
        this.config.getPrintQuotesInString().revert();
        return null;
    }

    @Override
    public Object visitDStrNode(DStrNode iVisited) {
        if (ReWriteVisitor.firstChild(iVisited) instanceof StrNode && this.stringIsHereDocument((StrNode)ReWriteVisitor.firstChild(iVisited))) {
            return this.createHereDocument(iVisited);
        }
        if (this.config.getPrintQuotesInString().isTrue()) {
            this.print(this.getSeparatorForStr(iVisited));
        }
        this.config.getPrintQuotesInString().set(false);
        this.leaveCall();
        for (Node child : iVisited.childNodes()) {
            this.visitNode(child);
        }
        this.enterCall();
        this.config.getPrintQuotesInString().revert();
        if (this.config.getPrintQuotesInString().isTrue()) {
            this.print(this.getSeparatorForStr(iVisited));
        }
        return null;
    }

    @Override
    public Object visitDSymbolNode(DSymbolNode iVisited) {
        this.print(':');
        if (this.config.getPrintQuotesInString().isTrue()) {
            this.print(this.getSeparatorForSym(iVisited));
        }
        this.config.getPrintQuotesInString().set(false);
        this.leaveCall();
        for (Node child : iVisited.childNodes()) {
            this.visitNode(child);
        }
        this.enterCall();
        this.config.getPrintQuotesInString().revert();
        if (this.config.getPrintQuotesInString().isTrue()) {
            this.print(this.getSeparatorForSym(iVisited));
        }
        return null;
    }

    @Override
    public Object visitDVarNode(DVarNode iVisited) {
        this.print(iVisited.getName());
        return null;
    }

    @Override
    public Object visitDXStrNode(DXStrNode iVisited) {
        this.config.getPrintQuotesInString().set(false);
        this.print("%x{");
        this.visitIter(iVisited.childNodes().iterator());
        this.print('}');
        this.config.getPrintQuotesInString().revert();
        return null;
    }

    @Override
    public Object visitDefinedNode(DefinedNode iVisited) {
        this.print("defined? ");
        this.enterCall();
        this.visitNode(iVisited.getExpressionNode());
        this.leaveCall();
        return null;
    }

    private boolean hasArguments(Node n) {
        if (n instanceof ArgsNode) {
            ArgsNode args = (ArgsNode)n;
            return args.getPre() != null || args.getOptional() != null || args.getBlock() != null || args.getRest() != null;
        }
        return !(n instanceof ArrayNode) || !n.childNodes().isEmpty();
    }

    protected void printCommentsAtEnd(Node n) {
        for (CommentNode comment : n.getComments()) {
            if (ReWriteVisitor.getStartLine(n) != ReWriteVisitor.getStartLine(comment)) continue;
            this.print(' ');
            this.visitNode(comment);
            this.print(comment.getContent());
        }
    }

    private void printDefNode(Node parent, String name, Node args, StaticScope scope, Node bodyNode) {
        this.print(name);
        this.config.getLocalVariables().addLocalVariable(scope);
        if (this.hasArguments(args)) {
            this.print(this.config.getFormatHelper().beforeMethodArguments());
            this.visitNode(args);
        }
        this.printCommentsAtEnd(parent);
        this.visitNode(bodyNode);
        this.config.getIndentor().outdent();
        this.printNewlineAndIndentation();
        this.printCommentsIn(parent);
        this.print("end");
    }

    @Override
    public Object visitDefnNode(DefnNode iVisited) {
        this.config.getIndentor().indent();
        this.print("def ");
        this.printDefNode(iVisited, iVisited.getName(), iVisited.getArgsNode(), iVisited.getScope(), iVisited.getBodyNode());
        return null;
    }

    @Override
    public Object visitDefsNode(DefsNode iVisited) {
        this.config.getIndentor().indent();
        this.print("def ");
        this.visitNode(iVisited.getReceiverNode());
        this.print('.');
        this.printDefNode(iVisited, iVisited.getName(), iVisited.getArgsNode(), iVisited.getScope(), iVisited.getBodyNode());
        return null;
    }

    @Override
    public Object visitDotNode(DotNode iVisited) {
        this.enterCall();
        this.visitNode(iVisited.getBeginNode());
        this.print("..");
        if (iVisited.isExclusive()) {
            this.print('.');
        }
        this.visitNode(iVisited.getEndNode());
        this.leaveCall();
        return null;
    }

    @Override
    public Object visitEnsureNode(EnsureNode iVisited) {
        this.visitNode(iVisited.getBodyNode());
        this.config.getIndentor().outdent();
        this.printNewlineAndIndentation();
        this.print("ensure");
        this.visitNodeInIndentation(iVisited.getEnsureNode());
        this.config.getIndentor().indent();
        return null;
    }

    @Override
    public Object visitEvStrNode(EvStrNode iVisited) {
        this.print('#');
        if (!(iVisited.getBody() instanceof NthRefNode)) {
            this.print('{');
        }
        this.config.getPrintQuotesInString().set(true);
        this.visitNode(this.unwrapNewlineNode(iVisited.getBody()));
        this.config.getPrintQuotesInString().revert();
        if (!(iVisited.getBody() instanceof NthRefNode)) {
            this.print('}');
        }
        return null;
    }

    private Node unwrapNewlineNode(Node node) {
        return node instanceof NewlineNode ? ((NewlineNode)node).getNextNode() : node;
    }

    @Override
    public Object visitFCallNode(FCallNode iVisited) {
        this.print(iVisited.getName());
        if (iVisited.getIterNode() != null) {
            this.config.getCallDepth().enterCall();
        }
        this.printCallArguments(iVisited.getArgsNode(), iVisited.getIterNode());
        if (iVisited.getIterNode() != null) {
            this.config.getCallDepth().leaveCall();
        }
        if (!(iVisited.getIterNode() instanceof BlockPassNode)) {
            this.visitNode(iVisited.getIterNode());
        }
        return null;
    }

    @Override
    public Object visitFalseNode(FalseNode iVisited) {
        this.print("false");
        return null;
    }

    @Override
    public Object visitFixnumNode(FixnumNode iVisited) {
        this.print(iVisited.getValue());
        return null;
    }

    @Override
    public Object visitFlipNode(FlipNode iVisited) {
        this.enterCall();
        this.visitNode(iVisited.getBeginNode());
        this.print(" ..");
        if (iVisited.isExclusive()) {
            this.print('.');
        }
        this.print(' ');
        this.visitNode(iVisited.getEndNode());
        this.leaveCall();
        return null;
    }

    @Override
    public Object visitFloatNode(FloatNode iVisited) {
        this.print(iVisited.getValue());
        return null;
    }

    @Override
    public Object visitForNode(ForNode iVisited) {
        this.print("for ");
        this.visitNode(iVisited.getVarNode());
        this.print(" in ");
        this.visitNode(iVisited.getIterNode());
        this.visitNodeInIndentation(iVisited.getBodyNode());
        this.printNewlineAndIndentation();
        this.print("end");
        return null;
    }

    @Override
    public Object visitGlobalAsgnNode(GlobalAsgnNode iVisited) {
        this.printAsgnNode(iVisited);
        return null;
    }

    @Override
    public Object visitGlobalVarNode(GlobalVarNode iVisited) {
        this.print(iVisited.getName());
        return null;
    }

    private void printHashNodeContent(HashNode iVisited) {
        this.print(this.config.getFormatHelper().beforeHashContent());
        if (iVisited.getListNode() != null) {
            Iterator<Node> it = iVisited.getListNode().childNodes().iterator();
            while (it.hasNext()) {
                this.visitNode(it.next());
                this.print(this.config.getFormatHelper().hashAssignment());
                this.visitNode(it.next());
                if (!it.hasNext()) continue;
                this.print(this.config.getFormatHelper().getListSeparator());
            }
        }
        this.print(this.config.getFormatHelper().afterHashContent());
    }

    @Override
    public Object visitHashNode(HashNode iVisited) {
        this.print('{');
        this.printHashNodeContent(iVisited);
        this.print('}');
        return null;
    }

    private void printAsgnNode(AssignableNode n) {
        this.print(((INameNode)((Object)n)).getName());
        if (n.getValueNode() == null || n.getValueNode().isInvisible()) {
            return;
        }
        this.printAssignmentOperator();
        this.visitNewlineInParentheses(n.getValueNode());
    }

    @Override
    public Object visitInstAsgnNode(InstAsgnNode iVisited) {
        this.printAsgnNode(iVisited);
        return null;
    }

    @Override
    public Object visitInstVarNode(InstVarNode iVisited) {
        this.print(iVisited.getName());
        return null;
    }

    private Node printElsIfNodes(Node iVisited) {
        if (iVisited != null && iVisited instanceof IfNode) {
            IfNode n = (IfNode)iVisited;
            this.printNewlineAndIndentation();
            this.print("elsif ");
            this.visitNode(n.getCondition());
            this.visitNodeInIndentation(n.getThenBody());
            return this.printElsIfNodes(n.getElseBody());
        }
        return iVisited != null ? iVisited : null;
    }

    private Object printShortIfStatement(IfNode n) {
        if (n.getThenBody() == null) {
            this.visitNode(n.getElseBody());
            this.print(" unless ");
            this.visitNode(n.getCondition());
        } else {
            this.enterCall();
            this.factory.createShortIfNodeReWriteVisitor().visitNode(n.getCondition());
            this.print(" ? ");
            this.factory.createShortIfNodeReWriteVisitor().visitNode(n.getThenBody());
            this.print(" : ");
            this.factory.createShortIfNodeReWriteVisitor().visitNewlineInParentheses(n.getElseBody());
            this.leaveCall();
        }
        return null;
    }

    private boolean isAssignment(Node n) {
        return n instanceof DAsgnNode || n instanceof GlobalAsgnNode || n instanceof InstAsgnNode || n instanceof LocalAsgnNode || n instanceof ClassVarAsgnNode;
    }

    private boolean sourceSubStringEquals(int offset, int length, String str) {
        return this.config.getSource().length() >= offset + length && this.config.getSource().substring(offset, offset + length).equals(str);
    }

    private boolean isShortIfStatement(IfNode iVisited) {
        return this.isOnSingleLine(iVisited.getCondition(), iVisited.getElseBody()) && !(iVisited.getElseBody() instanceof IfNode) && !this.sourceSubStringEquals(ReWriteVisitor.getStartOffset(iVisited), 2, "if");
    }

    @Override
    public Object visitIfNode(IfNode iVisited) {
        if (this.isShortIfStatement(iVisited)) {
            return this.printShortIfStatement(iVisited);
        }
        this.print("if ");
        if (this.isAssignment(iVisited.getCondition())) {
            this.enterCall();
        }
        this.visitNewlineInParentheses(iVisited.getCondition());
        if (this.isAssignment(iVisited.getCondition())) {
            this.leaveCall();
        }
        this.config.getIndentor().indent();
        if (!ReWriteVisitor.isStartOnNewLine(iVisited.getCondition(), iVisited.getThenBody()) && iVisited.getThenBody() != null) {
            this.printNewlineAndIndentation();
        }
        this.visitNode(iVisited.getThenBody());
        this.config.getIndentor().outdent();
        Node elseNode = this.printElsIfNodes(iVisited.getElseBody());
        if (elseNode != null) {
            this.printNewlineAndIndentation();
            this.print("else");
            this.config.getIndentor().indent();
            this.visitNode(elseNode);
            this.config.getIndentor().outdent();
        }
        this.printNewlineAndIndentation();
        this.print("end");
        return null;
    }

    private boolean isOnSingleLine(Node n) {
        return this.isOnSingleLine(n, n);
    }

    private boolean isOnSingleLine(Node n1, Node n2) {
        if (n1 == null || n2 == null) {
            return false;
        }
        return ReWriteVisitor.getStartLine(n1) == ReWriteVisitor.getEndLine(n2);
    }

    private boolean printIterVarNode(IterNode n) {
        if (n.getVarNode() == null) {
            return false;
        }
        this.print('|');
        this.visitNode(n.getVarNode());
        this.print('|');
        return true;
    }

    @Override
    public Object visitIterNode(IterNode iVisited) {
        if (this.isOnSingleLine(iVisited)) {
            this.print(this.config.getFormatHelper().beforeIterBrackets());
            this.print("{");
            this.print(this.config.getFormatHelper().beforeIterVars());
            if (this.printIterVarNode(iVisited)) {
                this.print(this.config.getFormatHelper().afterIterVars());
            }
            this.config.setSkipNextNewline(true);
            this.visitNode(iVisited.getBodyNode());
            this.print(this.config.getFormatHelper().beforeClosingIterBrackets());
            this.print('}');
        } else {
            this.print(" do ");
            this.printIterVarNode(iVisited);
            this.visitNodeInIndentation(iVisited.getBodyNode());
            this.printNewlineAndIndentation();
            this.print("end");
        }
        return null;
    }

    @Override
    public Object visitLocalAsgnNode(LocalAsgnNode iVisited) {
        this.config.getLocalVariables().addLocalVariable(iVisited.getIndex(), iVisited.getName());
        this.printAsgnNode(iVisited);
        return null;
    }

    @Override
    public Object visitLocalVarNode(LocalVarNode iVisited) {
        this.print(iVisited.getName());
        return null;
    }

    @Override
    public Object visitMultipleAsgnNode(MultipleAsgnNode iVisited) {
        if (iVisited.getHeadNode() != null) {
            this.factory.createMultipleAssignmentReWriteVisitor().visitAndPrintWithSeparator(iVisited.getHeadNode().childNodes().iterator());
        }
        if (iVisited.getValueNode() == null || iVisited.getValueNode().isInvisible()) {
            this.visitNode(iVisited.getArgsNode());
            return null;
        }
        this.print(this.config.getFormatHelper().beforeAssignment());
        this.print("=");
        this.print(this.config.getFormatHelper().afterAssignment());
        this.enterCall();
        if (iVisited.getValueNode() instanceof ArrayNode) {
            this.visitAndPrintWithSeparator(iVisited.getValueNode().childNodes().iterator());
        } else {
            this.visitNode(iVisited.getValueNode());
        }
        this.leaveCall();
        return null;
    }

    @Override
    public Object visitMultipleAsgnNode(MultipleAsgn19Node iVisited) {
        if (iVisited.getPre() != null) {
            this.factory.createMultipleAssignmentReWriteVisitor().visitAndPrintWithSeparator(iVisited.getPre().childNodes().iterator());
        }
        if (iVisited.getValueNode() == null || iVisited.getValueNode().isInvisible()) {
            this.visitNode(iVisited.getRest());
            return null;
        }
        this.print(this.config.getFormatHelper().beforeAssignment());
        this.print("=");
        this.print(this.config.getFormatHelper().afterAssignment());
        this.enterCall();
        if (iVisited.getValueNode() instanceof ArrayNode) {
            this.visitAndPrintWithSeparator(iVisited.getValueNode().childNodes().iterator());
        } else {
            this.visitNode(iVisited.getValueNode());
        }
        this.leaveCall();
        return null;
    }

    @Override
    public Object visitMatch2Node(Match2Node iVisited) {
        this.visitNode(iVisited.getReceiverNode());
        this.print(this.config.getFormatHelper().matchOperator());
        this.enterCall();
        this.visitNode(iVisited.getValueNode());
        this.leaveCall();
        return null;
    }

    @Override
    public Object visitMatch3Node(Match3Node iVisited) {
        this.visitNode(iVisited.getValueNode());
        this.print(this.config.getFormatHelper().matchOperator());
        this.visitNode(iVisited.getReceiverNode());
        return null;
    }

    @Override
    public Object visitMatchNode(MatchNode iVisited) {
        this.visitNode(iVisited.getRegexpNode());
        return null;
    }

    @Override
    public Object visitModuleNode(ModuleNode iVisited) {
        this.print("module ");
        this.config.getIndentor().indent();
        this.visitNode(iVisited.getCPath());
        this.visitNode(iVisited.getBodyNode());
        this.config.getIndentor().outdent();
        this.printNewlineAndIndentation();
        this.print("end");
        return null;
    }

    @Override
    public Object visitNewlineNode(NewlineNode iVisited) {
        if (this.config.isSkipNextNewline()) {
            this.config.setSkipNextNewline(false);
        } else {
            this.printNewlineAndIndentation();
        }
        this.visitNode(iVisited.getNextNode());
        return null;
    }

    @Override
    public Object visitNextNode(NextNode iVisited) {
        this.print("next");
        return null;
    }

    @Override
    public Object visitNilNode(NilNode iVisited) {
        this.print("nil");
        return null;
    }

    @Override
    public Object visitNotNode(NotNode iVisited) {
        if (iVisited.getConditionNode() instanceof CallNode) {
            this.enterCall();
        }
        this.print(this.sourceRangeContains(iVisited.getPosition(), "not") ? "not " : "!");
        this.visitNewlineInParentheses(iVisited.getConditionNode());
        if (iVisited.getConditionNode() instanceof CallNode) {
            this.leaveCall();
        }
        return null;
    }

    @Override
    public Object visitNthRefNode(NthRefNode iVisited) {
        this.print('$');
        this.print(iVisited.getMatchNumber());
        return null;
    }

    private boolean isSimpleNode(Node n) {
        return n instanceof LocalVarNode || n instanceof AssignableNode || n instanceof InstVarNode || n instanceof ClassVarNode || n instanceof GlobalVarNode || n instanceof ConstDeclNode || n instanceof VCallNode || this.isNumericNode(n);
    }

    @Override
    public Object visitOpElementAsgnNode(OpElementAsgnNode iVisited) {
        if (!this.isSimpleNode(iVisited.getReceiverNode())) {
            this.visitNewlineInParentheses(iVisited.getReceiverNode());
        } else {
            this.visitNode(iVisited.getReceiverNode());
        }
        this.visitNode(iVisited.getArgsNode());
        this.print(' ');
        this.print(iVisited.getOperatorName());
        this.print("=");
        this.print(this.config.getFormatHelper().afterAssignment());
        this.visitNode(iVisited.getValueNode());
        return null;
    }

    @Override
    public Object visitOpAsgnNode(OpAsgnNode iVisited) {
        this.visitNode(iVisited.getReceiverNode());
        this.print('.');
        this.print(iVisited.getVariableName());
        this.print(' ');
        this.print(iVisited.getOperatorName());
        this.print("=");
        this.print(this.config.getFormatHelper().afterAssignment());
        this.visitNode(iVisited.getValueNode());
        return null;
    }

    private void printOpAsgnNode(Node n, String operator) {
        this.enterCall();
        this.print(((INameNode)((Object)n)).getName());
        this.print(this.config.getFormatHelper().beforeAssignment());
        this.print(operator);
        this.print(this.config.getFormatHelper().afterAssignment());
        this.visitNode(((AssignableNode)n).getValueNode());
        this.leaveCall();
    }

    @Override
    public Object visitOpAsgnAndNode(OpAsgnAndNode iVisited) {
        this.printOpAsgnNode(iVisited.getSecondNode(), "&&=");
        return null;
    }

    @Override
    public Object visitOpAsgnOrNode(OpAsgnOrNode iVisited) {
        this.printOpAsgnNode(iVisited.getSecondNode(), "||=");
        return null;
    }

    @Override
    public Object visitOrNode(OrNode iVisited) {
        this.enterCall();
        this.visitNode(iVisited.getFirstNode());
        this.leaveCall();
        this.print(this.sourceRangeContains(iVisited.getPosition(), "||") ? " || " : " or ");
        this.enterCall();
        this.visitNewlineInParentheses(iVisited.getSecondNode());
        this.leaveCall();
        return null;
    }

    @Override
    public Object visitPostExeNode(PostExeNode iVisited) {
        return null;
    }

    @Override
    public Object visitPreExeNode(PreExeNode iVisited) {
        return null;
    }

    @Override
    public Object visitRedoNode(RedoNode iVisited) {
        this.print("redo");
        return null;
    }

    private String getFirstRegexpEnclosure(Node n) {
        return this.isSpecialRegexNotation(n) ? "%r(" : "/";
    }

    private String getSecondRegexpEnclosure(Node n) {
        return this.isSpecialRegexNotation(n) ? ")" : "/";
    }

    private boolean isSpecialRegexNotation(Node n) {
        return ReWriteVisitor.getStartOffset(n) >= 2 && this.config.getSource().length() >= ReWriteVisitor.getStartOffset(n) && this.config.getSource().charAt(ReWriteVisitor.getStartOffset(n) - 3) == '%';
    }

    private void printRegexpOptions(RegexpOptions option) {
        if (option.isIgnorecase()) {
            this.print('i');
        }
        if (option.isExtended()) {
            this.print('x');
        }
        if (option.isMultiline()) {
            this.print('m');
        }
    }

    @Override
    public Object visitRegexpNode(RegexpNode iVisited) {
        this.print(this.getFirstRegexpEnclosure(iVisited));
        this.print(iVisited.getValue().toString());
        this.print(this.getSecondRegexpEnclosure(iVisited));
        this.printRegexpOptions(iVisited.getOptions());
        return null;
    }

    public static Node firstChild(Node n) {
        if (n == null || n.childNodes().size() <= 0) {
            return null;
        }
        return n.childNodes().get(0);
    }

    @Override
    public Object visitRescueBodyNode(RescueBodyNode iVisited) {
        if (!iVisited.getBodyNode().isInvisible() && this.config.getLastPosition().getStartLine() == ReWriteVisitor.getEndLine(iVisited.getBodyNode())) {
            this.print(" rescue ");
        } else {
            this.print("rescue");
        }
        if (iVisited.getExceptionNodes() != null) {
            this.printExceptionNode(iVisited);
        } else {
            this.visitNodeInIndentation(iVisited.getBodyNode());
        }
        if (iVisited.getOptRescueNode() != null) {
            this.printNewlineAndIndentation();
        }
        this.visitNode(iVisited.getOptRescueNode());
        return null;
    }

    private void printExceptionNode(RescueBodyNode n) {
        if (n.getExceptionNodes() == null) {
            return;
        }
        this.print(' ');
        this.visitNode(ReWriteVisitor.firstChild(n.getExceptionNodes()));
        Node firstBodyNode = n.getBodyNode();
        if (n.getBodyNode() instanceof BlockNode) {
            firstBodyNode = ReWriteVisitor.firstChild(n.getBodyNode());
        }
        if (firstBodyNode instanceof AssignableNode) {
            this.print(this.config.getFormatHelper().beforeAssignment());
            this.print("=>");
            this.print(this.config.getFormatHelper().afterAssignment());
            this.print(((INameNode)((Object)firstBodyNode)).getName());
            if (firstBodyNode instanceof LocalAsgnNode) {
                this.config.getLocalVariables().addLocalVariable(((LocalAsgnNode)firstBodyNode).getIndex(), ((LocalAsgnNode)firstBodyNode).getName());
            }
            this.config.getIndentor().indent();
            this.visitIterAndSkipFirst(n.getBodyNode().childNodes().iterator());
            this.config.getIndentor().outdent();
        } else {
            this.visitNodeInIndentation(n.getBodyNode());
        }
    }

    @Override
    public Object visitRescueNode(RescueNode iVisited) {
        this.visitNode(iVisited.getBodyNode());
        this.config.getIndentor().outdent();
        if (!iVisited.getRescueNode().getBodyNode().isInvisible() && ReWriteVisitor.getStartLine(iVisited) != ReWriteVisitor.getEndLine(iVisited.getRescueNode().getBodyNode())) {
            this.printNewlineAndIndentation();
        }
        if (iVisited.getRescueNode().getBodyNode().isInvisible()) {
            this.printNewlineAndIndentation();
            this.print("rescue");
            this.printExceptionNode(iVisited.getRescueNode());
        } else {
            this.visitNode(iVisited.getRescueNode());
        }
        if (iVisited.getElseNode() != null) {
            this.printNewlineAndIndentation();
            this.print("else");
            this.visitNodeInIndentation(iVisited.getElseNode());
        }
        this.config.getIndentor().indent();
        return null;
    }

    @Override
    public Object visitRetryNode(RetryNode iVisited) {
        this.print("retry");
        return null;
    }

    public static Node unwrapSingleArrayNode(Node n) {
        if (!(n instanceof ArrayNode)) {
            return n;
        }
        if (((ArrayNode)n).childNodes().size() > 1) {
            return n;
        }
        return ReWriteVisitor.firstChild((ArrayNode)n);
    }

    @Override
    public Object visitReturnNode(ReturnNode iVisited) {
        this.print("return");
        this.enterCall();
        if (!iVisited.getValueNode().isInvisible()) {
            this.print(' ');
            this.visitNode(ReWriteVisitor.unwrapSingleArrayNode(iVisited.getValueNode()));
        }
        this.leaveCall();
        return null;
    }

    @Override
    public Object visitSClassNode(SClassNode iVisited) {
        this.print("class << ");
        this.config.getIndentor().indent();
        this.visitNode(iVisited.getReceiverNode());
        this.visitNode(iVisited.getBodyNode());
        this.config.getIndentor().outdent();
        this.printNewlineAndIndentation();
        this.print("end");
        return null;
    }

    @Override
    public Object visitSelfNode(SelfNode iVisited) {
        this.print("self");
        return null;
    }

    @Override
    public Object visitSplatNode(SplatNode iVisited) {
        this.print("*");
        this.visitNode(iVisited.getValue());
        return null;
    }

    private boolean stringIsHereDocument(StrNode n) {
        return this.sourceRangeEquals(ReWriteVisitor.getStartOffset(n) + 1, ReWriteVisitor.getStartOffset(n) + 3, "<<") || this.sourceRangeEquals(ReWriteVisitor.getStartOffset(n), ReWriteVisitor.getStartOffset(n) + 3, "<<-");
    }

    protected char getSeparatorForSym(Node n) {
        if (this.config.getSource().length() >= ReWriteVisitor.getStartOffset(n) + 1 && this.config.getSource().charAt(ReWriteVisitor.getStartOffset(n) + 1) == '\'') {
            return '\'';
        }
        return '\"';
    }

    protected char getSeparatorForStr(Node n) {
        if (this.config.getSource().length() >= ReWriteVisitor.getStartOffset(n) && this.config.getSource().charAt(ReWriteVisitor.getStartOffset(n)) == '\'') {
            return '\'';
        }
        return '\"';
    }

    protected boolean inDRegxNode() {
        return false;
    }

    @Override
    public Object visitStrNode(StrNode iVisited) {
        if (this.stringIsHereDocument(iVisited)) {
            this.print("<<-EOF");
            this.config.depositHereDocument(iVisited.getValue().toString());
            return null;
        }
        if (iVisited.getValue().equals("")) {
            if (this.config.getPrintQuotesInString().isTrue()) {
                this.print("\"\"");
            }
            return null;
        }
        if (this.config.getPrintQuotesInString().isTrue()) {
            this.print(this.getSeparatorForStr(iVisited));
        }
        if (this.inDRegxNode()) {
            this.print(iVisited.getValue().toString());
        } else {
            Matcher matcher = Pattern.compile("([\\\\\\n\\f\\r\\t\\\"\\'])").matcher(iVisited.getValue().toString());
            if (matcher.find()) {
                String unescChar = ReWriteVisitor.unescapeChar(matcher.group(1).charAt(0));
                this.print(matcher.replaceAll("\\\\" + unescChar));
            } else {
                this.print(iVisited.getValue().toString());
            }
        }
        if (this.config.getPrintQuotesInString().isTrue()) {
            this.print(this.getSeparatorForStr(iVisited));
        }
        return null;
    }

    public static String unescapeChar(char escapedChar) {
        switch (escapedChar) {
            case '\n': {
                return "n";
            }
            case '\f': {
                return "f";
            }
            case '\r': {
                return "r";
            }
            case '\t': {
                return "t";
            }
            case '\"': {
                return "\"";
            }
            case '\'': {
                return "'";
            }
            case '\\': {
                return "\\\\";
            }
        }
        return null;
    }

    private boolean needsSuperNodeParentheses(SuperNode n) {
        return n.getArgsNode().childNodes().isEmpty() && this.config.getSource().charAt(ReWriteVisitor.getEndOffset(n)) == '(';
    }

    @Override
    public Object visitSuperNode(SuperNode iVisited) {
        this.print("super");
        if (this.needsSuperNodeParentheses(iVisited)) {
            this.print('(');
        }
        this.printCallArguments(iVisited.getArgsNode(), iVisited.getIterNode());
        if (this.needsSuperNodeParentheses(iVisited)) {
            this.print(')');
        }
        return null;
    }

    @Override
    public Object visitSValueNode(SValueNode iVisited) {
        this.visitNode(iVisited.getValue());
        return null;
    }

    @Override
    public Object visitSymbolNode(SymbolNode iVisited) {
        this.print(':');
        this.print(iVisited.getName());
        return null;
    }

    @Override
    public Object visitToAryNode(ToAryNode iVisited) {
        this.visitNode(iVisited.getValue());
        return null;
    }

    @Override
    public Object visitTrueNode(TrueNode iVisited) {
        this.print("true");
        return null;
    }

    @Override
    public Object visitUndefNode(UndefNode iVisited) {
        this.print("undef ");
        this.visitNode(iVisited.getName());
        return null;
    }

    @Override
    public Object visitUntilNode(UntilNode iVisited) {
        this.print("until ");
        this.visitNode(iVisited.getConditionNode());
        this.visitNodeInIndentation(iVisited.getBodyNode());
        this.printNewlineAndIndentation();
        this.print("end");
        return null;
    }

    @Override
    public Object visitVAliasNode(VAliasNode iVisited) {
        this.print("alias ");
        this.print(iVisited.getNewName());
        this.print(' ');
        this.print(iVisited.getOldName());
        return null;
    }

    @Override
    public Object visitVCallNode(VCallNode iVisited) {
        this.print(iVisited.getName());
        return null;
    }

    public void visitNodeInIndentation(Node n) {
        this.config.getIndentor().indent();
        this.visitNode(n);
        this.config.getIndentor().outdent();
    }

    @Override
    public Object visitWhenNode(WhenNode iVisited) {
        this.printNewlineAndIndentation();
        this.print("when ");
        this.enterCall();
        this.visitAndPrintWithSeparator(iVisited.getExpressionNodes().childNodes().iterator());
        this.leaveCall();
        this.visitNodeInIndentation(iVisited.getBodyNode());
        if (iVisited.getNextCase() instanceof WhenNode || iVisited.getNextCase() == null) {
            this.visitNode(iVisited.getNextCase());
        } else {
            this.printNewlineAndIndentation();
            this.print("else");
            this.visitNodeInIndentation(iVisited.getNextCase());
        }
        return null;
    }

    protected void visitNewlineInParentheses(Node n) {
        if (n instanceof NewlineNode) {
            if (((NewlineNode)n).getNextNode() instanceof SplatNode) {
                this.print('[');
                this.visitNode(((NewlineNode)n).getNextNode());
                this.print(']');
            } else {
                this.print('(');
                this.visitNode(((NewlineNode)n).getNextNode());
                this.print(')');
            }
        } else {
            this.visitNode(n);
        }
    }

    private void printWhileStatement(WhileNode iVisited) {
        this.print("while ");
        if (this.isAssignment(iVisited.getConditionNode())) {
            this.enterCall();
        }
        this.visitNewlineInParentheses(iVisited.getConditionNode());
        if (this.isAssignment(iVisited.getConditionNode())) {
            this.leaveCall();
        }
        this.visitNodeInIndentation(iVisited.getBodyNode());
        this.printNewlineAndIndentation();
        this.print("end");
    }

    private void printDoWhileStatement(WhileNode iVisited) {
        this.print("begin");
        this.visitNodeInIndentation(iVisited.getBodyNode());
        this.printNewlineAndIndentation();
        this.print("end while ");
        this.visitNode(iVisited.getConditionNode());
    }

    @Override
    public Object visitWhileNode(WhileNode iVisited) {
        if (iVisited.evaluateAtStart()) {
            this.printWhileStatement(iVisited);
        } else {
            this.printDoWhileStatement(iVisited);
        }
        return null;
    }

    @Override
    public Object visitXStrNode(XStrNode iVisited) {
        this.print('`');
        this.print(iVisited.getValue().toString());
        this.print('`');
        return null;
    }

    @Override
    public Object visitYieldNode(YieldNode iVisited) {
        this.print("yield");
        if (iVisited.getArgsNode() != null) {
            this.print(this.needsParentheses(iVisited.getArgsNode()) ? (char)'(' : ' ');
            this.enterCall();
            if (iVisited.getArgsNode() instanceof ArrayNode) {
                this.visitAndPrintWithSeparator(iVisited.getArgsNode().childNodes().iterator());
            } else {
                this.visitNode(iVisited.getArgsNode());
            }
            this.leaveCall();
            if (this.needsParentheses(iVisited.getArgsNode())) {
                this.print(')');
            }
        }
        return null;
    }

    @Override
    public Object visitZArrayNode(ZArrayNode iVisited) {
        this.print("[]");
        return null;
    }

    @Override
    public Object visitZSuperNode(ZSuperNode iVisited) {
        this.print("super");
        return null;
    }

    private static int getStartLine(Node n) {
        return n.getPosition().getStartLine();
    }

    private static int getStartOffset(Node n) {
        return n.getPosition().getStartOffset();
    }

    private static int getEndLine(Node n) {
        return n.getPosition().getEndLine();
    }

    protected static int getEndOffset(Node n) {
        return n.getPosition().getEndOffset();
    }

    public ReWriterContext getConfig() {
        return this.config;
    }

    public static String createCodeFromNode(Node node, String document) {
        return ReWriteVisitor.createCodeFromNode(node, document, new DefaultFormatHelper());
    }

    public static String createCodeFromNode(Node node, String document, FormatHelper helper) {
        StringWriter writer = new StringWriter();
        ReWriterContext ctx = new ReWriterContext(writer, document, helper);
        ReWriteVisitor rewriter = new ReWriteVisitor(ctx);
        rewriter.visitNode(node);
        return writer.toString();
    }

    @Override
    public Object visitArgsPushNode(ArgsPushNode node) {
        assert (false) : "Unhandled node";
        return null;
    }

    @Override
    public Object visitAttrAssignNode(AttrAssignNode iVisited) {
        if (iVisited.getName().equals("[]=")) {
            return this.printIndexAssignment(iVisited);
        }
        if (iVisited.getName().endsWith("=")) {
            this.visitNode(iVisited.getReceiverNode());
            this.print('.');
            this.printNameWithoutEqualSign(iVisited);
            this.printAssignmentOperator();
            if (iVisited.getArgsNode() != null) {
                this.visitAndPrintWithSeparator(iVisited.getArgsNode().childNodes().iterator());
            }
        } else assert (false) : "Unhandled AttrAssignNode";
        return null;
    }

    private void printNameWithoutEqualSign(INameNode iVisited) {
        this.print(iVisited.getName().substring(0, iVisited.getName().length() - 1));
    }

    @Override
    public Object visitRootNode(RootNode iVisited) {
        this.config.getLocalVariables().addLocalVariable(iVisited.getStaticScope());
        this.visitNode(iVisited.getBodyNode());
        if (this.config.hasHereDocument()) {
            this.config.fetchHereDocument().print();
        }
        return null;
    }

    @Override
    public Object visitRestArgNode(RestArgNode iVisited) {
        this.print("*" + iVisited.getName());
        return null;
    }

    @Override
    public Object visitEncodingNode(EncodingNode iVisited) {
        this.print("__ENCODING__");
        return null;
    }

    @Override
    public Object visitLiteralNode(LiteralNode iVisited) {
        this.print("literal");
        return null;
    }
}

