/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.ui.io.navigator.actions;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.IOUtil;
import com.aptana.editor.common.UntitledFileStorageEditorInput;
import com.aptana.editor.common.internal.scripting.NewFileWizard;
import com.aptana.ide.ui.io.IOUIPlugin;
import com.aptana.ide.ui.io.navigator.actions.Messages;
import com.aptana.ide.ui.io.navigator.actions.NewFileTemplateMenuContributor;
import com.aptana.scripting.model.TemplateElement;
import com.aptana.ui.util.UIUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.jruby.embed.io.ReaderInputStream;

public class NewUntitledFileTemplateMenuContributor
extends NewFileTemplateMenuContributor {
    private Map<String, Integer> countByFileType = new HashMap<String, Integer>();

    public NewUntitledFileTemplateMenuContributor() {
    }

    public NewUntitledFileTemplateMenuContributor(String id) {
        super(id);
    }

    @Override
    protected void createNewFileFromTemplate(TemplateElement template) {
        String fileExtension = template.getFiletype();
        int index = fileExtension.lastIndexOf(46);
        if (index > -1) {
            fileExtension = fileExtension.substring(index + 1);
        }
        String name = template.getOwningBundle().getDisplayName();
        this.createUntitledFile(name, fileExtension, this.getInitialContents(template, Path.fromOSString((String)MessageFormat.format("{0}.{1}", name, fileExtension))));
    }

    @Override
    protected void createNewBlankFile(String editorType, String fileExtension) {
        this.createUntitledFile(editorType, fileExtension, new InputStream(){

            @Override
            public int read() throws IOException {
                return -1;
            }

            @Override
            public int available() throws IOException {
                return 0;
            }
        });
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private IEditorPart createUntitledFile(String editorType, String fileExtension, InputStream initialContent) {
        FileOutputStream output;
        block14: {
            String editorName;
            output = null;
            File file = File.createTempFile(Messages.NewUntitledFileTemplateMenuContributor_TempSuffix, "." + fileExtension);
            output = new FileOutputStream(file);
            IOUtil.pipe((InputStream)initialContent, (OutputStream)output);
            file.deleteOnExit();
            IEditorDescriptor editorDescriptor = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(file.getName());
            String editorId = editorDescriptor == null ? "com.aptana.editor.text" : editorDescriptor.getId();
            IWorkbenchPage page = UIUtils.getActivePage();
            if (page == null) break block14;
            Integer value = this.countByFileType.get(editorType);
            if (value == null) {
                editorName = MessageFormat.format(Messages.NewUntitledFileTemplateMenuContributor_DefaultName, editorType);
                this.countByFileType.put(editorType, 1);
            } else {
                editorName = MessageFormat.format(Messages.NewUntitledFileTemplateMenuContributor_DefaultName_2, editorType, value);
                value = value + 1;
                this.countByFileType.put(editorType, value);
            }
            IEditorPart iEditorPart = page.openEditor((IEditorInput)new UntitledFileStorageEditorInput(file.toURI(), editorName, initialContent), editorId);
            if (output == null) return iEditorPart;
            try {
                output.close();
                return iEditorPart;
            }
            catch (IOException iOException) {}
            return iEditorPart;
            catch (Exception e) {
                try {
                    IdeLog.logError((Plugin)IOUIPlugin.getDefault(), (String)"Failed to create new file from selected template", (Throwable)e);
                    if (output == null) return null;
                }
                catch (Throwable throwable) {
                    if (output == null) throw throwable;
                    try {
                        output.close();
                        throw throwable;
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    output.close();
                    return null;
                }
                catch (IOException iOException) {}
                return null;
            }
        }
        if (output == null) return null;
        try {
            output.close();
            return null;
        }
        catch (IOException iOException) {}
        return null;
    }

    private InputStream getInitialContents(TemplateElement template, IPath path) {
        String templateContent = NewFileWizard.getTemplateContent((TemplateElement)template, (IPath)path);
        if (templateContent != null) {
            return new ReaderInputStream((Reader)new StringReader(templateContent), "UTF-8");
        }
        return null;
    }
}

