/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.ui.io.navigator.actions;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.IOUtil;
import com.aptana.editor.common.internal.scripting.NewFileWizard;
import com.aptana.editor.common.internal.scripting.TemplateSelectionPage;
import com.aptana.ide.ui.io.IOUIPlugin;
import com.aptana.ide.ui.io.Utils;
import com.aptana.ide.ui.io.navigator.actions.EditorUtils;
import com.aptana.ide.ui.io.navigator.actions.Messages;
import com.aptana.ide.ui.io.navigator.actions.WizardNewExternalFilePage;
import com.aptana.scripting.model.TemplateElement;
import com.aptana.ui.util.UIUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.jruby.embed.io.ReaderInputStream;

public class NewExternalFileWizard
extends Wizard {
    protected static String TEMPLATE_PAGE_NAME = "templatePage";
    protected static String MAIN_PAGE_NAME = "mainPage";
    private String initialFilename;
    private InputStream initialContent;
    private IAdaptable selectedElement;
    private TemplateElement template;
    private WizardNewExternalFilePage mainPage;

    public NewExternalFileWizard(String initialName, InputStream initialContent, IAdaptable selectedElement) {
        this(initialName, initialContent, selectedElement, null);
    }

    public NewExternalFileWizard(String initialName, InputStream initialContent, IAdaptable selectedElement, TemplateElement template) {
        this.initialFilename = initialName;
        this.initialContent = initialContent;
        this.selectedElement = selectedElement;
        this.template = template;
    }

    public void addPages() {
        this.mainPage = new WizardNewExternalFilePage(MAIN_PAGE_NAME, this.initialFilename, this.template == null);
        this.addPage((IWizardPage)this.mainPage);
        this.mainPage.setTitle(Messages.NewExternalFileWizard_Title);
        this.mainPage.setDescription(Messages.NewExternalFileWizard_Description);
        if (this.initialContent == null && this.template == null) {
            this.addPage((IWizardPage)new TemplateSelectionPage(TEMPLATE_PAGE_NAME));
        }
    }

    public boolean canFinish() {
        if (this.getContainer().getCurrentPage() == this.mainPage && this.mainPage.isPageComplete()) {
            return true;
        }
        return super.canFinish();
    }

    public boolean performFinish() {
        IFileStore parentStore = this.getSelectedDirectory();
        final IFileStore newFile = parentStore.getChild(this.mainPage.getFileName());
        if (Utils.exists((IAdaptable)newFile) && !MessageDialog.openConfirm((Shell)this.getShell(), (String)Messages.NewFileAction_Confirm_Title, (String)Messages.NewFileAction_Confirm_Message)) {
            return false;
        }
        final InputStream in = this.getInitialContents(Path.fromOSString((String)newFile.toString()));
        Job job = new Job(Messages.NewFileAction_JobTitle){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    OutputStream out;
                    block18: {
                        out = newFile.openOutputStream(0, monitor);
                        if (in != null) {
                            try {
                                try {
                                    IOUtil.pipe((InputStream)in, (OutputStream)out);
                                }
                                catch (IOException e) {
                                    IdeLog.logError((Plugin)IOUIPlugin.getDefault(), (Throwable)e);
                                    try {
                                        in.close();
                                    }
                                    catch (IOException e2) {
                                        IdeLog.logError((Plugin)IOUIPlugin.getDefault(), (Throwable)e2);
                                    }
                                    break block18;
                                }
                            }
                            catch (Throwable throwable) {
                                try {
                                    in.close();
                                }
                                catch (IOException e) {
                                    IdeLog.logError((Plugin)IOUIPlugin.getDefault(), (Throwable)e);
                                }
                                throw throwable;
                            }
                            try {
                                in.close();
                            }
                            catch (IOException e) {
                                IdeLog.logError((Plugin)IOUIPlugin.getDefault(), (Throwable)e);
                            }
                        }
                    }
                    try {
                        out.close();
                    }
                    catch (IOException e) {
                        IdeLog.logError((Plugin)IOUIPlugin.getDefault(), (Throwable)e);
                    }
                    EditorUtils.openFileInEditor(newFile, null);
                    IFileStore fileStore = Utils.getFileStore(NewExternalFileWizard.this.selectedElement);
                    boolean selectionIsDirectory = Utils.isDirectory(NewExternalFileWizard.this.selectedElement);
                    if (selectionIsDirectory) {
                        IOUIPlugin.refreshNavigatorView(NewExternalFileWizard.this.selectedElement);
                    } else {
                        IOUIPlugin.refreshNavigatorView(fileStore.getParent());
                    }
                }
                catch (CoreException e) {
                    NewExternalFileWizard.this.showError((Exception)((Object)e));
                }
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.schedule();
        return true;
    }

    private IFileStore getSelectedDirectory() {
        IFileStore fileStore = Utils.getFileStore(this.selectedElement);
        boolean selectionIsDirectory = Utils.isDirectory(this.selectedElement);
        if (!selectionIsDirectory && fileStore.getParent() != null) {
            return fileStore.getParent();
        }
        return fileStore;
    }

    private InputStream getInitialContents(IPath path) {
        String templateContent;
        if (this.initialContent != null) {
            return this.initialContent;
        }
        if (this.template != null && (templateContent = NewFileWizard.getTemplateContent((TemplateElement)this.template, (IPath)path)) != null) {
            return new ReaderInputStream((Reader)new StringReader(templateContent), "UTF-8");
        }
        return this.mainPage.getInitialContents();
    }

    private void showError(Exception exception) {
        UIUtils.showErrorMessage((String)exception.getLocalizedMessage(), (Throwable)exception);
    }
}

