/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.ui.io.navigator;

import com.aptana.ide.ui.io.navigator.DeferredTreeSelectionExpander;
import com.aptana.ide.ui.io.navigator.FileNavigatorDecoratingLabelProvider;
import com.aptana.ide.ui.io.navigator.FileSystemElementComparer;
import com.aptana.theme.IControlThemerFactory;
import com.aptana.theme.ThemePlugin;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.navigator.CommonNavigator;

public class RemoteNavigatorView
extends CommonNavigator {
    public static final String ID = "com.aptana.ui.io.remoteview";

    public void createPartControl(Composite aParent) {
        super.createPartControl(aParent);
        this.getCommonViewer().setLabelProvider((IBaseLabelProvider)new FileNavigatorDecoratingLabelProvider(this.getNavigatorContentService().createCommonLabelProvider()));
        this.getCommonViewer().setComparer((IElementComparer)new FileSystemElementComparer());
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.getCommonViewer());
        this.hookToThemes();
        final Tree tree = this.getCommonViewer().getTree();
        tree.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                if (tree.getItem(new Point(e.x, e.y)) == null) {
                    tree.deselectAll();
                    tree.notifyListeners(13, new Event());
                }
            }
        });
    }

    public void setSelection(Object[] selectionPath) {
        if (selectionPath == null || selectionPath.length == 0) {
            return;
        }
        DeferredTreeSelectionExpander selectionExpander = (DeferredTreeSelectionExpander)((Object)this.getCommonViewer().getData("deferred_selection_expander"));
        if (selectionExpander != null) {
            selectionExpander.setSelection(new TreePath(selectionPath));
        }
    }

    private void hookToThemes() {
        this.getControlThemerFactory().apply((Viewer)this.getCommonViewer());
    }

    private IControlThemerFactory getControlThemerFactory() {
        return ThemePlugin.getDefault().getControlThemerFactory();
    }
}

