/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.ui.io.navigator;

import com.aptana.core.util.PlatformUtil;
import com.aptana.ide.core.io.LocalRoot;
import com.aptana.ide.ui.io.CoreIOImages;
import com.aptana.ide.ui.io.navigator.Messages;
import com.aptana.ide.ui.io.navigator.WindowsFileSystemRoot;
import java.io.File;
import java.util.ArrayList;
import javax.swing.filechooser.FileSystemView;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class LocalFileSystems
implements IWorkbenchAdapter {
    private static final String MY_COMPUTER_GUID = "::{20D04FE0-3AEA-1069-A2D8-08002B30309D}";
    private static final String MY_NETWORK_PLACES_GUID = "::{208D2C60-3AEA-1069-A2D7-08002B30309D}";
    private static final String DESKTOP = PlatformUtil.expandEnvironmentStrings((String)"%DesktopDirectory%");
    private static final File[] NO_FILES = new File[0];
    private static LocalFileSystems instance;

    private LocalFileSystems() {
    }

    public static LocalFileSystems getInstance() {
        if (instance == null) {
            instance = new LocalFileSystems();
        }
        return instance;
    }

    public Object[] getChildren(Object o) {
        LocalRoot[] otherRoots;
        ArrayList<WindowsFileSystemRoot> children = new ArrayList<WindowsFileSystemRoot>();
        if ("win32".equals(Platform.getOS())) {
            File[] files = LocalFileSystems.getWindowsRootFiles();
            int i = 0;
            while (i < files.length) {
                children.add(new WindowsFileSystemRoot(files[i]));
                ++i;
            }
        }
        LocalRoot[] localRootArray = otherRoots = LocalRoot.createRoots();
        int n = otherRoots.length;
        int n2 = 0;
        while (n2 < n) {
            LocalRoot root = localRootArray[n2];
            children.add((WindowsFileSystemRoot)root);
            ++n2;
        }
        return children.toArray(new Object[children.size()]);
    }

    public ImageDescriptor getImageDescriptor(Object object) {
        return CoreIOImages.getImageDescriptor("IMG_OBJS_DRIVE");
    }

    public String getLabel(Object o) {
        return Messages.LocalFileSystems_LBL;
    }

    public Object getParent(Object o) {
        return null;
    }

    public String toString() {
        return Messages.LocalFileSystems_LBL;
    }

    private static File[] getWindowsRootFiles() {
        File[] files;
        File desktop = LocalFileSystems.getWindowsDesktopFile();
        if (desktop == null) {
            return NO_FILES;
        }
        ArrayList<File> roots = new ArrayList<File>();
        File[] fileArray = files = FileSystemView.getFileSystemView().getFiles(desktop, false);
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            String name = file.getName();
            if (name.equals(MY_COMPUTER_GUID) || name.equals(MY_NETWORK_PLACES_GUID) || name.startsWith("::")) {
                roots.add(file);
            }
            ++n2;
        }
        return roots.toArray(new File[roots.size()]);
    }

    private static File getWindowsDesktopFile() {
        File[] files;
        Path desktopPath = new Path(DESKTOP);
        String desktopFilename = desktopPath.lastSegment();
        File[] fileArray = files = FileSystemView.getFileSystemView().getRoots();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.getName().equals(desktopFilename)) {
                return file;
            }
            ++n2;
        }
        return null;
    }
}

