/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.ui.io.internal;

import com.aptana.core.io.vfs.IExtendedFileStore;
import com.aptana.ide.ui.io.IUniformFileStoreEditorInput;
import com.aptana.ide.ui.io.internal.UniformFileStoreEditorInputFactory;
import com.aptana.ide.ui.io.preferences.RemotePreferenceUtil;
import java.net.URI;
import java.text.MessageFormat;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.ide.FileStoreEditorInput;

public class UniformFileStoreEditorInput
extends FileStoreEditorInput
implements IUniformFileStoreEditorInput {
    private IFileStore fLocalFileStore;
    private IFileStore fRealFileStore;
    private IFileInfo fRealFileInfo;

    public UniformFileStoreEditorInput(IFileStore localFileStore, IFileStore realFileStore, IFileInfo realFileInfo) {
        super(localFileStore);
        this.fLocalFileStore = localFileStore;
        this.fRealFileStore = realFileStore;
        this.fRealFileInfo = realFileInfo;
    }

    public String getName() {
        String name = this.fRealFileStore.getName();
        if (this.fRealFileStore instanceof IExtendedFileStore) {
            name = MessageFormat.format("({0}) {1}", ((IExtendedFileStore)this.fRealFileStore).toCanonicalURI().getScheme(), name);
        }
        return name;
    }

    public String getToolTipText() {
        return this.fRealFileStore.toString();
    }

    public IFileStore getLocalFileStore() {
        return this.fLocalFileStore;
    }

    @Override
    public IFileStore getFileStore() {
        return this.fRealFileStore;
    }

    public IFileInfo getFileInfo() {
        return this.fRealFileInfo;
    }

    @Override
    public boolean isRemote() {
        return !this.fLocalFileStore.equals(this.fRealFileStore);
    }

    public void setFileInfo(IFileInfo fileInfo) {
        this.fRealFileInfo = fileInfo;
    }

    public IPersistableElement getPersistable() {
        boolean reopen = RemotePreferenceUtil.getReopenRemoteOnStartup();
        return reopen ? this : null;
    }

    public int hashCode() {
        return this.fRealFileStore.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof UniformFileStoreEditorInput) {
            return this.fRealFileStore.equals(((UniformFileStoreEditorInput)o).fRealFileStore);
        }
        return false;
    }

    public Object getAdapter(Class adapter) {
        if (IFileStore.class.equals((Object)adapter)) {
            return this.fRealFileStore;
        }
        if (IFileInfo.class.equals((Object)adapter)) {
            return this.fRealFileInfo;
        }
        if (URI.class.equals((Object)adapter) && this.fRealFileStore instanceof IExtendedFileStore) {
            return ((IExtendedFileStore)this.fRealFileStore).toCanonicalURI();
        }
        return super.getAdapter(adapter);
    }

    public String getFactoryId() {
        return "com.aptana.ui.io.UniformFileStoreEditorInputFactory";
    }

    public void saveState(IMemento memento) {
        UniformFileStoreEditorInputFactory.saveState(memento, this);
    }
}

