/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.precompile.externalcommand.command;

import com.aptana.core.epl.IMemento;
import com.aptana.core.util.FileUtil;
import com.aptana.core.util.StringUtil;
import org.eclipse.core.resources.IFile;

public class ExternalCommand
implements Comparable<ExternalCommand> {
    protected static final String ELEMENT_ID = "id";
    protected static final String ELEMENT_ENABLE = "enable";
    protected static final String ELEMENT_PATH = "path";
    protected static final String ELEMENT_ARGS = "args";
    protected static final String ELEMENT_INFILECONTENTTYPEID = "inFileExtension";
    private String id;
    private boolean enable = true;
    private String path;
    private String args;
    private String inFileExtension;

    public ExternalCommand(IMemento memento) {
        this.loadState(memento);
    }

    public ExternalCommand() {
    }

    public ExternalCommand(boolean enable, String inFileExtension) {
        this.enable = enable;
        this.inFileExtension = inFileExtension;
    }

    public ExternalCommand(String id, boolean enable, String path, String args, String inFileExtension) {
        this.id = id;
        this.enable = enable;
        this.path = path;
        this.args = args;
        this.inFileExtension = inFileExtension;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.inFileExtension;
    }

    public boolean isEnable() {
        return this.enable;
    }

    public void setEnable(boolean enable) {
        this.enable = enable;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getArgs() {
        return this.args;
    }

    public void setArgs(String args) {
        this.args = args;
    }

    public String getInFileExtension() {
        return this.inFileExtension;
    }

    public void setInFileExtension(String inFileExtension) {
        this.inFileExtension = inFileExtension;
    }

    public void loadState(IMemento memento) {
        if (memento != null) {
            this.id = this.getValue(memento, ELEMENT_ID);
            this.enable = Boolean.parseBoolean(this.getValue(memento, ELEMENT_ENABLE));
            this.path = this.getValue(memento, ELEMENT_PATH);
            this.args = this.getValue(memento, ELEMENT_ARGS);
            this.inFileExtension = this.getValue(memento, ELEMENT_INFILECONTENTTYPEID);
        }
    }

    protected String getValue(IMemento memento, String name) {
        return memento.getString(name);
    }

    public void saveState(IMemento memento) {
        if (memento != null) {
            memento.putString(ELEMENT_ID, this.id);
            memento.putBoolean(ELEMENT_ENABLE, this.enable);
            memento.putString(ELEMENT_PATH, this.path);
            memento.putString(ELEMENT_ARGS, this.args);
            memento.putString(ELEMENT_INFILECONTENTTYPEID, this.inFileExtension);
        }
    }

    public boolean match(IFile file) {
        String extension;
        if (StringUtil.isNotBlank((String)this.path) && StringUtil.isNotBlank((String)this.inFileExtension) && StringUtil.isNotBlank((String)(extension = FileUtil.getExtension((String)file.getName())))) {
            return StringUtil.split((String)this.inFileExtension, (char)',').contains("." + extension);
        }
        return false;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ExternalCommand other = (ExternalCommand)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    @Override
    public int compareTo(ExternalCommand o) {
        return this.inFileExtension.compareTo(o.getInFileExtension());
    }
}

