/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.precompile;

import com.aptana.core.CorePlugin;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.EclipseUtil;
import com.aptana.editor.common.internal.save.EditorSaveEvent;
import com.aptana.editor.common.internal.save.EditorSaveManager;
import com.aptana.editor.common.internal.save.IEditorSaveListener;
import com.pandora.precompile.PreCompileActivator;
import com.pandora.precompile.compiler.AutoPreCompiler;
import com.pandora.precompile.externalcommand.command.ExternalCommandManager;
import java.net.URL;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ISaveContext;
import org.eclipse.core.resources.ISaveParticipant;
import org.eclipse.core.resources.ISavedState;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IStartup;
import org.osgi.framework.Bundle;
import org.osgi.service.prefs.BackingStoreException;

public class Startup
implements IStartup {
    public void earlyStartup() {
        Job job = new Job("load ExternalCommand Job"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    IPath location;
                    ISavedState lastState = ResourcesPlugin.getWorkspace().addSaveParticipant("com.pandora.precompile", (ISaveParticipant)new WorkspaceSaveParticipant());
                    if (lastState != null && (location = lastState.lookup((IPath)new Path("externalcommands"))) != null) {
                        ExternalCommandManager.getInstance().loadState(PreCompileActivator.getDefault().getStateLocation().append(location), false);
                    }
                    URL url = FileLocator.find((Bundle)PreCompileActivator.getDefault().getBundle(), (IPath)new Path("config/default_externalcommands.xml"), null);
                    ExternalCommandManager.getInstance().loadState((IPath)new Path(FileLocator.toFileURL((URL)url).getFile()), true);
                    IEclipsePreferences prefs = EclipseUtil.instanceScope().getNode("com.pandora.precompile");
                    boolean added = prefs.getBoolean("addDefaultExternalCommand", false);
                    if (!added) {
                        ExternalCommandManager.getInstance().resetDefaultExternalCommands();
                        prefs.putBoolean("addDefaultExternalCommand", true);
                        try {
                            prefs.flush();
                        }
                        catch (BackingStoreException e) {
                            IdeLog.logError((Plugin)CorePlugin.getDefault(), (Throwable)e);
                        }
                    }
                }
                catch (Exception e) {
                    IdeLog.logError((Plugin)PreCompileActivator.getDefault(), (Throwable)e);
                }
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule();
        this.addFileChangeListener();
    }

    private void addFileChangeListener() {
        EditorSaveManager.getInstance().addEditorSaveListener(new IEditorSaveListener(){

            public void editorSaveEvent(EditorSaveEvent event) {
                IFile file;
                IEditorInput input;
                Object source;
                if (event.getKind() == 2 && (source = event.getSource()) instanceof IEditorPart && (input = ((IEditorPart)source).getEditorInput()) instanceof IFileEditorInput && (file = ((IFileEditorInput)input).getFile()).exists()) {
                    Job build = new Job("\u4fdd\u5b58\u89e6\u53d1\u5668"){

                        protected IStatus run(IProgressMonitor monitor) {
                            monitor.beginTask("\u6b63\u5728\u7f16\u8bd1", 2);
                            monitor.worked(1);
                            AutoPreCompiler.getInstance().buildFile(file);
                            monitor.setTaskName("\u6b63\u5728\u7f16\u8bd1" + file.getFullPath());
                            monitor.worked(1);
                            return Status.OK_STATUS;
                        }
                    };
                    build.setRule((ISchedulingRule)new AutoPreCompileJobRule());
                    build.schedule();
                }
            }
        });
    }

    private class AutoPreCompileJobRule
    implements ISchedulingRule {
        private AutoPreCompileJobRule() {
        }

        public boolean contains(ISchedulingRule rule) {
            return this == rule;
        }

        public boolean isConflicting(ISchedulingRule rule) {
            if (this == rule) {
                return true;
            }
            return rule instanceof AutoPreCompileJobRule;
        }
    }

    private class WorkspaceSaveParticipant
    implements ISaveParticipant {
        private WorkspaceSaveParticipant() {
        }

        public void doneSaving(ISaveContext context) {
            IPath prevSavePath = new Path("externalcommands").addFileExtension(Integer.toString(context.getPreviousSaveNumber()));
            PreCompileActivator.getDefault().getStateLocation().append(prevSavePath).toFile().delete();
        }

        public void prepareToSave(ISaveContext context) throws CoreException {
        }

        public void rollback(ISaveContext context) {
            IPath savePath = new Path("externalcommands").addFileExtension(Integer.toString(context.getSaveNumber()));
            PreCompileActivator.getDefault().getStateLocation().append(savePath).toFile().delete();
        }

        public void saving(ISaveContext context) throws CoreException {
            IPath savePath = new Path("externalcommands").addFileExtension(Integer.toString(context.getSaveNumber()));
            ExternalCommandManager.getInstance().saveState(PreCompileActivator.getDefault().getStateLocation().append(savePath));
            context.map((IPath)new Path("externalcommands"), savePath);
            context.needSaveNumber();
        }
    }
}

