/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.json.validator;

import com.aptana.core.build.AbstractBuildParticipant;
import com.aptana.core.build.IProblem;
import com.aptana.core.logging.IdeLog;
import com.aptana.editor.json.CommentsFilter;
import com.aptana.editor.json.JSONPlugin;
import com.aptana.index.core.build.BuildContext;
import com.eclipsesource.json.Json;
import com.eclipsesource.json.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Plugin;

public class MinimalJsonValidator
extends AbstractBuildParticipant {
    public static final String ID = "com.aptana.editor.json.validator.MinimalJsonValidator";
    private String JSON_PROBLEM_MARKER_TYPE = "com.aptana.editor.json.problem";

    public void initContext(BuildContext context) {
        List problems = Collections.emptyList();
        context.putProblems(this.JSON_PROBLEM_MARKER_TYPE, problems);
    }

    public void buildFile(BuildContext context, IProgressMonitor monitor) {
        if (context == null) {
            return;
        }
        List<Object> problems = Collections.emptyList();
        String sourcePath = context.getURI().toString();
        try {
            problems = this.parse(context, context.getContents(), sourcePath, monitor);
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)JSONPlugin.getDefault(), (Throwable)e);
        }
        context.putProblems(this.JSON_PROBLEM_MARKER_TYPE, problems);
    }

    private List<IProblem> parse(BuildContext context, String contents, String sourcePath, IProgressMonitor monitor) {
        ArrayList<IProblem> list = new ArrayList<IProblem>();
        try {
            contents = CommentsFilter.filterComments(contents);
            Json.parse((String)contents);
        }
        catch (ParseException e) {
            list.add(this.createError(e.getMessage().replaceAll("(\\d+)\\:(\\d+)", " line $1 column $2"), e.getLine(), e.getOffset(), 1, sourcePath));
        }
        catch (Throwable ex) {
            IdeLog.logError((Plugin)JSONPlugin.getDefault(), (Throwable)ex);
        }
        return list;
    }

    public void deleteFile(BuildContext context, IProgressMonitor monitor) {
        if (context == null) {
            return;
        }
        context.removeProblems(this.JSON_PROBLEM_MARKER_TYPE);
    }
}

