/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.json.text.rules;

import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IPredicateRule;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.SingleLineRule;
import org.eclipse.jface.text.rules.Token;

public class JSONPropertyRule
implements IPredicateRule {
    private IRule _singleQuotedRule;
    private IRule _doubleQuotedRule;
    private IToken _token;
    private IToken _successToken;

    public JSONPropertyRule(IToken singleQuotedToken, IToken doubleQuotedToken, IToken token) {
        this._singleQuotedRule = new SingleLineRule("'", "'", singleQuotedToken, '\\');
        this._doubleQuotedRule = new SingleLineRule("\"", "\"", doubleQuotedToken, '\\');
        this._token = token;
        this._successToken = Token.UNDEFINED;
    }

    public IToken evaluate(ICharacterScanner scanner) {
        IToken token = this._doubleQuotedRule.evaluate(scanner);
        if (token == Token.UNDEFINED) {
            token = this._singleQuotedRule.evaluate(scanner);
        }
        if (token != Token.UNDEFINED) {
            char c = (char)scanner.read();
            int count = 1;
            while (Character.isWhitespace(c)) {
                c = (char)scanner.read();
                ++count;
            }
            if (c == ':') {
                token = this._token;
            }
            int i = 0;
            while (i < count) {
                scanner.unread();
                ++i;
            }
        }
        this._successToken = token;
        return this._successToken;
    }

    public IToken evaluate(ICharacterScanner scanner, boolean resume) {
        return this.evaluate(scanner);
    }

    public IToken getSuccessToken() {
        return this._successToken;
    }
}

