/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.json.outline;

import com.aptana.editor.common.outline.CommonOutlineItem;
import com.aptana.editor.json.JSONPlugin;
import com.aptana.editor.json.parsing.ast.JSONArrayNode;
import com.aptana.editor.json.parsing.ast.JSONEntryNode;
import com.aptana.editor.json.parsing.ast.JSONFalseNode;
import com.aptana.editor.json.parsing.ast.JSONNode;
import com.aptana.editor.json.parsing.ast.JSONNullNode;
import com.aptana.editor.json.parsing.ast.JSONNumberNode;
import com.aptana.editor.json.parsing.ast.JSONObjectNode;
import com.aptana.editor.json.parsing.ast.JSONStringNode;
import com.aptana.editor.json.parsing.ast.JSONTrueNode;
import com.aptana.parsing.ast.IParseNode;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

public class JSONOutlineLabelProvider
extends LabelProvider {
    private static final Image ARRAY = JSONPlugin.getImage("icons/array-literal.png");
    private static final Image BOOLEAN = JSONPlugin.getImage("icons/boolean.png");
    private static final Image NULL = JSONPlugin.getImage("icons/null.png");
    private static final Image NUMBER = JSONPlugin.getImage("icons/number.png");
    private static final Image OBJECT = JSONPlugin.getImage("icons/object-literal.png");
    private static final Image STRING = JSONPlugin.getImage("icons/string.png");

    public Image getImage(Object element) {
        Image result = null;
        if (element instanceof JSONNode) {
            JSONNode node = (JSONNode)((Object)element);
            switch (node.getType()) {
                case ARRAY: {
                    result = ARRAY;
                    break;
                }
                case TRUE: 
                case FALSE: {
                    result = BOOLEAN;
                    break;
                }
                case NULL: {
                    result = NULL;
                    break;
                }
                case NUMBER: {
                    result = NUMBER;
                    break;
                }
                case OBJECT: {
                    result = OBJECT;
                    break;
                }
                case STRING: {
                    result = STRING;
                }
            }
        } else if (element instanceof CommonOutlineItem) {
            CommonOutlineItem item = (CommonOutlineItem)element;
            result = this.getImage(item.getReferenceNode());
        }
        return result == null ? super.getImage(element) : result;
    }

    public String getText(Object element) {
        String result = null;
        if (element instanceof JSONNode) {
            JSONNode node = (JSONNode)((Object)element);
            IParseNode parent = node.getParent();
            if (parent instanceof JSONEntryNode) {
                if (parent.getChildCount() == 2) {
                    IParseNode frist = parent.getFirstChild();
                    if (frist instanceof JSONStringNode) {
                        IParseNode last = parent.getLastChild();
                        if (last instanceof JSONStringNode) {
                            result = String.valueOf(frist.getText()) + " : \"" + last.getText() + "\"";
                        } else if (last instanceof JSONNumberNode || last instanceof JSONNullNode || last instanceof JSONTrueNode || last instanceof JSONFalseNode) {
                            result = String.valueOf(frist.getText()) + " : " + last.getText();
                        } else if (last instanceof JSONArrayNode) {
                            result = String.valueOf(frist.getText()) + " : [" + last.getChildCount() + "]";
                        } else if (last instanceof JSONObjectNode) {
                            result = String.valueOf(frist.getText()) + " : {}";
                        }
                    }
                    if (result == null) {
                        result = parent.getFirstChild().getText();
                    }
                }
            } else if (parent instanceof JSONArrayNode) {
                result = "[" + parent.getChildIndex((IParseNode)node) + "] : ";
                result = node instanceof JSONStringNode ? String.valueOf(result) + "\"" + node.getText() + "\"" : String.valueOf(result) + node.getText();
            }
            if (result == null) {
                result = node.getText();
            }
        } else if (element instanceof CommonOutlineItem) {
            CommonOutlineItem item = (CommonOutlineItem)element;
            result = this.getText(item.getReferenceNode());
        }
        return result == null ? super.getText(element) : result;
    }
}

