/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.json;

public class CommentsFilter {
    private final char[] chars;
    private char lastCh;
    private boolean inLineComment;
    private boolean inBlockComment;
    private boolean isDoubleStr;
    private boolean inStr;

    public CommentsFilter(String input) {
        this.chars = input.toCharArray();
        this.process();
    }

    private void process() {
        int i = 0;
        while (i < this.chars.length) {
            char ch = this.chars[i];
            if (this.inLineComment) {
                if (ch == '\n' || ch == '\r') {
                    this.inLineComment = false;
                } else {
                    this.chars[i] = 32;
                }
            } else if (this.inBlockComment) {
                if (this.lastCh == '*' && ch == '/') {
                    this.inBlockComment = false;
                }
                this.chars[i] = this.chars[i] == '\n' ? 10 : 32;
            } else if (this.inStr) {
                if ((ch == '\'' && !this.isDoubleStr || ch == '\"' && this.isDoubleStr) && i > 0 && this.chars[i - 1] != '\\') {
                    this.inStr = false;
                    this.isDoubleStr = false;
                }
            } else if (ch == '\'') {
                this.inStr = true;
                this.isDoubleStr = false;
            } else if (ch == '\"') {
                this.inStr = true;
                this.isDoubleStr = true;
            } else if (this.lastCh == '/' && ch == '/') {
                this.inLineComment = true;
                this.chars[i - 1] = 32;
                this.chars[i] = 32;
            } else if (this.lastCh == '/' && ch == '*') {
                this.inBlockComment = true;
                this.chars[i - 1] = 32;
                this.chars[i] = 32;
            }
            this.lastCh = ch;
            ++i;
        }
    }

    public String toString() {
        return new String(this.chars);
    }

    public static String filterComments(String input) {
        return new CommentsFilter(input).toString();
    }
}

