--[[--
EyeonToBoujou2dTracks.eyeonscript 

This tool exports fusion tracker data to boujou 2d tracks

Requires   : Fusion 5.21 Build 23 or later
Written By : Srecko Zrilic [srecko@eyeonline.com]
Written On : Thursday 17th of February 2011

Important  : If exporting data at key times, assign exp_keys = true; if exporting tracks sapmles assign
		exp_keys = false
--]]--

local exp_keys = true

if (composition == nil) or (tool == nil) then
	print("Run this script on a Tracker tool")
	exit()
end

if tool.ID ~= "Tracker" then
	print("Run this script on a Tracker modifier\n")
	exit()
end

local dlg = iup.filedlg{ title = "Select output file", dialogtype = "SAVE", extfilter = "Boujou (*.txt)|*.txt|All Files (*.*)te|*.*|" }
print("dialog.")

print(dlg:popup(0,0))

if dlg.status ~= "-1" then
	local filename = dlg.value
	local file, err = io.open(filename, "w")
	
	if file then
		local inps  = tool:GetInputList("Point")
		if inps == nil then
			print("No tracker point inputs")
			exit()
		end
--[[--
		file:write(string.format("# boujou 2d tracks export: text\n"))
		file:write(string.format("# boujou version: 5.0.2 51953\n"))
		file:write(string.format("# Creation date :\n"))
		file:write(string.format("#\n"))
		file:write(string.format("# track_id    view      x    y\n"))
--]]--
		if exp_keys then
			for i, inp in pairs(inps) do
				local attr = inp:GetAttrs() 
				if attr.INPB_Connected then 
					local connectedTool = inp:GetConnectedOutput():GetTool()
					if connectedTool then
						local name = connectedTool.Name
						local keys = connectedTool:GetKeyFrames()
						for ff, frame in pairs(keys) do
							if frame > -1e+006 then
								local out = inp:GetConnectedOutput()
								if out then
									local point = out:GetValue(frame)
									if point then
										local x = point.X * 1920
										local y = (1.0 - point.Y) * 1080 
										file:write(string.format("%s %g %g %g\n", name, frame, x, y))
									end
								end
							end
						end
					end
				end
			end
		else
			local startframe = 1000000 -- calculating time range (startframe, endframe)
			local endframe = -1000000
			for i, inp in pairs(inps) do
				local attr = inp:GetAttrs() 
				if attr.INPB_Connected then 
					local connectedTool = inp:GetConnectedOutput():GetTool()
					local keys = connectedTool:GetKeyFrames()
					for ff, frame in pairs(keys) do
						if frame > -1e+006 then
							startframe = math.min(startframe, frame)
							endframe = math.max(endframe, frame)
						end
					end
				end
			end

			if endframe < startframe then -- if calculating time range fails
				local attrs = comp:GetAttrs()
				startframe = attrs.COMPN_RenderStartTime
				endframe = attrs.COMPN_RenderEndTime
			end

			for i, inp in pairs(inps) do
				local attr = inp:GetAttrs() 
				if attr.INPB_Connected then 
					for frame = startframe, endframe do
						local out = inp:GetConnectedOutput()
						if out then
							local connectedTool = inp:GetConnectedOutput():GetTool()
							if connectedTool then
								local name = connectedTool.Name
								local point = out:GetValue(frame)
								if point then
									local x = point.X * 1920
									local y = (1.0 - point.Y) * 1080 
									file:write(string.format("%s %g %g %g\n", name, frame, x, y))
								end
							end
						end
					end
					ii = ii + 1
				end
			end
		end
		file:close()
		print(tool.Name.." export complete\n")
	else
		print("Could not open file "..filename.."\n"..err.."\n")
	end
end
