--[[--
EyeonPathToBoujou2d.eyeonscript 

This tool exports fusion polypath and xypath to boujou 2d format

Requires   : Fusion 5.21 Build 23 or later
Written By : Srecko Zrilic [srecko@eyeonline.com]
Written On : Thursday 17th of February 2011

Important  : If exporting data at key times, assign exp_keys = true; if exporting path sapmles assign
		exp_keys = false
--]]--

local exp_keys = true

if tool == nil then
	print("Run this script on a Path modifier")
	exit()
end

if tool.ID ~= "PolyPath" and tool.ID ~= "XYPath" then
	print("Run this script on a Path modifier")
	exit()
end

local dlg = iup.filedlg{ title = "Select output file", dialogtype = "SAVE", extfilter = "Boujou (*.txt)|*.txt|All Files (*.*)te|*.*|" }
print("dialog.")

print(dlg:popup(0,0))

if dlg.status ~= "-1" then
	local filename = dlg.value
	local file, err = io.open(filename, "w")
	
	if file then
		local out = tool:FindMainOutput(1)
		if out ~= nil then
			local keys = tool:GetKeyFrames()
			if (keys == nil) and (exp_keys == true) then
				print("No keys")
				exit()
			end

			local name = tool.Name
			if exp_keys then
				for ff, frame in pairs(keys) do
					if frame > -1e+006 then
						local point = out:GetValue(frame)
						if point then
							local x = point.X * 1920
							local y = (1.0 - point.Y) * 1080 
							file:write(string.format("%s %g %g %g\n", name, frame, x, y))
						end
					end
				end
			else
				local startframe = 1000000 -- calculating time range (startframe, endframe)
				local endframe = -1000000
				if keys then
					for ff, frame in pairs(keys) do
						if frame > -1e+006 then
							startframe = math.min(startframe, frame)
							endframe = math.max(endframe, frame)
						end
					end
				end

				if endframe < startframe then -- if calculating time range fails
					local attrs = comp:GetAttrs()
					startframe = attrs.COMPN_RenderStartTime
					endframe = attrs.COMPN_RenderEndTime
				end
				for frame = startframe, endframe do
					local point = out:GetValue(frame)
					if point then
						local x = point.X * 1920
						local y = (1.0 - point.Y) * 1080 
						file:write(string.format("%s %g %g %g\n", name, frame, x, y))
					end
				end
			end
		end
		file:close()
		print(tool.Name.." export complete\n")
	else
		print("Could not open file "..filename.."\n"..err.."\n")
	end
end
