-- Converts a sequence of selected colour tools into a 3D LUT
-- Last updated: 14-Sept-09

-- Get a handy 2D viewer
view = comp.CurrentFrame.LeftView.CurrentViewer
if view == nil or view:GetID() ~= "GLImageViewer" then
   comp.CurrentFrame:ViewOn(1)
	view = comp.CurrentFrame.LeftView.CurrentViewer
end

if view == nil or view:GetID() ~= "GLImageViewer" then
   print("Error - bad tool selected\n")
   exit(10)
end

-- Get temporary settings filename
filename = comp:MapPath("Temp:TempLUTConversion.setting")

-- Copy selected tools to a table
seltools = comp:CopySettings()	-- save selected tools

-- Save to settings file
if bmd.writefile(filename, seltools) == false then
   print("Error saving selected tools\n");
   exit(10)
end

-- Save the existing LUT setup first
oldLUTfilename = comp:MapPath("Temp:TempLUTBackup.viewlut")
view:SaveLUTFile(oldLUTfilename)

-- Load the saved tool settings as a LUT macro
if view:LoadLUTFile(filename) == false then
	print("Error loading saved tools as a LUT\n")
	exit(10)
end

wasEnabled = view:IsLUTEnabled()
view:EnableLUT(true)

-- Do the export
ok, resultfilename = view:ExportTo3DLUT()	-- show UI

if resultfilename then
	resultfilename = " to "..resultfilename
else
	resultfilename = ""
end
	
if ok then
	print("Success: LUT exported"..resultfilename.."");
else
	print("No LUT exported.");
end

-- restore the old LUT settings
view:LoadLUTFile(oldLUTfilename)
view:EnableLUT(wasEnabled)

os.remove(filename)
os.remove(oldLUTfilename)

