


define('panels/search/search',['require','modules/settings_cache','shared/lazy_loader'],function(require) {
  var SettingsCache = require('modules/settings_cache');
  var LazyLoader = require('shared/lazy_loader');

  function Search() {
    this._searchUrlTemplate = null;
    this._searchEngineSelect = null;
  }

  Search.prototype.init = function(searchEngineSelect) {
    this._searchEngineSelect = searchEngineSelect;
    this.getCurrentSearchEngine();
    this.initSearchEngineSelect();
  };

  Search.prototype.getCurrentSearchEngine = function() {
    SettingsCache.getSettings((function(settingsCache) {
      this._searchUrlTemplate = settingsCache['search.urlTemplate'];
    }).bind(this));
  };

  Search.prototype.initSearchEngineSelect = function() {
    // Get search provider list from settings
    SettingsCache.getSettings((function(settingsCache) {
      var searchEngineList = settingsCache['search.providers'];
      // If the list is empty, populate it from default JSON file
      if (!searchEngineList) {
        this.populateSearchEngines()
        .then(this.generateSearchEngineOptions.bind(this));
        return;
      }

      // Otherwise just go ahead and generate the options
      this.generateSearchEngineOptions(searchEngineList);
    }).bind(this));
  };

  /**
   * Populate search engine list in settings from default JSON file.
   *
   * @param {Function} callback function to call with retrieved data.
   */
  Search.prototype.populateSearchEngines = function() {
    return LazyLoader.getJSON('/resources/search/providers.json')
    .then(function(data) {
      if (!data) {
        return;
      }

      var result = navigator.mozSettings.createLock().set({
        'search.providers': data
      });
      result.onerror = function() {
        console.error('Unable to set search providers setting');
      };

      return data;
    })
    .catch(function () {
      console.error('Unable to get default search provider file.');
      return;
    });
  };

  /**
   * Generate <options> for the search engine <select> element.
   *
   * @param {Array} data An array of engine objects.
   * @this
   */
  Search.prototype.generateSearchEngineOptions = function(data) {
    if (!data) {
      return;
    }

    if (!this._searchEngineSelect) {
      return;
    }

    this._searchEngineSelect.innerHTML = '';

    var selectFragment = document.createDocumentFragment();
    var optionNode = document.createElement('option');

    for (var i = 0; i < data.length; i++) {
      var engine = data[i];
      var option = optionNode.cloneNode();
      option.value = engine.urlTemplate;
      option.text = engine.title;
      if (engine.urlTemplate == this._searchUrlTemplate) {
        option.selected = true;
      }
      selectFragment.appendChild(option);
    }

    this._searchEngineSelect.appendChild(selectFragment);
  };

  return function() {
    return new Search();
  };
});

/**
 * SearchSettings provides the settings interface for search (i.e. default
 * search engine)
 */
define('panels/search/panel',['require','modules/settings_panel','panels/search/search'],function(require) {
  

  var SettingsPanel = require('modules/settings_panel');
  var Search = require('panels/search/search');

  var search;

  function onInit(panel) {
    var searchEngineSelect = panel.querySelector('[name="search.urlTemplate"]');
    search = Search();
    search.init(searchEngineSelect);
  }

  return function() {
    // SettingsPanel is not a constructor. Not even a little bit.
    return SettingsPanel({
      onInit: onInit
    });
  };
});
