/**
 * Setup is done; add another account?
 */

define(['require','cards','l10n!','./base','template!./setup_account_prefs.html','./account_prefs_mixins'],function(require) {

var cards = require('cards'),
    mozL10n = require('l10n!');

return [
  require('./base')(require('template!./setup_account_prefs.html')),
  require('./account_prefs_mixins'),
  {
    onArgs: function(args) {
      this.account = args.account;
      this.identity = this.account.identities[0];

      // Establish defaults specifically for our email app.
      this.identity.modifyIdentity({
        signatureEnabled: true,
        signature: mozL10n.get('settings-default-signature-2')
      });

      this._bindPrefs('tng-account-check-interval',
                      'tng-notify-mail',
                      'tng-sound-onsend',
                      'tng-signature-input',
                      'signature-button');
    },

    onNext: function(event) {
      cards.pushCard('setup_done', 'animate');
    },

    onCardVisible: function() {
      this.updateSignatureButton();
    },

    die: function() {
    }
  }
];
});
