
/**
 * alameda 0.2.0 Copyright (c) 2011-2014, The Dojo Foundation All Rights Reserved.
 * Available via the MIT or new BSD license.
 * see: http://github.com/requirejs/alameda for details
 */
//Going sloppy to avoid 'use strict' string cost, but strict practices should
//be followed.
/*jslint sloppy: true, nomen: true, regexp: true */
/*global setTimeout, process, document, navigator, importScripts,
  setImmediate */

var requirejs, require, define;
(function (global, undef) {
    var prim, topReq, dataMain, src, subPath,
        bootstrapConfig = requirejs || require,
        hasOwn = Object.prototype.hasOwnProperty,
        contexts = {},
        queue = [],
        currDirRegExp = /^\.\//,
        urlRegExp = /^\/|\:|\?|\.js$/,
        commentRegExp = /(\/\*([\s\S]*?)\*\/|([^:]|^)\/\/(.*)$)/mg,
        cjsRequireRegExp = /[^.]\s*require\s*\(\s*["']([^'"\s]+)["']\s*\)/g,
        jsSuffixRegExp = /\.js$/;

    if (typeof requirejs === 'function') {
        return;
    }

    function hasProp(obj, prop) {
        return hasOwn.call(obj, prop);
    }

    function getOwn(obj, prop) {
        return obj && hasProp(obj, prop) && obj[prop];
    }

    /**
     * Cycles over properties in an object and calls a function for each
     * property value. If the function returns a truthy value, then the
     * iteration is stopped.
     */
    function eachProp(obj, func) {
        var prop;
        for (prop in obj) {
            if (hasProp(obj, prop)) {
                if (func(obj[prop], prop)) {
                    break;
                }
            }
        }
    }

    /**
     * Simple function to mix in properties from source into target,
     * but only if target does not already have a property of the same name.
     */
    function mixin(target, source, force, deepStringMixin) {
        if (source) {
            eachProp(source, function (value, prop) {
                if (force || !hasProp(target, prop)) {
                    if (deepStringMixin && typeof value === 'object' && value &&
                        !Array.isArray(value) && typeof value !== 'function' &&
                        !(value instanceof RegExp)) {

                        if (!target[prop]) {
                            target[prop] = {};
                        }
                        mixin(target[prop], value, force, deepStringMixin);
                    } else {
                        target[prop] = value;
                    }
                }
            });
        }
        return target;
    }

    //Allow getting a global that expressed in
    //dot notation, like 'a.b.c'.
    function getGlobal(value) {
        if (!value) {
            return value;
        }
        var g = global;
        value.split('.').forEach(function (part) {
            g = g[part];
        });
        return g;
    }

    //START prim 0.0.6
    /**
     * Changes from baseline prim
     * - removed UMD registration
     */
    (function () {
        

        var waitingId, nextTick,
            waiting = [];

        function callWaiting() {
            waitingId = 0;
            var w = waiting;
            waiting = [];
            while (w.length) {
                w.shift()();
            }
        }

        function asyncTick(fn) {
            waiting.push(fn);
            if (!waitingId) {
                waitingId = setTimeout(callWaiting, 0);
            }
        }

        function syncTick(fn) {
            fn();
        }

        function isFunObj(x) {
            var type = typeof x;
            return type === 'object' || type === 'function';
        }

        //Use setImmediate.bind() because attaching it (or setTimeout directly
        //to prim will result in errors. Noticed first on IE10,
        //issue requirejs/alameda#2)
        nextTick = typeof setImmediate === 'function' ? setImmediate.bind() :
            (typeof process !== 'undefined' && process.nextTick ?
                process.nextTick : (typeof setTimeout !== 'undefined' ?
                    asyncTick : syncTick));

        function notify(ary, value) {
            prim.nextTick(function () {
                ary.forEach(function (item) {
                    item(value);
                });
            });
        }

        function callback(p, ok, yes) {
            if (p.hasOwnProperty('v')) {
                prim.nextTick(function () {
                    yes(p.v);
                });
            } else {
                ok.push(yes);
            }
        }

        function errback(p, fail, no) {
            if (p.hasOwnProperty('e')) {
                prim.nextTick(function () {
                    no(p.e);
                });
            } else {
                fail.push(no);
            }
        }

        prim = function prim(fn) {
            var promise, f,
                p = {},
                ok = [],
                fail = [];

            function makeFulfill() {
                var f, f2,
                    called = false;

                function fulfill(v, prop, listeners) {
                    if (called) {
                        return;
                    }
                    called = true;

                    if (promise === v) {
                        called = false;
                        f.reject(new TypeError('value is same promise'));
                        return;
                    }

                    try {
                        var then = v && v.then;
                        if (isFunObj(v) && typeof then === 'function') {
                            f2 = makeFulfill();
                            then.call(v, f2.resolve, f2.reject);
                        } else {
                            p[prop] = v;
                            notify(listeners, v);
                        }
                    } catch (e) {
                        called = false;
                        f.reject(e);
                    }
                }

                f = {
                    resolve: function (v) {
                        fulfill(v, 'v', ok);
                    },
                    reject: function(e) {
                        fulfill(e, 'e', fail);
                    }
                };
                return f;
            }

            f = makeFulfill();

            promise = {
                then: function (yes, no) {
                    var next = prim(function (nextResolve, nextReject) {

                        function finish(fn, nextFn, v) {
                            try {
                                if (fn && typeof fn === 'function') {
                                    v = fn(v);
                                    nextResolve(v);
                                } else {
                                    nextFn(v);
                                }
                            } catch (e) {
                                nextReject(e);
                            }
                        }

                        callback(p, ok, finish.bind(undefined, yes, nextResolve));
                        errback(p, fail, finish.bind(undefined, no, nextReject));

                    });
                    return next;
                },

                catch: function (no) {
                    return promise.then(null, no);
                }
            };

            try {
                fn(f.resolve, f.reject);
            } catch (e) {
                f.reject(e);
            }

            return promise;
        };

        prim.resolve = function (value) {
            return prim(function (yes) {
                yes(value);
            });
        };

        prim.reject = function (err) {
            return prim(function (yes, no) {
                no(err);
            });
        };

        prim.cast = function (x) {
            // A bit of a weak check, want "then" to be a function,
            // but also do not want to trigger a getter if accessing
            // it. Good enough for now.
            if (isFunObj(x) && 'then' in x) {
                return x;
            } else {
                return prim(function (yes, no) {
                    if (x instanceof Error) {
                        no(x);
                    } else {
                        yes(x);
                    }
                });
            }
        };

        prim.all = function (ary) {
            return prim(function (yes, no) {
                var count = 0,
                    length = ary.length,
                    result = [];

                function resolved(i, v) {
                    result[i] = v;
                    count += 1;
                    if (count === length) {
                        yes(result);
                    }
                }

                ary.forEach(function (item, i) {
                    prim.cast(item).then(function (v) {
                        resolved(i, v);
                    }, function (err) {
                        no(err);
                    });
                });
            });
        };

        prim.nextTick = nextTick;
    }());
    //END prim

    function newContext(contextName) {
        var req, main, makeMap, callDep, handlers, checkingLater, load, context,
            defined = {},
            waiting = {},
            config = {
                //Defaults. Do not set a default for map
                //config to speed up normalize(), which
                //will run faster if there is no default.
                waitSeconds: 7,
                baseUrl: './',
                paths: {},
                bundles: {},
                pkgs: {},
                shim: {},
                config: {}
            },
            mapCache = {},
            requireDeferreds = [],
            deferreds = {},
            calledDefine = {},
            calledPlugin = {},
            loadCount = 0,
            startTime = (new Date()).getTime(),
            errCount = 0,
            trackedErrors = {},
            urlFetched = {},
            bundlesMap = {};

        /**
         * Trims the . and .. from an array of path segments.
         * It will keep a leading path segment if a .. will become
         * the first path segment, to help with module name lookups,
         * which act like paths, but can be remapped. But the end result,
         * all paths that use this function should look normalized.
         * NOTE: this method MODIFIES the input array.
         * @param {Array} ary the array of path segments.
         */
        function trimDots(ary) {
            var i, part, length = ary.length;
            for (i = 0; i < length; i++) {
                part = ary[i];
                if (part === '.') {
                    ary.splice(i, 1);
                    i -= 1;
                } else if (part === '..') {
                    if (i === 1 && (ary[2] === '..' || ary[0] === '..')) {
                        //End of the line. Keep at least one non-dot
                        //path segment at the front so it can be mapped
                        //correctly to disk. Otherwise, there is likely
                        //no path mapping for a path starting with '..'.
                        //This can still fail, but catches the most reasonable
                        //uses of ..
                        break;
                    } else if (i > 0) {
                        ary.splice(i - 1, 2);
                        i -= 2;
                    }
                }
            }
        }

        /**
         * Given a relative module name, like ./something, normalize it to
         * a real name that can be mapped to a path.
         * @param {String} name the relative name
         * @param {String} baseName a real name that the name arg is relative
         * to.
         * @param {Boolean} applyMap apply the map config to the value. Should
         * only be done if this normalization is for a dependency ID.
         * @returns {String} normalized name
         */
        function normalize(name, baseName, applyMap) {
            var pkgMain, mapValue, nameParts, i, j, nameSegment, lastIndex,
                foundMap, foundI, foundStarMap, starI,
                baseParts = baseName && baseName.split('/'),
                normalizedBaseParts = baseParts,
                map = config.map,
                starMap = map && map['*'];

            //Adjust any relative paths.
            if (name && name.charAt(0) === '.') {
                //If have a base name, try to normalize against it,
                //otherwise, assume it is a top-level require that will
                //be relative to baseUrl in the end.
                if (baseName) {
                    //Convert baseName to array, and lop off the last part,
                    //so that . matches that 'directory' and not name of the baseName's
                    //module. For instance, baseName of 'one/two/three', maps to
                    //'one/two/three.js', but we want the directory, 'one/two' for
                    //this normalization.
                    normalizedBaseParts = baseParts.slice(0, baseParts.length - 1);
                    name = name.split('/');
                    lastIndex = name.length - 1;

                    // If wanting node ID compatibility, strip .js from end
                    // of IDs. Have to do this here, and not in nameToUrl
                    // because node allows either .js or non .js to map
                    // to same file.
                    if (config.nodeIdCompat && jsSuffixRegExp.test(name[lastIndex])) {
                        name[lastIndex] = name[lastIndex].replace(jsSuffixRegExp, '');
                    }

                    name = normalizedBaseParts.concat(name);
                    trimDots(name);
                    name = name.join('/');
                } else if (name.indexOf('./') === 0) {
                    // No baseName, so this is ID is resolved relative
                    // to baseUrl, pull off the leading dot.
                    name = name.substring(2);
                }
            }

            //Apply map config if available.
            if (applyMap && map && (baseParts || starMap)) {
                nameParts = name.split('/');

                outerLoop: for (i = nameParts.length; i > 0; i -= 1) {
                    nameSegment = nameParts.slice(0, i).join('/');

                    if (baseParts) {
                        //Find the longest baseName segment match in the config.
                        //So, do joins on the biggest to smallest lengths of baseParts.
                        for (j = baseParts.length; j > 0; j -= 1) {
                            mapValue = getOwn(map, baseParts.slice(0, j).join('/'));

                            //baseName segment has config, find if it has one for
                            //this name.
                            if (mapValue) {
                                mapValue = getOwn(mapValue, nameSegment);
                                if (mapValue) {
                                    //Match, update name to the new value.
                                    foundMap = mapValue;
                                    foundI = i;
                                    break outerLoop;
                                }
                            }
                        }
                    }

                    //Check for a star map match, but just hold on to it,
                    //if there is a shorter segment match later in a matching
                    //config, then favor over this star map.
                    if (!foundStarMap && starMap && getOwn(starMap, nameSegment)) {
                        foundStarMap = getOwn(starMap, nameSegment);
                        starI = i;
                    }
                }

                if (!foundMap && foundStarMap) {
                    foundMap = foundStarMap;
                    foundI = starI;
                }

                if (foundMap) {
                    nameParts.splice(0, foundI, foundMap);
                    name = nameParts.join('/');
                }
            }

            // If the name points to a package's name, use
            // the package main instead.
            pkgMain = getOwn(config.pkgs, name);

            return pkgMain ? pkgMain : name;
        }

        function makeShimExports(value) {
            function fn() {
                var ret;
                if (value.init) {
                    ret = value.init.apply(global, arguments);
                }
                return ret || (value.exports && getGlobal(value.exports));
            }
            return fn;
        }

        function takeQueue(anonId) {
            var i, id, args, shim;
            for (i = 0; i < queue.length; i += 1) {
                //Peek to see if anon
                if (typeof queue[i][0] !== 'string') {
                    if (anonId) {
                        queue[i].unshift(anonId);
                        anonId = undef;
                    } else {
                        //Not our anon module, stop.
                        break;
                    }
                }
                args = queue.shift();
                id = args[0];
                i -= 1;

                if (!hasProp(defined, id) && !hasProp(waiting, id)) {
                    if (hasProp(deferreds, id)) {
                        main.apply(undef, args);
                    } else {
                        waiting[id] = args;
                    }
                }
            }

            //if get to the end and still have anonId, then could be
            //a shimmed dependency.
            if (anonId) {
                shim = getOwn(config.shim, anonId) || {};
                main(anonId, shim.deps || [], shim.exportsFn);
            }
        }

        function makeRequire(relName, topLevel) {
            var req = function (deps, callback, errback, alt) {
                var name, cfg;

                if (topLevel) {
                    takeQueue();
                }

                if (typeof deps === "string") {
                    if (handlers[deps]) {
                        return handlers[deps](relName);
                    }
                    //Just return the module wanted. In this scenario, the
                    //deps arg is the module name, and second arg (if passed)
                    //is just the relName.
                    //Normalize module name, if it contains . or ..
                    name = makeMap(deps, relName, true).id;
                    if (!hasProp(defined, name)) {
                        throw new Error('Not loaded: ' + name);
                    }
                    return defined[name];
                } else if (deps && !Array.isArray(deps)) {
                    //deps is a config object, not an array.
                    cfg = deps;
                    deps = undef;

                    if (Array.isArray(callback)) {
                        //callback is an array, which means it is a dependency list.
                        //Adjust args if there are dependencies
                        deps = callback;
                        callback = errback;
                        errback = alt;
                    }

                    if (topLevel) {
                        //Could be a new context, so call returned require
                        return req.config(cfg)(deps, callback, errback);
                    }
                }

                //Support require(['a'])
                callback = callback || function () {};

                //Simulate async callback;
                prim.nextTick(function () {
                    //Grab any modules that were defined after a
                    //require call.
                    takeQueue();
                    main(undef, deps || [], callback, errback, relName);
                });

                return req;
            };

            req.isBrowser = typeof document !== 'undefined' &&
                typeof navigator !== 'undefined';

            req.nameToUrl = function (moduleName, ext, skipExt) {
                var paths, syms, i, parentModule, url,
                    parentPath, bundleId,
                    pkgMain = getOwn(config.pkgs, moduleName);

                if (pkgMain) {
                    moduleName = pkgMain;
                }

                bundleId = getOwn(bundlesMap, moduleName);

                if (bundleId) {
                    return req.nameToUrl(bundleId, ext, skipExt);
                }

                //If a colon is in the URL, it indicates a protocol is used and it is just
                //an URL to a file, or if it starts with a slash, contains a query arg (i.e. ?)
                //or ends with .js, then assume the user meant to use an url and not a module id.
                //The slash is important for protocol-less URLs as well as full paths.
                if (urlRegExp.test(moduleName)) {
                    //Just a plain path, not module name lookup, so just return it.
                    //Add extension if it is included. This is a bit wonky, only non-.js things pass
                    //an extension, this method probably needs to be reworked.
                    url = moduleName + (ext || '');
                } else {
                    //A module that needs to be converted to a path.
                    paths = config.paths;

                    syms = moduleName.split('/');
                    //For each module name segment, see if there is a path
                    //registered for it. Start with most specific name
                    //and work up from it.
                    for (i = syms.length; i > 0; i -= 1) {
                        parentModule = syms.slice(0, i).join('/');

                        parentPath = getOwn(paths, parentModule);
                        if (parentPath) {
                            //If an array, it means there are a few choices,
                            //Choose the one that is desired
                            if (Array.isArray(parentPath)) {
                                parentPath = parentPath[0];
                            }
                            syms.splice(0, i, parentPath);
                            break;
                        }
                    }

                    //Join the path parts together, then figure out if baseUrl is needed.
                    url = syms.join('/');
                    url += (ext || (/^data\:|\?/.test(url) || skipExt ? '' : '.js'));
                    url = (url.charAt(0) === '/' || url.match(/^[\w\+\.\-]+:/) ? '' : config.baseUrl) + url;
                }

                return config.urlArgs ? url +
                                        ((url.indexOf('?') === -1 ? '?' : '&') +
                                         config.urlArgs) : url;
            };

            /**
             * Converts a module name + .extension into an URL path.
             * *Requires* the use of a module name. It does not support using
             * plain URLs like nameToUrl.
             */
            req.toUrl = function (moduleNamePlusExt) {
                var ext,
                    index = moduleNamePlusExt.lastIndexOf('.'),
                    segment = moduleNamePlusExt.split('/')[0],
                    isRelative = segment === '.' || segment === '..';

                //Have a file extension alias, and it is not the
                //dots from a relative path.
                if (index !== -1 && (!isRelative || index > 1)) {
                    ext = moduleNamePlusExt.substring(index, moduleNamePlusExt.length);
                    moduleNamePlusExt = moduleNamePlusExt.substring(0, index);
                }

                return req.nameToUrl(normalize(moduleNamePlusExt, relName), ext, true);
            };

            req.defined = function (id) {
                return hasProp(defined, makeMap(id, relName, true).id);
            };

            req.specified = function (id) {
                id = makeMap(id, relName, true).id;
                return hasProp(defined, id) || hasProp(deferreds, id);
            };

            return req;
        }

        function resolve(name, d, value) {
            if (name) {
                defined[name] = value;
                if (requirejs.onResourceLoad) {
                    requirejs.onResourceLoad(context, d.map, d.deps);
                }
            }
            d.finished = true;
            d.resolve(value);
        }

        function reject(d, err) {
            d.finished = true;
            d.rejected = true;
            d.reject(err);
        }

        function makeNormalize(relName) {
            return function (name) {
                return normalize(name, relName, true);
            };
        }

        function defineModule(d) {
            var name = d.map.id,
                ret = d.factory.apply(defined[name], d.values);

            if (name) {
                // Favor return value over exports. If node/cjs in play,
                // then will not have a return value anyway. Favor
                // module.exports assignment over exports object.
                if (ret === undef) {
                    if (d.cjsModule) {
                        ret = d.cjsModule.exports;
                    } else if (d.usingExports) {
                        ret = defined[name];
                    }
                }
            } else {
                //Remove the require deferred from the list to
                //make cycle searching faster. Do not need to track
                //it anymore either.
                requireDeferreds.splice(requireDeferreds.indexOf(d), 1);
            }
            resolve(name, d, ret);
        }

        //This method is attached to every module deferred,
        //so the "this" in here is the module deferred object.
        function depFinished(val, i) {
            if (!this.rejected && !this.depDefined[i]) {
                this.depDefined[i] = true;
                this.depCount += 1;
                this.values[i] = val;
                if (!this.depending && this.depCount === this.depMax) {
                    defineModule(this);
                }
            }
        }

        function makeDefer(name) {
            var d = {};
            d.promise = prim(function (resolve, reject) {
                d.resolve = resolve;
                d.reject = reject;
            });
            d.map = name ? makeMap(name, null, true) : {};
            d.depCount = 0;
            d.depMax = 0;
            d.values = [];
            d.depDefined = [];
            d.depFinished = depFinished;
            if (d.map.pr) {
                //Plugin resource ID, implicitly
                //depends on plugin. Track it in deps
                //so cycle breaking can work
                d.deps = [makeMap(d.map.pr)];
            }
            return d;
        }

        function getDefer(name) {
            var d;
            if (name) {
                d = hasProp(deferreds, name) && deferreds[name];
                if (!d) {
                    d = deferreds[name] = makeDefer(name);
                }
            } else {
                d = makeDefer();
                requireDeferreds.push(d);
            }
            return d;
        }

        function makeErrback(d, name) {
            return function (err) {
                if (!d.rejected) {
                    if (!err.dynaId) {
                        err.dynaId = 'id' + (errCount += 1);
                        err.requireModules = [name];
                    }
                    reject(d, err);
                }
            };
        }

        function waitForDep(depMap, relName, d, i) {
            d.depMax += 1;

            //Do the fail at the end to catch errors
            //in the then callback execution.
            callDep(depMap, relName).then(function (val) {
                d.depFinished(val, i);
            }, makeErrback(d, depMap.id)).catch(makeErrback(d, d.map.id));
        }

        function makeLoad(id) {
            var fromTextCalled;
            function load(value) {
                //Protect against older plugins that call load after
                //calling load.fromText
                if (!fromTextCalled) {
                    resolve(id, getDefer(id), value);
                }
            }

            load.error = function (err) {
                getDefer(id).reject(err);
            };

            load.fromText = function (text, textAlt) {
                /*jslint evil: true */
                var d = getDefer(id),
                    map = makeMap(makeMap(id).n),
                   plainId = map.id;

                fromTextCalled = true;

                //Set up the factory just to be a return of the value from
                //plainId.
                d.factory = function (p, val) {
                    return val;
                };

                //As of requirejs 2.1.0, support just passing the text, to reinforce
                //fromText only being called once per resource. Still
                //support old style of passing moduleName but discard
                //that moduleName in favor of the internal ref.
                if (textAlt) {
                    text = textAlt;
                }

                //Transfer any config to this other module.
                if (hasProp(config.config, id)) {
                    config.config[plainId] = config.config[id];
                }

                try {
                    req.exec(text);
                } catch (e) {
                    reject(d, new Error('fromText eval for ' + plainId +
                                    ' failed: ' + e));
                }

                //Execute any waiting define created by the plainId
                takeQueue(plainId);

                //Mark this as a dependency for the plugin
                //resource
                d.deps = [map];
                waitForDep(map, null, d, d.deps.length);
            };

            return load;
        }

        load = typeof importScripts === 'function' ?
                function (map) {
                    var url = map.url;
                    if (urlFetched[url]) {
                        return;
                    }
                    urlFetched[url] = true;

                    //Ask for the deferred so loading is triggered.
                    //Do this before loading, since loading is sync.
                    getDefer(map.id);
                    importScripts(url);
                    takeQueue(map.id);
                } :
                function (map) {
                    var script,
                        id = map.id,
                        url = map.url;

                    if (urlFetched[url]) {
                        return;
                    }
                    urlFetched[url] = true;

                    script = document.createElement('script');
                    script.setAttribute('data-requiremodule', id);
                    script.type = config.scriptType || 'text/javascript';
                    script.charset = 'utf-8';
                    script.async = true;

                    loadCount += 1;

                    script.addEventListener('load', function () {
                        loadCount -= 1;
                        takeQueue(id);
                    }, false);
                    script.addEventListener('error', function () {
                        loadCount -= 1;
                        var err,
                            pathConfig = getOwn(config.paths, id),
                            d = getOwn(deferreds, id);
                        if (pathConfig && Array.isArray(pathConfig) && pathConfig.length > 1) {
                            script.parentNode.removeChild(script);
                            //Pop off the first array value, since it failed, and
                            //retry
                            pathConfig.shift();
                            d.map = makeMap(id);
                            load(d.map);
                        } else {
                            err = new Error('Load failed: ' + id + ': ' + script.src);
                            err.requireModules = [id];
                            getDefer(id).reject(err);
                        }
                    }, false);

                    script.src = url;

                    document.head.appendChild(script);
                };

        function callPlugin(plugin, map, relName) {
            plugin.load(map.n, makeRequire(relName), makeLoad(map.id), {});
        }

        callDep = function (map, relName) {
            var args, bundleId,
                name = map.id,
                shim = config.shim[name];

            if (hasProp(waiting, name)) {
                args = waiting[name];
                delete waiting[name];
                main.apply(undef, args);
            } else if (!hasProp(deferreds, name)) {
                if (map.pr) {
                    //If a bundles config, then just load that file instead to
                    //resolve the plugin, as it is built into that bundle.
                    if ((bundleId = getOwn(bundlesMap, name))) {
                        map.url = req.nameToUrl(bundleId);
                        load(map);
                    } else {
                        return callDep(makeMap(map.pr)).then(function (plugin) {
                            //Redo map now that plugin is known to be loaded
                            var newMap = makeMap(name, relName, true),
                                newId = newMap.id,
                                shim = getOwn(config.shim, newId);

                            //Make sure to only call load once per resource. Many
                            //calls could have been queued waiting for plugin to load.
                            if (!hasProp(calledPlugin, newId)) {
                                calledPlugin[newId] = true;
                                if (shim && shim.deps) {
                                    req(shim.deps, function () {
                                        callPlugin(plugin, newMap, relName);
                                    });
                                } else {
                                    callPlugin(plugin, newMap, relName);
                                }
                            }
                            return getDefer(newId).promise;
                        });
                    }
                } else if (shim && shim.deps) {
                    req(shim.deps, function () {
                        load(map);
                    });
                } else {
                    load(map);
                }
            }

            return getDefer(name).promise;
        };

        //Turns a plugin!resource to [plugin, resource]
        //with the plugin being undefined if the name
        //did not have a plugin prefix.
        function splitPrefix(name) {
            var prefix,
                index = name ? name.indexOf('!') : -1;
            if (index > -1) {
                prefix = name.substring(0, index);
                name = name.substring(index + 1, name.length);
            }
            return [prefix, name];
        }

        /**
         * Makes a name map, normalizing the name, and using a plugin
         * for normalization if necessary. Grabs a ref to plugin
         * too, as an optimization.
         */
        makeMap = function (name, relName, applyMap) {
            if (typeof name !== 'string') {
                return name;
            }

            var plugin, url, parts, prefix, result,
                cacheKey = name + ' & ' + (relName || '') + ' & ' + !!applyMap;

            parts = splitPrefix(name);
            prefix = parts[0];
            name = parts[1];

            if (!prefix && hasProp(mapCache, cacheKey)) {
                return mapCache[cacheKey];
            }

            if (prefix) {
                prefix = normalize(prefix, relName, applyMap);
                plugin = hasProp(defined, prefix) && defined[prefix];
            }

            //Normalize according
            if (prefix) {
                if (plugin && plugin.normalize) {
                    name = plugin.normalize(name, makeNormalize(relName));
                } else {
                    name = normalize(name, relName, applyMap);
                }
            } else {
                name = normalize(name, relName, applyMap);
                parts = splitPrefix(name);
                prefix = parts[0];
                name = parts[1];

                url = req.nameToUrl(name);
            }

            //Using ridiculous property names for space reasons
            result = {
                id: prefix ? prefix + '!' + name : name, //fullName
                n: name,
                pr: prefix,
                url: url
            };

            if (!prefix) {
                mapCache[cacheKey] = result;
            }

            return result;
        };

        handlers = {
            require: function (name) {
                return makeRequire(name);
            },
            exports: function (name) {
                var e = defined[name];
                if (typeof e !== 'undefined') {
                    return e;
                } else {
                    return (defined[name] = {});
                }
            },
            module: function (name) {
                return {
                    id: name,
                    uri: '',
                    exports: handlers.exports(name),
                    config: function () {
                        return getOwn(config.config, name) || {};
                    }
                };
            }
        };

        function breakCycle(d, traced, processed) {
            var id = d.map.id;

            traced[id] = true;
            if (!d.finished && d.deps) {
                d.deps.forEach(function (depMap) {
                    var depId = depMap.id,
                        dep = !hasProp(handlers, depId) && getDefer(depId);

                    //Only force things that have not completed
                    //being defined, so still in the registry,
                    //and only if it has not been matched up
                    //in the module already.
                    if (dep && !dep.finished && !processed[depId]) {
                        if (hasProp(traced, depId)) {
                            d.deps.forEach(function (depMap, i) {
                                if (depMap.id === depId) {
                                    d.depFinished(defined[depId], i);
                                }
                            });
                        } else {
                            breakCycle(dep, traced, processed);
                        }
                    }
                });
            }
            processed[id] = true;
        }

        function check(d) {
            var err,
                notFinished = [],
                waitInterval = config.waitSeconds * 1000,
                //It is possible to disable the wait interval by using waitSeconds of 0.
                expired = waitInterval && (startTime + waitInterval) < (new Date()).getTime();

            if (loadCount === 0) {
                //If passed in a deferred, it is for a specific require call.
                //Could be a sync case that needs resolution right away.
                //Otherwise, if no deferred, means a nextTick and all
                //waiting require deferreds should be checked.
                if (d) {
                    if (!d.finished) {
                        breakCycle(d, {}, {});
                    }
                } else if (requireDeferreds.length) {
                    requireDeferreds.forEach(function (d) {
                        breakCycle(d, {}, {});
                    });
                }
            }

            //If still waiting on loads, and the waiting load is something
            //other than a plugin resource, or there are still outstanding
            //scripts, then just try back later.
            if (expired) {
                //If wait time expired, throw error of unloaded modules.
                eachProp(deferreds, function (d) {
                    if (!d.finished) {
                        notFinished.push(d.map.id);
                    }
                });
                err = new Error('Timeout for modules: ' + notFinished);
                err.requireModules = notFinished;
                req.onError(err);
            } else if (loadCount || requireDeferreds.length) {
                //Something is still waiting to load. Wait for it, but only
                //if a later check is not already scheduled.
                if (!checkingLater) {
                    checkingLater = true;
                    prim.nextTick(function () {
                        checkingLater = false;
                        check();
                    });
                }
            }
        }

        //Used to break out of the promise try/catch chains.
        function delayedError(e) {
            prim.nextTick(function () {
                if (!e.dynaId || !trackedErrors[e.dynaId]) {
                    trackedErrors[e.dynaId] = true;
                    req.onError(e);
                }
            });
        }

        main = function (name, deps, factory, errback, relName) {
            //Only allow main calling once per module.
            if (name && hasProp(calledDefine, name)) {
                return;
            }
            calledDefine[name] = true;

            var d = getDefer(name);

            //This module may not have dependencies
            if (deps && !Array.isArray(deps)) {
                //deps is not an array, so probably means
                //an object literal or factory function for
                //the value. Adjust args.
                factory = deps;
                deps = [];
            }

            d.promise.catch(errback || delayedError);

            //Use name if no relName
            relName = relName || name;

            //Call the factory to define the module, if necessary.
            if (typeof factory === 'function') {

                if (!deps.length && factory.length) {
                    //Remove comments from the callback string,
                    //look for require calls, and pull them into the dependencies,
                    //but only if there are function args.
                    factory
                        .toString()
                        .replace(commentRegExp, '')
                        .replace(cjsRequireRegExp, function (match, dep) {
                            deps.push(dep);
                        });

                    //May be a CommonJS thing even without require calls, but still
                    //could use exports, and module. Avoid doing exports and module
                    //work though if it just needs require.
                    //REQUIRES the function to expect the CommonJS variables in the
                    //order listed below.
                    deps = (factory.length === 1 ?
                            ['require'] :
                            ['require', 'exports', 'module']).concat(deps);
                }

                //Save info for use later.
                d.factory = factory;
                d.deps = deps;

                d.depending = true;
                deps.forEach(function (depName, i) {
                    var depMap;
                    deps[i] = depMap = makeMap(depName, relName, true);
                    depName = depMap.id;

                    //Fast path CommonJS standard dependencies.
                    if (depName === "require") {
                        d.values[i] = handlers.require(name);
                    } else if (depName === "exports") {
                        //CommonJS module spec 1.1
                        d.values[i] = handlers.exports(name);
                        d.usingExports = true;
                    } else if (depName === "module") {
                        //CommonJS module spec 1.1
                        d.values[i] = d.cjsModule = handlers.module(name);
                    } else if (depName === undefined) {
                        d.values[i] = undefined;
                    } else {
                        waitForDep(depMap, relName, d, i);
                    }
                });
                d.depending = false;

                //Some modules just depend on the require, exports, modules, so
                //trigger their definition here if so.
                if (d.depCount === d.depMax) {
                    defineModule(d);
                }
            } else if (name) {
                //May just be an object definition for the module. Only
                //worry about defining if have a module name.
                resolve(name, d, factory);
            }

            startTime = (new Date()).getTime();

            if (!name) {
                check(d);
            }
        };

        req = makeRequire(null, true);

        /*
         * Just drops the config on the floor, but returns req in case
         * the config return value is used.
         */
        req.config = function (cfg) {
            if (cfg.context && cfg.context !== contextName) {
                return newContext(cfg.context).config(cfg);
            }

            //Since config changed, mapCache may not be valid any more.
            mapCache = {};

            //Make sure the baseUrl ends in a slash.
            if (cfg.baseUrl) {
                if (cfg.baseUrl.charAt(cfg.baseUrl.length - 1) !== '/') {
                    cfg.baseUrl += '/';
                }
            }

            //Save off the paths and packages since they require special processing,
            //they are additive.
            var primId,
                shim = config.shim,
                objs = {
                    paths: true,
                    bundles: true,
                    config: true,
                    map: true
                };

            eachProp(cfg, function (value, prop) {
                if (objs[prop]) {
                    if (!config[prop]) {
                        config[prop] = {};
                    }
                    mixin(config[prop], value, true, true);
                } else {
                    config[prop] = value;
                }
            });

            //Reverse map the bundles
            if (cfg.bundles) {
                eachProp(cfg.bundles, function (value, prop) {
                    value.forEach(function (v) {
                        if (v !== prop) {
                            bundlesMap[v] = prop;
                        }
                    });
                });
            }

            //Merge shim
            if (cfg.shim) {
                eachProp(cfg.shim, function (value, id) {
                    //Normalize the structure
                    if (Array.isArray(value)) {
                        value = {
                            deps: value
                        };
                    }
                    if ((value.exports || value.init) && !value.exportsFn) {
                        value.exportsFn = makeShimExports(value);
                    }
                    shim[id] = value;
                });
                config.shim = shim;
            }

            //Adjust packages if necessary.
            if (cfg.packages) {
                cfg.packages.forEach(function (pkgObj) {
                    var location, name;

                    pkgObj = typeof pkgObj === 'string' ? { name: pkgObj } : pkgObj;

                    name = pkgObj.name;
                    location = pkgObj.location;
                    if (location) {
                        config.paths[name] = pkgObj.location;
                    }

                    //Save pointer to main module ID for pkg name.
                    //Remove leading dot in main, so main paths are normalized,
                    //and remove any trailing .js, since different package
                    //envs have different conventions: some use a module name,
                    //some use a file name.
                    config.pkgs[name] = pkgObj.name + '/' + (pkgObj.main || 'main')
                                 .replace(currDirRegExp, '')
                                 .replace(jsSuffixRegExp, '');
                });
            }

            //If want prim injected, inject it now.
            primId = config.definePrim;
            if (primId) {
                waiting[primId] = [primId, [], function () { return prim; }];
            }

            //If a deps array or a config callback is specified, then call
            //require with those args. This is useful when require is defined as a
            //config object before require.js is loaded.
            if (cfg.deps || cfg.callback) {
                req(cfg.deps, cfg.callback);
            }

            return req;
        };

        req.onError = function (err) {
            throw err;
        };

        context = {
            id: contextName,
            defined: defined,
            waiting: waiting,
            config: config,
            deferreds: deferreds
        };

        contexts[contextName] = context;

        return req;
    }

    requirejs = topReq = newContext('_');

    if (typeof require !== 'function') {
        require = topReq;
    }

    /**
     * Executes the text. Normally just uses eval, but can be modified
     * to use a better, environment-specific call. Only used for transpiling
     * loader plugins, not for plain JS modules.
     * @param {String} text the text to execute/evaluate.
     */
    topReq.exec = function (text) {
        /*jslint evil: true */
        return eval(text);
    };

    topReq.contexts = contexts;

    define = function () {
        queue.push([].slice.call(arguments, 0));
    };

    define.amd = {
        jQuery: true
    };

    if (bootstrapConfig) {
        topReq.config(bootstrapConfig);
    }

    //data-main support.
    if (topReq.isBrowser && !contexts._.config.skipDataMain) {
        dataMain = document.querySelectorAll('script[data-main]')[0];
        dataMain = dataMain && dataMain.getAttribute('data-main');
        if (dataMain) {
            //Strip off any trailing .js since dataMain is now
            //like a module name.
            dataMain = dataMain.replace(jsSuffixRegExp, '');

            if (!bootstrapConfig || !bootstrapConfig.baseUrl) {
                //Pull off the directory of data-main for use as the
                //baseUrl.
                src = dataMain.split('/');
                dataMain = src.pop();
                subPath = src.length ? src.join('/')  + '/' : './';

                topReq.config({baseUrl: subPath});
            }

            topReq([dataMain]);
        }
    }
}(this));

define("ext/alameda", function(){});



(function(exports) {

  var AccessibilityHelper = {
    /**
     * For a set of tab elements, set aria-selected attribute in accordance with
     * the current selection.
     * @param {Object} selectedTab a tab to select object.
     * @param {Array} tabs an array of tabs.
     */
    setAriaSelected: function ah_setAriaSelected(selectedTab, tabs) {
      // In case tabs is a NodeList, that does not have forEach.
      Array.prototype.forEach.call(tabs, function setAriaSelectedAttr(tab) {
        tab.setAttribute('aria-selected',
          tab === selectedTab ? 'true' : 'false');
      });
    }
  };

  exports.AccessibilityHelper = AccessibilityHelper;

})(window);

define("shared/accessibility_helper", (function (global) {
    return function () {
        var ret, fn;
        return ret || global.AccessibilityHelper;
    };
}(this)));

define('timespan',['require','exports','module'],function(require, exports, module) {


function Timespan(startDate, endDate) {
  this.start = startDate.valueOf();
  this.end = endDate.valueOf();
}
module.exports = Timespan;

Timespan.prototype = {
  isEqual: function(inputSpan) {
    return (
      this.start === inputSpan.start &&
      this.end === inputSpan.end
    );
  },

  /**
   * If given Timespan overlaps this timespan
   * return a new timespan with the overlapping
   * parts removed.
   *
   * See tests for examples...
   */
  trimOverlap: function(span) {
    if (this.contains(span) || span.contains(this)) {
      return null;
    }

    var start = span.start;
    var end = span.end;
    var ourEnd = this.end;
    var ourStart = this.start;

    var overlapsBefore = start >= ourStart && start < ourEnd;
    var overlapsAfter = ourStart >= start && ourStart < end;

    var newStart = span.start;
    var newEnd = span.end;

    if (overlapsBefore) {
      newStart = ourEnd + 1;
    }

    if (overlapsAfter) {
      newEnd = ourStart - 1;
    }

    return new Timespan(newStart, newEnd);
  },

  /**
   * Checks if given time overlaps with
   * range.
   *
   * @param {Date|Numeric|Timespan} start range or one position.
   * @param {Date|Numeric} [end] do a span comparison.
   */
  overlaps: function(start, end) {
    var ourStart = this.start;
    var ourEnd = this.end;

    if (start instanceof Timespan) {
      end = start.end;
      start = start.start;
    } else {
      // start/end expected
      start = (start instanceof Date) ? start.valueOf() : start;
      end = (end instanceof Date) ? end.valueOf() : end;
    }

    return (
        start >= ourStart && start < ourEnd ||
        ourStart >= start && ourStart < end
    );
  },

  /**
   * When given a date checks if
   * date is inside given range.
   *
   *
   * @param {Date} date date or event.
   */
  contains: function(date) {
    var start = this.start;
    var end = this.end;

    if (date instanceof Date) {
      return start <= date && end >= date;
    } else if (date instanceof Timespan) {
      return start <= date.start &&
             end >= date.end;
    } else {
      return this.containsNumeric(date);
    }
  },

  /**
   * Numeric comparison assumes
   * given seconds since epoch.
   *
   * @param {Numeric} timestamp numeric timestamp.
   */
  containsNumeric: function(timestamp) {
    var start = this.start;
    var end = this.end;

    return start <= timestamp &&
           end >= timestamp;
  }
};

});

define('calc',['require','exports','module','timespan'],function(require, exports) {


var Timespan = require('timespan');

const SECOND = 1000;
const MINUTE = (SECOND * 60);
const HOUR = MINUTE * 60;

exports._hourDate = new Date();
exports.startsOnMonday = false;
exports.FLOATING = 'floating';
exports.ALLDAY = 'allday';
exports.SECOND = SECOND;
exports.MINUTE = MINUTE;
exports.HOUR = HOUR;
exports.PAST = 'past';
exports.NEXT_MONTH = 'next-month';
exports.OTHER_MONTH = 'other-month';
exports.PRESENT = 'present';
exports.FUTURE = 'future';

Object.defineProperty(exports, 'today', {
  get: function() {
    return new Date();
  }
});

exports.getTimeL10nLabel = function(timeLabel) {
  return timeLabel + (navigator.mozHour12 ? '12' : '24');
};

exports.daysInWeek = function() {
  // XXX: We need to localize this...
  return 7;
};

/**
 * Calculates day of week when starting day is Monday.
 */
exports.dayOfWeekFromMonday = function(numeric) {
  var day = numeric - 1;
  if (day < 0) {
    return 6;
  }

  return day;
};

/**
 * Calculates day of week when starting day is Sunday.
 */
exports.dayOfWeekFromSunday = function(numeric) {
  return numeric;
};

/**
 * Checks is given date is today.
 *
 * @param {Date} date compare.
 * @return {Boolean} true when today.
 */
exports.isToday = function(date) {
  return exports.isSameDate(date, exports.today);
};

/**
 * Checks if date object only contains date information (not time).
 *
 * Example:
 *
 *    var time = new Date(2012, 0, 1, 1);
 *    this._isOnlyDate(time); // false
 *
 *    var time = new Date(2012, 0, 1);
 *    this._isOnlyDate(time); // true
 *
 * @param {Date} date to verify.
 * @return {Boolean} see above.
 */
exports.isOnlyDate = function(date) {
  if (
    date.getHours() === 0 &&
    date.getMinutes() === 0 &&
    date.getSeconds() === 0
  ) {
    return true;
  }

  return false;
};

/**
 * Calculates the difference between
 * two points in hours.
 *
 * @param {Date|Numeric} start start hour.
 * @param {Date|Numeric} end end hour.
 */
exports.hourDiff = function(start, end) {
  start = (start instanceof Date) ? start.valueOf() : start;
  end = (end instanceof Date) ? end.valueOf() : end;

  start = start / HOUR;
  end = end / HOUR;

  return end - start;
};

/**
 * Creates timespan for given day.
 *
 * @param {Date} date date of span.
 * @param {Boolean} includeTime uses given date
 *                           as the start time of the timespan
 *                           rather then the absolute start of
 *                           the day of the given date.
 */
exports.spanOfDay = function(date, includeTime) {
  if (typeof(includeTime) === 'undefined') {
    date = exports.createDay(date);
  }

  var end = exports.createDay(date);
  end.setDate(end.getDate() + 1);
  return new Timespan(date, end);
};

/**
 * Creates timespan for a given month.
 * Starts at the first week that occurs
 * in the given month. Ends at the
 * last day, minute, second of given month.
 */
exports.spanOfMonth = function(month) {
  month = new Date(
    month.getFullYear(),
    month.getMonth(),
    1
  );

  var startDay = exports.getWeekStartDate(month);

  var endDay = new Date(
    month.getFullYear(),
    month.getMonth() + 1,
    1
  );

  endDay.setMilliseconds(-1);
  endDay = exports.getWeekEndDate(endDay);
  return new Timespan(startDay, endDay);
};

/**
 * Converts a date to UTC
 */
exports.getUTC = function(date) {
  return new Date(
    date.getUTCFullYear(),
    date.getUTCMonth(),
    date.getUTCDate(),
    date.getUTCHours(),
    date.getUTCMinutes(),
    date.getUTCSeconds(),
    date.getUTCMilliseconds()
  );
};

/**
 * Converts transport time into a JS Date object.
 *
 * @param {Object} transport date in transport format.
 * @return {Date} javascript date converts the transport into
 *                the current time.
 */
exports.dateFromTransport = function(transport) {
  var utc = transport.utc;
  var offset = transport.offset;
  var zone = transport.tzid;

  var date = new Date(
    // offset is expected to be 0 in the floating case
    parseInt(utc) - parseInt(offset)
  );

  if (zone && zone === exports.FLOATING) {
    return exports.getUTC(date);
  }

  return date;
};

/**
 * Converts a date object into a transport value
 * which can be stored in the database or sent
 * to a service.
 *
 * When the tzid value is given an is the string
 * value of "floating" it will convert the local
 * time directly to UTC zero and record no offset.
 * This along with the tzid is understood to be
 * a "floating" time which will occur at that position
 * regardless of the current tzid's offset.
 *
 * @param {Date} date js date object.
 * @param {String} [tzid] optional tzid.
 * @param {Boolean} isDate true when is a "date" representation.
 */
exports.dateToTransport = function(date, tzid, isDate) {
  var result = Object.create(null);

  if (isDate) {
    result.isDate = isDate;
  }

  if (tzid) {
    result.tzid = tzid;
  }

  var utc = Date.UTC(
    date.getFullYear(),
    date.getMonth(),
    date.getDate(),
    date.getHours(),
    date.getMinutes(),
    date.getSeconds(),
    date.getMilliseconds()
  );

  // remember a "date" is always a floating
  // point in time otherwise we don't use it...
  if (isDate || tzid && tzid === exports.FLOATING) {
    result.utc = utc;
    result.offset = 0;
    result.tzid = exports.FLOATING;
  } else {
    var localUtc = date.valueOf();
    var offset = utc - localUtc;

    result.utc = utc;
    result.offset = offset;
  }

  return result;
};

/**
 * Checks if two date objects occur
 * on the same date (in the same month, year, day).
 * Disregards time.
 *
 * @param {Date} first date.
 * @param {Date} second date.
 * @return {Boolean} true when they are the same date.
 */
exports.isSameDate = function(first, second) {
  return first.getMonth() == second.getMonth() &&
         first.getDate() == second.getDate() &&
         first.getFullYear() == second.getFullYear();
};

/**
 * Returns an identifier for a specific
 * date in time for a given date
 *
 * @param {Date} date to get id for.
 * @return {String} identifier.
 */
exports.getDayId = function(date) {
  return [
    'd',
    date.getFullYear(),
    date.getMonth(),
    date.getDate()
  ].join('-');
};

/**
 * Returns a date object from
 * a string id for a date.
 *
 * @param {String} id identifier for date.
 * @return {Date} date output.
 */
exports.dateFromId = function(id) {
  var parts = id.split('-'),
      date,
      type;

  if (parts.length > 1) {
    type = parts.shift();
    switch (type) {
      case 'd':
        date = new Date(parts[0], parts[1], parts[2]);
        break;
      case 'm':
        date = new Date(parts[0], parts[1]);
        break;
    }
  }

  return date;
};

/**
 * Returns an identifier for a specific
 * month in time for a given date.
 *
 * @return {String} identifier.
 */
exports.getMonthId = function(date) {
  return [
    'm',
    date.getFullYear(),
    date.getMonth()
  ].join('-');
};

exports.createDay = function(date, day, month, year) {
  return new Date(
    year != null ? year : date.getFullYear(),
    month != null ? month : date.getMonth(),
    day != null ? day : date.getDate()
  );
};

exports.endOfDay = function(date) {
  var day = exports.createDay(date, date.getDate() + 1);
  day.setMilliseconds(-1);
  return day;
};

/**
 * Returns localized day of week.
 *
 * @param {Date|Number} date numeric or date object.
 */
exports.dayOfWeek = function(date) {
  var number = date;

  if (typeof(date) !== 'number') {
    number = date.getDay();
  }

  if (exports.startsOnMonday) {
    return exports.dayOfWeekFromMonday(number);
  }
  return exports.dayOfWeekFromSunday(number);
};

/**
 * Finds localized week start date of given date.
 *
 * @param {Date} date any day the week.
 * @return {Date} first date in the week of given date.
 */
exports.getWeekStartDate = function(date) {
  var currentDay = exports.dayOfWeek(date);
  var startDay = (date.getDate() - currentDay);

  return exports.createDay(date, startDay);
};

exports.getWeekEndDate = function(date) {
  // TODO: There are localization problems
  // with this approach as we assume a 7 day week.
  var start = exports.getWeekStartDate(date);
  start.setDate(start.getDate() + 7);
  start.setMilliseconds(-1);

  return start;
};

/**
 * Returns an array of dates objects.
 * Inclusive. First and last are
 * the given instances.
 *
 * @param {Date} start starting day.
 * @param {Date} end ending day.
 * @param {Boolean} includeTime include times start/end ?
 */
exports.daysBetween = function(start, end, includeTime) {
  if (start instanceof Timespan) {
    if (end) {
      includeTime = end;
    }

    end = new Date(start.end);
    start = new Date(start.start);
  }

  if (start > end) {
    var tmp = end;
    end = start;
    start = tmp;
    tmp = null;
  }

  var list = [];
  var last = start.getDate();

  // handle the case where start & end dates
  // are the same date.
  if (exports.isSameDate(start, end)) {
    if (includeTime) {
      list.push(end);
    } else {
      list.push(this.createDay(start));
    }
    return list;
  }

  while (true) {
    var next = new Date(
      start.getFullYear(),
      start.getMonth(),
      ++last
    );

    if (next > end) {
      throw new Error(
        'sanity fails next is greater then end'
      );
    }

    if (!exports.isSameDate(next, end)) {
      list.push(next);
      continue;
    }

    break;
  }

  if (includeTime) {
    list.unshift(start);
    list.push(end);
  } else {
    list.unshift(exports.createDay(start));
    list.push(exports.createDay(end));
  }

  return list;
},

/**
 * Returns an array of weekdays based on the start date.
 * Will always return the 7 daysof that week regardless of
 * what the start date isbut they will be returned
 * in the order of their localized getDay function.
 *
 * @param {Date} startDate point of origin.
 * @return {Array} a list of dates in order of getDay().
 */
exports.getWeeksDays = function(startDate) {
  //local day position
  var weeksDayStart = exports.getWeekStartDate(startDate);
  var result = [weeksDayStart];

  for (var i = 1; i < 7; i++) {
    result.push(exports.createDay(weeksDayStart, weeksDayStart.getDate() + i));
  }

  return result;
};

/**
 * Checks if date is in the past
 *
 * @param {Date} date to check.
 * @return {Boolean} true when date is in the past.
 */
exports.isPast = function(date) {
  return (date.valueOf() < exports.today.valueOf());
};

/**
 * Checks if date is in the future
 *
 * @param {Date} date to check.
 * @return {Boolean} true when date is in the future.
 */
exports.isFuture = function(date) {
  return !exports.isPast(date);
};

/**
 * Based on the input date
 * will return one of the following states
 *
 *  past, present, future
 *
 * @param {Date} day for compare.
 * @param {Date} month comparison month.
 * @return {String} state.
 */
exports.relativeState = function(day, month) {
  var states;
  //var today = exports.today;

  // 1. the date is today (real time)
  if (exports.isToday(day)) {
    return exports.PRESENT;
  }

  // 2. the date is in the past (real time)
  if (exports.isPast(day)) {
    states = exports.PAST;
  // 3. the date is in the future (real time)
  } else {
    states = exports.FUTURE;
  }

  // 4. the date is not in the current month (relative time)
  if (day.getMonth() !== month.getMonth()) {
    states += ' ' + exports.OTHER_MONTH;
  }

  return states;
};

/**
 * Computes the relative hour (0...23.9999) inside the given day.
 * If `date` is on a different day than `baseDate` it will return `0`.
 * Used by week view to compute the position of the busytimes relative to
 * the top of the view.
 */
exports.relativeOffset = function(baseDate, date) {
  if (exports.isSameDate(baseDate, date)) {
    return date.getHours() + (date.getMinutes() / 60);
  }
  // different day!
  return 0;
};

/**
 * Computes the relative duration between startDate and endDate inside
 * a given baseDate. Returns a number between 0 and 24.
 * Used by MultiDay view to compute the height of the busytimes relative to
 * the length inside the baseDate.
 */
exports.relativeDuration = function(baseDate, startDate, endDate) {
  if (!exports.isSameDate(startDate, endDate)) {
    if (exports.isSameDate(baseDate, startDate)) {
      endDate = exports.endOfDay(baseDate);
    } else if (exports.isSameDate(baseDate, endDate)) {
      startDate = exports.createDay(endDate);
    } else {
      // started before baseDate and ends on a different day
      return 24;
    }
  }
  return exports.hourDiff(startDate, endDate);
};

/**
 * Check if event spans thru the whole day.
 */
exports.isAllDay = function(baseDate, startDate, endDate) {
  // beginning reference point (start of given date)
  var refStart = exports.createDay(baseDate);
  var refEnd = exports.endOfDay(baseDate);

  var startBefore = startDate <= refStart;
  var endsAfter = endDate >= refEnd;

  // yahoo uses same start/end date for recurring all day events!!!
  return (startBefore && endsAfter) || Number(startDate) === Number(endDate);
};

window.addEventListener('localized', function changeStartDay() {
  var startDay = navigator.mozL10n.get('weekStartsOnMonday');
  if (startDay && parseInt(startDay, 10)) {
    exports.startsOnMonday = true;
  } else {
    exports.startsOnMonday = false;
  }
});

});

define('date_format',['require','exports','module'],function(require, exports, module) {


module.exports = navigator.mozL10n.DateTimeFormat();

});

define('date_l10n',['require','exports','module','date_format'],function(require, exports) {


var dateFormat = require('date_format');

/**
 * Localizes all elements with data-l10n-date-format.
 */
exports.localizeElements = function() {
  var elements = document.querySelectorAll('[data-l10n-date-format]');
  for (var i = 0; i < elements.length; i++) {
    exports.localizeElement(elements[i]);
  }
};

exports.changeElementsHourFormat = function() {
  var isHour12 = navigator.mozHour12;
  var previousFormat = isHour12 ? 24 : 12;
  var currentFormat = isHour12 ? 12 : 24;
  var elements = document.querySelectorAll(
    `[data-l10n-date-format*="${previousFormat}"]`
  );

  Array.prototype.forEach.call(elements, (element) => {
    var format = element.dataset.l10nDateFormat.replace(
      previousFormat,
      currentFormat
    );

    element.dataset.l10nDateFormat = format;
    // Remove leading zero of hour items in day, week view sidebars.
    exports.localizeElement(element, {
      addAmPmClass: format === 'week-hour-format12',
      removeLeadingZero: format.contains('hour-format')
    });
  });
};

/**
 * Localize a single element expected to have data-l10n-date-format.
 *
 * Options:
 *
 *   (Boolean) addAmPmClass
 *   (Boolean) removeLeadingZero
 */
exports.localizeElement = function(element, options) {
  var date = element.dataset.date;
  if (!date) {
    return;
  }

  var l10n = navigator.mozL10n;
  var format = l10n.get(element.dataset.l10nDateFormat);
  if (options && options.addAmPmClass) {
    // developer.mozilla.org/docs/Mozilla/Localization/Localization_best_practices#Avoid_unnecessary_complexity_in_strings
    format = format.replace(/\s*%p\s*/, '<span class="ampm">%p</span>');
  }

  var text = dateFormat.localeFormat(new Date(date), format);
  if (options && options.removeLeadingZero) {
    text = text.replace(/^0/, '');
  }

  element.textContent = text;
};

});

define('models/account',['require','exports','module'],function(require, exports, module) {


function Account(options) {
  var key;

  if (typeof(options) === 'undefined') {
    options = {};
  }

  for (key in options) {
    if (options.hasOwnProperty(key)) {
      this[key] = options[key];
    }
  }
}
module.exports = Account;

Account.prototype = {

  /**
   * Type of provider this
   * account requires.
   */
  providerType: null,

  /**
   * ID for this model always set
   * by the store when hydrating
   */
  id: null,

  /**
   * Which preset this model came from.
   */
  preset: null,

  /**
   * Domain for account
   */
  domain: '',

  /**
   * url/path for account
   */
  entrypoint: '',

  /**
   * Location where calendars can be found.
   * May be the same as entrypoint.
   */
  calendarHome: '',

  /**
   * username for authentication
   */
  user: '',

  /**
   * password for authentication
   */
  password: '',

  get fullUrl() {
    return this.domain + this.entrypoint;
  },

  set fullUrl(value) {
    var protocolIdx = value.indexOf('://');

    this.domain = value;
    this.entrypoint = '/';

    if (protocolIdx !== -1) {
      protocolIdx += 3;
      // next chunk
      var domainChunk = value.substr(protocolIdx);
      var pathIdx = domainChunk.indexOf('/');


      if (pathIdx !== -1) {
        pathIdx = pathIdx + protocolIdx;

        this.entrypoint = value.substr(pathIdx);
        this.domain = value.substr(0, pathIdx);
      }

    }
  },

  /**
   * Data only version of this object.
   * Used for both passing data between
   * threads (workers) and persisting data
   * in indexeddb.
   */
  toJSON: function() {
    var output = {};
    var fields = [
      'entrypoint',
      'calendarHome',
      'domain',
      'password',
      'user',
      'providerType',
      'preset',
      'oauth',
      'error'
    ];

    fields.forEach(function(key) {
      output[key] = this[key];
    }, this);

    if (this._id || this._id === 0) {
      output._id = this._id;
    }

    return output;
  }

};

});

define('presets',{
  "google": {
    "providerType": "Caldav",
    "group": "remote",
    "authenticationType": "oauth2",
    "apiCredentials": {
      "tokenUrl": "https://accounts.google.com/o/oauth2/token",
      "authorizationUrl": "https://accounts.google.com/o/oauth2/auth",
      "user_info": {
        "url": "https://www.googleapis.com/oauth2/v3/userinfo",
        "field": "email"
      },
      "client_secret": "jQTKlOhF-RclGaGJot3HIcVf",
      "client_id": "605300196874-1ki833poa7uqabmh3hq6u1onlqlsi54h.apps.googleusercontent.com",
      "scope": "https://www.googleapis.com/auth/calendar https://www.googleapis.com/auth/userinfo.email",
      "redirect_uri": "https://oauth.gaiamobile.org/authenticated"
    },
    "options": {
      "domain": "https://apidata.googleusercontent.com",
      "entrypoint": "/caldav/v2/",
      "providerType": "Caldav"
    }
  },
  "yahoo": {
    "providerType": "Caldav",
    "group": "remote",
    "options": {
      "domain": "https://caldav.calendar.yahoo.com",
      "entrypoint": "/",
      "providerType": "Caldav",
      "user": "@yahoo.com",
      "usernameType": "email"
    }
  },
  "caldav": {
    "providerType": "Caldav",
    "group": "remote",
    "options": {
      "domain": "",
      "entrypoint": "",
      "providerType": "Caldav"
    }
  },
  "local": {
    "singleUse": true,
    "providerType": "Local",
    "group": "local",
    "options": {
      "providerType": "Local"
    }
  }
});
/**
 * @fileoverview Utilities for converting async functions which use
 *     node-style callbacks to also cater promises callers.
 */
define('promise',['require','exports','module'],function(require, exports) {


function denodeify(fn) {
  // This is our new, denodeified function. You can interact with it using
  // node-style callbacks or promises.
  return function() {
    // Original arguments to fn.
    var args = Array.slice(arguments);
    var callback = args[args.length - 1];
    if (typeof callback === 'function') {
      // If consumer is trying to interact with node-style callback, let them.
      return fn.apply(this, args);
    }

    // We need the defer style promise api here since we don't want to
    // accidentily step on functions that return things like DOMRequests...
    var deferred = defer();
    args.push((err, result) => {
      if (err) {
        return deferred.reject(err);
      }

      deferred.resolve(result);
    });

    // Return the promise <=> the function doesn't return an object.
    var returnValue = fn.apply(this, args);
    return typeof returnValue === 'object' ? returnValue : deferred.promise;
  };
}
exports.denodeify = denodeify;

function denodeifyAll(object, methods) {
  methods.forEach((method) => {
    object[method] = exports.denodeify(object[method]);
  });
}
exports.denodeifyAll = denodeifyAll;

function defer() {
  var deferred = {};
  var promise = new Promise((resolve, reject) => {
    deferred.resolve = resolve;
    deferred.reject = reject;
  });

  deferred.promise = promise;
  return deferred;
}

});

define('next_tick',['require','exports','module'],function(require, exports, module) {


var NEXT_TICK = 'calendar-next-tick';

var nextTickStack = [];

/**
 * Very similar to node's nextTick.
 * Much faster then setTimeout.
 */
module.exports = function(callback) {
  nextTickStack.push(callback);
  window.postMessage(NEXT_TICK, '*');
};

/**
 * next tick inspired by http://dbaron.org/log/20100309-faster-timeouts.
 */
window.addEventListener('message', (event) => {
  if (event.source === window && event.data === NEXT_TICK) {
    event.stopPropagation();
    if (nextTickStack.length) {
      (nextTickStack.shift())();
    }
  }
});

});

define('provider/abstract',['require','exports','module','promise','next_tick'],function(require, exports, module) {


var denodeifyAll = require('promise').denodeifyAll;
var nextTick = require('next_tick');

function Abstract(options) {
  var key;
  for (key in options) {
    if (options.hasOwnProperty(key)) {
      this[key] = options[key];
    }
  }


  denodeifyAll(this, [
    'eventCapabilities',
    'getAccount',
    'findCalendars',
    'syncEvents',
    'ensureRecurrencesExpanded',
    'createEvent',
    'updateEvent',
    'deleteEvent'
  ]);
}
module.exports = Abstract;

Abstract.prototype = {
  // orange (used by local calendar)
  defaultColor: '#F97C17',

  /**
   * Does this provider require credentials.
   */
  useCredentials: false,

  /**
   * Does this provider require a url.
   */
  useUrl: false,

  /**
   * Can provider sync with remote server?
   */
  canSync: false,

  /**
   * Can expand recurring events?
   */
  canExpandRecurringEvents: false,

  /**
   *  - domain: (String)
   *  - password: (String)
   *  - user: (String)
   *
   * @param {Object} account user credentials.
   * @param {Function} callback node style (err, result).
   */
  getAccount: function(account, callback) {},

  /**
   * Attempts to find all calendars
   * for a given account.
   *
   *
   * account: (same as getAccount)
   *
   * @param {Object} account user credentials.
   * @param {Function} callback node style (err, result).
   */
  findCalendars: function() {},

  /**
   * Sync remote and local events.
   *
   */
  syncEvents: function(account, calendar, callback) {},

  /**
   * Ensures recurring events are expanded up to the given date.
   *
   * Its very important to correctly return the second callback arg
   * in the subclasses callback. When requiredExpansion is returned as true a
   * second call will likely be made to ensureRecurrencesExpanded to verify
   * there are no more pending events for the date (controller handles this).
   *
   * @param {Date} date to expand recurring events to.
   * @param {Function} callback [err, requiredExpansion].
   *  first argument is error, second indicates if any expansion was done.
   */
  ensureRecurrencesExpanded: function(date, callback) {},

  /**
   * Update an event
   *
   * @param {Object} event record from event store.
   *
   * @param {Object} [busytime] optional busytime instance
   *                 when a busytime is passed the edit is treated
   *                 as an "exception" and will only edit the one recurrence
   *                 related to the busytime. This may result in the creation
   *                 of a new "event" related to the busytime.
   */
  updateEvent: function(event, busytime, callback) {},

  /**
   * Delete event
   *
   * @param {Object} event record from the event store.
   * @param {Object} [busytime] optional busytime instance
   *                 when given it will only remove this occurence/exception
   *                 of the event rather then the entire sequence of events.
   */
  deleteEvent: function(event, busytime, callback) {},

  /**
   * Create an event
   */
  createEvent: function(event, callback) {},

  /**
   * Returns an object with three keys used to
   * determine the capabilities of a given calendar.
   *
   * - canCreate (Boolean)
   * - canUpdate (Boolean)
   * - canDelete (Boolean)
   *
   * @param {Object} calendar full calendar details.
   */
  calendarCapabilities: function(calendar) {
    return {
      canCreateEvent: true,
      canUpdateEvent: true,
      canDeleteEvent: true
    };
  },

  /**
   * Returns the capabilities of a single event.
   *
   * @param {Object} event object.
   * @param {Function} callback [err, caps].
   */
  eventCapabilities: function(event, callback) {
    var caps = this.calendarCapabilities();

    nextTick(function() {
      callback(null, {
        canCreate: caps.canCreateEvent,
        canUpdate: caps.canUpdateEvent,
        canDelete: caps.canDeleteEvent
      });
    });
  }
};

});

//     uuid.js
//
//     Copyright (c) 2010-2012 Robert Kieffer
//     MIT License - http://opensource.org/licenses/mit-license.php

(function() {
  var _global = this;

  // Unique ID creation requires a high quality random # generator.  We feature
  // detect to determine the best RNG source, normalizing to a function that
  // returns 128-bits of randomness, since that's what's usually required
  var _rng;

  // Node.js crypto-based RNG - http://nodejs.org/docs/v0.6.2/api/crypto.html
  //
  // Moderately fast, high quality
  if (typeof(_global.require) == 'function' && typeof(module) != 'undefined' && module.exports) {
    try {
      var _rb = _global.require('crypto').randomBytes;
      _rng = _rb && function() {return _rb(16);};
    } catch(e) {}
  }

  if (!_rng && _global.crypto && crypto.getRandomValues) {
    // WHATWG crypto-based RNG - http://wiki.whatwg.org/wiki/Crypto
    //
    // Moderately fast, high quality
    var _rnds8 = new Uint8Array(16);
    _rng = function whatwgRNG() {
      crypto.getRandomValues(_rnds8);
      return _rnds8;
    };
  }

  if (!_rng) {
    // Math.random()-based (RNG)
    //
    // If all else fails, use Math.random().  It's fast, but is of unspecified
    // quality.
    var  _rnds = new Array(16);
    _rng = function() {
      for (var i = 0, r; i < 16; i++) {
        if ((i & 0x03) === 0) r = Math.random() * 0x100000000;
        _rnds[i] = r >>> ((i & 0x03) << 3) & 0xff;
      }

      return _rnds;
    };
  }

  // Buffer class to use
  var BufferClass = typeof(_global.Buffer) == 'function' ? _global.Buffer : Array;

  // Maps for number <-> hex string conversion
  var _byteToHex = [];
  var _hexToByte = {};
  for (var i = 0; i < 256; i++) {
    _byteToHex[i] = (i + 0x100).toString(16).substr(1);
    _hexToByte[_byteToHex[i]] = i;
  }

  // **`parse()` - Parse a UUID into it's component bytes**
  function parse(s, buf, offset) {
    var i = (buf && offset) || 0, ii = 0;

    buf = buf || [];
    s.toLowerCase().replace(/[0-9a-f]{2}/g, function(oct) {
      if (ii < 16) { // Don't overflow!
        buf[i + ii++] = _hexToByte[oct];
      }
    });

    // Zero out remaining bytes if string was short
    while (ii < 16) {
      buf[i + ii++] = 0;
    }

    return buf;
  }

  // **`unparse()` - Convert UUID byte array (ala parse()) into a string**
  function unparse(buf, offset) {
    var i = offset || 0, bth = _byteToHex;
    return  bth[buf[i++]] + bth[buf[i++]] +
            bth[buf[i++]] + bth[buf[i++]] + '-' +
            bth[buf[i++]] + bth[buf[i++]] + '-' +
            bth[buf[i++]] + bth[buf[i++]] + '-' +
            bth[buf[i++]] + bth[buf[i++]] + '-' +
            bth[buf[i++]] + bth[buf[i++]] +
            bth[buf[i++]] + bth[buf[i++]] +
            bth[buf[i++]] + bth[buf[i++]];
  }

  // **`v1()` - Generate time-based UUID**
  //
  // Inspired by https://github.com/LiosK/UUID.js
  // and http://docs.python.org/library/uuid.html

  // random #'s we need to init node and clockseq
  var _seedBytes = _rng();

  // Per 4.5, create and 48-bit node id, (47 random bits + multicast bit = 1)
  var _nodeId = [
    _seedBytes[0] | 0x01,
    _seedBytes[1], _seedBytes[2], _seedBytes[3], _seedBytes[4], _seedBytes[5]
  ];

  // Per 4.2.2, randomize (14 bit) clockseq
  var _clockseq = (_seedBytes[6] << 8 | _seedBytes[7]) & 0x3fff;

  // Previous uuid creation time
  var _lastMSecs = 0, _lastNSecs = 0;

  // See https://github.com/broofa/node-uuid for API details
  function v1(options, buf, offset) {
    var i = buf && offset || 0;
    var b = buf || [];

    options = options || {};

    var clockseq = options.clockseq != null ? options.clockseq : _clockseq;

    // UUID timestamps are 100 nano-second units since the Gregorian epoch,
    // (1582-10-15 00:00).  JSNumbers aren't precise enough for this, so
    // time is handled internally as 'msecs' (integer milliseconds) and 'nsecs'
    // (100-nanoseconds offset from msecs) since unix epoch, 1970-01-01 00:00.
    var msecs = options.msecs != null ? options.msecs : new Date().getTime();

    // Per 4.2.1.2, use count of uuid's generated during the current clock
    // cycle to simulate higher resolution clock
    var nsecs = options.nsecs != null ? options.nsecs : _lastNSecs + 1;

    // Time since last uuid creation (in msecs)
    var dt = (msecs - _lastMSecs) + (nsecs - _lastNSecs)/10000;

    // Per 4.2.1.2, Bump clockseq on clock regression
    if (dt < 0 && options.clockseq == null) {
      clockseq = clockseq + 1 & 0x3fff;
    }

    // Reset nsecs if clock regresses (new clockseq) or we've moved onto a new
    // time interval
    if ((dt < 0 || msecs > _lastMSecs) && options.nsecs == null) {
      nsecs = 0;
    }

    // Per 4.2.1.2 Throw error if too many uuids are requested
    if (nsecs >= 10000) {
      throw new Error('uuid.v1(): Can\'t create more than 10M uuids/sec');
    }

    _lastMSecs = msecs;
    _lastNSecs = nsecs;
    _clockseq = clockseq;

    // Per 4.1.4 - Convert from unix epoch to Gregorian epoch
    msecs += 12219292800000;

    // `time_low`
    var tl = ((msecs & 0xfffffff) * 10000 + nsecs) % 0x100000000;
    b[i++] = tl >>> 24 & 0xff;
    b[i++] = tl >>> 16 & 0xff;
    b[i++] = tl >>> 8 & 0xff;
    b[i++] = tl & 0xff;

    // `time_mid`
    var tmh = (msecs / 0x100000000 * 10000) & 0xfffffff;
    b[i++] = tmh >>> 8 & 0xff;
    b[i++] = tmh & 0xff;

    // `time_high_and_version`
    b[i++] = tmh >>> 24 & 0xf | 0x10; // include version
    b[i++] = tmh >>> 16 & 0xff;

    // `clock_seq_hi_and_reserved` (Per 4.2.2 - include variant)
    b[i++] = clockseq >>> 8 | 0x80;

    // `clock_seq_low`
    b[i++] = clockseq & 0xff;

    // `node`
    var node = options.node || _nodeId;
    for (var n = 0; n < 6; n++) {
      b[i + n] = node[n];
    }

    return buf ? buf : unparse(b);
  }

  // **`v4()` - Generate random UUID**

  // See https://github.com/broofa/node-uuid for API details
  function v4(options, buf, offset) {
    // Deprecated - 'format' argument, as supported in v1.2
    var i = buf && offset || 0;

    if (typeof(options) == 'string') {
      buf = options == 'binary' ? new BufferClass(16) : null;
      options = null;
    }
    options = options || {};

    var rnds = options.random || (options.rng || _rng)();

    // Per 4.4, set bits for version and `clock_seq_hi_and_reserved`
    rnds[6] = (rnds[6] & 0x0f) | 0x40;
    rnds[8] = (rnds[8] & 0x3f) | 0x80;

    // Copy bytes to buffer, if provided
    if (buf) {
      for (var ii = 0; ii < 16; ii++) {
        buf[i + ii] = rnds[ii];
      }
    }

    return buf || unparse(rnds);
  }

  // Export public API
  var uuid = v4;
  uuid.v1 = v1;
  uuid.v4 = v4;
  uuid.parse = parse;
  uuid.unparse = unparse;
  uuid.BufferClass = BufferClass;

  if (typeof define === 'function' && define.amd) {
    // Publish as AMD module
    define('ext/uuid',[],function() {return uuid;});
  } else if (typeof(module) != 'undefined' && module.exports) {
    // Publish as node.js module
    module.exports = uuid;
  } else {
    // Publish as global (in browsers)
    var _previousRoot = _global.uuid;

    // **`noConflict()` - (browser only) to reset global 'uuid' var**
    uuid.noConflict = function() {
      _global.uuid = _previousRoot;
      return uuid;
    };

    _global.uuid = uuid;
  }
}).call(this);

/**
 * EventMutations are a simple wrapper for a
 * set of idb transactions that span multiple
 * stores and calling out to the time controller
 * at appropriate times so it can cache the information.
 *
 *
 * Examples:
 *
 *
 *    // create an event
 *    var mutation = Calendar.EventMutations.create({
 *      // this class does not handle/process events
 *      // only persisting the records. Busytimes will
 *      // automatically be recreated.
 *      event: event
 *    });
 *
 *    // add an optional component
 *    // mutation.icalComponent = component;
 *
 *    mutation.commit(function(err) {
 *      if (err) {
 *        // handle it
 *      }
 *
 *      // success event/busytime/etc.. has been created
 *    });
 *
 *
 *    // update an event:
 *    // update shares an identical api but will
 *    // destroy/recreate associated busytimes with event.
 *    var mutation = Calendar.EventMutations.update({
 *      event: event
 *    });
 *
 *    mutation.commit(function() {
 *
 *    });
 *
 *
 */
define('event_mutations',['require','exports','module','calc','ext/uuid'],function(require, exports) {


var Calc = require('calc');
var uuid = require('ext/uuid');

/**
 * Create a single instance busytime for the given event object.
 *
 * @param {Object} event to create busytime for.
 */
function createBusytime(event) {
  return {
    _id: event._id + '-' + uuid.v4(),
    eventId: event._id,
    calendarId: event.calendarId,
    start: event.remote.start,
    end: event.remote.end
  };
}

function Create(options) {
  if (options) {
    for (var key in options) {
      if (options.hasOwnProperty(key)) {
        this[key] = options[key];
      }
    }
  }
}

Create.prototype = {
  commit: function(callback) {
    var app = exports.app;
    var alarmStore = app.store('Alarm');
    var eventStore = app.store('Event');
    var busytimeStore = app.store('Busytime');
    var componentStore = app.store('IcalComponent');

    var controller = app.timeController;

    var trans = eventStore.db.transaction(
      eventStore._dependentStores,
      'readwrite'
    );

    trans.oncomplete = function commitComplete() {
      callback(null);
    };

    trans.onerror = function commitError(e) {
      callback(e.target.error);
    };

    eventStore.persist(this.event, trans);

    if (!this.busytime) {
      this.busytime = createBusytime(this.event);
    }

    busytimeStore.persist(this.busytime, trans);

    if (this.icalComponent) {
      componentStore.persist(this.icalComponent, trans);
    }

    controller.cacheEvent(this.event);
    controller.cacheBusytime(
      busytimeStore.initRecord(this.busytime)
    );

    var alarms = this.event.remote.alarms;
    if (alarms && alarms.length) {
      var i = 0;
      var len = alarms.length;
      var now = Date.now();

      var alarmTrans = alarmStore.db.transaction(
        ['alarms'],
        'readwrite'
      );

      for (; i < len; i++) {

        var alarm = {
          startDate: {
            offset: this.busytime.start.offset,
            utc: this.busytime.start.utc + (alarms[i].trigger * 1000)
          },
          eventId: this.busytime.eventId,
          busytimeId: this.busytime._id
        };

        var alarmDate = Calc.dateFromTransport(this.busytime.end).valueOf();
        if (alarmDate < now) {
          continue;
        }

        alarmStore.persist(alarm, alarmTrans);
      }
    }
  }

};

function Update() {
  Create.apply(this, arguments);
}

Update.prototype = {
  commit: function(callback) {
    var app = exports.app;
    var busytimeStore = app.store('Busytime');

    var self = this;

    // required so UI knows to refresh even in the
    // case where the start/end times are the same.
    busytimeStore.removeEvent(this.event._id, function(err) {
      if (err) {
        callback(err);
        return;
      }

      Create.prototype.commit.call(self, callback);
    });
  }
};

/**
 * Will be injected...
 */
exports.app = null;

exports.create = function createMutation(option) {
  return new Create(option);
};

exports.update = function updateMutation(option) {
  return new Update(option);
};

});

define('provider/local',['require','exports','module','./abstract','event_mutations','ext/uuid'],function(require, exports, module) {


var Abstract = require('./abstract');
var mutations = require('event_mutations');
var uuid = require('ext/uuid');

var LOCAL_CALENDAR_ID = 'local-first';

function Local() {
  Abstract.apply(this, arguments);

  // TODO: Get rid of this when app global is gone.
  mutations.app = this.app;
  this.events = this.app.store('Event');
  this.busytimes = this.app.store('Busytime');
  this.alarms = this.app.store('Alarm');
}
module.exports = Local;

Local.calendarId = LOCAL_CALENDAR_ID;

/**
 * Returns the details for the default calendars.
 */
Local.defaultCalendar = function() {
  // XXX: Make async
  var l10nId = 'calendar-local';
  var name;

  if ('mozL10n' in window.navigator) {
    name = window.navigator.mozL10n.get(l10nId);
    if (name === l10nId) {
      name = null;
    }
  }

  if (!name) {
    name = 'Offline calendar';
  }

  return {
    // XXX localize this name somewhere
    name: name,
    id: LOCAL_CALENDAR_ID,
    color: Local.prototype.defaultColor
  };

};

Local.prototype = {
  __proto__: Abstract.prototype,

  canExpandRecurringEvents: false,

  getAccount: function(account, callback) {
    callback(null, {});
  },

  findCalendars: function(account, callback) {
    var list = {};
    list[LOCAL_CALENDAR_ID] = Local.defaultCalendar();
    callback(null, list);
  },

  syncEvents: function(account, calendar, cb) {
    cb(null);
  },

  /**
   * @return {Calendar.EventMutations.Create} mutation object.
   */
  createEvent: function(event, callback) {
    // most providers come with their own built in
    // id system when creating a local event we need to generate
    // our own UUID.
    if (!event.remote.id) {
      // TOOD: uuid is provided by ext/uuid.js
      //       if/when platform supports a safe
      //       random number generator (values never conflict)
      //       we can use that instead of uuid.js
      event.remote.id = uuid();
    }

    var create = mutations.create({ event: event });
    create.commit(function(err) {
      if (err) {
        return callback(err);
      }

      callback(null, create.busytime, create.event);
    });

    return create;
  },

  deleteEvent: function(event, busytime, callback) {
    if (typeof(busytime) === 'function') {
      callback = busytime;
      busytime = null;
    }

    this.app.store('Event').remove(event._id, callback);
  },

  /**
   * @return {Calendar.EventMutations.Update} mutation object.
   */
  updateEvent: function(event, busytime, callback) {
    if (typeof(busytime) === 'function') {
      callback = busytime;
      busytime = null;
    }

    var update = mutations.update({ event: event });
    update.commit(function(err) {
      if (err) {
        return callback(err);
      }

      callback(null, update.busytime, update.event);
    });

    return update;
  }
};

});

// this code is from test-agent might use native dom events
// or something else in the future to replace this.
define('responder',['require','exports','module'],function(require, exports, module) {


/**
 * @param {Object} list of events to add onto responder.
 */
function Responder(events) {
  this._$events = Object.create(null);

  if (typeof(events) !== 'undefined') {
    this.addEventListener(events);
  }
}
module.exports = Responder;

/**
 * Stringifies request to websocket
 *
 *
 * @param {String} command command name.
 * @param {Object} data object to be sent over the wire.
 * @return {String} json object.
 */
Responder.stringify = function stringify(command, data) {
  return JSON.stringify([command, data]);
};

/**
 * Parses request from WebSocket.
 *
 * @param {String} json json string to translate.
 * @return {Object} ex: { event: 'test', data: {} }.
 */
Responder.parse = function parse(json) {
  var data;
  try {
    data = (json.forEach) ? json : JSON.parse(json);
  } catch (e) {
    throw new Error('Could not parse json: "' + json + '"');
  }

  return data;
};

Responder.prototype = {
  parse: Responder.parse,
  stringify: Responder.stringify,

  /**
   * Events on this instance
   *
   * @type Object
   */
  events: null,

  /**
   * Recieves json string event and dispatches an event.
   *
   * @param {String|Object} json data object to respond to.
   * @param {String} json.event event to emit.
   * @param {Object} json.data data to emit with event.
   * @param {Object} [params] option number of params to pass to emit.
   * @return {Object} result of WebSocketCommon.parse.
   */
  respond: function respond(json) {
    var event = Responder.parse(json);
    var args = Array.prototype.slice.call(arguments).slice(1);
    this.emit.apply(this, event.concat(args));

    return event;
  },

  /**
   * Adds an event listener to this object.
   *
   *
   * @param {String} type event name.
   * @param {Function} callback event callback.
   */
  addEventListener: function addEventListener(type, callback) {
    var event;

    if (typeof(callback) === 'undefined' && typeof(type) === 'object') {
      for (event in type) {
        if (type.hasOwnProperty(event)) {
          this.addEventListener(event, type[event]);
        }
      }

      return this;
    }

    if (!(type in this._$events)) {
      this._$events[type] = [];
    }

    this._$events[type].push(callback);

    return this;
  },

  /**
   * Adds an event listener which will
   * only fire once and then remove itself.
   *
   *
   * @param {String} type event name.
   * @param {Function} callback fired when event is emitted.
   */
  once: function once(type, callback) {
    var self = this;
    function onceCb() {
      /*jshint validthis:true */
      self.removeEventListener(type, onceCb);
      callback.apply(this, arguments);
    }

    this.addEventListener(type, onceCb);

    return this;
  },

  /**
   * Emits an event.
   *
   * Accepts any number of additional arguments to pass unto
   * event listener.
   *
   * @param {String} eventName name of the event to emit.
   * @param {Object} [arguments] additional arguments to pass.
   */
  emit: function emit() {
    var args = Array.prototype.slice.call(arguments),
        event = args.shift(),
        eventList,
        self = this;

    if (event in this._$events) {
      eventList = this._$events[event];

      eventList.forEach(function(callback) {
        if (typeof(callback) === 'object' && callback.handleEvent) {
          callback.handleEvent({ type: event, data: args });
        } else {
          callback.apply(self, args);
        }
      });
    }

    return this;
  },

  /**
   * Removes all event listeners for a given event type
   *
   *
   * @param {String} event event type to remove.
   */
  removeAllEventListeners: function removeAllEventListeners(name) {
    if (name in this._$events) {
      //reuse array
      this._$events[name].length = 0;
    }

    return this;
  },

  /**
   * Removes a single event listener from a given event type
   * and callback function.
   *
   *
   * @param {String} eventName event name.
   * @param {Function} callback same instance of event handler.
   */
  removeEventListener: function removeEventListener(name, callback) {
    var i, length, events;

    if (!(name in this._$events)) {
      return false;
    }

    events = this._$events[name];

    for (i = 0, length = events.length; i < length; i++) {
      if (events[i] && events[i] === callback) {
        events.splice(i, 1);
        return true;
      }
    }

    return false;
  }

};

Responder.prototype.on = Responder.prototype.addEventListener;
Responder.prototype.off = Responder.prototype.removeEventListener;

});

define('store/abstract',['require','exports','module','responder','promise','next_tick'],function(require, exports, module) {


var Responder = require('responder');
var denodeifyAll = require('promise').denodeifyAll;
var nextTick = require('next_tick');

/**
 * Creates an abstract store instance.
 * Every store must contain a reference
 * to the database.
 */
function Abstract(db, app) {
  this.db = db;
  this.app = app;
  this._cached = Object.create(null);
  Responder.call(this);

  denodeifyAll(this, [
    'persist',
    'all',
    '_allCached',
    'removeByIndex',
    'get',
    'remove',
    'count'
  ]);
}
module.exports = Abstract;

Abstract.prototype = {
  __proto__: Responder.prototype,

  _store: null,

  /**
   * Stores that will need to be removed
   * when a record is removed from this store.
   *
   * @type {Array}
   */
  _dependentStores: null,

  _createModel: function(object, id) {
    if (typeof(id) !== 'undefined') {
      object._id = id;
    }

    return object;
  },

  _addToCache: function(object) {
    this._cached[object._id] = object;
  },

  _removeFromCache: function(id) {
    if (id in this._cached) {
      delete this._cached[id];
    }
  },

  _transactionCallback: function(trans, callback) {
    if (callback) {
      trans.addEventListener('error', function(e) {
        callback(e);
      });

      trans.addEventListener('complete', function() {
        callback(null);
      });
    }
  },

  /**
   * Adds an account to the database.
   *
   * @param {Object} object reference to account object to store.
   * @param {IDBTransaction} trans transaction.
   * @param {Function} callback node style callback.
   */
  persist: function(object, trans, callback) {
    if (typeof(trans) === 'function') {
      callback = trans;
      trans = undefined;
    }

    if (!trans) {
      trans = this.db.transaction(
        this._dependentStores || this._store,
        'readwrite'
      );
    }

    var self = this;
    var store = trans.objectStore(this._store);
    var data = this._objectData(object);
    var id;
    var model;

    var putReq;
    var reqType = this._detectPersistType(object);

    // determine type of event
    if (reqType === 'update') {
      putReq = store.put(data);
    } else {
      this._assignId(data);
      putReq = store.add(data);
    }

    trans.addEventListener('error', function(event) {
      if (callback) {
        callback(event);
      }
    });

    this._addDependents(object, trans);

    // when we have the id we can add the model to the cache.
    if (data._id) {
      id = data._id;
      model = self._createModel(object, id);
      self._addToCache(model);
    }

    trans.addEventListener('complete', function(data) {
      if (!model) {
        id = putReq.result;
        model = self._createModel(object, id);
        self._addToCache(model);
      }

      if (callback) {
        callback(null, id, model);
      }

      self.emit(reqType, id, model);
      self.emit('persist', id, model);
    });
  },

  _allCached: function(callback) {
    var list = this._cached;
    nextTick(function() {
      callback(null, list);
    });
  },

  /**
   * Loads all records in the database
   * for this store.
   *
   * Using this function will fill
   * the cache with all records in the store.
   * As such this should only be used once
   * during the app life-cycle.
   */
  all: function(callback) {
    if (this._allCallbacks) {
      this._allCallbacks.push(callback);
      return;
    }

    // list of pending callbacks
    this._allCallbacks = [callback];

    var self = this;
    var trans = this.db.transaction(this._store);
    var store = trans.objectStore(this._store);

    function process(data) {
      return self._addToCache(self._createModel(data));
    }

    function fireQueue(err, value) {
      var callback;
      while ((callback = self._allCallbacks.shift())) {
        callback(err, value);
      }
    }

    store.mozGetAll().onsuccess = function(event) {
      event.target.result.forEach(process);
    };

    trans.onerror = function(event) {
      fireQueue(event.target.error.name);
    };

    trans.oncomplete = function() {
      fireQueue(null, self._cached);
      self.all = self._allCached;
    };
  },

  _addDependents: function() {},
  _removeDependents: function(trans) {},

  _detectPersistType: function(object) {
    return ('_id' in object) ? 'update' : 'add';
  },

  _parseId: function(id) {
    return id;
  },

  _assignId: function(obj) {
  },

  /**
   * Removes all records a index value and removes
   * them from the cache. 'remove' events are *not* emitted
   * when removing in this manner for performance reasons.
   *
   * TODO: the test for this method still lives in the event store tests
   *       where this code began should refactor those tests to be general
   *       and live in the abstract tests.
   *
   * @param {String} indexName name of store index.
   * @param {Numeric} indexValue value in index.
   * @param {IDBTransation} [trans] optional transaction to reuse.
   * @param {Function} [callback] optional callback to use.
   *                   When called without a transaction chances
   *                   are you should pass a callback.
   */
  removeByIndex: function(indexName, indexValue, trans, callback) {
    var self = this;
    if (typeof(trans) === 'function') {
      callback = trans;
      trans = undefined;
    }

    if (!trans) {
      trans = this.db.transaction(
        this._dependentStores || this._store,
        'readwrite'
      );
    }
    if (callback) {

      trans.addEventListener('complete', function() {
        callback(null);
      });

      trans.addEventListener('error', function(event) {
        callback(event);
      });
    }


    var index = trans.objectStore(this._store).index(indexName);
    var req = index.openCursor(
      IDBKeyRange.only(indexValue)
    );

    req.onsuccess = function(event) {
      var cursor = event.target.result;
      if (cursor) {
        // remove deps first intentionally to mimic, removes normal behaviour
        self._removeDependents(cursor.primaryKey, trans);
        self._removeFromCache(cursor.primaryKey);
        cursor.delete();
        cursor.continue();
      }
    };

    return req;
  },

  /**
   * Finds a single record.
   *
   * Does not go through any cache or emit any events.
   *
   * @param {String} id id of record.
   * @param {IDBTransaction} [trans] optional transaction.
   * @param {Function} callback node style [err, record].
   */
  get: function(id, trans, callback) {
    var self = this;

    if (typeof(trans) === 'function') {
      callback = trans;
      trans = null;
    }

    if (!trans) {
      trans = this.db.transaction(this._store);
    }

    var store = trans.objectStore(this._store);
    var req = store.get(this._parseId(id));

    req.onsuccess = function() {
      var model;

      if (req.result) {
        model = self._createModel(req.result);
      }

      callback(null, model);
    };

    req.onerror = function(event) {
      callback(event);
    };
  },

  /**
   * Removes a object from the store.
   *
   * @param {String} id record reference.
   * @param {IDBTransaction} trans transaction.
   * @param {Function} callback node style callback.
   */
  remove: function(id, trans, callback) {
    if (typeof(trans) === 'function') {
      callback = trans;
      trans = undefined;
    }

    if (!trans) {
      trans = this.db.transaction(
        this._dependentStores || this._store,
        'readwrite'
      );
    }

    var self = this;
    var store = trans.objectStore(this._store);
    id = this._parseId(id);

    store.delete(id);

    this._removeDependents(id, trans);
    self.emit('preRemove', id);

    trans.addEventListener('error', function(event) {
      if (callback) {
        callback(event);
      }
    });

    trans.addEventListener('complete', function() {
      if (callback) {
        callback(null, id);
      }

      self.emit('remove', id);

      // intentionally after the callbacks...
      self._removeFromCache(id);
    });
  },

  /**
   * Find number of records in store.
   *
   * @param {Function} callback node style err/count.
   */
  count: function(callback) {
    var trans = this.db.transaction(this._store);
    var store = trans.objectStore(this._store);

    var req = store.count();

    req.onsuccess = function() {
      callback(null, req.result);
    };

    req.onerror = function(e) {
      callback(e);
    };
  },

  _objectData: function(data) {
    if ('toJSON' in data) {
      return data.toJSON();
    }
    return data;
  }
};

});

define('debug',['require','exports','module'],function(require, exports, module) {


module.exports = function(name) {
  return function() {
    var args = Array.prototype.slice.call(arguments).map(JSON.stringify);
    args.unshift('[calendar] ');
    args.unshift(name);
    console.log.apply(console, args);
  };
};

});

define('extend',['require','exports','module'],function(require, exports, module) {


module.exports = function(target, input) {
  for (var key in input) {
    if (hasOwnProperty.call(input, key)) {
      target[key] = input[key];
    }
  }

  return target;
};

});

define('probably_parse_int',['require','exports','module'],function(require, exports, module) {


var NUMERIC = /^[0-9]+$/;

/**
 * @param {number|string} id Some id.
 */
module.exports = function(id) {
  // by an unfortunate decision we have both
  // string ids and number ids.. based on the
  // input we run parseInt
  if (typeof id === 'string' && id.match(NUMERIC)) {
    return parseInt(id, 10);
  }

  return id;
};

});

define('error',['require','exports','module'],function(require, exports, module) {


/**
 * These errors are _not_ exceptions and are designed to be passed not thrown
 * in typical |throw new X| fashion.
 */
function Base(name, detail) {
  this.message = 'oops... why did you throw this?';
  this.name = name;
  this.detail = detail;
}
module.exports = Base;

Base.prototype = Object.create(Error.prototype);

function errorFactory(name, l10nID) {
  var error = function(detail) {
    this.name = name;
    this.detail = detail;
    /**
     * we need to use l10nID's for backwards compatibility
     * (not changing string IDs between releases).
     */
    this.l10nID = l10nID || name;
  };

  error.prototype = Object.create(Base.prototype);
  return error;
}

/* note names should _never_ change */
Base.Authentication = errorFactory('authentication', 'unauthenticated');
Base.InvalidServer = errorFactory('invalid-server', 'internal-server-error');
Base.ServerFailure = errorFactory('server-failure', 'internal-server-error');

});

define('provider/caldav_pull_events',['require','exports','module','calc','app','debug','ext/uuid'],function(require, exports, module) {


var Calc = require('calc');
var app = require('app');
var debug = require('debug')('pull events');
var uuid = require('ext/uuid');

/**
 * Event synchronization class for caldav provider.
 *
 * Options:
 *  - app: current calendar app (Calendar.App by default)
 *  - account: (Calendar.Models.Account) required
 *  - calendar: (Calendar.Models.Calendar) required
 *
 * Example:
 *
 *    // instance of a service stream
 *    var stream;
 *
 *    var pull = new Calendar.Provider.CaldavPullEvents(stream, {
 *      calendar: calendarModel,
 *      account: accountModel,
 *      app: Calendar.App
 *    });
 *
 *    stream.request(function() {
 *      // stream is complete here the audit of
 *      // events can be made. They are flushed
 *      // to the cache where possible but not actually
 *      // persisted in the database.
 *
 *      // assuming we are ready commit the changes
 *      pull.commit(function(err) {
 *        // all changes have been committed at this point.
 *      });
 *    });
 *
 * @param {Calendar.Responder} stream event emitter usually
 *                                    a service stream.
 * @param {Object} options options for instance (see above).
 */
function PullEvents(stream, options) {
  if (options.calendar) {
    this.calendar = options.calendar;
  } else {
    throw new Error('.calendar option must be given');
  }

  if (options.account) {
    this.account = options.account;
  } else {
    throw new Error('.account option must be given');
  }

  if (options.app) {
    this.app = options.app;
  } else {
    this.app = app;
  }

  stream.on('event', this);
  stream.on('component', this);
  stream.on('occurrence', this);
  stream.on('missingEvents', this);

  this.icalQueue = [];
  this.eventQueue = [];
  this.busytimeQueue = [];
  this.alarmQueue = [];

  this._busytimeStore = this.app.store('Busytime');

  // Catch account events to watch for mid-sync removal
  this._accountStore = this.app.store('Account');
  this._accountStore.on('remove', this._onRemoveAccount.bind(this));

  this._aborted = false;
  this._trans = null;
}
module.exports = PullEvents;

PullEvents.prototype = {
  eventQueue: null,
  busytimeQueue: null,

  /**
   * Get db id for busytime.
   *
   * @param {Object} busytime service sent busytime.
   */
  busytimeIdFromRemote: function(busytime) {
    var eventId = this.eventIdFromRemote(busytime, !busytime.isException);

    return busytime.start.utc + '-' +
           busytime.end.utc + '-' +
           eventId;
  },

  /**
   * Get db id for event.
   *
   * @param {Object} event service sent event or '.remote'
   *                       property in db event.
   *
   * @param {Boolean} ignoreException when true will ignore
   *                                  recurrence exceptions.
   *
   * @return {String} database object id.
   */
  eventIdFromRemote: function(event, ignoreException) {
    var id = event.eventId || event.id;

    if (!ignoreException && event.recurrenceId) {
      id += '-' + event.recurrenceId.utc;
    }

    return this.calendar._id + '-' + id;
  },

  /**
   * Format an incoming event.
   *
   * @param {Object} event service sent event.
   */
  formatEvent: function(event) {
    // get id or parent id we ignore the exception
    // rules here so children (exceptions) can lookup
    // their parents id.
    var id = this.eventIdFromRemote(event, true);

    var result = Object.create(null);
    result.calendarId = this.calendar._id;
    result.remote = event;

    if (event.recurrenceId) {
      result.parentId = id;
      // don't ignore the exceptions
      result._id = this.eventIdFromRemote(event);
    } else {
      result._id = id;
    }

    return result;
  },

  /**
   * Formats and tags busytime sent from service.
   *
   * @param {Object} time service sent busytime.
   */
  formatBusytime: function(time) {
    var eventId = this.eventIdFromRemote(time, !time.isException);
    var id = eventId + '-' + uuid.v4();
    var calendarId = this.calendar._id;

    time._id = id;
    time.calendarId = calendarId;
    time.eventId = eventId;

    if (time.alarms) {
      var i = 0;
      var len = time.alarms.length;
      var alarm;

      for (; i < len; i++) {
        alarm = time.alarms[i];
        alarm.eventId = eventId;
        alarm.busytimeId = id;
      }
    }

    return this._busytimeStore.initRecord(time);
  },

  handleOccurrenceSync: function(item) {
    var alarms;

    if ('alarms' in item) {
      alarms = item.alarms;
      delete item.alarms;

      if (alarms.length) {
        var i = 0;
        var len = alarms.length;
        var now = Date.now();

        for (; i < len; i++) {
          var alarm = {
            startDate: {},
            eventId: item.eventId,
            busytimeId: item._id
          };

          // Copy the start object
          for (var j in item.start) {
            alarm.startDate[j] = item.start[j];
          }
          alarm.startDate.utc += (alarms[i].trigger * 1000);

          var alarmDate = Calc.dateFromTransport(item.end);
          if (alarmDate.valueOf() < now) {
            continue;
          }
          this.alarmQueue.push(alarm);
        }
      }
    }

    this.app.timeController.cacheBusytime(item);
    this.busytimeQueue.push(item);
  },

  handleComponentSync: function(component) {
    component.eventId = this.eventIdFromRemote(component);
    component.calendarId = this.calendar._id;

    if (!component.lastRecurrenceId) {
      delete component.lastRecurrenceId;
    }

    this.icalQueue.push(component);
  },

  handleEventSync: function(event) {
    var exceptions = event.remote.exceptions;
    delete event.remote.exceptions;

    var id = event._id;

    // clear any busytimes that could possibly be
    // related to this event as we will be adding new
    // ones as part of the sync.
    this._busytimeStore.removeEvent(id);
    // remove details of past cached events....
    this.app.timeController.removeCachedEvent(event._id);
    this.app.timeController.cacheEvent(event);

    this.eventQueue.push(event);

    var component = event.remote.icalComponent;
    delete event.remote.icalComponent;

    // don't save components for exceptions.
    // the parent has the ical data.
    if (!event.remote.recurrenceId) {
      this.icalQueue.push({
        data: component,
        eventId: event._id
      });
    }

    if (exceptions) {
      for (var i = 0; i < exceptions.length; i++) {
        this.handleEventSync(this.formatEvent(exceptions[i]));
      }
    }
  },

  /**
   * Account removal event handler. Aborts the rest of sync processing, if
   * the account deleted is the subject of the current sync.
   *
   * @param {String} database object id.
   */
  _onRemoveAccount: function(id) {
    if (id === this.account._id) {
      // This is our account, so abort the sync.
      this.abort();
    }
  },

  /**
   * Abort the sync. After this, further events will be ignored and commit()
   * will do nothing.
   */
  abort: function() {
    if (this._aborted) {
      // Bail, if already aborted.
      return;
    }
    // Flag that the sync should be aborted.
    this._aborted = true;
    if (this._trans) {
      // Attempt to abort the in-progress commit transaction
      this._trans.abort();
    }
  },

  handleEvent: function(event) {
    if (this._aborted) {
      // Ignore all events, if the sync has been aborted.
      return;
    }

    var data = event.data;

    switch (event.type) {
      case 'missingEvents':
        this.removeList = data[0];
        break;
      case 'occurrence':
        var occur = this.formatBusytime(data[0]);
        this.handleOccurrenceSync(occur);
        break;
      case 'component':
        this.handleComponentSync(data[0]);
        break;
      case 'event':
        var e = this.formatEvent(data[0]);
        this.handleEventSync(e);
        break;
    }
  },

  /**
   * Commit all pending records.
   *
   *
   * @param {IDBTransaction} [trans] optional transaction.
   * @param {Function} callback fired when transaction completes.
   */
  commit: function(trans, callback) {
    var eventStore = this.app.store('Event');
    var icalComponentStore = this.app.store('IcalComponent');
    var calendarStore = this.app.store('Calendar');
    var busytimeStore = this.app.store('Busytime');
    var alarmStore = this.app.store('Alarm');

    if (typeof(trans) === 'function') {
      callback = trans;
      trans = calendarStore.db.transaction(
        ['calendars', 'events', 'busytimes', 'alarms', 'icalComponents'],
        'readwrite'
      );
    }

    if (this._aborted) {
      // Commit nothing, if sync was aborted.
      return callback && callback(null);
    }

    // Stash a reference to the transaction, in case we still need to abort.
    this._trans = trans;

    var self = this;

    this.eventQueue.forEach(function(event) {
      debug('add event', event);
      eventStore.persist(event, trans);
    });

    this.icalQueue.forEach(function(ical) {
      debug('add component', ical);
      icalComponentStore.persist(ical, trans);
    });

    this.busytimeQueue.forEach(function(busy) {
      debug('add busytime', busy);
      busytimeStore.persist(busy, trans);
    });

    this.alarmQueue.forEach(function(alarm) {
      debug('add alarm', alarm);
      alarmStore.persist(alarm, trans);
    });

    if (this.removeList) {
      this.removeList.forEach(function(id) {
        eventStore.remove(id, trans);
      });
    }

    function handleError(e) {
      if (e && e.type !== 'abort') {
        console.error('Error persisting sync results', e);
      }

      // if we have an event preventDefault so we don't trigger window.onerror
      if (e && e.preventDefault) {
        e.preventDefault();
      }

      self._trans = null;
      callback && callback(e);
    }

    trans.addEventListener('error', handleError);
    trans.addEventListener('abort', handleError);


    trans.addEventListener('complete', function() {
      self._trans = null;
      callback && callback(null);
    });

    return trans;
  }
};

});

define('provider/caldav',['require','exports','module','./abstract','error','calc','./caldav_pull_events','error','error','./local','error','event_mutations','next_tick'],function(require, exports, module) {


var Abstract = require('./abstract');
var Authentication = require('error').Authentication;
var Calc = require('calc');
var CaldavPullEvents = require('./caldav_pull_events');
var CalendarError = require('error');
var InvalidServer = require('error').InvalidServer;
var Local = require('./local');
var ServerFailure = require('error').ServerFailure;
var mutations = require('event_mutations');
var nextTick = require('next_tick');

var CALDAV_ERROR_MAP = {
  'caldav-authentication': Authentication,
  'caldav-invalid-entrypoint': InvalidServer,
  'caldav-server-failure': ServerFailure
};

function mapError(error, detail) {
  console.error('Error with name:', error.name);
  var calError = CALDAV_ERROR_MAP[error.name];
  if (!calError) {
    calError = new CalendarError(error.name, detail);
  } else {
    calError = new calError(detail);
  }

  return calError;
}

function CaldavProvider() {
  Abstract.apply(this, arguments);

  // TODO: Get rid of this when app global is gone.
  mutations.app = this.app;
  this.service = this.app.serviceController;
  this.accounts = this.app.store('Account');
  this.busytimes = this.app.store('Busytime');
  this.events = this.app.store('Event');
  this.icalComponents = this.app.store('IcalComponent');
}
module.exports = CaldavProvider;

CaldavProvider.prototype = {
  __proto__: Abstract.prototype,
  role: 'caldav',
  useUrl: true,
  useCredentials: true,
  canSync: true,
  canExpandRecurringEvents: true,

  /**
   * Number of dates in the past to sync.
   * This is usually from the first sync date.
   */
  daysToSyncInPast: 30,

  canCreateEvent: true,
  canUpdateEvent: true,
  canDeleteEvent: true,

  hasAccountSettings: true,

  /**
   * Error handling can be complex- this is the centralized location where
   * methods can send their error state and some context (an account).
   *
   *    this._handleServiceError(
   *      err,
   *      { account: account, calendar: calendar }
   *    );
   *
   * @param {Object} rawErr from service.
   * @param {Object} detail for the error.
   */
  _handleServiceError: function(rawErr, detail) {
    var calendarErr = mapError(rawErr, detail);

    // when we receive a permanent error we should mark the account with an
    // error.
    if (
      calendarErr instanceof Authentication ||
      calendarErr instanceof InvalidServer
    ) {
      // there must always be an account
      if (detail.account) {
        // but we only mark it with a permanent error if its persisted.
        if (detail.account._id) {
          this.accounts.markWithError(detail.account, calendarErr);
        }
      } else {
        console.error('Permanent server error without an account!');
      }
    }

    return calendarErr;
  },

  /**
   * Determines the capabilities of a specific calendar.
   *
   * The .remote property should contain a .privilegeSet array
   * with the caldav specific names of privileges.
   * In the case where .privilegeSet is missing all privileges are granted.
   *
   * (see http://tools.ietf.org/html/rfc3744#section-5.4).
   *
   *   - write-content: (PUT) can edit/add events
   *   - unbind: (DELETE) remove events
   *
   *
   * There are aggregate values (write for example) but
   * the spec states the specific permissions must also be expanded
   * so even if they have full write permissions we only check
   * for write-content.
   *
   * @param {Object} calendar object with caldav remote details.
   * @return {Object} object with three properties
   *  (canUpdate, canDelete, canCreate).
   */
  calendarCapabilities: function(calendar) {
    var remote = calendar.remote;

    if (!remote.privilegeSet) {
      return {
        canUpdateEvent: true,
        canDeleteEvent: true,
        canCreateEvent: true
      };
    }

    var privilegeSet = remote.privilegeSet;
    var canWriteConent = privilegeSet.indexOf('write-content') !== -1;

    return {
      canUpdateEvent: canWriteConent,
      canCreateEvent: canWriteConent,
      canDeleteEvent: privilegeSet.indexOf('unbind') !== -1
    };
  },

  /**
   * Returns the capabilities of a single event.
   *
   * @param {Object} event local object.
   * @param {Function} callback [err, caps].
   */
  eventCapabilities: function(event, callback) {
    if (event.remote.isRecurring) {
      // XXX: for now recurring events cannot be edited
      nextTick(function() {
        callback(null, {
          canUpdate: false,
          canDelete: false,
          canCreate: false
        });
      });

    } else {
      var calendarStore = this.app.store('Calendar');

      calendarStore.get(event.calendarId, function(err, calendar) {
        if (err) {
          return callback(err);
        }

        var caps = this.calendarCapabilities(
          calendar
        );

        callback(null, {
          canCreate: caps.canCreateEvent,
          canUpdate: caps.canUpdateEvent,
          canDelete: caps.canDeleteEvent
        });
      }.bind(this));
    }
  },

  getAccount: function(account, callback) {
    if (this.bailWhenOffline(callback)) {
      return;
    }

    var self = this;
    this.service.request(
      'caldav',
      'getAccount',
      account,
      function(err, data) {
        if (err) {
          return callback(
            self._handleServiceError(err, { account: account })
          );
        }
        callback(null, data);
      }
    );
  },

  /**
   * Hook to format remote data if needed.
   */
  formatRemoteCalendar: function(calendar) {
    if (!calendar.color) {
      calendar.color = this.defaultColor;
    }

    return calendar;
  },

  findCalendars: function(account, callback) {
    if (this.bailWhenOffline(callback)) {
      return;
    }

    var self = this;
    function formatCalendars(err, data) {
      if (err) {
        return callback(self._handleServiceError(err, {
          account: account
        }));
      }

      // format calendars if needed
      if (data) {
        for (var key in data) {
          data[key] = self.formatRemoteCalendar(data[key]);
        }
      }

      callback(err, data);
    }

    this.service.request(
      'caldav',
      'findCalendars',
      account.toJSON(),
      formatCalendars
    );
  },

  _syncEvents: function(account, calendar, cached, callback) {

    var startDate;
    // calculate the first date we want to sync
    if (!calendar.firstEventSyncDate) {
      startDate = Calc.createDay(new Date());

      // will be persisted if sync is successful (clone is required)
      calendar.firstEventSyncDate = new Date(
        startDate.valueOf()
      );
    } else {
      startDate = new Date(calendar.firstEventSyncDate.valueOf());
    }

    // start date - the amount of days is the sync range
    startDate.setDate(startDate.getDate() - this.daysToSyncInPast);

    var options = {
      startDate: startDate,
      cached: cached
    };

    var stream = this.service.stream(
      'caldav',
      'streamEvents',
      account.toJSON(),
      calendar.remote,
      options
    );

    var pull = new CaldavPullEvents(stream, {
      app: this.app,
      account: account,
      calendar: calendar
    });

    var calendarStore = this.app.store('Calendar');
    var syncStart = new Date();

    var self = this;
    stream.request(function(err) {
      if (err) {
        return callback(
          self._handleServiceError(err, {
            account: account,
            calendar: calendar
          })
        );
      }

      var trans = pull.commit(function(commitErr) {
        if (commitErr) {
          callback(err);
          return;
        }
        callback(null);
      });

      /**
       * Successfully synchronizing a calendar indicates we can remove this
       * error.
       */
      calendar.error = undefined;

      calendar.lastEventSyncToken = calendar.remote.syncToken;
      calendar.lastEventSyncDate = syncStart;

      calendarStore.persist(calendar, trans);

    });

    return pull;
  },

  /**
   * Builds list of event urls & sync tokens.
   *
   * @param {Calendar.Model.Calendar} calender model instance.
   * @param {Function} callback node style [err, results].
   */
  _cachedEventsFor: function(calendar, callback) {
    var store = this.app.store('Event');

    store.eventsForCalendar(calendar._id, function(err, results) {
      if (err) {
        callback(err);
        return;
      }

      var list = Object.create(null);

      var i = 0;
      var len = results.length;
      var item;

      for (; i < len; i++) {
        item = results[i];
        list[item.remote.url] = {
          syncToken: item.remote.syncToken,
          id: item._id
        };
      }

      callback(null, list);
    });
  },

  /**
   * Sync remote and local events for a calendar.
   */
  syncEvents: function(account, calendar, callback) {
    var self = this;

    if (this.bailWhenOffline(callback)) {
      return;
    }

    if (!calendar._id) {
      throw new Error('calendar must be assigned an _id');
    }

    // Don't attempt to sync when provider cannot
    // or we have matching tokens
    if ((calendar.lastEventSyncToken &&
         calendar.lastEventSyncToken === calendar.remote.syncToken)) {
      return nextTick(callback);
    }

    this._cachedEventsFor(calendar, function(err, results) {
      if (err) {
        callback(err);
        return;
      }

      self._syncEvents(
        account,
        calendar,
        results,
        callback
      );
    });
  },

  /**
   * See abstract for contract details...
   *
   * Finds all ical components that have not been expanded
   * beyond the given point and expands / persists them.
   *
   * @param {Date} maxDate maximum date to expand to.
   * @param {Function} callback [err, didExpand].
   */
  ensureRecurrencesExpanded: function(maxDate, callback) {
    var self = this;
    this.icalComponents.findRecurrencesBefore(maxDate,
                                              function(err, results) {
      if (err) {
        callback(err);
        return;
      }

      if (!results.length) {
        callback(null, false);
        return;
      }

      // CaldavPullRequest is based on a calendar/account combination
      // so we must group all of the outstanding components into
      // their calendars before we can begin expanding them.
      var groups = Object.create(null);
      results.forEach(function(comp) {
        var calendarId = comp.calendarId;
        if (!(calendarId in groups)) {
          groups[calendarId] = [];
        }

        groups[calendarId].push(comp);
      });

      var pullGroups = [];
      var pending = 0;
      var options = {
        maxDate: Calc.dateToTransport(maxDate)
      };

      function next(err, pull) {
        pullGroups.push(pull);
        if (!(--pending)) {
          var trans = self.app.db.transaction(
            ['icalComponents', 'alarms', 'busytimes'],
            'readwrite'
          );

          trans.oncomplete = function() {
            callback(null, true);
          };

          trans.onerror = function(event) {
            callback(event.result.error.name);
          };

          pullGroups.forEach(function(pull) {
            pull.commit(trans);
          });
        }
      }

      for (var calendarId in groups) {
        pending++;
        self._expandComponents(
          calendarId,
          groups[calendarId],
          options,
          next
        );
      }

    });
  },

  _expandComponents: function(calendarId, comps, options, callback) {
    var calStore = this.app.store('Calendar');

    calStore.ownersOf(calendarId, function(err, owners) {
      if (err) {
        return callback(err);
      }

      var calendar = owners.calendar;
      var account = owners.account;

      var stream = this.service.stream(
        'caldav',
        'expandComponents',
        comps,
        options
      );

      var pull = new CaldavPullEvents(
        stream,
        {
          account: account,
          calendar: calendar,
          app: this.app,
          stores: [
            'busytimes', 'alarms', 'icalComponents'
          ]
        }
      );

      stream.request(function(err) {
        if (err) {
          callback(err);
          return;
        }
        callback(null, pull);
      });

    }.bind(this));
  },

  createEvent: function(event, busytime, callback) {
    if (typeof(busytime) === 'function') {
      callback = busytime;
      busytime = null;
    }


    if (this.bailWhenOffline(callback)) {
      return;
    }

    this.events.ownersOf(event, fetchOwners);

    var self = this;
    var calendar;
    var account;
    function fetchOwners(err, owners) {
      calendar = owners.calendar;
      account = owners.account;

      self.service.request(
        'caldav',
        'createEvent',
        account,
        calendar.remote,
        event.remote,
        handleRequest
      );
    }

    function handleRequest(err, remote) {
      if (err) {
        return callback(self._handleServiceError(err, {
          account: account,
          calendar: calendar
        }));
      }

      var event = {
        _id: calendar._id + '-' + remote.id,
        calendarId: calendar._id
      };

      var component = {
        eventId: event._id,
        ical: remote.icalComponent
      };

      delete remote.icalComponent;
      event.remote = remote;

      var create = mutations.create({
        event: event,
        icalComponent: component
      });

      create.commit(function(err) {
        if (err) {
          callback(err);
          return;
        }

        callback(null, create.busytime, create.event);
      });
    }
  },

  updateEvent: function(event, busytime, callback) {
    if (typeof(busytime) === 'function') {
      callback = busytime;
      busytime = null;
    }

    if (this.bailWhenOffline(callback)) {
      return;
    }

    this.events.ownersOf(event, fetchOwners);

    var self = this;
    var calendar;
    var account;

    function fetchOwners(err, owners) {
      calendar = owners.calendar;
      account = owners.account;

      self.icalComponents.get(
        event._id, fetchComponent
      );
    }

    function fetchComponent(err, ical) {
      if (err) {
        callback(err);
        return;
      }

      var details = {
        event: event.remote,
        icalComponent: ical.ical
      };

      self.service.request(
        'caldav',
        'updateEvent',
        account,
        calendar.remote,
        details,
        handleUpdate
      );
    }

    function handleUpdate(err, remote) {
      if (err) {
        callback(self._handleServiceError(err, {
          account: account,
          calendar: calendar
        }));
        return;
      }

      var component = {
        eventId: event._id,
        ical: remote.icalComponent
      };

      delete remote.icalComponent;
      event.remote = remote;

      var update = mutations.update({
        event: event,
        icalComponent: component
      });

      update.commit(function(err) {
        if (err) {
          callback(err);
          return;
        }
        callback(null, update.busytime, update.event);
      });
    }
  },

  deleteEvent: function(event, busytime, callback) {
    if (typeof(busytime) === 'function') {
      callback = busytime;
      busytime = null;
    }

    if (this.bailWhenOffline(callback)) {
      return;
    }

    this.events.ownersOf(event, fetchOwners);

    var calendar;
    var account;
    var self = this;
    function fetchOwners(err, owners) {
      calendar = owners.calendar;
      account = owners.account;

      self.service.request(
        'caldav',
        'deleteEvent',
        account,
        calendar.remote,
        event.remote,
        handleRequest
      );

    }

    function handleRequest(err) {
      if (err) {
        callback(self._handleServiceError(err, {
          account: account,
          calendar: calendar
        }));
        return;
      }
      Local.prototype.deleteEvent.call(self, event, busytime, callback);
    }
  },

  bailWhenOffline: function(callback) {
    if (!this.offlineMessage && 'mozL10n' in window.navigator) {
      this.offlineMessage = window.navigator.mozL10n.get('error-offline');
    }

    var ret = this.app.offline() && callback;
    if (ret) {
      var error = new Error();
      error.name = 'offline';
      error.message = this.offlineMessage;
      callback(error);
    }
    return ret;
  }
};

});

define('provider/caldav_visual_log',['require','exports','module','calc'],function(require, exports, module) {


var Calc = require('calc');

/**
 * This is a more crude version of what asuth does in email.
 * Right now this class is here only for debugging sync issues.
 * We need to add the settings so we can optionally turn this on.
 */
function EventLogger() {
  this.events = Object.create(null);
  this.occurs = Object.create(null);

  this.richLog = {};
}
module.exports = EventLogger;

EventLogger.prototype = {
  displayLog: function(id, string) {
    if (!(id in this.richLog)) {
      this.richLog[id] = [];
    }
    this.richLog[id].push(string);
  },

  addEvent: function(event) {
    var id = event.id;
    this.events[id] = event;
    var log = this.formatEvent(event);
    this.displayLog(id, log);
  },

  addBusytime: function(busy) {
    var id = busy.eventId;
    this.occurs[id] = busy;
    this.displayLog(id, this.formatBusytime(busy));
  },

  formatEvent: function(event) {
    var format = [
      'add event: (' + event.id + ')',
      'title:' + event.title,
      'start:' + (Calc.dateFromTransport(event.start)).toString(),
      'end:' + (Calc.dateFromTransport(event.end)).toString(),
      'isException:' + event.isException
    ];

    return format.join(' || ');
  },

  formatBusytime: function(busy) {
    var event = this.events[busy.eventId];
    var title = 'busytime for event: ' + busy.eventId;

    if (event) {
      title = 'busytime for event: ' + event.title;
    }

    var format = [
      title,
      'start:' + (Calc.dateFromTransport(busy.start)).toString(),
      'end:' + (Calc.dateFromTransport(busy.end)).toString(),
      'isException:' + busy.isException
    ];

    return format.join(' || ');
  }
};

});

define('provider/provider',['require','exports','module','./abstract','./caldav','./caldav_pull_events','./caldav_visual_log','./local'],function(require, exports) {


exports.Abstract = require('./abstract');
exports.Caldav = require('./caldav');
exports.CaldavPullEvents = require('./caldav_pull_events');
exports.CaldavVisualLog = require('./caldav_visual_log');
exports.Local = require('./local');

});

/**
 * TODO(gareth): This thing must die.
 */
define('provider/provider_factory',['require','exports','module','./provider'],function(require, exports) {


var Provider = require('./provider');

var providers = exports.providers = {};

// Will be injected...
exports.app = null;

exports.get = function(name) {
  if (!providers[name]) {
    providers[name] = new Provider[name]({ app: exports.app });
  }

  return providers[name];
};

});

define('store/account',['require','exports','module','models/account','./abstract','debug','promise','extend','next_tick','probably_parse_int','provider/provider_factory'],function(require, exports, module) {


var AccountModel = require('models/account');
var Abstract = require('./abstract');
var debug = require('debug')('store/account');
var denodeifyAll = require('promise').denodeifyAll;
var extend = require('extend');
var nextTick = require('next_tick');
var probablyParseInt = require('probably_parse_int');
var providerFactory = require('provider/provider_factory');

function Account() {
  Abstract.apply(this, arguments);

  denodeifyAll(this, [
    'verifyAndPersist',
    'sync',
    'markWithError',
    'syncableAccounts',
    'availablePresets'
  ]);
}
module.exports = Account;

Account.prototype = {
  __proto__: Abstract.prototype,

  _store: 'accounts',

  _parseId: probablyParseInt,

  /**
   * Checks if a given account is a duplicate of another.
   *
   * @param {Calendar.Model.Account} model to check.
   * @param {Function} callback [err].
   */
  _validateModel: function(model, callback) {
    this.all(function(err, allAccounts) {
      if (err) {
        callback(err);
        return;
      }

      // check if this account is already registered
      for (var index in allAccounts) {
        if (
            allAccounts[index].user === model.user &&
            allAccounts[index].fullUrl === model.fullUrl &&
            allAccounts[index]._id !== model._id
        ) {

          var dupErr = new Error(
            'Cannot add two accounts with the same url / entry point'
          );

          dupErr.name = 'account-exist';
          callback(dupErr);
          return;
        }
      }

      callback();
    });
  },

  verifyAndPersist: function(model, callback) {
    var self = this;
    var provider = providerFactory.get(
      model.providerType
    );

    provider.getAccount(model.toJSON(), function(err, data) {
      if (err) {
        callback(err);
        return;
      }

      model.error = undefined;

      // if this works we always will get a calendar home.
      // This is used to find calendars.
      model.calendarHome = data.calendarHome;

      // server may override properties on demand.
      extend(model, data);

      self._validateModel(model, function(err) {
        if (err) {
          return callback(err);
        }

        self.persist(model, callback);
      });
    });
  },

  /**
   * Because this is a top-level store
   * when we remove an account all records
   * related to it must be removed.
   */
  _dependentStores: [
    'accounts', 'calendars', 'events',
    'busytimes', 'alarms', 'icalComponents'
  ],

  _removeDependents: function(id, trans) {
    var store = this.db.getStore('Calendar');
    store.remotesByAccount(id, trans, function(err, related) {
      if (err) {
        return console.error('Error removing deps for account: ', id);
      }

      var key;
      for (key in related) {
        store.remove(related[key]._id, trans);
      }
    });
  },

  /**
   * Syncs all calendars for account.
   *
   * TODO: Deprecate this method in favor of new provider API's.
   *
   * @param {Calendar.Models.Account} account sync target.
   * @param {Function} callback node style.
   */
  sync: function(account, callback) {
    //TODO: We need to block removal when syncing
    //OR after removal ensure everything created here
    //is purged.

    var self = this;
    var provider = providerFactory.get(account.providerType);
    var calendarStore = this.db.getStore('Calendar');

    var persist = [];

    // remotesByAccount return an object indexed by remote ids
    var calendars;

    // these are remote ids not local ones
    var originalIds;

    function fetchExistingCalendars(err, results) {
      if (err) {
        return callback(err);
      }

      calendars = results;
      originalIds = Object.keys(calendars);

      provider.findCalendars(account, persistCalendars);
    }

    function persistCalendars(err, remoteCals) {
      var key;

      if (err) {
        callback(err);
        return;
      }

      for (key in remoteCals) {
        if (remoteCals.hasOwnProperty(key)) {
          var cal = remoteCals[key];
          var idx = originalIds.indexOf(key);

          if (idx !== -1) {
            // update an existing calendar
            originalIds.splice(idx, 1);

            var original = calendars[key];
            original.remote = cal;
            original.error = undefined;
            persist.push(original);
          } else {
            // create a new calendar
            persist.push(
              calendarStore._createModel({
                remote: new Object(cal),
                accountId: account._id
              })
            );
          }
        }
      }

      // at this point whatever is left in originalIds
      // is considered a removed calendar.

      // update / remove
      if (persist.length || originalIds.length) {
        var trans = self.db.transaction(
          self._dependentStores,
          'readwrite'
        );

        originalIds.forEach(function(id) {
          calendarStore.remove(calendars[id]._id, trans);
        });

        persist.forEach(function(object) {
          calendarStore.persist(object, trans);
        });

        // event listeners must come at the end
        // because persist/remove also listen to
        // transaction complete events.
        trans.addEventListener('error', function(err) {
          callback(err);
        });

        trans.addEventListener('complete', function() {
          callback(null);
        });
      } else {
        // invoke callback nothing to sync
        callback(null);
      }
    }

    calendarStore.remotesByAccount(
      account._id,
      fetchExistingCalendars
    );
  },

  _createModel: function(obj, id) {
    if (!(obj instanceof AccountModel)) {
      obj = new AccountModel(obj);
    }

    if (typeof(id) !== 'undefined') {
      obj._id = id;
    }

    return obj;
  },

  /**
   * Marks given model with an error and sends an error event with the given
   * model
   *
   * This will trigger an 'error' event immediately with the given model.
   * The callback fires _after_ the event. Its entirely possible (under rare
   * conditions) that this operation will fail but the event will fire.
   *
   *
   * @param {Object} account model.
   * @param {Calendar.Error} error to mark model with.
   * @param {IDBTransaction} [trans] optional transaction.
   * @param {Function} [callback] optional called with [err, model].
   */
  markWithError: function(account, error, trans, callback) {
    if (typeof(trans) === 'function') {
      callback = trans;
      trans = null;
    }

    if (!account._id) {
      throw new Error('given account must be persisted');
    }

    if (!account.error) {
      account.error = {
        name: error.name,
        date: new Date(),
        count: 0
      };
    }

    // increment the error count
    account.error.count++;

    var calendarStore = this.db.getStore('Calendar');
    var self = this;
    function fetchedCalendars(err, calendars) {
      if (!trans) {
        trans = self.db.transaction(
          self._dependentStores,
          'readwrite'
        );
      }

      if (err) {
        console.error('Cannot fetch all calendars', err);
        return self.persist(account, trans, callback);
      }

      for (var id in calendars) {
        calendarStore.markWithError(calendars[id], error, trans);
      }

      self.persist(account, trans);
      self._transactionCallback(trans, callback);

    }

    // find related calendars and mark those too
    calendarStore.remotesByAccount(
      account._id,
      fetchedCalendars
    );
  },

  /**
   * Finds and returns all accounts that can sync (based on their provider).
   *
   *    accountStore.syncableAccounts(function(err, list) {
   *      if (list.length === 0)
   *        // hide sync options
   *    });
   *
   * @param {Function} callback [Error err, Array accountList].
   */
  syncableAccounts: function(callback) {
    debug('Will find syncable accounts...');
    this.all((err, list) => {
      if (err) {
        return callback(err);
      }

      var results = [];
      for (var key in list) {
        var account = list[key];
        var provider = providerFactory.get(account.providerType);
        if (provider.canSync) {
          results.push(account);
        }
      }

      callback(null, results);
    });
  },

  /**
   * Returns a list of available presets filtered by
   * the currently used presets in the database.
   *
   * Expected structure of the presetList is as follows:
   *
   *    {
   *      'presetType': {
   *        // most important field when true if the preset
   *        // is available in the database that preset type
   *        // will be excluded.
   *        singleUse: true
   *        providerType: 'X',
   *        options: {}
   *      }
   *
   *    }
   *
   * @param {Object} presetList see example ^^^.
   * @param {Function} callback [err, ['presetKey', ...]].
   */
  availablePresets: function(presetList, callback) {
    var results = [];
    var singleUse = {};
    var hasSingleUses = false;

    for (var preset in presetList) {
      if (presetList[preset].singleUse) {
        hasSingleUses = true;
        singleUse[preset] = true;
      } else {
        results.push(preset);
      }
    }

    if (!hasSingleUses) {
      return nextTick(function() {
        callback(null, results);
      });
    }

    this.all(function(err, list) {
      if (err) {
        callback(err);
        return;
      }

      for (var id in list) {
        var preset = list[id].preset;
        if (singleUse[preset]) {
          delete singleUse[preset];
        }
      }

      // add un-used presets to the list.
      callback(null, results.concat(Object.keys(singleUse)));
    });
  }
};

});

/**
 * @fileoverview Simple helper function to convert basic platform DOMRequest
 *     into Promise. Deprecate once there is platform support for something
 *     like DOMRequest.then().
 */
define('create_dom_promise',['require','exports','module'],function(require, exports, module) {


module.exports = function createDOMPromise(request) {
  return new Promise((resolve, reject) => {
    request.onsuccess = resolve;
    request.onerror = reject;
  });
};

});

define('message_handler',['require','exports','module','responder','debug'],function(require, exports, module) {


var Responder = require('responder');
var debug = require('debug')('message_handler');

// Will be injected...
exports.app = null;
var responder = exports.responder = new Responder();

if (!('mozSetMessageHandler' in navigator)) {
  debug('mozSetMessageHandler is missing!');
  return;
}

debug('Will listen for alarm messages...');
navigator.mozSetMessageHandler('alarm', message => {
  debug('Received alarm message!');
  var data = message.data;
  switch (data.type) {
    case 'sync':
      responder.emit('sync');
      break;
    default:
      responder.emit('alarm', data);
      break;
  }
});

navigator.mozSetMessageHandler('notification', message => {
  debug('Received notification message!');
  // Handle notifications when the calendar app process is closed.
  if (!message.clicked) {
    return debug('Notification was not clicked?');
  }

  navigator.mozApps.getSelf().onsuccess = (event) => {
    var app = event.target.result;
    var url = message.imageURL.split('?')[1];

    window.addEventListener('moz-app-loaded', () => {
      debug('App is loaded. Notification will now redirect to:', url);
      exports.app.go(url);
    });

    app.launch();
  };
});

});

/* exported NotificationHelper */


/**
 * Keeping a reference on all active notifications to avoid weird GC issues.
 * See https://bugzilla.mozilla.org/show_bug.cgi?id=755402
 */

var NotificationHelper = {
  _referencesArray: [],

  getIconURI: function nc_getIconURI(app, entryPoint) {
    var icons = app.manifest.icons;

    if (entryPoint) {
      icons = app.manifest.entry_points[entryPoint].icons;
    }

    if (!icons) {
      return null;
    }

    var sizes = Object.keys(icons).map(function parse(str) {
      return parseInt(str, 10);
    });
    sizes.sort(function(x, y) { return y - x; });

    var HVGA = document.documentElement.clientWidth < 480;
    var index = sizes[HVGA ? sizes.length - 1 : 0];
    return app.installOrigin + icons[index];
  },

  send: function nc_send(title, body, icon, clickCB, closeCB) {
    if (!('mozNotification' in navigator)) {
      return;
    }

    var notification = navigator.mozNotification.createNotification(title,
                                                                    body, icon);

    notification.onclick = (function() {
      if (clickCB) {
        clickCB();
      }

      this._forget(notification);
    }).bind(this);

    notification.onclose = (function() {
      if (closeCB) {
        closeCB();
      }

      this._forget(notification);
    }).bind(this);

    notification.show();
    this._keep(notification);
  },

  _keep: function nc_keep(notification) {
    this._referencesArray.push(notification);
  },
  _forget: function nc_forget(notification) {
    var idx = this._referencesArray.indexOf(notification);
    if (idx >= 0) {
      this._referencesArray.splice(idx, 1);
    }
  }
};


define("shared/notification_helper", (function (global) {
    return function () {
        var ret, fn;
        return ret || global.NotificationHelper;
    };
}(this)));

/* global Notification */
define('notification',['require','exports','module','shared/notification_helper','debug'],function(require, exports, module) {


var NotificationHelper = require('shared/notification_helper');
var debug = require('debug')('notification');

var cachedSelf;

// Will be injected...
exports.app = null;

exports.sendNotification = function(title, body, url) {
  return getSelf().then(app => {
    if (!app) {
      // This is perhaps a test environment?
      debug('mozApps.getSelf gave us lemons!');
      return Promise.resolve();
    }

    var icon = NotificationHelper.getIconURI(app);
    icon += '?';
    icon += url;
    var notification = new Notification(title, { body: body, icon: icon });
    return new Promise((resolve, reject) => {
      notification.onshow = resolve;
      notification.onerror = reject;
      notification.onclick = function() {
        launch(url);
      };
    });
  });
};

/**
 * Bug 987458 - Multipe requests to mozApps.getSelf will fail if fired
 *     in close succession. Therefore we must make sure to only ever fire
 *     a single request to getSelf.
 */
function getSelf() {
  if (!cachedSelf) {
    cachedSelf = new Promise((resolve, reject) => {
      var request = navigator.mozApps.getSelf();

      request.onsuccess = (event) => {
        resolve(event.target.result);
      };

      request.onerror = () => {
        reject(new Error('mozApps.getSelf failed!'));
      };
    });
  }

  return cachedSelf;
}

/**
 * Start the calendar app and open the url.
 */
function launch(url) {
  return getSelf().then(app => {
    if (app) {
      app.launch();
    }

    exports.app.go(url);
  });
}

});

define('controllers/notifications',['require','exports','module','calc','date_format','debug','message_handler','notification'],function(require, exports) {


var calc = require('calc');
var dateFormat = require('date_format');
var debug = require('debug')('controllers/notifications');
var messageHandler = require('message_handler');
var notification = require('notification');

// Will be injected...
exports.app = null;

exports.observe = function() {
  debug('Will start notifications controller...');
  messageHandler.responder.on('alarm', exports.onAlarm);
};

exports.unobserve = function() {
  messageHandler.responder.off('alarm', exports.onAlarm);
};

exports.onAlarm = function(alarm) {
  debug('Will request cpu wake lock...');
  var lock = navigator.requestWakeLock('cpu');
  debug('Received cpu lock. Will issue notification...');
  return issueNotification(alarm).then(() => {
    debug('Will release cpu wake lock...');
    lock.unlock();
  });
};

function issueNotification(alarm) {
  var app = exports.app;
  var eventStore = app.store('Event');
  var busytimeStore = app.store('Busytime');

  var trans = app.db.transaction(['busytimes', 'events']);

  // Find the event and busytime associated with this alarm.
  return Promise.all([
    eventStore.get(alarm.eventId, trans),
    busytimeStore.get(alarm.busytimeId, trans)
  ])
  .then(values => {
    var [event, busytime] = values;
    var begins = calc.dateFromTransport(busytime.start);
    var distance = dateFormat.fromNow(begins);
    var now = new Date();

    var alarmType = begins > now ?
      'alarm-start-notice' :
      'alarm-started-notice';

    var l10n = navigator.mozL10n;
    var title = l10n.get(alarmType, {
      title: event.remote.title,
      distance: distance
    });

    var body = event.remote.description || '';
    debug('Will send event notification with title:', title, 'body:', body);
    notification.app = exports.app;
    return notification.sendNotification(
      title,
      body,
      `/alarm-display/${busytime._id}`
    );
  });
}

});

define('object',['require','exports','module'],function(require, exports, module) {


exports.filter = function(obj, fn, thisArg) {
  var results = [];
  exports.forEach(obj, function(key, value) {
    if (fn.call(thisArg, key, value)) {
      results.push(value);
    }
  });

  return results;
};

exports.forEach = function(obj, fn, thisArg) {
  exports.map(obj, fn, thisArg);
};

exports.map = function(obj, fn, thisArg) {
  var results = [];
  Object.keys(obj).forEach((key) => {
    var value = obj[key];
    var result = fn.call(thisArg, key, value);
    results.push(result);
  });

  return results;
};

exports.values = function(obj) {
  return exports.map(obj, (key, value) => {
    return value;
  });
};

});

define('store/alarm',['require','exports','module','./abstract','calc','create_dom_promise','debug','promise','controllers/notifications','object'],function(require, exports, module) {


var Abstract = require('./abstract');
var Calc = require('calc');
var createDOMPromise = require('create_dom_promise');
var debug = require('debug')('store/alarm');
var denodeifyAll = require('promise').denodeifyAll;
var notificationsController = require('controllers/notifications');
var object = require('object');

/**
 * The alarm store can be thought of as a big queue.
 * Over time we add and remove alarm times related to
 * a specific busytime/event instance.
 * (and there could be multiple alarms per busytime/event).
 *
 * When `workQueue` is called records will be removed
 * from the queue (this object store) and added (via mozAlarms).
 */
function Alarm() {
  Abstract.apply(this, arguments);
  this._processQueue = this._processQueue.bind(this);

  denodeifyAll(this, [
    'findAllByBusytimeId',
    'workQueue'
  ]);
}
module.exports = Alarm;

Alarm.prototype = {
  __proto__: Abstract.prototype,

  _store: 'alarms',

  _dependentStores: ['alarms'],

  /**
   * Number of hours ahead of current time to add new alarms.
   *
   * @type Numeric
   */
  _alarmAddThresholdHours: 48,

  /** disable caching */
  _addToCache: function() {},
  _removeFromCache: function() {},

  /**
   * When false will not process queue automatically
   * (that is after each alarm transaction is complete).
   *
   * @type {Boolean}
   */
  autoQueue: false,

  _processQueue: function() {
    this.workQueue();
  },

  _objectData: function(object) {
    var data = Abstract.prototype._objectData.call(this, object);
    if (data.startDate) {
      // ensure the pending trigger is always in sync
      // with the current trigger whenever we update
      // the model.
      data.trigger = data.startDate;
    }

    return data;
  },

  /**
   * Manage the queue when alarms are added.
   */
  _addDependents: function(obj, trans) {
    if (!this.autoQueue) {
      return;
    }

    // by using processQueue even if we added
    // 6000 alarms during a single transaction we only
    // receive the event once as addEventListener discards
    // duplicates.
    trans.addEventListener('complete', this._processQueue);
  },

  /**
   * Move alarms over to the alarm api's database.
   *
   *
   * @param {Date} now date to use as current time.
   *
   * @param {Boolean} requiresAlarm attempts to ensure at
   *                                lest one alarm is added.
   *
   * @param {Function} callback node style callback.
   */
  _moveAlarms: function(now, requiresAlarm, callback) {
    // use transport dates so we can handle timezones & floating time.
    var time = Calc.dateToTransport(now);
    var utc = time.utc;
    // keep adding events until we are beyond this time.
    var minimum = utc + (this._alarmAddThresholdHours * Calc.HOUR);

    var request = this.db
      .transaction('alarms', 'readwrite')
      .objectStore('alarms')
      .index('trigger')
      .openCursor();

    request.onerror = function() {
      callback(new Error('Alarm cursor failed to open.'));
    };

    var past = [];  // Alarms that should be fired immediately.
    var future = [];  // Alarms that should fire in the future.
    request.onsuccess = function(event) {
      var cursor = event.target.result;
      if (!cursor ||
          (cursor.key >= minimum && (!requiresAlarm || future.length))) {
        // We've pulled all (or at least enough) alarms into memory.
        // Now we can send them to the notifications controller
        // or the alarms api.
        return dispatchAlarms(past, future)
        .then(callback)
        .catch(error => debug('Error dispatching alarms:', error));
      }

      var record = cursor.value;
      var date = Calc.dateFromTransport(record.trigger);
      var bucket = date < Date.now() ? past : future;
      bucket.push(record);
      // We need to save the trigger time so that we can send the
      // appropriate time to the alarms api. However, we want to mark
      // that we've handled this alarm so delete the trigger prop.
      record.triggered = record.trigger;
      delete record.trigger;
      cursor.update(record);
      cursor.continue();
    };
  },

  /**
   * Finds single alarm by busytime id.
   *
   * @param {Object} related busytime object.
   * @param {IDBTransaction} [trans] optional transaction.
   * @param {Function} callback node style [err, records].
   */
  findAllByBusytimeId: function(busytimeId, trans, callback) {
    if (typeof(trans) === 'function') {
      callback = trans;
      trans = null;
    }

    if (!trans) {
      trans = this.db.transaction(this._dependentStores);
    }

    var store = trans.objectStore(this._store);
    var index = store.index('busytimeId');
    var key = IDBKeyRange.only(busytimeId);

    index.mozGetAll(key).onsuccess = function(e) {
      callback(null, e.target.result);
    };
  },

  /**
   * Works queue putting alarms into the alarm api database where needed.
   *
   */
  workQueue: function(now, callback) {
    if (typeof(now) === 'function') {
      callback = now;
      now = null;
    }

    now = now || new Date();
    var alarms = navigator.mozAlarms;

    if (!alarms) {
      if (callback) {
        callback(null);
      }

      return;
    }

    var self = this;
    var requiresAlarm = false;

    /**
     * Why are we getting all alarms here?
     *
     * The alarms are designed to keep the total number
     * of entires (in mozAlarms) down but we should keep at
     * minimum one active at all times. For example if the user
     * has sync turned off and wants notifications we need
     * to have an alarm go off to trigger adding more alarms.
     */
    var req = alarms.getAll();

    //XXX: even with the good reasons above we need
    //     to justify the perf cost here later.
    req.onsuccess = function(e) {
      var data = e.target.result;
      var len = data.length;
      var mozAlarm;

      requiresAlarm = true;

      for (var i = 0; i < len; i++) {
        mozAlarm = data[i].data;
        if (
          mozAlarm &&
          'eventId' in mozAlarm &&
          'trigger' in mozAlarm
        ) {
          requiresAlarm = false;
          break;
        }
      }

      callback = callback || function() {};
      self._moveAlarms(
        now,
        requiresAlarm,
        callback
      );
    };

    req.onerror = function() {
      var msg = 'failed to get alarms';
      console.error('CALENDAR:', msg);

      if (callback) {
        callback(new Error(msg));
      }
    };
  }
};

function dispatchAlarms(past, future) {
  // If the alarm was meant to be triggered in the past,
  // we want to immediately issue a notification.
  // However, in bug 857284 we add the stipulation that
  // we shouldn't issue duplicates, so handle that here also.
  var eventToAlarm = {};
  past.forEach(alarm => {
    var event = alarm.eventId;
    if (!event || event in eventToAlarm) {
      return;
    }

    eventToAlarm[event] = alarm;
  });

  object.forEach(eventToAlarm, (event, alarm) => {
    notificationsController.onAlarm(alarm);
  });

  // If the alarm should be triggered in the future, then we can create an
  // entry in the alarms api to wake us up to issue a notification for it
  // at the appropriate time.
  var alarms = navigator.mozAlarms;
  return Promise.all(future.map(alarm => {
    var timezone = alarm.triggered.tzid === Calc.FLOATING ?
      'ignoreTimezone' :
      'honorTimezone';
    return createDOMPromise(
      alarms.add(
        Calc.dateFromTransport(alarm.triggered),
        timezone,
        alarm
      )
    );
  }));
}

});

define('time_observer',['require','exports','module','timespan'],function(require, exports, module) {


var Timespan = require('timespan');

function TimeObserver() {
  this._timeObservers = [];
}
module.exports = TimeObserver;

TimeObserver.enhance = function(given) {
  var key;
  var proto = TimeObserver.prototype;
  for (key in proto) {
    if (proto.hasOwnProperty(key)) {
      given[key] = proto[key];
    }
  }
};

TimeObserver.prototype = {
 /**
   * Adds observer for timespan.
   *
   * Object example:
   *
   *    object.handleEvent = function(e) {
   *      // e.type
   *      // e.data
   *      // e.time
   *    }
   *
   *    // when given an object
   *    EventStore.observe(timespan, object)
   *
   *
   * Callback example:
   *
   *    EventStore.observe(timespan, function(event) {
   *      // e.type
   *      // e.data
   *      // e.time
   *    });
   *
   * @param {Calendar.Timespan} timespan span to observe.
   * @param {Function|Object} callback function or object follows
   *                                   EventTarget pattern.
   */
  observeTime: function(timespan, callback) {
    if (!(timespan instanceof Timespan)) {
      throw new Error(
        'must pass an instance of Timespan as first argument'
      );
    }
    this._timeObservers.push([timespan, callback]);
  },

  /**
   * Finds index of timespan/object|callback pair.
   *
   * Used internally and in tests has little practical use
   * unless you have the original timespan object.
   *
   * @param {Calendar.Timespan} timespan original (===) timespan used.
   * @param {Function|Object} callback original callback/object.
   * @return {Numeric} -1 when not found otherwise index.
   */
  findTimeObserver: function(timespan, callback) {
    var len = this._timeObservers.length;
    var field;
    var i = 0;

    for (; i < len; i++) {
      field = this._timeObservers[i];

      if (field[0] === timespan &&
          field[1] === callback) {

        return i;
      }
    }

    return -1;
  },

  /**
   * Removes a time observer you
   * must pass the same instance of both
   * the timespan and the callback/object
   *
   *
   * @param {Calendar.Timespan} timespan timespan object.
   * @param {Function|Object} callback original callback/object.
   * @return {Boolean} true when found & removed callback.
   */
  removeTimeObserver: function(timespan, callback) {
    var idx = this.findTimeObserver(timespan, callback);

    if (idx !== -1) {
      this._timeObservers.splice(idx, 1);
      return true;
    } else {
      return false;
    }
  },

  /**
   * Fires a time based event.
   *
   * @param {String} type name of event.
   * @param {Date|Numeric} start start position of time event.
   * @param {Date|Numeric} end end position of time event.
   * @param {Object} data data related to event.
   */
  fireTimeEvent: function(type, start, end, data) {
    var i = 0;
    var len = this._timeObservers.length;
    var observer;
    var event = {
      time: true,
      data: data,
      type: type
    };

    for (; i < len; i++) {
      observer = this._timeObservers[i];
      if (observer[0].overlaps(start, end)) {
        if (typeof(observer[1]) === 'object') {
          observer[1].handleEvent(event);
        } else {
          observer[1](event);
        }
      }
    }
  }
};

});

/**
 * Binary search utilities taken /w permission from :asuth
 */
define('binsearch',['require','exports','module'],function(require, exports) {


exports.find = function(list, seekVal, cmpfunc, aLow, aHigh) {
  var low = ((aLow === undefined) ? 0 : aLow),
      high = ((aHigh === undefined) ? (list.length - 1) : aHigh),
      mid, cmpval;

  while (low <= high) {
    mid = low + Math.floor((high - low) / 2);
    cmpval = cmpfunc(seekVal, list[mid]);
    if (cmpval < 0) {
      high = mid - 1;
    } else if (cmpval > 0) {
      low = mid + 1;
    } else {
      return mid;
    }
  }

  return null;
};

exports.insert = function(list, seekVal, cmpfunc) {
  if (!list.length) {
    return 0;
  }

  var low = 0, high = list.length - 1,
      mid, cmpval;

  while (low <= high) {
    mid = low + Math.floor((high - low) / 2);
    cmpval = cmpfunc(seekVal, list[mid]);

    if (cmpval < 0) {
      high = mid - 1;
    } else if (cmpval > 0) {
      low = mid + 1;
    } else {
      break;
    }
  }

  if (cmpval < 0) {
    return mid; // insertion is displacing, so use mid outright.
  } else if (cmpval > 0) {
    return mid + 1;
  } else {
    return mid;
  }
};

});

define('compare',['require','exports','module'],function(require, exports, module) {


module.exports = function(a, b) {
  if (a > b) {
    return 1;
  }

  if (a < b) {
    return -1;
  }

  return 0;
};

});

define('store/busytime',['require','exports','module','./abstract','calc','time_observer','binsearch','compare','promise'],function(require, exports, module) {


var Abstract = require('./abstract');
var Calc = require('calc');
var TimeObserver = require('time_observer');
var binsearch = require('binsearch');
var compare = require('compare');
var denodeifyAll = require('promise').denodeifyAll;

/**
 * Objects saved in the busytime store:
 *
 *    {
 *      _id: (uuid),
 *      start: Calendar.Calc.dateToTransport(x),
 *      end: Calendar.Calc.dateToTransport(x),
 *      eventId: eventId,
 *      calendarId: calendarId
 *    }
 *
 */
function Busytime() {
  Abstract.apply(this, arguments);
  this._setupCache();

  denodeifyAll(this, [
    'removeEvent',
    'loadSpan'
  ]);
}
module.exports = Busytime;

Busytime.prototype = {
  __proto__: Abstract.prototype,

  _store: 'busytimes',

  _dependentStores: ['alarms', 'busytimes'],

  _setupCache: function() {
    // reset time observers
    TimeObserver.call(this);

    this._byEventId = Object.create(null);
  },

  _createModel: function(input, id) {
    return this.initRecord(input, id);
  },

  initRecord: function(input, id) {
    var _super = Abstract.prototype._createModel;
    var model = _super.apply(this, arguments);
    model.startDate = Calc.dateFromTransport(model.start);
    model.endDate = Calc.dateFromTransport(model.end);
    return model;
  },

  _removeDependents: function(id, trans) {
    this.db.getStore('Alarm').removeByIndex('busytimeId', id, trans);
  },

  removeEvent: function(id, trans, callback) {
    if (typeof(trans) === 'function') {
      callback = trans;
      trans = undefined;
    }

    if (typeof(trans) === 'undefined') {
      trans = this.db.transaction(
        this._dependentStores,
        'readwrite'
      );
    }

    // build the request using the inherited method
    var req = this.removeByIndex('eventId', id, trans);

    // get the original method which handles the generic bit
    var success = req.onsuccess;

    // override the default .onsuccess to get the ids
    // so we can emit remove events.
    var self = this;
    req.onsuccess = function(e) {
      var cursor = e.target.result;

      if (cursor) {
        var id = cursor.primaryKey;
        self.emit('remove', id);
      }

      success(e);
    };

    this._transactionCallback(trans, callback);
  },

  _startCompare: function(aObj, bObj) {
    var a = aObj.start.utc;
    var b = bObj.start.utc;
    return compare(a, b);
  },

  /**
   * Loads all busytimes in given timespan.
   *
   * @param {Calendar.Timespan} span timespan.
   * @param {Function} callback node style callback
   *                            where first argument is
   *                            an error (or null)
   *                            and the second argument
   *                            is a list of all loaded
   *                            busytimes in the timespan.
   */
  loadSpan: function(span, callback) {
    var trans = this.db.transaction(this._store);
    var store = trans.objectStore(this._store);

    var startPoint = Calc.dateToTransport(new Date(span.start));
    var endPoint = Calc.dateToTransport(new Date(span.end));

    // XXX: we need to implement busytime chunking
    // to make this efficient.
    var keyRange = IDBKeyRange.lowerBound(startPoint.utc);

    var index = store.index('end');
    var self = this;

    index.mozGetAll(keyRange).onsuccess = function(e) {
      var data = e.target.result;

      // sort data
      data = data.sort(self._startCompare);

      // attempt to find a start time that occurs
      // after the end time of the span
      var idx = binsearch.insert(
        data,
        { start: { utc: endPoint.utc + 1 } },
        self._startCompare
      );

      // remove unrelated timespan...
      data = data.slice(0, idx);

      // fire callback
      if (callback) {
        callback(null, data.map(function(item) {
          return self.initRecord(item);
        }));
      }

    };
  },

  /* we don't use id based caching for busytimes */

  _addToCache: function() {},
  _removeFromCache: function() {}

};

});

define('models/calendar',['require','exports','module'],function(require, exports, module) {


function Cal(options) {
  if (typeof(options) === 'undefined') {
    options = {};
  }

  this.remote = {};

  for (var key in options) {
    if (options.hasOwnProperty(key)) {
      this[key] = options[key];
    }
  }
}
module.exports = Cal;

Cal.prototype = {

  /**
   * Local copy of calendars remote state.
   * Taken from a calendar providers .toJSON method.
   *
   * @type {Object}
   */
  remote: null,

  /**
   * The date at which this calendar's events
   * where synchronized.
   *
   * @type {Date}
   */
  firstEventSyncDate: null,

  /**
   * Last sync token used in previous
   * event synchronization.
   *
   * @type {String}
   */
  lastEventSyncToken: '',

  /**
   * Last date of event synchronization.
   * This is not going to be used
   * for any kind of serious operation
   * right now this is just for the UI.
   *
   * @type {Date}
   */
  lastEventSyncDate: '',

  /**
   * Indicates if calendar is displayed
   * locally in the ui.
   *
   * @type {Boolean}
   */
  localDisplayed: true,

  /**
   * Id of account this record
   * is associated with.
   */
  accountId: '',

  /**
   * Updates remote with data from a calendar provider.
   *
   * @param {Calendar.Provider.Calendar.Abstract} provider remote.
   */
  updateRemote: function(provider) {
    var data = provider;
    if ('toJSON' in provider) {
        data = provider.toJSON();
    }

    this.remote = data;
  },

  /**
   * Checks if local and remote state differ
   * via sync tokens. Returns true when
   * local sync token and remote do not match.
   * Does not account for local changes only
   * when the server state has changed
   * and we have not yet synchronized.
   *
   * @return {Boolean} true when sync needed.
   */
  eventSyncNeeded: function() {
    var local = this.lastEventSyncToken;
    var remote = this.remote.syncToken;

    return local != remote;
  },

  set name(name) {
    this.remote.name = name;
    return this.remote.name;
  },

  set color(color) {
    this.remote.color = color;
    return this.remote.color;
  },

  set description(description) {
    this.remote.description = description;
    return this.remote.description;
  },

  get name() {
    return this.remote.name;
  },

  get color() {
    var color = this.remote.color;
    if (color) {
      if (color.substr(0, 1) === '#') {
        return color.substr(0, 7);
      }
    }
    return this.remote.color;
  },

  get description() {
    return this.remote.description;
  },

  toJSON: function() {
    var result = {
      error: this.error,
      remote: this.remote,
      accountId: this.accountId,
      localDisplayed: this.localDisplayed,
      lastEventSyncDate: this.lastEventSyncDate,
      lastEventSyncToken: this.lastEventSyncToken,
      firstEventSyncDate: this.firstEventSyncDate
    };

    if (this._id || this._id === 0) {
      result._id = this._id;
    }

    return result;
  }

};

});

define('store/calendar',['require','exports','module','./abstract','models/calendar','provider/local','promise','probably_parse_int','provider/provider_factory'],function(require, exports, module) {


var Abstract = require('./abstract');
var CalendarModel = require('models/calendar');
var Local = require('provider/local');
var denodeifyAll = require('promise').denodeifyAll;
var probablyParseInt = require('probably_parse_int');
var providerFactory = require('provider/provider_factory');

function Store() {
  Abstract.apply(this, arguments);
  this._usedColors = [];

  denodeifyAll(this, [
    'markWithError',
    'remotesByAccount',
    'sync',
    'providerFor',
    'ownersOf'
  ]);
}
module.exports = Store;

/**
 * Remote calendar colors
 */
Store.REMOTE_COLORS = [
  '#00aacc', // light blue
  '#bad600', // light green
  '#df4784', // pink
  '#f9bc17', // yellow
  '#0766b7', // dark blue
  '#76a408', // dark green
  '#33a185'  // teal
];

/**
 * Local calendar color (orange)
 */
Store.LOCAL_COLOR = '#f97c17',

/**
 * List of possible calendar capabilities.
 */
Store.capabilities = {
  createEvent: 'canCreateEvent',
  updateEvent: 'canUpdateEvent',
  deleteEvent: 'canDeleteEvent'
};

Store.prototype = {
  __proto__: Abstract.prototype,

  _store: 'calendars',

  _dependentStores: [
    'calendars', 'events', 'busytimes',
    'alarms', 'icalComponents'
  ],

  _parseId: probablyParseInt,

  _createModel: function(obj, id) {
    if (!(obj instanceof CalendarModel)) {
      obj = new CalendarModel(obj);
    }

    if (typeof(id) !== 'undefined') {
      obj._id = id;
    }

    return obj;
  },

  _removeDependents: function(id, trans) {
    var store = this.db.getStore('Event');
    store.removeByIndex('calendarId', id, trans);
  },

  /**
   * Marks a given calendar with an error.
   *
   * Emits a 'error' event immediately.. This method is typically
   * triggered by an account wide error.
   *
   *
   * @param {Object} calendar model.
   * @param {Calendar.Error} error for given calendar.
   * @param {IDBTransaction} transaction optional.
   * @param {Function} callback fired when model is saved [err, id, model].
   */
  markWithError: function(calendar, error, trans, callback) {
    if (typeof(trans) === 'function') {
      callback = trans;
      trans = null;
    }

    if (!calendar._id) {
      throw new Error('given calendar must be persisted.');
    }

    calendar.error = {
      name: error.name,
      date: new Date()
    };

    this.persist(calendar, trans, callback);
  },

  persist: function(calendar, trans, callback) {
    if (typeof(trans) === 'function') {
      callback = trans;
      trans = undefined;
    }

    this._updateCalendarColor(calendar);

    var cb = callback;
    var cached = this._cached[calendar._id];

    if (cached && cached.localDisplayed !== calendar.localDisplayed) {
      cb = function(err, id, model) {
        this.emit('calendarVisibilityChange', id, model);
        callback(err, id, model);
      }.bind(this);
    }

    Abstract.prototype.persist.call(this, calendar, trans, cb);
  },

  remove: function(id, trans, callback) {
    this._removeCalendarColorFromCache(id);
    Abstract.prototype.remove.apply(this, arguments);
  },

  _updateCalendarColor: function(calendar) {
    // we avoid storing multiple colors for same calendar in case of an
    // "update" operation
    this._removeCalendarColorFromCache(calendar._id);
    this._setCalendarColor(calendar);
    // cache is built asynchronously, we need to store the color as soon as
    // possible to avoid adding same color multiple times in a row (eg.
    // account with multiple calendars will call persist multiple times)
    this._usedColors.push(calendar.color);
  },

  _removeCalendarColorFromCache: function(id) {
    // we need to remove the color from index as soon as possible to avoid
    // race conditions (remove is async)
    var color = this._getCachedColorByCalendarId(id);
    var index = this._usedColors.indexOf(color);
    if (index !== -1) {
      this._usedColors.splice(index, 1);
    }
  },

  _getCachedColorByCalendarId: function(id) {
    return this._cached[id] && this._cached[id].color;
  },

  _setCalendarColor: function(calendar) {
    // local calendar should always use the same color
    if (calendar._id === Local.calendarId) {
      calendar.color = Store.LOCAL_COLOR;
      return;
    }

    // restore previous color only if it is part of the palette, otherwise we
    // get the next available color (or least used)
    var prevColor = this._getCachedColorByCalendarId(calendar._id);
    if (prevColor && Store.REMOTE_COLORS.indexOf(prevColor) !== -1) {
      calendar.color = prevColor;
    } else {
      calendar.color = this._getNextColor();
    }
  },

  _getNextColor: function() {
    var available = Store.REMOTE_COLORS.filter(function(color) {
      return this._usedColors.indexOf(color) === -1;
    }, this);

    return available.length ? available[0] : this._getLeastUsedColor();
  },

  _getLeastUsedColor: function() {
    var counter = {};
    this._usedColors.forEach(function(color) {
      counter[color] = (counter[color] || 0) + 1;
    });

    var leastUsedColor;
    var leastUsedCount = Infinity;
    for (var color in counter) {
      if (counter[color] < leastUsedCount) {
        leastUsedCount = counter[color];
        leastUsedColor = color;
      }
    }

    return leastUsedColor;
  },

  shouldDisplayCalendar: function(calendarId) {
    var calendar = this._cached[calendarId];
    return calendar && calendar.localDisplayed;
  },

  /**
   * Find calendars in a specific account.
   * Results will be returned in an object where
   * the key is the remote.id and the value is the calendar.
   *
   * @param {String|Numeric} accountId id of account.
   * @param {Function} callback [err, object] see above.
   */
  remotesByAccount: function(accountId, trans, callback) {
    if (typeof(trans) === 'function') {
      callback = trans;
      trans = null;
    }

    if (!trans) {
      trans = this.db.transaction(this._store);
    }

    var store = trans.objectStore(this._store);

    var reqKey = IDBKeyRange.only(accountId);
    var req = store.index('accountId').mozGetAll(reqKey);

    req.onerror = function remotesError(e) {
      callback(e.target.error);
    };

    var self = this;
    req.onsuccess = function remotesSuccess(e) {
      var result = Object.create(null);
      e.target.result.forEach(function(calendar) {
        result[calendar.remote.id] = self._createModel(
          calendar,
          calendar._id
        );
      });

      callback(null, result);
    };
  },

  /**
   * Sync remote and local events for a calendar.
   *
   * TODO: Deprecate use of this function in favor of a sync methods
   *       inside of providers.
   */
  sync: function(account, calendar, callback) {
    var provider = providerFactory.get(account.providerType);
    provider.syncEvents(account, calendar, callback);
  },

  /**
   * Shortcut to find provider for calendar.
   *
   * @param {Calendar.Models.Calendar} calendar input calendar.
   * @param {Function} callback [err, provider].
   */
  providerFor: function(calendar, callback) {
    this.ownersOf(calendar, function(err, owners) {
      if (err) {
        return callback(err);
      }

      callback(null, providerFactory.get(owners.account.providerType));
    });
  },

  /**
   * Finds calendar/account for a given event.
   *
   * TODO: think about moving this function into its
   * own file as a mixin.
   *
   * @param {Object|String|Numeric} objectOrId must contain .calendarId.
   * @param {Function} callback [err, { ... }].
   */
  ownersOf: function(objectOrId, callback) {
    var result = {};

    var accountStore = this.db.getStore('Account');

    // case 1. given a calendar
    if (objectOrId instanceof CalendarModel) {
      result.calendar = objectOrId;
      accountStore.get(objectOrId.accountId, fetchAccount);
      return;
    }

    // case 2 given a calendar id or object

    if (typeof(objectOrId) === 'object') {
      objectOrId = objectOrId.calendarId;
    }

    // why??? because we use this method in event store too..
    var calendarStore = this.db.getStore('Calendar');
    calendarStore.get(objectOrId, fetchCalendar);

    function fetchCalendar(err, calendar) {
      if (err) {
        return callback(err);
      }

      result.calendar = calendar;
      accountStore.get(calendar.accountId, fetchAccount);
    }

    function fetchAccount(err, account) {
      if (err) {
        return callback(err);
      }

      result.account = account;
      callback(null, result);
    }
  }
};

});

define('store/event',['require','exports','module','./abstract','calc','./calendar','promise','provider/provider_factory'],function(require, exports, module) {


var Abstract = require('./abstract');
var Calc = require('calc');
var Calendar = require('./calendar');
var denodeifyAll = require('promise').denodeifyAll;
var providerFactory = require('provider/provider_factory');

function Events() {
  Abstract.apply(this, arguments);

  denodeifyAll(this, [
    'providerFor',
    'findByIds',
    'ownersOf',
    'eventsForCalendar'
  ]);
}
module.exports = Events;

Events.prototype = {
  __proto__: Abstract.prototype,
  _store: 'events',
  _dependentStores: ['events', 'busytimes', 'alarms', 'icalComponents'],

  /** disable caching */
  _addToCache: function() {},
  _removeFromCache: function() {},

  _createModel: function(input, id) {
    var _super = Abstract.prototype._createModel;
    var model = _super.apply(this, arguments);
    model.remote.startDate = Calc.dateFromTransport(model.remote.start);
    model.remote.endDate = Calc.dateFromTransport(model.remote.end);
    return model;
  },

  /**
   * Link busytime dependants see _addDependents.
   */
  _removeDependents: function(id, trans) {
    this.removeByIndex('parentId', id, trans);

    var busy = this.db.getStore('Busytime');
    busy.removeEvent(id, trans);

    var component = this.db.getStore('IcalComponent');
    component.remove(id, trans);
  },

  /**
   * Generate an id for a newly created record.
   * Based off of remote id (uuid) and calendar id.
   */
  _assignId: function(obj) {
    var id = obj.calendarId + '-' + obj.remote.id;
    obj._id = id;
    return id;
  },

  /**
   * Shortcut finds provider for given event.
   *
   * @param {Object} event full event record from db.
   */
  providerFor: function(event, callback) {
    this.ownersOf(event, function(err, owners) {
      callback(null, providerFactory.get(owners.account.providerType));
    });
  },

  /**
   * Finds a list of events by id.
   *
   * @param {Array} ids list of ids.
   * @param {Function} callback node style second argument
   *                            is an object of _id/event.
   */
  findByIds: function(ids, callback) {
    var results = {};
    var pending = ids.length;
    var self = this;

    function next() {
      if (!(--pending)) {
        // fatal errors should break
        // and so we are not handling them
        // here...
        callback(null, results);
      }
    }

    function success(e) {
      var item = e.target.result;

      if (item) {
        results[item._id] = self._createModel(item);
      }

      next();
    }

    function error() {
      // can't find it or something
      // skip!
      next();
    }

    ids.forEach(function(id) {
      var trans = this.db.transaction('events');
      var store = trans.objectStore('events');
      var req = store.get(id);

      req.onsuccess = success;
      req.onerror = error;
    }, this);
  },

  /**
   * Finds calendar/account for a given event.
   *
   * @param {Object} event must contain .calendarId.
   * @param {Function} callback [err, { ... }].
   */
  ownersOf: Calendar.prototype.ownersOf,
  /**
   * Loads all events for given calendarId
   * and returns results. Does not cache.
   *
   * @param {String} calendarId calendar to find.
   * @param {Function} callback node style [err, array of events].
   */
  eventsForCalendar: function(calendarId, callback) {
    var trans = this.db.transaction('events');
    var store = trans.objectStore('events');
    var index = store.index('calendarId');
    var key = IDBKeyRange.only(calendarId);

    var req = index.mozGetAll(key);

    req.onsuccess = function(e) {
      callback(null, e.target.result);
    };

    req.onerror = function(e) {
      callback(e);
    };
  }
};

});

define('store/ical_component',['require','exports','module','./abstract','calc','promise'],function(require, exports, module) {


var Abstract = require('./abstract');
var Calc = require('calc');
var denodeifyAll = require('promise').denodeifyAll;

function IcalComponent() {
  Abstract.apply(this, arguments);

  denodeifyAll(this, [
    'findRecurrencesBefore'
  ]);
}
module.exports = IcalComponent;

IcalComponent.prototype = {
  __proto__: Abstract.prototype,

  _store: 'icalComponents',

  /** disable caching */
  _addToCache: function() {},
  _removeFromCache: function() {},

  _createModel: function(object) {
    return object;
  },

  _detectPersistType: function(object) {
    // always fire update.
    return 'update';
  },

  /**
   * Finds all components which have recurrences
   * that are not expanded beyond the given date.
   *
   * @param {Date} maxDate max date to find.
   * @param {Function} callback results of search [err, [icalComp, ...]].
   */
  findRecurrencesBefore: function(maxDate, callback) {
    var trans = this.db.transaction(this._store, 'readwrite');

    trans.onerror = function(event) {
      callback(event.target.error.name);
    };

    var time = Calc.dateToTransport(maxDate);
    var utc = time.utc;
    var range = IDBKeyRange.bound(0, utc);
    var store = trans.objectStore(this._store);
    var idx = store.index('lastRecurrenceId');

    var req = idx.mozGetAll(range);

    req.onsuccess = function(event) {
      callback(null, event.target.result);
    };
  }
};

});

define('store/setting',['require','exports','module','./abstract','promise','next_tick'],function(require, exports, module) {


var Abstract = require('./abstract');
var denodeifyAll = require('promise').denodeifyAll;
var nextTick = require('next_tick');

function Setting() {
  Abstract.apply(this, arguments);
  denodeifyAll(this, [
    'getValue',
    'set'
  ]);
}
module.exports = Setting;

Setting.prototype = {
  __proto__: Abstract.prototype,

  _store: 'settings',

  /**
   * Default option values.
   */
  defaults: {
    standardAlarmDefault: -300,
    alldayAlarmDefault: 32400,
    syncFrequency: 15,
    syncAlarm: {
      alarmId: null,
      start: null,
      end: null
    }
  },

  /** disable caching */
  _addToCache: function() {},
  _removeFromCache: function() {},

  /**
   * This method also will use the internal cache to ensure
   * callers are in a consistent state and don't require round
   * trips to the database. When the value does not exist defaults
   * are used where possible...
   *
   *
   *    settings.getValue('syncFrequency', function(err, value) {
   *      // ...
   *    });
   *
   *
   * @param {String} key name of setting.
   * @param {Function} callback usual [err, value] does not include metadata.
   */
  getValue: function(key, callback) {
    var self = this;

    if (key in this._cached) {
      nextTick(function handleCached() {
        callback(null, self._cached[key].value);
      });

      // we have cached value exit...
      return;
    }

    this.get(key, function handleStored(err, value) {
      if (err) {
        return callback(err);
      }

      if (value === undefined && self.defaults[key] !== undefined) {
        value = { value: self.defaults[key] };
      }

      self._cached[key] = value;
      callback(null, value.value);
    });
  },

  /**
   * Persist a setting change.
   *
   * In addition to updating the value of the setting
   * it will also update the updatedAt & createdAt properties
   * of the record.
   *
   * Calling this function will also emit a 'change' event
   * prior to fully persisting the record to the database.
   *
   * Example:
   *
   *    var settingStore;
   *
   *    settingStore.set('syncFrequency', 15, function() {
   *      // done
   *    });
   *
   *    // somewhere else in the app:
   *
   *    settingStore.on('syncFrequencyChange', function(value) {
   *      // value === 15
   *    });
   *
   * @param {String} key name of setting.
   * @param {Object} value any object that IndexedDb can store.
   * @param {IDBTransaction} [trans] idb transaction optional.
   * @param {Function} [callback] optional callback.
   */
  set: function(key, value, trans, callback) {
    if (typeof(trans) === 'function') {
      callback = trans;
      trans = null;
    }

    var cached = this._cached[key];
    var record;

    if (cached && cached._id) {
      cached.value = value;
      cached.updatedAt = new Date();
      record = cached;
    } else {
      var created = new Date();
      this._cached[key] = record = {
        _id: key,
        createdAt: created,
        updatedAt: created,
        value: value
      };
    }

    this.emit(key + 'Change', value, record);
    this.persist(record, trans, callback);
  }

};

});

define('store/store',['require','exports','module','./abstract','./account','./alarm','./busytime','./calendar','./event','./ical_component','./setting'],function(require, exports) {


exports.Abstract = require('./abstract');
exports.Account = require('./account');
exports.Alarm = require('./alarm');
exports.Busytime = require('./busytime');
exports.Calendar = require('./calendar');
exports.Event = require('./event');
exports.IcalComponent = require('./ical_component');
exports.Setting = require('./setting');

});

/* jshint loopfunc: true */
define('db',['require','exports','module','models/account','presets','provider/local','responder','store/store','debug','next_tick','probably_parse_int','ext/uuid'],function(require, exports, module) {


var Account = require('models/account');
var Presets = require('presets');
var Local = require('provider/local');
var Responder = require('responder');
var Store = require('store/store');
var debug = require('debug')('db');
var nextTick = require('next_tick');
var probablyParseInt = require('probably_parse_int');
var uuid = require('ext/uuid');

var idb = window.indexedDB;

const VERSION = 15;

var store = Object.freeze({
  events: 'events',
  accounts: 'accounts',
  calendars: 'calendars',
  busytimes: 'busytimes',
  settings: 'settings',
  alarms: 'alarms',
  icalComponents: 'icalComponents'
});

function Db(name, app) {
  this.app = app;
  this.name = name;
  this._stores = Object.create(null);
  Responder.call(this);
  this._upgradeOperations = [];
}
module.exports = Db;

Db.prototype = {
  __proto__: Responder.prototype,

  /**
   * Database connection
   */
  connection: null,

  getStore: function(name) {
    if (!(name in this._stores)) {
      try {
        this._stores[name] = new Store[name](this, this.app);
      } catch (e) {
        console.error('Error', e.name, e.message);
        console.error('Failed to load store', name, e.stack);
      }
    }

    return this._stores[name];
  },

  load: function(callback) {
    debug('Will load b2g-calendar db.');

    var self = this;
    function setupDefaults() {
      if (self.oldVersion < 8) {
        self._setupDefaults(callback);
      } else {
        nextTick(callback);
      }
    }

    if (this.isOpen) {
      return setupDefaults();
    }

    this.open(VERSION, setupDefaults);
  },


  /**
   * Opens connection to database.
   *
   * @param {Numeric} [version] version of database to open.
   *                            default to current version.
   *                            Should _only_ be used in testing.
   *
   * @param {Function} [callback] first argument is error, second
   *                            is result of operation or null
   *                            in the error case.
   */
  open: function(version, callback) {
    if (typeof(version) === 'function') {
      callback = version;
      version = VERSION;
    }

    var req = idb.open(this.name, version);
    this.version = version;

    var self = this;

    req.onsuccess = function() {
      self.isOpen = true;
      self.connection = req.result;

      // if we have pending upgrade operations
      if (self._upgradeOperations.length) {
        var pending = self._upgradeOperations.length;

        var operation;
        while ((operation = self._upgradeOperations.shift())) {
          operation.call(self, function next() {
            if (!(--pending)) {
              callback(null, self);
              self.emit('open', self);
            }
          });
        }
      } else {
        callback(null, self);
        self.emit('open', self);
      }
    };

    req.onblocked = function(error) {
      callback(error, null);
      self.emit('error', error);
    };

    req.onupgradeneeded = function(event) {
      self._handleVersionChange(req.result, event);
    };

    req.onerror = function(error) {
      //TODO: steal asuth's error handling...
      callback(error, null);
      self.emit('error', error);
    };
  },

  transaction: function(list, state) {
    var names;
    var self = this;

    if (typeof(list) === 'string') {
      names = [];
      names.push(this.store[list] || list);
    } else {
      names = list.map(function(name) {
        return self.store[name] || name;
      });
    }

    return this.connection.transaction(names, state || 'readonly');
  },

  _handleVersionChange: function(db, event) {
    var newVersion = event.newVersion;
    var curVersion = event.oldVersion;
    var transaction = event.currentTarget.transaction;

    this.hasUpgraded = true;
    this.oldVersion = curVersion;
    this.upgradedVersion = newVersion;

    for (; curVersion < newVersion; curVersion++) {
      // if version is < 7 then it was from pre-production
      // db and we can safely discard its information.
      if (curVersion < 6) {
        // ensure clean state if this was an old db.
        var existingNames = db.objectStoreNames;
        for (var i = 0; i < existingNames.length; i++) {
          db.deleteObjectStore(existingNames[i]);
        }

        // version 0-r are not maintained increment to 6
        curVersion = 6;

        // busytimes has one event, has one calendar
        var busytimes = db.createObjectStore(
          store.busytimes,
          { keyPath: '_id' }
        );

        busytimes.createIndex(
          'end',
          'end.utc',
          { unique: false, multiEntry: false }
        );

        busytimes.createIndex(
          'eventId',
          'eventId',
          { unique: false, multiEntry: false }
        );

        // events -> belongs to calendar
        var events = db.createObjectStore(
          store.events,
          { keyPath: '_id' }
        );

        events.createIndex(
          'calendarId',
          'calendarId',
          { unique: false, multiEntry: false }
        );

        events.createIndex(
          'parentId',
          'parentId',
          { unique: false, multiEntry: false }
        );

        // accounts -> has many calendars
        db.createObjectStore(
          store.accounts, { keyPath: '_id', autoIncrement: true }
        );

        // calendars -> has many events
        db.createObjectStore(
          store.calendars, { keyPath: '_id', autoIncrement: true }
        );

      } else if (curVersion === 7) {
        db.createObjectStore(store.settings, { keyPath: '_id' });
      } else if (curVersion === 8) {
        var alarms = db.createObjectStore(
          store.alarms, { keyPath: '_id', autoIncrement: true }
        );

        alarms.createIndex(
          'trigger',
          'trigger.utc',
          { unique: false, multiEntry: false }
        );

        alarms.createIndex(
          'busytimeId',
          'busytimeId',
          { unique: false, multiEntry: false }
        );
     } else if (curVersion === 12) {
        var icalComponents = db.createObjectStore(
          store.icalComponents, { keyPath: 'eventId', autoIncrement: false }
        );

        icalComponents.createIndex(
          'lastRecurrenceId',
          'lastRecurrenceId.utc',
          { unique: false, multiEntry: false }
        );
      } else if (curVersion === 13) {
        var calendarStore = transaction.objectStore(store.calendars);
        calendarStore.createIndex(
          'accountId', 'accountId', { unique: false, multiEntry: false }
        );
      } else if (curVersion === 14) {
        // Bug 851003 - The database may have some busytimes and/or events
        // which have their calendarId field as a string rather than an int.
        // We need to fix the calendarIds and also remove any of the idb
        // objects that have deleted calendars.
        this.sanitizeEvents(transaction);
      }
    }
  },

  /**
   * 1. Find all events with string calendar ids and index them.
   * 2. Check for each of the events whether the calendar
   *    they reference still exists.
   * 3. Fix the events' calendarIds if the calendar still exists else
   *    delete them.
   * @param {IDBTransaction} trans The active idb transaction during db
   *     upgrade.
   */
  sanitizeEvents: function(trans) {
    /**
     * Map from calendar ids to lists of event ids
     * which we've fixed with that id.
     * @type {Object.<number, Array.<number>>}
     */
    var badCalendarIdToEventIds = {};

    var objectStore = trans.objectStore(store.events);
    objectStore.openCursor().onsuccess = (function(evt) {
      var cursor = evt.target.result;
      if (!cursor) {
        return this._updateXorDeleteEvents(badCalendarIdToEventIds, trans);
      }

      var calendarId = cursor.value.calendarId;
      if (typeof(calendarId) === 'number') {
        // Nothing to do here!
        return cursor.continue();
      }

      // Record the bad reference.
      var eventIds = badCalendarIdToEventIds[calendarId] || [];
      eventIds.push(cursor.key);
      badCalendarIdToEventIds[calendarId] = eventIds;
      cursor.continue();
    }).bind(this);
  },

  /**
   * 1. Check for each of the events whether the calendar
   *    they reference still exists.
   * 2. Fix the events' calendarIds if the calendar still exists else
   *    delete them.
   *
   * @param {Object.<number, Array.<number>>} badCalendarIdToEventIds Map
   *     from calendar ids to lists of event ids which we've fixed with
   *     that id.
   * @param {IDBTransaction} trans The active idb transaction during db
   *     upgrade.
   * @private
   */
  _updateXorDeleteEvents: function(badCalendarIdToEventIds, trans) {
    var calendarIds = Object.keys(badCalendarIdToEventIds);
    calendarIds.forEach(function(calendarId) {
      //Bug 887698 cases for calendarIds of types strings or integers
      calendarId = probablyParseInt(calendarId);
      var eventIds = badCalendarIdToEventIds[calendarId];
      var calendars = trans.objectStore(store.calendars);
      calendars.get(calendarId).onsuccess = (function(evt) {
        var result = evt.target.result;
        if (result) {
          this._updateEvents(eventIds, calendarId, trans);
        } else {
          this._deleteEvents(eventIds, trans);
        }
      }).bind(this);
    }, this);
  },

  /**
   * Update a collection of events and the busytimes that depend on them.
   *
   * @param {Array.<number>>} eventIds An array of event ids for the events.
   * @param {number} calendarId A numerical id to set as calendarId.
   * @param {IDBTransaction} trans The active idb transaction during db
   *     upgrade.
   * @private
   */
  _updateEvents: function(eventIds, calendarId, trans) {
    var eventStore = trans.objectStore(store.events);
    var busytimeStore = trans.objectStore(store.busytimes);
    var busytimeStoreIndexedByEventId = busytimeStore.index('eventId');

    eventIds.forEach(function(eventId) {
      eventStore.get(eventId).onsuccess = function(evt) {
        var result = evt.target.result;
        result.calendarId = calendarId;
        eventStore.put(result);
      };

      busytimeStoreIndexedByEventId.get(eventId).onsuccess = function(evt) {
        var result = evt.target.result;
        result.calendarId = calendarId;
        busytimeStore.put(result);
      };
    });
  },

  /**
   * Delete a collection of events and the busytimes that depend on them.
   *
   * @param {Array.<number>>} eventIds An array of event ids for the events.
   * @param {IDBTransaction} trans The active idb transaction during db
   *     upgrade.
   * @private
   */
  _deleteEvents: function(eventIds, trans) {
    var events = this.getStore('Event');
    eventIds.forEach(function(eventId) {
      events.remove(eventId, trans);
    });
  },

  get store() {
    return store;
  },

  /**
   * Shortcut method for connection.close
   */
  close: function() {
    if (this.connection) {
      this.isOpen = false;
      this.connection.close();
      this.connection = null;
    }
  },

  clearNonCredentials: function(callback) {
    var stores = ['events', 'busytimes'];
    var trans = this.transaction(
      stores,
      'readwrite'
    );

    trans.addEventListener('complete', callback);

    stores.forEach(function(store) {
      store = trans.objectStore(store);
      store.clear();
    });
  },

  /**
   * Setup default values for initial calendar load.
   */
  _setupDefaults: function(callback) {
    debug('Will setup defaults.');
    var calendarStore = this.getStore('Calendar');
    var accountStore = this.getStore('Account');

    var trans = calendarStore.db.transaction(
      ['accounts', 'calendars'],
      'readwrite'
    );

    if (callback) {
      trans.addEventListener('error', function(err) {
        callback(err);
      });

      trans.addEventListener('complete', function() {
        callback();
      });
    }

    var options = Presets.local.options;
    debug('Creating local calendar with options:', options);
    var account = new Account(options);
    account.preset = 'local';
    account._id = uuid();

    var calendar = {
      _id: Local.calendarId,
      accountId: account._id,
      remote: Local.defaultCalendar()
    };

    accountStore.persist(account, trans);
    calendarStore.persist(calendar, trans);
  },

  deleteDatabase: function(callback) {
    var req = idb.deleteDatabase(this.name);

    req.onblocked = function() {
      // improve interface
      callback(new Error('blocked'));
    };

    req.onsuccess = function(event) {
      callback(null, event);
    };

    req.onerror = function(event) {
      callback(event, null);
    };
  }
};

});

define('controllers/error',['require','exports','module','error','error','responder','next_tick','notification'],function(require, exports, module) {


var Authentication = require('error').Authentication;
var InvalidServer = require('error').InvalidServer;
var Responder = require('responder');
var nextTick = require('next_tick');
var notification = require('notification');

/**
 * Global error handler / default handling for errors.
 *
 * @param {Calendar.App} app current application.
 */
function ErrorController(app) {
  Responder.call(this);

  this.app = app;
  this._handlers = Object.create(null);
}
module.exports = ErrorController;

ErrorController.prototype = {
  __proto__: Responder.prototype,

  /**
   * URL in which account errors are dispatched to.
   */
  accountErrorUrl: '/update-account/',

  /**
   * Dispatch an error event.
   *
   * If this type of event has been captured will be dispatched directly to
   * the callback provided. Otherwise the default behaviour will be triggered.
   *
   * @param {Calendar.Error} error to dispatch.
   */
  dispatch: function(error) {
    if (error instanceof Authentication || error instanceof InvalidServer) {
      this.handleAuthenticate(error.detail.account);
    }

    this.emit('error', error);
  },

  /**
   * Default handler for authentication errors.
   *
   * @param {Object} account to notify user about.
   * @param {Function} [callback] optional callback.
   */
  handleAuthenticate: function(account, callback) {
    if (!account) {
      return console.error('attempting to trigger reauth without an account');
    }

    // only trigger notification the first time there is an error.
    if (!account.error || account.error.count !== 1) {
      return nextTick(callback);
    }

    var lock = navigator.requestWakeLock('cpu');

    var l10n = navigator.mozL10n;
    var title = l10n.get('notification-error-sync-title');
    var description = l10n.get('notification-error-sync-description');

    var url = this.accountErrorUrl + account._id;
    notification.app = this.app;
    notification.sendNotification(title, description, url).then(() => {
      callback && callback();
      lock.unlock();
    });
  }
};

});

define('pending_manager',['require','exports','module'],function(require, exports, module) {


function PendingManager() {
  this.objects = [];
  this.pending = 0;
  this.onstart = this.onstart.bind(this);
  this.onend = this.onend.bind(this);
}
module.exports = PendingManager;

PendingManager.prototype = {
  register: function(object) {
    object.on(object.startEvent, this.onstart);
    object.on(object.completeEvent, this.onend);

    var wasPending = this.isPending();
    this.objects.push(object);
    if (object.pending) {
      this.pending++;

      if (!wasPending) {
        this.onpending && this.onpending();
      }
    }
  },

  /**
   * Unregister an object.
   * Note it is intended that objects that
   * are unregistered are never in a state
   * where we are waiting for their pending
   * status to complete. If an incomplete
   * object is removed it will break .pending.
   */
  unregister: function(object) {
    var idx = this.objects.indexOf(object);
    if (idx !== -1) {
      this.objects.splice(idx, 1);
      return true;
    }

    return false;
  },

  isPending: function() {
    return this.objects.some((object) => {
      return object.pending;
    });
  },

  onstart: function() {
    if (!this.pending) {
      this.onpending && this.onpending();
    }

    this.pending++;
  },

  onend: function() {
    this.pending--;
    if (!this.pending) {
      this.oncomplete && this.oncomplete();
    }
  }
};

});

define('controllers/recurring_events',['require','exports','module','responder','debug','next_tick','provider/provider_factory'],function(require, exports, module) {


var Responder = require('responder');
var debug = require('debug')('controllers/recurring_events');
var nextTick = require('next_tick');
var providerFactory = require('provider/provider_factory');

function RecurringEvents(app) {
  this.app = app;
  this.accounts = app.store('Account');
  Responder.call(this);
}
module.exports = RecurringEvents;

RecurringEvents.prototype = {
  __proto__: Responder.prototype,

  startEvent: 'expandStart',
  completeEvent: 'expandComplete',

  /**
   * Adds N number of days to the window to expand
   * events until. Its very important for this number
   * to be greater then the maximum number of days displayed
   * in the month view (or a view with more days) otherwise
   * the view may be loaded without actually expanding all
   * the visible days.
   *
   * @type Number
   */
  paddingInDays: 85,

  /**
   * Amount of time (in MS) to wait between triggering
   * the recurring event expansions.
   */
  waitBeforeMove: 750,

  /**
   * We need to limit the number of tries on expansions
   * otherwise its possible we never complete during error
   * or long recurring event.
   */
  maximumExpansions: 25,

  /**
   * private timeout (as in setTimeout id) use with waitBeforeMove.
   */
  _moveTimeout: null,

  /**
   * True when queue is running...
   */
  pending: false,

  unobserve: function() {
    this.app.timeController.removeEventListener(
      'monthChange',
      this
    );

    this.app.syncController.removeEventListener(
      'syncComplete',
      this
    );
  },

  observe: function() {
    var time = this.app.timeController;

    // expand initial time this is necessary
    // for cases where user has device off for long periods of time.
    if (time.position) {
      this.queueExpand(time.position);
    }

    // register observers
    time.on('monthChange', this);

    // we must re-expand after sync so events at least
    // expand to the current position....
    this.app.syncController.on('syncComplete', this);
  },

  handleEvent: function(event) {
    switch (event.type) {
      case 'syncComplete':
        this.queueExpand(
          this.app.timeController.position
        );
        break;

      case 'monthChange':
        if (this._moveTimeout !== null) {
          clearTimeout(this._moveTimeout);
          this._moveTimeout = null;
        }

        // trigger the event queue when we move
        this._moveTimeout = setTimeout(
          // data[0] is the new date.
          this.queueExpand.bind(this, event.data[0]),
          this.waitBeforeMove
        );
        break;
    }
  },

  /**
   * Attempts to expand provider until no events require expansion.
   *
   * @param {Date} expandDate expands up to this date.
   * @param {Calendar.Provider.Abstract} provider instance.
   * @param {Function} callback
   *  fired when maximumExpansions is hit or
   *  no more events require expansion.
   *
   */
  _expandProvider: function(expandDate, provider, callback) {
    debug('Will attempt to expand provider until:', expandDate);
    var tries = 0;
    var max = this.maximumExpansions;

    function attemptCompleteExpand() {
      debug('Will try to complete expansion (tries = ' + tries + ')');
      if (tries >= max) {
        return callback(new Error(
          'could not complete expansion after "' + tries + '"'
        ));
      }

      provider.ensureRecurrencesExpanded(expandDate, function(err, didExpand) {
        if (err) {
          return callback(err);
        }

        debug('Expansion attempt did expand:', didExpand);

        if (!didExpand) {
          // successfully expanded and no events need expansion
          // for this date anymore...
          callback();
        } else {
          tries++;
          // attempt another expand without stack.
          nextTick(attemptCompleteExpand);
        }
      });
    }

    attemptCompleteExpand();
  },

  /**
   * Queues an expansion. If the given date is before
   * any dates in the stack it will be discarded.
   */
  queueExpand: function(expandTo) {
    if (this.pending) {
      if (!this._next) {
        this._next = expandTo;
      } else if (expandTo > this._next) {
        this._next = expandTo;
      }
      // don't start the queue if pending...
      return;
    }

    // either way we need to process an event
    // so increment pending for running and non-running cases.
    this.pending = true;
    this.emit('expandStart');

    var self = this;
    function expandNext(date) {
      self.expand(date, function() {
        if (date === self._next) {
          self._next = null;
        }

        var next = self._next;

        // when the queue is empty emit expandComplete
        if (!next) {
          self.pending = false;
          self.emit('expandComplete');
          return;
        }

        expandNext(next);
      });
    }

    expandNext(expandTo);
  },

  /**
   * Ensures we have time converage until the given date.
   * Additional time will be added to the date see .paddingInDays.
   *
   * @param {Date} expandTo date to expand to.
   */
  expand: function(expandTo, callback) {
    debug('expand', expandTo);

    this.accounts.all((err, accounts) => {
      if (err) {
        return callback(err);
      }

      // add minimum padding...
      var expandDate = new Date(expandTo.valueOf());
      expandDate.setDate(expandDate.getDate() + this.paddingInDays);

      var providers = this._getExpandableProviders(accounts);
      var pending = providers.length;

      if (!pending) {
        return nextTick(callback);
      }

      providers.forEach(provider => {
        this._expandProvider(expandDate, provider, () => {
          if (--pending <= 0) {
            callback();
          }
        });
      });
    });
  },

  _getExpandableProviders: function(accounts) {
    var providers = [];
    Object.keys(accounts).forEach(key => {
      var account = accounts[key];
      var provider = providerFactory.get(account.providerType);
      if (provider &&
          provider.canExpandRecurringEvents &&
          providers.indexOf(provider) === -1) {
        providers.push(provider);
      }
    });

    return providers;
  }
};

});

/* jshint loopfunc: true */
define('router',['require','exports','module'],function(require, exports, module) {


var COPY_METHODS = ['start', 'stop', 'show'];

function Router(page) {
  var i = 0;
  var len = COPY_METHODS.length;

  this.page = page;
  this._activeObjects = [];

  for (; i < len; i++) {
    this[COPY_METHODS[i]] = this.page[COPY_METHODS[i]].bind(this.page);
  }

  this._lastState = this._lastState.bind(this);
}
module.exports = Router;

Router.prototype = {

  /**
   * Tells router to manage the object.
   * This will call the 'onactive'
   * method if present on the object.
   *
   * When the route is changed all 'manged'
   * object will be cleared and 'oninactive'
   * will be fired.
   */
  mangeObject: function() {
    var args = Array.prototype.slice.call(arguments);
    var object = args.shift();

    this._activeObjects.push(object);
    // intentionally using 'in'
    if ('onactive' in object) {
      object.onactive.apply(object, args);
    }
  },

  /**
   * Clears active objects, calls oninactive
   * on object if available.
   */
  clearObjects: function() {
    var item;
    while ((item = this._activeObjects.pop())) {
      // intentionally using 'in'
      if ('oninactive' in item) {
        item.oninactive();
      }
    }
  },

  /**
   * This method serves two purposes.
   *
   * 1. to safely end the loop by _not_ calling next.
   * 2. to store the last location.
   *
   * This function is added to the end of every rule.
   */
  _lastState: function(ctx) {
    this.last = ctx;
  },

  resetState: function() {
    if (!this.currentPath) {
      this.currentPath = '/month/';
    }

    this.show(this.currentPath);
  },

  /**
   * Adds a route that represents a state of the page.
   * The theory is that a page can only enter
   * one state at a time (basically yield control to some
   * view or other object).
   *
   * Modifiers can be used to alter the behaviour
   * of a given state (without exiting it)
   *
   * @param {String} path path as defined by page.js.
   * @param {String|Array} one or multiple view identifiers.
   * @param {Object} options (clear, path).
   */
  state: function(path, views, options) {

    options = options || {};
    if (!Array.isArray(views)) {
      views = [views];
    }

    var self = this;
    var viewObjs = [];

    function loadAllViews(ctx, next) {
      var len = views.length;
      var numViews = len;
      var i;

      // Reset our views
      viewObjs = [];

      /*jshint loopfunc: true */
      for (i = 0; i < numViews; i++) {
        self.app.view(views[i], function(view) {
          viewObjs.push(view);
          len--;

          if (!len) {
            next();
          }
        });
      }
    }

    function setPath(ctx, next) {
      // Only set the dataset path after the view has loaded
      // its resources. Otherwise, there is some flash and
      // jank while styles start to apply and the view is only
      // partially loaded.
      if (options.path !== false) {
        document.body.dataset.path = ctx.canonicalPath;
        // Need to trigger the DOM to accept the new style
        // right away. Otherwise, once manageObject is called,
        // any styles/animations it triggers may be delayed
        // or dropped as the browser coalesces style changes
        // into one visible change. Example is the settings
        // drawer animation getting chopped so it is not smooth.
        document.body.clientWidth;
      }
      next();
    }

    function handleViews(ctx, next) {

      // Clear views if needed
      if (options.clear !== false) {
        self.clearObjects();
      }

      // Activate objects
      for (var i = 0; i < viewObjs.length; i++) {
        self.mangeObject(viewObjs[i], ctx);
      }

      // Set the current path
      if (options.appPath !== false) {
        self.currentPath = ctx.canonicalPath;
      }

      next();
    }

    this.page(path, loadAllViews, setPath, handleViews, this._lastState);
  },

  /**
   * Adds a modifier route
   * Modifiers are essentially views, without the currentPath updating
   */
  modifier: function(path, view, options) {
    options = options || {};
    options.appPath = false;
    options.clear = false;
    this.state(path, view, options);
  }
};

});

define('worker/manager',['require','exports','module','responder','debug'],function(require, exports, module) {


var Responder = require('responder');
var debug = require('debug')('worker/manager');

const IDLE_CLEANUP_TIME = 5000;

/**
 * Worker manager. Each worker/thread
 * is assigned one or more roles.
 *
 * There may be one or more workers for
 * each role and there is a contract
 * that assumes all roles are stateless
 * requests/streams are routed to workers
 * and will be completed eventually
 * but without order guarantees.
 */
function Manager() {
  this._lastId = 0;

  Responder.call(this);

  this.roles = Object.create(null);
  this.workers = [];
}
module.exports = Manager;

Manager.prototype = {
  // So that we can mock out Worker API in unit tests...
  Worker: Worker,

  __proto__: Responder.prototype,

  _onLog: debug,

  _formatData: function(data) {
    if (data[1] && data[1].stack && data[1].constructorName) {
      var err = data[1];
      var builtErr;

      if (window[err.constructorName]) {
        builtErr = Object.create(window[err.constructorName].prototype);
      } else {
        builtErr = Object.create(Error.prototype);
      }

      var key;

      for (key in err) {
        if (err.hasOwnProperty(key)) {
          builtErr[key] = err[key];
        }
      }

      data[1] = builtErr;
    }

    return data;
  },

  _onWorkerError: function(worker, err) {
    if (/reference to undefined property/.test(err.message)) {
      // This is a warning spewed out by javascript.options.strict,
      // the worker actually didn't crash at all, so ignore it.
      return;
    }

    if (worker.instance) {
      worker.instance.terminate();
      worker.instance = null;
    }
    var pending = worker.pending;
    worker.pending = Object.create(null);
    for (var id in pending) {
      if (pending[id].stream) {
        pending[id].stream.emit('error', err);
      }
      pending[id].callback(err);
    }
  },

  _onWorkerMessage: function(worker, event) {
    var data = this._formatData(event.data);
    var type = data.shift();
    var match = type.match(/^(\d+) (end|stream)$/);

    if (type == 'log') {
      this._onLog.apply(this, data);

    } else if (match) {
      var pending = worker.pending[match[1]];
      if (pending) {
        this._dispatchMessage(worker, pending, match[2], data);
      } else {
        throw new Error('Message arrived for unknown consumer: ' +
                        type + ' ' + JSON.stringify(data));
      }
    } else {
      this.respond([type].concat(data));
    }
  },

  _dispatchMessage: function(worker, pending, type, data) {
    if (type == 'stream') {
      pending.stream.respond(data);
    } else { // 'end'
      pending.callback.apply(null, data);
      delete worker.pending[pending.id];
      // Bail out if there are other pending requests.
      if (Object.keys(worker.pending).length) {
        return;
      }
      // If none are left, schedule cleanup
      this._scheduleCleanup(worker);
    }
  },

  _addPending: function(worker, pending) {
    worker.pending[pending.id] = pending;
    clearTimeout(worker.cleanup);
  },

  _scheduleCleanup: function(worker) {
    clearTimeout(worker.cleanup);
    worker.cleanup = setTimeout(function() {
      // Ensure we don't have a race condition where someone just
      // added a request but the timeout fired anyway.
      if (Object.keys(worker.pending).length) {
        return;
      }
      if (!worker.instance) {
        return;
      }

      worker.instance.terminate();
      worker.instance = null;
    }, IDLE_CLEANUP_TIME);
  },

  /**
   * Adds a worker to the manager.
   * Worker is associated with one or
   * more roles. Workers are assumed
   * stateless.
   *
   *
   * @param {String|Array} role one or more roles.
   * @param {String} worker url.
   */
  add: function(role, workerURL) {
    debug('Will add', role, 'worker at', workerURL);
    var worker = {
      // Actual Worker instance, when active
      instance: null,
      // Handlers that are waiting for a response from this worker
      pending: Object.create(null),
      // Script URL
      url: workerURL,
      // Timeout set to disable the worker when it hasn't been used
      // for a given period of time
      cleanup: null
    };

    this.workers.push(worker);
    [].concat(role).forEach(function(role) {
      if (!(role in this.roles)) {
        this.roles[role] = [worker];
      } else {
        this.roles[role].push(worker);
      }
    }, this);
  },

  _ensureActiveWorker: function(role) {
    if (role in this.roles) {
      var workers = this.roles[role];
      var worker = workers[Math.floor(Math.random() * workers.length)];
      if (worker.instance) {
        return worker;
      } else {
        this._startWorker(worker);
        return worker;
      }
    } else {
      throw new Error('no worker with role "' + role + '" active');
    }
  },

  _startWorker: function(worker) {
    worker.instance = new this.Worker(
      // ?time= is for cache busting in development...
      // there have been cases where nightly would not
      // clear the cache of the worker.
      worker.url + '?time=' + Date.now()
    );

    worker.instance.onerror = this._onWorkerError.bind(this, worker);
    worker.instance.onmessage = this._onWorkerMessage.bind(this, worker);
    this._scheduleCleanup(worker);
  },

  request: function(role /*, args..., callback*/) {
    var args = Array.prototype.slice.call(arguments, 1);
    var callback = args.pop();
    var worker = null;

    try {
      worker = this._ensureActiveWorker(role);
    } catch (e) {
      callback(e);
      return;
    }

    var data = {
      id: this._lastId++,
      role: role,
      payload: args
    };

    this._addPending(worker, {
      id: data.id,
      callback: callback
    });

    worker.instance.postMessage(['_dispatch', data]);
  },

  stream: function(role /*, args...*/) {
    var args = Array.prototype.slice.call(arguments, 1);
    var stream = new Responder();
    var self = this;

    var data = {
      id: this._lastId++,
      role: role,
      payload: args,
      type: 'stream'
    };

    stream.request = function(callback) {
      var worker = null;

      stream.request = function() {
        throw new Error('stream request has been sent');
      };

      try {
        worker = self._ensureActiveWorker(role);
      } catch (e) {
        callback(e);
        return;
      }

      self._addPending(worker, {
        id: data.id,
        stream: stream,
        callback: callback
      });
      worker.instance.postMessage(['_dispatch', data]);
    };
    return stream;
  }
};

});

define('controllers/service',['require','exports','module','worker/manager','debug'],function(require, exports, module) {


var Manager = require('worker/manager');
var debug = require('debug')('controllers/service');

function Service() {
  Manager.call(this);
}
module.exports = Service;

Service.prototype = {
  __proto__: Manager.prototype,

  start: function() {
    debug('Will load and initialize worker...');
    this.add('caldav', '/js/caldav_worker.js');
  }
};

});

define('controllers/sync',['require','exports','module','responder'],function(require, exports, module) {


var Responder = require('responder');

/**
 * Handles all synchronization related
 * tasks. The intent is that this will
 * be the focal point for any view
 * to observe sync events and this
 * controller will decide when to actually
 * tell the stores when to sync.
 */
function Sync(app) {
  this.app = app;
  this.pending = 0;

  Responder.call(this);
}
module.exports = Sync;

Sync.prototype = {
  __proto__: Responder.prototype,

  startEvent: 'syncStart',
  completeEvent: 'syncComplete',

  _incrementPending: function() {
    if (!this.pending) {
      this.emit('syncStart');
    }

    this.pending++;
  },

  _resolvePending: function() {
    if (!(--this.pending)) {
      this.emit('syncComplete');
    }

    if (this.pending < 0) {
      dump('\n\n Error calendar sync .pending is < 0 \n\n');
    }
  },

  /**
   * Sync all accounts, calendars, events.
   * There is no callback for all intentionally.
   *
   * Use:
   *
   *    controller.once('syncComplete', cb);
   *
   */
  all: function(callback) {
    // this is for backwards compatibility... in reality we should remove
    // callbacks from .all.
    if (callback) {
      this.once('syncComplete', callback);
    }

    if (this.app.offline()) {
      this.emit('offline');
      this.emit('syncComplete');
      return;
    }

    var account = this.app.store('Account');

    account.all(function(err, list) {

      for (var key in list) {
        this.account(list[key]);
      }

      // If we have nothing to sync
      if (!this.pending) {
        this.emit('syncComplete');
      }

    }.bind(this));
 },

  /**
   * Initiates a sync for a single calendar.
   *
   * @param {Object} account parent of calendar.
   * @param {Object} calendar specific calendar to sync.
   * @param {Function} [callback] optional callback.
   */
  calendar: function(account, calendar, callback) {
    var store = this.app.store('Calendar');
    var self = this;

    this._incrementPending();
    store.sync(account, calendar, err => {
      self._resolvePending();
      this.handleError(err, callback);
    });
  },

  /**
   * Initiates a sync of a single account and all
   * associated calendars (calendars that exist after
   * the full sync of the account itself).
   *
   * The contract is if an callback is given the callback MUST handle the
   * error given. The default behaviour is to bubble up the error up to the
   * error controller.
   *
   * @param {Object} account sync target.
   * @param {Function} [callback] optional callback.
  */
  account: function(account, callback) {
    var accountStore = this.app.store('Account');
    var calendarStore = this.app.store('Calendar');

    var self = this;

    this._incrementPending();
    accountStore.sync(account, err => {
      if (err) {
        self._resolvePending();
        return this.handleError(err, callback);
      }

      var pending = 0;
      function next() {
        if (!(--pending)) {
          self._resolvePending();

          if (callback) {
            callback();
          }
        }
      }

      function fetchCalendars(err, calendars) {
        if (err) {
          self._resolvePending();
          return self.handleError(err, callback);
        }

        for (var key in calendars) {
          pending++;
          self.calendar(account, calendars[key], next);
        }
      }

      // find all calendars
      calendarStore.remotesByAccount(
        account._id,
        fetchCalendars
      );
    });
  },

  /**
   * Private helper for choosing how to dispatch errors.
   * When given a callback the callback will be called otherwise the error
   * controller will be invoked.
   */
  handleError: function(err, callback) {
    if (callback) {
      return callback(err);
    }

    this.app.errorController.dispatch(err);
  }
};

});

/**
 * The interval tree is a structure
 * designed and optimized for storing
 * (possibly) overlapping intervals in
 * such a way that we can optimally query them.
 *
 * To store an item in the tree the item
 * must have `START`, `END` and `_id` properties
 * both properties must be numeric and start
 * must always be < then end. ID should be unique
 * to each interval though it should be possible
 * to store multiple intervals with the same
 * start/end times.
 *
 * Trees should be created by providing an
 * array of items sorted by their start
 * times.
 *
 *
 *    // _start is a constant see below
 *    var list = [
 *      { start: 100, end: 200 },
 *      { start: 120, end: 150 },
 *      ...
 *    ];
 *
 *    var tree = new Calendar.Node(list);
 *
 *
 * The tree _should-be_ dynamic and you can add and
 * remove items from the tree.
 *
 * For the present the tree will rebuild itself
 * after add/removal before the next query operation.
 *
 *
 *    tree.add({ start: 0, end: 50 });
 *
 *    // record should be === to record
 *    // stored in the tree.
 *    tree.remove(savedRecord);
 *
 *
 * TODO: Implement self-balancing and real tree mutations.
 */
define('interval_tree',['require','exports','module','binsearch','compare','debug'],function(require, exports, module) {


var binsearch = require('binsearch');
var compare = require('compare');
var debug = require('debug')('interval_tree');

const START = '_startDateMS';
const END = '_endDateMS';

function compareObjectStart(a, b) {
  return compare(a[START], b[START]);
}

function compareObjectEnd(a, b) {
  return compare(a[END], b[END]);
}

IntervalTree.compareObjectStart = compareObjectStart;
IntervalTree.compareObjectEnd = compareObjectEnd;

/**
 * Internal function to create an endpoint
 * list. Assumed this is the array to insert
 * endpoint values into.
 *
 * @param {Object} item object with [START] & [END] properties.
 */
function buildEndpoints(item) {
  /*jshint validthis:true */
  addOrdered(item[START], this);
  addOrdered(item[END], this);
}

function Node() {
  this.list = [];
}

Node.prototype = {

  /**
   * Node to the left null or a node.
   */
  left: null,

  /**
   * Node to the right null or a node.
   */
  right: null,

  /**
   * List of objects that overlap current node.
   *
   * @type Array
   */
  list: null,

  /**
   * Center point of this node.
   */
  median: null,

  /**
   * Highest value of this node & subnodes.
   */
  max: null,

  /**
   * Iterates through matching items.
   * Will be roughly ordered by start
   * time but exact sort order is not
   * guaranteed.
   *
   * @param {Calendar.Timespan} span timespan.
   * @param {Function} callback first argument is matching
   *                            record second is the node in the
   *                            tree where record was found.
   */
  traverse: function(span, fn) {
    if (this.left && (span.start < this.median)) {
      this.left.traverse(span, fn);
    }

    var i = 0;
    var len = this.list.length;
    var item;

    for (; i < len; i++) {
      item = this.list[i];

      if (item[START] > span.end) {
        break;
      }

      if (span.overlaps(item[START], item[END])) {
        fn(item, this);
      }
    }

    if (this.right && span.end > this.median) {
      this.right.traverse(span, fn);
    }
  },

  /**
   * Find all overlapping records via a Calendar.Timespan.
   *
   * @param {Calendar.Timespan} span timespan.
   * @return {Array} results sorted by start time.
   */
  query: function(span) {
    var results = [];
    var seen = Object.create(null);

    this.traverse(span, function(item) {
      ///XXX: we probably want to order
      // these by start time via bin search
      // order by sort at the end.
      if (!seen[item._id]) {
        results.push(item);
      }
    });

    return results;
  }

};

IntervalTree.Node = Node;

/**
 * Start point for creation of the tree
 * this is optimized for the most balanced tree
 * when possible. The idea is the majority of
 * operations will be read and traversal.
 *
 * NOTE: Currently we discard the tree and
 * mark the object as synced=false after mutations
 * The next time the object is queried the tree is rebuilt.
 */
function IntervalTree(list) {
  if (typeof(list) === 'undefined') {
    this.items = [];
  } else {
    this.items = list.concat([]);
  }

  /**
   * Properties to index by when fields are added.
   */
  this._indexes = Object.create(null);

  // method aggregates
  this._indexOnAdd = [];
  this._indexOnRemove = [];

  this.byId = Object.create(null);
  this.synced = false;
}
module.exports = IntervalTree;

IntervalTree.prototype = {

  START: START,
  END: END,

  build: function() {
    if (!this.synced) {
      this.rootNode = this._nodeFromList(this.items);
      this.synced = true;
    }
  },

  toArray: function() {
    // create a copy of the items array
    return this.items.concat();
  },

  _getId: function(item) {
    return item._id;
  },

  /**
   * Returns all values in the given index.
   *
   * @param {String} property name of index.
   * @param {String} [value] to filter index on (optional).
   * @return {Null|Array}
   */
  index: function(property, value) {
    var items = this._indexes[property];

    if (items && value) {
      return items[value];
    }

    return items;
  },

  /**
   * Create index on property.
   *
   * @param {String} property to index on.
   */
  createIndex: function(property) {
    var index = this._indexes[property] = {};

    // remember this will be invoked later with the context
    // of |this| always...
    function addToIndex(object) {
      var value = object[property];

      // create array for index possibilities
      if (!index[value]) {
        index[value] = [];
      }

      // and push single object to index
      index[value].push(object);
    }

    function removeFromIndex(object) {
      // object given should always be same instance stored.
      var value = object[property];
      var valueGroup = index[value];

      if (valueGroup) {
        var idx = valueGroup.indexOf(object);
        valueGroup.splice(idx, 1);
        if (valueGroup.length === 0) {
          delete index[value];
        }
      }
    }

    this._indexOnAdd.push(addToIndex);
    this._indexOnRemove.push(removeFromIndex);
  },

  /**
   * Adds an item to the tree
   */
  add: function(item) {
    var id = this._getId(item);

    if (id in this.byId) {
      return;
    }


    if (!item[START] && item.startDate) {
      item[START] = item.startDate.valueOf();
    }

    if (!item[END] && item.endDate) {
      item[END] = item.endDate.valueOf();
    }

    if (!item[START] || !item[END]) {
      return debug('Invalid input skipping record: ', item);
    }

    var idx = binsearch.insert(
      this.items,
      item,
      compareObjectStart
    );

    this.items.splice(idx, 0, item);
    this.byId[id] = item;
    this.synced = false;

    var len = this._indexOnAdd.length;
    for (var i = 0; i < len; i++) {
      this._indexOnAdd[i].call(this, item);
    }

    return item;
  },

  indexOf: function(item) {
    var query = {};
    query[START] = item[START];
    var idx = binsearch.find(
      this.items,
      query,
      compareObjectStart
    );

    var prevIdx;
    var current;

    if (idx !== null) {
      // we want to start idx at earliest
      // point in list that matches start time.
      // When there are multiple start times
      // the binsearch may start us at any point
      // in the range of matching items.


      // Iterate backwards.
      if (idx > 0) {
        prevIdx = idx;
        while (prevIdx > -1) {
          prevIdx--;
          current = this.items[prevIdx];
          if (current && current[START] === item[START]) {
            if (current === item) {
              return prevIdx;
            }
          } else {
            break;
          }
        }
      }

      //Iterate forwards.
      current = this.items[idx];
      while (current) {
        if (current === item) {
          return idx;
        }

        current = this.items[++idx];

        if (!current || current[START] !== item[START]) {
          return null;
        }
      }
    }

    return null;
  },

  /**
   * Removes an item to the list.
   * Must be same === item as as the
   * one you are trying to remove.
   */
  remove: function(item) {

    var idx = this.indexOf(item);

    if (idx !== null) {
      this._removeIds(this.items[idx]);

      this.items.splice(idx, 1);
      this.synced = false;
      return true;
    }

    return false;
  },

  _removeIds: function(item) {
    if (Array.isArray(item)) {
      item.forEach(this._removeIds, this);
    } else {
      var len = this._indexOnRemove.length;
      for (var i = 0; i < len; i++) {
        this._indexOnRemove[i].call(this, item);
      }

      var id = this._getId(item);
      delete this.byId[id];
    }
  },

  /**
   * Remove all intervals that start
   * after a particular time.
   *
   *    // assume we have a list of the
   *    // following intervals
   *    1-2 4-10 5-10 6-8 8-9
   *
   *    tree.removeFutureIntervals(5);
   *
   *    // now we have: 1-2, 4-10 5-10
   *
   * @param {Numeric} start last start point.
   */
  removeFutureIntervals: function(start) {
    var query = {};
    query[START] = start;

    var idx = binsearch.insert(
      this.items,
      query,
      compareObjectStart
    );

    var max = this.items.length - 1;

    if (!this.items[idx]) {
      return;
    }


    // for duplicate values we need
    // to find the very last one
    // before the split point.
    while (this.items[idx] && this.items[idx][START] <= start) {
      idx++;
      if (idx === max) {
        break;
      }
    }

    this.synced = false;
    var remove = this.items.splice(
      idx, this.items.length - idx
    );

    this._removeIds(remove);
    return remove;
  },

  /**
   * Remove all intervals that end
   * before a particular time.
   *
   * For example is you have:
   *
   *    // assume we have a list of the
   *    // following intervals
   *    1-10, 2-3, 3-4, 4-5
   *
   *    tree.removePastIntervals(4);
   *
   *    // now we have: 1-10, 4-5
   *
   * @param {Numeric} end last end point.
   */
  removePastIntervals: function(end) {
    // 1. first re-sort to end dates.
    var items = this.items.sort(compareObjectEnd);

    // 2. find index of the last date ending
    // on or before end.
    var endQuery = {};
    endQuery[END] = end;
    var idx = binsearch.insert(
      items,
      endQuery,
      compareObjectEnd
    );

    var max = items.length - 1;

    if (!items[idx]) {
      return;
    }

    // for duplicate values we need
    // to find the very last one
    // before the split point.
    while (items[idx][END] <= end) {
      idx++;
      if (idx === max) {
        break;
      }
    }

    this.synced = false;
    var remove = items.slice(0, idx);
    this.items = items.slice(idx).sort(
      compareObjectStart
    );

    this._removeIds(remove);

    return remove;
  },

  /**
   * Executes a query on all nodes.
   * Rebuilds tree if in unclean state first.
   *
   * @param {Calendar.Timespan} span timespan.
   */
  query: function(span) {
    this.build();
    return this.rootNode.query(span);
  },

  _nodeFromList: function(list) {
    var rootNode = new Node();

    var left = [];
    var right = [];

    var median;
    var endpoints = [];

    //1. build endpoints to calculate median
    //   endpoints are the middle value of
    //   all start/end points in the current list.
    list.forEach(buildEndpoints, endpoints);
    median = rootNode.median = endpoints[Math.floor(endpoints.length / 2)];

    list.forEach(function(item) {

      if (item[END] < median) {
        left.push(item);
      } else if (item[START] > median) {
        right.push(item);
      } else {
        rootNode.list.push(item);
      }
    }, this);

    // recurse - create left/right nodes.
    if (left.length) {
      rootNode.left = this._nodeFromList(left);
    }

    if (right.length) {
      rootNode.right = this._nodeFromList(right);
    }

    return rootNode;
  }
};

/**
 * Internal function to add an item
 * to an array via binary search insert.
 * Keeps items in order as they are inserted.
 *
 * @private
 */
function addOrdered(item, array) {
  var idx = binsearch.insert(
    array,
    item,
    compare
  );

  array.splice(idx, 0, item);
}

});

define('controllers/time',['require','exports','module','calc','interval_tree','responder','time_observer','binsearch','compare'],function(require, exports, module) {


var Calc = require('calc');
var IntervalTree = require('interval_tree');
var Responder = require('responder');
var TimeObserver = require('time_observer');
var binsearch = require('binsearch');
var compare = require('compare');

function compareStart(a, b) {
  return compare(a.start, b.start);
}

function Time(app) {
  this.app = app;
  Responder.call(this);
  TimeObserver.call(this);

  this._timeCache = Object.create(null);

  /** cache of all loaded events */
  this._eventsCache = Object.create(null);

  this._timespans = [];
  this._collection = new IntervalTree();
  this._collection.createIndex('eventId');

  this.busytime = app.store('Busytime');
  this.calendarStore = app.store('Calendar');
}
module.exports = Time;

Time.prototype = {
  __proto__: Responder.prototype,

  /**
   * Current position in time.
   * Includes year, month and day.
   *
   * @type {Date}
   */
  _position: null,

  /**
   * Current center point of cached
   * time spans. This is not the last
   * loaded timespan but the last
   * requested timespan.
   *
   * @type {Calendar.Timespan}
   */
  _currentTimespan: null,

  /**
   * Hash that contains
   * the pieces of the current _position.
   * (month, day, year)
   */
  _timeCache: null,

  /**
   * Array of the currently cached
   * timespans. Should never be directly
   * referenced and it should be noted
   * that this array will be replaced
   * over time.
   *
   * @type {Array}
   */
  _timespans: null,

  /**
   * Maximum number of timespans
   * to keep cached over time.
   *
   * @type {Numeric}
   */
  _maxTimespans: 6,

  /**
   * Number of pending load operations.
   */
  pending: 0,

  /**
   * The time 'scale' of the current
   * state of the calendar.
   *
   * Usually one of: ['day', 'month', 'week']
   * @type {String}
   */
  _scale: null,

  /**
   * private state of mostRecentDayType
   */
  _mostRecentDayType: 'day',

  /**
   * When true will lock the cache so no records are
   * purged. This is critical during sync because some
   * records may not yet be in the database.
   */
  cacheLocked: false,

  /**
   * Returns the most recently changed
   * day type either 'day' or 'selectedDay'
   */
  get mostRecentDayType() {
    return this._mostRecentDayType;
  },

  get mostRecentDay() {
    if (this.mostRecentDayType === 'selectedDay') {
      return this.selectedDay;
    } else {
      return this.position;
    }
  },

  get timespan() {
    return this._currentTimespan;
  },

  get scale() {
    return this._scale;
  },

  set scale(value) {
    var oldValue = this._scale;
    if (value !== oldValue) {
      this._scale = value;
      this.emit('scaleChange', value, oldValue);
    }
  },

  get selectedDay() {
    return this._selectedDay;
  },

  set selectedDay(value) {
    var day = this._selectedDay;
    this._mostRecentDayType = 'selectedDay';
    if (!day || !Calc.isSameDate(day, value)) {
      this._selectedDay = value;
      this.emit('selectedDayChange', value, day);
    }
  },

  direction: 'future',

  observe: function() {
    // handle when we change months
    this.on(
      'monthChange',
      this._loadMonthSpan.bind(this)
    );

    // handle cache pause/resume
    var sync = this.app.syncController;
    sync.on('syncStart', this);
    sync.on('syncComplete', this);

    // XXX: case that the event name is so generic
    //      we handle it here directly.
    var self = this;
    this.busytime.on('remove', function(id) {
      self.removeCachedBusytime(id);
    });
    this.calendarStore.on(
      'calendarVisibilityChange',
      this._notifyVisibilityChange.bind(this)
    );
  },

  /**
   * Helper function to 'move' state of calendar
   * to the most recently modified day type.
   *
   * (in the case where selectedDay was changed after day)
   */
  moveToMostRecentDay: function() {
    if (this.mostRecentDayType === 'selectedDay') {
      this.move(this.selectedDay);
    }
  },

  _updateCache: function(type, value) {
    var old = this._timeCache[type];

    if (!old || !Calc.isSameDate(value, old)) {
      this._timeCache[type] = value;
      this.emit(type + 'Change', value, old);
    }
  },

  /**
   * Initiate a purge request.
   * Will remove all cached events and
   * remove busytimes outside of the
   * cached span.
   */
  purgeCache: function() {
    if (this.cacheLocked) {
      return;
    }

    this._updateBusytimeCache();
    this._eventsCache = Object.create(null);
  },

  _updateBusytimeCache: function() {
    var dir = this.direction;
    var spans = this._timespans;
    var len = spans.length;
    var max = this._maxTimespans;

    if (len > max) {
      var idx = binsearch.find(
        spans,
        this._currentTimespan,
        compareStart
      );

      var isFuture = (dir === 'future');
      var start = idx;

      // _maxTimespans is the total number of
      // timespans we wish to keep in memory
      // when the limit is hit we want to discard
      // extra but have _maxTimespans in length
      if (isFuture) {
        start = (idx - 1);
        if ((start + max) > len) {
          start = start - ((start + max) - len);
        }
      } else {
        start = (idx - max) + 1;
      }

      if (start < 0) {
        start = 0;
      }

      // reduce the current list to just what we need
      this._timespans = spans.splice(start, this._maxTimespans);

      // Once we have reduced the number of timespans
      // we also need purge unused busytimes from the cache.
      // Find the outer limits of the overal timespan
      // and purge anything that occurs before or after.
      //
      // NOTE: this will _not_ negatively effect long running
      // events we take care to only remove busytimes well before
      // or after the overall timespan.
      var startPoint = this._timespans[0].start;
      var endPoint = this._timespans[this._timespans.length - 1].end;

      this._collection.removePastIntervals(startPoint);
      this._collection.removeFutureIntervals(endPoint);

      spans.forEach(function(range) {
        // notify views that we have removed
        // these timespans. Views should remove
        // dom elements associated with these
        // ranges. Other controllers could possibly
        // listen to this event and do other kinds
        // of cleanup as well.
        this.emit(
          'purge', range
        );
      }, this);
    }
  },

  /**
   * Adds loaded spans to the cache.
   *
   * When we are finished loading
   * emit the 'loadingComplete' event.
   *
   * @param {Error|Null} err error object.
   * @param {Array[Object]} records list of busytimes.
   */
  _onLoadingComplete: function(err, records) {
    records.forEach(this.cacheBusytime, this);

    if (!(--this.pending)) {
      // Keep the busytime cache healthy
      // and not too full or empty.
      // To avoid race conditions and
      // too frequent checking of the
      // status of the cache we only
      // do this when all loading is complete
      // and the user is not actively paging
      // through. This happens more often
      // then you might think as the
      // only reason we load a new span
      // is when we completely change
      // the month.
      this.purgeCache();
      this.emit('loadingComplete');
    }
  },

  _recordSpanChange: function(span) {
    var spans = this._timespans;
    var loadSpan = span;

    // Check if timespan already exists
    // every start time should be unique
    // so if we find another span with the
    // same start time it should cover
    // the same span.
    var idx = binsearch.find(
      spans,
      span,
      compareStart
    );

    // if a perfect match is found stop,
    // we probably have loaded this span.
    if (idx !== null) {
      return;
    }

    // find best position for new span
    idx = binsearch.insert(
      spans,
      span,
      compareStart
    );

    // insert it keep all spans ordered
    // by start time.
    spans.splice(idx, 0, span);

    // While we want to keep all a record of all
    // timespans in a uniform sorted manner we do
    // not want to load the same set of busytimes.
    // We trim the overlapping periods so to only
    // load what we need now.

    //NOTE: this trim logic will cause missed
    //events unless this is the sole method
    //of adding items to spans.

    // 1. lower bound trim
    if (spans[idx - 1]) {
      loadSpan = spans[idx - 1].trimOverlap(loadSpan);
    }

    // 2. upper bound trim
    if (spans[idx + 1]) {
      loadSpan = spans[idx + 1].trimOverlap(loadSpan);
    }

    // On the odd chance that one span
    // completely contains the other play
    // it safe and load it anyway.
    loadSpan = loadSpan || span;

    ++this.pending;

    // Actually request spans.
    this.busytime.loadSpan(
      loadSpan,
      this._onLoadingComplete.bind(this)
    );
  },

  /**
   * Loads the initial timespans
   * required for user to interact with
   * the calendar based on a start
   * date. This is called on the first
   * move of the calendar.
   *
   * Loads spans in the follow order:
   *
   * 1. current month
   * 2. next month
   * 3. past month
   *
   * @param {Date} date start point of busytimes to load.
   *                    Expected to be the first of a given
   *                    month.
   *
   * @param {Calendar.Timespan} presentSpan center point
   *                                        of timespan.
   */
  _loadAroundSpan: function(date, presentSpan) {
    var getSpan = Calc.spanOfMonth;

    var pastSpan = getSpan(new Date(
      date.getFullYear(),
      date.getMonth() - 1,
      1
    ));

    var futureSpan = getSpan(
       new Date(
        date.getFullYear(),
        date.getMonth() + 1,
        1
      )
    );

    // order is important
    // we want to load the busytimes
    // in order of importance to the users:
    // 1. current span.
    // 2. next span
    // 3. previous span.
    this._recordSpanChange(presentSpan);
    this._recordSpanChange(futureSpan);
    this._recordSpanChange(pastSpan);
  },

  /**
   * Loads a span of a month.
   * Each time this method is called
   * the same timespan will be generated.
   */
  _loadMonthSpan: function(date) {
    var spanOfMonth = Calc.spanOfMonth;
    this._currentTimespan = spanOfMonth(date);

    var currentIdx = binsearch.find(
      this._timespans,
      this._currentTimespan,
      compareStart
    );

    // When given date's month span is not found
    // trigger a load of that span and the ones
    // around it.
    if (currentIdx === null) {
      return this._loadAroundSpan(date, this._currentTimespan);
    }

    // determine which direction we need load.
    var month = date.getMonth();
    var isFuture = this.direction === 'future';

    // Based on the direction we are
    // going we want to preload additional spans
    if (isFuture) {
      month += 1;
    } else {
      month -= 1;
    }

    var monthSpan = spanOfMonth(
      new Date(
        date.getFullYear(),
        month,
        1
      )
    );

    return this._recordSpanChange(monthSpan);
  },

  handleEvent: function(event) {
    switch (event.type) {
      case 'syncStart':
        this.cacheLocked = true;
        break;
      case 'syncComplete':
        this.cacheLocked = false;
        this.purgeCache();
        break;
    }
  },

  get month() {
    return this._timeCache.month;
  },

  get day() {
    return this._timeCache.day;
  },

  get year() {
    return this._timeCache.year;
  },

  get position() {
    return this._position;
  },

  _notifyVisibilityChange: function(calendarId, calendar) {
    // we can't really remove items from the cache (otherwise we wouldn't be
    // able to re-add them later) so we just dispatch the add/remove events
    // which will be enough to rebuild the views
    var eventType = calendar.localDisplayed ? 'add' : 'remove';

    // we need to notify all the cached timespans, not just the current one
    this._collection.toArray().forEach(busy => {
      if (busy.calendarId === calendarId) {
        this.fireTimeEvent(eventType, busy.startDate, busy.endDate, busy);
      }
    });
  },

  /**
   * Queries busytimes cache by timespan.
   * Only retuns busytimes from enabled calendars.
   *
   * @param {Calendar.Timespan} timespan query range.
   * @return {Array} busytimes ordered by start date.
   */
  queryCache: function(timespan) {
    var busytimes = this._collection.query(timespan);
    return busytimes.filter(this._shouldDisplayBusytime, this);
  },

  _shouldDisplayBusytime: function(busytime) {
    return this.calendarStore.shouldDisplayCalendar(busytime.calendarId);
  },

  /**
   * Adds a busytime to the collection.
   * Emits a 'add' time event when called (if calendar is enabled).
   *
   * @param {Object} busytime instance to add to the collection.
   */
  cacheBusytime: function(busytime) {
    var start = busytime.startDate;
    var end = busytime.endDate;

    this._collection.add(busytime);

    if (this._shouldDisplayBusytime(busytime)) {
      this.fireTimeEvent('add', start, end, busytime);
    }
  },

  /**
   * Removes a busytime from the collection.
   * Emits a 'remove' time event when called (if calendar is enabled).
   *
   * @param {String} id busytime id.
   */
  removeCachedBusytime: function(id) {
    var collection = this._collection;

    if (id in collection.byId) {
      var busytime = collection.byId[id];
      var start = busytime.startDate;
      var end = busytime.endDate;

      collection.remove(busytime);

      if (this._shouldDisplayBusytime(busytime)) {
        this.fireTimeEvent('remove', start, end, busytime);
      }
    }
  },

  /**
   * Adds a single event to the cache.
   *
   * @param {Object} event object to cache.
   */
  cacheEvent: function(event) {
    this._eventsCache[event._id] = event;
  },

  /**
   * Remove a single event from the cache by its id.
   * Also will clear any associated busytime record.
   *
   * @param {String} id of object to remove from cache.
   */
  removeCachedEvent: function(id) {
    // purge any busytimes related to this event
    var busytimes = this._collection.index('eventId', id);
    if (busytimes) {
      busytimes.forEach(function(busytime) {
        this.removeCachedBusytime(busytime._id);
      }, this);
    }

    // remove event details
    delete this._eventsCache[id];
  },

  /**
   * Requests associated records for one or more busytimes.
   *
   * Options:
   *
   *  event: (Boolean) when true returns associated event. (default true).
   *  alarm: (Boolean) when true returns the associated alarm.
   *
   * Returns:
   *
   *    [
   *      { busytime: inputBusytime, event: event, alarm: alarm },
   *      ...
   *    ]
   *
   * @param {Array[Object]|Object} busytime one or more busytimes.
   * @param {Object} options see above.
   * @param {Function} cb node style [err, (see returns above)].
   */
  findAssociated: function(busytimes, options, cb) {
    if (typeof(options) === 'function') {
      cb = options;
      options = null;
    }

    var getEvent = true;
    var getAlarms = false;

    busytimes = (Array.isArray(busytimes)) ? busytimes : [busytimes];

    if (options && ('alarms' in options)) {
      getAlarms = options.alarms;
    }

    if (options && ('event' in options)) {
      getEvent = options.event;
    }

    var eventStore = this.app.store('Event');
    var alarmStore = this.app.store('Alarm');
    var list = [];

    // this is a readonly transaction so we can add busytimes
    // here even though we may not use it later...
    var stores = ['busytimes'];

    if (getAlarms) {
      stores.push('alarms');
    }

    if (getEvent) {
      stores.push('events');
    }

    var trans = eventStore.db.transaction(stores);

    trans.addEventListener('error', cb);

    // we use pending instead of transaction 'complete'
    // to better handle caching.
    var pending = 0;

    function next() {
      if (!(--pending)) {
        cb(null, list);
      }
    }

    var self = this;

    /**
     * Fetch records for a given busytime.
     *
     * @param {Object} busytime object.
     * @param {Numeric} idx where to put item in array.
     */
    function fetchRecords(busytime, idx) {
      var result = { busytime: busytime };
      list[idx] = result;

      if (getAlarms) {
        pending++;
        // its possible for more then one alarm to be present
        // for a given busytime. We are not supporting that right
        // now but in the future we may need to modify this to
        // return an array of alarms.
        alarmStore.findAllByBusytimeId(busytime._id, trans,
                                    function(err, alarm) {

          // unlike events we probably never want to cache alarms.
          if (alarm) {
            result.alarms = alarm;
          }
          next();
        });
      }

      if (getEvent) {
        var eventId = busytime.eventId;

        if (eventId in self._eventsCache) {
          result.event = self._eventsCache[eventId];
        } else {
          pending++;
          eventStore.get(eventId, trans, function(err, event) {
            if (event) {
              self._eventsCache[eventId] = event;
              result.event = event;
            }
            next();
          });
        }
      }
    }

    function fetchBusytime(id, idx, err, record) {
      if (!record || err) {
        console.error('Error finding busytime', id, err);
        return next();
      }

      // cache the busytime when it is not found...
      // Even if the busytime is _way_ out of range later
      // we still will clean it up when we get far enough
      // out of its starting time...
      self.cacheBusytime(record);

      fetchRecords(record, idx);

      // next will decrement the pending counter and return
      // if there are no more pending items... We must call
      // this here to avoid race conditions in the case where
      // all but one busytime is uncached (which is common).
      next();
    }

    // using forEach for scoping
    // XXX: this is a hot code path needs some optimization.
    busytimes.forEach(function(busytime, idx) {
      if (typeof(busytime) === 'string') {

        var record = this._collection.byId[busytime];

        if (!record) {
          console.error('Cannot find busytime by id: ', busytime);

          // why pending++ ? we must add a pending item to our
          // counter otherwise the loop may close and return prior
          // to the busytime being fetched... later we decrement the
          // counter in fetchBusytime.
          pending++;
          return this.busytime.get(
            busytime,
            trans,
            fetchBusytime.bind(this, busytime, idx)
          );
        }

        busytime = this._collection.byId[busytime];
      }

      fetchRecords(busytime, idx);

    }, this);

    // this handles the case where there
    // where no pending records at all.
    if (!pending && cb) {
      cb(null, list);
    }
  },

  /**
   * Sets position of controller
   * in time.
   *
   * @param {Date} date position to move to.
   */
  move: function(date) {
    var year = date.getFullYear();
    var month = date.getMonth();
    var yearDate = new Date(year, 0, 1);
    var monthDate = new Date(year, month, 1);

    var oldPosition = this._position;
    this._position = date;

    if (oldPosition) {
      if (oldPosition < date) {
        this.direction = 'future';
      } else if (oldPosition > date) {
        this.direction = 'past';
      } else {
        this.direction = 'future';
      }
    }

    this._mostRecentDayType = 'day';

    this._updateCache('year', yearDate);
    this._updateCache('month', monthDate);
    this._updateCache('day', date);
  }
};
TimeObserver.enhance(Time.prototype);

});

/*!
 * EventEmitter2
 * https://github.com/hij1nx/EventEmitter2
 *
 * Copyright (c) 2013 hij1nx
 * Licensed under the MIT license.
 */
;!function(undefined) {

  var isArray = Array.isArray ? Array.isArray : function _isArray(obj) {
    return Object.prototype.toString.call(obj) === "[object Array]";
  };
  var defaultMaxListeners = 10;

  function init() {
    this._events = {};
    if (this._conf) {
      configure.call(this, this._conf);
    }
  }

  function configure(conf) {
    if (conf) {

      this._conf = conf;

      conf.delimiter && (this.delimiter = conf.delimiter);
      conf.maxListeners && (this._events.maxListeners = conf.maxListeners);
      conf.wildcard && (this.wildcard = conf.wildcard);
      conf.newListener && (this.newListener = conf.newListener);

      if (this.wildcard) {
        this.listenerTree = {};
      }
    }
  }

  function EventEmitter(conf) {
    this._events = {};
    this.newListener = false;
    configure.call(this, conf);
  }

  //
  // Attention, function return type now is array, always !
  // It has zero elements if no any matches found and one or more
  // elements (leafs) if there are matches
  //
  function searchListenerTree(handlers, type, tree, i) {
    if (!tree) {
      return [];
    }
    var listeners=[], leaf, len, branch, xTree, xxTree, isolatedBranch, endReached,
        typeLength = type.length, currentType = type[i], nextType = type[i+1];
    if (i === typeLength && tree._listeners) {
      //
      // If at the end of the event(s) list and the tree has listeners
      // invoke those listeners.
      //
      if (typeof tree._listeners === 'function') {
        handlers && handlers.push(tree._listeners);
        return [tree];
      } else {
        for (leaf = 0, len = tree._listeners.length; leaf < len; leaf++) {
          handlers && handlers.push(tree._listeners[leaf]);
        }
        return [tree];
      }
    }

    if ((currentType === '*' || currentType === '**') || tree[currentType]) {
      //
      // If the event emitted is '*' at this part
      // or there is a concrete match at this patch
      //
      if (currentType === '*') {
        for (branch in tree) {
          if (branch !== '_listeners' && tree.hasOwnProperty(branch)) {
            listeners = listeners.concat(searchListenerTree(handlers, type, tree[branch], i+1));
          }
        }
        return listeners;
      } else if(currentType === '**') {
        endReached = (i+1 === typeLength || (i+2 === typeLength && nextType === '*'));
        if(endReached && tree._listeners) {
          // The next element has a _listeners, add it to the handlers.
          listeners = listeners.concat(searchListenerTree(handlers, type, tree, typeLength));
        }

        for (branch in tree) {
          if (branch !== '_listeners' && tree.hasOwnProperty(branch)) {
            if(branch === '*' || branch === '**') {
              if(tree[branch]._listeners && !endReached) {
                listeners = listeners.concat(searchListenerTree(handlers, type, tree[branch], typeLength));
              }
              listeners = listeners.concat(searchListenerTree(handlers, type, tree[branch], i));
            } else if(branch === nextType) {
              listeners = listeners.concat(searchListenerTree(handlers, type, tree[branch], i+2));
            } else {
              // No match on this one, shift into the tree but not in the type array.
              listeners = listeners.concat(searchListenerTree(handlers, type, tree[branch], i));
            }
          }
        }
        return listeners;
      }

      listeners = listeners.concat(searchListenerTree(handlers, type, tree[currentType], i+1));
    }

    xTree = tree['*'];
    if (xTree) {
      //
      // If the listener tree will allow any match for this part,
      // then recursively explore all branches of the tree
      //
      searchListenerTree(handlers, type, xTree, i+1);
    }

    xxTree = tree['**'];
    if(xxTree) {
      if(i < typeLength) {
        if(xxTree._listeners) {
          // If we have a listener on a '**', it will catch all, so add its handler.
          searchListenerTree(handlers, type, xxTree, typeLength);
        }

        // Build arrays of matching next branches and others.
        for(branch in xxTree) {
          if(branch !== '_listeners' && xxTree.hasOwnProperty(branch)) {
            if(branch === nextType) {
              // We know the next element will match, so jump twice.
              searchListenerTree(handlers, type, xxTree[branch], i+2);
            } else if(branch === currentType) {
              // Current node matches, move into the tree.
              searchListenerTree(handlers, type, xxTree[branch], i+1);
            } else {
              isolatedBranch = {};
              isolatedBranch[branch] = xxTree[branch];
              searchListenerTree(handlers, type, { '**': isolatedBranch }, i+1);
            }
          }
        }
      } else if(xxTree._listeners) {
        // We have reached the end and still on a '**'
        searchListenerTree(handlers, type, xxTree, typeLength);
      } else if(xxTree['*'] && xxTree['*']._listeners) {
        searchListenerTree(handlers, type, xxTree['*'], typeLength);
      }
    }

    return listeners;
  }

  function growListenerTree(type, listener) {

    type = typeof type === 'string' ? type.split(this.delimiter) : type.slice();

    //
    // Looks for two consecutive '**', if so, don't add the event at all.
    //
    for(var i = 0, len = type.length; i+1 < len; i++) {
      if(type[i] === '**' && type[i+1] === '**') {
        return;
      }
    }

    var tree = this.listenerTree;
    var name = type.shift();

    while (name) {

      if (!tree[name]) {
        tree[name] = {};
      }

      tree = tree[name];

      if (type.length === 0) {

        if (!tree._listeners) {
          tree._listeners = listener;
        }
        else if(typeof tree._listeners === 'function') {
          tree._listeners = [tree._listeners, listener];
        }
        else if (isArray(tree._listeners)) {

          tree._listeners.push(listener);

          if (!tree._listeners.warned) {

            var m = defaultMaxListeners;

            if (typeof this._events.maxListeners !== 'undefined') {
              m = this._events.maxListeners;
            }

            if (m > 0 && tree._listeners.length > m) {

              tree._listeners.warned = true;
              console.error('(node) warning: possible EventEmitter memory ' +
                            'leak detected. %d listeners added. ' +
                            'Use emitter.setMaxListeners() to increase limit.',
                            tree._listeners.length);
              console.trace();
            }
          }
        }
        return true;
      }
      name = type.shift();
    }
    return true;
  }

  // By default EventEmitters will print a warning if more than
  // 10 listeners are added to it. This is a useful default which
  // helps finding memory leaks.
  //
  // Obviously not all Emitters should be limited to 10. This function allows
  // that to be increased. Set to zero for unlimited.

  EventEmitter.prototype.delimiter = '.';

  EventEmitter.prototype.setMaxListeners = function(n) {
    this._events || init.call(this);
    this._events.maxListeners = n;
    if (!this._conf) this._conf = {};
    this._conf.maxListeners = n;
  };

  EventEmitter.prototype.event = '';

  EventEmitter.prototype.once = function(event, fn) {
    this.many(event, 1, fn);
    return this;
  };

  EventEmitter.prototype.many = function(event, ttl, fn) {
    var self = this;

    if (typeof fn !== 'function') {
      throw new Error('many only accepts instances of Function');
    }

    function listener() {
      if (--ttl === 0) {
        self.off(event, listener);
      }
      fn.apply(this, arguments);
    }

    listener._origin = fn;

    this.on(event, listener);

    return self;
  };

  EventEmitter.prototype.emit = function() {

    this._events || init.call(this);

    var type = arguments[0];

    if (type === 'newListener' && !this.newListener) {
      if (!this._events.newListener) { return false; }
    }

    // Loop through the *_all* functions and invoke them.
    if (this._all) {
      var l = arguments.length;
      var args = new Array(l - 1);
      for (var i = 1; i < l; i++) args[i - 1] = arguments[i];
      for (i = 0, l = this._all.length; i < l; i++) {
        this.event = type;
        this._all[i].apply(this, args);
      }
    }

    // If there is no 'error' event listener then throw.
    if (type === 'error') {

      if (!this._all &&
        !this._events.error &&
        !(this.wildcard && this.listenerTree.error)) {

        if (arguments[1] instanceof Error) {
          throw arguments[1]; // Unhandled 'error' event
        } else {
          throw new Error("Uncaught, unspecified 'error' event.");
        }
        return false;
      }
    }

    var handler;

    if(this.wildcard) {
      handler = [];
      var ns = typeof type === 'string' ? type.split(this.delimiter) : type.slice();
      searchListenerTree.call(this, handler, ns, this.listenerTree, 0);
    }
    else {
      handler = this._events[type];
    }

    if (typeof handler === 'function') {
      this.event = type;
      if (arguments.length === 1) {
        handler.call(this);
      }
      else if (arguments.length > 1)
        switch (arguments.length) {
          case 2:
            handler.call(this, arguments[1]);
            break;
          case 3:
            handler.call(this, arguments[1], arguments[2]);
            break;
          // slower
          default:
            var l = arguments.length;
            var args = new Array(l - 1);
            for (var i = 1; i < l; i++) args[i - 1] = arguments[i];
            handler.apply(this, args);
        }
      return true;
    }
    else if (handler) {
      var l = arguments.length;
      var args = new Array(l - 1);
      for (var i = 1; i < l; i++) args[i - 1] = arguments[i];

      var listeners = handler.slice();
      for (var i = 0, l = listeners.length; i < l; i++) {
        this.event = type;
        listeners[i].apply(this, args);
      }
      return (listeners.length > 0) || !!this._all;
    }
    else {
      return !!this._all;
    }

  };

  EventEmitter.prototype.on = function(type, listener) {

    if (typeof type === 'function') {
      this.onAny(type);
      return this;
    }

    if (typeof listener !== 'function') {
      throw new Error('on only accepts instances of Function');
    }
    this._events || init.call(this);

    // To avoid recursion in the case that type == "newListeners"! Before
    // adding it to the listeners, first emit "newListeners".
    this.emit('newListener', type, listener);

    if(this.wildcard) {
      growListenerTree.call(this, type, listener);
      return this;
    }

    if (!this._events[type]) {
      // Optimize the case of one listener. Don't need the extra array object.
      this._events[type] = listener;
    }
    else if(typeof this._events[type] === 'function') {
      // Adding the second element, need to change to array.
      this._events[type] = [this._events[type], listener];
    }
    else if (isArray(this._events[type])) {
      // If we've already got an array, just append.
      this._events[type].push(listener);

      // Check for listener leak
      if (!this._events[type].warned) {

        var m = defaultMaxListeners;

        if (typeof this._events.maxListeners !== 'undefined') {
          m = this._events.maxListeners;
        }

        if (m > 0 && this._events[type].length > m) {

          this._events[type].warned = true;
          console.error('(node) warning: possible EventEmitter memory ' +
                        'leak detected. %d listeners added. ' +
                        'Use emitter.setMaxListeners() to increase limit.',
                        this._events[type].length);
          console.trace();
        }
      }
    }
    return this;
  };

  EventEmitter.prototype.onAny = function(fn) {

    if (typeof fn !== 'function') {
      throw new Error('onAny only accepts instances of Function');
    }

    if(!this._all) {
      this._all = [];
    }

    // Add the function to the event listener collection.
    this._all.push(fn);
    return this;
  };

  EventEmitter.prototype.addListener = EventEmitter.prototype.on;

  EventEmitter.prototype.off = function(type, listener) {
    if (typeof listener !== 'function') {
      throw new Error('removeListener only takes instances of Function');
    }

    var handlers,leafs=[];

    if(this.wildcard) {
      var ns = typeof type === 'string' ? type.split(this.delimiter) : type.slice();
      leafs = searchListenerTree.call(this, null, ns, this.listenerTree, 0);
    }
    else {
      // does not use listeners(), so no side effect of creating _events[type]
      if (!this._events[type]) return this;
      handlers = this._events[type];
      leafs.push({_listeners:handlers});
    }

    for (var iLeaf=0; iLeaf<leafs.length; iLeaf++) {
      var leaf = leafs[iLeaf];
      handlers = leaf._listeners;
      if (isArray(handlers)) {

        var position = -1;

        for (var i = 0, length = handlers.length; i < length; i++) {
          if (handlers[i] === listener ||
            (handlers[i].listener && handlers[i].listener === listener) ||
            (handlers[i]._origin && handlers[i]._origin === listener)) {
            position = i;
            break;
          }
        }

        if (position < 0) {
          continue;
        }

        if(this.wildcard) {
          leaf._listeners.splice(position, 1);
        }
        else {
          this._events[type].splice(position, 1);
        }

        if (handlers.length === 0) {
          if(this.wildcard) {
            delete leaf._listeners;
          }
          else {
            delete this._events[type];
          }
        }
        return this;
      }
      else if (handlers === listener ||
        (handlers.listener && handlers.listener === listener) ||
        (handlers._origin && handlers._origin === listener)) {
        if(this.wildcard) {
          delete leaf._listeners;
        }
        else {
          delete this._events[type];
        }
      }
    }

    return this;
  };

  EventEmitter.prototype.offAny = function(fn) {
    var i = 0, l = 0, fns;
    if (fn && this._all && this._all.length > 0) {
      fns = this._all;
      for(i = 0, l = fns.length; i < l; i++) {
        if(fn === fns[i]) {
          fns.splice(i, 1);
          return this;
        }
      }
    } else {
      this._all = [];
    }
    return this;
  };

  EventEmitter.prototype.removeListener = EventEmitter.prototype.off;

  EventEmitter.prototype.removeAllListeners = function(type) {
    if (arguments.length === 0) {
      !this._events || init.call(this);
      return this;
    }

    if(this.wildcard) {
      var ns = typeof type === 'string' ? type.split(this.delimiter) : type.slice();
      var leafs = searchListenerTree.call(this, null, ns, this.listenerTree, 0);

      for (var iLeaf=0; iLeaf<leafs.length; iLeaf++) {
        var leaf = leafs[iLeaf];
        leaf._listeners = null;
      }
    }
    else {
      if (!this._events[type]) return this;
      this._events[type] = null;
    }
    return this;
  };

  EventEmitter.prototype.listeners = function(type) {
    if(this.wildcard) {
      var handlers = [];
      var ns = typeof type === 'string' ? type.split(this.delimiter) : type.slice();
      searchListenerTree.call(this, handlers, ns, this.listenerTree, 0);
      return handlers;
    }

    this._events || init.call(this);

    if (!this._events[type]) this._events[type] = [];
    if (!isArray(this._events[type])) {
      this._events[type] = [this._events[type]];
    }
    return this._events[type];
  };

  EventEmitter.prototype.listenersAny = function() {

    if(this._all) {
      return this._all;
    }
    else {
      return [];
    }

  };

  if (typeof define === 'function' && define.amd) {
     // AMD. Register as an anonymous module.
    define('ext/eventemitter2',[],function() {
      return EventEmitter;
    });
  } else if (typeof exports === 'object') {
    // CommonJS
    exports.EventEmitter2 = EventEmitter;
  }
  else {
    // Browser global.
    window.EventEmitter2 = EventEmitter;
  }
}();

// these methods are all borrowed from MOUT.js (released under MIT license)
define('utils/mout',['require','exports','module'],function(require, exports) {


// TODO: add MOUT.js as a dependency!!!! this is just a temporary solution

exports.norm = function norm(val, min, max){
  // 0 / 0 === NaN
  if (val === min && min === max) {
    return 1;
  }
  return (val - min) / (max - min);
};

exports.clamp = function clamp(val, min, max) {
  return val < min ? min : (val > max ? max : val);
};

exports.round = function round(value, radix){
  radix = radix || 1; // default round 1
  return Math.round(value / radix) * radix;
};

exports.floor = function floor(val, step) {
  step = Math.abs(step || 1);
  return Math.floor(val / step) * step;
};

exports.ceil = function ceil(val, step) {
  step = Math.abs(step || 1);
  return Math.ceil(val / step) * step;
};

exports.lerp = function lerp(ratio, start, end){
  return start + (end - start) * ratio;
};

exports.debounce = function debounce(fn, threshold, isAsap){
  var timeout, result;
  function debounced(){
    //jshint -W040
    var args = arguments, context = this;
    //jshint +W040
    function delayed(){
      if (! isAsap) {
        result = fn.apply(context, args);
      }
      timeout = null;
    }
    if (timeout) {
      clearTimeout(timeout);
    } else if (isAsap) {
      result = fn.apply(context, args);
    }
    timeout = setTimeout(delayed, threshold);
    return result;
  }
  debounced.cancel = function(){
    clearTimeout(timeout);
  };
  return debounced;
};

exports.throttle = function throttle(fn, delay) {
  var context, timeout, result, args,
    diff,
    prevCall = 0;
  function delayed() {
    prevCall = Date.now();
    timeout = null;
    result = fn.apply(context, args);
  }
  function throttled() {
    //jshint -W040
    context = this;
    //jshint +W040
    args = arguments;
    diff = delay - (Date.now() - prevCall);
    if (diff <= 0) {
      clearTimeout(timeout);
      delayed();
    } else if (!timeout) {
      timeout = setTimeout(delayed, diff);
    }
    return result;
  }
  throttled.cancel = function() {
    clearTimeout(timeout);
  };
  return throttled;
};

});

define('day_observer',['require','exports','module','calc','ext/eventemitter2','calc','utils/mout'],function(require, exports) {


// Listen for changes on all busytimes inside a given day
// ---
// This module will listen for changes on any busytime inside a day and
// group/batch multiple add/remove events into a single emit call; making it
// easier to rerender all the busytimes at once and allowing us to use the
// same method to add/remove busytimes from the DOM, drastically simplifying
// the logic required.
// ---
// On the most common scenario there should not be that many busytimes inside
// the same day, and every time we add a new busytime to the DOM we need to
// check for "overlaps", so doing the full rerender will make a lot of sense
// and should not affect performance that much.
// ---
// Our goal is to deprecate most of the time controller logic and move to
// a simpler day-based logic for the whole calendar front-end, breaking the
// views into smaller sub-views and listening for changes on a single day
// instead of knowing how to handle months/weeks. This should increase the
// flexibility and simplify the development process A LOT.


var Calc = require('calc');
var EventEmitter2 = require('ext/eventemitter2');
var isAllDay = require('calc').isAllDay;
var debounce = require('utils/mout').debounce;

exports.DISPATCH_DELAY = 50;

// injected later to avoid circular dependencies
exports.timeController = null;

var cachedRecords = {};
var debouncedEmit = {};
// emitter is exposed to make testing/mocking easier
var emitter = exports.emitter = new EventEmitter2();

exports.on = function(date, callback) {
  var dayId = Calc.getDayId(date);
  var hasListeners = !!emitter.listeners(dayId).length;
  emitter.on(dayId, callback);

  if (!hasListeners) {
    // make sure the dispatch doesn't happen too often during sync, we also
    // only add a single listener for each day to the time controller since
    // we need to group/batch the event dispatches and the time controller
    // will dispatch "add/remove" events for each busy time.
    var dispatch = debouncedEmit[dayId] = debounce(
      emit.bind(null, dayId),
      exports.DISPATCH_DELAY
    );
    exports.timeController.observeTime(Calc.spanOfDay(date), dispatch);
    // we need to trigger callbacks to re-render the views if needed,
    // cachedRecords is only built after first dispatch
    dispatch();
  } else if (dayId in cachedRecords) {
    // if it is not the first listener and we have some records in memory we
    // should also call the callback
    callback(cachedRecords[dayId]);
  }
};

exports.off = function(date, callback) {
  var dayId = Calc.getDayId(date);
  emitter.off(dayId, callback);

  var listeners = emitter.listeners(dayId);
  if (!listeners || !listeners.length) {
    stopListening(dayId);
  }
};

function stopListening(dayId) {
  if (!debouncedEmit[dayId]) {
    return;
  }
  var date = Calc.dateFromId(dayId);
  exports.timeController.removeTimeObserver(
    Calc.spanOfDay(date),
    debouncedEmit[dayId]
  );
  // we need to cancel the dispatch otherwise we might trigger a db query
  // without need (causes error on unit tests)
  debouncedEmit[dayId].cancel();
  delete debouncedEmit[dayId];
  delete cachedRecords[dayId];
}

exports.removeAllListeners = function() {
  emitter.removeAllListeners();
  Object.keys(debouncedEmit).forEach(stopListening);
};

function emit(dayId) {
  // date objects are mutable, so it's safer to convert it back based
  // on the day id that was initially generated
  var date = Calc.dateFromId(dayId);
  var busytimes = getBusytimes(date);
  exports.timeController.findAssociated(busytimes, (err, records) => {
    var allday = [];
    var events = [];

    records.forEach(record => {
      var {startDate, endDate} = record.busytime;
      var group = isAllDay(date, startDate, endDate) ? allday : events;
      group.push(record);
    });

    events.sort((a, b) => {
      return a.busytime.startDate - b.busytime.startDate;
    });

    var result = {
      amount: records.length,
      events: events,
      allday: allday
    };
    emitter.emit(dayId, result);
    cachedRecords[dayId] = result;
  });
}

function getBusytimes(date) {
  var timespan = Calc.spanOfDay(date);
  return exports.timeController.queryCache(timespan);
}

});

/**
 * @fileoverview Period sync controller manages
 *
 *     1. Seeding first sync alarm when app starts.
 *     2. Syncing when a sync alarm fires and issuing a new sync alarm.
 *     3. Invalidating any existing sync alarms and issuing a new one
 *        when the sync interval changes.
 */
define('controllers/periodic_sync',['require','exports','module','responder','debug'],function(require, exports) {


var Responder = require('responder');
var debug = require('debug')('controllers/periodic_sync');

/**
 * Cached alarm previously sent to alarms db.
 * @type {Object}
 */
var syncAlarm;

/**
 * Cached sync value (every x minutes) from scheduling.
 * @type {Number}
 */
var prevSyncFrequency;

/**
 * Most recently set sync interval (every x minutes).
 * @type {Number}
 */
var syncFrequency;

/**
 * Cached promise representing pending sync operation.
 * @type {Promise}
 */
var syncing;

/**
 * Cached promise representing pending schedule operation.
 * @type {Promise}
 */
var scheduling;

var events = new Responder();
exports.events = events;

var accounts;
var settings;

// Will be injected...
exports.app = null;

exports.observe = function() {
  debug('Will start periodic sync controller...');
  var app = exports.app;
  accounts = app.store('Account');
  settings = app.store('Setting');
  return Promise.all([
    settings.getValue('syncAlarm'),
    settings.getValue('syncFrequency')
  ])
  .then(values => {
    [syncAlarm, syncFrequency] = values;
    // Trigger whenever there is a change to the accounts collection
    // since we need to re-evaluate whether periodic sync is still necessary.
    accounts.on('persist', onAccountsChange);
    accounts.on('remove', onAccountsChange);
    // Listen to the settings collection for a change to sync frequency so that
    // we can update any alarms we've sent to the alarms api accordingly.
    settings.on('syncFrequencyChange', exports);
    return scheduleSync();
  });
};

exports.unobserve = function() {
  syncAlarm = null;
  prevSyncFrequency = null;
  syncFrequency = null;
  syncing = null;
  scheduling = null;
  accounts.off('persist', onAccountsChange);
  accounts.off('remove', onAccountsChange);
  settings.off('syncFrequencyChange', exports);
};

exports.handleEvent = function(event) {
  switch (event.type) {
    case 'sync':
      // Gets triggered by mozSetMessageHandler alarm event.
      return onSync();
    case 'syncFrequencyChange':
      // Gets triggered by settings db change to sync frequency.
      return onSyncFrequencyChange(event.data[0]);
  }
};

/**
 * 1. Wait until we're done with any previous work.
 * 2. Sync.
 * 3. Schedule the next periodic sync.
 */
function onSync() {
  return sync().then(scheduleSync);
}

/**
 * 1. Wait until we're done with any previous work.
 * 2. Schedule a periodic sync at the new interval.
 */
function onSyncFrequencyChange(value) {
  debug('Sync frequency changed to', value);
  syncFrequency = value;
  return maybeScheduleSync();
}

/**
 * No syncable accounts => revoke any previously scheduled sync alarms.
 * Syncable accounts and no previously scheduled sync => schedule new sync.
 */
function onAccountsChange() {
  debug('Looking up syncable accounts...');
  return accounts.syncableAccounts().then(syncable => {
    if (!syncable || !syncable.length) {
      debug('There are no syncable accounts!');
      revokePreviousAlarm();
      events.emit('pause');
      return;
    }

    debug('There are', syncable.length, 'syncable accounts');

    if (!syncAlarmIssued()) {
      debug('The first syncable account was just added.');
      return scheduleSync();
    }
  });
}

function sync() {
  if (!syncing) {
    syncing = new Promise((resolve, reject) => {
      debug('Will request cpu and wifi wake locks...');
      var cpuLock = navigator.requestWakeLock('cpu');
      var wifiLock = navigator.requestWakeLock('wifi');
      debug('Will start periodic sync...');
      var app = exports.app;
      app.syncController.all(() => {
        debug('Sync complete! Will release cpu and wifi wake locks...');
        cpuLock.unlock();
        wifiLock.unlock();
        events.emit('sync');
        syncing = null;
        resolve();
      });
    });
  }

  return syncing;
}

function scheduleSync() {
  if (scheduling) {
    return scheduling;
  }

  scheduling = accounts.syncableAccounts()
  .then(syncable => {
    if (!syncable || !syncable.length) {
      debug('There seem to be no syncable accounts, will defer scheduling...');
      return Promise.resolve();
    }

    debug('Will schedule periodic sync in:', syncFrequency);
    // Cache the sync interval which we're sending to the alarms api.
    prevSyncFrequency = syncFrequency;
    revokePreviousAlarm();

    return issueSyncAlarm().then(cacheSyncAlarm).then(maybeScheduleSync);
  })
  .then(() => {
    events.emit('schedule');
    scheduling = null;
  })
  .catch(error => {
    debug('Error scheduling sync:', error);
    console.error(error.toString());
    scheduling = null;
  });

  return scheduling;
}

// TODO: When navigator.mozAlarms.remove (one day) returns a DOMRequest,
//     we should make this async...
function revokePreviousAlarm() {
  if (!syncAlarmIssued()) {
    debug('No sync alarms issued, nothing to revoke...');
    return;
  }

  debug('Will revoke alarm', syncAlarm.alarmId);
  var alarms = navigator.mozAlarms;
  alarms.remove(syncAlarm.alarmId);
}

function issueSyncAlarm() {
  if (!prevSyncFrequency) {
    debug('Periodic sync disabled!');
    return Promise.resolve({ alarmId: null, start: null, end: null });
  }

  var start = new Date();
  var end = new Date(
    start.getTime() +
    prevSyncFrequency * 60 * 1000 // minutes to ms
  );

  var alarms = navigator.mozAlarms;
  var request = alarms.add(end, 'ignoreTimezone', { type: 'sync' });

  return new Promise((resolve, reject) => {
    request.onsuccess = function() {
      resolve({ alarmId: this.result, start: start, end: end });
    };

    request.onerror = function() {
      reject(this.error);
    };
  });
}

function cacheSyncAlarm(alarm) {
  debug('Will save alarm:', alarm);
  syncAlarm = alarm;
  return settings.set('syncAlarm', syncAlarm);
}

function maybeScheduleSync() {
  if (syncFrequency === prevSyncFrequency) {
    // Nothing to do!
    return Promise.resolve();
  }

  if (scheduling) {
    return scheduling.then(scheduleSync);
  }

  return scheduleSync();
}

function syncAlarmIssued() {
  return syncAlarm && !!syncAlarm.alarmId;
}

});


;(function(){

  /**
   * Perform initial dispatch.
   */

  var dispatch = true;

  /**
   * Base path.
   */

  var base = '';

  /**
   * Running flag.
   */

  var running;

  /**
   * Register `path` with callback `fn()`,
   * or route `path`, or `page.start()`.
   *
   *   page(fn);
   *   page('*', fn);
   *   page('/user/:id', load, user);
   *   page('/user/' + user.id, { some: 'thing' });
   *   page('/user/' + user.id);
   *   page();
   *
   * @param {String|Function} path
   * @param {Function} fn...
   * @api public
   */

  function page(path, fn) {
    // <callback>
    if ('function' == typeof path) {
      return page('*', path);
    }

    // route <path> to <callback ...>
    if ('function' == typeof fn) {
      var route = new Route(path);
      for (var i = 1; i < arguments.length; ++i) {
        page.callbacks.push(route.middleware(arguments[i]));
      }
    // show <path> with [state]
    } else if ('string' == typeof path) {
      page.show(path, fn);
    // start [options]
    } else {
      page.start(path);
    }
  }

  /**
   * Callback functions.
   */

  page.callbacks = [];

  /**
   * Get or set basepath to `path`.
   *
   * @param {String} path
   * @api public
   */

  page.base = function(path){
    if (0 == arguments.length) return base;
    base = path;
  };

  /**
   * Bind with the given `options`.
   *
   * Options:
   *
   *    - `click` bind to click events [true]
   *    - `popstate` bind to popstate [true]
   *    - `dispatch` perform initial dispatch [true]
   *
   * @param {Object} options
   * @api public
   */

  page.start = function(options){
    options = options || {};
    if (running) return;
    running = true;
    if (false === options.dispatch) dispatch = false;
    if (false !== options.popstate) window.addEventListener('popstate', onpopstate, false);
    if (false !== options.click) window.addEventListener('click', onclick, false);
    if (!dispatch) return;
    page.replace(location.pathname + location.search, null, true, dispatch);
  };

  /**
   * Unbind click and popstate event handlers.
   *
   * @api public
   */

  page.stop = function(){
    running = false;
    removeEventListener('click', onclick, false);
    removeEventListener('popstate', onpopstate, false);
  };

  /**
   * Show `path` with optional `state` object.
   *
   * @param {String} path
   * @param {Object} state
   * @return {Context}
   * @api public
   */

  page.show = function(path, state){
    var ctx = new Context(path, state);
    page.dispatch(ctx);
    if (!ctx.unhandled) ctx.pushState();
    return ctx;
  };

  /**
   * Replace `path` with optional `state` object.
   *
   * @param {String} path
   * @param {Object} state
   * @return {Context}
   * @api public
   */

  page.replace = function(path, state, init, dispatch){
    var ctx = new Context(path, state);
    ctx.init = init;
    if (null == dispatch) dispatch = true;
    if (dispatch) page.dispatch(ctx);
    ctx.save();
    return ctx;
  };

  /**
   * Dispatch the given `ctx`.
   *
   * @param {Object} ctx
   * @api private
   */

  page.dispatch = function(ctx){
    var i = 0;

    function next() {
      var fn = page.callbacks[i++];
      if (!fn) return unhandled(ctx);
      fn(ctx, next);
    }

    next();
  };

  /**
   * Unhandled `ctx`. When it's not the initial
   * popstate then redirect. If you wish to handle
   * 404s on your own use `page('*', callback)`.
   *
   * @param {Context} ctx
   * @api private
   */

  function unhandled(ctx) {
    if (window.location.pathname + window.location.search == ctx.canonicalPath) return;
    page.stop();
    ctx.unhandled = true;
    window.location = ctx.canonicalPath;
  }

  /**
   * Initialize a new "request" `Context`
   * with the given `path` and optional initial `state`.
   *
   * @param {String} path
   * @param {Object} state
   * @api public
   */

  function Context(path, state) {
    if ('/' == path[0] && 0 != path.indexOf(base)) path = base + path;
    var i = path.indexOf('?');
    this.canonicalPath = path;
    this.path = path.replace(base, '') || '/';
    this.title = document.title;
    this.state = state || {};
    this.state.path = path;
    this.querystring = ~i ? path.slice(i + 1) : '';
    this.pathname = ~i ? path.slice(0, i) : path;
    this.params = [];
  }

  /**
   * Expose `Context`.
   */

  page.Context = Context;

  /**
   * Push state.
   *
   * @api private
   */

  Context.prototype.pushState = function(){
    history.pushState(this.state, this.title, this.canonicalPath);
  };

  /**
   * Save the context state.
   *
   * @api public
   */

  Context.prototype.save = function(){
    history.replaceState(this.state, this.title, this.canonicalPath);
  };

  /**
   * Initialize `Route` with the given HTTP `path`,
   * and an array of `callbacks` and `options`.
   *
   * Options:
   *
   *   - `sensitive`    enable case-sensitive routes
   *   - `strict`       enable strict matching for trailing slashes
   *
   * @param {String} path
   * @param {Object} options.
   * @api private
   */

  function Route(path, options) {
    options = options || {};
    this.path = path;
    this.method = 'GET';
    this.regexp = pathtoRegexp(path
      , this.keys = []
      , options.sensitive
      , options.strict);
  }

  /**
   * Expose `Route`.
   */

  page.Route = Route;

  /**
   * Return route middleware with
   * the given callback `fn()`.
   *
   * @param {Function} fn
   * @return {Function}
   * @api public
   */

  Route.prototype.middleware = function(fn){
    var self = this;
    return function(ctx, next){
      if (self.match(ctx.path, ctx.params)) return fn(ctx, next);
      next();
    }
  };

  /**
   * Check if this route matches `path`, if so
   * populate `params`.
   *
   * @param {String} path
   * @param {Array} params
   * @return {Boolean}
   * @api private
   */

  Route.prototype.match = function(path, params){
    var keys = this.keys
      , qsIndex = path.indexOf('?')
      , pathname = ~qsIndex ? path.slice(0, qsIndex) : path
      , m = this.regexp.exec(pathname);
  
    if (!m) return false;

    for (var i = 1, len = m.length; i < len; ++i) {
      var key = keys[i - 1];

      var val = 'string' == typeof m[i]
        ? decodeURIComponent(m[i])
        : m[i];

      if (key) {
        params[key.name] = undefined !== params[key.name]
          ? params[key.name]
          : val;
      } else {
        params.push(val);
      }
    }

    return true;
  };

  /**
   * Normalize the given path string,
   * returning a regular expression.
   *
   * An empty array should be passed,
   * which will contain the placeholder
   * key names. For example "/user/:id" will
   * then contain ["id"].
   *
   * @param  {String|RegExp|Array} path
   * @param  {Array} keys
   * @param  {Boolean} sensitive
   * @param  {Boolean} strict
   * @return {RegExp}
   * @api private
   */

  function pathtoRegexp(path, keys, sensitive, strict) {
    if (path instanceof RegExp) return path;
    if (path instanceof Array) path = '(' + path.join('|') + ')';
    path = path
      .concat(strict ? '' : '/?')
      .replace(/\/\(/g, '(?:/')
      .replace(/\+/g, '__plus__')
      .replace(/(\/)?(\.)?:(\w+)(?:(\(.*?\)))?(\?)?/g, function(_, slash, format, key, capture, optional){
        keys.push({ name: key, optional: !! optional });
        slash = slash || '';
        return ''
          + (optional ? '' : slash)
          + '(?:'
          + (optional ? slash : '')
          + (format || '') + (capture || (format && '([^/.]+?)' || '([^/]+?)')) + ')'
          + (optional || '');
      })
      .replace(/([\/.])/g, '\\$1')
      .replace(/__plus__/g, '(.+)')
      .replace(/\*/g, '(.*)');
    return new RegExp('^' + path + '$', sensitive ? '' : 'i');
  };

  /**
   * Handle "populate" events.
   */

  function onpopstate(e) {
    if (e.state) {
      var path = e.state.path;
      page.replace(path, e.state);
    }
  }

  /**
   * Handle "click" events.
   */

  function onclick(e) {
    if (1 != which(e)) return;
    if (e.defaultPrevented) return;
    var el = e.target;
    while (el && 'A' != el.nodeName) el = el.parentNode;
    if (!el || 'A' != el.nodeName) return;
    var href = el.href;
    var path = el.pathname + el.search;
    if (el.hash || '#' == el.getAttribute('href')) return;
    if (!sameOrigin(href)) return;
    var orig = path;
    path = path.replace(base, '');
    if (base && orig == path) return;
    e.preventDefault();
    page.show(orig);
  }

  /**
   * Event button.
   */

  function which(e) {
    e = e || window.event;
    return null == e.which
      ? e.button
      : e.which;
  }

  /**
   * Check if `href` is the same origin.
   */

  function sameOrigin(href) {
    var origin = location.protocol + '//' + location.hostname;
    if (location.port) origin += ':' + location.port;
    return 0 == href.indexOf(origin);
  }

  /**
   * Expose `page`.
   */

  if ('undefined' == typeof module) {
    window.page = page;
  } else {
    module.exports = page;
  }

})();

define("ext/page", (function (global) {
    return function () {
        var ret, fn;
        return ret || global.page;
    };
}(this)));



(function(window) {

  // Placeholder for storing statically generated performance timestamps,
  // similar to window.performance
  window.mozPerformance = {
    timing: {}
  };

  function dispatch(name) {
    if (!window.mozPerfHasListener) {
      return;
    }

    var now = window.performance.now();
    var epoch = Date.now();

    setTimeout(function() {
      var detail = {
        name: name,
        timestamp: now,
        epoch: epoch
      };
      var event = new CustomEvent('x-moz-perf', { detail: detail });

      window.dispatchEvent(event);
    });
  }

  [
    'moz-chrome-dom-loaded',
    'moz-chrome-interactive',
    'moz-app-visually-complete',
    'moz-content-interactive',
    'moz-app-loaded'
  ].forEach(function(eventName) {
      window.addEventListener(eventName, function mozPerfLoadHandler() {
        dispatch(eventName);
      }, false);
    });

  window.PerformanceTestingHelper = {
    dispatch: dispatch
  };

})(window);

define("shared/performance_testing_helper", (function (global) {
    return function () {
        var ret, fn;
        return ret || global.PerformanceTestingHelper;
    };
}(this)));

define('performance',['require','exports','module','shared/performance_testing_helper'],function(require, exports) {


require('shared/performance_testing_helper');

// Helper for the performance testing events. we created
// this dedicated module since we need some "state machine" logic to avoid
// race conditions and the app contains way too many async operations during
// startup and no simple way to listen to these events.

exports._isMonthAgendaInteractive = false;
exports._isMonthReady = false;
exports._isVisuallyActive = false;
exports._isPendingReady = false;

/**
 * Performance testing events. See <https://bugzil.la/996038>.
 */
function dispatch(eventType) {
  window.dispatchEvent(new CustomEvent(eventType));
}

/**
 * Dispatch 'moz-chrome-dom-loaded' event.
 * Designates that the app's *core* chrome or navigation interface
 * exists in the DOM and is marked as ready to be displayed.
 */
exports.domLoaded = function() {
  // PERFORMANCE EVENT (1): moz-chrome-dom-loaded
  dispatch('moz-chrome-dom-loaded');
};

/**
 * Designates that the app's *core* chrome or navigation interface
 * has its events bound and is ready for user interaction.
 */
exports.chromeInteractive = function() {
  // PERFORMANCE EVENT (2): moz-chrome-interactive
  dispatch('moz-chrome-interactive');
};

/**
 * Should be called when the MonthsDayView
 * rendered all the busytimes for that day.
 */
exports.monthsDayReady = function() {
  if (exports._isMonthAgendaInteractive) {
    return;
  }

  exports._isMonthAgendaInteractive = true;
  dispatchVisuallyCompleteAndInteractive();
};

/**
 * Should be called when the month is "ready" (rendered + event listeners)
 * including the busy times indicator.
 */
exports.monthReady = function() {
  if (exports._isMonthReady) {
    return;
  }

  exports._isMonthReady = true;
  dispatchVisuallyCompleteAndInteractive();
};

/**
 * app-visually-complete and content-interactive will happen after the
 * MonthChild#activate + rendering the busy counts for the current month +
 * DayBased#_loadRecords (inherited by MonthsDayView)
 */
function dispatchVisuallyCompleteAndInteractive() {
  if (exports._isVisuallyActive ||
      !exports._isMonthAgendaInteractive ||
      !exports._isMonthReady) {
    return;
  }

  exports._isVisuallyActive = true;

  // PERFORMANCE EVENT (3): moz-app-visually-complete
  // Designates that the app is visually loaded (e.g.: all of the
  // "above-the-fold" content exists in the DOM and is marked as
  // ready to be displayed).
  dispatch('moz-app-visually-complete');

  // PERFORMANCE EVENT (4): moz-content-interactive
  // Designates that the app has its events bound for the minimum
  // set of functionality to allow the user to interact with the
  // "above-the-fold" content.
  dispatch('moz-content-interactive');

  dispatchAppLoad();
}

/**
 * Register that pending manager completed first batch of operations.
 */
exports.pendingReady = function() {
  if (exports._isPendingReady) {
    return;
  }

  exports._isPendingReady = true;
  dispatchAppLoad();
};

/**
 * App is only considered "loaded" after the MonthView and MonthDayAgenda
 * are "ready" and the first pending operations batch is completed (loading
 * events from DB and recurring events expansion).
 */
function dispatchAppLoad() {
  if (!exports._isVisuallyActive || !exports._isPendingReady) {
    // to avoid race conditions (in case this is called before month view
    // is built), should not happen, but maybe in the future when IDB gets
    // faster this might be possible.
    return;
  }

  // PERFORMANCE EVENT (5): moz-app-loaded
  // Designates that the app is *completely* loaded and all relevant
  // "below-the-fold" content exists in the DOM, is marked visible,
  // has its events bound and is ready for user interaction. All
  // required startup background processing should be complete.
  dispatch('moz-app-loaded');
}

});

define('snake_case',['require','exports','module'],function(require, exports, module) {


module.exports = function(name) {
  return name
    .replace(/^./, chr => chr.toLowerCase())
    .replace(/[A-Z]/g, chr => '_' + chr.toLowerCase());
};

});

define('app',['require','exports','module','shared/accessibility_helper','calc','date_l10n','db','controllers/error','pending_manager','controllers/recurring_events','router','controllers/service','controllers/sync','controllers/time','day_observer','debug','message_handler','next_tick','controllers/notifications','controllers/periodic_sync','ext/page','performance','provider/provider_factory','snake_case'],function(require, exports, module) {


var AccessibilityHelper = require('shared/accessibility_helper');
var Calc = require('calc');
var DateL10n = require('date_l10n');
var Db = require('db');
var ErrorController = require('controllers/error');
var PendingManager = require('pending_manager');
var RecurringEventsController = require('controllers/recurring_events');
var Router = require('router');
var ServiceController = require('controllers/service');
var SyncController = require('controllers/sync');
var TimeController = require('controllers/time');
var Views = {};
var dayObserver = require('day_observer');
var debug = require('debug')('app');
var messageHandler = require('message_handler');
var nextTick = require('next_tick');
var notificationsController = require('controllers/notifications');
var periodicSyncController = require('controllers/periodic_sync');
var page = require('ext/page');
var performance = require('performance');
var providerFactory = require('provider/provider_factory');
var snakeCase = require('snake_case');

var pendingClass = 'pending-operation';

/**
 * Focal point for state management
 * within calendar application.
 *
 * Contains tools for routing and central
 * location to reference database.
 */
module.exports = {
  _mozTimeRefreshTimeout: 3000,

  /**
   * Entry point for application
   * must be called at least once before
   * using other methods.
   */
  configure: function(db, router) {
    debug('Configure calendar with db and router.');
    this.db = db;
    this.router = router;
    this.router.app = this;

    providerFactory.app = this;

    this._views = Object.create(null);
    this._routeViewFn = Object.create(null);
    this._pendingManager = new PendingManager();

    this._pendingManager.oncomplete = function onpending() {
      document.body.classList.remove(pendingClass);
      performance.pendingReady();
    };

    this._pendingManager.onpending = function oncomplete() {
      document.body.classList.add(pendingClass);
    };

    messageHandler.app = this;
    this.timeController = new TimeController(this);
    this.syncController = new SyncController(this);
    this.serviceController = new ServiceController(this);
    this.errorController = new ErrorController(this);
    notificationsController.app = this;
    periodicSyncController.app = this;

    dayObserver.timeController = this.timeController;
    dayObserver.calendarStore = this.store('Calendar');

    // observe sync events
    this.observePendingObject(this.syncController);

    // Tell audio channel manager that we want to adjust the notification
    // channel if the user press the volumeup/volumedown buttons in Calendar.
    if (navigator.mozAudioChannelManager) {
      navigator.mozAudioChannelManager.volumeControlChannel = 'notification';
    }
  },

  /**
   * Observes localized events and localizes elements
   * with data-l10n-date-format should be registered
   * after the first localized event.
   *
   *
   * Example:
   *
   *
   *    <span
   *      data-date="Wed Jan 09 2013 19:25:38 GMT+0100 (CET)"
   *      data-l10n-date-format="%x">
   *
   *      2013/9/19
   *
   *    </span>
   *
   */
  observeDateLocalization: function() {
    window.addEventListener('localized', DateL10n.localizeElements);
    window.addEventListener('timeformatchange', () => {
      this.setCurrentTimeFormat();
      DateL10n.changeElementsHourFormat();
    });
  },

  setCurrentTimeFormat: function() {
    document.body.dataset.timeFormat = navigator.mozHour12 ? '12' : '24';
  },

  /**
   * Adds observers to objects capable of being pending.
   *
   * Object must emit some kind of start/complete events
   * and have the following properties:
   *
   *  - startEvent (used to register an observer)
   *  - endEvent ( ditto )
   *  - pending
   *
   * @param {Object} object to observe.
   */
  observePendingObject: function(object) {
    this._pendingManager.register(object);
  },

  isPending: function() {
    return this._pendingManager.isPending();
  },

  /**
   * Internally restarts the application.
   */
  forceRestart: function() {
    if (!this.restartPending) {
      this.restartPending = true;
      this._location.href = this.startingURL;
    }
  },

  /**
   * Navigates app to a new location.
   *
   * @param {String} url new view url.
   */
  go: function(url) {
    this.router.show(url);
  },

  /**
   * Shortcut for app.router.state
   */
  state: function() {
    this.router.state.apply(this.router, arguments);
  },

  /**
   * Shortcut for app.router.modifier
   */
  modifier: function() {
    this.router.modifier.apply(this.router, arguments);
  },

  /**
   * Shortcut for app.router.resetState
   */
  resetState: function() {
    this.router.resetState();
  },

  _routes: function() {

    /* routes */
    this.state('/week/', 'Week');
    this.state('/day/', 'Day');
    this.state('/month/', ['Month', 'MonthDayAgenda']);
    this.modifier('/settings/', 'Settings', { clear: false });
    this.modifier('/advanced-settings/', 'AdvancedSettings');

    this.state('/alarm-display/:id', 'ViewEvent', { path: false });

    this.state('/event/add/', 'ModifyEvent');
    this.state('/event/edit/:id', 'ModifyEvent');
    this.state('/event/show/:id', 'ViewEvent');

    this.modifier('/select-preset/', 'CreateAccount');
    this.modifier('/create-account/:preset', 'ModifyAccount');
    this.modifier('/update-account/:id', 'ModifyAccount');

    this.router.start();

    // at this point the tabs should be interactive and the router ready to
    // handle the path changes (meaning the user can start interacting with
    // the app)
    performance.chromeInteractive();

    var pathname = window.location.pathname;
    // default view
    if (pathname === '/index.html' || pathname === '/') {
      this.go('/month/');
    }

  },

  _init: function() {
    // quick hack for today button
    var tablist = document.querySelector('#view-selector');
    var today = tablist.querySelector('.today a');
    var tabs = tablist.querySelectorAll('[role="tab"]');

    this._showTodayDate();
    this._syncTodayDate();
    today.addEventListener('click', (e) => {
      var date = new Date();
      this.timeController.move(date);
      this.timeController.selectedDay = date;

      e.preventDefault();
    });

    // Handle aria-selected attribute for tabs.
    tablist.addEventListener('click', (event) => {
      if (event.target !== today) {
        AccessibilityHelper.setAriaSelected(event.target, tabs);
      }
    });

    this.setCurrentTimeFormat();
    // re-localize dates on screen
    this.observeDateLocalization();

    this.timeController.observe();
    notificationsController.observe();
    periodicSyncController.observe();

    // turn on the auto queue this means that when
    // alarms are added to the database we manage them
    // transparently. Defaults to off for tests.
    this.store('Alarm').autoQueue = true;

    this.timeController.move(new Date());

    this.view('TimeHeader', (header) => header.render());
    this.view('CalendarColors', (colors) => colors.render());

    document.body.classList.remove('loading');

    // at this point we remove the .loading class and user will see the main
    // app frame
    performance.domLoaded();

    this._routes();

    var recurringEventsController = new RecurringEventsController(this);
    this.observePendingObject(recurringEventsController);
    recurringEventsController.observe();
    this.recurringEventsController = recurringEventsController;

    nextTick(() => this.view('Errors'));
  },

  _setPresentDate: function() {
    var id = Calc.getDayId(new Date());
    var presentDate = document.querySelector(
      '#month-view [data-date="' + id + '"]'
    );
    var previousDate = document.querySelector('#month-view .present');

    previousDate.classList.remove('present');
    previousDate.classList.add('past');
    presentDate.classList.add('present');
  },

  _showTodayDate: function() {
    var element = document.querySelector('#today .icon-calendar-today');
    element.innerHTML = new Date().getDate();
  },

  _syncTodayDate: function() {
    var now = new Date();
    var midnight = new Date(
      now.getFullYear(), now.getMonth(), now.getDate() + 1,
      0, 0, 0
    );

    var timeout = midnight.getTime() - now.getTime();
    setTimeout(() => {
      this._showTodayDate();
      this._setPresentDate();
      this._syncTodayDate();
    }, timeout);
  },

  /**
   * Primary code for app can go here.
   */
  init: function() {
    debug('Will initialize calendar app...');
    var self = this;
    var pending = 2;

    function next() {
      pending--;
      if (!pending) {
        self._init();
      }
    }

    if (!this.db) {
      this.configure(new Db('b2g-calendar', this), new Router(page));
    }

    // start the workers
    this.serviceController.start(false);

    var l10n = navigator.mozL10n;
    l10n.once(next);
    this.db.load(next);
  },

  _initView: function(name) {
    var view = new Views[name]({ app: this });
    this._views[name] = view;
  },

  /**
   * Initializes a view and stores
   * a internal reference so when
   * view is called a second
   * time the same view is used.
   *
   * Makes an asynchronous call to
   * load the script if we do not
   * have the view cached.
   *
   *    // for example if you have
   *    // a calendar view Foo
   *
   *    Calendar.Views.Foo = Klass;
   *
   *    app.view('Foo', function(view) {
   *      (view instanceof Calendar.Views.Foo) === true
   *    });
   *
   * @param {String} name view name.
   * @param {Function} view loaded callback.
   */
  view: function(name, cb) {
    if (name in this._views) {
      debug('Found view named ', name);
      var view = this._views[name];
      return cb && nextTick(() => cb.call(this, view));
    }

    if (name in Views) {
      debug('Must initialize view', name);
      this._initView(name);
      return this.view(name, cb);
    }

    var snake = snakeCase(name);
    debug('Will try to load view', name);
    require([ 'views/' + snake ], (aView) => {
      debug('Loaded view', name);
      Views[name] = aView;
      return this.view(name, cb);
    });
  },

  /**
   * Pure convenience function for
   * referencing a object store.
   *
   * @param {String} name store name. (e.g events).
   * @return {Calendar.Store.Abstact} store.
   */
  store: function(name) {
    return this.db.getStore(name);
  },

  /**
   * Returns the offline status.
   */
  offline: function() {
    return (navigator && 'onLine' in navigator) ? !navigator.onLine : true;
  }
};

});

(function() {


function waitForLoad() {
  return new Promise(accept => {
    if (document.readyState === 'complete') {
      return accept();
    }

    window.addEventListener('load', function onLoad() {
      window.removeEventListener('load', onLoad);
      return accept();
    });
  });
}

console.log('Will configure rjs...');
require.config({
  baseUrl: '/js',
  paths: {
    shared: '/shared/js'
  },
  shim: {
    'ext/caldav': { exports: 'Caldav' },
    'ext/ical': { exports: 'ICAL' },
    'ext/page': { exports: 'page' },
    'shared/accessibility_helper': { exports: 'AccessibilityHelper' },
    'shared/gesture_detector': { exports: 'GestureDetector' },
    'shared/input_parser': { exports: 'InputParser' },
    'shared/lazy_loader': { exports: 'LazyLoader' },
    'shared/notification_helper': { exports: 'NotificationHelper' },
    'shared/performance_testing_helper': { exports: 'PerformanceTestingHelper' }
  }
});

require([
  'app',
  'debug',
  'next_tick'
], (app, debug, nextTick) => {
  debug = debug('main');

  debug('Will wait for window load...');
  waitForLoad().then(() => {
    debug('Window loaded!');

    // Restart the calendar when the timezone changes.
    // We do this on a timer because this event may fire
    // many times. Refreshing the url of the calendar frequently
    // can result in crashes so we attempt to do this only after
    // the user has completed their selection.
    debug('Will listen for timezone change...');
    window.addEventListener('moztimechange', () => {
      debug('Noticed timezone change!');
      nextTick(() => app.forceRestart(), app._mozTimeRefreshTimeout);
    });

    app.init();
  });
});

}());

define("main", function(){});
