unit UnitPaste;
{
    Pasting, macro support - including keystrokes
}
interface
uses UnitClipQueue, INIFiles, Classes;

type TPasteMethod = (
    PASTE_CTRL_V=0,
    PASTE_SHIFT_INS=1,
    PASTE_MIMIC=2,
    PASTE_CLIPBOARD=3,
    PASTE_DEFAULT=4,
    //PASTE_PASTEMACRO=5,
    PASTE_PROGRAMCUSTOMMACRO=6
);

type TPasteVariable = (
pv_NONE,
pv_date, pv_wait, pv_prompt, pv_popupitem, pv_clipbrd, pv_clipbrdcurrent, pv_clear, pv_clearpoup,
pv_windowconfig, pv_windowremoved, pv_windowhistory, pv_windowclipboard, pv_windowpermanent,
pv_windowsearch, pv_selectall, pv_selectleft, pv_selectright, pv_windowpastesel,
pv_clipboardonly, pv_left, pv_right, pv_up, pv_down, pv_backspace, pv_home, pv_end,
pv_tab, pv_delete, pv_insert, pv_space, pv_enter, pv_key, pv_cut, pv_copy, pv_paste, pv_run, pv_endrun,
pv_clipboardfind, pv_disablemonitoring, pv_deletepopupclip, pv_trimclipboard,
pv_clipboardupper, pv_clipboardlower, pv_clipboardcapwords, pv_clipboardinverse,
pv_copywait, pv_pushclipboard, pv_popfirst, pv_poplast,
pv_toclipboard, pv_pastedefault, pv_moveclip, pv_waitforclip, pv_totextfile
);

// variables that don't need to send keystrokes to the target program
const
TNoFocusVariables = [
    pv_wait, pv_clear, pv_clearpoup,pv_windowconfig, pv_windowremoved,
    pv_windowhistory, pv_windowclipboard, pv_windowpermanent, pv_windowsearch,
    {pv_run,} pv_endrun, pv_clipboardfind, pv_disablemonitoring, pv_deletepopupclip, pv_trimclipboard,
    pv_clipboardupper, pv_clipboardlower, pv_clipboardcapwords, pv_clipboardinverse,
    pv_copywait, pv_pushclipboard, pv_popfirst, pv_poplast,
    pv_toclipboard, pv_moveclip, pv_waitforclip, pv_totextfile
];

TInsertTextVariables = [
    pv_none, pv_clipbrd, pv_clipbrdcurrent, pv_popupitem
];

TNoFocusClipboardOnlyMode = TNoFocusVariables + TInsertTextVariables;

type TPaste = class(TObject)
    private
        {Configurations for pasting method}
        UseKeyboardMimic,
        UsePastingSI,
        UsePastingCV,
        UseClipboardOnly,
        UseCustomScript,

        {single time use overrides for pasting}
        PasteCVOnce,
        PasteSIOnce,
        ClipboardOnlyOnce,
        KeyboardMimicOnce,
        CustomScriptOnce : boolean;


        EXEPasteList : THashedStringList;

        VariableStart : TStringHash;
        fIsPasting, fIsPastingKeystrokes : Boolean;

        nuggets : TList;
        MacroMimic : boolean;
        MacroNoMonitoring : boolean;
        fMacroRequiresFocus : boolean;
        MacroClipboardState : string;
        MonitoringState : boolean;
        HasEndRun : integer;

        PasteMacro : string;

        procedure ClearMethods;
        procedure ClearNuggets;
        function PutClipOnCLipboard(ci : TClipItem; NoPlaintext:boolean=false) : boolean;
        procedure HandlePasteMethod;
        procedure SendUsingKeyboardMimic(s : WideString);

    public
        constructor Create;
        destructor Destroy; override;
        procedure DefineVariableStart(starttext : string; vartype : TPasteVariable);
        function IsVariable(starttext : string) : boolean;
        function VariableType(starttext : string) : TPasteVariable;
        procedure SendText(s: string; ci  : TClipItem = nil; noPlaintext : boolean = false);

        procedure SendTextWithKeystrokes(maintext : string);
        procedure ParseMacro(maintext : string);
        procedure ExecuteMacro;
        function MacroRequiresFocus : boolean;

        procedure PlaceOnClipboardDontBypassClipboardManager(s : string);
        procedure SendSHIFT_INSERT;
        procedure SendCTRL_V;
        procedure SendCTRL_C;
        procedure SendCTRL_X;        
        procedure SendCTRL_A;
        procedure SendCTRL_Release;
        procedure SendShift_Release;
        procedure SendALT_Release;
        procedure SendKeyCustom(keys : string);
        procedure SendTAB;
        procedure SendENTER;
        procedure SendINSERT;
        procedure SendDELETE;
        procedure SendBACKSPACE;
        procedure SendHOME;
        procedure SendEND;
        procedure SendUP;
        procedure SendDOWN;
        procedure SendDOWNSpecial;
        procedure SendLEFT;
        procedure SendRIGHT;
        procedure SendESC;
        procedure SendSPACE;
        procedure SendCTRL_SHIFT_LEFT;
        procedure SendCTRL_SHIFT_RIGHT;
        procedure SendCTRL_RIGHT;
        {Used by FrmCONFIG to set pasting method}
        procedure SetClipboardOnly;
        function GetClipboardOnly : boolean;
        procedure SetMimicTyping;
        procedure SetUsePaste;
        procedure SetUsePasteSI;
        procedure SetUseCustomScript;

        {Used by FrmMainPopup}
        procedure SetClipboardOnlyOnce;
        procedure SetKeyboardMimicOnce;
        function GetKeyboardMimicOnce : boolean;
        procedure SetUsePasteCVOnce;
        procedure SetUsePasteSIOnce;
        procedure SetUseCustomScriptOnce;
        procedure ClearOnceFlags;
        function GetClipboardOnlyOnce : boolean;

        procedure AssignPaste(EXEName : string; method : TPasteMethod);
        function GetPasteMethod(EXEName : string) : TPasteMethod;
        function GetDefaultPasteMethod : TPasteMethod;
        procedure GetEXEPasteList(var sl : TStringList);

        function IsPasting : boolean;

        procedure SetPasteMacro(macro : string);
end;

var Paste : TPaste;

implementation

uses Windows, SysUtils, StrUtils, UnitFrmMainPopup, UnitPopupGenerate, clipbrd,
    UnitFrmClipboardManager, UnitOtherQueue, UnitMisc, UnitToken, Forms, Dialogs,
  UnitFrmConfig, UnitFrmNewEditHistory, UnitFrmSysTrayMenu, UnitFrmPermanentNew,
  UnitFrmSearch, UnitFrmHotKey, UnitKeyboardQuery, UnitFrmEditTextExternal,
  UnitFrmPasteSelected, System.Character, Generics.Collections, UnitFrmDebug
  ;

const  EXEPASTE_FILE = 'exepaste.ini';
{ TPaste }

type TMacroClipboardList = class(TObject)
    private
        l : TList<string>;
    public
        constructor Create;
        procedure Push;
        procedure PopFirst;
        procedure PopLast;
        procedure Clear;
end;
constructor TMacroClipboardList.Create;
begin
    l := TList<string>.Create;
end;
procedure TMacroClipboardList.Push;
begin
    l.Add( Clipboard.AsText );
end;
procedure TMacroClipboardList.PopFirst;
var result : string;
begin
    result := l.First;
    l.Delete(0);

    ClipBoard.SetTextBuf(pchar(result));
end;
procedure TMacroClipboardList.PopLast;
var result : string;
begin
    result := l.Last;
    l.Delete(l.Count-1);

    ClipBoard.SetTextBuf(pchar(result));
end;
procedure TMacroClipboardList.Clear;
begin
    l.Clear;
end;
var MacroClipboardList : TMacroClipboardList;



procedure TPaste.PlaceOnClipboardDontBypassClipboardManager(s: string);
begin
    frmClipboardManager.DisablePasteProtectionOnce;
    // No clearing, do not prevent the Clipboard from detecting the change
    clipboard.SetTextBuf(PChar(s));
end;

constructor TPaste.Create;
var s : string;
begin
    self.EXEPasteList := THashedStringList.Create;
    s := UnitMisc.GetAppPath;
    s := s + EXEPASTE_FILE;
    if FileExists(s) then begin
        self.EXEPasteList.LoadFromFile(s);
    end;

    VariableStart := TStringHash.Create;
    self.DefineVariableStart('date', pv_date);
    self.DefineVariableStart('wait', pv_wait);
    self.DefineVariableStart('prompt', pv_prompt);
    self.DefineVariableStart('popupitem', pv_popupitem);
    self.DefineVariableStart('clipbrd', pv_clipbrd);
    self.DefineVariableStart('CLIPBRDCURRENT', pv_clipbrdcurrent);
    self.DefineVariableStart('clear', pv_clear);
    self.DefineVariableStart('clearpopup', pv_clearpoup);
    self.DefineVariableStart('windowconfig', pv_windowconfig);
    self.DefineVariableStart('windowremoved', pv_windowremoved);
    self.DefineVariableStart('windowhistory', pv_windowhistory);
    self.DefineVariableStart('windowclipboard', pv_windowclipboard);
    self.DefineVariableStart('windowpermanent', pv_windowpermanent);
    self.DefineVariableStart('windowsearch', pv_windowsearch);
    self.DefineVariableStart('selectall', pv_selectall);
    self.DefineVariableStart('selectleft', pv_selectleft);
    self.DefineVariableStart('selectright', pv_selectright);
    self.DefineVariableStart('windowpastesel', pv_windowpastesel);
    self.DefineVariableStart('clipboardonly', pv_clipboardonly);
    self.DefineVariableStart('left', pv_left);
    self.DefineVariableStart('right', pv_right);
    self.DefineVariableStart('up', pv_up);
    self.DefineVariableStart('down', pv_down);
    self.DefineVariableStart('back', pv_backspace);
    self.DefineVariableStart('home', pv_home);
    self.DefineVariableStart('end', pv_end);
    self.DefineVariableStart('tab', pv_tab);
    self.DefineVariableStart('del', pv_delete);
    self.DefineVariableStart('insert', pv_insert);
    self.DefineVariableStart('space', pv_space);
    self.DefineVariableStart('enter', pv_enter);
    self.DefineVariableStart('key', pv_key);
    self.DefineVariableStart('run', pv_run);
    self.DefineVariableStart('endrun', pv_endrun);

    self.DefineVariableStart('copy', pv_copy);
    self.DefineVariableStart('cut', pv_cut);
    Self.DefineVariableStart('clipboardfind', pv_clipboardfind);
    Self.DefineVariableStart('deleteclip', pv_deletepopupclip);
    self.DefineVariableStart('trimclipboard', pv_trimclipboard);
    self.DefineVariableStart('clipboardupper', pv_clipboardupper);
    self.DefineVariableStart('clipboardlower', pv_clipboardlower);
    self.DefineVariableStart('clipboardcapwords', pv_clipboardcapwords);
    self.DefineVariableStart('clipboardinverse', pv_clipboardinverse);
    self.DefineVariableStart('copywait', pv_copywait);
    self.DefineVariableStart('pushclipboard', pv_pushclipboard);
    self.DefineVariableStart('popfirst', pv_popfirst);
    self.DefineVariableStart('poplast', pv_poplast);
    self.DefineVariableStart('toclipboard', pv_toclipboard);
    self.DefineVariableStart('pastedefault', pv_pastedefault);
    self.DefineVariableStart('moveclip', pv_moveclip);
    self.DefineVariableStart('waitforclip', pv_waitforclip);
    self.DefineVariableStart('totextfile', pv_totextfile);

    nuggets := TList.Create;
end;
destructor TPaste.Destroy;
var s : string;
begin
    s := UnitMisc.GetAppPath;
    s := s + EXEPASTE_FILE;
    self.EXEPasteList.SaveToFile(s);
    MyFree(EXEPasteList);
end;


procedure TPaste.SetPasteMacro(macro: string);
begin
    self.PasteMacro := macro;
end;
//
// Either send text S or use ClipItem if specificed
//

procedure TPaste.SendUsingKeyboardMimic(s : WideString);
var
    i : integer;
    inp : array[0..1] of tagINPUT;
begin
    fillchar(inp[0],sizeof(inp[0]),0);
    fillchar(inp[1],sizeof(inp[1]),0);

    inp[0].Itype := INPUT_KEYBOARD;
    inp[0].ki.dwFlags := KEYEVENTF_UNICODE;
    inp[1] := inp[0];
    inp[1].ki.dwFlags := inp[1].ki.dwFlags or KEYEVENTF_KEYUP;

    for i := 1 to length(s) do begin
        if (s[i]=#13) and ((i+1)<=length(s)) and (s[i+1]=#10) then CONTINUE;
        inp[0].ki.wScan := word(s[i]);
        inp[1].ki.wScan := word(s[i]);
        SendInput(1, inp[0], sizeof(tagINPUT));
        SendInput(1, inp[1], sizeof(tagINPUT));
    end;
end;
function TPaste.IsPasting : boolean;
begin
    result := self.fIsPasting or self.fIsPastingKeystrokes;
end;
function TPaste.PutClipOnClipboard(ci : TClipItem; NoPlaintext:boolean=false) : boolean;
    function PutClipOnCLipboard(ci : TClipItem; Format : word = 0) : boolean;
    var duph : THandle;
        dups : cardinal;
        pc : PChar;
        s : string;
        st : TStream;

        procedure TextOnClipboard(s : ansistring);
        begin
            dups := length(s) + 1;
            //dups := StrSize(s+#0) + 1;
            duph := Windows.GlobalAlloc(GMEM_MOVEABLE or GMEM_ZEROINIT, dups);
            pc := Windows.GlobalLock(duph);
            Windows.MoveMemory(pc, pansichar(s+#0), dups);
            Windows.GlobalUnlock(duph);
            Windows.SetClipboardData(CF_TEXT, duph);

        end;
//    var rawstring : RawByteString;
    begin
        result := false;

        if (Format = CF_TEXT) then begin
            FrmDebug.AppendLog('PutClipOnClipboard: text' );
            s := ci.GetAsPlaintext +#0;
            duph := UnitMisc.DupPointerToHandle(@s[1], length(s) * SizeOf(Char) );
            Windows.SetClipboardData(CF_UNICODETEXT, duph);
        end else begin

            st := ci.GetStream;
            duph := 0;
            if ci.GetFormatType = FT_UNICODE then begin
                FrmDebug.AppendLog('PutClipOnClipboard: text' );
                s := ci.GetAsPlaintext + #0;
                duph := UnitMisc.DupPointerToHandle(@s[1], length(s) * SizeOf(Char) );
            end else if (st.size <> 0) then begin
                FrmDebug.AppendLog('PutClipOnClipboard: format = ' + ci.GetFormatName );
                duph := UnitMisc.DupStreamToHandle(st);
            end else begin
                FrmDebug.AppendLog('SendText: Missing Pointer/Unicode string');
            end;
            ci.FinishedWithStream;

            if (duph <> 0) then begin
                Windows.SetClipboardData(ci.GetFormat, duph);
            end else begin
                FrmDebug.AppendLog('SendText: Unable to dup ClipItem to place on clipboard');
                EXIT;
            end;
        end;

        result := true;
    end;

begin
    result := false;
    //
    // No calls to unit Clipbrd can be used to in this section
    // since it will try to open and already open clipboard.
    // Place both the plain text version and the complex item on the clipboard
    //
    Windows.OpenClipboard(Application.Handle);
    Windows.EmptyClipboard;
    //Clipboard.Clear; // <- Makes use owner
    if not PutClipOnCLipboard(ci) then begin
        Windows.CloseClipboard;
        EXIT;
    end;

    if not noPlaintext then begin
        if ci.HasText and (ci.GetFormat <> Windows.CF_DIB)  then begin
            if not PutClipOnCLipboard(ci, CF_TEXT) then begin
                Windows.CloseClipboard;
                EXIT;
            end;
        end;
    end;

    Windows.CloseClipboard;
    result := true;
end;
procedure TPaste.HandlePasteMethod;
var list : TList;
begin
    // check the PasteOnce options first
    // they override normal pasting settings

    // Attemp Overrides First
    if (self.ClipboardOnlyOnce) then begin
        self.ClipboardOnlyOnce := false;
        FrmDebug.AppendLog('Paste: Clipboard Only');
    end else if (self.PasteCVOnce) then  begin
        self.SendCTRL_V;
        self.PasteCVOnce := false;
        FrmDebug.AppendLog('Paste: CTRL+V Once');
    end else if (self.PasteSIOnce) then  begin
        self.SendSHIFT_INSERT;
        self.PasteSIOnce := false;
        FrmDebug.AppendLog('Paste: Shift Insert once');
    end else if (self.KeyboardMimicOnce) then begin
        SendUsingKeyboardMimic(Clipboard.AsText);
        FrmDebug.AppendLog('Paste: Mimic Type');
        self.KeyboardMimicOnce := false;
    end else if (self.CustomScriptOnce) then begin
        list := nil;

        if (nuggets<>nil) and (nuggets.Count <> 0) then begin
            list := TList.Create;
            list.Assign(nuggets);
            nuggets.Clear; // doesn't free objects
        end;

        FrmDebug.AppendLog('Paste: Custom Script');
        self.SendTextWithKeystrokes('[KEYS]'+self.PasteMacro);

        if (list <> nil) then begin
            nuggets.Assign(list); // add objects back
        end;
    // Use Default - no overrides
    end else if (self.UsePastingCV) then  begin
        self.SendCTRL_V;
        self.PasteCVOnce := false;
        FrmDebug.AppendLog('Paste: CTRL+V');
    end else if (self.UsePastingSI) then  begin
        self.SendSHIFT_INSERT;
        self.PasteSIOnce := false;
        FrmDebug.AppendLog('Paste: Shift Insert');
    end  else if (self.UseKeyboardMimic) then begin
        SendUsingKeyboardMimic(Clipboard.AsText);
        FrmDebug.AppendLog('Paste: Mimic Typing');
        self.KeyboardMimicOnce := false;
    end else if (self.UseClipboardOnly) then begin
        FrmDebug.AppendLog('Paste: Clipboard Only');
    end else if (self.UseCustomScript or self.CustomScriptOnce) then begin

        FrmDebug.AppendLog('Paste: Custom Script');
        self.SendTextWithKeystrokes('[KEYS]'+self.PasteMacro);
    end else begin
        self.SendCTRL_V;
        self.PasteCVOnce := false;
        FrmDebug.AppendLog('Paste: CTRL+V');
    end;
end;
procedure TPaste.SendText(s: string; ci : TClipItem = nil; NoPlaintext : boolean = false);
    {$REGION 'Legacy'}
    {procedure SendUsingKeyboardMimic(s : string);
    var c : char;
        w : smallint;
        i : integer;
        delay : Integer;
        ShiftPressed, EnterPressed, AltPressed, CtrlPressed : boolean;
    begin
        //FrmDebug.AppendLog('mimic typing');
        delay := FrmConfig.GetMimicDelayMS;
        for i := 1 to length(s) do begin
            c := s[i];
            if c=#0 then BREAK; // issue with nulls showing up in text

            w := VkKeyScan(c);
            ShiftPressed := (hi(w) and 1) > 0;
            CtrlPressed := (hi(w) and 2) > 0;   //this is for German/Swiss keyboards with an AltGr (CTLR+ALT) keystroke
            AltPressed := (hi(w) and 4) > 0;


            EnterPressed := (byte(c) = VK_RETURN);
            //VkKeyScan: The first bit of the hi byte set means shift is pressed
            //Ditch LF - assume CR came first
            if (c <> #10) then begin
                if ShiftPressed and (not EnterPressed) then begin
                    keybd_event(VK_SHIFT, 0,0,0);
                end;
                if AltPressed and (not EnterPressed) then begin
                    keybd_event(VK_MENU, 0, 0, 0);
                end;
                //sleep(1);
                if CtrlPressed and (not EnterPressed) then begin
                    keybd_event(VK_CONTROL , 0, 0, 0);
                end;
                //sleep(1);

                //Press and release key
                keybd_event(lo(w), 0, 0, 0);
                sleep(delay);
                keybd_event(lo(w), 0, KEYEVENTF_KEYUP, 0);


                if CtrlPressed and (not EnterPressed) then begin
                    keybd_event(VK_CONTROL, 0, KEYEVENTF_KEYUP, 0);
                end;

                if AltPressed and (not EnterPressed) then begin
                    keybd_event(VK_MENU, 0, KEYEVENTF_KEYUP, 0);
                end;
                if ShiftPressed and (not EnterPressed) then begin
                    //keybd_event(VK_RSHIFT, 0, KEYEVENTF_KEYUP, 0);
                     keybd_event(VK_SHIFT, 0, KEYEVENTF_KEYUP, 0);
                end;

            end;

            if (i mod 10 = 0) then sleep(1); // give the keyboard buffer a little break
        end;
    end; }
    {procedure SendUsingKeyboardMimic2(s : WideString);
    var
        i : integer;
        inp : array[0..1] of tagINPUT;
    begin
        fillchar(inp[0],sizeof(inp[0]),0);
        fillchar(inp[1],sizeof(inp[1]),0);

        inp[0].Itype := INPUT_KEYBOARD;
        inp[0].ki.dwFlags := KEYEVENTF_UNICODE;
        inp[1] := inp[0];
        inp[1].ki.dwFlags := inp[1].ki.dwFlags or KEYEVENTF_KEYUP;

        for i := 1 to length(s) do begin
            inp[0].ki.wScan := word(s[i]);
            inp[1].ki.wScan := word(s[i]);
            SendInput(1, inp[0], sizeof(tagINPUT));
            SendInput(1, inp[1], sizeof(tagINPUT));
        end;
    end; }
    {$ENDREGION}
    procedure PutOnClipboard(s : string);
    var
        duph : THandle;
        s2 : string;
    begin
        if (s <> '') and (s <> #0) then begin
            Windows.OpenClipboard(Application.Handle);
            Windows.EmptyClipboard;

            s2 := s + #0;
            duph := UnitMisc.DupPointerToHandle(@s[1], length(s) * SizeOf(Char) );
            Windows.SetClipboardData(CF_UNICODETEXT, duph);

            Windows.CloseClipboard;
        end;
    end;
    procedure SendUsingPaste(s : string);
    begin
        //
        // place text on clipboard and paste via CTRL+P
        //

        FrmDebug.AppendLog('clearing and placing selected text on clipboard');
//        FrmDebug.AppendLog('---"' + s + '"---');
        PutOnClipboard(s);

        sleep(10);
        if (self.PasteSIOnce) then begin
            Self.SendSHIFT_INSERT;
        end else if (self.PasteCVOnce) then begin
            Self.SendCTRL_V;
        end else if (self.UsePastingCV)  then begin
            Self.SendCTRL_V;
        end else if (self.UsePastingSI) then begin
            Self.SendSHIFT_INSERT;
        end;
    end;
begin
    if (s = '') and (ci = nil) then begin
        self.ClearOnceFlags;
        EXIT;
    end;
    FrmDebug.AppendLog('[Paste Start]');
try
    self.fIsPasting := true;
    s := s + #0;
    UnitMisc.MySleep(FrmConfig.GetPasteDelay);

    // send text using configured method
    // Update: ClipboardOnlyWindow will override and force
    //          a clipboard only operation
    if (ci = nil) then begin
        FrmDebug.AppendLog('Plain text version');
        if (self.UseKeyboardMimic or self.KeyboardMimicOnce) then begin
            FrmDebug.AppendLog('Paste: Mimic');
            SendUsingKeyboardMimic(s);
            self.KeyboardMimicOnce := false;
        end else begin
            Windows.EmptyClipboard;
            PutOnClipboard(s);
            HandlePasteMethod;
        end;
    end else begin
        FrmDebug.AppendLog('complex text version');
        if not self.PutClipOnClipboard(ci, noPlaintext) then EXIT;
        if (self.UseKeyboardMimic or self.KeyboardMimicOnce) then begin
            self.KeyboardMimicOnce := false;
            if not ci.HasText then begin
                self.PasteCVOnce := true;
                HandlePasteMethod;
            end else begin
                SendUsingKeyboardMimic(ci.GetAsPlaintext);
                FrmDebug.AppendLog('Paste: Mimic Type');
            end;
        end else begin
            HandlePasteMethod;
        end;
    end;
finally
    self.fIsPasting := false;
end;


    FrmDebug.AppendLog('[Paste End]');
end;


function SetKeyUp(key : byte; up : boolean = true) : boolean;
begin
    result := false;
    if up then begin
        result := KeyboardQuery.IsPressed(key);
        if result  then begin
            case key of
                VK_CONTROL:
                begin
                    if Keyboardquery.IsPressed(VK_LCONTROL) then begin
                        keybd_event(VK_LCONTROL,0,KEYEVENTF_KEYUP, 0);
                    end else begin
                        keybd_event(VK_RCONTROL,0,KEYEVENTF_KEYUP, 0);
                    end;
                    sleep(15);
                end;
                VK_SHIFT:
                begin
                    if KeyboardQuery.IsPressed(VK_LSHIFT) then begin
                        keybd_event(VK_LSHIFT,0,KEYEVENTF_KEYUP, 0);
                    end else begin
                        keybd_event(VK_RSHIFT,0,KEYEVENTF_KEYUP, 0);
                    end;
                    sleep(15);
                end;
                VK_MENU:
                begin
                    keybd_event(VK_MENU,0,KEYEVENTF_KEYUP, 0);
                    if KeyboardQuery.IsPressed(VK_LMENU) then begin
                        keybd_event(VK_LMENU,0,KEYEVENTF_KEYUP, 0);
                    end else begin
                        keybd_event(VK_RMENU,0,KEYEVENTF_KEYUP, 0);
                    end;
                    sleep(16);
                end;
            else
                begin
                    keybd_event(key,key,KEYEVENTF_KEYUP, 0);
                    sleep(10);
                end;
            end;
        end;
    end else begin
        keybd_event(key,0,0, 0);
        sleep(10);
    end;
end;

//
// used by SendText and OtherItemClickEvent to simulate the user
// pressing CTRL+V to paste
//
procedure TPaste.SendCTRL_V;
var w : word;
begin
    FrmDebug.AppendLog('sending CTRL+V');

    // clear any phantom keystrokes
    keybd_event(VK_SHIFT, VkKeyScan(char(VK_SHIFT)), KEYEVENTF_KEYUP, 0);
    keybd_event(VK_CONTROL , VkKeyScan(char(VK_control)), KEYEVENTF_KEYUP, 0);
    sleep(10);

    // press CTRL, press V, release V, release CTRL
    keybd_event(VK_CONTROL , VkKeyScan(char(VK_control)), 0, 0);
    sleep(10);
            w := VkKeyScan('V');
            keybd_event(lo(w), w, 0, 0);
            sleep(50);

            keybd_event(lo(w), w, KEYEVENTF_KEYUP, 0);
            sleep(50);
    keybd_event(VK_CONTROL , VkKeyScan(char(VK_control)), KEYEVENTF_KEYUP, 0);
    sleep(10);
    FrmDebug.AppendLog('sent CTRL+V');
end;
procedure TPaste.SendCTRL_C;
var w : word;
begin
    FrmDebug.AppendLog('sending CTRL+C');

    // clear any phantom keystrokes
    keybd_event(VK_SHIFT, VkKeyScan(char(VK_SHIFT)), KEYEVENTF_KEYUP, 0);
    keybd_event(VK_CONTROL , VkKeyScan(char(VK_control)), KEYEVENTF_KEYUP, 0);
    sleep(10);

    // press CTRL, press V, release V, release CTRL
    keybd_event(VK_CONTROL , VkKeyScan(char(VK_control)), 0, 0);
    sleep(10);
            w := VkKeyScan('C');
            keybd_event(lo(w), w, 0, 0);
            sleep(10);

            keybd_event(lo(w), w, KEYEVENTF_KEYUP, 0);
            sleep(10);
    keybd_event(VK_CONTROL , VkKeyScan(char(VK_control)), KEYEVENTF_KEYUP, 0);
    //sleep(10);
    FrmDebug.AppendLog('sent CTRL+C');
end;
procedure TPaste.SendCTRL_X;
var w : word;
begin
    FrmDebug.AppendLog('sending CTRL+X');

    // clear any phantom keystrokes
    keybd_event(VK_SHIFT, VkKeyScan(char(VK_SHIFT)), KEYEVENTF_KEYUP, 0);
    keybd_event(VK_CONTROL , VkKeyScan(char(VK_control)), KEYEVENTF_KEYUP, 0);
    sleep(10);

    // press CTRL, press V, release V, release CTRL
    keybd_event(VK_CONTROL , VkKeyScan(char(VK_control)), 0, 0);
    sleep(10);
            w := VkKeyScan('X');
            keybd_event(lo(w), w, 0, 0);
            sleep(10);

            keybd_event(lo(w), w, KEYEVENTF_KEYUP, 0);
            sleep(10);
    keybd_event(VK_CONTROL , VkKeyScan(char(VK_control)), KEYEVENTF_KEYUP, 0);
    //sleep(10);
    FrmDebug.AppendLog('sent CTRL+X');
end;
procedure TPaste.SendCTRL_A;
var w : word;
begin
    FrmDebug.AppendLog('sending CTRL+A');

    // clear any phantom keystrokes
    keybd_event(VK_SHIFT, VkKeyScan(char(VK_SHIFT)), KEYEVENTF_KEYUP, 0);
    keybd_event(VK_CONTROL , VkKeyScan(char(VK_control)), KEYEVENTF_KEYUP, 0);
    sleep(10);

    // press CTRL, press V, release V, release CTRL
    keybd_event(VK_CONTROL , VkKeyScan(char(VK_control)), 0, 0);
    sleep(10);
            w := VkKeyScan('A');
            keybd_event(lo(w), w, 0, 0);
            sleep(50);

            keybd_event(lo(w), w, KEYEVENTF_KEYUP, 0);
            sleep(50);
    keybd_event(VK_CONTROL , VkKeyScan(char(VK_control)), KEYEVENTF_KEYUP, 0);
    sleep(10);
    FrmDebug.AppendLog('sent CTRL+A');
end;

procedure TPaste.SendCTRL_SHIFT_RIGHT;
var w : word;
begin
     // clear any phantom keystrokes
    keybd_event(VK_SHIFT, VkKeyScan(char(VK_SHIFT)), KEYEVENTF_KEYUP, 0);
    keybd_event(VK_CONTROL , VkKeyScan(char(VK_control)), KEYEVENTF_KEYUP, 0);
    sleep(10);

    // press CTRL, press V, release V, release CTRL
    keybd_event(VK_CONTROL , VkKeyScan(char(VK_control)), 0, 0);
    sleep(1);
    keybd_event(VK_SHIFT, Lo(MapVirtualKey(VK_SHIFT,0)),0,0);  // win9x
    sleep(10);
            //w := VkKeyScan('C');
            w := VK_RIGHT;
            keybd_event(lo(w), w, KEYEVENTF_EXTENDEDKEY, 0);
            sleep(10);

            keybd_event(lo(w), w, KEYEVENTF_EXTENDEDKEY or KEYEVENTF_KEYUP, 0);
            sleep(10);
    keybd_event(VK_SHIFT, Lo(MapVirtualKey(VK_SHIFT,0)), KEYEVENTF_KEYUP, 0);
    keybd_event(VK_CONTROL , VkKeyScan(char(VK_control)), KEYEVENTF_KEYUP, 0);

    //sleep(10);
    FrmDebug.AppendLog('sent CTRL+SHIFT+LEFT');
end;
procedure TPaste.SendCTRL_SHIFT_LEFT;
var w : word;
begin
     // clear any phantom keystrokes
    keybd_event(VK_SHIFT, VkKeyScan(char(VK_SHIFT)), KEYEVENTF_KEYUP, 0);
    keybd_event(VK_CONTROL , VkKeyScan(char(VK_control)), KEYEVENTF_KEYUP, 0);
    sleep(10);

    // press CTRL, press V, release V, release CTRL
    keybd_event(VK_CONTROL , VkKeyScan(char(VK_control)), 0, 0);
    sleep(1);
    keybd_event(VK_SHIFT, Lo(MapVirtualKey(VK_SHIFT,0)),0,0);  // win9x
    sleep(10);
            //w := VkKeyScan('C');
            w := VK_LEFT;
            keybd_event(lo(w), w, KEYEVENTF_EXTENDEDKEY, 0);
            sleep(10);

            keybd_event(lo(w), w, KEYEVENTF_EXTENDEDKEY or KEYEVENTF_KEYUP, 0);
            sleep(10);
    keybd_event(VK_SHIFT, Lo(MapVirtualKey(VK_SHIFT,0)), KEYEVENTF_KEYUP, 0);
    keybd_event(VK_CONTROL , VkKeyScan(char(VK_control)), KEYEVENTF_KEYUP, 0);

    //sleep(10);
    FrmDebug.AppendLog('sent CTRL+SHIFT+LEFT');
end;

procedure TPaste.SendCTRL_Release;
begin
	SetKeyUp(VK_CONTROL, true);
end;
procedure TPaste.SendShift_Release;
begin
	SetKeyUp(VK_SHIFT, true);
end;
procedure TPaste.SendALT_Release;
begin
    SetKeyUp(VK_MENU, true);
end;

procedure TPaste.SendKeyCustom(keys: string);
var w : word;
    hk : THotkeydata;
var flags : cardinal;
begin

// These keys require are known to require KEYEVENTF_EXTENDEDKEY
// like for SHIFT+HOME and SHIFT+END
//
//HOME & END
//Left Win 		E0 5B
//Right Win 		E0 5C
//Application 	E0 5D
//ACPI Power 	E0 5E
//ACPI Sleep 	E0 5F
//ACPI Wake 	E0 63
//Numeric / 	E0 35
//Up Arrow 	E0 48
//Dn Arrow 	E0 50
//Page Up 	E0 49
//Page Down 	E0 51
//R Arrow 	E0 4D
//L Arrow 	E0 4B


    hk := FrmHotkey.FromString(keys);
    // unpress mod keys
   { keybd_event(VK_SHIFT, VkKeyScan(char(VK_SHIFT)), KEYEVENTF_KEYUP, 0);
    keybd_event(VK_CONTROL , VkKeyScan(char(VK_control)), KEYEVENTF_KEYUP, 0);
    keybd_event(VK_MENU , VkKeyScan(char(VK_MENU)), KEYEVENTF_KEYUP, 0);
    keybd_event(VK_LWIN, VkKeyScan(char(VK_MENU)), KEYEVENTF_KEYUP, 0);}
    sleep(10);



    // simulate modifiers down
    if hk.win then
        keybd_event(VK_LWIN, VkKeyScan(char(VK_LWIN)), 0, 0);
    sleep(10);
    if hk.alt then
        keybd_event(VK_MENU, VkKeyScan(char(VK_MENU)), 0, 0);
    sleep(10);
    if hk.ctrl then
        keybd_event(VK_CONTROL , VkKeyScan(char(VK_control)), 0, 0);
    sleep(10);
    if hk.shft  then
        keybd_event(VK_SHIFT, Lo(MapVirtualKey(VK_SHIFT,0)),0,0);  // win9x
    sleep(10);

            // main key press
            //w := VkKeyScan('C');
            w := hk.key;

            flags := 0;
            if (hk.key >= ord('A')) and (hk.key <= ord('Z')) then begin
                w := VKKeyScan(char(lo(w)));
            end;
            if hk.key in [VK_LEFT, VK_RIGHT, VK_HOME, VK_END, VK_NEXT, VK_PRIOR, VK_INSERT, VK_DELETE ] then
                flags := KEYEVENTF_EXTENDEDKEY;

            keybd_event(lo(w), w, flags, 0);
            sleep(10);

            keybd_event(lo(w), w, flags or KEYEVENTF_KEYUP, 0);
            sleep(10);
    //keybd_event(VK_SHIFT, Lo(MapVirtualKey(VK_SHIFT,0)), KEYEVENTF_KEYUP, 0);
    //keybd_event(VK_CONTROL , VkKeyScan(char(VK_control)), KEYEVENTF_KEYUP, 0);

    // release modifiers
    if hk.shft then
        keybd_event(VK_SHIFT, VkKeyScan(char(VK_SHIFT)), KEYEVENTF_KEYUP, 0);
    if hk.ctrl then
        keybd_event(VK_CONTROL, VkKeyScan(char(VK_control)), KEYEVENTF_KEYUP, 0);
    if hk.alt then
        keybd_event(VK_MENU, VkKeyScan(char(VK_MENU)), KEYEVENTF_KEYUP, 0);
    if hk.win then
        keybd_event(VK_LWIN, VkKeyScan(char(VK_LWIN)), KEYEVENTF_KEYUP, 0);

    //sleep(10);
    FrmDebug.AppendLog('sent Keystroke ' + hk.name);
end;


procedure TPaste.SendSHIFT_INSERT;
begin
    FrmDebug.AppendLog('sending SHIFT+INSERT');

    // clear any phantom keystrokes
    keybd_event(VK_SHIFT, VkKeyScan(char(VK_SHIFT)), KEYEVENTF_KEYUP, 0);
    keybd_event(VK_CONTROL , VkKeyScan(char(VK_control)), KEYEVENTF_KEYUP, 0);
    sleep(10);

    // press SHIFT, press INSERT, release INSERT, release SHIFT

    // Label VK_INSERT as extended, othewise it freaks out when combined with SHIFT

    keybd_event(VK_SHIFT, Lo(MapVirtualKey(VK_SHIFT,0)),0,0);  // win9x
    sleep(1);
            keybd_event(VK_INSERT, Lo(MapVirtualKey(VK_INSERT,0)),KEYEVENTF_EXTENDEDKEY, 0);
            sleep(1);

            keybd_event(VK_INSERT, Lo(MapVirtualKey(VK_INSERT,0)),KEYEVENTF_EXTENDEDKEY or KEYEVENTF_KEYUP,0);
            sleep(1);

    keybd_event(VK_SHIFT, Lo(MapVirtualKey(VK_SHIFT,0)), KEYEVENTF_KEYUP, 0);
    sleep(5);
    FrmDebug.AppendLog('sent SHIFT+INSERT');
end;
procedure TPaste.SendCTRL_RIGHT;
var w : word;
begin
     // clear any phantom keystrokes
    keybd_event(VK_SHIFT, VkKeyScan(char(VK_SHIFT)), KEYEVENTF_KEYUP, 0);
    keybd_event(VK_CONTROL , VkKeyScan(char(VK_control)), KEYEVENTF_KEYUP, 0);
    sleep(10);

    // press CTRL, press V, release V, release CTRL
    keybd_event(VK_CONTROL , VkKeyScan(char(VK_control)), 0, 0);
    sleep(1);
    //keybd_event(VK_SHIFT, Lo(MapVirtualKey(VK_SHIFT,0)),0,0);  // win9x
    sleep(10);
            //w := VkKeyScan('C');
            w := VK_RIGHT;
            keybd_event(lo(w), w, KEYEVENTF_EXTENDEDKEY, 0);
            sleep(10);

            keybd_event(lo(w), w, KEYEVENTF_EXTENDEDKEY or KEYEVENTF_KEYUP, 0);
            sleep(10);
    //keybd_event(VK_SHIFT, Lo(MapVirtualKey(VK_SHIFT,0)), KEYEVENTF_KEYUP, 0);
    keybd_event(VK_CONTROL , VkKeyScan(char(VK_control)), KEYEVENTF_KEYUP, 0);

    //sleep(10);
    FrmDebug.AppendLog('sent CTRL+SHIFT+LEFT');

end;

procedure TPaste.SendTAB;
begin
    FrmDebug.AppendLog('sending tab');
    keybd_event(VK_TAB , 0, 0, 0);
    sleep(30);

    keybd_event(VK_TAB, 0, KEYEVENTF_KEYUP, 0);
    sleep(10);
    FrmDebug.AppendLog('sent tab');
end;
procedure TPaste.SendDELETE;
begin
    FrmDebug.AppendLog('sending del');
    keybd_event(VK_DELETE, 0, 0, 0);
    sleep(30);

    keybd_event(VK_DELETE, 0, KEYEVENTF_KEYUP, 0);
    sleep(10);
    FrmDebug.AppendLog('sent del');

end;
procedure TPaste.SendINSERT;
begin
    FrmDebug.AppendLog('sending INSERT');
    keybd_event(VK_INSERT, 0, 0, 0);
    sleep(30);

    keybd_event(VK_INSERT, 0, KEYEVENTF_KEYUP, 0);
    sleep(10);
    FrmDebug.AppendLog('sent INSERT');
end;
procedure TPaste.SendENTER;
begin
    FrmDebug.AppendLog('sending ENTER');
    keybd_event(VK_RETURN, MapVirtualKey(VK_RETURN,0), 0, 0);
    sleep(30);

    keybd_event(VK_RETURN, MapVirtualKey(VK_RETURN,0), KEYEVENTF_KEYUP, 0);
    sleep(10);
    FrmDebug.AppendLog('sent ENTER');
end;
procedure TPaste.SendSPACE;
begin
    FrmDebug.AppendLog('sending tab');
    keybd_event(VK_SPACE , 0, 0, 0);
    sleep(30);

    keybd_event(VK_SPACE, 0, KEYEVENTF_KEYUP, 0);
    sleep(10);
    FrmDebug.AppendLog('sending space');
end;

procedure TPaste.ClearMethods;
begin
    self.UseKeyboardMimic := false;
    self.UsePastingSI := false;
    self.UsePastingCV := false;
    self.UseClipboardOnly := false;
    self.UseCustomScript := false;
end;
procedure TPaste.SetClipboardOnly;
begin
    self.ClearMethods;
    self.UseClipboardOnly := true;
end;
procedure TPaste.SetMimicTyping;
begin
    self.ClearMethods;
    self.UseKeyboardMimic := true;
end;
procedure TPaste.SetUsePaste;
begin
    self.ClearMethods;
    self.UsePastingCV := true;
end;
procedure TPaste.SetUsePasteSI;
begin
    self.ClearMethods;
    self.UsePastingSI := true;
end;
procedure TPaste.SetUseCustomScript;
begin
    self.ClearMethods;
    self.UseCustomScript := true;
end;

procedure TPaste.SetKeyboardMimicOnce;
begin
    ClearOnceFlags;
    self.KeyboardMimicOnce := true;
end;
procedure TPaste.SetUsePasteCVOnce;
begin
    ClearOnceFlags;
    self.PasteCVOnce := true;
end;
procedure TPaste.SetUsePasteSIOnce;
begin
    ClearOnceFlags;
    self.PasteSIOnce := true;
end;
procedure TPaste.SetClipboardOnlyOnce;
begin
    ClearOnceFlags;
    FrmDebug.AppendLog('[Paste]: ClipboardOnce set');
    self.ClipboardOnlyOnce := true;
end;
procedure TPaste.SetUseCustomScriptOnce;
begin
    ClearOnceFlags;
    FrmDebug.AppendLog('[Paste]: CustomScriptOnce set');
    self.CustomScriptOnce := true;
end;
function TPaste.GetClipboardOnlyOnce : boolean;
begin
    result := self.ClipboardOnlyOnce;
end;

function TPaste.GetClipboardOnly: boolean;
begin
    result := self.UseClipboardOnly;
end;


function TPaste.GetKeyboardMimicOnce: boolean;
begin
    result := self.UseKeyboardMimic;
end;

type TKeyProc = procedure;
type TNugget = class(TObject)
    vartype : TPasteVariable;
    vartext : string;
end;

//
// Macro Execution
//
procedure TPaste.ClearNuggets;
var i : integer;
    n : TNugget;
begin
    for i := nuggets.Count-1 downto 0 do begin
        n := TNugget(nuggets.Items[i]);
        n.Free;
    end;
    nuggets.Clear;
end;
procedure TPaste.ParseMacro(maintext : string);
var
    {clip,} temps, literaltext, varname, vartext, datastr : string;
    i, j : integer;
    nugget : TNugget;
    nuggettype : TPasteVariable;
    forceclipboard : boolean;
    runmode : boolean;


    procedure DetectContextFreeCommands;
    begin
        forceclipboard := false;
        if ContainsText(maintext,'[CLIPBOARDONLY]') then begin
            self.ClipboardOnlyOnce := true;
            forceclipboard := true;
            maintext := StringReplace(maintext, '[CLIPBOARDONLY]','',[rfIgnoreCase, rfReplaceAll]);
        end;
        if ContainsText(maintext,'[MIMIC]') then begin
            MacroMimic := true;
            maintext := StringReplace(maintext, '[MIMIC]','',[rfIgnoreCase, rfReplaceAll]);
        end;
        MacroNoMonitoring := false;
        if ContainsText(maintext,'[DISABLEMONITORING]') then begin
            MacroNoMonitoring := true;
            maintext := StringReplace(maintext, '[DISABLEMONITORING]','',[rfIgnoreCase, rfReplaceAll]);
            MonitoringState := frmClipboardManager.GetMonitoring;
            frmClipboardManager.SetDisableMonitoring(true);
        end;
    end;
    procedure HandleVariable(varname, vartext : string);
    begin
        // preceeding text is alway a litteral
        if literaltext <> '' then begin
            nugget := TNugget.Create;
            nugget.vartype := pv_NONE;
            nugget.vartext := literaltext;
            literaltext := '';
            nuggets.Add(nugget);
        end;

        nuggettype := self.VariableType(varname);


        // handle the insert variables and convert to literal text
        case nuggettype of
        pv_clipbrd: begin
            nugget := TNugget.Create;
            if RunMode then begin
                nugget.vartype := pv_clipbrd; // need this to be separate for URL encoding
            end else begin
                nugget.vartype := pv_NONE; // this can be concatenated with other literal text
            end;
            nugget.vartext := MacroClipboardState;
        end;
        pv_date: begin  //DATE="mm/yy/ddd"
            datastr := TokenString(vartext, '"', false);
            datastr := TokenString(vartext, '"', false);
            nugget := TNugget.Create;
            nugget.vartype := pv_NONE;
            nugget.vartext := '';
            try
                nugget.vartext := FormatDateTime(datastr, now);
            except
            end;
        end;
        pv_POPUPITEM: begin   //POPUPITEM=X
            datastr := TokenString(vartext, '=', false);
            datastr := vartext;
            //datastr := TokenString(vartext, ']"', false);
            nugget := TNugget.Create;
            nugget.vartype := pv_NONE;
            nugget.vartext := '';
            try
                j := StrToInt(datastr);
                if j < ClipQueue.GetQueueCount then
                    nugget.vartext := ClipQueue.GetItemText( j );
            except
            end;
        end;
        else
            begin
                nugget := TNugget.Create;
                nugget.vartype := nuggettype;
                nugget.vartext := vartext;
            end;
        end;
        nuggets.Add(nugget);
    end;
    procedure HandleLitteral(var literaltext : string; isLast : boolean);
    begin
        if not IsLast then begin
            literaltext := literaltext + '['; // add back removed
        end;

        if literaltext <> '' then begin
            nugget := TNugget.Create;
            nugget.vartype := pv_NONE;
            nugget.vartext := literaltext;
            literaltext := '';
            nuggets.Add(nugget);
        end;

        // litterals sent to the clipboard do not require focus
        fMacroRequiresFocus := fMacroRequiresFocus or not (ClipboardOnlyOnce or UseClipboardOnly);
    end;
begin
    HasEndRun := 0;
    RunMode := false;
    MacroMimic := false;
    DetectContextFreeCommands;

    //
    // turn remaining text into a list of nuggets commands
    //
    self.ClearNuggets;
    temps := maintext;
    MacroClipboardState := Clipboard.AsText;
    literaltext := '';
    fMacroRequiresFocus := false;

    while temps <> '' do begin
        // text ahead of the '[' is always litteral
        literaltext := TokenString(temps,'[', false);

        i := 0;
        while (i<Length(temps)) and
            CharInSet(LowerCase(temps[i+1])[1], ['a'..'z']) do
            Inc(i);
        varname := Copy(temps,1,i);

        if self.IsVariable(varname) then begin

            if literaltext <> '' then begin
                HandleLitteral(literaltext,true);
            end;
            nuggettype := VariableType(varname);
            if (nuggettype = pv_endrun) then begin
                Inc(HasEndRun);
            end;
            if (nuggettype = pv_run) then begin
                runmode := true;
                if not ContainsText(temps,'[endrun]') then begin
                    temps := temps + '[endrun]';
                end;
            end else if (nuggettype = pv_end) then begin
                runmode := false;
            end;

            if (nuggettype = pv_windowsearch) and AnsiStartsText('windowsearch="', temps) then begin
                vartext := TokenString(temps,'"]', false) + '"';
            end else begin
                vartext := TokenString(temps,']', false);
            end;
            HandleVariable(varname, vartext);

            if forceclipboard then begin
                fMacroRequiresFocus := fMacroRequiresFocus or not (nuggettype in TNoFocusClipboardOnlyMode)
            end else begin
                fMacroRequiresFocus := fMacroRequiresFocus or not (nuggettype in TNoFocusVariables)
            end;
        end else begin
            // '[' and following may also be litteral if it's not a variable
            HandleLitteral(literaltext, temps='');
        end;
    end;
end;
function TPaste.MacroRequiresFocus : boolean;
begin
    result := self.fMacroRequiresFocus;
end;
procedure TPaste.ExecuteMacro;
const SLEEPMS = 60;
var
    ShowSearchWindow : boolean;
    pastestr : string;
    prompts : TStringList;
    i : integer;
    nugget : TNugget;
    nuggettype : TPasteVariable;
    StartRun : boolean;
    RunStr : string;
    foreground : THandle;
    RequiresFocusBack : boolean;
    function IsRunMode : boolean;
    begin
        result := StartRun and (HasEndRun<>0);
    end;

    function url_encode(url : string) : string;
    var
    	i: integer;
    begin
        result:='';
        for i := 1 to length(url) do begin
        case url[i] of
        'a'..'z','A'..'Z','0'..'9','/','.','&','-' :
        	result:=result+ url[i];
        else
        	result := result+'%'+uppercase(inttohex(ord(url[i]),2));
        end;
        end;
    end;
    procedure PreKey(pastestr : string);
    var b, b1,b2,b3,b4 : boolean;
        procedure PushFlags;
        begin
            b := self.ClipboardOnlyOnce;
            b1 := self.PasteCVOnce;
            b2 := self.PasteSIOnce;
            b3 := self.KeyboardMimicOnce;
            b4 := self.CustomScriptOnce;
        end;
        procedure PopFlags;
        begin
            self.ClipboardOnlyOnce := b;
            self.PasteCVOnce := b1;
            self.PasteSIOnce := b2;
            self.KeyboardMimicOnce := b3;
            self.CustomScriptOnce := b4;
        end;
    begin
        if pastestr <> '' then begin
            if IsRunMode then begin
                if AnsiStartsText('http:', RunStr) then begin
                    RunStr := RunStr + url_encode(pastestr);
                end else begin
                    RunStr := RunStr + pastestr;
                end;
            end else begin
                frmClipboardManager.IgnoreClipboardOnce;
                PushFlags;
                if MacroMimic then self.KeyboardMimicOnce := true;
                if RequiresFocusBack then begin
                    RequiresFocusBack := false;
                    ForceForeground(foreground);
                end;
                self.SendText(pastestr);
                PopFlags;
                sleep(SLEEPMS);
            end;
        end;
    end;
    procedure PostKey;
    begin
        Application.ProcessMessages;
        pastestr := '';
    end;
    procedure ExecuteNugget(var i : integer; nugget : TNugget; nuggets : TList);
    var
        pastestr, temptoken, temptoken2, before : string;
        j, seq, k : Integer;
        h : THandle;
    begin
        case nugget.vartype of
        pv_NONE: {$region 'pv_none'}
            begin
                // literal text -- concat all text nuggets into a single item
                // TODO:
                // pv_clipbrdcurrent is always them same until a keystroke/command is executed.
                // This is a BUG, but is better left as-is until a proper fix
                // is thought of
                pastestr := nugget.vartext;
                if not IsRunMode then begin
                    while (i+1 < nuggets.count) and
                        (TNugget(nuggets[i+1]).vartype in [pv_NONE, pv_clipbrdcurrent, pv_clipbrd]) do begin
                        Inc(i);
                        nugget := TNugget(nuggets[i]);

                        if nugget.vartype = pv_clipbrdcurrent then begin
                            pastestr := pastestr + Clipboard.AsText;
                        end else begin
                            pastestr := pastestr + nugget.vartext;
                        end;
                    end;
                end else begin
                    // run mode may need to URL encode the CLIPBOARD separately
                    // can't optimize the pasting
                    pastestr := nugget.vartext;
                end;
                PreKey(pastestr);
            end;
            {$endregion}
        pv_run:  {$region 'pv_run'}
            begin // [RUN]...[ENDRUN]
                // run all text items afterwords
                RunStr := '';
                StartRun := true;
            end;
            {$endregion}
        pv_endrun: {$region 'pv_enrun'}
            begin // [RUN]...[ENDRUN]

                Dec(HasEndRun);
                StartRun := false;

                foreground := Windows.GetForegroundWindow;
                FrmDebug.AppendLog('ENDRUN - program=' + UnitMisc.WindowHandleToEXEName(foreground));
                UnitMisc.ShellExecute(FrmMainPopup.Handle, RunStr);

                FrmDebug.AppendLog('ENDRUN - foreground=' + UnitMisc.WindowHandleToEXEName(Windows.GetForegroundWindow));
                if (foreground <> Windows.GetForegroundWindow) then begin
                    RequiresFocusBack := UnitMisc.IsHiddenCommandPrompt(RunStr);
                    FrmDebug.AppendLog('ENDRUN - requiresfocusback='+BoolToStr(RequiresFocusBack));
                end;
            end;
            {$endregion}
        pv_wait:  {$region 'pv_wait'}
            begin //WAIT or WAIT=100
            j := 100;
            if ContainsText(nugget.vartext, '=') then begin
                TokenString(nugget.vartext,'=');
                temptoken := TokenString(nugget.vartext,']');
                try
                    j := StrToInt(temptoken);
                except
                end;
            end;
            sleep(j);
            end;
            {$endregion}
        pv_waitforclip: {$region 'pv_waitforclip'}
            begin
                j := 2000;
                if ContainsText(nugget.vartext, '=') then begin
                    TokenString(nugget.vartext,'=');
                    temptoken := TokenString(nugget.vartext,']');
                    try
                        j := StrToInt(temptoken);
                    except
                    end;
                end;

                k := 0;
                seq := frmClipboardManager.GetSequenceCode;
                while (frmClipboardManager.GetSequenceCode=seq) and
                    (k < j) do begin
                    Application.ProcessMessages; // give the clipboard a chance to work
                    inc(k, 100);
                    sleep(100);
                end;
            end;
            {$endregion}
        pv_totextfile: {$region 'pv_totextfile'}
            begin
                TokenString(nugget.vartext,'"');
                temptoken := TokenString(nugget.vartext,'"');

                if FileExists(temptoken) then begin
                    k := 0;
                    while FileExists(temptoken+'.bak'+IntToStr(k)) do begin
                         inc(k);
                    end;
                    RenameFile(temptoken, temptoken+'.bak'+IntToStr(k))
                end;


                with TStreamWriter.Create(temptoken, false, TEncoding.Unicode) do begin
                    Write(clipboard.astext);
                    Free();
                end;
            end;
            {$endregion}
        pv_prompt: {$region 'pv_prompt'}
            begin    //PROMPT="Prompt Text"
            TokenString(nugget.vartext,'"');
            temptoken := TokenString(nugget.vartext,'"');
            pastestr := prompts.Values[LowerCase(temptoken)];
            if pastestr = '' then begin
                h := GetForegroundWindow;
                ForceForeground(FrmMainPopup.Handle);
                pastestr := InputBox('ArsClip Prompt', temptoken, '');
                if h<>0 then ForceForeground(h);

                prompts.Values[LowerCase(temptoken)] := pastestr;
            end;
            if pastestr <> '' then begin
                PreKey(pastestr);
            end;
        end;
        {$endregion}
        pv_clipboardfind: {$region 'pv_clipboardfind'}
            begin //CLIPBOARDFIND="" REPLACE=""
                // detect \n or \t
                TokenString(nugget.vartext, '"', false);
                temptoken := TokenString(nugget.vartext, '"', false);
                TokenString(nugget.vartext, '"', false);
                temptoken2 := TokenString(nugget.vartext, '"', false);

                pastestr := Clipboard.AsText;
                before := pastestr;
                // auto-detect Unix style or Windows style linefeeds
                if ContainsStr(temptoken,'\n') then begin
                    if ContainsStr(pastestr, #10) then begin
                        if ContainsStr(pastestr, #13) then begin
                            temptoken := StringReplace(temptoken,'\n',#13#10,[rfReplaceAll, rfIgnoreCase]);
                        end else begin
                            temptoken := StringReplace(temptoken,'\n',#10,[rfReplaceAll, rfIgnoreCase]);
                        end;
                    end;
                end;
                temptoken2 := StringReplace(temptoken2,'\t', #9, [rfReplaceAll, rfIgnoreCase]);
                temptoken2 := StringReplace(temptoken2,'\n', #13#10, [rfReplaceAll, rfIgnoreCase]);

                pastestr := StringReplace(pastestr,temptoken,temptoken2,[rfReplaceAll, rfIgnoreCase]);

                if before <> pastestr then
                    Clipboard.SetTextBuf(@pastestr[1]);
            end;
        {$endregion}
        pv_clipboardupper: {$region 'pv_clipboardupper'}
        begin
            pastestr := UpperCase(Clipboard.AsText);
            Clipboard.SetTextBuf(@pastestr[1]);
        end;
        {$endregion}
        pv_clipboardlower: {$region ''}begin
            before := Clipboard.AsText;
            pastestr := LowerCase(before);
            if before <> pastestr then
                Clipboard.SetTextBuf(@pastestr[1]);
        end;
        {$endregion}
        pv_clipboardcapwords: {$region ''}begin
            before := Clipboard.AsText;
            pastestr := UnitToken.CapitalizeWords(before);
            if before <> pastestr then
                Clipboard.SetTextBuf(@pastestr[1]);
        end;
        {$endregion}
        pv_clipboardinverse: {$region ''}begin
            pastestr := Clipboard.AsText;
            before := pastestr;
            for j := 1 to length(pastestr) do begin
                if TCharacter.IsUpper(pastestr[j]) then begin
                    pastestr[j] := TCharacter.ToLower(pastestr[j]);
                end else begin
                    pastestr[j] := TCharacter.ToUpper(pastestr[j]);
                end;
            end;
            if before <> pastestr then
                Clipboard.SetTextBuf(@pastestr[1]);
        end;
        {$endregion}
        pv_popupitem: begin end;
        pv_deletepopupclip: {$region 'pv_deletepopupclip'}begin //
            TokenString(nugget.vartext, '=');
            try
                j := StrToInt(nugget.vartext);
                if j < ClipQueue.GetQueueCount then begin
                    ClipQueue.DeleteItem(j);
                end;
            except
            end;
        end; {$endregion}
        pv_key: begin {$region ''}  //KEY="datahere"
            TokenString(nugget.vartext, '"');
            pastestr := TokenString(nugget.vartext, '"');
            self.SendKeyCustom(pastestr);
        end;  {$endregion}
        pv_clipbrd: begin {$region ''}
            pastestr := nugget.vartext;
            PreKey(pastestr);
        end; {$endregion}
        pv_clipbrdcurrent: {$region ''}begin
            sleep(10); // breathing room for any previous COPY command
            pastestr := clipboard.AsText;
            PreKey(pastestr);
        end;  {$endregion}
        pv_trimclipboard: {$region ''}begin
            frmClipboardManager.IgnoreClipboardOnce;  // TODO: Is this needed?
            before := Clipboard.AsText;
            pastestr := Trim(before);
            if before <> pastestr then
                Clipboard.SetTextBuf(@pastestr[1]);
        end;  {$endregion}
        pv_clear: frmClipboardManager.ClearClipboard(true);
        pv_clearpoup: ClipQueue.ClearQueue;
        pv_windowconfig: {$region ''}begin
            FrmConfig.Show;
            UnitMisc.ForceForeground(FrmConfig.Handle);
        end; {$endregion}
        pv_windowremoved: {$region ''}begin
            frmEditHistory.ShowRemoved;
            UnitMisc.ForceForeground(frmEditHistory.Handle);
        end;  {$endregion}
        pv_windowhistory: {$region ''}begin
            frmEditHistory.ShowRemoved;
            UnitMisc.ForceForeground(frmEditHistory.Handle);
        end; {$endregion}
        pv_windowclipboard: {$region ''}begin
            frmEditTextExternal.EditClipboard;
        end;   {$endregion}
        pv_windowpermanent: {$region ''}begin
            frmPermanent.Show;
            UnitMisc.ForceForeground(frmPermanent.Handle);
        end; {$endregion}
        pv_windowsearch: {$region ''}begin
            if ContainsText(nugget.vartext, '="') then begin
                TokenString(nugget.vartext,'="');
                temptoken := TokenString(nugget.vartext,'"');
                if temptoken<>'' then begin
                    temptoken := StringReplace(temptoken,'[CLIPBRDCURRENT]',clipboard.AsText,[rfIgnoreCase,rfReplaceAll]);
                    temptoken := StringReplace(temptoken,'[CLIPBRD]',MacroClipboardState,[rfIgnoreCase,rfReplaceAll]);
                    frmsearch.txtFind.Text := temptoken;
                end;
            end;
            FrmSearch.ShowAutomatted;
        end;   {$endregion}
        pv_windowpastesel: FrmPasteSelected.ShowaAutomated;
        pv_selectall: Self.SendCTRL_A;
        pv_selectleft: self.SendCTRL_SHIFT_LEFT;
        pv_selectright: self.SendCTRL_SHIFT_RIGHT;
        pv_left: self.SendLEFT;
        pv_right: self.SendRIGHT;
        pv_up: self.SendUP;
        pv_down: self.SendDOWN;
        pv_backspace: self.SendBACKSPACE;
        pv_home: self.SendHOME;
        pv_end: self.SendEND;
        pv_tab: self.SendTAB;
        pv_delete: self.SendDELETE;
        pv_insert: Self.SendINSERT;
        pv_space: self.SendSPACE;
        pv_enter: self.SendENTER;
        pv_cut: self.SendCTRL_X;
        pv_copy: Self.SendCTRL_C;
        pv_copywait: {$region ''}begin
            j := 2000; //default wait time
            if ContainsText(nugget.vartext, '=') then begin
                TokenString(nugget.vartext,'=');
                temptoken := TokenString(nugget.vartext,']');
                try
                    j := StrToInt(temptoken);
                except
                end;
            end;

            // send copy keystroke
            // wait for new clip signal or timer to run out
            k := 0;
            seq := frmClipboardManager.GetSequenceCode;
            Self.SendCTRL_C;

            while (frmClipboardManager.GetSequenceCode=seq) and
                (k < j) do begin
                Application.ProcessMessages; // give the clipboard a chance to work
                inc(k, 100);
                sleep(100);
            end;
        end; {$endregion}
        pv_pushclipboard: MacroClipboardList.Push;
        pv_popfirst: MacroClipboardList.PopFirst;
        pv_poplast: MacroClipboardList.PopLast;
        pv_toclipboard: {$region ''}
            begin
                TokenString(nugget.vartext,'=');
                temptoken := TokenString(nugget.vartext,']');
                try
                    j := StrToInt(temptoken);
                    if j < ClipQueue.GetQueueCount then begin
                        self.PutClipOnCLipboard(ClipQueue.GetClipItem(j));
                    end;
                except
                end;
            end;  {$endregion}
        pv_moveclip:  {$region ''}
            begin   //MOVECLIP="0" TO="1"
                TokenString(nugget.vartext, '"', false);
                temptoken := TokenString(nugget.vartext, '"', false);
                TokenString(nugget.vartext, '"', false);
                temptoken2 := TokenString(nugget.vartext, '"', false);

                try
                    j := StrToInt(temptoken);
                    k := StrToInt(temptoken2);

                    ClipQueue.Move(j, k);
                except
                end;
            end; {$endregion}
        pv_pastedefault: {$region ''}
            begin
                self.HandlePasteMethod;
            end;
        end;  {$endregion}
    end;
begin
    prompts := TStringList.Create;
    ShowSearchWindow := false;
    StartRun := false;
    RunStr := '';
    foreground := 0;
    RequiresFocusBack := false;
    try
        //
        // Execute nugget commands
        //
        i := 0;
        while i < nuggets.Count do begin
            nugget := TNugget(nuggets.items[i]);
            ExecuteNugget(i, nugget, nuggets);
            PostKey;
            inc(i);
        end;
    finally
        if self.ClipboardOnlyOnce  then self.ClipboardOnlyOnce := false;
        if MacroNoMonitoring then begin
            if MonitoringState <> frmClipboardManager.GetMonitoring then begin
                frmClipboardManager.SetDisableMonitoring(not MonitoringState);
            end;
        end;
        MacroClipboardList.Clear;
        self.ClearNuggets;
    end;
end;
procedure TPaste.SendTextWithKeystrokes(maintext: string);
begin
    try
        self.fIsPastingKeystrokes := true;
        UnitMisc.MySleep(FrmConfig.GetPasteDelay);

        // key rid of '[KEYS]'
        maintext := rightstr(maintext,length(maintext) - 6);

        ParseMacro(maintext);
        ExecuteMacro
    finally
        Self.fIsPastingKeystrokes := false;
    end;
end;

procedure TPaste.SendBACKSPACE;
begin
    FrmDebug.AppendLog('sending back');
    keybd_event(VK_BACK , 0, 0, 0);
    sleep(30);

    keybd_event(VK_BACK, 0, KEYEVENTF_KEYUP, 0);
    sleep(10);
    FrmDebug.AppendLog('sent back');
end;
procedure TPaste.SendEND;
begin
    FrmDebug.AppendLog('sending end');
    keybd_event(VK_END  , 0, 0, 0);
    sleep(30);

    keybd_event(VK_END, 0, KEYEVENTF_KEYUP, 0);
    sleep(10);
    FrmDebug.AppendLog('sent end');
end;
procedure TPaste.SendHOME;
begin
    FrmDebug.AppendLog('sending VK_HOME');
    keybd_event(VK_HOME  , 0, 0, 0);
    sleep(30);

    keybd_event(VK_HOME, 0, KEYEVENTF_KEYUP, 0);
    sleep(10);
    FrmDebug.AppendLog('sent VK_HOME');
end;
procedure TPaste.SendDOWN;
begin
     FrmDebug.AppendLog('sending VK_DOWN');
    keybd_event(VK_DOWN   , 0, 0, 0);
    sleep(30);

    keybd_event(VK_DOWN, 0, KEYEVENTF_KEYUP, 0);
    sleep(10);
    FrmDebug.AppendLog('sent VK_DOWN');
end;
procedure TPaste.SendDOWNSpecial;
var lwindown, rwindown : boolean;


begin
    FrmDebug.AppendLog('sending VK_DOWN');

    lwindown := SetKeyUp(VK_LWIN);
    rwindown := SetKeyUp(VK_RWIN);

    keybd_event(VK_DOWN, 0, 0, 0);
    sleep(10);
    keybd_event(VK_DOWN, 0, KEYEVENTF_KEYUP, 0);
    sleep(10);
    if lwindown then SetKeyUp(VK_LWIN, false);
    if rwindown then SetKeyUp(VK_RWIN, false);


    FrmDebug.AppendLog('sent VK_DOWN');
end;
procedure TPaste.SendLEFT;
begin
  FrmDebug.AppendLog('sending VK_LEFT');
    keybd_event(VK_LEFT   , 0, 0, 0);
    sleep(30);

    keybd_event(VK_LEFT, 0, KEYEVENTF_KEYUP, 0);
    sleep(10);
    FrmDebug.AppendLog('sent VK_LEFT');
end;
procedure TPaste.SendRIGHT;
begin
   FrmDebug.AppendLog('sending VK_RIGHT');
    keybd_event(VK_RIGHT   , 0, 0, 0);
    sleep(30);

    keybd_event(VK_RIGHT, 0, KEYEVENTF_KEYUP, 0);
    sleep(10);
    FrmDebug.AppendLog('sent VK_RIGHT');
end;
procedure TPaste.SendUP;
begin
   FrmDebug.AppendLog('sending VK_UP');
    keybd_event(VK_UP   , 0, 0, 0);
    sleep(30);

    keybd_event(VK_UP, 0, KEYEVENTF_KEYUP, 0);
    sleep(10);
    FrmDebug.AppendLog('sent VK_UP');
end;
procedure TPaste.SendESC;
begin
    FrmDebug.AppendLog('sending ESC');
    keybd_event(VK_ESCAPE  , 0, 0, 0);
    sleep(150);

    keybd_event(VK_ESCAPE, 0, KEYEVENTF_KEYUP, 0);
    sleep(30);
end;

procedure TPaste.ClearOnceFlags;
begin
    PasteCVOnce := false;
    PasteSIOnce := false;
    ClipboardOnlyOnce := false;
    KeyboardMimicOnce := false;
    CustomScriptOnce := false;
end;

//
// Assigned Paste Methods
//


procedure TPaste.AssignPaste(EXEName: string; method: TPasteMethod);
begin
    EXEPasteList.Values[EXEName] := IntToStr(Integer(method));
end;
function TPaste.GetPasteMethod(EXEName : string) : TPasteMethod;
var s : string;
begin
    result := PASTE_DEFAULT;
    s := EXEPasteList.Values[EXEName];

    if (s <> '') then begin
        result := TPasteMethod(StrToInt(s));
    end;
end;
function TPaste.GetDefaultPasteMethod: TPasteMethod;
begin
    result := PASTE_DEFAULT; // this case should never fire

    if self.UseKeyboardMimic then begin
        result := PASTE_MIMIC;
    end else if self.UsePastingSI then begin
        result := PASTE_SHIFT_INS;
    end else if self.UsePastingCV then begin
        result := PASTE_CTRL_V;
    end else if self.UseClipboardOnly then begin
        result := PASTE_CLIPBOARD
    end;
end;
procedure TPaste.GetEXEPasteList(var sl : TStringList);
begin
    sl.AddStrings(EXEPasteList); 
end;



procedure TPaste.DefineVariableStart(starttext : string; vartype : TPasteVariable);
begin
    if VariableStart.ValueOf(LowerCase(starttext)) = -1 then begin
        VariableStart.Add(LowerCase(starttext), Integer(vartype));
    end;
end;
function TPaste.IsVariable(starttext : string) : boolean;
begin
    result := VariableStart.ValueOf(LowerCase(starttext)) <> -1;
end;
function TPaste.VariableType(starttext : string) : TPasteVariable;
var i : integer;
begin
    result := pv_NONE;
    i := VariableStart.ValueOf(LowerCase(starttext));
    if i <> -1 then
        Result := TPasteVariable(i);
end;



initialization
begin
    //FrmDebug.AppendLog('TPaste - creating');
    Paste := TPaste.Create;
    MacroClipboardList := TMacroClipboardList.Create;
end;
finalization
begin
    MyFree(MacroClipboardList);
    MyFree(Paste);
end;
end.
