unit UnitFrmPreview;
{
    Purpose:
        Show a preview of a clipboard item
        Allow for easy closing of the window by mouse click or keystroke

    Updates:
        Fix for wordwrap = true not working with scrollbars ssBoth

        New RichText display option

        ----

        Fix for showing the preview on multiple monitors
        ---------------
        Support for Pictures

        Better positioning of Window

        Center Vertically
        
        Keystrokes also will close window
        Preview text is read only
}

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Buttons, ExtCtrls, ComCtrls;

type
  TFrmPreview = class(TForm)
    txtPreview: TMemo;
    imgPreview: TImage;
    Label1: TLabel;
    rePreview: TRichEdit;
    btnEdit: TButton;
    procedure bCloseClick(Sender: TObject);
    procedure txtPreviewClick(Sender: TObject);
    procedure FormClick(Sender: TObject);
    procedure Label1Click(Sender: TObject);
    procedure FormMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure FormKeyPress(Sender: TObject; var Key: Char);
    procedure txtPreviewKeyPress(Sender: TObject; var Key: Char);
    procedure FormShow(Sender: TObject);
    procedure imgPreviewClick(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure rePreviewMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure rePreviewKeyPress(Sender: TObject; var Key: Char);
    procedure btnEditClick(Sender: TObject);
  private
    { Private declarations }
        lastText : string;
  public
    { Public declarations }
        procedure SetText(s : string);
        procedure SetRichText(s : string);
        procedure SetPicture;
  end;

var
  FrmPreview: TFrmPreview;

implementation

uses UnitFrmMainPopup, UnitFrmEditItem;

{$R *.dfm}

procedure TFrmPreview.SetRichText(s: string);
begin
    lastText := s;

    txtPreview.Visible := false;
    imgPreview.Visible := false;
    rePreview.Visible := true;
    rePreview.Lines.Clear;
    rePreview.Text := s;
    btnEdit.visible := true;
end;

procedure TFrmPreview.SetText(s : string);
begin
    lastText := s;

    txtPreview.Text := s;
    txtPreview.Visible := true;
    rePreview.Visible := false;
    imgPreview.Visible := false;
    btnEdit.visible := true;
end;

procedure TFrmPreview.SetPicture;
begin
    txtPreview.Visible := false;
    rePreview.Visible := false;
    imgPreview.Visible := true;
    btnEdit.visible := false;
end;

procedure TFrmPreview.bCloseClick(Sender: TObject);
begin
    self.ModalResult := mrOk;
end;

procedure TFrmPreview.txtPreviewClick(Sender: TObject);
begin
    self.ModalResult := mrok;
end;

procedure TFrmPreview.btnEditClick(Sender: TObject);
begin
    FrmEditItem.Left := self.Left;
    FrmEditItem.Top := Self.top;

    self.ModalResult := mrCancel;
    self.Hide;
    Application.ProcessMessages;

    FrmEditItem.SetText(lastText, FrmEditItem);

    //Windows.SetForegroundWindow(FrmEditItem.Handle);

    Application.ProcessMessages;
    FrmEditItem.ShowModal;
end;

procedure TFrmPreview.FormClick(Sender: TObject);
begin
    self.ModalResult := mrok;
end;

procedure TFrmPreview.Label1Click(Sender: TObject);
begin
    self.ModalResult := mrok;
end;

procedure TFrmPreview.FormMouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
    self.ModalResult := mrok;
end;

procedure TFrmPreview.FormKeyPress(Sender: TObject; var Key: Char);
begin
    self.ModalResult := mrok;
end;

procedure TFrmPreview.txtPreviewKeyPress(Sender: TObject; var Key: Char);
begin
    self.ModalResult := mrok;
end;

procedure TFrmPreview.imgPreviewClick(Sender: TObject);
begin
    self.ModalResult := mrok;
end;


procedure TFrmPreview.FormShow(Sender: TObject);
begin
    //
    // show window just above current mouse position
    // Keep if rom falling off the top of the screen
    //
    self.Top := mouse.CursorPos.Y - 80;
    if (self.top < 0) then self.Top := 0;

    //
    // keep preview from falling off the bottom or right
    // of the screen
    //
    if (self.Top + self.Height) > screen.DesktopHeight then
        self.top := screen.DesktopHeight - self.Height;
    if (self.Left + self.Width) > screen.DesktopWidth then
        self.Left := screen.DesktopWidth - self.Width;

end;


procedure TFrmPreview.FormResize(Sender: TObject);
begin
    self.ModalResult := 0;
end;



procedure TFrmPreview.rePreviewMouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
    self.ModalResult := mrok;
end;

procedure TFrmPreview.rePreviewKeyPress(Sender: TObject; var Key: Char);
begin
    self.ModalResult := mrok;
end;

end.
