unit UnitFrmPermanentEdit;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ExtCtrls, StdCtrls, ComCtrls, Buttons, UnitClipQueue, Menus,
  UnitFrmHotKey, UnitFrmPermanentNew, ImgList;

type
  TFrmPermanentEdit = class(TForm)
    {$REGION 'default'}
    pmGetAs: TPopupMenu;
    PlaintText1: TMenuItem;
    DIBPicture1: TMenuItem;
    CopiedFiles1: TMenuItem;
    RichTExt1: TMenuItem;
    pmSaveGroup: TPopupMenu;
    pnlBottom: TPanel;
    btnCancel: TButton;
    btnSaveGroup: TSpeedButton;
    btnSave: TButton;
    ilPics: TImageList;
    pmInsertKey: TPopupMenu;
    MILeft1: TMenuItem;
    MIRight1: TMenuItem;
    MIUp1: TMenuItem;
    MIDown1: TMenuItem;
    MITab1: TMenuItem;
    MIBackspace1: TMenuItem;
    MIHome1: TMenuItem;
    MIEnd1: TMenuItem;
    MIDelete1: TMenuItem;
    MIInsert1: TMenuItem;
    MISpace1: TMenuItem;
    N1: TMenuItem;
    pmInsertCommands: TPopupMenu;
    MIClear1: TMenuItem;
    MIWait1: TMenuItem;
    MIDate1: TMenuItem;
    MIClipboard1: TMenuItem;
    MIPopupItem1: TMenuItem;
    MIRun1: TMenuItem;
    MIClearPopupClips1: TMenuItem;
    pnlOptional: TPanel;
    pnlTop: TPanel;
    Panel6: TPanel;
    lblCaptionHelp: TLabel;
    Label2: TLabel;
    txtItemName: TEdit;
    Panel5: TPanel;
    Label4: TLabel;
    pnlPreview: TPanel;
    pPreview: TImage;
    reItemText: TRichEdit;
    mItemText: TMemo;
    pmRightClick: TPopupMenu;
    MICut1: TMenuItem;
    MICopy1: TMenuItem;
    MIPaste1: TMenuItem;
    MIDelete2: TMenuItem;
    N3: TMenuItem;
    MISelectAll1: TMenuItem;
    MIPasteAs1: TMenuItem;
    pnlKeys: TPanel;
    Panel8: TPanel;
    cbKeystrokes: TCheckBox;
    Panel9: TPanel;
    Panel10: TPanel;
    btnInsert: TSpeedButton;
    btnCommands: TSpeedButton;
    MIWindows1: TMenuItem;
    MIEditHistory1: TMenuItem;
    MIConfiguration1: TMenuItem;
    MIRemovedClips1: TMenuItem;
    MIEditClipboard1: TMenuItem;
    MIPermanentClips1: TMenuItem;
    MISearch1: TMenuItem;
    pnlDescription: TPanel;
    Shape2: TShape;
    lblCommands: TLabel;
    Shape3: TShape;
    Label1: TLabel;
    MISelectAll2: TMenuItem;
    N4: TMenuItem;
    Copy1: TMenuItem;
    Cut1: TMenuItem;
    MISelectWordLeft1: TMenuItem;
    MISelectWordRight1: TMenuItem;
    MIKeyCombination1: TMenuItem;
    Examples1: TMenuItem;
    MIHighlightCurrentLine1: TMenuItem;
    MIHighlighttoBeginningofPage1: TMenuItem;
    MIHighlightToEnd1: TMenuItem;
    MIDeleteWordRight1: TMenuItem;
    MIDeleteWordLeft1: TMenuItem;
    N5: TMenuItem;
    Examples2: TMenuItem;
    MIGooglesearchClipboard1: TMenuItem;
    MIEditalltextinEditor1: TMenuItem;
    MIClipboardTimestamp1: TMenuItem;
    MIPastethefirst5PopupClips1: TMenuItem;
    InsertClipboard1: TMenuItem;
    MIEnter1: TMenuItem;
    PasteSelected1: TMenuItem;
    ClipboardOnly1: TMenuItem;
    MIPromptforInput1: TMenuItem;
    btnPreview: TSpeedButton;
    ClipboardFindandReplace1: TMenuItem;
    DisableClipboardMonitoring1: TMenuItem;
    DeletePopupClip1: TMenuItem;
    MimicTypingforClip1: TMenuItem;
    ClipboardTrim1: TMenuItem;
    Removedoublelinefeedsfromclipboard1: TMenuItem;
    lblGroup: TLabel;
    EditClipboard1: TMenuItem;
    ReplaceDoubleSpaces1: TMenuItem;
    ReplaceDoubleLinefeeds1: TMenuItem;
    ReplaceTabswithSpaces1: TMenuItem;
    UpperCase1: TMenuItem;
    LowerCase1: TMenuItem;
    CapitalizeWords1: TMenuItem;
    btnMoreToggle: TSpeedButton;
    InverseCase1: TMenuItem;
    RemoevLinefeeds1: TMenuItem;
    CopyandWaitforClip1: TMenuItem;
    PushClipboard1: TMenuItem;
    PopFirsttoClipboard1: TMenuItem;
    PopLasttoClipboard1: TMenuItem;
    emporaryClips1: TMenuItem;
    N7: TMenuItem;
    N8: TMenuItem;
    N9: TMenuItem;
    Insert1: TMenuItem;
    Select1: TMenuItem;
    PasteMode1: TMenuItem;
    N2: TMenuItem;
    PlacePopupCliponClipboard1: TMenuItem;
    PasteDefault1: TMenuItem;
    PopupClips1: TMenuItem;
    MoveClip1: TMenuItem;
    WaitForNewClip1: TMenuItem;
    ClipboardtoTextfile1: TMenuItem;
    procedure cbKeystrokesClick(Sender: TObject);
    procedure btnCancelClick(Sender: TObject);
    procedure btnSaveClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure btnSaveGroupClick(Sender: TObject);
    procedure GroupMenuClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure btnMoreToggleClick(Sender: TObject);
    procedure txtItemNameChange(Sender: TObject);
    procedure MIAllClick(Sender: TObject);
    procedure btnInsertClick(Sender: TObject);
    procedure btnCommandsClick(Sender: TObject);
    procedure txtItemNameEnter(Sender: TObject);
    procedure txtItemNameExit(Sender: TObject);
    procedure MICut1Click(Sender: TObject);
    procedure MICopy1Click(Sender: TObject);
    procedure MIPaste1Click(Sender: TObject);
    procedure MIDelete2Click(Sender: TObject);
    procedure MISelectAll1Click(Sender: TObject);
    procedure pmRightClickPopup(Sender: TObject);
    procedure MIKeyCombination1Click(Sender: TObject);
    procedure MIHighlightCurrentLine1Click(Sender: TObject);
    procedure MIHighlighttoBeginningofPage1Click(Sender: TObject);
    procedure MISelecttobeginning1Click(Sender: TObject);
    procedure MIHighlightToEnd1Click(Sender: TObject);
    procedure MIDeleteWordRight1Click(Sender: TObject);
    procedure MIDeleteWordLeft1Click(Sender: TObject);
    procedure MIGooglesearchClipboard1Click(Sender: TObject);
    procedure MIEditalltextinEditor1Click(Sender: TObject);
    procedure MIClipboardTimestamp1Click(Sender: TObject);
    procedure MIPastethefirst5PopupClips1Click(Sender: TObject);
    procedure btnPreviewClick(Sender: TObject);
    procedure Removedoublelinefeedsfromclipboard1Click(Sender: TObject);
    procedure lblGroupContextPopup(Sender: TObject; MousePos: TPoint;
      var Handled: Boolean);
    procedure mItemTextKeyPress(Sender: TObject; var Key: Char);
    procedure mItemTextKeyUp(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure mItemTextKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    {$ENDREGION}
  private
    { Private declarations }
    clip : TClipItem;
    IsNew : boolean;
    index : integer;
    group : string;
    overridegroup : string;
    clipformat : integer;
    hkd : THotkeyData;

    HasNewData : boolean;
    HasNewCaption: boolean;
    NewDatIsClip : boolean;
    DialogMode : boolean;

    procedure ShowItem(ci : TClipItem); overload;
    procedure UpdateCaret;
  protected
    procedure CreateParams(var Params: TCreateParams); override;
  public
    { Public declarations }
    function ShowForm(
        asnew : boolean;
        group : string; itemindex : integer;hotkey : THotKeyData;
        ci : TClipItem = nil ) : integer; overload;

    function ShowForm(
        asnew : boolean;
        group : string; itemindex : integer;
        ci : TClipItem = nil ) : integer; overload;

    procedure SetNewItem( clip : string; caption :string='' ); overload;

    procedure PopupItemClick(sender : Tobject);

    function ShowAsDialog(var caption : string; var clip : string) : boolean;
  end;

var
  FrmPermanentEdit: TFrmPermanentEdit;

implementation

uses  Clipbrd, UnitMisc, UnitTWideChar, StrUtils, UnitFrmPermanentPreview,
  UnitPaste, ShLwApi, UnitKeyboardQuery, UnitToken;

{$R *.dfm}



procedure TFrmPermanentEdit.cbKeystrokesClick(Sender: TObject);
var i, j : integer;
begin
    for i := 0 to pnlKeys.ControlCount  - 1 do begin
        if  pnlkeys.Controls[i] is TPanel then begin
            for j := 0 to TPanel(pnlkeys.Controls[i]).ControlCount - 1 do   begin
                TPanel(pnlkeys.Controls[i]).Controls[j].Enabled := cbKeystrokes.Checked;
            end;
        end;

    end;

    btnInsert.Enabled :=cbKeystrokes.Checked;
    btnCommands.Enabled :=cbKeystrokes.Checked;
    pnlDescription.Visible :=cbKeystrokes.Checked;
    btnPreview.Enabled := cbKeystrokes.Checked;
end;



procedure TFrmPermanentEdit.CreateParams(var Params: TCreateParams);
begin
    inherited CreateParams(Params);
    // allow context taskbar context menu and
    // show me on the taskbar - independant of main form
    with Params do begin
        ExStyle := ExStyle or WS_EX_APPWINDOW;
        WndParent := FrmPermanent.Handle;
    end;
end;

procedure TFrmPermanentEdit.FormClose(Sender: TObject; var Action: TCloseAction);
begin
    self.HasNewData := false;
    self.NewDatIsClip := false;
    self.HasNewCaption := false;
    FrmPermanentPreview.Hide;
end;
procedure TFrmPermanentEdit.FormCreate(Sender: TObject);
begin
    clip := TClipItem.Create;

    self.clientheight := pnlTop.Height + pnlBottom.height;
    pnlTop.Align := alClient;

    SHAutoComplete(txtItemName.Handle,
        SHACF_AUTOAPPEND_FORCE_OFF or SHACF_AUTOSUGGEST_FORCE_OFF);

{    SHAutoComplete(mItemText.Handle,
        SHACF_AUTOAPPEND_FORCE_OFF or SHACF_AUTOSUGGEST_FORCE_OFF);
 }
end;
procedure TFrmPermanentEdit.FormShow(Sender: TObject);
begin
    //bgOptional.Height := 10;
    self.txtItemName.SetFocus;

    lblGroup.Caption := '&Group [' + self.overridegroup + ']' ;
end;

procedure TFrmPermanentEdit.GroupMenuClick(Sender: TObject);
begin
    self.overridegroup := TMenuItem(sender).caption;
    lblGroup.Caption := '&Group [' +self.overridegroup + ']' ;
end;


function TFrmPermanentEdit.ShowAsDialog(var caption : string; var clip : string) : boolean;
var windowCaption : string;
begin
    self.SetNewItem(clip, caption);
    self.cbKeystrokes.Checked := true;
    self.btnSaveGroup.Enabled := false;
    self.lblGroup.Visible := false;
    DialogMode := true;
    windowCaption := self.Caption;
    self.Caption := 'Edit Macro';
    result := false;
    if self.ShowModal <> mrCancel then begin
        result := true;
        caption := txtItemName.Text;
        clip := mItemText.Text;
    end;
    self.Caption := windowCaption;
    DialogMode := false;
    self.btnSaveGroup.Enabled := true;
    self.lblGroup.Visible := true;
end;





procedure TFrmPermanentEdit.lblGroupContextPopup(Sender: TObject; MousePos: TPoint; var Handled: Boolean);
begin
    btnSaveGroupClick(self);
end;

procedure TFrmPermanentEdit.MIHighlightCurrentLine1Click(Sender: TObject);
begin
    self.Update;
    mItemText.SelText := '[END][KEY="001024SHIFT+HOME"]';
end;
procedure TFrmPermanentEdit.MIHighlighttoBeginningofPage1Click(Sender: TObject);
begin
    self.Update;
    mItemText.SelText := '[KEY="011024CTRL+SHIFT+HOME"]';


end;
procedure TFrmPermanentEdit.MIHighlightToEnd1Click(Sender: TObject);
begin
    self.Update;
    mItemText.SelText := '[KEY="011023CTRL+SHIFT+END"]';
end;
procedure TFrmPermanentEdit.MISelecttobeginning1Click(Sender: TObject);
begin
    self.Update;
    mItemText.SelText := '[END][KEY="001024SHIFT+HOME"]';
end;

procedure TFrmPermanentEdit.mItemTextKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
begin
{    if (key = VK_BACK) and ([ssCtrl]=shift) then begin
        key := 0;
        Paste.SendTextWithKeystrokes('[KEYS][KEY="001025SHIFT+LEFT"][DEL]');
    end;}
end;
procedure TFrmPermanentEdit.mItemTextKeyPress(Sender: TObject; var Key: Char);
begin
    if Key = ^A then begin
        (Sender as TMemo).SelectAll;
        Key := #0;
    end;
{    if (key = #127)  then begin
        key := #0;
    end;}
end;
procedure TFrmPermanentEdit.mItemTextKeyUp(Sender: TObject; var Key: Word; Shift: TShiftState);
begin
{    if (key = VK_BACK) and ([ssCtrl]=shift) then begin
        key := 0;
    end;}
end;

procedure TFrmPermanentEdit.btnInsertClick(Sender: TObject);
var p : TPoint;
begin
    p := btnInsert.Parent.ClientToScreen(Point(btnInsert.Left, btnInsert.top));
    pmInsertKey.Popup(p.X+btnInsert.Width, p.y);
end;
procedure TFrmPermanentEdit.btnCommandsClick(Sender: TObject);
var p : TPoint;
begin
    p := btnCommands.Parent.ClientToScreen(Point(btnCommands.Left, btnCommands.top));
    pmInsertCommands.Popup(p.X+btnCommands.Width, p.y);
end;




procedure TFrmPermanentEdit.SetNewItem(clip : string; caption :string='' );
begin
    self.HasNewData := true;
    self.mItemText.text := clip;

    self.txtItemName.Text := caption;
    self.HasNewCaption := true;

    self.clipformat := CF_TEXT;
    self.NewDatIsClip := false;
end;



function TFrmPermanentEdit.ShowForm(asnew : boolean; group: string; itemindex: integer; ci : TClipItem = nil  ) : integer;
var hk : THotkeyData;
begin
    hk.name := EMPTY_HOTKEY_NAME;
    self.ShowForm(asnew,group,itemindex,hk,ci);

    result := 0; // not used yet
end;

function TFrmPermanentEdit.ShowForm(
        asnew : boolean;
        group : string; itemindex : integer;hotkey : THotKeyData;
        ci : TClipItem = nil ) : integer;
var s : string;
    prefix : string;
procedure RefreshPopup;
    var i : integer;
    cur, s : string;
    mi : TMenuItem;
begin
    pmSaveGroup.Items.Clear;
    if self.overridegroup = '' then self.overridegroup := self.group;
    cur := self.overridegroup;

    for i  := 0 to FrmPermanent.PermFoldersGetCount - 1 do begin
        s := FrmPermanent.PermFoldersGetItem(i);
        mi := pmSaveGroup.CreateMenuItem;
        mi.Caption := s;
        if (s = cur) then begin
            mi.Checked := true;
        end;
        mi.OnClick := self.GroupMenuClick;

        pmSaveGroup.Items.add(mi);
    end;
end;

begin
    self.overridegroup := group;

    FrmPermanent.PermFolderPush;
    clip.GetClipboardItem(0);

    mItemText.Visible := false;
    reItemText.Visible := false;
    pPreview.Visible := false;

    self.IsNew := asnew;
    self.index := ItemIndex;
    self.group := group;
    self.clipformat := CF_TEXT;
    cbKeystrokes.Checked := false;
    self.hkd := hotkey;
//    lblKeyname.Caption := hkd.name;
    FrmPermanent.SetPermanentPath(group);

    if self.IsNew then begin
        if not self.HasNewCaption  then begin
            txtItemName.text := '';
        end;
        if not self.HasNewData then begin
            self.clipformat := CF_TEXT;
            mItemText.Lines.clear;
        end else begin
            if FrmPermanent.IsComplexItem(mItemText.Text) then begin
                ci := FrmPermanent.GetComplexItem(mItemText.text);
                self.clipformat := ci.GetFormat;
            end;
        end;
        mItemText.Visible := true;
//        lblKeyname.Caption := EMPTY_HOTKEY_NAME;
        if (ci <> nil) then begin
            self.ShowItem(ci);
            MyFree(clip);
            clip := ci;
        end;
    end else begin
//        lblKeyname.caption := hotkey.name;
        s := FrmPermanent.GetItemText(self.index);
        if FrmPermanent.IsComplexItem(s) then begin
            ci := FrmPermanent.GetComplexItem(s);
            self.ShowItem(ci);
            MyFree(clip);
            self.clip := ci;
        end else begin
            txtItemName.text := '';
            mItemText.Lines.clear;
            mItemText.Visible := true;
            mItemText.Text := s;
        end;
        txtItemName.text := FrmPermanent.GetItemName(self.index);

        prefix := uppercase(leftstr(mItemText.Text,6));
        cbKeystrokes.Checked :=  prefix = '[KEYS]';
        if cbKeystrokes.Checked then begin
            s := mItemText.Text;
            delete(s,1,6);
            mItemText.Text := s;
        end;
    end;
    FrmPermanent.PermFolderPop;
    result := self.ShowModal;
end;



procedure TFrmPermanentEdit.btnSaveGroupClick(Sender: TObject);
var i : integer;
    cur, s : string;
    mi : TMenuItem;
    var p : TPoint;
begin
    pmSaveGroup.Items.Clear;
    if self.overridegroup = '' then self.overridegroup := self.group;
    cur := self.overridegroup;

    for i  := 0 to FrmPermanent.PermFoldersGetCount - 1 do begin
        s := FrmPermanent.PermFoldersGetItem(i);
        mi := pmSaveGroup.CreateMenuItem;
        mi.Caption := s;
        if (s = cur) then begin
            mi.Checked := true;
        end;
        mi.OnClick := self.GroupMenuClick;

        pmSaveGroup.Items.add(mi);
    end;

    p := btnSaveGroup.Parent.ClientToScreen(Point(btnSaveGroup.Left, btnSaveGroup.top));
    pmSaveGroup.Popup(p.X+btnSaveGroup.Width, p.y);
end;

procedure TFrmPermanentEdit.txtItemNameChange(Sender: TObject);
begin
    if not DialogMode then begin
        btnsave.Enabled := txtItemName.Text <> '';
        btnSaveGroup.Enabled := btnsave.Enabled;
        lblGroup.Enabled := btnSave.Enabled;
    end else begin
        btnsave.Enabled := (txtItemName.Text <> '') and (mItemText.Text<>'');
    end;
end;
procedure TFrmPermanentEdit.txtItemNameEnter(Sender: TObject);
begin
    if not DialogMode then
        lblCaptionHelp.Visible := true;
end;
procedure TFrmPermanentEdit.txtItemNameExit(Sender: TObject);
begin
    lblCaptionHelp.Visible := false;
end;

procedure TFrmPermanentEdit.btnMoreToggleClick(Sender: TObject);
begin
    if btnMoreToggle.caption = '&More' then begin
        btnMoreToggle.caption := 'L&ess';
        btnMoreToggle.Glyph := nil;
        ilPics.GetBitmap(1, btnMoreToggle.Glyph );

        pnlOptional.Visible := true;
        pnlOptional.Top := pnlBottom.Top - pnlOptional.Height;

        self.clientheight := self.ClientHeight + pnlOptional.height;
    end else begin
        btnMoreToggle.caption := '&More';

        pnlOptional.visible := false;
        self.clientheight := self.ClientHeight - pnlOptional.height;

        btnMoreToggle.Glyph := nil;
        ilPics.GetBitmap(0, btnMoreToggle.Glyph );
    end;
end;
procedure TFrmPermanentEdit.btnPreviewClick(Sender: TObject);
var
    s,s2,token : string;
begin
    FrmPermanentPreview.Top := self.Top;
    FrmPermanentPreview.Left := self.Left + self.Width;
    FrmPermanentPreview.Visible := true;
    FrmPermanentPreview.reText.Text := '';

    ForceForeground(FrmPermanentPreview.Handle);

    s := uppercase(mItemText.text);
    s2 := TokenString(s,'[INDEX=',false);
    if (s<>'') then begin
        //[INDEX=$i]
        token := TokenString(s,']',false);
        s := mItemText.text;
        s := StringReplace(s,'[index='+token+']', '',[rfReplaceAll,rfIgnoreCase]);
        s := StringReplace(s,token, IntToStr(0),[rfReplaceAll,rfIgnoreCase]);
    end else begin
        s := mItemText.text;
    end;
    if ContainsText(s,'[STAYOPEN]') then begin
        s := StringReplace(s,'[STAYOPEN]', '',[rfReplaceAll,rfIgnoreCase]);
    end;

    Paste.SendTextWithKeystrokes('[KEYS]'+s);
end;
procedure TFrmPermanentEdit.btnSaveClick(Sender: TObject);
var c : TClipItem;
begin
    if not DialogMode then begin
        c := nil;
        if self.clipformat <> CF_TEXT then c := self.clip;

        // if the group changed, just save to the end of the list
        if (self.group <> self.overridegroup) then begin
            self.index := -1;
            self.group := self.overridegroup;
        end;


        if (self.IsNew) then begin
            FrmPermanent.SaveNewItem(
                self.group,txtItemName.Text,mItemText.Text,
                hkd,cbKeystrokes.checked,c
            );
        end else begin
            FrmPermanent.SaveItem(
                self.group,self.index, txtItemName.Text,mItemText.Text,
                hkd,cbKeystrokes.checked,c
            );
        end;
    end;
    self.ModalResult := mrOK;
end;
procedure TFrmPermanentEdit.btnCancelClick(Sender: TObject);
begin
    self.ModalResult := mrCancel;
end;
procedure TFrmPermanentEdit.Button1Click(Sender: TObject);
var btn : TButton;
begin
    btn := TButton(sender);
    self.Update;

    if (btn.caption = 'DATE') then begin
        mItemText.SelText := '[' + btn.Caption + '="mm/dd/yyyy"]';
    end else if (btn.caption = 'POPUPITEM') then begin
        mItemText.SelText := '[' + btn.Caption + '="0"]';
    end else begin
        mItemText.SelText := '[' + btn.Caption + ']';
    end;

end;


procedure TFrmPermanentEdit.MIAllClick(Sender: TObject);
var mi : TMenuItem;
    s : string;
begin
    mi := TMenuItem(sender);
    s := uppercase(mi.Caption);

    self.Update;


    if (s = 'DATE') then begin
        mItemText.SelText := '[DATE="mm/dd/yyyy"]';
    end else if (s = 'WAIT') then begin
        mItemText.SelText := '[WAIT=100]';
    end else if (AnsiStartsText('SHOW PROMPT',s)) then begin
        mItemText.SelText := '[PROMPT="Enter Data"]';

    end else if (s = 'POPUPITEM') then begin
        mItemText.SelText := '[POPUPITEM="0"]';
    end else if (AnsiStartsText('POPUPCLIP', s)) then begin
        mItemText.SelText := '[POPUPITEM=0]';

    end else if (s= 'BACKSPACE') then begin
        mItemText.SelText := '[BACK]';
    end else if (s= 'DELETE') then begin
        mItemText.SelText := '[DEL]';
    end else if (s= 'DATE') then begin
        mItemText.SelText := '[DATE="mm/dd/yyyy"]';
    end else if (AnsiStartsText('CLIPBOARD STATE', s)) then begin
        mItemText.SelText := '[CLIPBRD]';
    end else if (AnsiStartsText('CURRENT CLIPBOARD', s)) then begin
        mItemText.SelText := '[CLIPBRDCURRENT]';
    end else if (s= 'DELETE CLIPBOARD') then begin
        mItemText.SelText := '[CLEAR]';
        end else if (s= 'CONFIGURATION') then begin
            mItemText.SelText := '[WINDOWCONFIG]';
        end else if (s= 'EDIT HISTORY') then begin
            mItemText.SelText := '[WINDOWHISTORY]';
        end else if (s= 'REMOVED CLIPS') then begin
            mItemText.SelText := '[WINDOWREMOVED]';
        end else if (s= 'EDIT CLIPBOARD') then begin
            mItemText.SelText := '[WINDOWCLIPBOARD]';
        end else if (s= 'PERMANENT CLIPS') then begin
            mItemText.SelText := '[WINDOWPERMANENT]';
        end else if (s= 'SEARCH AND PASTE') then begin
            mItemText.SelText := '[WINDOWSEARCH=""]';
    end else if (s= 'ALL') then begin
        mItemText.SelText := '[SELECTALL]';
    end else if (s= 'WORD LEFT') then begin
        mItemText.SelText := '[SELECTLEFT]';
    end else if (s= 'WORD RIGHT') then begin
        mItemText.SelText := '[SELECTRIGHT]';
     end else if (s= 'PASTE SELECTED') then begin
        mItemText.SelText := '[WINDOWPASTESEL]';
    end else if (AnsiStartsText('CLIPBOARD ONLY', s)) then begin
    	mItemText.seltext := '[CLIPBOARDONLY]';
    end else if (s = 'FIND AND REPLACE') then begin
        mItemText.SelText := '[CLIPBOARDFIND="" REPLACE=""]';
    end else if (s = 'REPLACE DOUBLE SPACES') then begin
        mItemText.SelText := '[CLIPBOARDFIND="  " REPLACE=" "]';
    end else if (s = 'REPLACE DOUBLE LINEFEEDS') then begin
        mItemText.SelText := '[CLIPBOARDFIND="\n\n" REPLACE="\n"]';
    end else if (s = 'REPLACE TABS WITH SPACES') then begin
        mItemText.SelText := '[CLIPBOARDFIND="\t" REPLACE="    "]';
    end else if (s = 'REMOVE LINEFEEDS') then begin
        mItemText.SelText := '[CLIPBOARDFIND="\n" REPLACE=""]';
        end else if (s = 'UPPER CASE') then begin
        mItemText.SelText := '[CLIPBOARDUPPER]';
        end else if (s = 'LOWER CASE') then begin
        mItemText.SelText := '[CLIPBOARDLOWER]';
        end else if (s = 'CAPITALIZE WORDS') then begin
        mItemText.SelText := '[CLIPBOARDCAPWORDS]';
        end else if (s = 'INVERSE CASE') then begin
        mItemText.SelText := '[CLIPBOARDINVERSE]';
    end else if (AnsiStartsText('DISABLE CLIP', s)) then begin
        mItemText.SelText := '[DISABLEMONITORING]';
    end else if (AnsiStartsText('MIMIC TYPING', s)) then begin
        mItemText.SelText := '[MIMIC]';
    end else if (AnsiStartsText('TRIM', s)) then begin
        mItemText.SelText := '[TRIMCLIPBOARD]';
    end else if (AnsiStartsText('COPY AND', s)) then begin
        mItemText.SelText := '[COPYWAIT=2000]';
    end else if (s = 'PUSH CLIPBOARD') then begin
        mItemText.SelText := '[PUSHCLIPBOARD]';
    end else if (AnsiStartsText('POP FIRST', s)) then begin
        mItemText.SelText := '[POPFIRST]';
    end else if (AnsiStartsText('POP LAST', s)) then begin
        mItemText.SelText := '[POPLAST]';
    end else if (AnsiStartsText('PASTE', s)) then begin
        mItemText.SelText := '[PASTEDEFAULT]';

    {Popup Clips}
    end else if (s= 'DELETE CLIP') then begin
        mItemText.SelText := '[DELETECLIP=0]';
    end else if (s= 'DELETE ALL CLIPS') then begin
        mItemText.SelText := '[CLEARPOPUP]';
    end else if (AnsiStartsText('PLACE CLIP', s)) then begin
        mItemText.SelText := '[TOCLIPBOARD=0]';
    end else if (s= 'MOVE CLIP') then begin
        mItemText.SelText := '[MOVECLIP="0" TO="1"]';

    end else if (s='RUN') then begin
        mItemText.SelText := '[RUN][ENDRUN]';

    end else if s = 'WAIT FOR NEW CLIP' then begin
        mItemText.SelText := '[WAITFORCLIP]';
    end else if s = 'CLIPBOARD TO TEXTFILE' then begin
        mItemText.SelText := '[TOTEXTFILE=""]';
    end else begin
        mItemText.SelText := '[' + s + ']';
    end;
end;
procedure TFrmPermanentEdit.MIKeyCombination1Click(Sender: TObject);
var hkd : THotkeyData;
begin
    if FrmHotkey.GetHotkey(
        hkd.alt, hkd.shft, hkd.ctrl, hkd.win,
        hkd.key,
        hkd.name
    ) then begin

       self.Update;


       mItemText.seltext := '[KEY="'+ frmHotkey.toHKstring(hkd)  +'"]';
    end;
end;

procedure TFrmPermanentEdit.MICopy1Click(Sender: TObject);
begin
    mItemText.CopyToClipboard;
end;
procedure TFrmPermanentEdit.MICut1Click(Sender: TObject);
begin
    mItemText.CutToClipboard;
end;
procedure TFrmPermanentEdit.MIDelete2Click(Sender: TObject);
begin
    mItemText.SelText := '';
end;
procedure TFrmPermanentEdit.MIDeleteWordLeft1Click(Sender: TObject);
begin
    self.Update;
    mItemText.SelText := '[KEY="010008CTRL+BACKSPACE"]';
end;
procedure TFrmPermanentEdit.MIDeleteWordRight1Click(Sender: TObject);
begin
    self.Update;
    mItemText.SelText := '[KEY="01002ECTRL+DELETE"]';
end;
procedure TFrmPermanentEdit.MIPaste1Click(Sender: TObject);
begin
    mItemText.PasteFromClipboard;
end;

procedure TFrmPermanentEdit.UpdateCaret;
begin
    if (mItemText.SelStart = 0) and (mItemText.SelLength = 0) then
        mItemTExt.SelStart := length(mItemText.Text);
end;

procedure TFrmPermanentEdit.MIGooglesearchClipboard1Click(Sender: TObject);
begin
    self.Update;
    mItemText.SelText := '[RUN]http://www.google.com/search?q=[CLIPBRD]';

end;
procedure TFrmPermanentEdit.MIEditalltextinEditor1Click(Sender: TObject);
begin
    self.Update;
    mItemText.SelText := '[SELECTALL][COPY][WINDOWCLIPBOARD]';

end;
procedure TFrmPermanentEdit.MIClipboardTimestamp1Click(Sender: TObject);
begin
self.Update;

    mItemText.SelText := '[DATE="hh:mm ampm"]: [CLIPBRD]';
end;
procedure TFrmPermanentEdit.MIPastethefirst5PopupClips1Click(Sender: TObject);
begin
self.Update;
    mItemText.SelText := '[POPUPITEM=0]' + #13#10 +
    '[POPUPITEM=1]' + #13#10 +
    '[POPUPITEM=2]' + #13#10 +
    '[POPUPITEM=3]' + #13#10 +
    '[POPUPITEM=4]';
end;

procedure TFrmPermanentEdit.Removedoublelinefeedsfromclipboard1Click(Sender: TObject);
begin
  self.Update;
    mItemText.SelText := '[CLIPBOARDFIND="\n\n" REPLACE="\n"]';
end;


procedure TFrmPermanentEdit.MISelectAll1Click(Sender: TObject);
begin
    mItemText.SelectAll;
end;

procedure TFrmPermanentEdit.pmRightClickPopup(Sender: TObject);
    procedure AddFormat(format : integer; description : string);
    var mi : TMenuItem;
    begin
        if Clipbrd.clipboard.HasFormat(format) then begin
            mi := TMenuItem.Create(MIPasteAs1);
            mi.Caption := description;
            mi.Hint := IntToStr(format);
            mi.OnClick := self.PopupItemClick;
            MIPasteAs1.Add(mi);
        end;

    end;

begin
    if mItemText.Visible then begin
        MISelectAll1.Enabled := mItemText.text <> '';
        MIDelete2.Enabled := mItemText.SelText <> '';
        MICut1.Enabled := MIDelete2.Enabled;
        MICopy1.Enabled := MIDelete2.Enabled;
    end else begin
        MISelectAll1.Enabled := false;
        MIDelete2.Enabled := false;
        MICut1.Enabled := false;
        MICopy1.Enabled := false;
    end;

    MIPasteAs1.Clear;
    AddFormat(CF_TEXT, 'Plain Text');
    AddFormat(CF_WAVE, 'Wave Audio');
    AddFormat(CF_DIB, 'DIB (Picture)');
    AddFormat(CF_HDROP, 'File(s)');
    AddFormat(UnitMisc.GetCF_RICHTEXT, 'RichText');
    AddFormat(UnitMisc.GetCF_HTML, 'HTML');
    AddFormat(CF_UNICODETEXT, 'Unicode');

end;
procedure TFrmPermanentEdit.PopupItemClick(sender: Tobject);
begin
    with sender as TMenuItem do begin
        clipformat := SysUtils.StrToInt(Hint);
    end;
    clip.GetClipboardItem(0, clipformat);

    self.ShowItem(clip);
end;


procedure TFrmPermanentEdit.ShowItem(ci: TClipItem);
var
  wc: TWideChar;
  r : TRect;
  s : string;
begin
    pPreview.Visible := false;
    mItemText.Visible := false;
    reItemText.Visible := false;

    clipformat := ci.getformat;



    if (ci.GetFormat = Windows.CF_DIB) then begin
        pPreview.Visible := true;
        ci.GetDIB(pPreview.Picture);
    end else if (ci.GetFormat = unitmisc.GetCF_RICHTEXT)
        or (ci.GetFormat = unitmisc.GetCF_HTML) then begin
        reItemText.Visible := true;
        reItemText.PlainText := false;
        reItemText.Lines.Clear;
        if ci.GetFormatType = FT_HTML then begin
            ci.GetUTF8Text(s);
        end else begin
            ci.GetRichText(s);
        end;
        reItemText.Text := s;
    end else if (ci.GetFormatType = FT_FILE) then begin
        reItemText.Visible := true;
        reItemText.PlainText := true;
        reItemText.Lines.Clear;
        reItemText.Text := ci.GetAsPlaintext;

    end else if (ci.GetFormat = Windows.CF_UNICODETEXT) then begin

        pPreview.Visible := true;
        wc := TWideChar.Create;
        wc.AppendUnicode(ci.GetAsPlaintext);


        pPreview.Canvas.textflags := pPreview.Canvas.textflags or DT_WORDBREAK and (not DT_SINGLELINE);
        r := pPreview.ClientRect;
        FillRect(pPreview.Canvas.handle,r,pPreview.Canvas.brush.handle);
        DrawTextW(
            pPreview.Canvas.handle, wc.memory, (wc.size-2) div 2,
            r, DT_WORDBREAK
        );

        myfree(wc);
    end else begin
        clipformat := CF_TEXT;
        mItemText.Visible := true;
        mitemtext.Text := Clipboard.AsText;
    end;
end;

end.
