unit UnitFrmJumpList;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ShellAPI, ShlOBJ, INIFiles{for THashedStringList};

type
  TFrmJumpList = class(TForm)
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    procedure HandleTaskArgument(arg : string);
    function IsTaskArgument(arg : string) : boolean;
  end;

var
  FrmJumpList: TFrmJumpList;
type TTaskArg = (ARG_CONFIG, ARG_REFRESH, ARG_PERM, ARG_HIST, ARG_CLIP, ARG_REMOVE, ARG_SEARCH);
implementation

uses UnitMisc, UnitDestinationList, UnitTaskArray, Clipbrd, TypInfo, UnitFrmSysTrayMenu,
  UnitFrmPermanentEdit, UnitFrmSearch, UnitPaste, UnitFrmClipboardManager,
  UnitPopupGenerate, UnitFrmConfig, UnitFrmEditItem, UnitFrmDebug;

{$R *.dfm}


procedure TFrmJumpList.FormCreate(Sender: TObject);
var
    dl : TDestinationList;
    ta : TTaskArray;

    function AC(arg : TTaskArg) : string;
    begin
        result := TypInfo.GetEnumName(TypeInfo(TTaskArg), Integer(arg));
    end;
begin
    if CheckWin32Version(6,1) then begin
        FrmDebug.AppendLog('Jumplist Support');
        dl := TDestinationList.Create;
        ta := TTaskArray.Create;

        ta.AddShellLink('Configuration',AC(ARG_CONFIG), Application.ExeName,2);
        //ta.AddShellLink('Refresh Clipboard Monitor',AC(ARG_REFRESH), '', 0);
        // ZERO need for this with the new clipboard monitor
        
        ta.AddShellLink('-','','',0);
        ta.AddShellLink('Permanent Clips / Macros ...',AC(ARG_PERM), Application.ExeName, 7);
        ta.AddShellLink('Removed Clips ...',AC(ARG_REMOVE), Application.ExeName, 8);

        ta.AddShellLink('Edit History ...',AC(ARG_HIST), Application.ExeName, 3);
        ta.AddShellLink('Edit Clipboard ...',AC(ARG_CLIP), Application.ExeName, 6);

        ta.AddShellLink('Search ...',AC(ARG_SEARCH), Application.ExeName, 9);

        dl.BeginUpdate;
        dl.AddUserTasks(ta);
        dl.EndUpdate;
    end;
end;

    {
    mimic only what's needed from the system tray popup (eg below)
    |=================|
    | Configure       |
    | Refresh Clipboard Monitor |>|
    |-----------------|
    | Permenant Clips |
    | Switch to... |> |
    |-----------------|
    | Flush |>        |
    | Edit History    |
    | Edit Clipboard..|
    | Removed Items...|
    |-----------------|
    | About           |
    | Exit            |
    |=================|
    }


    function StringToArg(s : string) : TTaskArg;
    begin
        result := TTaskArg(GetEnumValue(TypeInfo(TTaskArg), s));
    end;


procedure TFrmJumpList.HandleTaskArgument(arg: string);
var b : boolean;
begin
    case StringToArg(arg) of
    ARG_CONFIG:
        begin
            frmConfig.show;
            ForceForeground(frmConfig.Handle);
        end;
    ARG_REFRESH:
        begin
            frmSysTrayMenu.RefreshMenuItemClickEvent(self);
        end;
    ARG_PERM:
        begin
            frmSysTrayMenu.PermanentClipsMenuItemClickEvent(self);
        end;
    ARG_HIST:
        begin
            frmSysTrayMenu.EditHistoryMenuItemClickEvent(self);
        end;
    ARG_CLIP:
        begin
            frmSysTrayMenu.EditClipboardMenuItemClickEvent(self);
        end;
    ARG_REMOVE:
        begin
            frmSysTrayMenu.RemovedItemsMenuItemClickEvent(self);
        end;
    ARG_SEARCH:
        begin
            Frmsearch.ShowAutomattedPasteOnly;
        end;
    end;

    If StringToArg(arg) <> ARG_CONFIG then begin
        b := ThreadAttach(GetForegroundWindow());
        SetForegroundWindow(FrmMainPopup.Handle);
        if b then ThreadDetach;
    end else begin
    end;
end;

function TFrmJumpList.IsTaskArgument(arg: string): boolean;
begin
    result := Integer(StringToArg(arg)) <> -1;
end;

end.
