unit UnitFolderWriteTest;

interface

uses Forms, Dialogs, SysUtils, Windows, UnitMisc;

type TFolderWriteTest = class

        err : integer;
        lasterr : string;
    public
        function CurrentFolder : string;
        function CanWrite : boolean;
        function IsDesktop : boolean;
end;

var FolderWriteTest : TFolderWriteTest;
implementation


{ TFolderWriteTest }

function TFolderWriteTest.CanWrite: boolean;
var f : file;
    name : string;

begin
    result := false;

    name :=  self.CurrentFolder + 'TestFile.txt';
    try
        assign(f,name);
        rewrite(f);
        close(f);
        SysUtils.DeleteFile(name);
        result := true;
    except
        lasterr := SysErrorMessage(GetLastError);
        //self.err := IOResult;
    end;


end;

function TFolderWriteTest.CurrentFolder: string;
begin
    result := UnitMisc.GetAppPath;
end;

function TFolderWriteTest.IsDesktop: boolean;
var folder : string;
begin
    folder := ExtractFileName(ExcludeTrailingPathDelimiter(self.CurrentFolder));
    result :=  lowercase(folder) = 'desktop';
end;

initialization
begin
    FolderWriteTest := TFolderWriteTest.create();
    if not FolderWriteTest.CanWrite  then begin
        ShowMessage('Error: ' + FolderWRiteTest.lasterr + #13#10#13#10 +
                    'Cannot create files in the location: '#13#10 +
                     FolderWriteTest.CurrentFolder  + #13#10
                    );
        Application.Terminate;
        ExitProcess(1);        
    end;


    if FolderWriteTest.IsDesktop then begin
        ShowMessage('This executable cannot be run directly from the Desktop.');

        Application.Terminate;
        ExitProcess(1);
    end;
end;
end.
