// Persistence of Vision Ray Tracer Scene Description File
// File: test.pov
// Vers: 3.5
// Desc: Produced by AnkerCAD
// Date: 21.09.2006
//

#version 3.5;

#include "acBlocks.inc"

#declare USE_RADIOSITY = 0;

global_settings {
  assumed_gamma 1.4
#if (USE_RADIOSITY)
  ambient_light 0
  max_trace_level 25
  adc_bailout 1/150
  radiosity {
    pretrace_start 0.08
    pretrace_end 0.01
    count 300
    error_bound 0.1
    recursion_limit 1
  }
#end
}

// ----------------------------------------

#if (USE_RADIOSITY)
  sky_sphere {
    pigment {
      gradient y
      color_map {
        [0.5 rgb 1.25]
        [1 rgb <.5,.7,1>*1.1]
      }
    }
  }
#else
  sky_sphere {
    pigment {
      gradient y
      color_map {
        [0.0 rgb <0.6,0.7,1.0>]
        [0.7 rgb <0.0,0.1,0.8>]
      }
    }
  }

#end

light_source {
  <0,2000,5000>
  color rgb 0.55*<1, 1, 1>
}

light_source { // At the same pos as the camera
  <9396,6840,16275>
  color rgb 0.35*<1, 1, 1>
  shadowless
}
light_source { <0, 5000000, 0> color 0.5 shadowless }
// ----------------------------------------

plane {
  y, -0.1
#if (USE_RADIOSITY)
  pigment { color rgb <0.7,0.5,0.3>*0.5 }
#else
  pigment { color rgb <0.7,0.5,0.3> }
#end
}

camera {
  location <9396,6840,16275>
  direction 1.5*z
  right     -x*image_width/image_height
  look_at   <-99999, -99999, -99999>
  angle 3
#if (USE_RADIOSITY)
  focal_point <150,-50,-150>
  aperture 25
  blur_samples 70
  variance 1/1000 //even better: 0.0
#end
}

