#include "colors.inc"
#include "textures.inc"
#include "transforms.inc"

#ifndef (USE_RADIOSITY)
  #declare USE_RADIOSITY = 0;
#end

#if (USE_RADIOSITY)
  #declare AMB = 0.1;
  #declare DIF = 0.9;
  #declare BMP = 0.5;
  #declare INT = 0.5;
#else
  #declare AMB = 0.25;
  #declare DIF = 0.7;
  #declare BMP = 0.5;
  #declare INT = 1.0;
#end

#macro ColorX(R,G,B)  
  texture {
	  pigment { rgb INT/1.3*<R, G, B> }
	  finish { ambient AMB diffuse DIF }
  normal {bumps BMP}
  }
#end

#declare Color1 = material { // Yellow
  texture {
	  pigment { rgb INT*<0.85, 0.67, 0.37> }
	  finish { ambient AMB diffuse DIF }
  normal {bumps BMP / 2}
  }
}

#declare Color2 = material { // Red
  texture {
	  pigment { rgb INT*<0.62, 0.30, 0.20> }
	  finish { ambient AMB diffuse DIF }
  normal {bumps BMP / 2}
  }
}

#declare Color3 = material { // Blue
  texture {
	  pigment { rgb INT*<0.24, 0.25, 0.30> }
	  finish { ambient AMB diffuse DIF }
  normal {bumps BMP}
  }
}

#declare Color3m = material { // Blue metallic (Bridge)
  texture {
	  pigment { rgb INT*<0.10, 0.15, 0.40> }
	  finish { ambient AMB diffuse DIF metallic reflection 0.1}
    normal {bumps 0.4 scale 12} 
  }
}

#declare Color5m = material { // Brown  metallic (Bridge)
  texture {
	  pigment { rgb INT*<0.50, 0.25, 0> }
	  finish { ambient AMB diffuse DIF metallic reflection 0.1}
    normal {bumps 0.4 scale 12} 
  }
}

#declare ColorTin = material { // Tin metallic (Bridge)
  texture {
	  pigment { rgb INT*<0.45, 0.45, 0.45> }
	  finish { ambient AMB diffuse DIF metallic reflection 0.2}
    normal {bumps 0.4 scale 12} 
  }
}

#declare Cs = 1.5;
#declare Bs = 2;

//------------------------------------------------------------------

#macro MovedTo(NewObject) 
  object { NewObject }
#end

//------------------------------------------------------------------

#macro UnitCyl(Height, Radius) object {
  union {
    cone {<Radius*40, 0, Radius*40>,  Radius*40-Cs,  <Radius*40, Cs, Radius*40>, Radius*40}
    cylinder {<Radius*40, Cs, Radius*40>,  <Radius*40, Height*80-Cs, Radius*40>,  Radius*40}
    cone {<Radius*40, Height*80-Cs, Radius*40>,  Radius*40,  <Radius*40, Height*80, Radius*40>, Radius*40-Cs}
  }
}
#end

#macro UnitBlock(Length, Width, Height)
#local r = 20;
#local r2 = r/sqrt(2)-1;
#local r3 = r/sqrt(3)-1.5;
object {
                              
  
  difference {
    box {<0, 0, 0> <Length*80, Height*80, Width*80>}

    cylinder {<-1,-r2,-r2> <Length*80+1,-r2,-r2> r}
    cylinder {<-1,Height*80+r2,-r2> <Length*80+1,Height*80+r2,-r2> r}
    cylinder {<-r2,-1,-r2> <-r2,Height*80+1,-r2> r}
    cylinder {<Length*80+r2,-1,-r2> <Length*80+r2,Height*80+1,-r2> r}

    cylinder {<-1,-r2,Width*80+r2> <Length*80+1,-r2,Width*80+r2> r}
    cylinder {<-1,Height*80+r2,Width*80+r2> <Length*80+1,Height*80+r2,Width*80+r2> r}
    cylinder {<-r2,-1,Width*80+r2> <-r2,Height*80+1,Width*80+r2> r}
    cylinder {<Length*80+r2,-1,Width*80+r2> <Length*80+r2,Height*80+1,Width*80+r2> r}

    cylinder {<-r2,-r2,-1> <-r2,-r2,Width*80+1> r}
    cylinder {<Length*80+r2,-r2,-1> <Length*80+r2,-r2,Width*80+1> r}
    cylinder {<-r2,Height*80+r2,-1> <-r2,Height*80+r2,Width*80+1> r}
    cylinder {<Length*80+r2,Height*80+r2,-1> <Length*80+r2,Height*80+r2,Width*80+1> r}


    sphere {<-r3, -r3, -r3> r+0.5}
    sphere {<Length*80+r3, -r3, -r3> r+0.5}
    sphere {<-r3, Height*80+r3, -r3> r+0.5}
    sphere {<Length*80+r3, Height*80+r3, -r3> r+0.5}

    sphere {<-r3, -r3, Width*80+r3> r+0.5}
    sphere {<Length*80+r3, -r3, Width*80+r3> r+0.5}
    sphere {<-r3, Height*80+r3, Width*80+r3> r+0.5}
    sphere {<Length*80+r3, Height*80+r3, Width*80+r3> r+0.5}
    
  }
}
#end

#macro UnitBlock_r(Length, Width, Height) // No rounded edges on the right side
#local r = 20;
#local r2 = r/sqrt(2)-1;
#local r3 = r/sqrt(3)-1.5;
object {
                              
  
  difference {
    box {<0, 0, 0> <Length*80, Height*80, Width*80>}

    cylinder {<-1,-r2,-r2> <Length*80+1,-r2,-r2> r}
    cylinder {<-1,Height*80+r2,-r2> <Length*80+1,Height*80+r2,-r2> r}
    cylinder {<-r2,-1,-r2> <-r2,Height*80+1,-r2> r}
//    cylinder {<Length*80+r2,-1,-r2> <Length*80+r2,Height*80+1,-r2> r}

    cylinder {<-1,-r2,Width*80+r2> <Length*80+1,-r2,Width*80+r2> r}
    cylinder {<-1,Height*80+r2,Width*80+r2> <Length*80+1,Height*80+r2,Width*80+r2> r}
    cylinder {<-r2,-1,Width*80+r2> <-r2,Height*80+1,Width*80+r2> r}
//    cylinder {<Length*80+r2,-1,Width*80+r2> <Length*80+r2,Height*80+1,Width*80+r2> r}

    cylinder {<-r2,-r2,-1> <-r2,-r2,Width*80+1> r}
//    cylinder {<Length*80+r2,-r2,-1> <Length*80+r2,-r2,Width*80+1> r}
    cylinder {<-r2,Height*80+r2,-1> <-r2,Height*80+r2,Width*80+1> r}
//    cylinder {<Length*80+r2,Height*80+r2,-1> <Length*80+r2,Height*80+r2,Width*80+1> r}


    sphere {<-r3, -r3, -r3> r+0.5}
//    sphere {<Length*80+r3, -r3, -r3> r+0.5}
    sphere {<-r3, Height*80+r3, -r3> r+0.5}
//    sphere {<Length*80+r3, Height*80+r3, -r3> r+0.5}

    sphere {<-r3, -r3, Width*80+r3> r+0.5}
//    sphere {<Length*80+r3, -r3, Width*80+r3> r+0.5}
    sphere {<-r3, Height*80+r3, Width*80+r3> r+0.5}
//    sphere {<Length*80+r3, Height*80+r3, Width*80+r3> r+0.5}
    
  }
}
#end

#macro UnitTriangleBlock(Length, Width, Height)
#local r = 20;
#local r2 = r/sqrt(2)-1;
#local r3 = r/sqrt(3)-1.5;
object {

  difference {
    prism {0, Width*80, 4, < 0, 0>, < Length*80,  0>, < Length*80, Height*80>, < 0,  0> rotate -90*x translate Width*80*z}
    cylinder {<-1,-r2,-r2> <Length*80+1,-r2,-r2> r}
    cylinder {<Length*80+r2,-1,-r2> <Length*80+r2,Height*80+1,-r2> r}
    cylinder {<-1,-r2,Width*80+r2> <Length*80+1,-r2,Width*80+r2> r}
    cylinder {<Length*80+r2,-1,Width*80+r2> <Length*80+r2,Height*80+1,Width*80+r2> r}
    cylinder {<-r2,-r2,-1> <-r2,-r2,Width*80+1> r}
    cylinder {<Length*80+r2,-r2,-1> <Length*80+r2,-r2,Width*80+1> r}
    cylinder {<Length*80+r2,Height*80+r2,-1> <Length*80+r2,Height*80+r2,Width*80+1> r}

//    cylinder {<-r2,0,-r2> <Length*80+r2,Height*80,-r2> r}
//    cylinder {<-r2,0,Width*80+r2> <Length*80+r2,Height*80,Width*80+r2> r}

    sphere {<-r3, -r3, -r3> r}
    sphere {<Length*80+r3, -r3, -r3> r}
    sphere {<Length*80+r3, Height*80+r3, -r3> r}

    sphere {<-r3, -r3, Width*80+r3> r}
    sphere {<Length*80+r3, -r3, Width*80+r3> r}
    sphere {<Length*80+r3, Height*80+r3, Width*80+r3> r}
  }
 rotate 90*y translate 80*z
}
#end

//------------------------------------------------------------------

#macro UnitRoofCorner(Length, Width, Height)
#local r = 20;
#local r2 = r/sqrt(2)-1;
#local r3 = r/sqrt(3)-1.5;
object {

  difference {
    prism {conic_sweep linear_spline 0, 1, 5, < 0, 0>, < 1,  0>, <1, 1>, <0, 1>, < 0,  0>
      rotate <180, 90, 0>
      translate <1, 1, 1>
      scale <Length*80, Height*80, Width*80>
    }
    cylinder {<-1,-r2,-r2> <Length*80+1,-r2,-r2> r}
    cylinder {<Length*80+r2,-1,Width*80+r2> <Length*80+r2,Height*80+1,Width*80+r2> r}
    cylinder {<Length*80+r2,-r2,-1> <Length*80+r2,-r2,Width*80+1> r}
    cylinder {<-r2,r2/2,Width*80+r2> <Length*80+1,Height*80+r2+r2/2,Width*80+r2> r}
    cylinder {<-1,-r2,Width*80+r2> <Length*80+1,-r2,Width*80+r2> r}
    cylinder {<-r2,-r2,-1> <-r2,-r2,Width*80+1> r}
    cylinder {<Length*80+r2,-1,-r2> <Length*80+r2,Height*80+1,Width*80-r2> r2}
    cylinder {<-r2,r2/2,-r2> <Length*80+1,Height*80+r2+r2/2,Width*80+1> r2}
    sphere {<-r3, -r3, -r3> r}
    sphere {<Length*80+r3, -r3, -r3> r}
    sphere {<Length*80+r3, Height*80+r3, -r3> r}
    sphere {<Length*80+r3, Height*80+r3, Width*80+r3> r}
    sphere {<-r3, -r3, Width*80+r3> r}
    sphere {<Length*80+r3, -r3, Width*80+r3> r}
  }
  rotate <0, 180, 0>
  translate <80, 0, 80>
}
#end

//------------------------------------------------------------------

#macro UnitRoofTop(bLength, tLength, bWidth, tWidth, Height)
#local r = 20;
#local r2 = r/sqrt(2)-1;
#local r3 = r/sqrt(3)-1.5;
#local bL8 = bLength * 80;
#local tL8 = tLength * 80;
#local dL8 = (bL8 - tL8) / 2;
#local bW8 = bWidth * 80;
#local tW8 = tWidth * 80;
#local dW8 = (bW8 - tW8) / 2; 
#local H8 = Height * 80;

// Not solid, so we can not cut away the edges...
  //    polygon { 4, <0, 0, 0>, <0, 0, bW8>, <bL8, 0, bW8>, <bL8, 0, 0> }
  //    polygon { 4, <0, 0, 0>, <bL8, 0, 0>, <bL8-dL8, H8, dW8>, <0+dL8, H8, dW8> }
  //    polygon { 4, <0, 0, bW8>, <bL8, 0, bW8>, <bL8-dL8, H8, bW8-dW8>, <0+dL8, H8, bW8-dW8> }
  //    polygon { 4, <0, 0, 0>, <0, 0, bW8>, <0+dL8, H8, bW8-dW8>, <0+dL8, H8, dW8>}
  //    polygon { 4, <bL8, 0, 0>, <bL8, 0, bW8>, <bL8-dL8, H8, bW8-dW8>, <bL8-dL8, H8, dW8>}
  //    polygon { 4, <dL8, H8, dW8>, <dL8, H8, bW8-dW8>, <bL8-dL8, H8, bW8-dW8>, <bL8-dL8, H8, dW8> }
// But a solid mesh can!
object {
  difference {
    mesh {
      triangle { <0, 0, 0>, <0, 0, bW8>, <bL8, 0, bW8> }
      triangle { <bL8, 0, bW8>, <bL8, 0, 0>, <0, 0, 0> }
      triangle { <0, 0, 0>, <bL8, 0, 0>, <bL8-dL8, H8, dW8> }
      triangle { <bL8-dL8, H8, dW8>, <0+dL8, H8, dW8>, <0, 0, 0> }
      triangle { <0, 0, bW8>, <bL8, 0, bW8>, <bL8-dL8, H8, bW8-dW8> }
      triangle { <bL8-dL8, H8, bW8-dW8>, <0+dL8, H8, bW8-dW8>, <0, 0, bW8> }
      triangle { <0, 0, 0>, <0, 0, bW8>, <0+dL8, H8, bW8-dW8> }
      triangle { <0+dL8, H8, bW8-dW8>, <0+dL8, H8, dW8>, <0, 0, 0>}
      triangle { <bL8, 0, 0>, <bL8, 0, bW8>, <bL8-dL8, H8, bW8-dW8>}
      triangle { <bL8-dL8, H8, bW8-dW8>, <bL8-dL8, H8, dW8>, <bL8, 0, 0>}
      triangle { <dL8, H8, dW8>, <dL8, H8, bW8-dW8>, <bL8-dL8, H8, bW8-dW8> }
      triangle { <bL8-dL8, H8, bW8-dW8>, <bL8-dL8, H8, dW8>, <dL8, H8, dW8> }
      inside_vector <0, 0, 1>
    }
    cylinder {<-1,-r2,-r2> <bL8+1,-r2,-r2> r}
    cylinder {<bL8+r2,-r2,-1> <bL8+r2,-r2,bW8+1> r}
    cylinder {<-1,-r2,bW8+r2> <bL8+1,-r2,bW8+r2> r}
    cylinder {<-r2,-r2,-1> <-r2,-r2,bW8+1> r}
    sphere {<-r3, -r3, -r3> r}
    sphere {<bL8+r3, -r3, -r3> r}
    sphere {<-r3, -r3, bW8+r3> r}
    sphere {<bL8+r3, -r3, bW8+r3> r}
  }
}
#end
                               
//------------------------------------------------------------------

#macro UnitHalfArc(Length, Width, Height, Radius) object {
#local r = 20;
#local r2 = r/sqrt(2)-2;
#local r3 = r/sqrt(3)-2;
#local As = Bs*1.5;
  difference {
      UnitBlock(Length, Width, Height)
      cylinder {<(Length-Radius)*80+r2,-r2,-1> <(Length-Radius)*80+r2,-r2,Width*80+1> r}
      cylinder {<Length*80+r2,Radius*80-r2,-1> <Length*80+r2,Radius*80-r2,Width*80+1> r}
      cone {<Length*80, 0, -As>,  Radius*80+As+As,  <Length*80, 0, As>, Radius*80-As+As}
      cone {<Length*80, 0, Width*80+As>,  Radius*80+As+As,  <Length*80, 0, Width*80-As>, Radius*80-As+As}
      cylinder {<Length*80, 0, -1>,  <Length*80, 0, Width*80+1>,  Radius*80} 
  }       
}
#end

#macro G95Pat(Width) 
  #local r = 1.5;
  #local R2 = 2.5;
  
  object {
  difference {

      UnitHalfArc(2.5, Width, 2.5, 1.5)
      cylinder {<0, 200-40, 0> <80, 200-40, 0> r}
      cylinder {<0, 200-40, Width*80> <80, 200-40, Width*80> r}
      cylinder {<80, 200-40, 0> <80, 200, 0> r}
      cylinder {<80, 200-40, Width*80> <80, 200, Width*80> r}
      cylinder {<0, 200-80, 0> <40, 200-80, 0> r}
      cylinder {<0, 200-80, Width*80> <40, 200-80, Width*80> r}
      cylinder {<0, 80, 0> <17, 80, 0> r}
      cylinder {<0, 80, Width*80> <17, 80, Width*80> r}

      cylinder {<8, 55, 0> <200, 0, 0> r}
      cylinder {<8, 55, Width*80> <200, 0, Width*80> r}
      cylinder {<30, 106, 0> <200, 0, 0> r}
      cylinder {<30, 106, Width*80> <200, 0, Width*80> r}
      cylinder {<66, 149, 0> <200, 0, 0> r}
      cylinder {<66, 149, Width*80> <200, 0, Width*80> r}
      cylinder {<112, 180, 0> <200, 0, 0> r}
      cylinder {<112, 180, Width*80> <200, 0, Width*80> r}
      cylinder {<165, 197, 0> <200, 0, 0> r}
      cylinder {<165, 197, Width*80> <200, 0, Width*80> r}

      object {torus {R2*80, r} rotate <90, 0, 0> translate <R2*80, 0, Width*80>} 
      object {torus {R2*80, r} rotate <90, 0, 0> translate <R2*80, 0, 0>} 
  }       
}
#end

#macro G95aPat(Width) 
  #local r = 1.5;
  #local r2 = 20;
  #local r3 = 13;
  
  object {
  difference {
      union {
        object {UnitBlock(2, Width, 1)}
        object {UnitBlock(2, Width, 1.25) translate <40, 60, 0>}
        object {UnitBlock(1.5, Width, 1) translate <80, 120, 0>}
      }
      cylinder {<200, 0, -1> <200, 0, Width*80+1> 120}
      object {torus {120, r} rotate <90, 0, 0> translate <120+80, 0, Width*80>} 
      object {torus {120, r} rotate <90, 0, 0> translate <120+80, 0, 0>} 
      cylinder {<80+r3, 0-r3, -1> <80+r3, 0-r3, Width*80+1> 20}
      cylinder {<200+r3, 120-r3, -1> <200+r3, 120-r3, Width*80+1> 20}
      cylinder {<40, 80, Width*80> <84, 31, Width*80> r}
      cylinder {<80, 160, Width*80> <123, 92, Width*80> r}
      cylinder {<160, 200, Width*80> <175, 117, Width*80> r}
  }       
}
#end

#macro G101Pat(Width) 
  #local r = 1.5;
  #local R2 = 1.5;
  
  object {
  difference {
      UnitHalfArc(1.5, Width, 2, 1)

      cylinder {<12, 51, 0> <120, 0, 0> r}
      cylinder {<43, 92, 0> <120, 0, 0> r}
      cylinder {<89, 116, 0> <120, 0, 0> r}

      object {torus {R2*80, r} rotate <90, 0, 0> translate <R2*80, 0, 0>} 
    }       
    scale <1, 1, -1>
    translate 80*z
  }
#end

#macro G101aPat(Width) 
  #local r = 1.5;
  #local r2 = 20;
  #local r3 = 13;
  
  object {
  difference {
      union {
        object {UnitBlock(1.5, Width, 1)}
        object {UnitBlock(1, Width, 1.25) translate <40, 60, 0>}
      }
      cylinder {<120, 0, -1> <120, 0, Width*80+1> 80}
      object {torus {80, r} rotate <90, 0, 0> translate <40+80, 0, Width*80>} 
      object {torus {80, r} rotate <90, 0, 0> translate <40+80, 0, 0>} 
      cylinder {<40+r3, 0-r3, -1> <40+r3, 0-r3, Width*80+1> 20}
      cylinder {<120+r3, 80-r3, -1> <120+r3, 80-r3, Width*80+1> 20}
      cylinder {<40, 80, Width*80> <64, 56, Width*80> r}
      cylinder {<80, 160, Width*80> <100, 77, Width*80> r}
    }
    rotate <0, 90, 0> translate <0, 0, 120>
  }
#end

#macro G112Pat(Width) 
  #local r = 1.5;
  #local R2 = 1;
  
  object {
  difference {
      UnitHalfArc(1, Width, 1, 0.5)

      cylinder {<14, 46, 0> <80, 0, 0> r}
      cylinder {<53, 75, 0> <80, 0, 0> r}

      object {torus {R2*80, r} rotate <90, 0, 0> translate <R2*80, 0, 0>} 
    }       
    scale <1, 1, -1>
    translate 80*z
  }
#end

#macro G112aPat(Width) 
  #local r = 1.5;
  
  object {
  difference {
      UnitHalfArc(1, Width, 1, 0.5)

      cylinder {<0, 40, 0> <23, 40, 0> r}
      cylinder {<23, 40, 0> <80, 0, 0> r}
      cylinder {<53, 80, 0> <80, 0, 0> r}
      
    }       
    scale <1, 1, -1>
    translate 80*z
}
#end

//------------------------------------------------------------------

#macro UnitFullArc(Length, Width, Height, Radius) object {
#local r = 20;
#local r2 = r/sqrt(2)-2;
#local r3 = r/sqrt(3)-2;
#local As = Bs*1.5;
  difference {
      UnitBlock(Length, Width, Height)
      cylinder {<(Length/2-Radius)*80+r2,-r2,-1> <(Length/2-Radius)*80+r2,-r2,Width*80+1> r}
      cylinder {<(Length/2+Radius)*80-r2,-r2,-1> <(Length/2+Radius)*80-r2,-r2,Width*80+1> r}
      cone {<Length*40, 0, -As>,  Radius*80+As+As,  <Length*40, 0, As>, Radius*80-As+As}
      cone {<Length*40, 0, Width*80+As>,  Radius*80+As+As,  <Length*40, 0, Width*80-As>, Radius*80-As+As}
      cylinder {<Length*40, 0, -1>,  <Length*40, 0, Width*80+1>,  Radius*80} 
  }       
}
#end

#macro G98Pat(Width) 
  #local r = 1.5;
  #local R2 = 1.5;
  
  object {
  difference {
      UnitFullArc(3, Width, 2, 1)

      cylinder {<0, 120, Width*80> <50, 120, Width*80> r}
      cylinder {<50, 120, Width*80> <120, 0, Width*80> r}
      cylinder {<50, 120, Width*80> <50, 160, Width*80> r}
      cylinder {<0, 80, Width*80> <27, 80, Width*80> r}
      cylinder {<27, 80, Width*80> <27, 120, Width*80> r}
      cylinder {<27, 80, Width*80> <120, 0, Width*80> r}
      cylinder {<0, 40, Width*80> <120, 0, Width*80> r}
      cylinder {<92, 160, Width*80> <120, 0, Width*80> r}

      cylinder {<240, 120, Width*80> <190, 120, Width*80> r}
      cylinder {<190, 120, Width*80> <120, 0, Width*80> r}
      cylinder {<190, 120, Width*80> <190, 160, Width*80> r}
      cylinder {<240, 80, Width*80> <213, 80, Width*80> r}
      cylinder {<213, 80, Width*80> <213, 120, Width*80> r}
      cylinder {<213, 80, Width*80> <120, 0, Width*80> r}
      cylinder {<240, 40, Width*80> <120, 0, Width*80> r}
      cylinder {<148, 160, Width*80> <120, 0, Width*80> r}
      
      cylinder {<11, 50, 0> <120, 0, 0> r}
      cylinder {<43, 92, 0> <120, 0, 0> r}
      cylinder {<88, 116, 0> <120, 0, 0> r}
      cylinder {<152, 116, 0> <120, 0, 0> r}
      cylinder {<197, 92, 0> <120, 0, 0> r}
      cylinder {<229, 50, 0> <120, 0, 0> r}

      object {torus {R2*80, r} rotate <90, 0, 0> translate <R2*80, 0, 0>} 
    }       
    scale <1, 1, -1>
    translate 80*z  
  }
#end

#macro G98aPat(Width) 
#local r = 20;
#local r2 = r/sqrt(2)-1;
#local r3 = r/sqrt(3)-1.5;
#local r4 = 1.5;
  
  object {
    difference {
      UnitFullArc(3, Width, 2, 1)
      
      box {<-1, 161, Width*80+1> <40, 80, -1>}
      box {<241, 161, Width*80+1> <200, 80, -1>}
      
      cylinder {<-1,80+r2,-r2> <40,80+r2,-r2> r}
      cylinder {<241,80+r2,-r2> <200,80+r2,-r2> r}
      cylinder {<40-r2,80,-r2> <40-r2,160,-r2> r}
      cylinder {<200+r2,80,-r2> <200+r2,160,-r2> r}
  
      cylinder {<-1,80+r2,Width*80+r2> <40,80+r2,Width*80+r2> r}
      cylinder {<241,80+r2,Width*80+r2> <200,80+r2,Width*80+r2> r}
      cylinder {<40-r2,80,Width*80+r2> <40-r2,160,Width*80+r2> r}
      cylinder {<200+r2,80,Width*80+r2> <200+r2,160,Width*80+r2> r}
                                                          
      cylinder {<-r2,80+r2,-1> <-r2, 80+r2, Width*80+1> r}
      cylinder {<40-r2,160+r2,-1> <40-r2, 160+r2, Width*80+1> r}

      cylinder {<240+r2,80+r2,-1> <240+r2, 80+r2, Width*80+1> r}
      cylinder {<200+r2,160+r2,-1> <200+r2, 160+r2, Width*80+1> r}
                                                                
      cylinder {<40, 80, Width*80> <120, 0, Width*80> r4}
      cylinder {<80, 160, Width*80> <120, 0, Width*80> r4}

      cylinder {<200, 80, Width*80> <120, 0, Width*80> r4}
      cylinder {<160, 160, Width*80> <120, 0, Width*80> r4}
    }      
}
#end

#macro G107Pat(Width) 
  #local r = 1.5;
  #local R2 = 1.25;
  
  object {
  difference {
      UnitFullArc(2.5, Width, 1.5, 0.75)

      cylinder {<0, 80, Width*80> <40, 80, Width*80> r}
      cylinder {<40, 80, Width*80> <40, 120, Width*80> r}
      
      cylinder {<200, 80, Width*80> <160, 80, Width*80> r}
      cylinder {<160, 80, Width*80> <160, 120, Width*80> r}
      
      cylinder {<200, 40, Width*80> <180, 40, Width*80> r}
      cylinder {<180, 40, Width*80> <180, 80, Width*80> r}
      
      cylinder {<0, 40, Width*80> <20, 40, Width*80> r}
      cylinder {<20, 40, Width*80> <20, 80, Width*80> r}

      cylinder {<180, 40, Width*80> <100, 0, Width*80> r}
      cylinder {<160, 80, Width*80> <100, 0, Width*80> r}
      cylinder {<128, 120, Width*80> <100, 0, Width*80> r}
      cylinder {<72, 120, Width*80> <100, 0, Width*80> r}
      cylinder {<40, 80, Width*80> <100, 0, Width*80> r}
      cylinder {<20, 40, Width*80> <100, 0, Width*80> r}

      cylinder {<11, 45, 0> <100, 0, 0> r}
      cylinder {<40, 80, 0> <100, 0, 0> r}
      cylinder {<78, 97, 0> <100, 0, 0> r}
      cylinder {<123, 97, 0> <100, 0, 0> r}
      cylinder {<160, 80, 0> <100, 0, 0> r}
      cylinder {<190, 45, 0> <100, 0, 0> r}

      object {torus {R2*80, r} rotate <90, 0, 0> translate <R2*80, 0, 0>} 
    }       
    scale <1, 1, -1>
    translate 80*z
  }
#end

#macro G108Pat(Width) 
  #local r = 1.5;
  #local R2 = 1;
  
  object {
  difference {
      UnitFullArc(2, Width, 1, 0.5)

      cylinder {<15, 46, 0> <80, 0, 0> r}
      cylinder {<53, 75, 0> <80, 0, 0> r}
      cylinder {<107, 75, 0> <80, 0, 0> r}
      cylinder {<145, 46, 0> <80, 0, 0> r}

      object {torus {R2*80, r} rotate <90, 0, 0> translate <R2*80, 0, 0>} 
      
      cylinder {<15, 46, Width*80> <80, 0, Width*80> r}
      cylinder {<53, 75, Width*80> <80, 0, Width*80> r}
      cylinder {<107, 75, Width*80> <80, 0, Width*80> r}
      cylinder {<145, 46, Width*80> <80, 0, Width*80> r}

      object {torus {R2*80, r} rotate <90, 0, 0> translate <R2*80, 0, Width*80>} 
   }       
}
#end

#macro G108aPat(Width) 
  #local r = 1.5;
  
  object {
  difference {
      UnitFullArc(2, Width, 1, 0.5)

      cylinder {<20, 40, 0> <0, 40, 0> r}
      cylinder {<20, 40, 0> <80, 0, 0> r}
      cylinder {<50, 80, 0> <80, 0, 0> r}
      cylinder {<110, 80, 0> <80, 0, 0> r}
      cylinder {<140, 40, 0> <80, 0, 0> r}
      cylinder {<140, 40, 0> <160, 40, 0> r}

      cylinder {<20, 40, Width*80> <0, 40, Width*80> r}
      cylinder {<20, 40, Width*80> <80, 0, Width*80> r}
      cylinder {<50, 80, Width*80> <80, 0, Width*80> r}
      cylinder {<110, 80, Width*80> <80, 0, Width*80> r}
      cylinder {<140, 40, Width*80> <80, 0, Width*80> r}
      cylinder {<140, 40, Width*80> <160, 40, Width*80> r}
   }       
}
#end

#macro G118Pat(Width) 
  #local r = 1.25;
  #local R2 = 0.75;
  
  object {
  difference {
      UnitFullArc(1.5, Width, 1, 0.5)

      cylinder {<6, 25, Width*80> <60, 0, Width*80> r}
      cylinder {<21, 46, Width*80> <60, 0, Width*80> r}
      cylinder {<44, 58, Width*80> <60, 0, Width*80> r}
      cylinder {<76, 58, Width*80> <60, 0, Width*80> r}
      cylinder {<99, 46, Width*80> <60, 0, Width*80> r}
      cylinder {<114, 25, Width*80> <60, 0, Width*80> r}
      
      cylinder {<0, 40, Width*80> <15, 40, Width*80> r}
      cylinder {<15, 40, Width*80> <15, 80, Width*80> r}
      cylinder {<120, 40, Width*80> <105, 40, Width*80> r}
      cylinder {<105, 40, Width*80> <105, 80, Width*80> r}

      object {torus {R2*80, r} rotate <90, 0, 0> translate <R2*80, 0, 0>} 
      object {torus {R2*80, r} rotate <90, 0, 0> translate <R2*80, 0, Width*80>} 
   }       
}
#end

#macro G120Pat(Width) 
  #local r = 1.25;
  #local R2 = 0.625;
  
  object {
  difference {
      UnitFullArc(1.25, Width, 1, 0.375)

      cylinder {<10, 29, Width*80> <50, 0, Width*80> r}
      cylinder {<35, 48, Width*80> <50, 0, Width*80> r}
      cylinder {<65, 48, Width*80> <50, 0, Width*80> r}
      cylinder {<90, 29, Width*80> <50, 0, Width*80> r}
      
      cylinder {<0, 40, Width*80> <20, 40, Width*80> r}
      cylinder {<20, 40, Width*80> <20, 80, Width*80> r}
      cylinder {<100, 40, Width*80> <80, 40, Width*80> r}
      cylinder {<80, 40, Width*80> <80, 80, Width*80> r}

      object {torus {R2*80, r} rotate <90, 0, 0> translate <R2*80, 0, 0>} 
      object {torus {R2*80, r} rotate <90, 0, 0> translate <R2*80, 0, Width*80>} 
   }       
}
#end

#macro G124Pat(Width) 
  #local r = 0.9;
  #local R2 = 0.5;
  
  object {
  difference {
      UnitFullArc(1, Width, 0.5, 0.25)

      cylinder {<8, 22, Width*80> <40, 0, Width*80> r}
      cylinder {<26, 37, Width*80> <40, 0, Width*80> r}
      cylinder {<54, 37, Width*80> <40, 0, Width*80> r}
      cylinder {<72, 22, Width*80> <40, 0, Width*80> r}

      object {torus {R2*80, r} rotate <90, 0, 0> translate <R2*80, 0, Width*80>} 
   }
   rotate <0, -90, 0>
}
#end

#macro G127Pat(Width)  
#local r = 20;
#local r2 = r/sqrt(2);
#local r3 = r/sqrt(3);
  
  object {
  difference {
      UnitFullArc(1, Width, 0.5, 0.25)
      box  {<-1, -1, Width*80+1> <40, 10, -1>}
      cylinder {<-r2,10-r2,-1> <-r2,10-r2,Width*80+1> r*1.1}
      cylinder {<15+r2,6-r2,-1> <15+r2,6-r2,Width*80+1> r}
      cylinder {<-1,10-r2,-r2> <25,10-r2,-r2> r*1.07}
      cylinder {<-1,10-r2,Width*80+r2> <25,10-r2,Width*80+r2> r*1.07}
   }
   rotate <0, -90, 0>
}
#end

//------------------------------------------------------------------

#macro UnitHalfGothicArcGeom(Length, Width, Height, Radius, A, B) object {
#local r = 20;
#local r2 = r/sqrt(2)-1;
#local r3 = r/sqrt(3)-1;
#local As = Bs*1.5;
#local Px = (Length - B) * 80 + r2 + 1;
#local Py = A*80;
#local Cx = (Length + Radius - B) * 80;
#local Cy = 0;
#local L8 = Length*80;
#local W8 = Width*80;
#local R8 = Radius*80;

  difference {
      UnitBlock(Length, Width, Height)
      cylinder {<L8+r2,Py-r2,-1> <L8+r2,Py-r2,W8+1> r}
      cylinder {<Px,-r3,-1> <Px,-r3,W8+1> r}
      cone {<Cx, Cy, -As>,  R8+As+As,  <Cx, Cy, As>, R8-As+As}
      cone {<Cx, Cy, W8+As>,  R8+As+As,  <Cx, Cy, W8-As>, R8-As+As}
      cylinder {<Cx, Cy, -1>,  <Cx, Cy, W8+1>,  R8} 
  }
}
#end

#macro UnitHalfFullGothicArcGeom(Length, Width, Height, Radius, A, B) object {
#local r = 20;
#local r2 = r/sqrt(2)-1;
#local r3 = r/sqrt(3)-1;
#local As = Bs*1.5;
#local Px = (Length - B) * 80 + r2 + 1;
#local Py = A*80;
#local Cx = (Length + Radius - B) * 80;
#local Cy = 0;
#local L8 = Length*80;
#local W8 = Width*80;
#local R8 = Radius*80;

    difference {
      UnitBlock_r(Length, Width, Height)
      cylinder {<Px,-r3,-1> <Px,-r3,W8+1> r}
      cone {<Cx, Cy, -As>,  R8+As+As,  <Cx, Cy, As>, R8-As}
      cone {<Cx, Cy, W8+As>,  R8+As+As,  <Cx, Cy, W8-As>, R8-As}
      cylinder {<Cx, Cy, -1>,  <Cx, Cy, W8+1>,  R8} 
    }
}
#end

#macro G130Pat(Width)
#local r = 1.5;
#local Length = 2.25;
#local Height = 3.25;
#local Radius = 136/12/4;
#local R2 = Height*1.06;
#local A = 10/4;
#local B = 6/4;

  object {
    difference {
      UnitHalfGothicArcGeom(Length, Width, Height, Radius, A, B)

      cylinder {<20, 102, 0> <20, 260, 0> r}
      cylinder {<60, 171, 0> <60, 260, 0> r}
      cylinder {<100, 214, 0> <100, 260, 0> r}
      cylinder {<160, 251, 0> <160, 260, 0> r}
      cylinder {<0, 160, 0> <20, 160, 0> r}
      cylinder {<20, 200, 0> <60, 200, 0> r}

      cylinder {<0, 80, Width*80> <13, 80, Width*80> r}
      cylinder {<0, 120, Width*80> <28, 120, Width*80> r}
      cylinder {<0, 160, Width*80> <52, 160, Width*80> r}
      cylinder {<0, 200, Width*80> <85, 200, Width*80> r}
      cylinder {<0, 240, Width*80> <140, 240, Width*80> r}
      cylinder {<20, 160, Width*80> <20, 200, Width*80> r}
      cylinder {<60, 200, Width*80> <60, 240, Width*80> r}
      cylinder {<20, 240, Width*80> <20, 260, Width*80> r}
      cylinder {<100, 240, Width*80> <100, 260, Width*80> r}

      cylinder {<1, 19, 0> <R2*80, 0, 0> r}
      cylinder {<6, 58, 0> <R2*80, 0, 0> r}
      cylinder {<17, 95, 0> <R2*80, 0, 0> r}
      cylinder {<33, 130, 0> <R2*80, 0, 0> r}
      cylinder {<48, 158, 0> <R2*80, 0, 0> r}
      cylinder {<78, 193, 0> <R2*80, 0, 0> r}
      cylinder {<107, 219, 0> <R2*80, 0, 0> r}
      cylinder {<139, 241, 0> <R2*80, 0, 0> r}

      cylinder {<4, 48, Width*80> <R2*80, 0, Width*80> r}
      cylinder {<17, 95, Width*80> <R2*80, 0, Width*80> r}
      cylinder {<37, 139, Width*80> <R2*80, 0, Width*80> r}
      cylinder {<65, 179, Width*80> <R2*80, 0, Width*80> r}
      cylinder {<99, 213, Width*80> <R2*80, 0, Width*80> r}
      cylinder {<139, 241, Width*80> <R2*80, 0, Width*80> r}

      object {torus {R2*80, r} rotate <90, 0, 0> translate <R2*80, 0, Width*80>} 
      object {torus {R2*80, r} rotate <90, 0, 0> translate <R2*80, 0, 0>} 
    }
  }
#end

#macro G136Pat(Width)
#local r = 1.5;
#local Length = 1.5;
#local Height = 2;
#local Radius = 13/2/4;
#local R2 = Height*1.03;
#local A = 6/4;
#local B = 4/4;

  object {
    difference {
      UnitHalfGothicArcGeom(Length, Width, Height, Radius, A, B)
      cylinder {<80, 141, 0> <80, 160, 0> r}
      cylinder {<0, 110, 0> <40, 110, 0> r}
      cylinder {<40, 110, 0> <40, 160, 0> r}

      cylinder {<0, 120, Width*80> <50, 120, Width*80> r}
      cylinder {<52, 120, Width*80> <52, 160, Width*80> r}
      cylinder {<0, 80, Width*80> <22, 80, Width*80> r}
      
      cylinder {<2, 22, 0> <R2*80, 0, 0> r}
      cylinder {<13, 65, 0> <R2*80, 0, 0> r}
      cylinder {<35, 103, 0> <R2*80, 0, 0> r}
      cylinder {<67, 134, 0> <R2*80, 0, 0> r}
      cylinder {<105, 155, 0> <R2*80, 0, 0> r}
      
      cylinder {<5.9, 44, Width*80> <R2*80, 0, Width*80> r}
      cylinder {<23.7, 84.5, Width*80> <R2*80, 0, Width*80> r}
      cylinder {<51, 120, Width*80> <R2*80, 0, Width*80> r}
      cylinder {<86.5, 143.5, Width*80> <R2*80, 0, Width*80> r}

      object {torus {R2*80, r} rotate <90, 0, 0> translate <R2*80, 0, Width*80>} 
      object {torus {R2*80, r} rotate <90, 0, 0> translate <R2*80, 0, 0>} 
    }
  }

#end

#macro G142Pat(Width)
#local r = 1.5;
#local Length = 1.25;
#local Height = 1.75;
#local Radius = 34/6/4;
#local R2 = Height*1.03;
#local A = 5/4;
#local B = 3/4;

  object {
    difference {
      UnitHalfGothicArcGeom(Length, Width, Height, Radius, A, B)

      cylinder {<0, 80, 0> <24, 80, 0> r}
      cylinder {<0, 120, 0> <63, 120, 0> r}
      cylinder {<20, 120, 0> <20, 140, 0> r}
      cylinder {<63, 120, 0> <63, 140, 0> r}
      cylinder {<40, 100, 0> <40, 120, 0> r}

      cylinder {<0, 80, Width*80> <24, 80, Width*80> r}
      cylinder {<0, 120, Width*80> <63, 120, Width*80> r}
      cylinder {<20, 120, Width*80> <20, 140, Width*80> r}
      cylinder {<63, 120, Width*80> <63, 140, Width*80> r}
      cylinder {<40, 100, Width*80> <40, 120, Width*80> r}

      cylinder {<6,   38, 0>        <R2*80, 0, 0> r}
      cylinder {<21,  73, 0>        <R2*80, 0, 0> r}
      cylinder {<43, 103, 0>        <R2*80, 0, 0> r}
      cylinder {<74, 126, 0>        <R2*80, 0, 0> r}
      cylinder {<6,   38, Width*80> <R2*80, 0, Width*80> r}
      cylinder {<21,  73, Width*80> <R2*80, 0, Width*80> r}
      cylinder {<43, 103, Width*80> <R2*80, 0, Width*80> r}
      cylinder {<74, 126, Width*80> <R2*80, 0, Width*80> r}

      object {torus {R2*80, r} rotate <90, 0, 0> translate <R2*80, 0, Width*80>} 
      object {torus {R2*80, r} rotate <90, 0, 0> translate <R2*80, 0, 0>} 
    }
  }
#end

#macro G145Pat(Width)
#local r = 1.5;
#local Length = 1;
#local Height = 1.5;
#local Radius = 13/4/4;
#local R2 = Height*0.85;
#local A = 3/4;
#local B = 2/4;

  object {
    difference {
      UnitHalfGothicArcGeom(Length, Width, Height, Radius, A, B)

      cylinder {<0, 80, 0> <40, 80, 0> r}
      cylinder {<40, 80, 0> <40, 120, 0> r}
      cylinder {<0, Height*80-40, Width*80> <40, Height*80-40, Width*80> r}
      cylinder {<40, Height*80-40, Width*80> <40, Height*80, Width*80> r}
      
      cylinder {<2, 18, 0> <R2*80, 0, 0> r}
      cylinder {<14, 51, 0> <R2*80, 0, 0> r}
      cylinder {<37, 79, 0> <R2*80, 0, 0> r}       
      cylinder {<67, 96, 0> <R2*80, 0, 0> r}       
      
      cylinder {<6, 35, Width*80> <R2*80, 0, Width*80> r}
      cylinder {<24, 66, Width*80> <R2*80, 0, Width*80> r}
      cylinder {<51, 89, Width*80> <R2*80, 0, Width*80> r}

      object {torus {R2*80, r} rotate <90, 0, 0> translate <R2*80, 0, Width*80>} 
      object {torus {R2*80, r} rotate <90, 0, 0> translate <R2*80, 0, 0>} 
    }
  }
#end
    
#macro G153Pat(Width)
#local r = 1.5;
#local Length = 0.75;
#local Height = 1.25;
#local R2 = Height*0.83;
#local A = 3/4;
#local B = 2/4;
#local Radius = 13/4/4;
  union {
    object {
      difference {
        UnitHalfFullGothicArcGeom(Length, Width, Height, Radius, A, B)
  
        cylinder {<0, 40, Width*80> <11, 40, Width*80> r}
        cylinder {<0, 80, Width*80> <Length*80+10, 80, Width*80> r}
        cylinder {<40, 80, Width*80> <40, Height*80, Width*80> r}

        cylinder {<5, 28, Width*80> <R2*80, 0, Width*80> r}
        cylinder {<19, 54, Width*80> <R2*80, 0, Width*80> r}
        cylinder {<42, 72, Width*80> <R2*80, 0, Width*80> r}
  
        object {torus {R2*80, r} rotate <90, 0, 0> translate <R2*80, 0, Width*80>} 
        object {torus {R2*80, r} rotate <90, 0, 0> translate <R2*80, 0, 0>} 
      }
    }
    object {
      difference {
        UnitHalfFullGothicArcGeom(Length, Width, Height, Radius, A, B)
  
        cylinder {<0, 40, Width*80> <11, 40, Width*80> r}
        cylinder {<0, 80, Width*80> <Length*80+10, 80, Width*80> r}
        cylinder {<40, 80, Width*80> <40, Height*80, Width*80> r}
  
        cylinder {<5, 28, Width*80> <R2*80, 0, Width*80> r}
        cylinder {<19, 54, Width*80> <R2*80, 0, Width*80> r}
        cylinder {<42, 72, Width*80> <R2*80, 0, Width*80> r}
  
        object {torus {R2*80, r} rotate <90, 0, 0> translate <R2*80, 0, Width*80>} 
        object {torus {R2*80, r} rotate <90, 0, 0> translate <R2*80, 0, 0>} 
      }
      scale <-1, 1, 1> translate <2*Length*80, 0, 0>
    }
  }
#end
    
#macro G159Pat(Width)
#local r = 1.5;
#local Length = 5/8;
#local Height = 1;
#local R2 = Height*0.9;
#local A = 2.3/4;
#local B = 1.5/4;
#local Radius = 1/2/B*(A*A+B*B);

  object {
    difference {
      UnitHalfGothicArcGeom(Length, Width, Height, Radius, A, B)

      cylinder {<0, 40, 0> <11, 40, 0> r}
      cylinder {<0, 40, Width*80> <11, 40, Width*80> r}

      cylinder {<1, 13, 0> <R2*80, 0, 0> r}
      cylinder {<10, 37, 0> <R2*80, 0, 0> r}
      cylinder {<26, 57, 0> <R2*80, 0, 0> r}
      cylinder {<49, 70, 0> <R2*80, 0, 0> r}

      cylinder {<4, 25, Width*80> <R2*80, 0, Width*80> r}
      cylinder {<17, 48, Width*80> <R2*80, 0, Width*80> r}
      cylinder {<37, 64, Width*80> <R2*80, 0, Width*80> r}

      object {torus {R2*80, r} rotate <90, 0, 0> translate <R2*80, 0, Width*80>} 
      object {torus {R2*80, r} rotate <90, 0, 0> translate <R2*80, 0, 0>} 
    }
  }
#end

#macro G165Pat(Width)
#local r = 1.5;
#local Length = 5/8;
#local Height = 1;
#local R2 = Height*0.9;
#local A = 2.3/4;
#local B = 1.5/4;
#local Radius = 1/2/B*(A*A+B*B);

  union {
    object {
      difference {
        UnitHalfFullGothicArcGeom(Length, Width, Height, Radius, A, B)
  
        cylinder {<0, 40, 0> <11, 40, 0> r}
        cylinder {<0, 40, Width*80> <11, 40, Width*80> r}
  
        cylinder {<1, 13, 0> <R2*80, 0, 0> r}
        cylinder {<10, 37, 0> <R2*80, 0, 0> r}
        cylinder {<26, 57, 0> <R2*80, 0, 0> r}
        cylinder {<49, 70, 0> <R2*80, 0, 0> r}
  
        cylinder {<4, 25, Width*80> <R2*80, 0, Width*80> r}
        cylinder {<17, 48, Width*80> <R2*80, 0, Width*80> r}
        cylinder {<37, 64, Width*80> <R2*80, 0, Width*80> r}
  
        object {torus {R2*80, r} rotate <90, 0, 0> translate <R2*80, 0, Width*80>} 
        object {torus {R2*80, r} rotate <90, 0, 0> translate <R2*80, 0, 0>} 
      }
    }
    object {
      difference {
        UnitHalfFullGothicArcGeom(Length, Width, Height, Radius, A, B)
  
        cylinder {<0, 40, 0> <11, 40, 0> r}
        cylinder {<0, 40, Width*80> <11, 40, Width*80> r}
  
        cylinder {<1, 13, 0> <R2*80, 0, 0> r}
        cylinder {<10, 37, 0> <R2*80, 0, 0> r}
        cylinder {<26, 57, 0> <R2*80, 0, 0> r}
        cylinder {<49, 70, 0> <R2*80, 0, 0> r}
  
        cylinder {<4, 25, Width*80> <R2*80, 0, Width*80> r}
        cylinder {<17, 48, Width*80> <R2*80, 0, Width*80> r}
        cylinder {<37, 64, Width*80> <R2*80, 0, Width*80> r}
  
        object {torus {R2*80, r} rotate <90, 0, 0> translate <R2*80, 0, Width*80>} 
        object {torus {R2*80, r} rotate <90, 0, 0> translate <R2*80, 0, 0>} 
      }
      scale <-1, 1, 1> translate <2*Length*80, 0, 0>
    }
  }    
#end

#macro G167Pat(Width)
#local r = 1.5;
#local Length = 0.5;
#local Height = 0.75;
#local R2 = Height*0.85;
#local A = 1.55/4;
#local B = 1.1/4;
#local Radius = 1/2/B*(A*A+B*B);

  object {
    difference {
      UnitHalfGothicArcGeom(Length, Width, Height, Radius, A, B)

      cylinder {<2, 13, 0> <R2*80, 0, 0> r}
      cylinder {<15, 36, 0> <R2*80, 0, 0> r}
      cylinder {<35, 48, 0> <R2*80, 0, 0> r}

      cylinder {<6, 26, Width*80> <R2*80, 0, Width*80> r}
      cylinder {<26, 44, Width*80> <R2*80, 0, Width*80> r}

      object {torus {R2*80, r} rotate <90, 0, 0> translate <R2*80, 0, Width*80>} 
      object {torus {R2*80, r} rotate <90, 0, 0> translate <R2*80, 0, 0>} 
    }
  }
#end

#macro G173Pat(Width)
#local r = 1.2;
#local Length = 0.5;
#local Height = 0.75;
#local R2 = Height;
#local A = 1.8/4;
#local B = 1.1/4;
#local Radius = 1/2/B*(A*A+B*B);

  union {
    object {
      difference {
        UnitHalfFullGothicArcGeom(Length, Width, Height, Radius, A, B)
  
        cylinder {<3, 17, Width*80> <R2*80, 0, Width*80> r}
        cylinder {<19, 44, Width*80> <R2*80, 0, Width*80> r}
  
        object {torus {R2*80, r} rotate <90, 0, 0> translate <R2*80, 0, Width*80>} 
      }
    }
    object {
      difference {
        UnitHalfFullGothicArcGeom(Length, Width, Height, Radius, A, B)
  
        cylinder {<3, 17, Width*80> <R2*80, 0, Width*80> r}
        cylinder {<19, 44, Width*80> <R2*80, 0, Width*80> r}
  
        object {torus {R2*80, r} rotate <90, 0, 0> translate <R2*80, 0, Width*80>} 
      }
      scale <-1, 1, 1> translate <2*Length*80, 0, 0>
    }
  }
#end

//------------------------------------------------------------------

#macro UnitRoundedCorner(Length, Width, Height, Radius) object {
  #local r = 20;
  #local As = Bs*1.5;
  difference {
    intersection {
      UnitBlock(Length, Width, Height)
      cylinder {<Length*80, 0, -1> <Length*80, 0, Width*80+1> Radius*80}
    }
    object {torus {Radius*80+0.7*(r-1), r} rotate <90, 0, 0> translate <Length*80, 0, -0.7*(r-1)>}
    object {torus {Radius*80+0.7*(r-1), r} rotate <90, 0, 0> translate <Length*80, 0, Width*80+0.7*(r-1)>}
  }
  rotate <0, 90, 0> translate <0, 0, Length*80>    
}
#end

//------------------------------------------------------------------

#macro UnitRoundedEnd(Length, Width, Height) object {
  #local r = 20;
  #local As = Bs*1.5;
  #local Radius = Height;
  
  union {
    object {UnitBlock(Length-Radius+5/80, Width, Height) translate <Radius*80-5, 0, 0>}
    difference {
      intersection {
        UnitBlock(Radius, Width, Height)
        cylinder {<Radius*80, 0, -1> <Radius*80, 0, Width*80+1> Radius*80}
      }
      object {torus {Radius*80+0.7*(r-1), r} rotate <90, 0, 0> translate <Radius*80, 0, -0.7*(r-1)>}
      object {torus {Radius*80+0.7*(r-1), r} rotate <90, 0, 0> translate <Radius*80, 0, Width*80+0.7*(r-1)>}
    }
  }
}
#end

//------------------------------------------------------------------

#macro UnitRoofFlat(Length, Width1, Width2, Height) object {
  #local Shear = (Width2 - Width1) / Height;
  intersection {
    object {UnitBlock(Length, Width1, Height) Shear_Trans(<1,0,0>, <0, 1, Shear>, <0,0,1>)}
    object {UnitBlock(Length, Width1, Height) }
  } 
}
#end

#macro UnitRoofFlatCorner(Length, Width1, Width2, Height) object {
  #local Shear = (Width2 - Width1) / Height;
  intersection {
    object {UnitBlock(Length, Width1, Height) Shear_Trans(<1,0,0>, <Shear, 1, Shear>, <0,0,1>)}
    object {UnitBlock(Length, Width1, Height) }
  } 
}
#end

//------------------------------------------------------------------

#macro UnitRoundedRoof(Length, Width, Height, Radius) object {
  intersection {
    UnitBlock(Length, Width, Height)
    object {
      UnitCyl(Length, Radius*2)
      rotate <-90,-90,0>
      translate <0,-Radius*80,-Radius*80*2+Width*80>
    }
  }
}
#end

//------------------------------------------------------------------

#macro GDS103Pat(c1) object {
  difference {
    object { box {<0, 0,   0> <500, 112, 9>} material {c1} }
// z-16 -> 96 -> 56 , x-23 -> 50 = triangle 80x27                     
    object { prism {-10, 20, 4, < 23, 16>, < 50,  56>, < 23, 96 >, < 23, 16>} material {c1} rotate -90*x translate 0*78*x}
    object { prism {-10, 20, 4, < 23, 16>, < 50,  56>, < 23, 96 >, < 23, 16>} material {c1} rotate -90*x translate 1*78*x}
    object { prism {-10, 20, 4, < 23, 16>, < 50,  56>, < 23, 96 >, < 23, 16>} material {c1} rotate -90*x translate 2*78*x}
    object { prism {-10, 20, 4, < 23, 16>, < 50,  56>, < 23, 96 >, < 23, 16>} material {c1} rotate -90*x translate 3*78*x}
    object { prism {-10, 20, 4, < 23, 16>, < 50,  56>, < 23, 96 >, < 23, 16>} material {c1} rotate -90*x translate 4*78*x}
    object { prism {-10, 20, 4, < 23, 16>, < 50,  56>, < 23, 96 >, < 23, 16>} material {c1} rotate -90*x translate 5*78*x}

    object { prism {-10, 20, 4, < 87, 16>, < 60,  56>, < 87, 96 >, < 87, 16>} material {c1} rotate -90*x translate 0*78*x}
    object { prism {-10, 20, 4, < 87, 16>, < 60,  56>, < 87, 96 >, < 87, 16>} material {c1} rotate -90*x translate 1*78*x}
    object { prism {-10, 20, 4, < 87, 16>, < 60,  56>, < 87, 96 >, < 87, 16>} material {c1} rotate -90*x translate 2*78*x}
    object { prism {-10, 20, 4, < 87, 16>, < 60,  56>, < 87, 96 >, < 87, 16>} material {c1} rotate -90*x translate 3*78*x}
    object { prism {-10, 20, 4, < 87, 16>, < 60,  56>, < 87, 96 >, < 87, 16>} material {c1} rotate -90*x translate 4*78*x}
    object { prism {-10, 20, 4, < 87, 16>, < 60,  56>, < 87, 96 >, < 87, 16>} material {c1} rotate -90*x translate 5*78*x}
                      
// x-33 -> 55 -> 87,  z-96 -> 63 = triangle 54x33
    object { prism {-10, 20, 4, < 33, 96>, < 55,  63>, < 77, 96 >, < 33, 96>} material {c1} rotate -90*x translate 0*78*x}
    object { prism {-10, 20, 4, < 33, 96>, < 55,  63>, < 77, 96 >, < 33, 96>} material {c1} rotate -90*x translate 1*78*x}
    object { prism {-10, 20, 4, < 33, 96>, < 55,  63>, < 77, 96 >, < 33, 96>} material {c1} rotate -90*x translate 2*78*x}
    object { prism {-10, 20, 4, < 33, 96>, < 55,  63>, < 77, 96 >, < 33, 96>} material {c1} rotate -90*x translate 3*78*x}
    object { prism {-10, 20, 4, < 33, 96>, < 55,  63>, < 77, 96 >, < 33, 96>} material {c1} rotate -90*x translate 4*78*x}
    object { prism {-10, 20, 4, < 33, 96>, < 55,  63>, < 77, 96 >, < 33, 96>} material {c1} rotate -90*x translate 5*78*x}

    object { prism {-10, 20, 4, < 33, 16>, < 55,  48>, < 77, 16 >, < 33, 16>} material {c1} rotate -90*x translate 0*78*x}
    object { prism {-10, 20, 4, < 33, 16>, < 55,  48>, < 77, 16 >, < 33, 16>} material {c1} rotate -90*x translate 1*78*x}
    object { prism {-10, 20, 4, < 33, 16>, < 55,  48>, < 77, 16 >, < 33, 16>} material {c1} rotate -90*x translate 2*78*x}
    object { prism {-10, 20, 4, < 33, 16>, < 55,  48>, < 77, 16 >, < 33, 16>} material {c1} rotate -90*x translate 3*78*x}
    object { prism {-10, 20, 4, < 33, 16>, < 55,  48>, < 77, 16 >, < 33, 16>} material {c1} rotate -90*x translate 4*78*x}
    object { prism {-10, 20, 4, < 33, 16>, < 55,  48>, < 77, 16 >, < 33, 16>} material {c1} rotate -90*x translate 5*78*x}
  }
}
#end
            
#macro GDS110Pat(c1, c2) object {
  union {
    object { box {<0, 0,  20> <500, 3, 180>} material {c1} }
    object { box {<0, 0,   0> <500, 3,  20>} material {c2} }
    object { box {<0, 0, 180> <500, 3, 200>} material {c2} }
  }
}
#end