#include "acMacros.inc"

#declare empty = box { <0,0,0> <0,0,0> }
#declare NoPart = object { empty } // For parts that are intentionally empty (combo sub-parts)
#declare Unfinished = object { empty } // For parts that will be implemented later


/* - Basic blocks ------------------------------------------------------ */

#declare G1       = object { UnitBlock(1,      1,      1)}
#declare G1_45    = object { G1 rotate <0, 45, 0> translate <0, 0, 40> }

#declare G2_1     = object { UnitBlock(1.25,   1,      1) }                        
#declare G2_2     = object { G2_1 rotate <0, 0, 90> translate <80, 0, 0>}

#declare G3_1     = object { UnitBlock(1.5,    1,      1) }
#declare G3_2     = object { G3_1 rotate <0, 0, 90> translate <80, 0, 0>}
#declare G3_45_x  = object { G3_1 rotate <0, 45, 0> translate <0, 0, 40>}
#declare G3_45_1  = object { G3_1 rotate <45, 0, 90> translate <60, 0, 0>}

#declare G4_1     = object { UnitBlock(2,      1,      1)}
#declare G4_2     = object { G4_1 rotate <0, 0, 90> translate <80, 0, 0>}

#declare G5_1     = object { UnitBlock(3,      1,      1)}
#declare G5_2     = object { G5_1 rotate <0, 0, 90> translate <80, 0, 0>}

#declare G6_1     = object { UnitBlock(4,      1,      1)}
#declare G6_2     = object { G6_1 rotate <0, 0, 90> translate <80, 0, 0>}

#declare G8_1     = object { UnitBlock(1.25,   1.25,   1)}
#declare G8_2     = object { G8_1 rotate <0, 0, 90> translate <80, 0, 0>}

#declare G10_1    = object { UnitBlock(0.75,   1,      1)}
#declare G10_2    = object { G10_1 rotate <0, 0, 90> translate <80, 0, 0>}

#declare G11_1    = object { UnitBlock(0.625,  1,      1)}
#declare G11_2    = object { G11_1 rotate <0, 0, 90> translate <80, 0, 0>}

#declare G12_1    = object { UnitBlock(0.75,   0.75,   1)}
#declare G12_2    = object { G12_1 rotate <0, 0, 90> translate <80, 0, 0>}

#declare G15_1    = object { UnitBlock(2,      1,      0.5)}
#declare G15_2    = object { G15_1 rotate <90, 90, 0> translate <0, 80, 160>}
#declare G15_3    = object { G15_1 rotate <0, 0, 90> translate <40, 0, 0>}

#declare G16_1    = object { UnitBlock(1.75,   1,      0.5)}
#declare G16_2    = object { G16_1 rotate <90, 90, 0> translate <0, 80, 140>}
#declare G16_3    = object { G16_1 rotate <0, 0, 90> translate <40, 0, 0>}

#declare G17_1    = object { UnitBlock(1.5 ,   1,      0.5)}
#declare G17_2    = object { G17_1 rotate <90, 90, 0> translate <0, 80, 120>}
#declare G17_3    = object { G17_1 rotate <0, 0, 90> translate <40, 0, 0>}

#declare G18_1    = object { UnitBlock(1.25,   1,      0.5)}
#declare G18_2    = object { G18_1 rotate <0, 90, 90> translate <40, 0, 100>}
#declare G18_3    = object { G18_1 rotate <0, 0, 90> translate <40, 0, 0>}

#declare G19_1    = object { UnitBlock(1,      1,      0.5)}
#declare G19_2    = object { G19_1 rotate <90, 90, 0> translate <0, 80, 80>}
#declare G19_45_1 = object { G19_1 rotate <0, 45, 0> translate <0, 0, 60>}
#declare G19_45_2 = object { G19_2 rotate <0, 45, 0> translate <0, 0, 60>}

#declare G20_1    = object { UnitBlock(1.25,   1.25,   0.5)}
#declare G20_2    = object { G20_1 rotate <90, 90, 0> translate <0, 100, 100>}

#declare G21_1    = object { UnitBlock(3,      1,      0.5)}
#declare G21_2    = object { G21_1 rotate <90, 90, 0> translate <0, 80, 240>}
#declare G21_3    = object { G21_1 rotate <0, 0, 90> translate <40, 0, 0>}

#declare G22_1    = object { UnitBlock(4,      1,      0.5)}
#declare G22_2    = object { G22_1 rotate <90, 90, 0> translate <0, 80, 320>}
#declare G22_3    = object { G22_1 rotate <0, 0, 90> translate <40, 0, 0>}

#declare G23_1    = object { UnitBlock(5,      1,      0.5)}
#declare G23_2    = object { G23_1 rotate <90, 90, 0> translate <0, 80, 400>}
#declare G23_3    = object { G23_1 rotate <0, 0, 90> translate <40, 0, 0>}

#declare G24_1    = object { UnitBlock(6,      1,      0.5)}
#declare G24_2    = object { G24_1 rotate <90, 90, 0> translate <0, 80, 480>}
#declare G24_3    = object { G24_1 rotate <0, 0, 90> translate <40, 0, 0>}

#declare G25_1    = object { UnitBlock(7,      1,      0.5)}
#declare G25_2    = object { G25_1 rotate <90, 90, 0> translate <0, 80, 560>}
#declare G25_3    = object { G25_1 rotate <0, 0, 90> translate <40, 0, 0>}

#declare G26_1    = object { UnitBlock(3,      0.5,    0.5)}
#declare G26_2    = object { G26_1 rotate <0, 0, 90> translate <40, 0, 0>}

#declare G28_1    = object { UnitBlock(2,      0.5,    0.5)}
#declare G28_2    = object { G28_1 rotate <0, 0, 90> translate <40, 0, 0>}

#declare G29_1    = object { UnitBlock(1.5,    0.5,    0.5)}
#declare G29_2    = object { G29_1 rotate <0, 0, 90> translate <40, 0, 0>}

#declare G30_1    = object { UnitBlock(1.25,   0.5,    0.5)}
#declare G30_2    = object { G30_1 rotate <0, 0, 90> translate <40, 0, 0>}

#declare G31_1    = object { UnitBlock(1,      0.5,    0.5)}
#declare G31_2    = object { G31_1 rotate <0, 0, 90> translate <40, 0, 0>}
#declare G31_45_2 = object { G31_2 rotate <0, -45, 0> translate <30, 0, 0>}
#declare G31_5    = object { G31_1 rotate <0, -45, 0> translate <30, 0, 0> }

#declare G32_1    = object { UnitBlock(0.75,   0.5,    0.5)}
#declare G32_2    = object { G32_1 rotate <0, 0, 90> translate <40, 0, 0>}

#declare G33_1    = object { UnitBlock(0.625,  0.5,    0.5)}
#declare G33_2    = object { G33_1 rotate <0, 0, 90> translate <40, 0, 0>}

#declare G34      = object { UnitBlock(0.5,    0.5,    0.5)}

#declare G36_1    = object { UnitBlock(1.5,    0.75,   0.5)}
#declare G36_2    = object { G36_1 rotate <-90, -90, 0> translate <0, 0, 0>}
#declare G36_3    = object { G36_1 rotate <0, 0, 90> translate <40, 0, 0>}

#declare G38_1    = object { UnitBlock(1,      0.75,   0.5)}
#declare G38_2    = object { G38_1 rotate <-90, -90, 0> translate <0, 0, 0>}
#declare G38_3    = object { G38_1 rotate <0, 0, 90> translate <40, 0, 0>}

#declare G39_1    = object { UnitBlock(0.75,   0.75,   0.5)}
#declare G39_2    = object { G39_1 rotate <0, 0, 90> translate <40, 0, 0>}
                             
#declare G40_1    = object { UnitBlock(1,      0.625,  0.5)}
#declare G40_2    = object { G40_1 rotate <-90, -90, 0> translate <0, 0, 0>}
#declare G40_3    = object { G40_1 rotate <0, 0, 90> translate <40, 0, 0>}

#declare G51_1    = object { UnitBlock(1.25,   0.5,    0.375)}
#declare G51_2    = object { G51_1 rotate <-90, -90, 0> translate <0, 0, 0>}
#declare G51_3    = object { G51_1 rotate <0, 0, 90> translate <30, 0, 0>}

#declare G52_1    = object { UnitBlock(1,      0.5,    0.375)}
#declare G52_2    = object { G52_1 rotate <-90, -90, 0> translate <0, 0, 0>}
#declare G52_3    = object { G52_1 rotate <0, 0, 90> translate <30, 0, 0>}

#declare G53_1    = object { UnitBlock(0.75,   0.5,    0.375)}
#declare G53_2    = object { G53_1 rotate <-90, -90, 0> translate <0, 0, 0>}
#declare G53_3    = object { G53_1 rotate <0, 0, 90> translate <30, 0, 0>}

#declare G54_1    = object { UnitBlock(0.625,  0.5,    0.375)}
#declare G54_2    = object { G54_1 rotate <-90, -90, 0> translate <0, 0, 0>}
#declare G54_3    = object { G54_1 rotate <0, 0, 90> translate <30, 0, 0>}

#declare G55_1    = object { UnitBlock(0.5,    0.5,    0.375)}
#declare G55_2    = object { G55_1 rotate <0, 0, 90> translate <30, 0, 0>}

#declare G56_1    = object { UnitBlock(0.5,    0.375,  0.375)}
#declare G56_2    = object { G56_1 rotate <0, 0, 90> translate <30, 0, 0>}

#declare G58_1    = object { UnitBlock(2,      1,      0.25)}
#declare G58_2    = object { G58_1 rotate <-90, -90, 0> translate <0, 0, 0>}
#declare G58_3    = object { G58_1 rotate <0, 0, 90> translate <20, 0, 0>}

#declare G59_1    = object { UnitBlock(1.75,   1,      0.25)}
#declare G59_2    = object { G59_1 rotate <-90, -90, 0> translate <0, 0, 0>}
#declare G59_3    = object { G59_1 rotate <0, 0, 90> translate <20, 0, 0>}

#declare G60_1    = object { UnitBlock(1.5,    1,      0.25)}
#declare G60_2    = object { G60_1 rotate <-90, -90, 0> translate <0, 0, 0>}
#declare G60_3    = object { G60_1 rotate <0, 0, 90> translate <20, 0, 0>}

#declare G61_1    = object { UnitBlock(1.25,   1,      0.25)}
#declare G61_2    = object { G61_1 rotate <-90, -90, 0> translate <0, 0, 0>}
#declare G61_3    = object { G61_1 rotate <0, 0, 90> translate <20, 0, 0>}

#declare G62_1    = object { UnitBlock(1,      1,      0.25)}
#declare G62_2    = object { G62_1 rotate <0, 0, 90> translate <20, 0, 0>}
                             
#declare G63_1    = object { UnitBlock(0.75,   1,      0.25)}
#declare G63_2    = object { G63_1 rotate <-90, -90, 0> translate <0, 0, 0>}
#declare G63_3    = object { G63_1 rotate <0, 0, 90> translate <20, 0, 0>}

#declare G64_1    = object { UnitBlock(0.75,   0.75,   0.25)}
#declare G64_2    = object { G64_1 rotate <0, 0, 90> translate <20, 0, 0>}

#declare G65_1    = object { UnitBlock(1.25,   1.25,   0.25)}
#declare G65_2    = object { G65_1 rotate <0, 0, 90> translate <20, 0, 0>}

#declare G66_1    = object { UnitBlock(2,      0.5,    0.25)}
#declare G66_2    = object { G66_1 rotate <-90, -90, 0> translate <0, 0, 0>}
#declare G66_3    = object { G66_1 rotate <0, 0, 90> translate <20, 0, 0>}

#declare G67_1    = object { UnitBlock(1.5,    0.5,    0.25)}
#declare G67_2    = object { G67_1 rotate <-90, -90, 0> translate <0, 0, 0>}
#declare G67_3    = object { G67_1 rotate <0, 0, 90> translate <20, 0, 0>}

#declare G68_1    = object { UnitBlock(1.25,   0.5,    0.25)}
#declare G68_2    = object { G68_1 rotate <-90, -90, 0> translate <0, 0, 0>}
#declare G68_3    = object { G68_1 rotate <0, 0, 90> translate <20, 0, 0>}

#declare G69_1    = object { UnitBlock(1,      0.5,    0.25)}
#declare G69_2    = object { G69_1 rotate <90, 90, 0> translate <0, 40, 80>}
#declare G69_3    = object { G69_1 rotate <0, 0, 90> translate <20, 0, 0>}
#declare G69_4    = object { G69_3 rotate <0, -45, 0> translate <40, 0, 20>}
#declare G69_5    = object { G69_1 rotate <0, -45, 0> translate <20, 0, 0> }

#declare G70_1    = object { UnitBlock(0.75,   0.5,    0.25)}
#declare G70_2    = object { G70_1 rotate <-90, -90, 0> translate <0, 0, 0>}
#declare G70_3    = object { G70_1 rotate <0, 0, 90> translate <20, 0, 0>}

#declare G71_1    = object { UnitBlock(0.625,  0.5,    0.25)}
#declare G71_2    = object { G71_1 rotate <-90, -90, 0> translate <0, 0, 0>}
#declare G71_3    = object { G71_1 rotate <0, 0, 90> translate <20, 0, 0>}

#declare G72_1    = object { UnitBlock(0.5,    0.5,    0.25)}
#declare G72_2    = object { G72_1 rotate <-90, -90, 0> translate <0, 0, 0>}

#declare G73_1    = object { UnitBlock(1,      0.375,  0.25)}
#declare G73_2    = object { G73_1 rotate <-90, -90, 0> translate <0, 0, 0>}
#declare G73_3    = object { G73_1 rotate <0, 0, 90> translate <20, 0, 0>}

#declare G76_1    = object { UnitBlock(0.625,  0.375,  0.25)}
#declare G76_2    = object { G76_1 rotate <-90, -90, 0> translate <0, 0, 0>}
#declare G76_3    = object { G76_1 rotate <0, 0, 90> translate <20, 0, 0>}

#declare G77_1    = object { UnitBlock(0.5,    0.375,  0.25)}
#declare G77_2    = object { G77_1 rotate <-90, -90, 0> translate <0, 0, 0>}
#declare G77_3    = object { G77_1 rotate <0, 0, 90> translate <20, 0, 0>}

#declare G78_1    = object { UnitBlock(0.375,  0.375,  0.25)}
#declare G78_2    = object { G78_1 rotate <-90, -90, 0> translate <0, 0, 0>}

#declare G79_1    = object { UnitBlock(1,      0.25,   0.25)}
#declare G79_2    = object { G79_1 rotate <0, 0, 90> translate <20, 0, 0>}

#declare G80_1    = object { UnitBlock(0.75,   0.25,   0.25)}
#declare G80_2    = object { G80_1 rotate <0, 0, 90> translate <20, 0, 0>}

#declare G81_1    = object { UnitBlock(0.5,    0.25,   0.25)}
#declare G81_2    = object { G81_1 rotate <0, 0, 90> translate <20, 0, 0>}

#declare G82_1    = object { UnitBlock(0.375,  0.25,   0.25)}
#declare G82_2    = object { G82_1 rotate <0, 0, 90> translate <20, 0, 0>}

#declare G83_1    = object { UnitBlock(0.25,   0.25,   0.25)}

#declare G84_1    = object { UnitBlock(1,      1,      0.125)}
#declare G84_2    = object { G84_1 rotate <0, 0, 90> translate <10, 0, 0>}

#declare G85_1    = object { UnitBlock(0.75,   1,      0.125)}
#declare G85_2    = object { G85_1 rotate <-90, -90, 0> translate <0, 0, 0>}
#declare G85_3    = object { G85_1 rotate <0, 0, 90> translate <10, 0, 0>}

#declare G86_1    = object { UnitBlock(0.5,    1,      0.125)}
#declare G86_2    = object { G86_1 rotate <-90, -90, 0> translate <0, 0, 0>}
#declare G86_3    = object { G86_1 rotate <0, 0, 90> translate <10, 0, 0>}

#declare G87_1    = object { UnitBlock(0.75,   0.75,   0.125)}
#declare G87_2    = object { G87_1 rotate <0, 0, 90> translate <10, 0, 0>}

#declare G88_1    = object { UnitBlock(0.5,    0.75,   0.125)}
#declare G88_2    = object { G88_1 rotate <-90, -90, 0> translate <0, 0, 0>}
#declare G88_3    = object { G88_1 rotate <0, 0, 90> translate <10, 0, 0>}

#declare G89_1    = object { UnitBlock(0.5,    0.5,    0.125)}
#declare G89_2    = object { G89_1 rotate <0, 0, 90> translate <10, 0, 0>}

#declare G90_1    = object { UnitBlock(0.375,  0.375,  0.125)}
#declare G90_2    = object { G90_1 rotate <0, 0, 90> translate <10, 0, 0>}

/* --------------------------------------------------------------------- */

#declare G486     = object { UnitBlock(1,    0.4,    0.4) }
#declare G486_1   = object { G486 }

#declare G487     = object { UnitBlock(8,    0.5,    1) }
#declare G487_1   = object { G487 }

#declare G488     = object { UnitBlock(9,    0.5,    1) }
#declare G488_1   = object { G488 }

#declare G507     = object { UnitBlock(2.5,    1,    0.5) }
#declare G507_1   = object { G507 }

#declare G512     = object { UnitBlock(3,    1,    0.25) }
#declare G512_1   = object { G512 }

#declare G519     = object { UnitBlock(3,    0.5,    0.25) }
#declare G519_1   = object { G519 }

/* - Arcs -------------------------------------------------------------- */

#declare G95_1    = object { G95Pat(1) }
#declare G95_2    = object { G95_1 rotate <-90, 0, 0> translate <0, 0, 200>}
#declare G95_3    = object { G95_1 scale <1, -1, 1> translate <0, 200, 0>}
#declare G95_4    = object { G95_2 scale <-1, 1, 1> translate <200, 0, 0>}
                             
#declare G95a     = object { G95aPat(1) }
#declare G95a_1   = object { G95a } // base for _1
#declare G95a_2   = object { NoPart }
#declare G95a_3   = object { NoPart }
#declare G95a_4   = object { G95a_1 rotate <-90, 0, 0> translate <0, 0, 80> } // base for _2
#declare G95a_5   = object { NoPart }
#declare G95a_6   = object { NoPart }
#declare G95a_7   = object { G95a_1 rotate <0, 0, -90> translate <-120, 110, 0> } // base for _3
#declare G95a_8   = object { NoPart }
#declare G95a_9   = object { NoPart }
                                
#declare G95b_1   = object { G95a_1 scale <-1, 1, 1> translate <120, 0, 0> } // base for _1
#declare G95b_2   = object { NoPart }
#declare G95b_3   = object { NoPart }
#declare G95b_4   = object { G95b_1 rotate <-90, 0, 0> translate <0, 0, 80> } // base for _4
#declare G95b_5   = object { NoPart }
#declare G95b_6   = object { NoPart }
#declare G95b_7   = object { G95b_1 rotate <0, 0, 90> translate <200, -10, 0> } // base for _3
#declare G95b_8   = object { NoPart }
#declare G95b_9   = object { NoPart }

#declare G97_1    = object { G95Pat(0.5)}
#declare G97_2    = object { G97_1 rotate <-90, 0, 0> translate <0, 0, 200>}
#declare G97_3    = object { G97_1 scale <1, -1, 1> translate <0, 200, 0>}
#declare G97_4    = object { G97_2 scale <-1, 1, 1> translate <200, 0, 0>}

#declare G97a_1   = object { G95aPat(0.5) }
#declare G97a_2   = object { NoPart }
#declare G97a_3   = object { NoPart }
#declare G97a_4   = object { G97a_1 rotate <-90, 0, 0> translate <0, 0, 80> } // base for _2
#declare G97a_5   = object { NoPart }
#declare G97a_6   = object { NoPart }
#declare G97a_7   = object { G97a_1 rotate <0, 0, -90> translate <-120, 110, 0> } // base for _3
#declare G97a_8   = object { NoPart }
#declare G97a_9   = object { NoPart }

#declare G97b_1   = object { G97a_1 scale <-1, 1, 1> translate <120, 0, 0> } // base for _1
#declare G97b_2   = object { NoPart }
#declare G97b_3   = object { NoPart }
#declare G97b_4   = object { G97b_1 rotate <-90, 0, 0> translate <0, 0, 80> } // base for _4
#declare G97b_5   = object { NoPart }
#declare G97b_6   = object { NoPart }
#declare G97b_7   = object { G97b_1 rotate <0, 0, 90> translate <200, -10, 0> } // base for _3
#declare G97b_8   = object { NoPart }
#declare G97b_9   = object { NoPart }

#declare G98_1    = object { G98Pat(1)}
#declare G98_2    = object { G98_1 rotate <-90, -90, 0> translate <0, 0, 0>}
#declare G98_3    = object { G98_1 rotate <0, 0, -90> translate <0, 240, 0>}
#declare G98_4    = object { G98_1 rotate <0, 0, 180> translate <240, 160, 0>}
#declare G98_5    = object { G98_1 rotate <0, 0, 90> translate <160, 0, 0>}
#declare G98_6    = object { G98_1 rotate <90, 0, 0> translate <0, 80, 0> }
                                
#declare G98a_1_1 = object { G98aPat(1) }
#declare G98a_1_2 = object { NoPart }
#declare G98a_2_4 = object { G98a_1_1 rotate <-90, 0, 0> translate <-40, 0, 160> }
#declare G98a_2_3 = object { NoPart }
#declare G98a_1_teil_1 = object { G98aPat(1) }
#declare G98a_1_teil_2 = object { NoPart }

#declare G100     = object { G98Pat(0.5) }
#declare G100_1   = object { G100 translate <0, 0, -40>}
#declare G100_2   = object { G100 rotate <-90, -90, 0> translate <0, -40, 0> }
#declare G100_3   = object { G100 rotate <0, 0, -90> translate <0, 240, -40>}
#declare G100_4   = object { G100 rotate <0, 0, 180> translate <240, 160, -40>}
#declare G100_5   = object { G100 rotate <0, 0, 90> translate <160, 0, -40>}
#declare G100_6   = object { G100 rotate <90, 0, 0> translate <0, 80, 0> }

#declare G100a_1_1 = object { G98aPat(0.5) }
#declare G100a_1_2 = object { NoPart }
#declare G100a_2_4 = object { G100a_1_1 rotate <-90, 0, 0> translate <-40, 0, 160> }
#declare G100a_2_3 = object { NoPart }
#declare G100a_3_5 = object { G100a_1_1 rotate <0, 0, -90> translate <0, 240, 0> }      
#declare G100a_3_6 = object { NoPart }
#declare G100a_4_7 = object { G100a_1_1 rotate <0, 0, 90> translate <80, 0, 0> }      
#declare G100a_4_8 = object { NoPart }

#declare G101_1   = object { G101Pat(1) }
#declare G101_2   = object { G101_1 rotate <-90, -90, 0> translate <0, 0, 0>}
#declare G101_3   = object { G101_1 rotate <0, 0, 90> translate <160, 0, 0>}
#declare G101_4   = object { G101_1 rotate <0, 0, 180> translate <120, 160, 0>}
#declare G101_5   = object { G101_1 rotate <90, 90, 0> translate <0, 80, 120>}
#declare G101_6   = object { G101_1 rotate <90, -90, 0> translate <160, 80, 0>}
// 101_7, 101_8 at the end, as they need 316 and 318

#declare G101a_1_1 = object { G101aPat(1) }
#declare G101a_1_2 = object { NoPart }
#declare G101a_2_1 = object { G101a_1_1 rotate <0, 0, 90> translate <160, 0, 0> }
#declare G101a_2_2 = object { NoPart }
#declare G101a_1  = MovedTo( G101a_1_1 )
#declare G101a_2  = MovedTo( G101a_1_2 )

#declare G102_1   = object { G101Pat(1) scale <1, 1, -1> rotate <0, 180, 0> translate 120*x}
#declare G102_2   = object { G102_1 rotate <-90, 90, 0> translate <160, 0, 120>}
#declare G102_3   = object { G102_1 rotate <0, 0, -90> translate <0, 120, 0>}
#declare G102_4   = object { G102_1 rotate <0, 0, 180> translate <120, 160, 0>}
#declare G102_5   = object { G102_1 rotate <90, 90, 0> translate <0, 80, 120>}
#declare G102_6   = object { G102_5 }

#declare G102a_1_1 = object { G101aPat(1) scale <-1, 1, 1> translate <80, 0, 80>}
#declare G102a_1_2 = object { NoPart }
#declare G102a_2_1 = object { G102a_1_1 rotate <-90, 0, -90> translate <-160, 80, 80> }
#declare G102a_2_2 = object { NoPart }
#declare G102a_1  = MovedTo( G102a_1_1 )
#declare G102a_2  = MovedTo( G102a_1_2 )
#declare G19mod_1 = MovedTo( G102a_2_1 )
#declare G102a_2_4 = MovedTo( G102a_2_2 )

#declare G107     = object { G107Pat(0.5) translate <0, 0, -40>}
#declare G107_1   = object { G107 }
#declare G107_2   = object { G107 rotate <-90, -90, 0> translate <0, 0, 0>}
#declare G107_3   = object { G107 rotate <0, 0, 90> translate <120, 0, 0>}
#declare G107_4   = object { G107 rotate <180, 180, 0> translate <200, 120, 0>}
#declare G107_5   = object { G107 rotate <-90, 0, -90> translate <0, 200, 120>}

#declare G108     = object { G108Pat(1) }
#declare G108_1   = object { G108 }
#declare G108_2   = object { G108 rotate <-90, 90, 0> translate <80, 0, 160>}
#declare G108_3   = object { G108 rotate <0, 0, -90> translate <0, 160, 0>}
#declare G108_4   = object { G108 rotate <180, 0, 0> translate <0, 80, 80>}

#declare G108a    = object { G108aPat(1) }
#declare G108a_1  = object { G108a }
#declare G108a_2  = object { G108a rotate <-90, 180, 0> translate <160, 0, 0>}
#declare G108a_3  = object { G108a rotate <0, 0, 90> translate <80, 0, 0>}
#declare G108a_4  = object { G108a rotate <180, 0, 0> translate <0, 80, 80>}
#declare G108a_5  = object { G108a rotate <0, 0, -90> translate <0, 160, 0>}

#declare G110     = object { G108Pat(0.5) translate <0, 0, 40>}
#declare G110_1   = object { G110 translate -40*z}
#declare G110_2   = object { G110 rotate <-90, -90, 0> translate <0, -40, 0>}
#declare G110_3   = object { G110 rotate <0, 0, -90> translate <0, 160, -40>}
#declare G110_4   = object { G110 rotate <180, 0, 0> translate <0, 80, 80>}

#declare G110a    = object { G108aPat(0.5)} 
#declare G110a_1  = object { G110a }
#declare G110a_2  = object { G110a rotate <-90, 180, 0> translate <160, 0, 0>}
#declare G110a_3  = object { G110a rotate <0, 0, 90> translate <80, 0, 0>}
#declare G110a_4  = object { G110a rotate <180, 0, 0> translate <0, 80, 40>}
#declare G110a_5  = object { G110a rotate <0, 0, -90> translate <0, 160, 0>}

#declare G112     = object { G112Pat(1) }
#declare G112_1   = object { G112 }
#declare G112_2   = object { G112 rotate <-90, 0, 0> translate <0, 0, 80>}
#declare G112_3   = object { G112 rotate <0, 0, 90> translate <80, 0, 0>}
#declare G112_4   = object { G112 rotate <0, -90, 90> translate <80, 80, 0>}

#declare G112a_1  = object { G112aPat(1) }
#declare G112a_2  = object { G112a_1 rotate <90, 0, 0> translate <0, 80, 0>}
#declare G112a_3  = object { G112a_1 rotate <0, 0, 90> translate <80, 0, 0>}
#declare G112a_4  = object { G112a_1 rotate <-90, -90, 0> translate <0, 0, 0>}

#declare G113     = object { G112 scale <1, 1, -1> rotate <0, 180, 0> translate 80*x}
#declare G113_1   = object { G113 }
#declare G113_2   = object { G113 rotate <-90, 0, 0> translate <0, 0, 80>}
#declare G113_3   = object { G113 rotate <0, 0, -90> translate <0, 80, 0>}
#declare G113_4   = object { G113 rotate <90, 90, 0> translate <0, 80, 80>}

#declare G113a_1  = object { G112a_1 scale <1, 1, -1> translate 80*z} 
#declare G113a_2  = object { G113a_1 rotate <90, -90, 0> translate <80, 80, 0> }
#declare G113a_3  = object { G113a_1 rotate <0, 0, 90> translate <80, 0, 0> }
#declare G113a_4  = object { G113a_1 rotate <-90, 0, 0> translate <0, 0, 80> }

#declare G114     = object { G112Pat(0.5) translate <0, 0, -40>}
#declare G114_1   = object { G114 }
#declare G114_2   = object { G114 rotate <-90, 0, 0> translate <0, 0, 80>}
#declare G114_3   = object { G114 rotate <0, 0, 90> translate <80, 0, 0>}
#declare G114_4   = object { G114 rotate <90, 180, 0> translate <80, 40, 80>}

#declare G114a_1  = object { G112aPat(0.5) translate <0, 0, -40>}
#declare G114a_2  = object { G114a_1 rotate <-90, 0, 0> translate <0, 0, 80>}
#declare G114a_3  = object { G114a_1 rotate <0, 0, 90> translate <80, 0, 0>}
#declare G114a_4  = object { G114a_1 rotate <90, -90, 0> translate <80, 40, 0>}

#declare G115     = object { G114 scale <1, 1, -1> rotate <0, 180, 0> translate 80*x}
#declare G115_1   = object { G115 }
#declare G115_2   = object { G115 rotate <-90, 0, 0> translate <0, 0, 80>}
#declare G115_3   = object { G115 rotate <0, 0, -90> translate <0, 80, 0>}
#declare G115_4   = object { G115 rotate <90, 180, 0> translate <80, 40, 80>}

#declare G115a_1  = object { G114a_1 scale <1, 1, -1>  translate <0, 0, 40>}
#declare G115a_2  = object { G115a_1 rotate <90, -90, 0> translate <80, 40, 0>}
#declare G115a_3  = object { G115a_1 rotate <0, 0, 90> translate <80, 0, 0>}
#declare G115a_4  = object { G115a_1 rotate <-90, 0, 0> translate <0, 0, 80>}

#declare G118     = object { G118Pat(0.5) }
#declare G118_1   = object { G118 }
#declare G118_2   = object { G118 rotate <-90, 180, 0> translate <120, 0, 0>}
#declare G118_3   = object { G118 rotate <0, 0, 90> translate <80, 0, 0>}
#declare G118_4   = object { G118 rotate <0, 0, -90> translate <0, 120, 0>}
#declare G118_5   = object { G118 rotate <0, 0, 180> translate <120, 80, 0>}

#declare G120     = object { G120Pat(1.0) }
#declare G120_1   = object { G120 }
#declare G120_2   = object { G120 rotate <-90, -90, 0> translate <0, 0, 0>}

#declare G121     = object { G120Pat(0.75) }
#declare G121_1   = object { G121 }
#declare G121_2   = object { G121 rotate <-90, -90, 0> translate <0, 0, 0>}

#declare G122     = object { G120Pat(0.5) }
#declare G122_1   = object { G122 }
#declare G122_2   = object { G122 rotate <-90, -90, 0> translate <0, 0, 0>}
#declare G122_3   = object { G122 rotate <0, 0, 90> translate <80, 0, 0>}
#declare G122_4   = object { G122 rotate <0, 0, -90> translate <0, 100, 0>}
#declare G122_5   = object { G122 rotate <0, 0, 180> translate <100, 80, 0>}

#declare G123     = object { G120Pat(0.25) }
#declare G123_1   = object { G123 }
#declare G123_2   = object { G123 rotate <-90, -90, 0> translate <0, 0, 0>}
#declare G123_3   = object { G123 rotate <0, 0, 90> translate <80, 0, 0>}
#declare G123_4   = object { G123 rotate <0, 0, -90> translate <0, 100, 0>}
#declare G123_5   = object { G123 rotate <0, 0, 180> translate <100, 80, 0>}

#declare G124     = object { G124Pat(0.5) translate <40, 0, 0>}
#declare G124_1   = object { G124 }
#declare G124_2   = object { G124 rotate <0, 180, 90> translate <40, 40, 80>}
#declare G124_3   = object { G124 rotate <180, 0, 0> translate <0, 40, 80>}
#declare G124_4   = object { G124 rotate <90, 0, 0> translate <0, 80, 0>}
#declare G124_5   = object { G124 rotate <-90, 0, 0> translate <0, 0, 40>}

#declare G126     = object { G124Pat(0.25) translate <20, 0, 0>}
#declare G126_1   = object { G126 }
#declare G126_2   = object { G126 rotate <0, 180, 90> translate <40, 20, 80>}
#declare G126_3   = object { G126 rotate <180, 0, 0> translate <0, 40, 80>}
#declare G126_4   = object { G126 rotate <90, 0, 0> translate <0, 80, 0>}
#declare G126_5   = object { G126 rotate <-90, 0, 0> translate <0, 0, 40>}

#declare G127_1   = object { G127Pat(0.5) translate <40, 0, 0>}
#declare G127_2   = object { G127_1 rotate <90, 0, 180> translate <40, 0, 0>}

#declare G130_1   = object { G130Pat(1.0) }
#declare G130_2   = object { G130_1 rotate <-90, 0, 0> translate <0, 0, 260>}
#declare G130_3   = object { G130_1 rotate <0, 0, -90> translate <0, 180, 0>}
#declare G130_4   = object { G130_1 rotate <0, 180, -90> translate <0, 0, 80>}

#declare G131_1   = object { G130Pat(1.0) scale <-1, 1, 1> translate <180, 0, 0>}
#declare G131_2   = object { G131_1 rotate <-90, 0, 0> translate <0, 0, 260>}
#declare G131_3   = object { G131_1 rotate <0, 0, -90> translate <0, 180, 0>}
#declare G131_4   = object { G131_1 rotate <0, 180, -90> translate <0, 0, 80>}

#declare G134_1   = object { G130Pat(0.5) }
#declare G134_2   = object { G134_1 rotate <-90, 0, 0> translate <0, 0, 260>}
#declare G134_3   = object { G134_1 rotate <0, 0, -90> translate <0, 180, 0>}
#declare G134_4   = object { G134_1 rotate <0, 180, -90> translate <0, 0, 40>}

#declare G135_1   = object { G130Pat(0.5) scale <1, 1, -1>}
#declare G135_2   = object { G135_1 rotate <-90, 0, 0> translate <0, 0, 260>}
#declare G135_3   = object { G135_1 rotate <0, 0, -90> translate <0, 180, 0>}
#declare G135_4   = object { G135_1 rotate <0, 180, -90> translate <0, 0, 40>}

#declare G136_1   = object { G136Pat(1) }
#declare G136_2   = object { G136_1 rotate <-90, 0, 0> translate <0, 0, 160>}
#declare G136_3   = object { G136_1 rotate <0, 0, -90> translate <0, 120, 0>}

#declare G137_1   = object { G136_1 scale <-1, 1, 1> translate <120, 0, 0>}
#declare G137_2   = object { G136_2 scale <-1, 1, 1> translate <120, 0, 0>}
#declare G137_3   = object { G136_3 scale <1, 1, 1> translate <0, 0, 0>}

#declare G140_1   = object { G136Pat(0.5) }
#declare G140_2   = object { G140_1 rotate <-90, 0, 0> translate <0, 0, 160>}
#declare G140_3   = object { G140_1 rotate <0, 0, -90> translate <0, 120, 0>}

#declare G141_1   = object { G140_1 scale <-1, 1, 1> translate <120, 0, 0>}
#declare G141_2   = object { G140_2 scale <-1, 0, 0> translate <120, 0, 0>}
#declare G141_3   = object { G140_3 scale <1, 1, 1> translate <0, 0, 0>}

#declare G142_1   = object { G142Pat(1) }
#declare G142_2   = object { G142_1 rotate <-90, 0, 180> translate <100, 80, 140>}
#declare G142_3   = object { G142_1 rotate <0, 0, -90> translate <0, 120, 0>}

#declare G144_1   = object { G142Pat(0.5) }
#declare G144_2   = object { G144_1 rotate <-90, 0, 180> translate <100, 40, 140>}
#declare G144_3   = object { G144_1 rotate <-90, 0, 0> translate <0, 0, 140>}
#declare G144_4   = object { G144_1 rotate <0, 0, 90> rotate <0, 180, 0> translate <0, 0, 40> }
#declare G144_5   = object { G144_1 rotate <0, 0, -90> translate <0, 100, 0> }

#declare G145_1   = object { G145Pat(1) }
#declare G145_2   = object { G145_1 rotate <0,0,90> translate <120,0,0> }
#declare G145_3   = object { G145_2 rotate <-90,0,0> translate <0,0,80> }

#declare G146_1   = object { G145_1 scale <-1, 1, 1> translate <80, 0, 0>}
#declare G146_2   = object { G146_1 rotate <0,0,-90> translate <0,80,0> }
#declare G146_3   = object { G146_2 rotate <-90,0,0> translate <0,0,80> }

#declare G149_1   = object { G145Pat(0.5) }
#declare G149_2   = object { G149_1 rotate <0,0,90> translate <120,0,0> }
#declare G149_3   = object { G149_2 rotate <-90,0,0> translate <0,0,80> }
#declare G149_4   = object { G149_2 rotate <0,0,90> rotate <0,180,0> translate <0,0,40> }

#declare G150_1   = object { G149_1 scale <-1, 1, 1> translate <80, 0, 0>} 
#declare G150_2   = object { G150_1 rotate <0,0,-90> translate <0,80,0> }
#declare G150_3   = object { G150_2 rotate <-90,0,0> translate <0,0,80> }
#declare G150_4   = object { G150_2 rotate <0,0,-90> rotate <0,180,0> translate <80,120,40> }

#declare G153_1   = object { G153Pat(0.5) }
#declare G153_2   = object { G153_1 rotate <-90, 0, 0> translate <0, 0, 100> }
#declare G153_3   = object { G153_1 rotate <0, 0, -90> translate <0, 120, 0> }
#declare G153_4   = object { G153_1 rotate <0, 0, 90> translate <100, 0, 0> }
#declare G153_5   = object { G153_1 rotate <0, 0, -180> translate <120, 100, 0> }

#declare G154_1   = object { G153Pat(0.25) }
#declare G154_2   = object { G154_1 rotate <-90, 0, 0> translate <0, 0, 100> }
#declare G154_3   = object { G154_1 rotate <0, 0, -90> translate <0, 120, 0> }
#declare G154_4   = object { G154_1 rotate <0, 0, 90> translate <100, 0, 0> }
#declare G154_5   = object { G154_1 rotate <0, 0, -180> translate <120, 100, 0> }

#declare G159_1   = object { G159Pat(0.5) }
#declare G159_2   = object { G159_1 rotate <180, 0, 90> translate <0, 0, 40>}
#declare G159_3   = object { G159_1 rotate <90, 0, 180> translate <60, 0, 0>}

#declare G160_1   = object { G159_1 scale <-1, 1, 1> translate <50, 0, 0>}
#declare G160_2   = object { G160_1 rotate <180, 0, 90> translate <0, 0, 40>}
#declare G160_3   = object { G159_3 scale <-1, 1, 1> translate <60, 0, 0>}

#declare G165_1   = object { G165Pat(0.5) }
#declare G165_2   = object { G165_1 rotate <-90, 0, 0> translate <0, 0, 80>}

#declare G166_1   = object { G165Pat(0.25) }
#declare G166_2   = object { G166_1 rotate <-90, 0, 0> translate <0, 0, 80> }

#declare G167_1   = object { G167Pat(0.5) }
#declare G167_2   = object { G167_1 rotate <0, 180, -90> translate <0, 0, 40> }
#declare G167_3   = object { G167_1 rotate <0, 0, 180> translate <40, 60, 0> }
#declare G167_4   = object { G167_1 rotate <90, -90, 0> translate <60, 40, 0> }
#declare G167_5   = object { G167_1 rotate <-90, -90, 0> translate <0, 0, 0> }

#declare G168_1   = object { G167Pat(0.5) scale <-1, 1, 1> translate <40, 0, 0> }
#declare G168_2   = object { G168_1 rotate <0, 0, -90> translate <0, 40, 0> }
#declare G168_3   = object { G168_1 rotate <0, 0, 180> translate <40, 60, 0> }
#declare G168_4   = object { G168_1 rotate <-90, 90, 0> translate <60, 0, 40> }
#declare G168_5   = object { G168_1 rotate <90, 90, 0> translate <0, 40, 40> }

#declare G173_1   = object { G173Pat(0.5) }
#declare G173_2   = object { G173_1 rotate <-90,0,0> translate <0,0,60> }
#declare G173_3   = object { G173_1 rotate <0,0,-90> translate <0,80,0> }

#declare G174_1   = object { G173Pat(0.25) }
#declare G174_2   = object { G174_1 rotate <-90,0,0> translate <0,0,60> }
#declare G174_3   = object { G174_1 rotate <0,0,-90> translate <0,80,0> }

#declare G1364_1  = object { G101Pat(0.25) translate <0,0,-60>}
#declare G1364_2  = object { G1364_1 rotate <-90, -90, 0> translate <0, 0, 0> }
#declare G1364_3  = object { G1364_1 rotate <0, 0, 90> translate <160, 0, 0>}
#declare G1364_4  = object { G1364_1 rotate <0, 0, 180> translate <120, 160, 0>}
#declare G1364_5  = object { G1364_1 rotate <180, 0, -90> translate <160, 120, 20>}
#declare G1364_6  = object { G1364_1 rotate <90, -90, 0> translate <160, 20, 0> }

#declare G1365_1  = object { G101Pat(0.25) scale <1, 1, -1> rotate <0, 180, 0> translate <120, 0, -60>}
#declare G1365_2  = object { G1365_1 rotate <-90, 90, 0> translate <160, 0, 120>}
#declare G1365_3  = object { G1365_1 rotate <0, 0, -90> translate <0, 120, 0>}
#declare G1365_4  = object { G1365_1 rotate <0, 0, 180> translate <120, 160, 0>}
#declare G1365_5  = object { G1365_1 rotate <180, 0, 90> translate <0, 0, 20>}
#declare G1365_6  = object { G1365_5 rotate <-90, 0, 0> translate <0, 0, 120>}

/* - Cylinders --------------------------------------------------------- */

#declare G179     = object { UnitCyl(2,    1) }
#declare G179_1   = object { G179 }
#declare G179_2   = object { G179 rotate <0, 0, -90> translate <0, 80, 0>}
#declare G179_2a  = object { G179_2 }
 
#declare G181     = object { UnitCyl(1,    1) }
#declare G181_1   = object { G181 }
#declare G181_2   = object { G181 rotate <0, 0, -90> translate <0, 80, 0>}
#declare G181_2a  = object { G181_2 }
#declare G181_3   = object { G181_2 translate <-79,0,0>}
#declare G181_4   = object { G181_2 }
#declare G181_5   = object { G181_1 translate <-20,0,0>}

#declare G184     = object { UnitCyl(0.25, 1) }
#declare G184_1   = object { G184 }
#declare G184_2   = object { G184 rotate <0, 0, -90> translate <0, 80, 0>}
#declare G184_2a  = object { G184_2 }

#declare G186     = object { UnitCyl(1.25, 0.75) }
#declare G186_1   = object { G186 }
#declare G186_2   = object { G186 rotate <0, 0, -90> translate <0, 80, 0>}
#declare G186_3   = object { G186_2 }

#declare G188     = object { UnitCyl(1,    0.75) }
#declare G188_1   = object { G188 }
#declare G188_2   = object { G188 rotate <0, 0, -90> translate <0, 60, 0>}
#declare G188_3   = object { G188_2 }

#declare G192     = object { UnitCyl(2,    0.5) }
#declare G192_1   = object { G192 }
#declare G192_2   = object { G192 rotate <0, 0, -90> translate <0, 40, 0>}
#declare G192_3   = object { G192_2 }
             
#declare G196     = object { UnitCyl(1,    0.5) }
#declare G196_1   = object { G196 }
#declare G196_2   = object { G196 rotate <0, 0, -90> translate <0, 40, 0>}
#declare G196_3   = object { G196_2 }
             
#declare G198     = object { UnitCyl(0.5,  0.5) }
#declare G198_1   = object { G198 }
#declare G198_2   = object { G198 rotate <0, 0, -90> translate <0, 40, 0>}
#declare G198_3   = object { G198_2 }
#declare G198_4   = object { G198_2 translate <-39,0,0> }

#declare G199     = object { UnitCyl(1.5,  0.375) }
#declare G199_1   = object { G199 }
#declare G199_2   = object { G199 rotate <0, 0, -90> translate <0, 40, 0>}
#declare G199_3   = object { G199_2 }
             
#declare G200     = object { UnitCyl(1.25, 0.375) }
#declare G200_1   = object { G200 }
#declare G200_2   = object { G200 rotate <0, 0, -90> translate <0, 40, 0>}
#declare G200_3   = object { G200_2 }
             
#declare G202     = object { UnitCyl(1,    0.375) }
#declare G202_1   = object { G202 }
#declare G202_2   = object { G202 rotate <0, 0, -90> translate <0, 40, 0>}
#declare G202_3   = object { G202_2 }
             
/* - Roof parts -------------------------------------------------------- */

#declare G208     = object { UnitTriangleBlock(1,     1,    1)}
#declare G208_1   = object { G208 }
#declare G208_2   = object { G208 rotate <135, 90, 0> translate <60, 57, 80>}
#declare G208_3   = object { G208 rotate <0, 0, -90> rotate <0, 90, 0> translate <0, 80, 80>}
#declare G208_4   = object { G208_2 scale <1, -1, 1> translate <0, 60, 0> }
#declare G208_5   = union {
                      object { G208_3 } 
                      object {G208_3 rotate <0, 180, 0> translate <80, 0, 80>}
                    }
#declare G208_6   = object { G208 rotate <0, 0, -90> rotate <0, 135, 0> translate <55, 80, 57>}
#declare G208_7   = union {
                      object { G208_2 }
                      object { G208_2 rotate <0, 0, 90> translate <117, -3, 0> }
                    }
#declare G208_8   = object { G208_1 scale <1,-1,1> translate <0,80,0> }
#declare G208_9   = object { G208_5 rotate <-90,0,0> translate <0,0,80> }

#declare G210     = object { UnitTriangleBlock(1,     0.5,  1)}
#declare G210_1   = object { G210 }
#declare G210_2   = object { G210 rotate <135, 90, 0> translate <60, 57, 40>}
#declare G210_3   = object { G210 rotate <0, 0, -90> rotate <0, 90, 0> translate <0, 40, 80>}
#declare G210_4   = object { G210_2 scale<1, -1, 1> translate <0, 60, 0>}
#declare G210_5   = union {
                      object { G210_3 } 
                      object {G210_3 rotate <0, 180, 0> translate <80, 0, 80>}
                    }
#declare G210_6   = object { G210 rotate <0, 0, -90> rotate <0, 135, 0> translate <55, 40, 57>}
#declare G210_7   = union {
                      object { G210_2 }
                      object { G210_2 rotate <0, 0, 90> translate <116, -4, 0>}
                    }
#declare G210_8   = object { G210 scale <1, -1, 1> translate <0, 80, 0>}
#declare G210_9   = union {
                      object { G210 rotate <0, -90, 0> translate <80, 0, 0>}
                      object { G210_8 rotate <0, 90, 0> translate <0, 0, 40>}
                    }
#declare G210_2xliegend = object { G210_5 }

#declare G210_45_1 = object { G210_1 rotate <0, 45, 0> translate <0, 0, 60>}

#declare G211     = object { UnitTriangleBlock(1,     0.25, 1)}
#declare G211_1   = object { G211 }
#declare G211_2   = object { G211 rotate <135, 90, 0> translate <60, 57, 20>}
#declare G211_3   = object { G211 rotate <0, 0, -90> rotate <0, 90, 0> translate <0, 20, 80>}
#declare G211_4   = object { G211_2 scale<1, -1, 1> translate <0, 60, 0>}
#declare G211_5   = union {
                      object { G211_3 } 
                      object {G211_3 rotate <0, 180, 0> translate <80, 0, 80>}
                    }
#declare G211_6   = object { G211_3 rotate <0,45,0>}
#declare G211_7   = union {
                      object { G211_2 }
                      object { G211_2 rotate <0, 0, 90> translate <116, -4, 0>}
                    }
#declare G211_8   = object { G211_1 scale <1,-1,1> translate <0,80,0> }
#declare G211_9   = object { G211_5 rotate <-90,0,0> translate <0,0,20> }

#declare G212     = object { UnitRoofCorner(1, 1, 1) }
#declare G212_1   = object { G212 }
#declare G212_2   = object { G212 rotate <0, 90, 0> rotate <90, 0, 0> translate <0, 0, 0>}
#declare G212_3   = object { G212_2 rotate <0, 0, 90> translate <80, 0, 0>}
#declare G212_4   = union {
                      object { G212_3 }
                      object { G212  rotate <0, 90, 0> rotate <90, 90, 0> translate <0, 0, 80>}
                    }
#declare G212_3x  = object {union {
                      object { G212_4 }
                      object { G212  rotate <180, 0, 0> rotate <0, 90, 0> translate <80, 80, 80>}
                    } rotate <0,90,0> translate <0,0,80> }

#declare G213     = object { UnitTriangleBlock(0.75,  1,    0.75) }
#declare G213_1   = object { G213 translate <0, 0, -20>}
#declare G213_2   = object { G213 rotate <135, 90, 0> translate <60, 57, 80>}
#declare G213_3   = object { G213 rotate <0, 0, 90> rotate <0, 180, 0> translate <0, 0, 80>}
#declare G213_4   = object { G213_2 scale <1,-1,1> translate <0,40,0> }
#declare G213_5   = union {
                      object { G213_3 translate <0,0,-4>}
                      object { G213_3 rotate <0,180,0> translate <60,0,60-4>}
                    }
#declare G213_6   = object { G213 rotate <0, 0, 90> rotate <0, -135, 0> translate <60, 0, 60>}
#declare G213_2x  = union {
                      object { G213_2 rotate <0, 90, 0> translate <0, 0, 80> }
                      object { G213_2 rotate <0, 90, 0> rotate <90, 0, 0> translate <0, -3, -8> }
                    }

#declare G215     = object { UnitTriangleBlock(0.75,  0.5,  0.75) }
#declare G215_1   = object { G215 }
#declare G215_2   = object { G215_1 rotate <135, 90, 0> translate <54.5, 56.5, 40>}
#declare G215_3   = object { G215_2 rotate <90,-45,0> translate <0,40,0> }
#declare G215_6   = object { G215_2 rotate <90,0,0> translate <0,40,0> }
#declare G215_2x  = union {
                      object { G215_2 rotate <0,90,0> translate <0,0,100> }
                      object { G215_2 rotate <0,90,0> rotate <90,0,0> translate <0,0,20> }
                    }
                    
#declare G216     = object { UnitTriangleBlock(0.75,  0.25, 0.75) }
#declare G216_1   = object { G216 }
#declare G216_2   = object { G216_1 rotate <135, 90, 0> translate <56, 57, 20>}
#declare G216_3   = object { G216_2 rotate <90,-45,0> translate <0,20,0> }
#declare G216_6   = object { G216_2 rotate <90,0,0> translate <0,20,0> }

#declare G217     = object { UnitRoofCorner(0.7, 0.7, 0.7) }
#declare G217_1   = object { G217 translate <-24,0,-24>}
#declare G217_2   = object { G217 rotate <0, 90, 0> rotate <90, 0, 0> translate <0, 0, 0>}
#declare G217_3   = object { G217_2 rotate <0, 0, 90> translate <80, -20, 0>}
#declare G217_2x  = union {
                      object { G217_3 }
                      object { G217  rotate <0, 90, 0> rotate <90, 90, 0> translate <0, -20, 80>}
                    }

#declare G218     = object { UnitTriangleBlock(0.5,   0.5,  0.5) }
#declare G218_1   = object { G218 translate <0, 0, -40>} // Needed a move !?
#declare G218_2   = object { G218 rotate <135, 90, 0> translate <60, 57, 40>}
#declare G218_3   = object { Unfinished }
#declare G218_4   = object { Unfinished }
#declare G218_6   = object { Unfinished }
#declare G218_9   = object { Unfinished }
#declare G218_10  = object { Unfinished }

#declare G220     = object { UnitTriangleBlock(0.5,   0.25, 0.5) }
#declare G220_1   = object { G220 }
#declare G220_2   = object { Unfinished }
#declare G220_3   = object { Unfinished }
#declare G220_4   = object { Unfinished }
#declare G220_5   = object { G220 rotate <135, 90, 0> translate <60, 57, 40>}
                              
// not finished yet...
#declare G221     = object { UnitRoofCorner(0.5, 0.5, 0.5) }
#declare G221_1   = object { G221 translate <-40,0,-40>}
#declare G221_2   = object { Unfinished }
#declare G221_2x  = object { Unfinished }
#declare G221_3x  = object { Unfinished }
                              
#declare G222     = object { UnitTriangleBlock(0.375, 0.5, 0.375) }
#declare G222_1   = object { G222 }
#declare G222_2   = object { G222 rotate <135, 90, 0> translate <60, 57, 40>}

#declare G227     = object { UnitTriangleBlock(0.5,   0.5, 1) } // Unfinished edges
#declare G227_1   = object { G227 translate <0,0,-40>}
#declare G227_3   = object { Unfinished }
#declare G227_4   = object { Unfinished }
#declare G227_5   = object { Unfinished }
#declare G227_8   = object { Unfinished }
#declare G227_9   = object { Unfinished }

#declare G228     = object { UnitTriangleBlock(0.5,   0.25, 1) }
#declare G228_1   = object { G228 translate <0,0,-40>}
#declare G228_3   = object { Unfinished }
#declare G228_4   = object { Unfinished }
#declare G228_5   = object { Unfinished }
#declare G228_8   = object { Unfinished }
#declare G228_9   = object { Unfinished }

#declare G258     = object { UnitRoofFlatCorner(1, 1, 0.5, 1) }
#declare G258_1   = object { G258 }
                                                     
#declare G260     = object { UnitRoofFlat(1, 0.75, 0.5, 1) }
#declare G260_1   = object { G260 }
#declare G260_2   = object { Unfinished }
#declare G260_3   = object { Unfinished }
#declare G260_4   = object { Unfinished }
#declare G260_5   = object { G260_1 rotate <90,0,0> scale <1,-1,1> translate <0,0,0>}
#declare G260_6   = object { Unfinished }
#declare G260_7   = object { Unfinished }

#declare G261     = object { UnitRoofFlat(0.75, 0.75, 0.5, 1) }
#declare G261_1   = object { G261 }
#declare G261_5   = object { G261_1 rotate <90,0,0> scale <1,-1,1> translate <0,0,0>}
#declare G261_7   = object { Unfinished }

#declare G262     = object { UnitRoofFlat(0.5, 0.75, 0.5, 1) }
#declare G262_1   = object { G262 }
#declare G262_2   = object { Unfinished }
#declare G262_3   = object { Unfinished }
#declare G262_4   = object { Unfinished }
#declare G262_5   = object { Unfinished }
#declare G262_6   = object { Unfinished }
#declare G262_7   = object { Unfinished }

#declare G264     = object { UnitRoofFlat(0.25, 0.75, 0.5, 1) }
#declare G264_1   = object { G264 }
#declare G264_2   = object { Unfinished }
#declare G264_3   = object { Unfinished }
#declare G264_4   = object { Unfinished }
#declare G264_5   = object { Unfinished }
#declare G264_6   = object { Unfinished }
#declare G264_7   = object { Unfinished }

#declare G265     = object { UnitRoofFlatCorner(0.75, 0.75, 0.5, 1) }
#declare G265_1   = object { G265 }
#declare G265_4   = object { G265_1 scale <0, -1, 0> translate <0, 80, 0> }

#declare G267     = object { UnitRoofFlat(1, 0.5, 0.25, 1) }
#declare G267_1   = object { G267 }
#declare G267_2   = object { Unfinished }
#declare G267_3   = object { Unfinished }
#declare G267_5   = object { Unfinished }
#declare G267_6   = object { Unfinished }
                        
#declare G268     = object { Unfinished }
#declare G268_1   = object { Unfinished }
#declare G268_7   = object { Unfinished }
                       
#declare G269     = object { UnitRoofFlat(0.5, 0.5, 0.25, 1) }
#declare G269_1   = object { G269 }
#declare G269_2   = object { Unfinished }
#declare G269_3   = object { Unfinished }
#declare G269_4   = object { Unfinished }
#declare G269_5   = object { Unfinished }
#declare G269_6   = object { Unfinished }

#declare G270     = object { UnitRoofFlat(0.25, 0.5, 0.25, 1) }
#declare G270_1   = object { G270 }
#declare G270_2   = object { Unfinished }
#declare G270_3   = object { Unfinished }
#declare G270_4   = object { Unfinished }
#declare G270_5   = object { Unfinished }
#declare G270_6   = object { Unfinished }

#declare G272     = object { UnitRoofFlat(1.25, 0.5, 0.375, 1) }
#declare G272_1   = object { G272 }
#declare G272_2   = object { Unfinished }
#declare G272_3   = object { Unfinished }
#declare G272_5   = object { Unfinished }
#declare G272_6   = object { Unfinished }
#declare G272_7   = object { Unfinished }

#declare G273     = object { UnitRoofFlat(1, 0.5, 0.375, 1) }
#declare G273_1   = object { G273 }
#declare G273_2   = object { Unfinished }
#declare G273_3   = object { Unfinished }
#declare G273_5   = object { Unfinished }

#declare G274     = object { UnitRoofFlat(0.75, 0.5, 0.375, 1) }
#declare G274_1   = object { G274 }
#declare G274_2   = object { Unfinished }
#declare G274_3   = object { Unfinished }
#declare G274_5   = object { Unfinished }
#declare G274_7   = object { Unfinished }

#declare G275     = object { UnitRoofFlat(0.5, 0.5, 0.375, 1) }
#declare G275_1   = object { G275 }
#declare G275_2   = object { Unfinished }
#declare G275_3   = object { Unfinished }
#declare G275_5   = object { Unfinished }
#declare G275_9   = object { Unfinished }

#declare G276     = object { UnitRoofFlat(0.25, 0.5, 0.375, 1) }
#declare G276_1   = object { G276 }
#declare G276_2   = object { Unfinished }
#declare G276_3   = object { Unfinished }
#declare G276_5   = object { Unfinished }

#declare G277     = object { UnitRoofFlatCorner(0.5, 0.5, 0.375, 1) }
#declare G277_1   = object { G277 }
                
#declare G278     = object { UnitRoofFlat(1, 0.5, 0.25, 0.5) }
#declare G278_1   = object { G278 }
#declare G278_2   = object { Unfinished }
#declare G278_3   = object { Unfinished }
#declare G278_5   = object { Unfinished }

#declare G280     = object { UnitRoofFlat(0.5, 0.5, 0.25, 0.5) }
#declare G280_1   = object { G280 }
#declare G280_2   = object { Unfinished }
#declare G280_3   = object { Unfinished }
#declare G280_4   = object { Unfinished }
#declare G280_5   = object { Unfinished }

#declare G281     = object { UnitRoofFlat(0.25, 0.5, 0.25, 0.5) }
#declare G281_1   = object { G281 }
#declare G281_2   = object { Unfinished }
#declare G281_3   = object { Unfinished }
#declare G281_5   = object { Unfinished }

#declare G282     = object { UnitRoofTop(0.5, 0.25, 0.5, 0.25, 0.5) }
#declare G282_1   = object { G282 }

#declare G284     = object { UnitRoofTop(2, 1, 1, 0.05, 1.75)}
#declare G284_1   = object { G284 }
#declare G284_2   = object { Unfinished }
#declare G284_3   = object { Unfinished }
#declare G284_4   = object { Unfinished }

#declare G286     = object { UnitRoofTop(1.5, 0.5, 1, 0.05, 1.75)}
#declare G286_1   = object { G286 }
#declare G286_2   = object { Unfinished }
#declare G286_3   = object { Unfinished }
#declare G286_4   = object { Unfinished }

#declare G288     = object { UnitRoofTop(1, 0.05, 1, 0.05, 1.75) }                                                     
#declare G288_1   = object { G288 }
#declare G288_2   = object { Unfinished }
#declare G288_3   = object { Unfinished }
#declare G288_6x  = object { Unfinished }

#declare G289     = object { UnitRoofTop(1.5, 1.1, 0.5, 0.1, 1.4) }
#declare G289_1   = object { G289 }

#declare G290     = object { UnitRoofTop(1.25, 0.85, 0.5, 0.1, 1.4) }
#declare G290_1   = object { G290 }

#declare G291     = object { UnitRoofTop(1, 0.6, 0.5, 0.1, 1.4) }
#declare G291_1   = object { G291 }

#declare G292     = object { UnitRoofTop(0.75, 0.35, 0.5, 0.1, 1.4) }
#declare G292_1   = object { G292 }

#declare G293     = object { UnitRoofTop(0.5, 0.1, 0.5, 0.1, 1.4)}
#declare G293_1   = object { G293 }

#declare G297     = object { UnitRoofFlat(0.25, 0.75, 0.5, 1) }
#declare G297_1   = object { G297 }
#declare G297_2   = object { Unfinished }
#declare G297_3   = object { Unfinished }
#declare G297_5   = object { Unfinished }

#declare G299     = object { Unfinished } 
#declare G299_1   = object { Unfinished }

#declare G300_1   = object { Unfinished }

#declare G301     = object { Unfinished }
#declare G301_1   = object { Unfinished }

#declare G302     = object { UnitRoofTop(0.75, 0.5, 0.75, 0.5, 1)}
#declare G302_1   = object { G302 }

#declare GKK90_1  = object { UnitRoofTop(0.4, 0.05, 0.4, 0.05, 1.2) }

/* - Rounded parts ----------------------------------------------------- */

#declare G316_1   = object { UnitRoundedCorner(1, 1, 1, 1) }
#declare G316_2   = object { G316_1 rotate <0, 0, -90> rotate <0, 90, 0> translate <0, 80, 80>}
#declare G316_3   = object { G316_2 translate <0,-79,0> }
#declare G316_4   = union {
                      object { G316_2 rotate <0,45,0> translate <20,0,20> }
                      object { G316_2 rotate <0,135,0> translate <20,0,133> }
                      object { G316_2 rotate <0,225,0> translate <133,0,133> }
                      object { G316_2 rotate <0,315,0> translate <133,0,20> }
                    }

#declare G318     = object { UnitRoundedCorner(1, 0.5, 1, 1) }
#declare G318_1   = object { G318 translate <0, 0, 0> }
#declare G318_2   = object { G318 rotate <0, 0, -90> rotate <0, 90, 0> translate <0, 40, 80>}

#declare G319     = object { UnitRoundedCorner(1, 0.25, 1, 1) }
#declare G319_1   = object { G319 translate <0, 0, 0> }
#declare G319_2   = object { G319 rotate <0, 0, 90> rotate <0, 180, 0> translate <0, 0, 80>}

#declare G320_1   = intersection {
                      object { G316_1 }
                      object { G316_1 rotate <0, 90, 0> translate <0, 0, 80>}
                    }
#declare G320_2   = object { G320_1 rotate <-90,0,0> scale <1,1,-1> translate <0,0,0>}
#declare G320_3   = object { G320_1 rotate <-90,180,0> scale <1,1,1> translate <80,0,0>}

#declare G321     = object { UnitRoundedRoof(1.0, 0.5, 1.25, 1.75) }
#declare G321_1   = object { G321 }
#declare G321_2   = object { G321_1 rotate <-90,0,0> translate <0,0,100> }

#declare G322     = object { UnitRoundedRoof(0.75, 0.5, 1.25, 1.75) }
#declare G322_1   = object { G322 }
#declare G322_2   = object { G322_1 rotate <-90,0,0> translate <0,0,100> }

#declare G323     = object { UnitRoundedRoof(0.5, 0.5, 1.25, 1.75) }
#declare G323_1   = object { G323 }
#declare G323_2   = object { G323_1 rotate <-90,0,0> translate <0,0,100> }

#declare G324     = object { UnitRoundedRoof(0.25, 0.5, 1.25, 1.75) }
#declare G324_1   = object { G324 }
#declare G324_2   = object { G324_1 rotate <-90,0,0> translate <0,0,100> }

#declare G325_1   = intersection {
                      object { G323_1 }
                      object { G323_1 rotate <0, -90, 0> translate <40, 0, 0>}
                    }

#declare G326_1   = intersection {
                      union {
                        object { G321_2 }
                        object { G321_2 translate <20,0,0>}
                      }
                      union {
                        object { G321_2 rotate <0, -90, 0> translate <100, 0, 20>}
                        object { G321_2 rotate <0, -90, 0> translate <100, 0, 0>}
                      }
                    }


#declare G332_1   = object { UnitRoundedEnd(1, 1, 0.5) }
#declare G332_2   = object { G332_1 scale <1, -1, 1> translate <0, 40, 0> }
#declare G332_3   = object { G332_1 rotate <90, 0, 0> translate <0, 80, 0> }
#declare G332_4   = object { G332_3 scale <1, 1, -1> translate<0, 0, 40> }
                             
#declare G334_1   = object { UnitRoundedEnd(1, 0.5, 0.5) }
#declare G334_2   = object { G334_1 scale <1, -1, 1> translate <0, 40, 0> }
#declare G334_3   = object { G334_1 rotate <90, 0, 0> translate <0, 40, 0> }
#declare G334_4   = object { G334_3 scale <1, 1, -1> translate<0, 0, 40> }

#declare G335_1   = object { UnitRoundedEnd(1, 0.25, 0.5) }
#declare G335_2   = object { G335_1 scale <1, -1, 1> translate <0, 40, 0> }
#declare G335_3   = object { G335_1 rotate <90, 0, 0> translate <0, 20, 0> }
#declare G335_4   = object { G335_3 scale <1, 1, -1> translate<0, 0, 40> }

#declare G336_1   = intersection {
                      object { G332_1 }
                      object { G332_1 rotate <0, 90, 0> translate <0, 0, 80>}
                    }


#declare G337_1   = object { UnitRoundedEnd(2, 1, 0.5) }
#declare G337_2   = object { G337_1 scale <1, -1, 1> translate <0, 40, 0> }
#declare G337_3   = object { G337_1 rotate <90, 0, 0> translate <0, 80, 0> }
#declare G337_4   = object { G337_3 scale <1, 1, -1> translate<0, 0, 40> }

#declare G339_1   = object { UnitRoundedEnd(2, 0.5, 0.5) }
#declare G339_2   = object { G339_1 scale <1, -1, 1> translate <0, 40, 0> }
#declare G339_3   = object { G339_1 rotate <90, 0, 0> translate <0, 40, 0> }
#declare G339_4   = object { G339_3 scale <1, 1, -1> translate<0, 0, 40> }
             
/* - Block with one curner 'shaved' ------------------------------------ */

#declare G412     = object { Unfinished }
#declare G412_1   = object { Unfinished }
#declare G412_2   = object { Unfinished }
#declare G412_3   = object { Unfinished }
#declare G412_4   = object { Unfinished }
#declare G412_5   = object { Unfinished }
#declare G412_6   = object { Unfinished }

#declare G430     = object { Unfinished }
#declare G430_1   = object { Unfinished }

#declare G448     = object { Unfinished }
#declare G448_1   = object { Unfinished }

#declare G450     = object { Unfinished }
#declare G450_1   = object { Unfinished }

#declare G451     = object { Unfinished }
#declare G451_1   = object { Unfinished }

#declare G523     = object { Unfinished }
#declare G523_1   = object { Unfinished }

#declare G525     = object { Unfinished }
#declare G525_1   = object { Unfinished }

/* - Bridge ------------------------------------------------------------ */

#declare GDS103_1 = object { GDS103Pat(Color3m) }

#declare GDS110_1 = object { GDS110Pat(Color5m, Color3m) }
             
#declare GDS103_1_tin = object { GDS103Pat(ColorTin) }

#declare GDS110_1_tin = object { GDS110Pat(ColorTin, ColorTin) }
             
/* - Miscellaneous ----------------------------------------------------- */

#declare GKasten     = object { box {<0, 0, 0>, <13*80, 2*80, 9*80>} }
#declare GKasten_1   = object { GKasten }
#declare GKasten_2   = object { GKasten rotate <-90, -90, 0> translate <0, 0, 0>}
#declare GKasten_3   = object { GKasten rotate <0, 0, 90> translate <160, 0, 0>}

#declare GUhr_1      = object { 
                          box { <0,0,0> <1,1,1>}
                                material { texture {
                                pigment {image_map {png "uhr.png"}} 
                                } }
                                scale <80,-80,2> rotate <0,0,90> rotate <0,90,0> translate <-0,0,80>
                              }  // Face 80x80 
#declare GUhr_2      = object { G108_1 translate <0,0,-79> scale 3/80*z }
#declare GUhr_3      = object { G108_4 translate <0,0,-79> scale 3/80*z }
#declare GUhr_4      = object { GUhr_1 scale <2,2,2> }  // Face 160x160 
#declare GUhr_5      = object { GUhr_1 scale <1.5, 1.5, 1.5> }  // Face 120x120 
#declare GUhr_6      = object { GUhr_1 scale <0.75, 0.75, 0.75> }  // Face 60x60 

#declare GLil1_Dach_1 = object { box {<0, 0, 0>, <226.3, 1, 280> rotate <0, 0, 45>} }
#declare GLil1_Dach_2 = object { box {<0, 0, 0>, <226.3, 1, 400> rotate <0, 0, 45>} }
#declare GLil2_Dach_1 = object { box {<0, 0, 0>, <339.4, 1, 440> rotate <0, 0, 45>} }
#declare GLil2_Dach_2 = object { box {<0, 0, 0>, <169.7, 1, 160> rotate <0, 0, 45>} }
#declare GLil2_Dach_3 = object { box {<0, 0, 0>, <223.6, 1, 200> rotate <0, 0, 60>} }

/* - Composite 'cheats' ------------------------------------------------ */

#declare G101_7   = union {
                      object { G101_2 }
                      object { G316_2 rotate <0, 0, 0> translate <0, 0, 40> material {Color3}}
                    }

#declare G101_8   = union {
                      object { G101_2 }
                      object { G318_2 rotate <0, 0, 0> translate <0, 0, 40> material {Color3}}
                    }

