/*
 * Decompiled with CFR 0.152.
 */
package pxb.android.dex2jar.v3;

import java.util.HashMap;
import java.util.Map;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;
import pxb.android.dex2jar.DexOpcodeDump;
import pxb.android.dex2jar.DexOpcodeUtil;
import pxb.android.dex2jar.DexOpcodes;
import pxb.android.dex2jar.Field;
import pxb.android.dex2jar.Method;
import pxb.android.dex2jar.visitors.DexCodeVisitor;

public class V3CodeAdapter
implements DexCodeVisitor,
Opcodes,
DexOpcodes {
    private MethodVisitor mv;
    private int _regcount = 0;
    private Map<Integer, Integer> map = new HashMap<Integer, Integer>();
    private int maxStack = 0;
    private Map<Label, Type> handlers = new HashMap<Label, Type>();
    private static final int TEMP_REG = Integer.MAX_VALUE;

    private void stack(int a) {
        if (a > this.maxStack) {
            this.maxStack = a;
        }
    }

    private int map(int reg) {
        Integer integer = this.map.get(reg);
        if (integer == null) {
            integer = this._regcount++;
            this.map.put(reg, integer);
        }
        return integer;
    }

    public V3CodeAdapter(MethodVisitor mv) {
        this.mv = mv;
    }

    @Override
    public void visitInitLocal(int ... args) {
        for (int i : args) {
            this.map(i);
        }
        this.map(Integer.MAX_VALUE);
    }

    @Override
    public void visitArrayInsn(int opcode, int regFromOrTo, int array, int index) {
        this.checkResult();
        switch (opcode) {
            case 75: 
            case 78: 
            case 79: 
            case 80: 
            case 81: {
                this.mv.visitVarInsn(25, this.map(array));
                this.mv.visitVarInsn(21, this.map(index));
                this.mv.visitVarInsn(21, this.map(regFromOrTo));
                this.mv.visitInsn(DexOpcodeUtil.mapOpcode(opcode));
                this.stack(3);
                break;
            }
            case 76: {
                this.mv.visitVarInsn(25, this.map(array));
                this.mv.visitVarInsn(21, this.map(index));
                this.mv.visitVarInsn(22, this.map(regFromOrTo));
                this.mv.visitInsn(80);
                this.stack(3);
                break;
            }
            case 77: {
                this.mv.visitVarInsn(25, this.map(array));
                this.mv.visitVarInsn(21, this.map(index));
                this.mv.visitVarInsn(25, this.map(regFromOrTo));
                this.mv.visitInsn(83);
                this.stack(3);
                break;
            }
            case 68: 
            case 71: 
            case 72: 
            case 73: 
            case 74: {
                this.mv.visitVarInsn(25, this.map(array));
                this.mv.visitVarInsn(21, this.map(index));
                this.mv.visitInsn(DexOpcodeUtil.mapOpcode(opcode));
                this.mv.visitVarInsn(54, this.map(regFromOrTo));
                this.stack(2);
                break;
            }
            case 69: {
                this.mv.visitVarInsn(25, this.map(array));
                this.mv.visitVarInsn(21, this.map(index));
                this.mv.visitInsn(47);
                this.mv.visitVarInsn(55, this.map(regFromOrTo));
                this.stack(2);
                break;
            }
            case 70: {
                this.mv.visitVarInsn(25, this.map(array));
                this.mv.visitVarInsn(21, this.map(index));
                this.mv.visitInsn(50);
                this.mv.visitVarInsn(58, this.map(regFromOrTo));
                this.stack(2);
                break;
            }
            default: {
                throw new RuntimeException(String.format("Not support Opcode:[0x%04x]=%s yet!", opcode, DexOpcodeDump.dump(opcode)));
            }
        }
    }

    @Override
    public void visitArrayInsn(int opcode, String type, int saveToReg, int demReg) {
        this.checkResult();
        switch (opcode) {
            case 35: {
                this.mv.visitVarInsn(21, this.map(demReg));
                int shortType = Type.getType((String)type).getElementType().getSort();
                switch (shortType) {
                    case 1: {
                        this.mv.visitIntInsn(188, 4);
                        break;
                    }
                    case 3: {
                        this.mv.visitIntInsn(188, 8);
                        break;
                    }
                    case 2: {
                        this.mv.visitIntInsn(188, 5);
                        break;
                    }
                    case 8: {
                        this.mv.visitIntInsn(188, 7);
                        break;
                    }
                    case 6: {
                        this.mv.visitIntInsn(188, 6);
                        break;
                    }
                    case 5: {
                        this.mv.visitIntInsn(188, 10);
                        break;
                    }
                    case 10: {
                        this.mv.visitTypeInsn(189, type);
                    }
                }
                this.mv.visitVarInsn(58, this.map(saveToReg));
                this.stack(2);
                break;
            }
            default: {
                throw new RuntimeException(String.format("Not support Opcode:[0x%04x]=%s yet!", opcode, DexOpcodeDump.dump(opcode)));
            }
        }
    }

    @Override
    public void visitEnd() {
        this.checkResult();
        this.mv.visitMaxs(this.maxStack, this._regcount);
        this.mv.visitEnd();
    }

    @Override
    public void visitFieldInsn(int opcode, Field field, int regFromOrTo, int ownerReg) {
        this.checkResult();
        switch (opcode) {
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: {
                this.mv.visitVarInsn(25, this.map(ownerReg));
                this.mv.visitFieldInsn(180, field.getOwner(), field.getName(), field.getType());
                switch (opcode) {
                    case 82: 
                    case 85: 
                    case 86: 
                    case 87: 
                    case 88: {
                        this.mv.visitVarInsn(54, this.map(regFromOrTo));
                        break;
                    }
                    case 83: {
                        this.mv.visitVarInsn(55, this.map(regFromOrTo));
                        break;
                    }
                    case 84: {
                        this.mv.visitVarInsn(58, this.map(regFromOrTo));
                    }
                }
                this.stack(1);
                break;
            }
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: {
                this.mv.visitVarInsn(25, this.map(ownerReg));
                switch (opcode) {
                    case 89: 
                    case 92: 
                    case 93: 
                    case 94: 
                    case 95: {
                        this.mv.visitVarInsn(21, this.map(regFromOrTo));
                        break;
                    }
                    case 90: {
                        this.mv.visitVarInsn(22, this.map(regFromOrTo));
                        break;
                    }
                    case 91: {
                        this.mv.visitVarInsn(25, this.map(regFromOrTo));
                    }
                }
                this.stack(2);
                this.mv.visitFieldInsn(181, field.getOwner(), field.getName(), field.getType());
                break;
            }
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: {
                switch (opcode) {
                    case 105: {
                        this.mv.visitVarInsn(25, this.map(regFromOrTo));
                        break;
                    }
                    case 103: 
                    case 106: 
                    case 107: 
                    case 108: 
                    case 109: {
                        this.mv.visitVarInsn(21, this.map(regFromOrTo));
                        break;
                    }
                    case 104: {
                        this.mv.visitVarInsn(22, this.map(regFromOrTo));
                    }
                }
                this.mv.visitFieldInsn(179, field.getOwner(), field.getName(), field.getType());
                this.stack(1);
                break;
            }
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: {
                this.mv.visitFieldInsn(178, field.getOwner(), field.getName(), field.getType());
                switch (opcode) {
                    case 98: {
                        this.mv.visitVarInsn(58, this.map(regFromOrTo));
                        break;
                    }
                    case 97: {
                        this.mv.visitVarInsn(55, this.map(regFromOrTo));
                        break;
                    }
                    case 96: 
                    case 99: 
                    case 100: 
                    case 101: 
                    case 102: {
                        this.mv.visitVarInsn(54, this.map(regFromOrTo));
                    }
                }
                this.stack(1);
                break;
            }
            default: {
                throw new RuntimeException(String.format("Not support Opcode:[0x%04x]=%s yet!", opcode, DexOpcodeDump.dump(opcode)));
            }
        }
    }

    @Override
    public void visitFillArrayInsn(int opcode, int reg, int elemWidth, int initLength, Object[] values) {
        this.checkResult();
        int op = 0;
        switch (elemWidth) {
            case 1: {
                op = 84;
                break;
            }
            case 2: {
                op = 86;
                break;
            }
            case 4: {
                op = 79;
                break;
            }
            case 8: {
                op = 80;
            }
        }
        this.mv.visitVarInsn(25, this.map(reg));
        for (int i = 0; i < initLength; ++i) {
            this.mv.visitInsn(89);
            this.mv.visitLdcInsn((Object)i);
            this.mv.visitLdcInsn(values[i]);
            this.mv.visitInsn(op);
        }
        this.mv.visitVarInsn(58, this.map(reg));
        this.stack(4);
    }

    @Override
    public void visitFilledNewArrayIns(int opcode, String type, int[] regs) {
        this.checkResult();
        Type elem = Type.getType((String)type).getElementType();
        int shortType = elem.getSort();
        this.mv.visitLdcInsn((Object)regs.length);
        switch (shortType) {
            case 1: {
                this.mv.visitIntInsn(188, 4);
                break;
            }
            case 3: {
                this.mv.visitIntInsn(188, 8);
                break;
            }
            case 2: {
                this.mv.visitIntInsn(188, 5);
                break;
            }
            case 8: {
                this.mv.visitIntInsn(188, 7);
                break;
            }
            case 6: {
                this.mv.visitIntInsn(188, 6);
                break;
            }
            case 5: {
                this.mv.visitIntInsn(188, 10);
                break;
            }
            case 10: {
                this.mv.visitTypeInsn(189, type);
            }
        }
        int store = elem.getOpcode(79);
        int load = elem.getOpcode(21);
        for (int i = 0; i < regs.length; ++i) {
            this.mv.visitInsn(89);
            this.mv.visitLdcInsn((Object)i);
            this.mv.visitVarInsn(load, this.map(regs[i]));
            this.mv.visitInsn(store);
        }
        this.mv.visitVarInsn(58, this.map(Integer.MAX_VALUE));
        this.stack(4);
    }

    @Override
    public void visitInInsn(int opcode, int saveToReg, int opReg) {
        this.checkResult();
        switch (opcode) {
            case 176: 
            case 177: 
            case 178: 
            case 179: 
            case 180: 
            case 181: 
            case 182: 
            case 183: 
            case 184: 
            case 185: 
            case 186: 
            case 187: 
            case 188: 
            case 189: 
            case 190: 
            case 191: 
            case 192: 
            case 193: 
            case 194: 
            case 195: 
            case 196: 
            case 197: 
            case 198: 
            case 199: 
            case 200: 
            case 201: 
            case 202: 
            case 203: 
            case 204: 
            case 205: 
            case 206: 
            case 207: {
                int load = 0;
                int store = 0;
                switch (opcode) {
                    case 176: 
                    case 177: 
                    case 178: 
                    case 179: 
                    case 180: 
                    case 181: 
                    case 182: 
                    case 183: 
                    case 184: 
                    case 185: 
                    case 186: {
                        load = 21;
                        store = 54;
                        break;
                    }
                    case 187: 
                    case 188: 
                    case 189: 
                    case 190: 
                    case 191: 
                    case 192: 
                    case 193: 
                    case 194: 
                    case 195: 
                    case 196: 
                    case 197: {
                        load = 22;
                        store = 55;
                        break;
                    }
                    case 198: 
                    case 199: 
                    case 200: 
                    case 201: 
                    case 202: {
                        load = 23;
                        store = 56;
                        break;
                    }
                    case 203: 
                    case 204: 
                    case 205: 
                    case 206: 
                    case 207: {
                        load = 24;
                        store = 57;
                    }
                }
                this.mv.visitVarInsn(load, this.map(saveToReg));
                this.mv.visitVarInsn(load, this.map(opReg));
                this.mv.visitInsn(DexOpcodeUtil.mapOpcode(opcode));
                this.mv.visitVarInsn(store, this.map(saveToReg));
                this.stack(2);
                break;
            }
            case 33: 
            case 123: 
            case 125: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 142: 
            case 143: {
                int load = 0;
                int store = 0;
                switch (opcode) {
                    case 123: {
                        load = 21;
                        store = 54;
                        break;
                    }
                    case 128: {
                        load = 24;
                        store = 54;
                        break;
                    }
                    case 127: {
                        load = 23;
                        store = 54;
                        break;
                    }
                    case 125: {
                        load = 22;
                        store = 54;
                        break;
                    }
                    case 141: {
                        load = 21;
                        store = 54;
                        break;
                    }
                    case 143: {
                        load = 21;
                        store = 54;
                        break;
                    }
                    case 142: {
                        load = 21;
                        store = 54;
                        break;
                    }
                    case 130: {
                        load = 21;
                        store = 56;
                        break;
                    }
                    case 131: {
                        load = 21;
                        store = 57;
                        break;
                    }
                    case 129: {
                        load = 21;
                        store = 55;
                        break;
                    }
                    case 134: {
                        load = 22;
                        store = 57;
                        break;
                    }
                    case 133: {
                        load = 22;
                        store = 56;
                        break;
                    }
                    case 132: {
                        load = 22;
                        store = 54;
                        break;
                    }
                    case 140: {
                        load = 24;
                        store = 56;
                        break;
                    }
                    case 138: {
                        load = 24;
                        store = 54;
                        break;
                    }
                    case 139: {
                        load = 24;
                        store = 55;
                        break;
                    }
                    case 135: {
                        load = 23;
                        store = 54;
                        break;
                    }
                    case 136: {
                        load = 23;
                        store = 55;
                        break;
                    }
                    case 137: {
                        load = 23;
                        store = 57;
                        break;
                    }
                    case 33: {
                        load = 25;
                        store = 54;
                    }
                }
                this.mv.visitVarInsn(load, this.map(opReg));
                this.mv.visitInsn(DexOpcodeUtil.mapOpcode(opcode));
                this.mv.visitVarInsn(store, this.map(saveToReg));
                this.stack(1);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                int load = 0;
                int store = 0;
                switch (opcode) {
                    case 7: 
                    case 8: {
                        load = 25;
                        store = 58;
                        break;
                    }
                    case 1: 
                    case 2: {
                        load = 21;
                        store = 54;
                        break;
                    }
                    case 4: 
                    case 5: {
                        load = 22;
                        store = 55;
                    }
                }
                this.mv.visitVarInsn(load, this.map(opReg));
                this.mv.visitVarInsn(store, this.map(saveToReg));
                this.stack(1);
                break;
            }
            default: {
                throw new RuntimeException(String.format("Not support Opcode:[0x%04x]=%s yet!", opcode, DexOpcodeDump.dump(opcode)));
            }
        }
    }

    @Override
    public void visitInInsn(int opcode, int saveToReg, int opReg, int opValueOrReg) {
        this.checkResult();
        switch (opcode) {
            case 216: 
            case 218: 
            case 219: 
            case 220: 
            case 221: 
            case 222: 
            case 223: 
            case 224: 
            case 225: 
            case 226: {
                this.mv.visitVarInsn(21, this.map(opReg));
                this.mv.visitLdcInsn((Object)opValueOrReg);
                this.mv.visitInsn(DexOpcodeUtil.mapOpcode(opcode));
                this.mv.visitVarInsn(54, this.map(saveToReg));
                this.stack(2);
                break;
            }
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 144: 
            case 145: 
            case 146: 
            case 147: 
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 152: 
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 167: 
            case 168: 
            case 169: 
            case 170: 
            case 171: 
            case 172: 
            case 173: 
            case 174: 
            case 175: {
                int load = 0;
                int store = 0;
                switch (opcode) {
                    case 144: 
                    case 145: 
                    case 146: 
                    case 147: 
                    case 148: 
                    case 149: 
                    case 150: 
                    case 151: 
                    case 152: 
                    case 153: 
                    case 154: {
                        load = 21;
                        store = 54;
                        break;
                    }
                    case 49: 
                    case 155: 
                    case 156: 
                    case 157: 
                    case 158: 
                    case 159: 
                    case 160: 
                    case 161: 
                    case 162: 
                    case 163: 
                    case 164: 
                    case 165: {
                        load = 22;
                        store = 55;
                        break;
                    }
                    case 45: 
                    case 46: 
                    case 166: 
                    case 167: 
                    case 168: 
                    case 169: 
                    case 170: {
                        load = 23;
                        store = 56;
                        break;
                    }
                    case 47: 
                    case 48: 
                    case 171: 
                    case 172: 
                    case 173: 
                    case 174: 
                    case 175: {
                        load = 24;
                        store = 57;
                    }
                }
                this.mv.visitVarInsn(load, this.map(opValueOrReg));
                this.mv.visitVarInsn(load, this.map(opReg));
                this.mv.visitInsn(DexOpcodeUtil.mapOpcode(opcode));
                this.mv.visitVarInsn(store, this.map(saveToReg));
                this.stack(2);
                break;
            }
            case 208: 
            case 210: 
            case 211: 
            case 212: 
            case 213: 
            case 214: 
            case 215: {
                this.mv.visitVarInsn(21, this.map(opReg));
                this.mv.visitLdcInsn((Object)opValueOrReg);
                this.mv.visitInsn(DexOpcodeUtil.mapOpcode(opcode));
                this.mv.visitVarInsn(54, this.map(saveToReg));
                this.stack(2);
                break;
            }
            default: {
                throw new RuntimeException(String.format("Not support Opcode:[0x%04x]=%s yet!", opcode, DexOpcodeDump.dump(opcode)));
            }
        }
    }

    @Override
    public void visitInsn(int opcode) {
        this.checkResult();
        switch (opcode) {
            case 14: {
                this.mv.visitInsn(177);
                break;
            }
            default: {
                throw new RuntimeException(String.format("Not support Opcode:[0x%04x]=%s yet!", opcode, DexOpcodeDump.dump(opcode)));
            }
        }
    }

    @Override
    public void visitJumpInsn(int opcode, Label label) {
        this.checkResult();
        switch (opcode) {
            case 40: 
            case 41: {
                this.mv.visitJumpInsn(167, label);
                break;
            }
            default: {
                throw new RuntimeException(String.format("Not support Opcode:[0x%04x]=%s yet!", opcode, DexOpcodeDump.dump(opcode)));
            }
        }
    }

    @Override
    public void visitJumpInsn(int opcode, Label label, int reg) {
        this.checkResult();
        this.mv.visitVarInsn(21, this.map(reg));
        this.stack(1);
        switch (opcode) {
            case 57: {
                this.mv.visitJumpInsn(154, label);
                break;
            }
            case 56: {
                this.mv.visitJumpInsn(153, label);
                break;
            }
            case 60: {
                this.mv.visitJumpInsn(157, label);
                break;
            }
            case 59: {
                this.mv.visitJumpInsn(156, label);
                break;
            }
            case 61: {
                this.mv.visitJumpInsn(158, label);
                break;
            }
            case 58: {
                this.mv.visitJumpInsn(155, label);
                break;
            }
            default: {
                throw new RuntimeException(String.format("Not support Opcode:[0x%04x]=%s yet!", opcode, DexOpcodeDump.dump(opcode)));
            }
        }
    }

    @Override
    public void visitJumpInsn(int opcode, Label label, int reg1, int reg2) {
        this.checkResult();
        this.mv.visitVarInsn(21, this.map(reg1));
        this.mv.visitVarInsn(21, this.map(reg2));
        this.mv.visitJumpInsn(DexOpcodeUtil.mapOpcode(opcode), label);
        this.stack(2);
    }

    @Override
    public void visitLabel(Label label) {
        this.checkResult();
        this.mv.visitLabel(label);
        if (this.handlers.containsKey(label)) {
            // empty if block
        }
    }

    @Override
    public void visitLdcInsn(int opcode, Object value, int reg) {
        this.checkResult();
        switch (opcode) {
            case 26: 
            case 28: {
                this.mv.visitLdcInsn(value);
                this.mv.visitVarInsn(58, this.map(reg));
                this.stack(1);
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                this.mv.visitLdcInsn(value);
                this.mv.visitVarInsn(54, this.map(reg));
                this.stack(1);
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                this.mv.visitLdcInsn(value);
                this.mv.visitVarInsn(55, this.map(reg));
                this.stack(1);
                break;
            }
            default: {
                throw new RuntimeException(String.format("Not support Opcode:[0x%04x]=%s yet!", opcode, DexOpcodeDump.dump(opcode)));
            }
        }
    }

    @Override
    public void visitLineNumber(int line, Label label) {
        this.mv.visitLineNumber(line, label);
    }

    @Override
    public void visitLocalVariable(String name, String type, String signature, Label start, Label end, int reg) {
        this.mv.visitLocalVariable(name, type, signature, start, end, this.map(reg));
    }

    @Override
    public void visitLookupSwitchInsn(int opcode, int reg, Label defaultOffset, int[] cases, Label[] labels) {
        this.checkResult();
        switch (opcode) {
            case 44: {
                this.mv.visitVarInsn(21, this.map(reg));
                this.mv.visitLookupSwitchInsn(defaultOffset, cases, labels);
                this.stack(1);
            }
        }
    }

    private void loadArgument(Method method, int[] registers, boolean isStatic) {
        int i = 0;
        if (!isStatic) {
            this.mv.visitVarInsn(25, this.map(registers[i++]));
        }
        for (String s : method.getType().getParameterTypes()) {
            this.mv.visitVarInsn(Type.getType((String)s).getOpcode(21), this.map(registers[i++]));
        }
        this.stack(registers.length);
    }

    @Override
    public void visitMethodInsn(int opcode, Method method, int[] args) {
        this.checkResult();
        block0 : switch (opcode) {
            case 113: {
                this.stack(args.length);
                this.loadArgument(method, args, true);
                this.mv.visitMethodInsn(184, method.getOwner(), method.getName(), method.getType().getDesc());
                break;
            }
            default: {
                this.stack(1 + args.length);
                this.loadArgument(method, args, false);
                switch (opcode) {
                    case 111: 
                    case 112: {
                        this.mv.visitMethodInsn(183, method.getOwner(), method.getName(), method.getType().getDesc());
                        break block0;
                    }
                    case 110: {
                        this.mv.visitMethodInsn(182, method.getOwner(), method.getName(), method.getType().getDesc());
                        break block0;
                    }
                    case 114: {
                        this.mv.visitMethodInsn(185, method.getOwner(), method.getName(), method.getType().getDesc());
                        break block0;
                    }
                }
                throw new RuntimeException(String.format("Not support Opcode:[0x%04x]=%s yet!", opcode, DexOpcodeDump.dump(opcode)));
            }
        }
        Type ret = Type.getType((String)method.getType().getReturnType());
        if (!Type.VOID_TYPE.equals((Object)ret)) {
            this.mv.visitVarInsn(54, this.map(Integer.MAX_VALUE));
        }
    }

    @Override
    public void visitTableSwitchInsn(int opcode, int reg, int first_case, int last_case, Label default_label, Label[] labels) {
        this.checkResult();
        switch (opcode) {
            case 43: {
                this.mv.visitVarInsn(21, this.map(reg));
                this.mv.visitTableSwitchInsn(first_case, last_case, default_label, labels);
                this.stack(1);
            }
        }
    }

    private void checkResult() {
    }

    @Override
    public void visitTryCatch(Label start, Label end, Label handler, String type) {
        this.mv.visitTryCatchBlock(start, end, handler, type);
        if (type == null) {
            type = Type.getDescriptor(Throwable.class);
        }
        this.handlers.put(handler, Type.getType((String)type));
    }

    @Override
    public void visitTypeInsn(int opcode, String type, int toReg) {
        this.checkResult();
        switch (opcode) {
            case 34: {
                this.mv.visitTypeInsn(187, type);
                this.mv.visitVarInsn(58, this.map(toReg));
                this.stack(1);
                break;
            }
            case 28: {
                this.mv.visitLdcInsn((Object)Type.getType((String)type));
                this.mv.visitVarInsn(58, this.map(toReg));
                this.stack(1);
                break;
            }
            case 31: {
                this.mv.visitVarInsn(25, this.map(toReg));
                this.mv.visitTypeInsn(192, type);
                this.mv.visitVarInsn(58, this.map(toReg));
                this.stack(1);
                break;
            }
            default: {
                throw new RuntimeException(String.format("Not support Opcode:[0x%04x]=%s yet!", opcode, DexOpcodeDump.dump(opcode)));
            }
        }
    }

    @Override
    public void visitTypeInsn(int opcode, String type, int toReg, int fromReg) {
        this.checkResult();
        switch (opcode) {
            case 32: {
                this.mv.visitVarInsn(25, this.map(fromReg));
                this.mv.visitTypeInsn(193, type);
                this.mv.visitVarInsn(54, this.map(toReg));
                this.stack(1);
                break;
            }
            default: {
                throw new RuntimeException(String.format("Not support Opcode:[0x%04x]=%s yet!", opcode, DexOpcodeDump.dump(opcode)));
            }
        }
    }

    @Override
    public void visitVarInsn(int opcode, int reg) {
        switch (opcode) {
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                break;
            }
            default: {
                this.checkResult();
            }
        }
        switch (opcode) {
            case 10: 
            case 11: 
            case 12: {
                this.mv.visitVarInsn(21, this.map(Integer.MAX_VALUE));
                this.mv.visitVarInsn(54, this.map(reg));
                this.stack(1);
                break;
            }
            case 13: {
                this.mv.visitVarInsn(58, this.map(reg));
                this.stack(1);
                break;
            }
            case 39: {
                this.mv.visitVarInsn(25, this.map(reg));
                this.mv.visitInsn(191);
                this.stack(1);
                break;
            }
            case 15: {
                this.mv.visitVarInsn(21, this.map(reg));
                this.mv.visitInsn(172);
                this.stack(1);
                break;
            }
            case 17: {
                this.mv.visitVarInsn(25, this.map(reg));
                this.mv.visitInsn(176);
                this.stack(1);
                break;
            }
            case 16: {
                this.mv.visitVarInsn(22, this.map(reg));
                this.mv.visitInsn(173);
                this.stack(1);
                break;
            }
            case 29: {
                this.mv.visitVarInsn(25, this.map(reg));
                this.mv.visitInsn(194);
                this.stack(1);
                break;
            }
            case 30: {
                this.mv.visitVarInsn(25, this.map(reg));
                this.mv.visitInsn(195);
                this.stack(1);
                break;
            }
            default: {
                throw new RuntimeException(String.format("Not support Opcode:[0x%04x]=%s yet!", opcode, DexOpcodeDump.dump(opcode)));
            }
        }
    }
}

