/*
 * Decompiled with CFR 0.152.
 */
package pxb.android.dex2jar.v3;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pxb.android.dex2jar.ClassVisitorFactory;
import pxb.android.dex2jar.Version;
import pxb.android.dex2jar.reader.DexFileReader;
import pxb.android.dex2jar.v3.V3;
import pxb.android.dex2jar.v3.V3AccessFlagsAdapter;

public class Main {
    private static final Logger log = LoggerFactory.getLogger(Main.class);

    public static void main(String ... args) {
        System.out.println("version:" + Version.getVersionString());
        if (args.length == 0) {
            System.err.println("dex2jar file1.dexORapk file2.dexORapk ...");
            return;
        }
        String jreVersion = System.getProperty("java.specification.version");
        if (jreVersion.compareTo("1.6") < 0) {
            System.err.println("A JRE version >=1.6 is required");
            return;
        }
        for (String file : args) {
            File dex = new File(file);
            File gen = new File(file + ".dex2jar.jar");
            log.info("dex2jar {} -> {}", (Object)dex, (Object)gen);
            try {
                Main.doFile(dex, gen);
            }
            catch (IOException e) {
                log.warn("Exception while process file " + dex, (Throwable)e);
            }
        }
        System.out.println("Done.");
    }

    public static void doData(byte[] data, File destJar) throws IOException {
        final ZipOutputStream zos = new ZipOutputStream(FileUtils.openOutputStream((File)destJar));
        DexFileReader reader = new DexFileReader(data);
        V3AccessFlagsAdapter afa = new V3AccessFlagsAdapter();
        reader.accept(afa);
        reader.accept(new V3(afa.getAccessFlagsMap(), new ClassVisitorFactory(){

            @Override
            public ClassVisitor create(final String name) {
                return new ClassWriter(1){

                    public void visitEnd() {
                        super.visitEnd();
                        try {
                            byte[] data = this.toByteArray();
                            ZipEntry entry = new ZipEntry(name + ".class");
                            zos.putNextEntry(entry);
                            zos.write(data);
                            zos.closeEntry();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                };
            }
        }));
        zos.finish();
        zos.close();
    }

    public static void doFile(File srcDex) throws IOException {
        Main.doFile(srcDex, new File(srcDex.getParentFile(), srcDex.getName() + ".dex2jar.jar"));
    }

    public static void doFile(File srcDex, File destJar) throws IOException {
        byte[] data = FileUtils.readFileToByteArray((File)srcDex);
        if ("dex".equals(new String(data, 0, 3))) {
            Main.doData(data, destJar);
        } else if ("PK".equals(new String(data, 0, 2))) {
            ZipInputStream zis = new ZipInputStream(new ByteArrayInputStream(data));
            ZipEntry entry = zis.getNextEntry();
            while (entry != null) {
                if (entry.getName().equals("classes.dex")) {
                    data = IOUtils.toByteArray((InputStream)zis);
                    Main.doData(data, destJar);
                }
                entry = zis.getNextEntry();
            }
        } else {
            throw new RuntimeException("the src file not a .dex file or a zip file");
        }
    }
}

