/*
 * Decompiled with CFR 0.152.
 */
package pxb.android.dex2jar.reader;

import java.util.HashMap;
import java.util.Map;
import org.objectweb.asm.Label;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pxb.android.dex2jar.DataIn;
import pxb.android.dex2jar.Dex;
import pxb.android.dex2jar.DexOpcodeDump;
import pxb.android.dex2jar.DexOpcodeUtil;
import pxb.android.dex2jar.DexOpcodes;
import pxb.android.dex2jar.Method;
import pxb.android.dex2jar.reader.DexOpcodeAdapter;
import pxb.android.dex2jar.visitors.DexCodeVisitor;

public class DexCodeReader
implements DexOpcodes {
    private static final Logger log = LoggerFactory.getLogger(DexCodeReader.class);
    private Dex dex;
    private DataIn in;
    private Map<Integer, Label> labels = new HashMap<Integer, Label>();
    private Method method;

    public DexCodeReader(Dex dex, DataIn in, Method method) {
        this.dex = dex;
        this.in = in;
        this.method = method;
    }

    public void accept(DexCodeVisitor dcv) {
        short elemWidth;
        short switch_size;
        int x;
        int a;
        int opcode;
        int args_index;
        int[] args;
        DataIn in = this.in;
        DexOpcodeAdapter tadoa = new DexOpcodeAdapter(this.dex, dcv, this.labels);
        short total_registers_size = in.readShortx();
        short in_register_size = in.readShortx();
        in.readShortx();
        int tries_size = in.readShortx();
        int debug_off = in.readIntx();
        int instruction_size = in.readIntx();
        int i = total_registers_size - in_register_size;
        if ((this.method.getAccessFlags() & 8) == 0) {
            args = new int[this.method.getType().getParameterTypes().length + 1];
            args[0] = i++;
            args_index = 1;
        } else {
            args = new int[this.method.getType().getParameterTypes().length];
            args_index = 0;
        }
        for (String type : this.method.getType().getParameterTypes()) {
            args[args_index++] = i++;
            if (!"D".equals(type) && !"J".equals(type)) continue;
            ++i;
        }
        dcv.visitInitLocal(args);
        if (tries_size > 0) {
            in.push();
            in.skip(instruction_size * 2);
            if (in.needPadding()) {
                in.skip(2);
            }
            for (int i2 = 0; i2 < tries_size; ++i2) {
                int start = in.readIntx() * 2;
                int offset = in.readShortx() * 2;
                short handlers = in.readShortx();
                in.push();
                in.skip((tries_size - i2 - 1) * 8 + handlers);
                boolean catchAll = false;
                int listSize = (int)in.readSignedLeb128();
                if (listSize <= 0) {
                    listSize = -listSize;
                    catchAll = true;
                }
                for (int k = 0; k < listSize; ++k) {
                    int type_id = (int)in.readUnsignedLeb128();
                    int handler = (int)in.readUnsignedLeb128() * 2;
                    this.order(start);
                    int end = 0;
                    if (handler > start && handler < start + offset) {
                        end = handler;
                        this.order(handler);
                    } else {
                        end = start + offset;
                        this.order(start + offset);
                        this.order(handler);
                    }
                    String type = this.dex.getType(type_id);
                    dcv.visitTryCatch(this.labels.get(start), this.labels.get(end), this.labels.get(handler), type);
                }
                if (catchAll) {
                    int handler = (int)in.readUnsignedLeb128() * 2;
                    this.order(start);
                    int end = 0;
                    if (handler > start && handler < start + offset) {
                        end = handler;
                        this.order(handler);
                    } else {
                        end = start + offset;
                        this.order(start + offset);
                        this.order(handler);
                    }
                    dcv.visitTryCatch(this.labels.get(start), this.labels.get(end), this.labels.get(handler), null);
                }
                in.pop();
            }
            in.pop();
        }
        if (debug_off != 0) {
            // empty if block
        }
        in.push();
        int baseOffset = in.getCurrentPosition();
        int currentOffset = 0;
        while (currentOffset < instruction_size * 2) {
            opcode = in.readByte() & 0xFF;
            int size = DexOpcodeUtil.getSize(opcode);
            switch (size) {
                case 1: {
                    a = in.readByte();
                    switch (opcode) {
                        case 40: {
                            this.order(currentOffset + (byte)a * 2);
                        }
                    }
                    break;
                }
                case 2: {
                    in.skip(1);
                    short b = in.readShortx();
                    switch (opcode) {
                        case 41: 
                        case 50: 
                        case 51: 
                        case 52: 
                        case 53: 
                        case 54: 
                        case 55: 
                        case 56: 
                        case 57: 
                        case 58: 
                        case 59: 
                        case 60: 
                        case 61: {
                            this.order(currentOffset + b * 2);
                        }
                    }
                    break;
                }
                case 3: {
                    in.skip(5);
                    break;
                }
                case 0: {
                    x = in.readByte();
                    switch (x) {
                        case 0: {
                            break;
                        }
                        case 1: {
                            switch_size = in.readShortx();
                            in.skip(4);
                            in.skip(switch_size * 4);
                            break;
                        }
                        case 2: {
                            switch_size = in.readShortx();
                            in.skip(switch_size * 8);
                            break;
                        }
                        case 3: {
                            elemWidth = in.readShortx();
                            int initLength = in.readIntx();
                            in.skip(elemWidth * initLength);
                            if (elemWidth != 1 || initLength % 2 == 0) break;
                            in.skip(1);
                            break;
                        }
                    }
                    break;
                }
                case -1: {
                    in.skip(1);
                    int offset = in.readIntx();
                    in.push();
                    in.skip((offset - 3) * 2);
                    switch (opcode) {
                        case 44: {
                            int j;
                            in.readShortx();
                            int switch_size2 = in.readShortx();
                            for (j = 0; j < switch_size2; ++j) {
                                in.readIntx();
                            }
                            for (j = 0; j < switch_size2; ++j) {
                                this.order(currentOffset + in.readIntx() * 2);
                            }
                            this.order(currentOffset + 6);
                            break;
                        }
                        case 43: {
                            int j;
                            in.skip(2);
                            int switch_size2 = in.readShortx();
                            in.skip(4);
                            for (j = 0; j < switch_size2; ++j) {
                                int targetOffset = in.readIntx();
                                this.order(currentOffset + targetOffset * 2);
                            }
                            this.order(currentOffset + 6);
                            break;
                        }
                    }
                    in.pop();
                    break;
                }
                case 5: {
                    in.skip(9);
                }
            }
            currentOffset = in.getCurrentPosition() - baseOffset;
        }
        in.pop();
        int currentOffset2 = 0;
        int baseOffset2 = in.getCurrentPosition();
        while (currentOffset2 < instruction_size * 2) {
            opcode = in.readByte() & 0xFF;
            if (this.labels.containsKey(currentOffset2)) {
                dcv.visitLabel(this.labels.get(currentOffset2));
            }
            tadoa.visitOffset(currentOffset2);
            int size = DexOpcodeUtil.getSize(opcode);
            switch (size) {
                case 1: {
                    a = in.readByte();
                    if (log.isDebugEnabled()) {
                        log.debug(String.format("%04x| %02x%02x           %s", currentOffset2, opcode, a, DexOpcodeDump.dump(opcode)));
                    }
                    tadoa.visit(opcode, a);
                    break;
                }
                case 2: {
                    a = in.readByte();
                    short b = in.readShortx();
                    if (log.isDebugEnabled()) {
                        log.debug(String.format("%04x| %02x%02x %04x      %s", currentOffset2, opcode, a, Short.reverseBytes(b), DexOpcodeDump.dump(opcode)));
                    }
                    tadoa.visit(opcode, a, b);
                    break;
                }
                case 3: {
                    a = in.readByte();
                    short b = in.readShortx();
                    short c = in.readShortx();
                    if (log.isDebugEnabled()) {
                        log.debug(String.format("%04x| %02x%02x %04x %04x %s", currentOffset2, opcode, a, Short.reverseBytes(b), Short.reverseBytes(c), DexOpcodeDump.dump(opcode)));
                    }
                    tadoa.visit(opcode, a, b, c);
                    break;
                }
                case 0: {
                    x = in.readByte();
                    switch (x) {
                        case 0: {
                            break;
                        }
                        case 1: {
                            switch_size = in.readShortx();
                            in.skip(4);
                            in.skip(switch_size * 4);
                            break;
                        }
                        case 2: {
                            switch_size = in.readShortx();
                            in.skip(switch_size * 8);
                            break;
                        }
                        case 3: {
                            elemWidth = in.readShortx();
                            int initLength = in.readIntx();
                            in.skip(elemWidth * initLength);
                            if (elemWidth != 1 || initLength % 2 == 0) break;
                            in.skip(1);
                            break;
                        }
                    }
                    break;
                }
                case -1: {
                    int reg = in.readByte();
                    int offset = in.readIntx();
                    in.push();
                    in.skip((offset - 3) * 2);
                    switch (opcode) {
                        case 44: {
                            int j;
                            in.readShortx();
                            int switch_size3 = in.readShortx();
                            int[] cases = new int[switch_size3];
                            Label[] label = new Label[switch_size3];
                            for (j = 0; j < switch_size3; ++j) {
                                cases[j] = in.readIntx();
                            }
                            for (j = 0; j < switch_size3; ++j) {
                                label[j] = this.labels.get(currentOffset2 + in.readIntx() * 2);
                            }
                            dcv.visitLookupSwitchInsn(opcode, reg, this.labels.get(currentOffset2 + 6), cases, label);
                            break;
                        }
                        case 43: {
                            in.readShortx();
                            int switch_size3 = in.readShortx();
                            int first_case = in.readIntx();
                            int last_case = first_case - 1 + switch_size3;
                            Label[] _labels = new Label[switch_size3];
                            for (int j = 0; j < switch_size3; ++j) {
                                int targetOffset = in.readIntx();
                                _labels[j] = this.labels.get(currentOffset2 + targetOffset * 2);
                            }
                            dcv.visitTableSwitchInsn(opcode, reg, first_case, last_case, this.labels.get(currentOffset2 + 6), _labels);
                            break;
                        }
                        case 38: {
                            in.readShortx();
                            short elemWidth2 = in.readShortx();
                            int initLength = in.readIntx();
                            Object[] values = new Object[initLength];
                            switch (elemWidth2) {
                                case 1: {
                                    for (int j = 0; j < initLength; ++j) {
                                        values[j] = in.readByte();
                                    }
                                    break;
                                }
                                case 2: {
                                    for (int j = 0; j < initLength; ++j) {
                                        values[j] = in.readShortx();
                                    }
                                    break;
                                }
                                case 4: {
                                    for (int j = 0; j < initLength; ++j) {
                                        values[j] = in.readIntx();
                                    }
                                    break;
                                }
                                case 8: {
                                    for (int j = 0; j < initLength; ++j) {
                                        values[j] = in.readLongx();
                                    }
                                    break;
                                }
                            }
                            dcv.visitFillArrayInsn(opcode, reg, elemWidth2, initLength, values);
                        }
                    }
                    in.pop();
                    break;
                }
                case 5: {
                    int reg = in.readByte();
                    int l = in.readIntx();
                    int h = in.readIntx();
                    long longV = (long)h << 32 | (long)l & 0xFFFFFFFFL;
                    dcv.visitLdcInsn(opcode, longV, reg);
                    break;
                }
                default: {
                    throw new RuntimeException(String.format("Not support Opcode :0x%02x=%s @[0x%04x]", opcode, DexOpcodeDump.dump(opcode), currentOffset2));
                }
            }
            currentOffset2 = in.getCurrentPosition() - baseOffset2;
        }
        if (this.labels.containsKey(currentOffset2)) {
            dcv.visitLabel(this.labels.get(currentOffset2));
        }
        tadoa.visitOffset(currentOffset2);
        dcv.visitEnd();
    }

    private void order(int offset) {
        if (!this.labels.containsKey(offset)) {
            this.labels.put(offset, new Label());
        }
    }
}

