/*
 * Decompiled with CFR 0.152.
 */
package pxb.android.dex2jar.reader;

import org.objectweb.asm.Type;
import pxb.android.dex2jar.DataIn;
import pxb.android.dex2jar.Dex;

public class Constant {
    public static Object ReadConstant(Dex dex, DataIn in) {
        int b = in.readByte();
        int type = b & 0x1F;
        switch (type) {
            case 0: {
                return new Byte((byte)Constant.x0246(in, b));
            }
            case 2: {
                return new Short((short)Constant.x0246(in, b));
            }
            case 4: {
                return new Integer((int)Constant.x0246(in, b));
            }
            case 6: {
                return new Long(Constant.x0246(in, b));
            }
            case 3: {
                return new Character((char)Constant.x3(in, b));
            }
            case 23: {
                return dex.getString((int)Constant.x3(in, b));
            }
            case 16: {
                return Float.valueOf(Float.intBitsToFloat((int)(Constant.xf(in, b) >> 32)));
            }
            case 17: {
                return Double.longBitsToDouble(Constant.xf(in, b));
            }
            case 30: {
                return null;
            }
            case 28: {
                int size = in.readByte();
                Object[] array = new Object[size];
                for (int i = 0; i < size; ++i) {
                    array[i] = Constant.ReadConstant(dex, in);
                }
                return array;
            }
            case 24: {
                int type_id = (int)Constant.x3(in, b);
                return Type.getType((String)dex.getType(type_id));
            }
            case 31: {
                return new Boolean((b >> 5 & 3) != 0);
            }
        }
        throw new RuntimeException("Not support yet.");
    }

    public static long x0246(DataIn in, int before) {
        int length = (before >> 5 & 7) + 1;
        long value = 0L;
        for (int j = 0; j < length; ++j) {
            value |= (long)in.readByte() << j * 8;
        }
        return value;
    }

    public static long x3(DataIn in, int before) {
        int length = (before >> 5 & 7) + 1;
        long value = 0L;
        for (int j = 0; j < length; ++j) {
            value |= (long)(in.readByte() << j * 8);
        }
        return value;
    }

    public static long xf(DataIn in, int before) {
        int bytes = (before >> 5 & 7) + 1;
        long result = 0L;
        int bitpos = 0;
        int i = 0;
        while (i < bytes) {
            int b = in.readByte();
            result |= (long)b << bitpos;
            ++i;
            bitpos += 8;
        }
        return result <<= (8 - bytes) * 8;
    }
}

