/*
 * Decompiled with CFR 0.152.
 */
package pxb.android.dex2jar.optimize;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.LookupSwitchInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TableSwitchInsnNode;
import org.objectweb.asm.tree.TryCatchBlockNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;
import org.objectweb.asm.util.TraceMethodVisitor;
import pxb.android.dex2jar.optimize.MethodTransformer;
import pxb.android.dex2jar.optimize.Util;

public class B
implements MethodTransformer,
Opcodes {
    private Map<Label, Block> blockMaps = new HashMap<Label, Block>();
    private List<Block> blocks = new ArrayList<Block>();
    private Map<Integer, Integer> grobalMap = new HashMap<Integer, Integer>();
    private InsnList insnList;
    private int max = 0;
    private MethodNode method;

    private static Boolean isOutReaded(Integer i, Block block, Map<Object, Boolean> visited) {
        if (visited.containsKey(block)) {
            return visited.get(block);
        }
        visited.put(block, null);
        Boolean result = null;
        if (block.in.containsKey(i)) {
            result = true;
        } else if (block.out.containsKey(i)) {
            result = false;
        } else {
            for (Block n : block.tos) {
                Boolean xresult = B.isOutReaded(i, n, visited);
                if (xresult == null || !xresult.booleanValue()) continue;
                result = true;
                break;
            }
        }
        visited.put(block, result);
        return result;
    }

    private static void link(Block from, Block to) {
        from.tos.add(to);
        to.froms.add(from);
    }

    private boolean couldReplace(int r, Block block, Map<Block, Boolean> blocks) {
        for (Block in : block.froms) {
            Boolean x = this.doCouldReplace(r, in, blocks);
            if (x == null || x.booleanValue()) continue;
            return false;
        }
        return true;
    }

    private void cut() {
        AbstractInsnNode q;
        int blockIndex = 0;
        HashMap<Integer, Object> in = new HashMap<Integer, AbstractInsnNode>();
        HashMap<Integer, Object> out = new HashMap<Integer, AbstractInsnNode>();
        AbstractInsnNode p = this.method.instructions.getFirst();
        if (!(p instanceof LabelNode)) {
            this.insnList.insertBefore(p, (AbstractInsnNode)new LabelNode());
        }
        if (!((q = this.method.instructions.getLast()) instanceof LabelNode)) {
            this.insnList.insert(q, (AbstractInsnNode)new LabelNode());
        }
        AbstractInsnNode first = this.method.instructions.getFirst();
        for (p = first.getNext(); p != null; p = p.getNext()) {
            if (Util.isRead(p)) {
                int r = Util.var(p);
                if (in.get(r) != null || out.get(r) != null) continue;
                in.put(r, p);
                continue;
            }
            if (Util.isWrite(p)) {
                int r = Util.var(p);
                out.put(r, p);
                continue;
            }
            if (!Util.needBreak(p)) continue;
            if (p.getType() != 7) {
                q = p.getNext();
                if (q != null && q.getType() == 7) {
                    p = q;
                } else {
                    this.method.instructions.insert(p, (AbstractInsnNode)new LabelNode());
                    p = p.getNext();
                }
            }
            Block block = new Block(blockIndex++);
            block.first = (LabelNode)first;
            block.last = (LabelNode)p;
            block.in = in;
            block.out = out;
            this.blocks.add(block);
            this.blockMaps.put(block.first.getLabel(), block);
            first = p;
            in = new HashMap();
            out = new HashMap();
        }
    }

    private void doBlock(Block block) {
        this.doNew(block);
        this.doLdc(block);
        this.doVar(block);
    }

    private Boolean doCouldReplace(int r, Block block, Map<Block, Boolean> blocks) {
        if (blocks.containsKey(block)) {
            return blocks.get(block);
        }
        if (block.out.containsKey(r)) {
            blocks.put(block, false);
            return false;
        }
        blocks.put(block, null);
        for (Block in : block.froms) {
            Boolean x = this.doCouldReplace(r, in, blocks);
            if (x == null || x.booleanValue()) continue;
            blocks.put(block, false);
            return false;
        }
        blocks.put(block, true);
        return true;
    }

    private void doLdc(Block block) {
        HashMap<Integer, LdcInsnNode> map = new HashMap<Integer, LdcInsnNode>();
        for (AbstractInsnNode p = block.first.getNext(); p != null && p != block.last; p = p.getNext()) {
            Integer var;
            if (p.getOpcode() == 18) {
                Integer var2;
                AbstractInsnNode q = p.getNext();
                if (!Util.isWrite(q) || block.out.get(var2 = Integer.valueOf(Util.var(q))) != null && block.out.get(var2) == q) continue;
                map.put(var2, (LdcInsnNode)p);
                this.insnList.remove(q);
                q = p.getPrevious();
                this.insnList.remove(p);
                p = q;
                continue;
            }
            if (Util.isRead(p)) {
                LdcInsnNode ldc;
                var = Util.var(p);
                if (block.out.get(var) != null && block.out.get(var) == p || (ldc = (LdcInsnNode)map.get(var)) == null) continue;
                AbstractInsnNode _ldc_copy = ldc.clone(null);
                this.insnList.insert(p, _ldc_copy);
                this.insnList.remove(p);
                p = _ldc_copy;
                continue;
            }
            if (!Util.isWrite(p)) continue;
            var = Util.var(p);
            map.remove(var);
        }
    }

    private void doNew(Block block) {
        HashMap<String, AbstractInsnNode> map = new HashMap<String, AbstractInsnNode>();
        AbstractInsnNode p = block.first.getNext();
        block4: while (p != null && p != block.last) {
            switch (p.getOpcode()) {
                case 187: {
                    AbstractInsnNode store = p.getNext();
                    if (store instanceof VarInsnNode) {
                        map.put(((TypeInsnNode)p).desc + Util.var(store), p);
                        p = store.getNext();
                        continue block4;
                    }
                    p = store;
                    continue block4;
                }
                case 183: {
                    MethodInsnNode m = (MethodInsnNode)p;
                    p = p.getNext();
                    if (!m.name.equals("<init>")) continue block4;
                    int length = Type.getArgumentTypes((String)m.desc).length;
                    AbstractInsnNode q = m.getPrevious();
                    while (length-- > 0) {
                        q = q.getPrevious();
                    }
                    AbstractInsnNode _new = (AbstractInsnNode)map.remove(m.owner + Util.var(q));
                    if (_new == null) continue block4;
                    AbstractInsnNode _store = _new.getNext();
                    this.insnList.remove(_new);
                    this.insnList.remove(_store);
                    this.insnList.insertBefore(q, _new);
                    this.insnList.insert(_new, (AbstractInsnNode)new InsnNode(89));
                    this.insnList.remove(q);
                    this.insnList.insert((AbstractInsnNode)m, _store);
                    continue block4;
                }
            }
            p = p.getNext();
        }
    }

    private boolean doOptmizeFirstBlockLdc(LdcInsnNode node, int r, Block block, Map<Block, Boolean> couldReplaceBlockIds, Set<Block> replacedBlockIds) {
        if (replacedBlockIds.contains(block)) {
            return true;
        }
        replacedBlockIds.add(block);
        if (this.couldReplace(r, block, couldReplaceBlockIds)) {
            AbstractInsnNode p = block.first.getNext();
            while (p != null && p != block.last) {
                int var;
                if (Util.isRead(p)) {
                    var = Util.var(p);
                    if (r == var) {
                        LdcInsnNode nLdc = (LdcInsnNode)node.clone(null);
                        AbstractInsnNode q = p.getNext();
                        this.insnList.remove(p);
                        this.insnList.insertBefore(q, (AbstractInsnNode)nLdc);
                        p = q;
                        continue;
                    }
                } else if (Util.isWrite(p) && r == (var = Util.var(p))) break;
                p = p.getNext();
            }
        } else {
            return false;
        }
        boolean remove = true;
        if (!block.out.containsKey(r)) {
            for (Block subBlockId : block.tos) {
                boolean x = this.doOptmizeFirstBlockLdc(node, r, subBlockId, couldReplaceBlockIds, replacedBlockIds);
                if (x) continue;
                remove = false;
            }
        }
        return remove;
    }

    private void doReIndex(Block block) {
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
        for (LabelNode p = block.first; p != block.last; p = p.getNext()) {
            int r;
            if (Util.isWrite((AbstractInsnNode)p)) {
                r = Util.var((AbstractInsnNode)p);
                if (block.out.get(r) != p) {
                    int nr = this.order();
                    Util.var((AbstractInsnNode)p, nr);
                    map.put(r, nr);
                    continue;
                }
                Integer v = this.grobalMap.get(r);
                if (v == null) {
                    v = this.order();
                    this.grobalMap.put(r, v);
                }
                Util.var((AbstractInsnNode)p, v);
                map.put(r, v);
                continue;
            }
            if (!Util.isRead((AbstractInsnNode)p)) continue;
            r = Util.var((AbstractInsnNode)p);
            if (block.in.get(r) != p) {
                Integer v = (Integer)map.get(r);
                if (v == null) {
                    int nr = this.order();
                    Util.var((AbstractInsnNode)p, nr);
                    map.put(r, nr);
                    continue;
                }
                Util.var((AbstractInsnNode)p, v);
                continue;
            }
            Integer v = this.grobalMap.get(r);
            if (v == null) {
                v = this.order();
                this.grobalMap.put(r, v);
            }
            Util.var((AbstractInsnNode)p, v);
            map.put(r, v);
        }
        Map<Integer, AbstractInsnNode> old = block.in;
        block.in = new HashMap<Integer, AbstractInsnNode>();
        for (Map.Entry<Integer, AbstractInsnNode> e : old.entrySet()) {
            block.in.put(this.grobalMap.get(e.getKey()), e.getValue());
        }
        old = block.out;
        block.out = new HashMap<Integer, AbstractInsnNode>();
        for (Map.Entry<Integer, AbstractInsnNode> e : old.entrySet()) {
            block.out.put(this.grobalMap.get(e.getKey()), e.getValue());
        }
    }

    private void doVar(Block block) {
        for (AbstractInsnNode p = block.first.getNext(); p != null && p != block.last; p = p.getNext()) {
            AbstractInsnNode q;
            if (!Util.isWrite(p) || !Util.isRead(q = p.getNext()) || !Util.isSameVar(p, q)) continue;
            int var = Util.var(p);
            boolean canDel = true;
            for (AbstractInsnNode i = q.getNext(); i != null && i != block.last; i = i.getNext()) {
                if (Util.isRead(i) && var == Util.var(i)) {
                    canDel = false;
                    break;
                }
                if (!Util.isWrite(i) || var != Util.var(i)) continue;
                canDel = true;
                break;
            }
            if (!canDel || block.out.get(var) == p) continue;
            AbstractInsnNode t = q.getNext();
            this.insnList.remove(p);
            this.insnList.remove(q);
            p = t.getPrevious();
        }
    }

    private void linkBlocks() {
        block5: for (int i = 0; i < this.blocks.size(); ++i) {
            Block block = this.blocks.get(i);
            AbstractInsnNode node = block.last.getPrevious();
            switch (node.getType()) {
                case 6: {
                    JumpInsnNode jump = (JumpInsnNode)node;
                    B.link(block, this.blockMaps.get(jump.label.getLabel()));
                    if (jump.getOpcode() == 167) continue block5;
                    B.link(block, this.blocks.get(i + 1));
                    continue block5;
                }
                case 11: {
                    LabelNode label;
                    LookupSwitchInsnNode lsin = (LookupSwitchInsnNode)node;
                    B.link(block, this.blockMaps.get(lsin.dflt.getLabel()));
                    for (Object l : lsin.labels) {
                        label = (LabelNode)l;
                        B.link(block, this.blockMaps.get(label.getLabel()));
                    }
                    continue block5;
                }
                case 10: {
                    LabelNode label;
                    TableSwitchInsnNode tsin = (TableSwitchInsnNode)node;
                    B.link(block, this.blockMaps.get(tsin.dflt.getLabel()));
                    for (Object l : tsin.labels) {
                        label = (LabelNode)l;
                        B.link(block, this.blockMaps.get(label.getLabel()));
                    }
                    continue block5;
                }
                default: {
                    int insnOpcode = node.getOpcode();
                    if (insnOpcode == 191 || insnOpcode >= 172 && insnOpcode <= 177) continue block5;
                    B.link(block, this.blocks.get(i + 1));
                    continue block5;
                }
            }
        }
    }

    private void linkTryCatch() {
        block0: for (Object o : this.method.tryCatchBlocks) {
            Block block;
            int i;
            TryCatchBlockNode tcb = (TryCatchBlockNode)o;
            Block b_handle = this.blockMaps.get(tcb.handler.getLabel());
            for (i = 0; i < this.blocks.size(); ++i) {
                block = this.blocks.get(i);
                if (block.first == tcb.start) break;
            }
            while (i < this.blocks.size()) {
                block = this.blocks.get(i);
                if (block.first == tcb.end) continue block0;
                B.link(block, b_handle);
                ++i;
            }
        }
    }

    private void OptmizeFirstBlockLdc() {
        Block block = this.blocks.get(0);
        HashMap<Integer, LdcInsnNode> map = new HashMap<Integer, LdcInsnNode>();
        AbstractInsnNode p = block.first.getNext();
        while (p != null && p != block.last) {
            int var;
            LdcInsnNode ldc;
            if (p.getOpcode() == 18) {
                int var2;
                AbstractInsnNode q = p.getNext();
                if (Util.isWrite(q) && block.out.get(var2 = Util.var(q)) == q) {
                    HashMap<Block, Boolean> couldReplace = new HashMap<Block, Boolean>();
                    HashSet<Block> replacedBlock = new HashSet<Block>();
                    replacedBlock.add(block);
                    couldReplace.put(block, true);
                    LdcInsnNode ldc2 = (LdcInsnNode)p;
                    boolean remove = true;
                    for (Block subBlock : block.tos) {
                        boolean x = this.doOptmizeFirstBlockLdc(ldc2, var2, subBlock, couldReplace, replacedBlock);
                        if (x) continue;
                        remove = false;
                    }
                    if (remove) {
                        this.insnList.remove(p);
                        p = q.getNext();
                        this.insnList.remove(q);
                        map.put(var2, ldc2);
                        continue;
                    }
                }
            } else if (Util.isRead(p) && (ldc = (LdcInsnNode)map.get(var = Util.var(p))) != null) {
                AbstractInsnNode q = p.getNext();
                this.insnList.remove(p);
                this.insnList.insertBefore(q, ldc.clone(null));
                p = q;
                continue;
            }
            p = p.getNext();
        }
    }

    private void optmizeOut(Integer i) {
        HashMap<Object, Boolean> map = new HashMap<Object, Boolean>();
        for (Block block : this.blocks) {
            if (!block.out.containsKey(i)) continue;
            boolean read = false;
            for (Block n : block.tos) {
                Boolean xresult = B.isOutReaded(i, n, map);
                if (xresult == null || !xresult.booleanValue()) continue;
                read = true;
                break;
            }
            if (read) continue;
            block.out.remove(i);
        }
    }

    private int order() {
        return this.max++;
    }

    @Override
    public void transform(MethodNode method) {
        this.insnList = method.instructions;
        this.method = method;
        this.cut();
        this.linkTryCatch();
        this.linkBlocks();
        HashSet<Integer> set = new HashSet<Integer>();
        for (Block b : this.blocks) {
            set.addAll(b.out.keySet());
        }
        for (Integer i : set) {
            this.optmizeOut(i);
        }
        set = null;
        for (Block block : this.blocks) {
            this.doBlock(block);
        }
        this.OptmizeFirstBlockLdc();
        int i = 0;
        if ((method.access & 8) == 0) {
            this.grobalMap.put(i++, this.order());
        }
        for (int j = 0; j < Type.getArgumentTypes((String)method.desc).length; ++j) {
            this.grobalMap.put(i++, this.order());
        }
        for (Block block : this.blocks) {
            this.doReIndex(block);
        }
    }

    private static class Block {
        public LabelNode first;
        public List<Block> froms = new ArrayList<Block>();
        public Map<Integer, AbstractInsnNode> in;
        private final int index;
        public LabelNode last;
        public Map<Integer, AbstractInsnNode> out;
        public List<Block> tos = new ArrayList<Block>();

        public Block(int index) {
            this.index = index;
        }

        public String toString() {
            TraceMethodVisitor tr = new TraceMethodVisitor();
            for (AbstractInsnNode p = this.first.getNext(); p != this.last; p = p.getNext()) {
                p.accept((MethodVisitor)tr);
            }
            StringBuilder sb = new StringBuilder().append("this:").append(this.index);
            StringBuilder temp = new StringBuilder();
            for (Block b : this.froms) {
                temp.append(',').append(b.index);
            }
            if (temp.length() > 0) {
                temp.deleteCharAt(0);
            }
            sb.append(" from:").append('[').append(temp.toString()).append(']');
            temp.setLength(0);
            for (Block b : this.tos) {
                temp.append(',').append(b.index);
            }
            if (temp.length() > 0) {
                temp.deleteCharAt(0);
            }
            sb.append(" to:").append('[').append(temp.toString()).append(']');
            temp.setLength(0);
            for (Integer i : this.in.keySet()) {
                if (this.in.get(i) == null) continue;
                temp.append(',').append(i);
            }
            if (temp.length() > 0) {
                temp.deleteCharAt(0);
            }
            sb.append(" in:").append('[').append(temp.toString()).append(']');
            temp.setLength(0);
            for (Integer i : this.out.keySet()) {
                if (this.out.get(i) == null) continue;
                temp.append(',').append(i);
            }
            if (temp.length() > 0) {
                temp.deleteCharAt(0);
            }
            sb.append(" out:").append('[').append(temp.toString()).append(']');
            sb.append("\n");
            int i = 0;
            for (Object o : tr.text) {
                sb.append(String.format("%04d", i++)).append(o);
            }
            sb.append("");
            return sb.toString();
        }
    }
}

