/*
 * Decompiled with CFR 0.152.
 */
package pxb.android.dex2jar.asm;

import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodAdapter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PDescMethodVisitor
extends MethodAdapter
implements Opcodes {
    private Map<Label, Type> handlers = new HashMap<Label, Type>();
    private Map<Integer, Type> _local = new HashMap<Integer, Type>();
    private Stack<Type> stack = new Stack<Type>(){

        @Override
        public Type push(Type item) {
            if (this.size() + 1 > PDescMethodVisitor.this.maxStack) {
                PDescMethodVisitor.this.maxStack = this.size() + 1;
            }
            return super.push(item);
        }
    };
    int maxLocalId = 0;
    int maxStack = 0;
    private static final Logger log = LoggerFactory.getLogger(PDescMethodVisitor.class);

    public void putLocal(int id, Type t) {
        if (id > this.maxLocalId) {
            this.maxLocalId = id;
        }
        this._local.put(id, t);
    }

    public PDescMethodVisitor(MethodVisitor mv) {
        super(mv);
    }

    public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
        super.visitTryCatchBlock(start, end, handler, type);
        this.handlers.put(handler, type == null ? Type.getType((String)"Ljava/lang/Throwable;") : Type.getType((String)type));
    }

    public void visit(String owner, String des, boolean isStatic) {
        Type[] args = Type.getArgumentTypes((String)des);
        if (isStatic) {
            for (int i = 0; i < args.length; ++i) {
                this.putLocal(i, args[i]);
            }
        } else {
            this.putLocal(0, Type.getType((String)owner));
            for (int i = 1; i <= args.length; ++i) {
                this.putLocal(i, args[i - 1]);
            }
        }
    }

    private void e(Type actual, Type expect) {
        if (expect == null || !expect.equals((Object)actual)) {
            log.warn("Expect :{} but :{}", (Object)expect, (Object)actual);
        }
    }

    public Type getLocal(int i) {
        return this._local.get(i);
    }

    public Type getStack(int i) {
        return (Type)this.stack.get(this.stack.size() - i);
    }

    public void visitFieldInsn(int opcode, String owner, String name, String desc) {
        super.visitFieldInsn(opcode, owner, name, desc);
        switch (opcode) {
            case 180: {
                this.e(this.stack.pop(), Type.getType((String)owner));
                this.stack.push(Type.getType((String)desc));
                break;
            }
            case 181: {
                this.e(this.stack.pop(), Type.getType((String)desc));
                this.e(this.stack.pop(), Type.getType((String)owner));
                break;
            }
            case 178: {
                this.stack.push(Type.getType((String)desc));
                break;
            }
            case 179: {
                this.e(this.stack.pop(), Type.getType((String)desc));
            }
        }
    }

    public void visitInsn(int opcode) {
        super.visitInsn(opcode);
        switch (opcode) {
            case 1: {
                this.stack.push(Type.VOID_TYPE);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                this.stack.push(Type.INT_TYPE);
                break;
            }
            case 10: {
                this.stack.push(Type.LONG_TYPE);
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                this.stack.push(Type.FLOAT_TYPE);
                break;
            }
            case 14: 
            case 15: {
                this.stack.push(Type.DOUBLE_TYPE);
                break;
            }
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: {
                this.stack.pop();
                Type base = this.stack.pop();
                this.stack.push(base.getElementType());
                break;
            }
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: {
                this.stack.pop();
                this.stack.pop();
                this.stack.pop();
                break;
            }
            case 87: {
                this.stack.pop();
                break;
            }
            case 89: {
                this.stack.push(this.stack.peek());
                break;
            }
            case 172: 
            case 173: 
            case 174: 
            case 175: 
            case 176: 
            case 191: {
                this.stack.pop();
                break;
            }
            case 190: {
                this.stack.pop();
                this.stack.push(Type.INT_TYPE);
                break;
            }
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 152: 
            case 194: 
            case 195: {
                this.stack.pop();
                break;
            }
            case 90: {
                Type a = this.stack.pop();
                Type b = this.stack.pop();
                this.stack.push(a);
                this.stack.push(b);
                this.stack.push(a);
                break;
            }
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 142: 
            case 143: 
            case 144: 
            case 145: 
            case 146: 
            case 147: 
            case 177: {
                break;
            }
            default: {
                throw new RuntimeException("");
            }
        }
    }

    public void visitIntInsn(int opcode, int operand) {
        super.visitIntInsn(opcode, operand);
        block0 : switch (opcode) {
            case 16: {
                this.stack.push(Type.BYTE_TYPE);
                break;
            }
            case 17: {
                this.stack.push(Type.SHORT_TYPE);
                break;
            }
            case 188: {
                this.stack.pop();
                switch (operand) {
                    case 4: {
                        this.stack.push(Type.getType((String)"[Z"));
                        break block0;
                    }
                    case 8: {
                        this.stack.push(Type.getType((String)"[B"));
                        break block0;
                    }
                    case 5: {
                        this.stack.push(Type.getType((String)"[C"));
                        break block0;
                    }
                    case 7: {
                        this.stack.push(Type.getType((String)"[D"));
                        break block0;
                    }
                    case 6: {
                        this.stack.push(Type.getType((String)"[F"));
                        break block0;
                    }
                    case 10: {
                        this.stack.push(Type.getType((String)"[I"));
                        break block0;
                    }
                    case 11: {
                        this.stack.push(Type.getType((String)"[J"));
                        break block0;
                    }
                    case 9: {
                        this.stack.push(Type.getType((String)"[Z"));
                    }
                }
            }
        }
    }

    public void visitJumpInsn(int opcode, Label label) {
        super.visitJumpInsn(opcode, label);
        switch (opcode) {
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 198: 
            case 199: {
                this.stack.pop();
                break;
            }
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: {
                this.stack.pop();
                this.stack.pop();
                break;
            }
        }
    }

    public void visitLabel(Label label) {
        super.visitLabel(label);
        Type type = this.handlers.get(label);
        if (type != null) {
            this.stack.push(type);
        }
    }

    public void visitLdcInsn(Object cst) {
        if (cst instanceof String) {
            this.stack.push(Type.getType(String.class));
        } else if (cst instanceof Integer) {
            this.stack.push(Type.INT_TYPE);
        } else if (cst instanceof Float) {
            this.stack.push(Type.FLOAT_TYPE);
        } else if (cst instanceof Long) {
            this.stack.push(Type.LONG_TYPE);
        } else if (cst instanceof Double) {
            this.stack.push(Type.DOUBLE_TYPE);
        } else if (cst instanceof Type) {
            this.stack.push(Type.getType(Class.class));
        }
        super.visitLdcInsn(cst);
    }

    public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
        super.visitLookupSwitchInsn(dflt, keys, labels);
        this.stack.pop();
    }

    public void visitMethodInsn(int opcode, String owner, String name, String desc) {
        Type ret;
        Type[] args = Type.getArgumentTypes((String)desc);
        for (int i = args.length - 1; i >= 0; --i) {
            Type t = this.stack.pop();
            this.e(args[i], t);
        }
        if (opcode != 184) {
            Type o = Type.getType((String)owner);
            Type p = this.stack.pop();
            this.e(p, o);
        }
        if (!(ret = Type.getReturnType((String)desc)).equals((Object)Type.VOID_TYPE)) {
            this.stack.push(ret);
        }
        super.visitMethodInsn(opcode, owner, name, desc);
    }

    public void visitMultiANewArrayInsn(String desc, int dims) {
        super.visitMultiANewArrayInsn(desc, dims);
    }

    public void visitTableSwitchInsn(int min, int max, Label dflt, Label[] labels) {
        super.visitTableSwitchInsn(min, max, dflt, labels);
        this.stack.pop();
    }

    public void visitTypeInsn(int opcode, String type) {
        super.visitTypeInsn(opcode, type);
        switch (opcode) {
            case 187: {
                this.stack.push(Type.getType((String)type));
                break;
            }
            case 192: {
                this.stack.pop();
                this.stack.push(Type.getType((String)type));
                break;
            }
            case 193: {
                this.stack.pop();
                this.stack.push(Type.BOOLEAN_TYPE);
                break;
            }
            case 189: {
                this.stack.pop();
                this.stack.push(Type.getType((String)type));
            }
        }
    }

    public void visitMaxs(int maxStack, int maxLocals) {
        super.visitMaxs(this.maxStack, this.maxLocalId + 1);
    }

    public void visitVarInsn(int opcode, int var) {
        super.visitVarInsn(opcode, var);
        switch (opcode) {
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                this.stack.push(this.getLocal(var));
                break;
            }
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: {
                Type p = this.stack.pop();
                this.putLocal(var, p);
                break;
            }
        }
    }
}

