/*
 * Decompiled with CFR 0.152.
 */
package oms.GameEngine;

import android.content.Context;
import android.content.res.AssetManager;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.util.Log;
import java.io.IOException;
import java.io.InputStream;
import oms.GameEngine.C_Lib;
import oms.GameEngine.GameCanvas;
import oms.GameEngine.GameMath;
import oms.GameEngine.PackageManager;
import oms.GameEngine.TextDEF;

public class TextManager {
    private static TextDEF[] Text;
    private Matrix cMatrix;
    private Context mContext;
    private boolean mIsLogOut = true;
    private long nCurBMPRamSize = 0L;
    private int nTextLayerMax;

    public TextManager(Context context, int n2) {
        Matrix matrix;
        this.mContext = context;
        Text = null;
        int n3 = this.nTextLayerMax = n2;
        this.InitText(n3);
        this.cMatrix = matrix = new Matrix();
        this.nCurBMPRamSize = 0L;
    }

    /*
     * Enabled aggressive block sorting
     */
    private int GetBitmapSize(Bitmap bitmap) {
        Bitmap.Config config;
        int n2 = 1;
        Bitmap.Config config2 = bitmap.getConfig();
        if (config2 == (config = Bitmap.Config.ALPHA_8)) {
            n2 = 1;
        } else {
            Bitmap.Config config3;
            Bitmap.Config config4 = bitmap.getConfig();
            if (config4 == (config3 = Bitmap.Config.RGB_565)) {
                n2 = 2;
            } else {
                Bitmap.Config config5;
                Bitmap.Config config6 = bitmap.getConfig();
                if (config6 == (config5 = Bitmap.Config.ARGB_4444)) {
                    n2 = 2;
                } else {
                    Bitmap.Config config7;
                    Bitmap.Config config8 = bitmap.getConfig();
                    if (config8 == (config7 = Bitmap.Config.ARGB_8888)) {
                        n2 = 4;
                    }
                }
            }
        }
        int n3 = bitmap.getWidth();
        int n4 = bitmap.getHeight();
        return n3 * n4 * n2 + 128;
    }

    public void CloseAllText() {
        int n2 = 0;
        int n3;
        while (n2 < (n3 = this.nTextLayerMax)) {
            this.CloseText(n2);
            ++n2;
        }
        return;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void CloseText(int n2) {
        long l2;
        Object var2_2 = null;
        int n3 = this.nTextLayerMax;
        if (n2 >= n3) {
            return;
        }
        if (TextManager.Text[n2].Text == null) return;
        long l3 = this.nCurBMPRamSize;
        Bitmap bitmap = TextManager.Text[n2].Text;
        long l4 = this.GetBitmapSize(bitmap);
        this.nCurBMPRamSize = l2 = l3 - l4;
        TextManager.Text[n2].Text.recycle();
        TextManager.Text[n2].Text = null;
        TextManager.Text[n2].TextAttrib = (int)var2_2;
        TextManager.Text[n2].TextCtrl = (int)var2_2;
        TextManager.Text[n2].TextXInc = (int)var2_2;
        TextManager.Text[n2].TextYInc = (int)var2_2;
        TextManager.Text[n2].TextXVal = (int)var2_2;
        TextManager.Text[n2].TextYVal = (int)var2_2;
        if (!this.mIsLogOut) return;
        StringBuilder stringBuilder = new StringBuilder("Text use RAM: ");
        long l5 = this.nCurBMPRamSize / 1024L;
        String string2 = stringBuilder.append(l5).append(" KBytes").toString();
        Log.v((String)"GameEngine", (String)string2);
    }

    public long GetBMPRamSize() {
        return this.nCurBMPRamSize;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int GetTextHeight(int n2) {
        void var2_4;
        Bitmap bitmap = TextManager.Text[n2].Text;
        if (bitmap == null) return (int)var2_4;
        int n3 = TextManager.Text[n2].Text.getHeight();
        return (int)var2_4;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int GetTextWidth(int n2) {
        void var2_4;
        Bitmap bitmap = TextManager.Text[n2].Text;
        if (bitmap == null) return (int)var2_4;
        int n3 = TextManager.Text[n2].Text.getWidth();
        return (int)var2_4;
    }

    public int GetTextXVal(int n2) {
        return TextManager.Text[n2].TextXVal;
    }

    public int GetTextYVal(int n2) {
        return TextManager.Text[n2].TextYVal;
    }

    public void InitText(int n2) {
        this.nTextLayerMax = n2;
        if (this.nTextLayerMax == 0) {
            this.nTextLayerMax = 1;
        }
        Text = new TextDEF[this.nTextLayerMax];
        int n3 = 0;
        int n4;
        while (n3 < (n4 = this.nTextLayerMax)) {
            TextDEF textDEF;
            TextDEF[] textDEFArray = Text;
            textDEFArray[n3] = textDEF = new TextDEF();
            ++n3;
        }
        return;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void LoadPicture(int n2, int n3, int n4) {
        long l2;
        int n5 = 1065353216;
        Object var5_5 = null;
        int n6 = this.nTextLayerMax;
        if (n3 >= n6) {
            return;
        }
        this.CloseText(n3);
        Bitmap bitmap = BitmapFactory.decodeResource((Resources)this.mContext.getResources(), (int)n2);
        if (bitmap == null) return;
        long l3 = this.nCurBMPRamSize;
        long l4 = this.GetBitmapSize(bitmap);
        this.nCurBMPRamSize = l2 = l3 + l4;
        if (this.mIsLogOut) {
            String string2 = "ResID: " + n2;
            Log.v((String)"GameEngine", (String)string2);
            StringBuilder stringBuilder = new StringBuilder("Width: ");
            int n7 = bitmap.getWidth();
            String string3 = stringBuilder.append(n7).toString();
            Log.v((String)"GameEngine", (String)string3);
            StringBuilder stringBuilder2 = new StringBuilder("Height: ");
            int n8 = bitmap.getHeight();
            String string4 = stringBuilder2.append(n8).toString();
            Log.v((String)"GameEngine", (String)string4);
            StringBuilder stringBuilder3 = new StringBuilder("OPtions: ");
            Bitmap.Config config = bitmap.getConfig();
            String string5 = stringBuilder3.append(config).toString();
            Log.v((String)"GameEngine", (String)string5);
            StringBuilder stringBuilder4 = new StringBuilder("Text use RAM: ");
            long l5 = this.nCurBMPRamSize / 1024L;
            String string6 = stringBuilder4.append(l5).append(" KBytes").toString();
            Log.v((String)"GameEngine", (String)string6);
        }
        TextManager.Text[n3].Text = bitmap;
        TextManager.Text[n3].TextXInc = (int)var5_5;
        TextManager.Text[n3].TextYInc = (int)var5_5;
        TextManager.Text[n3].TextXVal = (int)var5_5;
        TextManager.Text[n3].TextYVal = (int)var5_5;
        TextManager.Text[n3].ScaleX = n5;
        TextManager.Text[n3].ScaleY = n5;
        TextManager.Text[n3].Rotate = (float)null;
        TextManager.Text[n3].TextAttrib = n4;
        TextManager.Text[n3].TextCtrl = 15;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void LoadText(int n2, int n3, int n4) {
        long l2;
        int n5 = 1065353216;
        Object var5_5 = null;
        int n6 = this.nTextLayerMax;
        if (n3 >= n6) {
            return;
        }
        this.CloseText(n3);
        Bitmap bitmap = PackageManager.createBitmap(this.mContext, n2);
        if (bitmap == null) return;
        long l3 = this.nCurBMPRamSize;
        long l4 = this.GetBitmapSize(bitmap);
        this.nCurBMPRamSize = l2 = l3 + l4;
        if (this.mIsLogOut) {
            String string2 = "ResID: " + n2;
            Log.v((String)"GameEngine", (String)string2);
            StringBuilder stringBuilder = new StringBuilder("Width: ");
            int n7 = bitmap.getWidth();
            String string3 = stringBuilder.append(n7).toString();
            Log.v((String)"GameEngine", (String)string3);
            StringBuilder stringBuilder2 = new StringBuilder("Height: ");
            int n8 = bitmap.getHeight();
            String string4 = stringBuilder2.append(n8).toString();
            Log.v((String)"GameEngine", (String)string4);
            StringBuilder stringBuilder3 = new StringBuilder("OPtions: ");
            Bitmap.Config config = bitmap.getConfig();
            String string5 = stringBuilder3.append(config).toString();
            Log.v((String)"GameEngine", (String)string5);
            StringBuilder stringBuilder4 = new StringBuilder("Text use RAM: ");
            long l5 = this.nCurBMPRamSize / 1024L;
            String string6 = stringBuilder4.append(l5).append(" KBytes").toString();
            Log.v((String)"GameEngine", (String)string6);
        }
        TextManager.Text[n3].Text = bitmap;
        TextManager.Text[n3].TextXInc = (int)var5_5;
        TextManager.Text[n3].TextYInc = (int)var5_5;
        TextManager.Text[n3].TextXVal = (int)var5_5;
        TextManager.Text[n3].TextYVal = (int)var5_5;
        TextManager.Text[n3].ScaleX = n5;
        TextManager.Text[n3].ScaleY = n5;
        TextManager.Text[n3].Rotate = (float)null;
        TextManager.Text[n3].TextAttrib = n4;
        TextManager.Text[n3].TextCtrl = 15;
    }

    public void LoadText(int n2, int n3, int n4, int n5) {
        int n6 = 1065353216;
        Object var6_6 = null;
        if (TextManager.Text[n4].Text != null) {
            TextManager.Text[n4].Text.recycle();
            TextManager.Text[n4].Text = null;
        }
        Bitmap.Config config = Bitmap.Config.ARGB_8888;
        Bitmap bitmap = Bitmap.createBitmap((int)n2, (int)n3, (Bitmap.Config)config);
        int n7 = this.nTextLayerMax;
        if (n4 < n7) {
            long l2;
            long l3 = this.nCurBMPRamSize;
            long l4 = this.GetBitmapSize(bitmap);
            this.nCurBMPRamSize = l2 = l3 + l4;
            if (this.mIsLogOut) {
                Log.v((String)"GameEngine", (String)"ResID: 0");
                StringBuilder stringBuilder = new StringBuilder("Width: ");
                int n8 = bitmap.getWidth();
                String string2 = stringBuilder.append(n8).toString();
                Log.v((String)"GameEngine", (String)string2);
                StringBuilder stringBuilder2 = new StringBuilder("Height: ");
                int n9 = bitmap.getHeight();
                String string3 = stringBuilder2.append(n9).toString();
                Log.v((String)"GameEngine", (String)string3);
                StringBuilder stringBuilder3 = new StringBuilder("OPtions: ");
                Bitmap.Config config2 = bitmap.getConfig();
                String string4 = stringBuilder3.append(config2).toString();
                Log.v((String)"GameEngine", (String)string4);
                StringBuilder stringBuilder4 = new StringBuilder("Text use RAM: ");
                long l5 = this.nCurBMPRamSize / 1024L;
                String string5 = stringBuilder4.append(l5).append(" KBytes").toString();
                Log.v((String)"GameEngine", (String)string5);
            }
            TextManager.Text[n4].Text = bitmap;
            TextManager.Text[n4].TextXInc = (int)var6_6;
            TextManager.Text[n4].TextYInc = (int)var6_6;
            TextManager.Text[n4].TextXVal = (int)var6_6;
            TextManager.Text[n4].TextYVal = (int)var6_6;
            TextManager.Text[n4].ScaleX = n6;
            TextManager.Text[n4].ScaleY = n6;
            TextManager.Text[n4].Rotate = (float)null;
            TextManager.Text[n4].TextAttrib = n5;
            TextManager.Text[n4].TextCtrl = 15;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void LoadText(String string2, int n2, int n3) {
        long l2;
        int n4 = 1065353216;
        Object var5_5 = null;
        int n5 = this.nTextLayerMax;
        if (n2 >= n5) {
            return;
        }
        if (TextManager.Text[n2].Text != null) {
            TextManager.Text[n2].Text.recycle();
            TextManager.Text[n2].Text = null;
        }
        Bitmap bitmap = null;
        InputStream inputStream = null;
        AssetManager assetManager = this.mContext.getAssets();
        try {
            inputStream = assetManager.open(string2);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        if (inputStream == null) return;
        bitmap = BitmapFactory.decodeStream((InputStream)inputStream);
        try {
            inputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        if (bitmap == null) return;
        long l3 = this.nCurBMPRamSize;
        long l4 = this.GetBitmapSize(bitmap);
        this.nCurBMPRamSize = l2 = l3 + l4;
        if (this.mIsLogOut) {
            Log.v((String)"GameEngine", (String)"ResID: 0");
            StringBuilder stringBuilder = new StringBuilder("Width: ");
            int n6 = bitmap.getWidth();
            String string3 = stringBuilder.append(n6).toString();
            Log.v((String)"GameEngine", (String)string3);
            StringBuilder stringBuilder2 = new StringBuilder("Height: ");
            int n7 = bitmap.getHeight();
            String string4 = stringBuilder2.append(n7).toString();
            Log.v((String)"GameEngine", (String)string4);
            StringBuilder stringBuilder3 = new StringBuilder("OPtions: ");
            Bitmap.Config config = bitmap.getConfig();
            String string5 = stringBuilder3.append(config).toString();
            Log.v((String)"GameEngine", (String)string5);
            StringBuilder stringBuilder4 = new StringBuilder("Text use RAM: ");
            long l5 = this.nCurBMPRamSize / 1024L;
            String string6 = stringBuilder4.append(l5).append(" KBytes").toString();
            Log.v((String)"GameEngine", (String)string6);
        }
        TextManager.Text[n2].Text = bitmap;
        TextManager.Text[n2].TextXInc = (int)var5_5;
        TextManager.Text[n2].TextYInc = (int)var5_5;
        TextManager.Text[n2].TextXVal = (int)var5_5;
        TextManager.Text[n2].TextYVal = (int)var5_5;
        TextManager.Text[n2].ScaleX = n4;
        TextManager.Text[n2].ScaleY = n4;
        TextManager.Text[n2].Rotate = (float)null;
        TextManager.Text[n2].TextAttrib = n3;
        TextManager.Text[n2].TextCtrl = 15;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public void OnDraw(Canvas canvas, int n2, int n3, int n4, Paint paint) {
        int n5 = 1065353216;
        int n6 = null;
        int n7;
        while (n6 < (n7 = this.nTextLayerMax)) {
            void var7_8;
            if (TextManager.Text[n6].Text != null && TextManager.Text[n6].TextAttrib == n2) {
                if (TextManager.Text[n6].ScaleX == n5 && TextManager.Text[n6].ScaleY == n5 && TextManager.Text[n6].Rotate == null) {
                    Bitmap bitmap = TextManager.Text[n6].Text;
                    float f2 = TextManager.Text[n6].TextXVal;
                    float f3 = n3;
                    float f4 = f2 + f3;
                    float f5 = TextManager.Text[n6].TextYVal;
                    float f6 = n4;
                    float f7 = f5 + f6;
                    canvas.drawBitmap(bitmap, f4, f7, paint);
                } else {
                    this.cMatrix.reset();
                    int n8 = TextManager.Text[n6].TextXVal + n3;
                    int n9 = TextManager.Text[n6].TextYVal + n4;
                    Matrix matrix = this.cMatrix;
                    float f8 = GameMath.convertToUIX(n8);
                    float f9 = GameMath.convertToUIY(n9);
                    matrix.setTranslate(f8, f9);
                    Matrix matrix2 = this.cMatrix;
                    float f10 = TextManager.Text[n6].Rotate;
                    float f11 = TextManager.Text[n6].Text.getWidth() >> 1;
                    float f12 = TextManager.Text[n6].Text.getHeight() >> 1;
                    matrix2.postRotate(f10, f11, f12);
                    if (TextManager.Text[n6].ScaleX != n5 || TextManager.Text[n6].ScaleY != n5) {
                        Matrix matrix3 = this.cMatrix;
                        float f13 = TextManager.Text[n6].ScaleX;
                        float f14 = TextManager.Text[n6].ScaleY;
                        matrix3.postScale(f13, f14);
                    }
                    Bitmap bitmap = TextManager.Text[n6].Text;
                    Matrix matrix4 = this.cMatrix;
                    canvas.drawBitmap(bitmap, matrix4, paint);
                }
            }
            ++var7_8;
        }
        return;
    }

    /*
     * WARNING - void declaration
     */
    public void OnDraw(Canvas canvas, int n2, Paint paint) {
        int n3 = null;
        int n4;
        while (n3 < (n4 = this.nTextLayerMax)) {
            void var4_5;
            if (TextManager.Text[n3].Text != null && TextManager.Text[n3].TextAttrib == n2) {
                Bitmap bitmap = TextManager.Text[n3].Text;
                float f2 = GameMath.convertToUIX(TextManager.Text[n3].TextXVal);
                float f3 = GameMath.convertToUIY(TextManager.Text[n3].TextYVal);
                canvas.drawBitmap(bitmap, f2, f3, paint);
            }
            ++var4_5;
        }
        return;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void ScrollText(int n2) {
        int n3;
        int n4;
        Object var2_2 = null;
        int n5 = this.nTextLayerMax;
        if (n2 >= n5) return;
        if (TextManager.Text[n2].Text == null) {
            return;
        }
        int n6 = GameCanvas.GetScreenWidth();
        int n7 = GameCanvas.GetScreenHeight();
        int n8 = TextManager.Text[n2].Text.getWidth();
        int n9 = TextManager.Text[n2].Text.getHeight();
        int n10 = TextManager.Text[n2].TextCtrl;
        if (TextManager.Text[n2].TextXInc < 0 && (n10 & 4) == 4) {
            int n11;
            TextDEF textDEF = Text[n2];
            int n12 = TextManager.Text[n2].TextXVal;
            int n13 = TextManager.Text[n2].TextXInc;
            textDEF.TextXVal = n11 = n12 - n13;
            if (TextManager.Text[n2].TextXVal >= 0) {
                TextManager.Text[n2].TextXVal = (int)var2_2;
            }
        }
        if (TextManager.Text[n2].TextXInc > 0 && (n10 & 8) == 8) {
            int n14;
            TextDEF textDEF = Text[n2];
            int n15 = TextManager.Text[n2].TextXVal;
            int n16 = TextManager.Text[n2].TextXInc;
            textDEF.TextXVal = n14 = n15 - n16;
            if (TextManager.Text[n2].TextXVal + n6 >= n8) {
                int n17;
                TextDEF textDEF2 = Text[n2];
                textDEF2.TextXVal = n17 = n6 - n8;
            }
        }
        if (TextManager.Text[n2].TextYInc < 0 && (n10 & 1) == 1) {
            int n18;
            TextDEF textDEF = Text[n2];
            int n19 = TextManager.Text[n2].TextYVal;
            int n20 = TextManager.Text[n2].TextYInc;
            textDEF.TextYVal = n18 = n19 - n20;
            if (TextManager.Text[n2].TextXVal >= 0) {
                TextManager.Text[n2].TextYVal = (int)var2_2;
            }
        }
        if (TextManager.Text[n2].TextYInc <= 0) return;
        if ((n10 & 2) != 2) return;
        TextDEF textDEF = Text[n2];
        int n21 = TextManager.Text[n2].TextYVal;
        int n22 = TextManager.Text[n2].TextYInc;
        textDEF.TextYVal = n4 = n21 - n22;
        if (TextManager.Text[n2].TextYVal + n7 < n9) return;
        TextDEF textDEF3 = Text[n2];
        textDEF3.TextYVal = n3 = n7 - n9;
    }

    public void SetBMPSizeOut(boolean bl) {
        this.mIsLogOut = bl;
    }

    public void SetTextInc(int n2, int n3, int n4) {
        int n5 = this.nTextLayerMax;
        if (n2 < n5) {
            TextManager.Text[n2].TextXInc = n3;
            TextManager.Text[n2].TextYInc = n4;
        }
    }

    public void SetTextRotate(int n2, float f2) {
        if (f2 > null) {
            TextManager.Text[n2].Rotate = f2;
        }
    }

    public void SetTextScale(int n2, float f2) {
        if (f2 > null) {
            float f3;
            float f4;
            TextDEF textDEF = Text[n2];
            textDEF.ScaleX = f4 = C_Lib.mCanvasScaleX + f2;
            TextDEF textDEF2 = Text[n2];
            textDEF2.ScaleY = f3 = C_Lib.mCanvasScaleY + f2;
        }
    }

    public void SetTextXVal(int n2, int n3) {
        TextManager.Text[n2].TextXVal = n3;
    }

    public void SetTextYVal(int n2, int n3) {
        TextManager.Text[n2].TextYVal = n3;
    }

    public int getTextLayer() {
        return this.nTextLayerMax;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean getTextPixels(int n2, int[] nArray) {
        int n3 = 0;
        int n4 = this.nTextLayerMax;
        if (n2 >= n4) {
            return n3 != 0;
        }
        Bitmap bitmap = TextManager.Text[n2].Text;
        if (bitmap == null) {
            return n3 != 0;
        }
        int n5 = TextManager.Text[n2].Text.getWidth();
        int n6 = TextManager.Text[n2].Text.getHeight();
        bitmap = TextManager.Text[n2].Text;
        int[] nArray2 = nArray;
        int n7 = n3;
        int n8 = n3;
        int n9 = n5;
        bitmap.getPixels(nArray2, n3, n5, n7, n8, n9, n6);
        return 1 != 0;
    }

    public void release() {
        this.CloseAllText();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setTextPixels(int n2, int[] nArray) {
        int n3 = 0;
        int n4 = this.nTextLayerMax;
        if (n2 >= n4) {
            return;
        }
        if (TextManager.Text[n2].Text == null) return;
        int n5 = TextManager.Text[n2].Text.getWidth();
        int n6 = TextManager.Text[n2].Text.getHeight();
        Bitmap bitmap = TextManager.Text[n2].Text;
        int[] nArray2 = nArray;
        int n7 = n3;
        int n8 = n3;
        int n9 = n5;
        bitmap.setPixels(nArray2, n3, n5, n7, n8, n9, n6);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setTextPixels(int n2, int[] nArray, int n3, int n4, int n5, int n6, int n7) {
        int n8 = this.nTextLayerMax;
        if (n2 >= n8) {
            return;
        }
        if (TextManager.Text[n2].Text == null) return;
        int n9 = TextManager.Text[n2].Text.getWidth();
        Bitmap bitmap = TextManager.Text[n2].Text;
        int[] nArray2 = nArray;
        int n10 = n3;
        int n11 = n4;
        int n12 = n5;
        int n13 = n6;
        int n14 = n7;
        bitmap.setPixels(nArray2, n10, n9, n11, n12, n13, n14);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setTextPixels(int n2, int[] nArray, int n3, int n4, int n5, int n6, int n7, int n8) {
        int n9 = this.nTextLayerMax;
        if (n2 >= n9) {
            return;
        }
        if (TextManager.Text[n2].Text == null) return;
        Bitmap bitmap = TextManager.Text[n2].Text;
        int[] nArray2 = nArray;
        int n10 = n3;
        int n11 = n4;
        int n12 = n5;
        int n13 = n6;
        int n14 = n7;
        int n15 = n8;
        bitmap.setPixels(nArray2, n10, n11, n12, n13, n14, n15);
    }
}

