/*
 * Decompiled with CFR 0.152.
 */
package pxb.android.dex2jar.optimize;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.objectweb.asm.Type;
import pxb.android.dex2jar.optimize.C;
import pxb.android.dex2jar.org.objectweb.asm.tree.AbstractInsnNode;
import pxb.android.dex2jar.org.objectweb.asm.tree.LdcInsnNode;
import pxb.android.dex2jar.org.objectweb.asm.tree.MethodInsnNode;
import pxb.android.dex2jar.org.objectweb.asm.tree.MultiANewArrayInsnNode;
import pxb.android.dex2jar.org.objectweb.asm.tree.analysis.AnalyzerException;
import pxb.android.dex2jar.org.objectweb.asm.tree.analysis.BasicInterpreter;
import pxb.android.dex2jar.org.objectweb.asm.tree.analysis.BasicValue;
import pxb.android.dex2jar.org.objectweb.asm.tree.analysis.Value;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DexInterpreter
extends BasicInterpreter {
    Map<Value, Set<AbstractInsnNode>> m = new HashMap<Value, Set<AbstractInsnNode>>();

    public Map<Value, Set<AbstractInsnNode>> getM() {
        return this.m;
    }

    @Override
    public Value binaryOperation(AbstractInsnNode insn, Value value1, Value value2) throws AnalyzerException {
        return super.binaryOperation(insn, value1, value2);
    }

    @Override
    public Value copyOperation(AbstractInsnNode insn, Value value) throws AnalyzerException {
        if (value instanceof MayObject) {
            this.addTo(value, insn);
            if (insn.getOpcode() == 25) {
                ((MayObject)value).type = Type.INT_TYPE;
                return value;
            }
        } else if (((BasicValue)value).isReference()) {
            C.replace(insn);
        }
        return super.copyOperation(insn, value);
    }

    @Override
    public Value merge(Value v, Value w) {
        if (v instanceof MayObject) {
            return v;
        }
        if (w instanceof MayObject) {
            return w;
        }
        return super.merge(v, w);
    }

    void setv(Type sure, Value may) {
        if (may instanceof MayObject) {
            MayObject mayObject = (MayObject)may;
            mayObject.type = sure.equals((Object)Type.INT_TYPE) ? Type.INT_TYPE : sure;
        }
    }

    @Override
    public Value naryOperation(AbstractInsnNode insn, List values) throws AnalyzerException {
        if (insn.getOpcode() == 197) {
            MultiANewArrayInsnNode mn = (MultiANewArrayInsnNode)insn;
        } else {
            Type[] ts;
            MethodInsnNode m = (MethodInsnNode)insn;
            Iterator it = values.iterator();
            if (m.getOpcode() != 184) {
                it.hasNext();
                this.setv(Type.getType((String)m.owner), (Value)it.next());
            }
            Type[] typeArray = ts = Type.getArgumentTypes((String)m.desc);
            int n = ts.length;
            int n2 = 0;
            while (n2 < n) {
                Type t = typeArray[n2];
                it.hasNext();
                this.setv(t, (Value)it.next());
                ++n2;
            }
        }
        return super.naryOperation(insn, values);
    }

    @Override
    public Value newValue(Type type) {
        return super.newValue(type);
    }

    @Override
    public void returnOperation(AbstractInsnNode insn, Value value, Value expected) throws AnalyzerException {
        super.returnOperation(insn, value, expected);
    }

    @Override
    public Value ternaryOperation(AbstractInsnNode insn, Value value1, Value value2, Value value3) throws AnalyzerException {
        Type type;
        if (value1 instanceof MayObject) {
            type = null;
            switch (insn.getOpcode()) {
                case 79: {
                    type = Type.getType((String)"[I");
                    break;
                }
                case 80: {
                    type = Type.getType((String)"[J");
                    break;
                }
                case 81: {
                    type = Type.getType((String)"[F");
                    break;
                }
                case 82: {
                    type = Type.getType((String)"[D");
                    break;
                }
                case 84: {
                    type = Type.getType((String)"[B");
                    break;
                }
                case 85: {
                    type = Type.getType((String)"[C");
                    break;
                }
                case 86: {
                    type = Type.getType((String)"[S");
                    break;
                }
                case 83: {
                    if (value3 instanceof MayObject) {
                        if (((MayObject)value3).type == null) {
                            type = Type.getType((String)"[Ljava/lang/Object;");
                            break;
                        }
                        type = Type.getType((String)("[" + ((MayObject)value3).type.getDescriptor()));
                        break;
                    }
                    type = Type.getType((String)("[" + ((BasicValue)value3).getType().getDescriptor()));
                }
            }
            ((MayObject)value1).type = type;
        }
        if (value2 instanceof MayObject) {
            ((MayObject)value2).type = Type.INT_TYPE;
        }
        if (value3 instanceof MayObject) {
            type = null;
            switch (insn.getOpcode()) {
                case 79: {
                    type = Type.INT_TYPE;
                    break;
                }
                case 80: {
                    type = Type.LONG_TYPE;
                    break;
                }
                case 81: {
                    type = Type.FLOAT_TYPE;
                    break;
                }
                case 82: {
                    type = Type.DOUBLE_TYPE;
                    break;
                }
                case 84: {
                    type = Type.BYTE_TYPE;
                    break;
                }
                case 85: {
                    type = Type.CHAR_TYPE;
                    break;
                }
                case 86: {
                    type = Type.SHORT_TYPE;
                    break;
                }
                case 83: {
                    if (value1 instanceof MayObject) {
                        if (((MayObject)value1).type == null) {
                            type = Type.getType((String)"Ljava/lang/Object;");
                            break;
                        }
                        type = ((MayObject)value1).type.getElementType();
                        break;
                    }
                    Type t = ((BasicValue)value1).getType();
                    type = t.getDescriptor().startsWith("[") ? t.getElementType() : t;
                }
            }
            ((MayObject)value3).type = type;
        }
        return super.ternaryOperation(insn, value1, value2, value3);
    }

    @Override
    public Value unaryOperation(AbstractInsnNode insn, Value value) throws AnalyzerException {
        if (insn.getOpcode() == 153 || insn.getOpcode() == 154) {
            if (value instanceof MayObject) {
                this.addTo(value, insn);
            } else if (((BasicValue)value).isReference()) {
                C.replace(insn);
            }
        }
        return super.unaryOperation(insn, value);
    }

    void addTo(Value value, AbstractInsnNode insn) {
        Set<AbstractInsnNode> s = this.m.get(value);
        if (s == null) {
            s = new HashSet<AbstractInsnNode>();
            this.m.put(value, s);
        }
        s.add(insn);
    }

    @Override
    public Value newOperation(AbstractInsnNode insn) throws AnalyzerException {
        Object cst;
        if (insn.getOpcode() == 18 && (cst = ((LdcInsnNode)insn).cst) instanceof Integer && (Integer)cst == 0) {
            MayObject v = new MayObject();
            this.addTo(v, insn);
            return v;
        }
        return super.newOperation(insn);
    }

    public class MayObject
    implements Value {
        public Type type;

        public String toString() {
            return this.type == null ? "X" : (this.type.equals((Object)Type.INT_TYPE) ? "Y" : "N");
        }

        public int getSize() {
            return 1;
        }
    }
}

