/*
 * Decompiled with CFR 0.152.
 */
package org.xmlpull.v1.wrapper.classic;

import java.io.IOException;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.util.XmlPullUtil;
import org.xmlpull.v1.wrapper.XmlPullParserWrapper;
import org.xmlpull.v1.wrapper.classic.XmlPullParserDelegate;

public class StaticXmlPullParserWrapper
extends XmlPullParserDelegate
implements XmlPullParserWrapper {
    public StaticXmlPullParserWrapper(XmlPullParser xmlPullParser) {
        super(xmlPullParser);
    }

    @Override
    public String getAttributeValue(String string) {
        return XmlPullUtil.getAttributeValue(this.pp, string);
    }

    @Override
    public String getRequiredAttributeValue(String string) throws IOException, XmlPullParserException {
        return XmlPullUtil.getRequiredAttributeValue(this.pp, null, string);
    }

    @Override
    public String getRequiredAttributeValue(String string, String string2) throws IOException, XmlPullParserException {
        return XmlPullUtil.getRequiredAttributeValue(this.pp, string, string2);
    }

    @Override
    public String getRequiredElementText(String string, String string2) throws IOException, XmlPullParserException {
        if (string2 == null) {
            throw new XmlPullParserException("name for element can not be null");
        }
        String string3 = null;
        this.nextStartTag(string, string2);
        if (this.isNil()) {
            this.nextEndTag(string, string2);
        } else {
            string3 = this.pp.nextText();
        }
        this.pp.require(3, string, string2);
        return string3;
    }

    @Override
    public boolean isNil() throws IOException, XmlPullParserException {
        boolean bl = false;
        String string = this.pp.getAttributeValue("http://www.w3.org/2001/XMLSchema-instance", "nil");
        if ("true".equals(string)) {
            bl = true;
        }
        return bl;
    }

    @Override
    public String getPITarget() throws IllegalStateException {
        return XmlPullUtil.getPITarget(this.pp);
    }

    @Override
    public String getPIData() throws IllegalStateException {
        return XmlPullUtil.getPIData(this.pp);
    }

    @Override
    public boolean matches(int n, String string, String string2) throws XmlPullParserException {
        return XmlPullUtil.matches(this.pp, n, string, string2);
    }

    @Override
    public void nextStartTag() throws XmlPullParserException, IOException {
        if (this.pp.nextTag() != 2) {
            throw new XmlPullParserException("expected START_TAG and not " + this.pp.getPositionDescription());
        }
    }

    @Override
    public void nextStartTag(String string) throws XmlPullParserException, IOException {
        this.pp.nextTag();
        this.pp.require(2, null, string);
    }

    @Override
    public void nextStartTag(String string, String string2) throws XmlPullParserException, IOException {
        this.pp.nextTag();
        this.pp.require(2, string, string2);
    }

    @Override
    public void nextEndTag() throws XmlPullParserException, IOException {
        XmlPullUtil.nextEndTag(this.pp);
    }

    @Override
    public void nextEndTag(String string) throws XmlPullParserException, IOException {
        XmlPullUtil.nextEndTag(this.pp, null, string);
    }

    @Override
    public void nextEndTag(String string, String string2) throws XmlPullParserException, IOException {
        XmlPullUtil.nextEndTag(this.pp, string, string2);
    }

    @Override
    public String nextText(String string, String string2) throws IOException, XmlPullParserException {
        return XmlPullUtil.nextText(this.pp, string, string2);
    }

    @Override
    public void skipSubTree() throws XmlPullParserException, IOException {
        XmlPullUtil.skipSubTree(this.pp);
    }

    public double readDouble() throws XmlPullParserException, IOException {
        double d;
        String string = this.pp.nextText();
        try {
            d = Double.parseDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            if (string.equals("INF") || string.toLowerCase().equals("infinity")) {
                d = Double.POSITIVE_INFINITY;
            }
            if (string.equals("-INF") || string.toLowerCase().equals("-infinity")) {
                d = Double.NEGATIVE_INFINITY;
            }
            if (string.equals("NaN")) {
                d = Double.NaN;
            }
            throw new XmlPullParserException("can't parse double value '" + string + "'", this, numberFormatException);
        }
        return d;
    }

    public float readFloat() throws XmlPullParserException, IOException {
        float f;
        String string = this.pp.nextText();
        try {
            f = Float.parseFloat(string);
        }
        catch (NumberFormatException numberFormatException) {
            if (string.equals("INF") || string.toLowerCase().equals("infinity")) {
                f = Float.POSITIVE_INFINITY;
            }
            if (string.equals("-INF") || string.toLowerCase().equals("-infinity")) {
                f = Float.NEGATIVE_INFINITY;
            }
            if (string.equals("NaN")) {
                f = Float.NaN;
            }
            throw new XmlPullParserException("can't parse float value '" + string + "'", this, numberFormatException);
        }
        return f;
    }

    private int parseDigits(String string, int n, int n2) throws XmlPullParserException {
        int n3 = 0;
        if (n2 > 9) {
            try {
                n3 = Integer.parseInt(string.substring(n, n + n2));
            }
            catch (NumberFormatException numberFormatException) {
                throw new XmlPullParserException(numberFormatException.getMessage());
            }
        } else {
            int n4 = n + n2;
            while (n < n4) {
                char c;
                if ((c = string.charAt(n++)) >= '0' && c <= '9') {
                    n3 = n3 * 10 + (c - 48);
                    continue;
                }
                throw new XmlPullParserException("non-digit in number value", this, null);
            }
        }
        return n3;
    }

    private int parseInt(String string) throws XmlPullParserException {
        int n = 0;
        int n2 = string.length();
        if (n2 == 0) {
            throw new XmlPullParserException("empty number value", this, null);
        }
        boolean bl = false;
        char c = string.charAt(0);
        if (c == '-') {
            if (n2 > 9) {
                try {
                    return Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new XmlPullParserException(numberFormatException.getMessage(), this, null);
                }
            }
            bl = true;
            ++n;
        } else if (c == '+') {
            ++n;
        }
        if (n >= n2) {
            throw new XmlPullParserException("Invalid number format", this, null);
        }
        int n3 = this.parseDigits(string, n, n2 - n);
        if (bl) {
            return -n3;
        }
        return n3;
    }

    public int readInt() throws XmlPullParserException, IOException {
        try {
            int n = this.parseInt(this.pp.nextText());
            return n;
        }
        catch (NumberFormatException numberFormatException) {
            throw new XmlPullParserException("can't parse int value", this, numberFormatException);
        }
    }

    public String readString() throws XmlPullParserException, IOException {
        String string = this.pp.getAttributeValue("http://www.w3.org/2001/XMLSchema", "nil");
        if ("true".equals(string)) {
            this.nextEndTag();
            return null;
        }
        return this.pp.nextText();
    }

    public double readDoubleElement(String string, String string2) throws XmlPullParserException, IOException {
        this.pp.require(2, string, string2);
        return this.readDouble();
    }

    public float readFloatElement(String string, String string2) throws XmlPullParserException, IOException {
        this.pp.require(2, string, string2);
        return this.readFloat();
    }

    public int readIntElement(String string, String string2) throws XmlPullParserException, IOException {
        this.pp.require(2, string, string2);
        return this.readInt();
    }

    public String readStringElemet(String string, String string2) throws XmlPullParserException, IOException {
        this.pp.require(2, string, string2);
        return this.readString();
    }
}

