/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib.Util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public final class FileUtils {
    private FileUtils() {
    }

    public static byte[] readFile(String string) throws IOException {
        File file = new File(string);
        return FileUtils.readFile(file);
    }

    public static byte[] readFile(File file) throws IOException {
        return FileUtils.readFile(file, 0, -1);
    }

    public static byte[] readFile(File file, int n, int n2) throws IOException {
        if (!file.exists()) {
            throw new RuntimeException(file + ": file not found");
        }
        if (!file.isFile()) {
            throw new RuntimeException(file + ": not a file");
        }
        if (!file.canRead()) {
            throw new RuntimeException(file + ": file not readable");
        }
        long l = file.length();
        int n3 = (int)l;
        if ((long)n3 != l) {
            throw new RuntimeException(file + ": file too long");
        }
        if (n2 == -1) {
            n2 = n3 - n;
        }
        if (n + n2 > n3) {
            throw new RuntimeException(file + ": file too short");
        }
        FileInputStream fileInputStream = new FileInputStream(file);
        int n4 = n;
        while (n4 > 0) {
            long l2 = fileInputStream.skip(n4);
            if (l2 == -1L) {
                throw new RuntimeException(file + ": unexpected EOF");
            }
            n4 = (int)((long)n4 - l2);
        }
        byte[] byArray = FileUtils.readStream(fileInputStream, n2);
        fileInputStream.close();
        return byArray;
    }

    public static byte[] readStream(InputStream inputStream, int n) throws IOException {
        byte[] byArray = new byte[n];
        int n2 = 0;
        while (n > 0) {
            int n3 = inputStream.read(byArray, n2, n);
            if (n3 == -1) {
                throw new RuntimeException("unexpected EOF");
            }
            n2 += n3;
            n -= n3;
        }
        return byArray;
    }
}

