/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib.Util;

import java.util.ArrayList;
import java.util.List;
import org.jf.dexlib.DebugInfoItem;
import org.jf.dexlib.DexFile;
import org.jf.dexlib.Item;
import org.jf.dexlib.StringIdItem;
import org.jf.dexlib.TypeIdItem;
import org.jf.dexlib.Util.ByteArrayOutput;
import org.jf.dexlib.Util.Output;

public class DebugInfoBuilder {
    private static final int LINE_BASE = -4;
    private static final int LINE_RANGE = 15;
    private static final int FIRST_SPECIAL = 10;
    private int lineStart = 0;
    private ArrayList<String> parameterNames = new ArrayList();
    private ArrayList<Event> events = new ArrayList();
    private int lastAddress = 0;
    private boolean hasData;
    private int currentAddress;
    private int currentLine;

    private void checkAddress(int n) {
        if (this.lastAddress > n) {
            throw new RuntimeException("Cannot add an event with an address before the address of the prior event");
        }
    }

    public void addParameterName(String string) {
        if (string != null) {
            this.hasData = true;
        }
        this.parameterNames.add(string);
    }

    public void addLine(int n, int n2) {
        this.hasData = true;
        this.checkAddress(n);
        if (this.lineStart == 0) {
            this.lineStart = n2;
        }
        this.events.add(new LineEvent(n, n2));
    }

    public void addLocal(int n, int n2, String string, String string2) {
        this.hasData = true;
        this.checkAddress(n);
        this.events.add(new StartLocalEvent(n, n2, string, string2));
    }

    public void addLocalExtended(int n, int n2, String string, String string2, String string3) {
        this.hasData = true;
        this.checkAddress(n);
        this.events.add(new StartLocalExtendedEvent(n, n2, string, string2, string3));
    }

    public void addEndLocal(int n, int n2) {
        this.hasData = true;
        this.checkAddress(n);
        this.events.add(new EndLocalEvent(n, n2));
    }

    public void addRestartLocal(int n, int n2) {
        this.hasData = true;
        this.checkAddress(n);
        this.events.add(new RestartLocalEvent(n, n2));
    }

    public void addPrologue(int n) {
        this.hasData = true;
        this.checkAddress(n);
        this.events.add(new PrologueEvent(n));
    }

    public void addEpilogue(int n) {
        this.hasData = true;
        this.checkAddress(n);
        this.events.add(new EpilogueEvent(n));
    }

    public void addSetFile(int n, String string) {
        this.hasData = true;
        this.checkAddress(n);
        this.events.add(new SetFileEvent(n, string));
    }

    public int getParameterNameCount() {
        return this.parameterNames.size();
    }

    public DebugInfoItem encodeDebugInfo(DexFile dexFile) {
        if (!this.hasData) {
            return null;
        }
        ByteArrayOutput byteArrayOutput = new ByteArrayOutput();
        StringIdItem[] stringIdItemArray = new StringIdItem[this.parameterNames.size()];
        ArrayList<Item> arrayList = new ArrayList<Item>();
        if (this.lineStart == 0) {
            this.lineStart = 1;
        }
        this.currentLine = this.lineStart;
        for (Event itemArray2 : this.events) {
            itemArray2.emit(dexFile, byteArrayOutput, arrayList);
        }
        this.emitEndSequence(byteArrayOutput);
        int n = 0;
        for (String string : this.parameterNames) {
            if (string == null) {
                stringIdItemArray[n++] = null;
                continue;
            }
            stringIdItemArray[n++] = StringIdItem.internStringIdItem(dexFile, string);
        }
        Item[] itemArray = new Item[arrayList.size()];
        arrayList.toArray(itemArray);
        return DebugInfoItem.internDebugInfoItem(dexFile, this.lineStart, stringIdItemArray, byteArrayOutput.toByteArray(), itemArray);
    }

    public static byte calculateSpecialOpcode(int n, int n2) {
        return (byte)(10 + n2 * 15 + (n - -4));
    }

    private void emitEndSequence(Output output) {
        output.writeByte(0);
    }

    private void emitAdvancePC(Output output, int n) {
        int n2 = n - this.currentAddress;
        if (n2 > 0) {
            output.writeByte(1);
            output.writeUnsignedLeb128(n2);
            this.currentAddress = n;
        }
    }

    private void emitAdvanceLine(Output output, int n) {
        output.writeByte(2);
        output.writeSignedLeb128(n);
    }

    private void emitStartLocal(Output output, int n) {
        output.writeByte(3);
        output.writeUnsignedLeb128(n);
        output.writeByte(1);
        output.writeByte(1);
    }

    private void emitStartLocalExtended(Output output, int n) {
        output.writeByte(4);
        output.writeUnsignedLeb128(n);
        output.writeByte(1);
        output.writeByte(1);
        output.writeByte(1);
    }

    private void emitEndLocal(Output output, int n) {
        output.writeByte(5);
        output.writeUnsignedLeb128(n);
    }

    private void emitRestartLocal(Output output, int n) {
        output.writeByte(6);
        output.writeUnsignedLeb128(n);
    }

    private void emitSetPrologueEnd(Output output) {
        output.writeByte(7);
    }

    private void emitSetEpilogueBegin(Output output) {
        output.writeByte(8);
    }

    private void emitSetFile(Output output) {
        output.writeByte(9);
        output.writeByte(1);
    }

    private void emitSpecialOpcode(Output output, byte by) {
        output.writeByte(by);
    }

    private class SetFileEvent
    implements Event {
        private final int address;
        private final String fileName;

        public SetFileEvent(int n, String string) {
            this.address = n;
            this.fileName = string;
        }

        @Override
        public int getAddress() {
            return this.address;
        }

        @Override
        public void emit(DexFile dexFile, Output output, List<Item> list) {
            DebugInfoBuilder.this.emitAdvancePC(output, this.address);
            DebugInfoBuilder.this.emitSetFile(output);
            if (this.fileName != null) {
                list.add(StringIdItem.internStringIdItem(dexFile, this.fileName));
            }
        }
    }

    private class EpilogueEvent
    implements Event {
        private final int address;

        public EpilogueEvent(int n) {
            this.address = n;
        }

        @Override
        public int getAddress() {
            return this.address;
        }

        @Override
        public void emit(DexFile dexFile, Output output, List<Item> list) {
            DebugInfoBuilder.this.emitAdvancePC(output, this.address);
            DebugInfoBuilder.this.emitSetEpilogueBegin(output);
        }
    }

    private class PrologueEvent
    implements Event {
        private final int address;

        public PrologueEvent(int n) {
            this.address = n;
        }

        @Override
        public int getAddress() {
            return this.address;
        }

        @Override
        public void emit(DexFile dexFile, Output output, List<Item> list) {
            DebugInfoBuilder.this.emitAdvancePC(output, this.address);
            DebugInfoBuilder.this.emitSetPrologueEnd(output);
        }
    }

    private class RestartLocalEvent
    implements Event {
        private final int address;
        private final int registerNum;

        public RestartLocalEvent(int n, int n2) {
            this.address = n;
            this.registerNum = n2;
        }

        @Override
        public int getAddress() {
            return this.address;
        }

        @Override
        public void emit(DexFile dexFile, Output output, List<Item> list) {
            DebugInfoBuilder.this.emitAdvancePC(output, this.address);
            DebugInfoBuilder.this.emitRestartLocal(output, this.registerNum);
        }
    }

    private class EndLocalEvent
    implements Event {
        private final int address;
        private final int registerNum;

        public EndLocalEvent(int n, int n2) {
            this.address = n;
            this.registerNum = n2;
        }

        @Override
        public int getAddress() {
            return this.address;
        }

        @Override
        public void emit(DexFile dexFile, Output output, List<Item> list) {
            DebugInfoBuilder.this.emitAdvancePC(output, this.address);
            DebugInfoBuilder.this.emitEndLocal(output, this.registerNum);
        }
    }

    private class StartLocalExtendedEvent
    implements Event {
        private final int address;
        private final int registerNum;
        private final String localName;
        private final String localType;
        private final String signature;

        public StartLocalExtendedEvent(int n, int n2, String string, String string2, String string3) {
            this.address = n;
            this.registerNum = n2;
            this.localName = string;
            this.localType = string2;
            this.signature = string3;
        }

        @Override
        public int getAddress() {
            return this.address;
        }

        @Override
        public void emit(DexFile dexFile, Output output, List<Item> list) {
            DebugInfoBuilder.this.emitAdvancePC(output, this.address);
            DebugInfoBuilder.this.emitStartLocalExtended(output, this.registerNum);
            if (this.localName != null) {
                list.add(StringIdItem.internStringIdItem(dexFile, this.localName));
            }
            if (this.localType != null) {
                list.add(TypeIdItem.internTypeIdItem(dexFile, StringIdItem.internStringIdItem(dexFile, this.localType)));
            }
            if (this.signature != null) {
                list.add(StringIdItem.internStringIdItem(dexFile, this.signature));
            }
        }
    }

    private class StartLocalEvent
    implements Event {
        private final int address;
        private final int registerNum;
        private final String localName;
        private final String localType;

        public StartLocalEvent(int n, int n2, String string, String string2) {
            this.address = n;
            this.registerNum = n2;
            this.localName = string;
            this.localType = string2;
        }

        @Override
        public int getAddress() {
            return this.address;
        }

        @Override
        public void emit(DexFile dexFile, Output output, List<Item> list) {
            DebugInfoBuilder.this.emitAdvancePC(output, this.address);
            DebugInfoBuilder.this.emitStartLocal(output, this.registerNum);
            list.add(this.localName == null ? null : StringIdItem.internStringIdItem(dexFile, this.localName));
            list.add(this.localType == null ? null : TypeIdItem.internTypeIdItem(dexFile, StringIdItem.internStringIdItem(dexFile, this.localType)));
        }
    }

    private class LineEvent
    implements Event {
        private final int address;
        private final int line;

        public LineEvent(int n, int n2) {
            this.address = n;
            this.line = n2;
        }

        @Override
        public int getAddress() {
            return this.address;
        }

        @Override
        public void emit(DexFile dexFile, Output output, List<Item> list) {
            int n = this.line - DebugInfoBuilder.this.currentLine;
            int n2 = this.address - DebugInfoBuilder.this.currentAddress;
            if (n < -4 || n > 10) {
                DebugInfoBuilder.this.emitAdvanceLine(output, n);
                n = 0;
            }
            if (n < 2 && n2 > 16 || n > 1 && n2 > 15) {
                DebugInfoBuilder.this.emitAdvancePC(output, this.address);
                n2 = 0;
            }
            DebugInfoBuilder.this.emitSpecialOpcode(output, DebugInfoBuilder.calculateSpecialOpcode(n, n2));
            DebugInfoBuilder.this.currentAddress = this.address;
            DebugInfoBuilder.this.currentLine = this.line;
        }
    }

    private static interface Event {
        public int getAddress();

        public void emit(DexFile var1, Output var2, List<Item> var3);
    }
}

