/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.jf.dexlib.DexFile;
import org.jf.dexlib.Item;
import org.jf.dexlib.ItemType;
import org.jf.dexlib.ReadContext;
import org.jf.dexlib.Util.AlignmentUtils;
import org.jf.dexlib.Util.AnnotatedOutput;
import org.jf.dexlib.Util.Input;

public abstract class Section<T extends Item> {
    protected final ArrayList<T> items;
    protected HashMap<T, T> uniqueItems = null;
    protected int offset = 0;
    public final ItemType ItemType;
    public final DexFile DexFile;

    protected Section(DexFile dexFile, ItemType itemType) {
        this.DexFile = dexFile;
        this.items = new ArrayList();
        this.ItemType = itemType;
    }

    protected int placeAt(int n) {
        if (this.items.size() > 0) {
            n = AlignmentUtils.alignOffset(n, this.ItemType.ItemAlignment);
            assert (!this.DexFile.getInplace() || n == this.offset);
            this.offset = n;
            for (int i = 0; i < this.items.size(); ++i) {
                Item item = (Item)this.items.get(i);
                assert (item != null);
                n = AlignmentUtils.alignOffset(n, this.ItemType.ItemAlignment);
                n = item.placeAt(n, i);
            }
        } else {
            this.offset = 0;
        }
        return n;
    }

    protected void writeTo(AnnotatedOutput annotatedOutput) {
        annotatedOutput.annotate(0, " ");
        annotatedOutput.annotate(0, "-----------------------------");
        annotatedOutput.annotate(0, this.ItemType.TypeName + " section");
        annotatedOutput.annotate(0, "-----------------------------");
        annotatedOutput.annotate(0, " ");
        for (Item item : this.items) {
            assert (item != null);
            annotatedOutput.alignTo(this.ItemType.ItemAlignment);
            item.writeTo(annotatedOutput);
            annotatedOutput.annotate(0, " ");
        }
    }

    protected void readFrom(int n, Input input, ReadContext readContext) {
        this.items.ensureCapacity(n);
        for (int i = this.items.size(); i < n; ++i) {
            this.items.add(null);
        }
        input.alignTo(this.ItemType.ItemAlignment);
        this.offset = input.getCursor();
        this.readItems(input, readContext);
    }

    protected abstract void readItems(Input var1, ReadContext var2);

    public int getOffset() {
        return this.offset;
    }

    public List<T> getItems() {
        return Collections.unmodifiableList(this.items);
    }

    protected T intern(T t) {
        if (t == null) {
            return null;
        }
        T t2 = this.getInternedItem(t);
        if (t2 == null) {
            this.uniqueItems.put(t, t);
            this.items.add(t);
            return t;
        }
        return t2;
    }

    protected T getInternedItem(T t) {
        if (this.uniqueItems == null) {
            this.buildInternedItemMap();
        }
        return (T)((Item)this.uniqueItems.get(t));
    }

    private void buildInternedItemMap() {
        this.uniqueItems = new HashMap();
        for (Item item : this.items) {
            assert (item != null);
            this.uniqueItems.put(item, item);
        }
    }

    protected void sortSection() {
        Collections.sort(this.items);
    }
}

